/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.text.NumberFormat;
import java.util.UUID;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.regex.Pattern;
import kafka.log.AbortedTxn;
import kafka.log.AbortedTxn$;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Log$ {
    public static Log$ MODULE$;
    private final String LogFileSuffix;
    private final String IndexFileSuffix;
    private final String TimeIndexFileSuffix;
    private final String ProducerSnapshotFileSuffix;
    private final String TxnIndexFileSuffix;
    private final String DeletedFileSuffix;
    private final String CleanedFileSuffix;
    private final String SwapFileSuffix;
    private final String CleanShutdownFile;
    private final String DeleteDirSuffix;
    private final String FutureDirSuffix;
    private final String TierStateSuffix;
    private final Pattern DeleteDirPattern;
    private final Pattern FutureDirPattern;
    private final long UnknownOffset;

    static {
        new Log$();
    }

    public long $lessinit$greater$default$12() {
        return 0L;
    }

    public Function0<Object> $lessinit$greater$default$13() {
        return (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L;
    }

    public String LogFileSuffix() {
        return this.LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return this.IndexFileSuffix;
    }

    public String TimeIndexFileSuffix() {
        return this.TimeIndexFileSuffix;
    }

    public String ProducerSnapshotFileSuffix() {
        return this.ProducerSnapshotFileSuffix;
    }

    public String TxnIndexFileSuffix() {
        return this.TxnIndexFileSuffix;
    }

    public String DeletedFileSuffix() {
        return this.DeletedFileSuffix;
    }

    public String CleanedFileSuffix() {
        return this.CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return this.SwapFileSuffix;
    }

    public String CleanShutdownFile() {
        return this.CleanShutdownFile;
    }

    public String DeleteDirSuffix() {
        return this.DeleteDirSuffix;
    }

    public String FutureDirSuffix() {
        return this.FutureDirSuffix;
    }

    public String TierStateSuffix() {
        return this.TierStateSuffix;
    }

    public Pattern DeleteDirPattern() {
        return this.DeleteDirPattern;
    }

    public Pattern FutureDirPattern() {
        return this.FutureDirPattern;
    }

    public long UnknownOffset() {
        return this.UnknownOffset;
    }

    public MergedLog apply(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, LogDirFailureChannel logDirFailureChannel, Option<TierLogComponents> tierLogComponentsOpt) {
        if (tierLogComponentsOpt == null) {
            throw null;
        }
        Object object = tierLogComponentsOpt.isEmpty() ? TierLogComponents$.MODULE$.EMPTY() : tierLogComponentsOpt.get();
        TierLogComponents tierLogComponents = (TierLogComponents)object;
        return MergedLog$.MODULE$.apply(dir, config, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, time, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, logDirFailureChannel, tierLogComponents);
    }

    public Time apply$default$7() {
        return Time.SYSTEM;
    }

    public Option<TierLogComponents> apply$default$11() {
        return None$.MODULE$;
    }

    public String filenamePrefixFromOffset(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset);
    }

    public File logFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.LogFileSuffix()).append(suffix).toString());
    }

    public String logFile$default$3() {
        return "";
    }

    public String logDeleteDirName(TopicPartition topicPartition) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        String suffix = new StringBuilder(2).append("-").append(topicPartition.partition()).append(".").append(uniqueId).append(this.DeleteDirSuffix()).toString();
        String string = topicPartition.topic();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int prefixLength = Math.min(new StringOps(string).size(), 255 - new StringOps(suffix).size());
        return new StringBuilder(0).append(topicPartition.topic().substring(0, prefixLength)).append(suffix).toString();
    }

    public String logFutureDirName(TopicPartition topicPartition) {
        return this.logDirNameWithSuffix(topicPartition, this.FutureDirSuffix());
    }

    private String logDirNameWithSuffix(TopicPartition topicPartition, String suffix) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        return new StringBuilder(1).append(this.logDirName(topicPartition)).append(".").append(uniqueId).append(suffix).toString();
    }

    public String logDirName(TopicPartition topicPartition) {
        return new StringBuilder(1).append(topicPartition.topic()).append("-").append(topicPartition.partition()).toString();
    }

    public File offsetIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.IndexFileSuffix()).append(suffix).toString());
    }

    public String offsetIndexFile$default$3() {
        return "";
    }

    public File timeIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.TimeIndexFileSuffix()).append(suffix).toString());
    }

    public String timeIndexFile$default$3() {
        return "";
    }

    public void deleteFileIfExists(File file, String suffix) {
        Files.deleteIfExists(new File(new StringBuilder(0).append(file.getPath()).append(suffix).toString()).toPath());
    }

    public String deleteFileIfExists$default$2() {
        return "";
    }

    public File producerSnapshotFile(File dir, long offset) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.ProducerSnapshotFileSuffix()).toString());
    }

    public File transactionIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.TxnIndexFileSuffix()).append(suffix).toString());
    }

    public String transactionIndexFile$default$3() {
        return "";
    }

    public File tierStateFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.TierStateSuffix()).append(suffix).toString());
    }

    public String tierStateFile$default$3() {
        return "";
    }

    public long offsetFromFileName(String filename) {
        String string = filename.substring(0, filename.indexOf(46));
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).toLong();
    }

    public long offsetFromFile(File file) {
        return this.offsetFromFileName(file.getName());
    }

    public long sizeInBytes(Iterable<LogSegment> segments) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)segments.map((Function1 & Serializable & scala.Serializable)x$58 -> BoxesRunTime.boxToLong((long)x$58.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public TopicPartition parseTopicPartitionName(File dir) {
        int n;
        String dirName;
        block11: {
            block10: {
                if (dir == null) {
                    throw new KafkaException("dir should not be null");
                }
                dirName = dir.getName();
                if (dirName == null || dirName.isEmpty()) break block10;
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                if (new StringOps(dirName).contains((Object)BoxesRunTime.boxToCharacter((char)'-'))) break block11;
            }
            throw Log$.exception$1(dir);
        }
        if (dirName.endsWith(this.DeleteDirSuffix()) && !this.DeleteDirPattern().matcher(dirName).matches() || dirName.endsWith(this.FutureDirSuffix()) && !this.FutureDirPattern().matcher(dirName).matches()) {
            throw Log$.exception$1(dir);
        }
        String name = dirName.endsWith(this.DeleteDirSuffix()) || dirName.endsWith(this.FutureDirSuffix()) ? dirName.substring(0, dirName.lastIndexOf(46)) : dirName;
        int index = name.lastIndexOf(45);
        String topic = name.substring(0, index);
        String partitionString = name.substring(index + 1);
        if (topic.isEmpty() || partitionString.isEmpty()) {
            throw Log$.exception$1(dir);
        }
        try {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            n = new StringOps(partitionString).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw Log$.exception$1(dir);
        }
        int partition = n;
        return new TopicPartition(topic, partition);
    }

    public boolean kafka$log$Log$$isIndexFile(File file) {
        String filename = file.getName();
        return filename.endsWith(this.IndexFileSuffix()) || filename.endsWith(this.TimeIndexFileSuffix()) || filename.endsWith(this.TxnIndexFileSuffix());
    }

    public boolean kafka$log$Log$$isLogFile(File file) {
        return file.getPath().endsWith(this.LogFileSuffix());
    }

    public boolean isTierStateFile(File file) {
        return file.getPath().endsWith(this.TierStateSuffix());
    }

    /*
     * WARNING - void declaration
     */
    public <A> ConcurrentNavigableMap<Long, A> logSegments(ConcurrentNavigableMap<Long, A> segments, long from, long to, Object lock) {
        synchronized (lock) {
            void var7_9;
            None$ none$;
            Option option = Option$.MODULE$.apply((Object)segments.floorKey(Predef$.MODULE$.long2Long(from)));
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            if (map_this.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                Long l = (Long)map_this.get();
                none$ = new Some((Object)segments.subMap(l, Predef$.MODULE$.long2Long(to)));
            }
            if (none$ == null) {
                throw null;
            }
            Object object = none$.isEmpty() ? segments.headMap(Predef$.MODULE$.long2Long(to)) : none$.get();
            ConcurrentNavigableMap view = (ConcurrentNavigableMap)object;
            return var7_9;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Option<ByteBuffer> serializeAbortedTransactions(Seq<AbortedTxn> abortedTxnsList) {
        void var2_2;
        None$ maybeAbortedTxnsBuf = None$.MODULE$;
        if (abortedTxnsList.nonEmpty()) {
            ByteBuffer buf = ByteBuffer.allocate(abortedTxnsList.length() * AbortedTxn$.MODULE$.TotalSize());
            abortedTxnsList.foreach((Function1 & Serializable & scala.Serializable)abortedTxn -> buf.put(abortedTxn.buffer().duplicate()));
            buf.flip();
            maybeAbortedTxnsBuf = new Some((Object)buf);
        }
        return var2_2;
    }

    private static final KafkaException exception$1(File dir) {
        return new KafkaException(new StringBuilder(196).append("Found directory ").append(dir.getCanonicalPath()).append(", '").append(dir.getName()).append("' is not in the form of ").append("topic-partition or topic-partition.uniqueId-delete (if marked for deletion).\n").append("Kafka's log directories (and children) should only contain Kafka topic data.").toString());
    }

    private Log$() {
        MODULE$ = this;
        this.LogFileSuffix = ".log";
        this.IndexFileSuffix = ".index";
        this.TimeIndexFileSuffix = ".timeindex";
        this.ProducerSnapshotFileSuffix = ".snapshot";
        this.TxnIndexFileSuffix = ".txnindex";
        this.DeletedFileSuffix = ".deleted";
        this.CleanedFileSuffix = ".cleaned";
        this.SwapFileSuffix = ".swap";
        this.CleanShutdownFile = ".kafka_cleanshutdown";
        this.DeleteDirSuffix = "-delete";
        this.FutureDirSuffix = "-future";
        this.TierStateSuffix = ".tierstate";
        this.DeleteDirPattern = Pattern.compile(new StringBuilder(19).append("^(\\S+)-(\\S+)\\.(\\S+)").append(this.DeleteDirSuffix()).toString());
        this.FutureDirPattern = Pattern.compile(new StringBuilder(19).append("^(\\S+)-(\\S+)\\.(\\S+)").append(this.FutureDirSuffix()).toString());
        this.UnknownOffset = -1L;
    }
}

