/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.AbstractLog;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.LastRecord;
import kafka.log.LogCleaner;
import kafka.log.LogCleaner$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.log.TransactionIndex;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\t}d!\u0002\u0012$\u0001\r:\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\t\u0011i\u0002!\u0011!Q\u0001\n]B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005{!A!\t\u0001B\u0001B\u0003%q\u0007\u0003\u0005D\u0001\t\u0005\t\u0015!\u00038\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\u0006I\u0002!\t!\u001a\u0005\u0006_\u0002!\t\u0006\u001d\u0005\bs\u0002\u0001\r\u0011\"\u0003{\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)\u0001C\u0004\u0002\f\u0001\u0001\u000b\u0015B>\t\u0011\u00055\u0001\u00011A\u0005\niD\u0011\"a\u0004\u0001\u0001\u0004%I!!\u0005\t\u000f\u0005U\u0001\u0001)Q\u0005w\"I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011\u0004\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u001c!A\u0011\u0011\u0006\u0001\u0005\u0002\r\nY\u0003\u0003\u0005\u0002J\u0001!\taIA&\u0011!\t\u0019\u0006\u0001C\u0001G\u0005U\u0003\u0002CAE\u0001\u0011\u00051%a#\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBA\u007f\u0001\u0011%\u0011q \u0005\b\u0005'\u0001A\u0011\u0001B\u000b\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057A\u0001B!\b\u0001\t\u0003\u0019#q\u0004\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0011!\u0011\u0019\u0006\u0001C\u0001G\tU\u0003b\u0002B3\u0001\u0011%!q\r\u0002\b\u00072,\u0017M\\3s\u0015\t!S%A\u0002m_\u001eT\u0011AJ\u0001\u0006W\u000647.Y\n\u0004\u0001!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020e5\t\u0001G\u0003\u00022K\u0005)Q\u000f^5mg&\u00111\u0007\r\u0002\b\u0019><w-\u001b8h\u0003\tIGm\u0001\u0001\u0016\u0003]\u0002\"!\u000b\u001d\n\u0005eR#aA%oi\u0006\u0019\u0011\u000e\u001a\u0011\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u001f\u0011\u0005yzT\"A\u0012\n\u0005\u0001\u001b#!C(gMN,G/T1q\u0003)ygMZ:fi6\u000b\u0007\u000fI\u0001\rS>\u0014UO\u001a4feNK'0Z\u0001\u0010[\u0006D\u0018j\u001c\"vM\u001a,'oU5{K\u0006\u0019B-\u001e9Ck\u001a4WM\u001d'pC\u00124\u0015m\u0019;peB\u0011\u0011FR\u0005\u0003\u000f*\u0012a\u0001R8vE2,\u0017!\u0003;ie>$H\u000f\\3s!\ty#*\u0003\u0002La\tIA\u000b\u001b:piRdWM]\u0001\u0005i&lW\r\u0005\u0002O/6\tqJ\u0003\u00022!*\u0011\u0011KU\u0001\u0007G>lWn\u001c8\u000b\u0005\u0019\u001a&B\u0001+V\u0003\u0019\t\u0007/Y2iK*\ta+A\u0002pe\u001eL!\u0001W(\u0003\tQKW.Z\u0001\nG\",7m\u001b#p]\u0016\u0004B!K.^C&\u0011AL\u000b\u0002\n\rVt7\r^5p]F\u0002\"AX0\u000e\u0003AK!\u0001\u0019)\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0011FY\u0005\u0003G*\u0012A!\u00168ji\u00061A(\u001b8jiz\"\u0012BZ4iS*\\G.\u001c8\u0011\u0005y\u0002\u0001\"\u0002\u001b\f\u0001\u00049\u0004\"B\u001e\f\u0001\u0004i\u0004\"\u0002\"\f\u0001\u00049\u0004\"B\"\f\u0001\u00049\u0004\"\u0002#\f\u0001\u0004)\u0005\"\u0002%\f\u0001\u0004I\u0005\"\u0002'\f\u0001\u0004i\u0005\"B-\f\u0001\u0004Q\u0016A\u00037pO\u001e,'OT1nKV\t\u0011\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u0006!A.\u00198h\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_:\u0003\rM#(/\u001b8h\u0003)\u0011X-\u00193Ck\u001a4WM]\u000b\u0002wB\u0011Ap`\u0007\u0002{*\u0011a0^\u0001\u0004]&|\u0017bAA\u0001{\nQ!)\u001f;f\u0005V4g-\u001a:\u0002\u001dI,\u0017\r\u001a\"vM\u001a,'o\u0018\u0013fcR\u0019\u0011-a\u0002\t\u0011\u0005%a\"!AA\u0002m\f1\u0001\u001f\u00132\u0003-\u0011X-\u00193Ck\u001a4WM\u001d\u0011\u0002\u0017]\u0014\u0018\u000e^3Ck\u001a4WM]\u0001\u0010oJLG/\u001a\"vM\u001a,'o\u0018\u0013fcR\u0019\u0011-a\u0005\t\u0011\u0005%\u0011#!AA\u0002m\fAb\u001e:ji\u0016\u0014UO\u001a4fe\u0002\n1\u0004Z3d_6\u0004(/Z:tS>t')\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014XCAA\u000e!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011!\u00061!/Z2pe\u0012LA!!\n\u0002 \tq!)\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\u0018\u0001\b3fG>l\u0007O]3tg&|gNQ;gM\u0016\u00148+\u001e9qY&,'\u000fI\u0001\u0006G2,\u0017M\u001c\u000b\u0005\u0003[\ty\u0004E\u0004*\u0003_\t\u0019$!\u000f\n\u0007\u0005E\"F\u0001\u0004UkBdWM\r\t\u0004S\u0005U\u0012bAA\u001cU\t!Aj\u001c8h!\rq\u00141H\u0005\u0004\u0003{\u0019#\u0001D\"mK\u0006tWM]*uCR\u001c\bbBA!+\u0001\u0007\u00111I\u0001\nG2,\u0017M\\1cY\u0016\u00042APA#\u0013\r\t9e\t\u0002\u000b\u0019><Gk\\\"mK\u0006t\u0017a\u00023p\u00072,\u0017M\u001c\u000b\u0007\u0003[\ti%a\u0014\t\u000f\u0005\u0005c\u00031\u0001\u0002D!9\u0011\u0011\u000b\fA\u0002\u0005M\u0012a\u00043fY\u0016$X\rS8sSj|g.T:\u0002\u001b\rdW-\u00198TK\u001elWM\u001c;t)5\t\u0017qKA0\u0003k\nI(a\u001f\u0002\u0000!1Ae\u0006a\u0001\u00033\u00022APA.\u0013\r\tif\t\u0002\f\u0003\n\u001cHO]1di2{w\rC\u0004\u0002b]\u0001\r!a\u0019\u0002\u0011M,w-\\3oiN\u0004b!!\u001a\u0002l\u0005=TBAA4\u0015\r\tIGK\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA7\u0003O\u00121aU3r!\rq\u0014\u0011O\u0005\u0004\u0003g\u001a#A\u0003'pON+w-\\3oi\"1\u0011qO\fA\u0002u\n1!\\1q\u0011\u001d\t\tf\u0006a\u0001\u0003gAq!! \u0018\u0001\u0004\tI$A\u0003ti\u0006$8\u000fC\u0004\u0002\u0002^\u0001\r!a!\u0002'Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0011\u0007y\n))C\u0002\u0002\b\u000e\u0012!d\u00117fC:,G\r\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006\f\u0011b\u00197fC:Le\u000e^8\u0015'\u0005\fi)!%\u0002\u001c\u0006}\u0015\u0011UAV\u0003_\u000b\t,!5\t\r\u0005=\u0005\u00041\u0001^\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a%\u0019\u0001\u0004\t)*A\u0007t_V\u00148-\u001a*fG>\u0014Hm\u001d\t\u0005\u0003;\t9*\u0003\u0003\u0002\u001a\u0006}!a\u0003$jY\u0016\u0014VmY8sINDq!!(\u0019\u0001\u0004\ty'\u0001\u0003eKN$\bBBA<1\u0001\u0007Q\bC\u0004\u0002$b\u0001\r!!*\u00025I,G/Y5o\t\u0016dW\r^3t\u0003:$G\u000b\u001f8NCJ\\WM]:\u0011\u0007%\n9+C\u0002\u0002**\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002.b\u0001\raN\u0001\u0012[\u0006DHj\\4NKN\u001c\u0018mZ3TSj,\u0007bBAA1\u0001\u0007\u00111\u0011\u0005\b\u0003gC\u0002\u0019AA[\u0003qa\u0017m\u001d;SK\u000e|'\u000fZ:PM\u0006\u001bG/\u001b<f!J|G-^2feN\u0004\u0002\"a.\u0002F\u0006M\u00121\u001a\b\u0005\u0003s\u000b\t\rE\u0002\u0002<*j!!!0\u000b\u0007\u0005}V'\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0007T\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002H\u0006%'aA'ba*\u0019\u00111\u0019\u0016\u0011\u0007y\ni-C\u0002\u0002P\u000e\u0012!\u0002T1tiJ+7m\u001c:e\u0011\u001d\ti\b\u0007a\u0001\u0003s\t\u0011c\u001a:po\n+hMZ3sg>\u0013h)Y5m)%\t\u0017q[Am\u0003;\fy\u000eC\u0004\u0002\u0014f\u0001\r!!&\t\r\u0005m\u0017\u00041\u00018\u0003!\u0001xn]5uS>t\u0007BBAW3\u0001\u0007q\u0007C\u0004\u0002bf\u0001\r!a9\u0002\u001b5,Wn\u001c:z%\u0016\u001cwN\u001d3t!\u0011\ti\"!:\n\t\u0005\u001d\u0018q\u0004\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\u0002%MDw.\u001e7e\t&\u001c8-\u0019:e\u0005\u0006$8\r\u001b\u000b\t\u0003K\u000bi/a>\u0002z\"9\u0011q\u001e\u000eA\u0002\u0005E\u0018!\u00022bi\u000eD\u0007\u0003BA\u000f\u0003gLA!!>\u0002 \tY!+Z2pe\u0012\u0014\u0015\r^2i\u0011\u001d\t\tI\u0007a\u0001\u0003\u0007Cq!a?\u001b\u0001\u0004\t)+\u0001\tsKR\f\u0017N\u001c+y]6\u000b'o[3sg\u0006\u00112\u000f[8vY\u0012\u0014V\r^1j]J+7m\u001c:e)1\t)K!\u0001\u0003\u0004\t\u001d!\u0011\u0002B\t\u0011\u0019\t9h\u0007a\u0001{!9!QA\u000eA\u0002\u0005\u0015\u0016!\u0004:fi\u0006Lg\u000eR3mKR,7\u000fC\u0004\u0002pn\u0001\r!!=\t\u000f\u0005\u00052\u00041\u0001\u0003\fA!\u0011Q\u0004B\u0007\u0013\u0011\u0011y!a\b\u0003\rI+7m\u001c:e\u0011\u001d\tih\u0007a\u0001\u0003s\t1b\u001a:po\n+hMZ3sgR\u0019\u0011Ma\u0006\t\r\u00055F\u00041\u00018\u00039\u0011Xm\u001d;pe\u0016\u0014UO\u001a4feN$\u0012!Y\u0001\u0014OJ|W\u000f]*fO6,g\u000e^:CsNK'0\u001a\u000b\u000b\u0005C\u0011\u0019Da\u000f\u0003@\t\r\u0003C\u0002B\u0012\u0005[\t\u0019G\u0004\u0003\u0003&\t%b\u0002BA^\u0005OI\u0011aK\u0005\u0004\u0005WQ\u0013a\u00029bG.\fw-Z\u0005\u0005\u0005_\u0011\tD\u0001\u0003MSN$(b\u0001B\u0016U!9\u0011\u0011\r\u0010A\u0002\tU\u0002CBA3\u0005o\ty'\u0003\u0003\u0003:\u0005\u001d$\u0001C%uKJ\f'\r\\3\t\r\tub\u00041\u00018\u0003\u001di\u0017\r_*ju\u0016DaA!\u0011\u001f\u0001\u00049\u0014\u0001D7bq&sG-\u001a=TSj,\u0007b\u0002B#=\u0001\u0007\u00111G\u0001\u0017M&\u00148\u000f^+oG2,\u0017M\\1cY\u0016|eMZ:fi\u0006IB.Y:u\u001f\u001a47/\u001a;G_J4\u0015N]:u'\u0016<W.\u001a8u)\u0019\t\u0019Da\u0013\u0003R!9!QJ\u0010A\u0002\t=\u0013\u0001B:fON\u0004bAa\t\u0003.\u0005=\u0004b\u0002B#?\u0001\u0007\u00111G\u0001\u000fEVLG\u000eZ(gMN,G/T1q)-\t'q\u000bB-\u0005;\u0012\tGa\u0019\t\r\u0011\u0002\u0003\u0019AA-\u0011\u001d\u0011Y\u0006\ta\u0001\u0003g\tQa\u001d;beRDqAa\u0018!\u0001\u0004\t\u0019$A\u0002f]\u0012Da!a\u001e!\u0001\u0004i\u0004bBA?A\u0001\u0007\u0011\u0011H\u0001\u0019EVLG\u000eZ(gMN,G/T1q\r>\u00148+Z4nK:$HCEAS\u0005S\u0012YGa\u001c\u0003r\tU$\u0011\u0010B>\u0005{Ba!a$\"\u0001\u0004i\u0006b\u0002B7C\u0001\u0007\u0011qN\u0001\bg\u0016<W.\u001a8u\u0011\u0019\t9(\ta\u0001{!9!1O\u0011A\u0002\u0005M\u0012aC:uCJ$xJ\u001a4tKRDqAa\u001e\"\u0001\u0004\t\u0019$\u0001\foKb$8+Z4nK:$8\u000b^1si>3gm]3u\u0011\u0019\ti+\ta\u0001o!9\u0011\u0011Q\u0011A\u0002\u0005\r\u0005bBA?C\u0001\u0007\u0011\u0011\b")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        long l;
        Option option = cleanable.log().localLogSegments(0L, cleanable.firstDirtyOffset()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            l = ((LogSegment)((Some)option).value()).lastModified() - Predef$.MODULE$.Long2long(cleanable.log().config().deleteRetentionMs());
        } else {
            throw new MatchError((Object)option);
        }
        return this.doClean(cleanable, l);
    }

    public Tuple2<Object, CleanerStats> doClean(LogToClean cleanable, long deleteHorizonMs) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = "Beginning cleaning of log %s.";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()}));
        });
        AbstractLog log = cleanable.log();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = "Building offset map for %s...";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()}));
        });
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        Option option = log.localLogSegments(0L, cleanable.firstUncleanableOffset()).lastOption();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogSegment)map_this.get()).lastModified()));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? BoxesRunTime.boxToLong((long)Cleaner.$anonfun$doClean$4()) : object.get();
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)object2);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = "Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)...";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(deleteHorizonMs)}));
        });
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List groupedSegments = this.groupSegmentsBySize(log.localLogSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize()), cleanable.firstUncleanableOffset());
        if (groupedSegments == null) {
            throw null;
        }
        List foreach_these = groupedSegments;
        while (!foreach_these.isEmpty()) {
            Seq seq = (Seq)foreach_these.head();
            this.cleanSegments(log, (Seq<LogSegment>)seq, this.offsetMap(), deleteHorizonMs, stats, transactionMetadata);
            foreach_these = (List)foreach_these.tail();
        }
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    public void cleanSegments(AbstractLog log, Seq<LogSegment> segments, OffsetMap map, long deleteHorizonMs, CleanerStats stats, CleanedTransactionMetadata transactionMetadata) {
        LogSegment cleaned = LogCleaner$.MODULE$.createNewCleanedSegment(log.dir(), log.config(), ((LogSegment)segments.head()).baseOffset());
        transactionMetadata.cleanedIndex_$eq((Option<TransactionIndex>)new Some((Object)cleaned.txnIndex()));
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            Map<Object, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                if (nextSegmentOpt == null) {
                    throw null;
                }
                Object object = nextSegmentOpt.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogSegment)nextSegmentOpt.get()).baseOffset()));
                if (object == null) {
                    throw null;
                }
                Object object2 = object.isEmpty() ? BoxesRunTime.boxToLong((long)Cleaner.$anonfun$cleanSegments$2(map)) : object.get();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)object2);
                List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(startOffset, upperBoundOffset);
                transactionMetadata.addAbortedTransactions(abortedTransactions);
                boolean retainDeletesAndTxnMarkers = currentSegment.lastModified() > deleteHorizonMs;
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Cleaning ").append(currentSegment).append(" in log ").append(log.name()).append(" into ").append(cleaned.baseOffset()).append(" ").append("with deletion horizon ").append(deleteHorizonMs).append(", ").append((Object)(retainDeletesAndTxnMarkers ? "retaining" : "discarding")).append(" deletes.").toString());
                try {
                    this.cleanInto(log.topicPartition(), currentSegment.log(), cleaned, map, retainDeletesAndTxnMarkers, Predef$.MODULE$.Integer2int(log.config().maxMessageSize()), transactionMetadata, lastOffsetOfActiveProducers, stats);
                }
                catch (LogSegmentOffsetOverflowException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Caught segment overflow error during cleaning: ").append(e.getMessage()).toString());
                    log.splitOverflowedSegment(currentSegment);
                    throw new LogCleaningAbortedException();
                }
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Swapping in cleaned segment ").append(cleaned).append(" for segment(s) ").append(segments).append(" in log ").append(log).toString());
            log.replaceSegments((Seq<LogSegment>)new .colon.colon((Object)cleaned, (List)Nil$.MODULE$), segments, log.replaceSegments$default$3());
            return;
        }
        catch (LogCleaningAbortedException e) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception deleteException) {
                    e.addSuppressed(deleteException);
                }
            }
            catch (Throwable throwable) {
                throw e;
            }
            throw e;
        }
    }

    public void cleanInto(TopicPartition topicPartition, FileRecords sourceRecords, LogSegment dest, OffsetMap map, boolean retainDeletesAndTxnMarkers, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, LastRecord> lastRecordsOfActiveProducers, CleanerStats stats) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, transactionMetadata, retainDeletesAndTxnMarkers, lastRecordsOfActiveProducers, map, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final boolean retainDeletesAndTxnMarkers$2;
            private final Map lastRecordsOfActiveProducers$1;
            private final OffsetMap map$2;
            private final CleanerStats stats$3;

            private boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            private void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                this.discardBatchRecords_$eq(this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$2, this.retainDeletesAndTxnMarkers$2));
                if (batch.hasProducerId() && this.isBatchLastRecordOfProducer$1(batch)) {
                    return MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY;
                }
                if (this.discardBatchRecords()) {
                    return MemoryRecords.RecordFilter.BatchRetention.DELETE;
                }
                return MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY;
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record) {
                if (this.discardBatchRecords()) {
                    return false;
                }
                return this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$2, this.retainDeletesAndTxnMarkers$2, batch, record, this.stats$3);
            }

            public static final /* synthetic */ boolean $anonfun$checkBatchRetention$1(RecordBatch batch$1, LastRecord lastRecord) {
                boolean bl;
                Option<Object> option = lastRecord.lastDataOffset();
                if (option instanceof Some) {
                    long offset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    bl = batch$1.lastOffset() == offset;
                } else if (None$.MODULE$.equals(option)) {
                    bl = batch$1.isControlBatch() && batch$1.producerEpoch() == lastRecord.producerEpoch();
                } else {
                    throw new MatchError(option);
                }
                return bl;
            }

            private final boolean isBatchLastRecordOfProducer$1(RecordBatch batch$1) {
                LastRecord lastRecord;
                Option option = this.lastRecordsOfActiveProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch$1.producerId()));
                if (option == null) {
                    throw null;
                }
                Option exists_this = option;
                boolean bl = !exists_this.isEmpty() && $anon$6.$anonfun$checkBatchRetention$1(batch$1, lastRecord = (LastRecord)exists_this.get());
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.retainDeletesAndTxnMarkers$2 = retainDeletesAndTxnMarkers$2;
                this.lastRecordsOfActiveProducers$1 = lastRecordsOfActiveProducers$1;
                this.map$2 = map$2;
                this.stats$3 = stats$3;
            }

            public static final /* synthetic */ Object $anonfun$checkBatchRetention$1$adapted(RecordBatch batch$1, LastRecord lastRecord) {
                return BoxesRunTime.boxToBoolean((boolean)$anon$6.$anonfun$checkBatchRetention$1(batch$1, lastRecord));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$checkBatchRetention$1$adapted(org.apache.kafka.common.record.RecordBatch kafka.log.LastRecord )}, serializedLambda);
            }
        };
        int position = 0;
        while (position < sourceRecords.sizeInBytes()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            sourceRecords.readInto(this.readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result.messagesRead(), result.bytesRead());
            stats.recopyMessages(result.messagesRetained(), result.bytesRetained());
            position += result.bytesRead();
            ByteBuffer outputBuffer = result.outputBuffer();
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(result.maxOffset(), result.maxTimestamp(), result.shallowOffsetOfMaxTimestamp(), retained);
                this.throttler.maybeThrottle(outputBuffer.limit());
            }
            if (this.readBuffer().limit() <= 0 || result.bytesRead() != 0) continue;
            this.growBuffersOrFail(sourceRecords, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
    }

    private void growBuffersOrFail(FileRecords sourceRecords, int position, int maxLogMessageSize, MemoryRecords memoryRecords) {
        int n;
        if (this.readBuffer().capacity() >= maxLogMessageSize) {
            Integer nextBatchSize = memoryRecords.firstBatchSize();
            String logDesc = new StringBuilder(25).append("log segment ").append(sourceRecords.file()).append(" at position ").append(position).toString();
            if (nextBatchSize == null) {
                throw new IllegalStateException(new StringBuilder(40).append("Could not determine next batch size for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= 0) {
                throw new IllegalStateException(new StringBuilder(24).append("Invalid batch size ").append(nextBatchSize).append(" for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= this.readBuffer().capacity()) {
                throw new IllegalStateException(new StringBuilder(50).append("Batch size ").append(nextBatchSize).append(" < buffer size ").append(this.readBuffer().capacity()).append(", but not processed for ").append(logDesc).toString());
            }
            long bytesLeft = sourceRecords.channel().size() - (long)position;
            if ((long)Predef$.MODULE$.Integer2int(nextBatchSize) > bytesLeft) {
                throw new CorruptRecordException(new StringBuilder(69).append("Log segment may be corrupt, batch size ").append(nextBatchSize).append(" > ").append(bytesLeft).append(" bytes left in segment for ").append(logDesc).toString());
            }
            n = nextBatchSize;
        } else {
            n = maxLogMessageSize;
        }
        int maxSize = n;
        this.growBuffers(maxSize);
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata, boolean retainTxnMarkers) {
        if (batch.isControlBatch()) {
            return transactionMetadata.onControlBatchRead(batch) && !retainTxnMarkers;
        }
        return transactionMetadata.onBatchRead(batch);
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletes, RecordBatch batch, Record record, CleanerStats stats) {
        if (record.offset() > map.latestOffset()) {
            return true;
        }
        if (record.hasKey()) {
            boolean isRetainedValue;
            ByteBuffer key = record.key();
            long foundOffset = map.get(key);
            boolean latestOffsetForKey = record.offset() >= foundOffset;
            boolean bl = isRetainedValue = record.hasValue() || retainDeletes;
            return latestOffsetForKey && isRetainedValue;
        }
        stats.invalidMessage();
        return false;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            String string = "This log contains a message larger than maximum allowable size of %s.";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new IllegalStateException(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Growing cleaner I/O buffers from ").append(this.readBuffer().capacity()).append(" bytes to ").append(newSize).append(" bytes.").toString());
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.readBuffer().capacity() > this.ioBufferSize) {
            this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            .colon.colon group = new .colon.colon((Object)((LogSegment)segs.head()), (List)Nil$.MODULE$);
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        if (segs.size() > 1) {
            return ((LogSegment)segs.apply(1)).baseOffset() - 1L;
        }
        return firstUncleanableOffset - 1L;
    }

    public void buildOffsetMap(AbstractLog log, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = log.localLogSegments(start, end).toBuffer();
        ListBuffer nextSegmentStartOffsets = new ListBuffer();
        if (dirty.nonEmpty()) {
            ((IterableLike)dirty.tail()).foreach((Function1 & Serializable & scala.Serializable)nextSegment -> {
                nextSegmentStartOffsets.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{nextSegment.baseOffset()}));
                return BoxedUnit.UNIT;
            });
            nextSegmentStartOffsets.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{end}));
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = "Building offset map for log %s for %d segments in offset range [%d, %d).";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)}));
        });
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(start, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        BooleanRef full = BooleanRef.create((boolean)false);
        ((TraversableLike)dirty.zip((GenIterable)nextSegmentStartOffsets, Buffer$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).withFilter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$4(full, x$18))).foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            Cleaner.$anonfun$buildOffsetMap$5(this, log, full, map, start, transactionMetadata, stats, dirty, x$19);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = "Offset map for log %s complete.";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name()}));
        });
    }

    private boolean buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map, long startOffset, long nextSegmentStartOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        Object object = new Object();
        try {
            int position = segment.offsetIndex().lookup(startOffset).position();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < segment.log().sizeInBytes()) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                try {
                    segment.log().readInto(this.readBuffer(), position);
                }
                catch (Exception e) {
                    throw new KafkaException(new StringBuilder(67).append("Failed to read from segment ").append(segment).append(" of partition ").append(topicPartition).append(" ").append("while loading offset map").toString(), (Throwable)e);
                }
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                this.throttler.maybeThrottle(records.sizeInBytes());
                int startPosition = position;
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$1(transactionMetadata, stats, startOffset, map, maxDesiredMapSize, object, batch);
                    return BoxedUnit.UNIT;
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(segment.log(), position, maxLogMessageSize, records);
            }
            map.updateLatestOffset(nextSegmentStartOffset - 1L);
            this.restoreBuffers();
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ String $anonfun$new$2() {
        return "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads";
    }

    public static final /* synthetic */ long $anonfun$doClean$4() {
        return 0L;
    }

    public static final /* synthetic */ long $anonfun$cleanSegments$2(OffsetMap map$1) {
        return map$1.latestOffset() + 1L;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$4(BooleanRef full$1, Tuple2 x$18) {
        if (x$18 == null) {
            throw new MatchError(null);
        }
        boolean bl = !full$1.elem;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$5(Cleaner $this, AbstractLog log$4, BooleanRef full$1, OffsetMap map$3, long start$1, CleanedTransactionMetadata transactionMetadata$3, CleanerStats stats$4, Buffer dirty$1, Tuple2 x$19) {
        if (x$19 != null) {
            LogSegment segment = (LogSegment)x$19._1();
            long nextSegmentStartOffset = x$19._2$mcJ$sp();
            $this.checkDone.apply((Object)log$4.topicPartition());
            full$1.elem = $this.buildOffsetMapForSegment(log$4.topicPartition(), segment, map$3, start$1, nextSegmentStartOffset, Predef$.MODULE$.Integer2int(log$4.config().maxMessageSize()), transactionMetadata$3, stats$4);
            if (full$1.elem) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                    String string = "Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped";
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                    return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirty$1.indexOf((Object)segment)), BoxesRunTime.boxToLong((long)segment.baseOffset())}));
                });
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$2(long startOffset$1, OffsetMap map$4, int maxDesiredMapSize$1, Object nonLocalReturnKey2$1, CleanerStats stats$5, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$1) {
            if (map$4.size() < maxDesiredMapSize$1) {
                map$4.put(record.key(), record.offset());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, true);
            }
        }
        stats$5.indexMessagesRead(1);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(CleanedTransactionMetadata transactionMetadata$4, CleanerStats stats$5, long startOffset$1, OffsetMap map$4, int maxDesiredMapSize$1, Object nonLocalReturnKey2$1, MutableRecordBatch batch) {
        if (batch.isControlBatch()) {
            transactionMetadata$4.onControlBatchRead((RecordBatch)batch);
            stats$5.indexMessagesRead(1);
        } else if (transactionMetadata$4.onBatchRead((RecordBatch)batch)) {
            stats$5.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
        } else {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                Cleaner.$anonfun$buildOffsetMapForSegment$2(startOffset$1, map$4, maxDesiredMapSize$1, nonLocalReturnKey2$1, stats$5, record);
                return BoxedUnit.UNIT;
            });
        }
        if (batch.lastOffset() >= startOffset$1) {
            map$4.updateLatestOffset(batch.lastOffset());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        void require_requirement;
        boolean bl;
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.checkDone = checkDone;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(10).append("Cleaner ").append(id).append(": ").toString());
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        boolean bl2 = bl = (double)offsetMap.slots() * dupBufferLoadFactor > 1.0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (require_requirement == false) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)Cleaner.$anonfun$new$2()).toString());
        }
    }

    public static final /* synthetic */ Object $anonfun$doClean$3$adapted(LogSegment x$15) {
        return BoxesRunTime.boxToLong((long)x$15.lastModified());
    }

    public static final /* synthetic */ Object $anonfun$doClean$6$adapted(Cleaner $this, AbstractLog log$2, long deleteHorizonMs$1, CleanerStats stats$2, CleanedTransactionMetadata transactionMetadata$1, Seq group) {
        $this.cleanSegments(log$2, (Seq<LogSegment>)group, $this.offsetMap(), deleteHorizonMs$1, stats$2, transactionMetadata$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$cleanSegments$1$adapted(LogSegment x$16) {
        return BoxesRunTime.boxToLong((long)x$16.baseOffset());
    }
}

