/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager$;
import kafka.log.LogConfig;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.state.TierPartitionState;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RetriableException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001\u0002\u0010 \u0001\u0011B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!)\u0005A!A!\u0002\u00131\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u000bU\u0003A\u0011\u0001,\t\u000fy\u0003!\u0019!C\u0001?\"11\r\u0001Q\u0001\n\u0001DQ\u0001\u001a\u0001\u0005\u0002\u0015DQA \u0001\u0005\u0002}Dq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\n\u0001!\t!a\u0003\t\u0013\u0005=\u0001!%A\u0005\u0002\u0005E\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003o\u0001A\u0011AA\u001d\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013Bq!!\u0014\u0001\t\u0013\ty\u0005C\u0004\u0002T\u0001!\t!!\u0016\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBA3\u0001\u0011%\u0011q\r\u0005\b\u0003W\u0002A\u0011BA7\u0011\u001d\t\t\b\u0001C\u0005\u0003gBq!a\u001e\u0001\t\u0013\tI\bC\u0004\u0002~\u0001!\t!a \t\u000f\u0005\r\u0005\u0001\"\u0003\u0002\u0006\"9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0005BBAI\u0001\u0011%qP\u0001\u000bU_BL7\rR3mKRLwN\\'b]\u0006<WM\u001d\u0006\u0003A\u0005\n!bY8oiJ|G\u000e\\3s\u0015\u0005\u0011\u0013!B6bM.\f7\u0001A\n\u0004\u0001\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-_5\tQF\u0003\u0002/C\u0005)Q\u000f^5mg&\u0011\u0001'\f\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOB\u00111GN\u0007\u0002i)\u0011Q'I\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005]\"$aC&bM.\f7i\u001c8gS\u001e\f\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u!\tQ4(D\u0001 \u0013\tatDA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqR\f1C]3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016\u0004\"AO \n\u0005\u0001{\"a\u0005*fa2L7-Y*uCR,W*Y2iS:,\u0017!\u00069beRLG/[8o'R\fG/Z'bG\"Lg.\u001a\t\u0003u\rK!\u0001R\u0010\u0003+A\u000b'\u000f^5uS>t7\u000b^1uK6\u000b7\r[5oK\u000611\r\\5f]R\u0004\"AO$\n\u0005!{\"A\u0004#fY\u0016$\u0018n\u001c8DY&,g\u000e^\u0001\u0014i&,'\u000fV8qS\u000el\u0015M\\1hKJ|\u0005\u000f\u001e\t\u0004M-k\u0015B\u0001'(\u0005\u0019y\u0005\u000f^5p]B\u0011ajU\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0006i>\u0004\u0018n\u0019\u0006\u0003%\u0006\nA\u0001^5fe&\u0011Ak\u0014\u0002\u0011)&,'\u000fV8qS\u000el\u0015M\\1hKJ\fa\u0001P5oSRtDcB,Y3j[F,\u0018\t\u0003u\u0001AQ!M\u0004A\u0002IBQ\u0001O\u0004A\u0002eBQ!P\u0004A\u0002yBQ!Q\u0004A\u0002\tCQ!R\u0004A\u0002\u0019CQ!S\u0004A\u0002)\u000bA#[:EK2,G/\u001a+pa&\u001cWI\\1cY\u0016$W#\u00011\u0011\u0005\u0019\n\u0017B\u00012(\u0005\u001d\u0011un\u001c7fC:\fQ#[:EK2,G/\u001a+pa&\u001cWI\\1cY\u0016$\u0007%\u0001\u0003j]&$Hc\u00014jyB\u0011aeZ\u0005\u0003Q\u001e\u0012A!\u00168ji\")!N\u0003a\u0001W\u0006A\u0012N\\5uS\u0006dGk\u001c9jGN$vNQ3EK2,G/\u001a3\u0011\u00071|\u0017/D\u0001n\u0015\tqw%\u0001\u0006d_2dWm\u0019;j_:L!\u0001]7\u0003\u0007M+G\u000f\u0005\u0002ss:\u00111o\u001e\t\u0003i\u001ej\u0011!\u001e\u0006\u0003m\u000e\na\u0001\u0010:p_Rt\u0014B\u0001=(\u0003\u0019\u0001&/\u001a3fM&\u0011!p\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a<\u0003\"B?\u000b\u0001\u0004Y\u0017AI5oSRL\u0017\r\u001c+pa&\u001c7/\u00138fY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g.\u0001\tuef$v\u000e]5d\t\u0016dW\r^5p]R\ta-\u0001\rf]F,X-^3U_BL7m\u001d$pe\u0012+G.\u001a;j_:$2AZA\u0003\u0011\u0019\t9\u0001\u0004a\u0001W\u00061Ao\u001c9jGN\fqC]3tk6,G)\u001a7fi&|gNR8s)>\u0004\u0018nY:\u0015\u0007\u0019\fi\u0001\u0003\u0005\u0002\b5\u0001\n\u00111\u0001l\u0003\u0005\u0012Xm];nK\u0012+G.\u001a;j_:4uN\u001d+pa&\u001c7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019BK\u0002l\u0003+Y#!a\u0006\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003C9\u0013AC1o]>$\u0018\r^5p]&!\u0011QEA\u000e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0014M\u0006LGNU3qY&\u001c\u0017\rR3mKRLwN\u001c\u000b\u0004M\u0006-\u0002bBA\u0017\u001f\u0001\u0007\u0011qF\u0001\te\u0016\u0004H.[2bgB!An\\A\u0019!\rQ\u00141G\u0005\u0004\u0003ky\"a\u0005)beRLG/[8o\u0003:$'+\u001a9mS\u000e\f\u0017AH7be.$v\u000e]5d\u0013:,G.[4jE2,gi\u001c:EK2,G/[8o)\u00151\u00171HA\u001f\u0011\u0019\t9\u0001\u0005a\u0001W\"A\u0011q\b\t\u0005\u0002\u0004\t\t%\u0001\u0004sK\u0006\u001cxN\u001c\t\u0005M\u0005\r\u0013/C\u0002\u0002F\u001d\u0012\u0001\u0002\u00102z]\u0006lWMP\u0001\u001dSN$v\u000e]5d\u0013:,G.[4jE2,gi\u001c:EK2,G/[8o)\r\u0001\u00171\n\u0005\u0006!F\u0001\r!]\u0001\u001aSN$v\u000e]5d\t\u0016dW\r^5p]&s\u0007K]8he\u0016\u001c8\u000fF\u0002a\u0003#BQ\u0001\u0015\nA\u0002E\f!$[:U_BL7-U;fk\u0016$W\u000b\u001d$pe\u0012+G.\u001a;j_:$2\u0001YA,\u0011\u0015\u00016\u00031\u0001r\u0003]\u0019w.\u001c9mKR,'+\u001a9mS\u000e\fG)\u001a7fi&|g\u000eF\u0002g\u0003;Bq!!\f\u0015\u0001\u0004\ty#\u0001\u000ejgR{\u0007/[2FY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000eF\u0002a\u0003GBQ\u0001U\u000bA\u0002E\f!E]3uef$U\r\\3uS>tgi\u001c:J]\u0016d\u0017nZ5cY\u0016\u0014V\r\u001d7jG\u0006\u001cHc\u00014\u0002j!1\u0011q\u0001\fA\u0002-\fA\u0003^5fe\u0016$G)\u001a7fi&|gNT3fI\u0016$Gc\u00011\u0002p!)\u0001k\u0006a\u0001c\u00061\u0012m]=oG\u0012+G.\u001a;f)&,'/\u001a3U_BL7\rF\u0002g\u0003kBQ\u0001\u0015\rA\u0002E\f!\u0004\u001d:fa\u0006\u0014XmQ8na2,G/\u001a#fY\u0016$X\rV8qS\u000e$2AZA>\u0011\u0015\u0001\u0016\u00041\u0001r\u0003E1\u0017N\\5tQR{\u0007/[2EK2,G/\u001a\u000b\u0004M\u0006\u0005\u0005\"\u0002)\u001b\u0001\u0004\t\u0018aD8o)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8\u0015\u0007\u0019\f9\t\u0003\u0004\u0002\bm\u0001\ra[\u0001\u0014_:\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0004M\u00065\u0005BBAH9\u0001\u00071.A\tu_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012\fqB]3tk6,G)\u001a7fi&|gn\u001d")
public class TopicDeletionManager
implements Logging {
    private final KafkaConfig config;
    private final ControllerContext controllerContext;
    private final ReplicaStateMachine replicaStateMachine;
    private final PartitionStateMachine partitionStateMachine;
    public final DeletionClient kafka$controller$TopicDeletionManager$$client;
    private final Option<TierTopicManager> tierTopicManagerOpt;
    private final boolean isDeleteTopicEnabled;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Initializing manager with initial deletions: ").append(initialTopicsToBeDeleted).append(", ").append("initial ineligible deletions: ").append(initialTopicsIneligibleForDeletion).toString());
        if (this.isDeleteTopicEnabled()) {
            this.controllerContext.queueTopicDeletion(initialTopicsToBeDeleted);
            this.controllerContext.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.controllerContext.topicsToBeDeleted()));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Removing ").append(initialTopicsToBeDeleted).append(" since delete topic is disabled").toString());
        this.kafka$controller$TopicDeletionManager$$client.deleteTopicDeletions((Seq<String>)initialTopicsToBeDeleted.toSeq(), this.controllerContext.epochZkVersion());
    }

    public void tryTopicDeletion() {
        if (this.isDeleteTopicEnabled()) {
            this.resumeDeletions();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            this.controllerContext.topicsWithDeletionBeingCompleted().$minus$minus$eq(topics);
            this.controllerContext.queueTopicDeletion(topics);
            this.resumeDeletions();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion;
        if (this.isDeleteTopicEnabled() && (topicsToResumeDeletion = (Set)topics.$amp(this.controllerContext.topicsToBeDeleted())).nonEmpty()) {
            this.controllerContext.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeDeletions();
            return;
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete;
        if (this.isDeleteTopicEnabled() && (replicasThatFailedToDelete = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())))).nonEmpty()) {
            Set topics = (Set)replicasThatFailedToDelete.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topic(), Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Deletion failed for replicas ").append(replicasThatFailedToDelete.mkString(",")).append(". Halting deletion for topics ").append(topics).toString());
            this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasThatFailedToDelete.toSeq(), ReplicaDeletionIneligible$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "replica deletion failure");
            this.resumeDeletions();
            return;
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics, Function0<String> reason) {
        if (this.isDeleteTopicEnabled()) {
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.controllerContext.topicsToBeDeleted().$amp(topics);
            this.controllerContext.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Halted deletion of topics ").append(newTopicsToHaltDeletion.mkString(",")).append(" due to ").append(reason.apply()).toString());
                return;
            }
        }
    }

    private boolean isTopicIneligibleForDeletion(String topic) {
        if (this.isDeleteTopicEnabled()) {
            return this.controllerContext.topicsIneligibleForDeletion().contains((Object)topic);
        }
        return true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        if (this.isDeleteTopicEnabled()) {
            return this.controllerContext.isAnyReplicaInState(topic, ReplicaDeletionStarted$.MODULE$);
        }
        return false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        if (this.isDeleteTopicEnabled()) {
            return this.controllerContext.isTopicQueuedUpForDeletion(topic);
        }
        return false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Deletion successfully completed for replicas ").append(successfullyDeletedReplicas.mkString(",")).toString());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)successfullyDeletedReplicas.toSeq(), ReplicaDeletionSuccessful$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        this.resumeDeletions();
    }

    private boolean isTopicEligibleForDeletion(String topic) {
        return this.controllerContext.isTopicQueuedUpForDeletion(topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic) && !this.controllerContext.topicsWithDeletionBeingCompleted().contains((Object)topic);
    }

    private void retryDeletionForIneligibleReplicas(Set<String> topics) {
        Set failedReplicas = (Set)topics.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> $this.controllerContext.replicasInState((String)x$3, ReplicaDeletionIneligible$.MODULE$), Set$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Retrying deletion of topics ").append(topics.mkString(",")).append(" since replicas ").append(failedReplicas.mkString(",")).append(" were not successfully deleted").toString());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)failedReplicas.toSeq(), OfflineReplica$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
    }

    private boolean tieredDeletionNeeded(String topic) {
        if (Predef$.MODULE$.Boolean2boolean(this.config.tierFeature())) {
            LogConfig topicConfig = this.kafka$controller$TopicDeletionManager$$client.topicConfig(topic, this.config);
            return Predef$.MODULE$.Boolean2boolean(topicConfig.tierEnable()) && !topicConfig.compact();
        }
        return false;
    }

    private void asyncDeleteTieredTopic(String topic) {
        Set<PartitionAndReplica> replicasForDeletedTopic = this.controllerContext.replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        TierTopicManager tierTopicManager = (TierTopicManager)this.tierTopicManagerOpt.get();
        UUID topicId = (UUID)this.controllerContext.topicIds().apply((Object)topic);
        scala.collection.immutable.Set partitionsForDeletedTopic = ((TraversableOnce)replicasForDeletedTopic.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.topicPartition(), Set$.MODULE$.canBuildFrom())).toSet();
        ListBuffer appendResults = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        partitionsForDeletedTopic.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            TopicIdPartition topicIdPartition = new TopicIdPartition(topic, topicId, partition.partition());
            TierPartitionDeleteInitiate deleteInitiate = new TierPartitionDeleteInitiate(topicIdPartition, $this.controllerContext.epoch(), UUID.randomUUID());
            return appendResults.$plus$eq(tierTopicManager.addMetadata(deleteInitiate));
        });
        CompletableFuture.allOf((CompletableFuture[])appendResults.toArray(ClassTag$.MODULE$.apply(CompletableFuture.class))).whenComplete((BiConsumer)new BiConsumer<Void, Throwable>(this, appendResults, topic){
            private final /* synthetic */ TopicDeletionManager $outer;
            private final ListBuffer appendResults$1;
            private final String topic$1;

            public BiConsumer<Void, Throwable> andThen(BiConsumer<? super Void, ? super Throwable> x$1) {
                return BiConsumer.super.andThen(x$1);
            }

            /*
             * WARNING - void declaration
             */
            public void accept(Void result, Throwable t) {
                block7: {
                    Object object = new Object();
                    try {
                        void forall_p;
                        void map_bf;
                        void map_f;
                        if (t != null) {
                            this.$outer.kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(t, this.topic$1);
                            break block7;
                        }
                        ListBuffer listBuffer = this.appendResults$1;
                        CanBuildFrom canBuildFrom = ListBuffer$.MODULE$.canBuildFrom();
                        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)appendResult -> {
                            try {
                                return (TierPartitionState.AppendResult)((Object)((Object)appendResult.get()));
                            }
                            catch (Exception e) {
                                $this.$outer.kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(e, $this.topic$1);
                                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                            }
                        };
                        if (listBuffer == null) {
                            throw null;
                        }
                        ListBuffer results = (ListBuffer)TraversableLike.map$((TraversableLike)listBuffer, (Function1)map_f, (CanBuildFrom)map_bf);
                        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$accept$2(x$5));
                        if (results == null) {
                            throw null;
                        }
                        if (results.underlying().forall((Function1)forall_p)) {
                            this.$outer.kafka$controller$TopicDeletionManager$$client.completeDeleteTopic(this.topic$1);
                            break block7;
                        }
                        this.$outer.kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(new IllegalStateException(new StringBuilder(18).append("Unexpected result ").append(results).toString()), this.topic$1);
                        return;
                    }
                    catch (NonLocalReturnControl ex) {
                        if (ex.key() == object) {
                            ex.value$mcV$sp();
                            return;
                        }
                        throw ex;
                    }
                }
            }

            public static final /* synthetic */ boolean $anonfun$accept$2(TierPartitionState.AppendResult x$5) {
                TierPartitionState.AppendResult appendResult = x$5;
                TierPartitionState.AppendResult appendResult2 = TierPartitionState.AppendResult.ACCEPTED;
                return !(appendResult != null ? !((Object)((Object)appendResult)).equals((Object)((Object)appendResult2)) : appendResult2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.appendResults$1 = appendResults$1;
                this.topic$1 = topic$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1(kafka.controller.TopicDeletionManager$$anon$1 java.lang.Object java.util.concurrent.CompletableFuture ), $anonfun$accept$2$adapted(kafka.tier.state.TierPartitionState$AppendResult )}, serializedLambda);
            }
        });
    }

    private void prepareCompleteDeleteTopic(String topic) {
        this.kafka$controller$TopicDeletionManager$$client.mutePartitionModifications(topic);
        this.controllerContext.topicsWithDeletionBeingCompleted().$plus$eq((Object)topic);
        if (this.tieredDeletionNeeded(topic)) {
            this.asyncDeleteTieredTopic(topic);
            return;
        }
        this.finishTopicDelete(topic);
    }

    public void finishTopicDelete(String topic) {
        Set<PartitionAndReplica> replicasForDeletedTopic = this.controllerContext.replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletedTopic.toSeq(), NonExistentReplica$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        this.controllerContext.topicsToBeDeleted().$minus$eq((Object)topic);
        this.controllerContext.topicsWithDeletionStarted().$minus$eq((Object)topic);
        this.kafka$controller$TopicDeletionManager$$client.deleteTopic(topic, this.controllerContext.epochZkVersion());
        this.controllerContext.removeTopic(topic);
        this.controllerContext.topicsWithDeletionBeingCompleted().$minus$eq((Object)topic);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Deletion of topic ").append(topic).append(" successfully completed").toString());
    }

    private void onTopicDeletion(Set<String> topics) {
        Set unseenTopicsForDeletion = (Set)topics.$minus$minus(this.controllerContext.topicsWithDeletionStarted());
        if (unseenTopicsForDeletion.nonEmpty()) {
            Set unseenPartitionsForDeletion = (Set)unseenTopicsForDeletion.flatMap((Function1 & Serializable & scala.Serializable)topic -> $this.controllerContext.partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom());
            this.partitionStateMachine.handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), OfflinePartition$.MODULE$);
            this.partitionStateMachine.handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), NonExistentPartition$.MODULE$);
            this.controllerContext.beginTopicDeletion((Set<String>)unseenTopicsForDeletion);
        }
        this.kafka$controller$TopicDeletionManager$$client.sendMetadataUpdate((Set<TopicPartition>)((Set)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> $this.controllerContext.partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom())));
        this.onPartitionDeletion(topics);
    }

    private void onPartitionDeletion(Set<String> topicsToBeDeleted) {
        ListBuffer allDeadReplicas = (ListBuffer)ListBuffer$.MODULE$.empty();
        ListBuffer allReplicasForDeletionRetry = (ListBuffer)ListBuffer$.MODULE$.empty();
        scala.collection.mutable.Set allTopicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
        topicsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            void var7_7;
            void var6_6;
            Tuple2 tuple2 = $this.controllerContext.replicasForTopic((String)topic).partition((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.controllerContext.isReplicaOnline(r.replica(), r.topicPartition(), this.controllerContext.isReplicaOnline$default$3())));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Set aliveReplicas = (Set)tuple2._1();
            Set deadReplicas = (Set)tuple2._2();
            void aliveReplicas2 = var6_6;
            void deadReplicas2 = var7_7;
            Set<PartitionAndReplica> successfullyDeletedReplicas = $this.controllerContext.replicasInState((String)topic, ReplicaDeletionSuccessful$.MODULE$);
            Set replicasForDeletionRetry = (Set)aliveReplicas2.$minus$minus(successfullyDeletedReplicas);
            allDeadReplicas.$plus$plus$eq((TraversableOnce)deadReplicas2);
            allReplicasForDeletionRetry.$plus$plus$eq((TraversableOnce)replicasForDeletionRetry);
            if (deadReplicas2.nonEmpty()) {
                this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> TopicDeletionManager.$anonfun$onPartitionDeletion$3((Set)deadReplicas2, topic)));
                return allTopicsIneligibleForDeletion.$plus$eq(topic);
            }
            return BoxedUnit.UNIT;
        });
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allDeadReplicas, ReplicaDeletionIneligible$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allReplicasForDeletionRetry, OfflineReplica$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allReplicasForDeletionRetry, ReplicaDeletionStarted$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        if (allTopicsIneligibleForDeletion.nonEmpty()) {
            this.markTopicIneligibleForDeletion((Set<String>)allTopicsIneligibleForDeletion, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "offline replicas");
        }
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.controllerContext.topicsToBeDeleted());
        scala.collection.mutable.Set topicsEligibleForRetry = scala.collection.mutable.Set$.MODULE$.empty();
        scala.collection.mutable.Set topicsEligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Handling deletion for topics ").append(topicsQueuedForDeletion.mkString(",")).toString());
        }
        topicsQueuedForDeletion.diff(this.controllerContext.topicsWithDeletionBeingCompleted()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            if ($this.controllerContext.areAllReplicasInState((String)topic, ReplicaDeletionSuccessful$.MODULE$)) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("All replicas for ").append((String)topic).append(" have been successfully deleted. Preparing to complete topic deletion.").toString());
                this.prepareCompleteDeleteTopic((String)topic);
            } else if (!$this.controllerContext.isAnyReplicaInState((String)topic, ReplicaDeletionStarted$.MODULE$) && $this.controllerContext.isAnyReplicaInState((String)topic, ReplicaDeletionIneligible$.MODULE$)) {
                topicsEligibleForRetry.$plus$eq(topic);
            }
            if (this.isTopicEligibleForDeletion((String)topic)) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deletion of topic ").append((String)topic).append(" (re)started").toString());
                return topicsEligibleForDeletion.$plus$eq(topic);
            }
            return BoxedUnit.UNIT;
        });
        if (topicsEligibleForRetry.nonEmpty()) {
            this.retryDeletionForIneligibleReplicas((Set<String>)topicsEligibleForRetry);
        }
        if (topicsEligibleForDeletion.nonEmpty()) {
            this.onTopicDeletion((Set<String>)topicsEligibleForDeletion);
        }
    }

    public final void kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(Throwable t, String topic$1) {
        boolean bl = t instanceof RetriableException ? true : t.getCause() != null && t.getCause() instanceof RetriableException;
        if (bl) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Retrying topic deletion for tiered topic ").append(topic$1).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            try {
                this.kafka$controller$TopicDeletionManager$$client.retryDeletion();
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Error deleting tiered topic ").append(topic$1).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
        }
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Error deleting tiered topic ").append(topic$1).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
    }

    public static final /* synthetic */ String $anonfun$onPartitionDeletion$3(Set deadReplicas$1, String topic$3) {
        return new StringBuilder(33).append("Dead Replicas (").append(deadReplicas$1.mkString(",")).append(") found for topic ").append(topic$3).toString();
    }

    public TopicDeletionManager(KafkaConfig config, ControllerContext controllerContext, ReplicaStateMachine replicaStateMachine, PartitionStateMachine partitionStateMachine, DeletionClient client, Option<TierTopicManager> tierTopicManagerOpt) {
        this.config = config;
        this.controllerContext = controllerContext;
        this.replicaStateMachine = replicaStateMachine;
        this.partitionStateMachine = partitionStateMachine;
        this.kafka$controller$TopicDeletionManager$$client = client;
        this.tierTopicManagerOpt = tierTopicManagerOpt;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(26).append("[Topic Deletion Manager ").append(config.brokerId()).append("] ").toString());
        this.isDeleteTopicEnabled = Predef$.MODULE$.Boolean2boolean(config.deleteTopicEnable());
    }
}

