/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.controller.CompleteTopicDeletion;
import kafka.controller.DeletionClient;
import kafka.controller.KafkaController;
import kafka.controller.TopicDeletion$;
import kafka.log.LogConfig;
import kafka.server.KafkaConfig;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001y4Aa\u0003\u0007\u0001#!AQ\u0002\u0001B\u0001B\u0003%A\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011\u00151\u0003\u0001\"\u0001(\u0011\u0015Y\u0003\u0001\"\u0011-\u0011\u0015\u0011\u0005\u0001\"\u0011D\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015I\b\u0001\"\u0011{\u0011\u0015a\b\u0001\"\u0011~\u0005a\u0019uN\u001c;s_2dWM\u001d#fY\u0016$\u0018n\u001c8DY&,g\u000e\u001e\u0006\u0003\u001b9\t!bY8oiJ|G\u000e\\3s\u0015\u0005y\u0011!B6bM.\f7\u0001A\n\u0004\u0001IA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u001a55\tA\"\u0003\u0002\u001c\u0019\tqA)\u001a7fi&|gn\u00117jK:$\bCA\r\u001e\u0013\tqBBA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0003!Q8n\u00117jK:$\bCA\u0011%\u001b\u0005\u0011#BA\u0012\u000f\u0003\tQ8.\u0003\u0002&E\ti1*\u00194lCj[7\t\\5f]R\fa\u0001P5oSRtDc\u0001\u0015*UA\u0011\u0011\u0004\u0001\u0005\u0006\u001b\r\u0001\r\u0001\b\u0005\u0006?\r\u0001\r\u0001I\u0001\fI\u0016dW\r^3U_BL7\rF\u0002.au\u0002\"a\u0005\u0018\n\u0005=\"\"\u0001B+oSRDQ!\r\u0003A\u0002I\nQ\u0001^8qS\u000e\u0004\"a\r\u001e\u000f\u0005QB\u0004CA\u001b\u0015\u001b\u00051$BA\u001c\u0011\u0003\u0019a$o\\8u}%\u0011\u0011\bF\u0001\u0007!J,G-\u001a4\n\u0005mb$AB*ue&twM\u0003\u0002:)!)a\b\u0002a\u0001\u007f\u0005qQ\r]8dQj[g+\u001a:tS>t\u0007CA\nA\u0013\t\tECA\u0002J]R\fA\u0003Z3mKR,Gk\u001c9jG\u0012+G.\u001a;j_:\u001cHcA\u0017E\u001f\")Q)\u0002a\u0001\r\u00061Ao\u001c9jGN\u00042a\u0012'3\u001d\tA%J\u0004\u00026\u0013&\tQ#\u0003\u0002L)\u00059\u0001/Y2lC\u001e,\u0017BA'O\u0005\r\u0019V-\u001d\u0006\u0003\u0017RAQAP\u0003A\u0002}\n!$\\;uKB\u000b'\u000f^5uS>tWj\u001c3jM&\u001c\u0017\r^5p]N$\"!\f*\t\u000bE2\u0001\u0019\u0001\u001a\u0002%M,g\u000eZ'fi\u0006$\u0017\r^1Va\u0012\fG/\u001a\u000b\u0003[UCQAV\u0004A\u0002]\u000b!\u0002]1si&$\u0018n\u001c8t!\rA6,X\u0007\u00023*\u0011!\fF\u0001\u000bG>dG.Z2uS>t\u0017B\u0001/Z\u0005\r\u0019V\r\u001e\t\u0003=\u001al\u0011a\u0018\u0006\u0003A\u0006\faaY8n[>t'BA\bc\u0015\t\u0019G-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0006\u0019qN]4\n\u0005\u001d|&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\fi>\u0004\u0018nY\"p]\u001aLw\rF\u0002kaF\u0004\"a\u001b8\u000e\u00031T!!\u001c\b\u0002\u00071|w-\u0003\u0002pY\nIAj\\4D_:4\u0017n\u001a\u0005\u0006c!\u0001\rA\r\u0005\u0006e\"\u0001\ra]\u0001\u0007G>tg-[4\u0011\u0005Q<X\"A;\u000b\u0005Yt\u0011AB:feZ,'/\u0003\u0002yk\nY1*\u00194lC\u000e{gNZ5h\u0003M\u0019w.\u001c9mKR,G)\u001a7fi\u0016$v\u000e]5d)\ti3\u0010C\u00032\u0013\u0001\u0007!'A\u0007sKR\u0014\u0018\u0010R3mKRLwN\u001c\u000b\u0002[\u0001")
public class ControllerDeletionClient
implements DeletionClient {
    private final KafkaController controller;
    private final KafkaZkClient zkClient;

    @Override
    public void deleteTopic(String topic, int epochZkVersion) {
        this.zkClient.deleteTopicZNode(topic, epochZkVersion);
        this.zkClient.deleteTopicConfigs((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), epochZkVersion);
        this.zkClient.deleteTopicDeletions((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), epochZkVersion);
    }

    @Override
    public void deleteTopicDeletions(Seq<String> topics, int epochZkVersion) {
        this.zkClient.deleteTopicDeletions(topics, epochZkVersion);
    }

    @Override
    public void mutePartitionModifications(String topic) {
        this.controller.unregisterPartitionModificationsHandlers((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
    }

    @Override
    public void sendMetadataUpdate(Set<TopicPartition> partitions) {
        this.controller.sendUpdateMetadataRequest((Seq<Object>)this.controller.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), partitions);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LogConfig topicConfig(String topic, KafkaConfig config) {
        void var5_5;
        void var4_4;
        Tuple2<Map<String, LogConfig>, Map<String, Exception>> tuple2 = this.zkClient.getLogConfigs((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), config.originals());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map topicConfigs = (Map)tuple2._1();
        Map failed = (Map)tuple2._2();
        void topicConfigs2 = var4_4;
        void failed2 = var5_5;
        if (failed2.nonEmpty()) {
            throw (Throwable)((Tuple2)failed2.head())._2();
        }
        return (LogConfig)((Object)topicConfigs2.apply((Object)topic));
    }

    @Override
    public void completeDeleteTopic(String topic) {
        if (this.controller.isActive()) {
            this.controller.eventManager().put(new CompleteTopicDeletion(topic));
        }
    }

    @Override
    public void retryDeletion() {
        this.controller.kafkaScheduler().schedule("delete-topic-retry", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if ($this.controller.isActive()) {
                $this.controller.eventManager().put(TopicDeletion$.MODULE$);
            }
        }, 1000L, this.controller.kafkaScheduler().schedule$default$4(), this.controller.kafkaScheduler().schedule$default$5());
    }

    public ControllerDeletionClient(KafkaController controller, KafkaZkClient zkClient) {
        this.controller = controller;
        this.zkClient = zkClient;
    }
}

