/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.UUID;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_0_IV0$;
import kafka.api.KAFKA_2_2_IV0$;
import kafka.api.KAFKA_2_4_IV0$;
import kafka.api.KAFKA_2_4_IV1$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEvent;
import kafka.controller.LeaderAndIsrRequestInfo;
import kafka.controller.LeaderAndIsrResponseReceived;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaAssignment;
import kafka.controller.StateChangeLogger;
import kafka.controller.StopReplicaRequestInfo;
import kafka.controller.TopicDeletionStopReplicaResponseReceived;
import kafka.controller.UpdateMetadataResponseReceived;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-a!\u0002\u000f\u001e\u0003\u0003\u0011\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u0011Y\u0002!\u0011!Q\u0001\n]B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0011\u0019Q\u0005\u0001)A\u0005\u000f\"91\n\u0001b\u0001\n\u0003a\u0005B\u0002-\u0001A\u0003%Q\nC\u0004Z\u0001\t\u0007I\u0011\u0001.\t\r\t\u0004\u0001\u0015!\u0003\\\u0011\u001d\u0019\u0007A1A\u0005\u0002\u0011Da\u0001\u001b\u0001!\u0002\u0013)\u0007bB5\u0001\u0005\u0004%\tA\u001b\u0005\b\u00037\u0001\u0001\u0015!\u0003l\u0011\u001d\ti\u0002\u0001D\u0001\u0003?Aq!!\r\u0001\r\u0003\t\u0019\u0004C\u0005\u0002z\u0001\t\n\u0011\"\u0001\u0002|!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAK\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0003G\u0003A\u0011AAJ\u0011\u001d\t)\u000b\u0001C\u0001\u0003OCq!a5\u0001\t\u0003\t)\u000eC\u0004\u0002`\u0002!\t!!9\t\u000f\u0005-\b\u0001\"\u0003\u0002n\"9\u0011q\u001f\u0001\u0005\n\u0005e\bbBA\u0000\u0001\u0011%!\u0011\u0001\u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0005\u0011\n%m\u001d;sC\u000e$8i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD'B\u0001\u0010 \u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002A\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001$SA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0017\u000e\u0003-R!\u0001L\u0010\u0002\u000bU$\u0018\u000e\\:\n\u00059Z#a\u0002'pO\u001eLgnZ\u0001\u0007G>tg-[4\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005Mz\u0012AB:feZ,'/\u0003\u00026e\tY1*\u00194lC\u000e{gNZ5h\u0003E\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\t\u0003qej\u0011!H\u0005\u0003uu\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\t\u0003quJ!AP\u000f\u0003#M#\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0005\u0003\n\u001bE\t\u0005\u00029\u0001!)q\u0006\u0002a\u0001a!)a\u0007\u0002a\u0001o!)1\b\u0002a\u0001y\u0005a1m\u001c8ue>dG.\u001a:JIV\tq\t\u0005\u0002%\u0011&\u0011\u0011*\n\u0002\u0004\u0013:$\u0018!D2p]R\u0014x\u000e\u001c7fe&#\u0007%\u0001\fmK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cH/T1q+\u0005i\u0005\u0003\u0002(T\u000fVk\u0011a\u0014\u0006\u0003!F\u000bq!\\;uC\ndWM\u0003\u0002SK\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Q{%aA'baB\u0011\u0001HV\u0005\u0003/v\u0011q\u0003T3bI\u0016\u0014\u0018I\u001c3JgJ\u0014V-];fgRLeNZ8\u0002/1,\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;NCB\u0004\u0013!F:u_B\u0014V\r\u001d7jG\u0006\u0014V-];fgRl\u0015\r]\u000b\u00027B!ajU$]!\rqUlX\u0005\u0003=>\u0013!\u0002T5ti\n+hMZ3s!\tA\u0004-\u0003\u0002b;\t12\u000b^8q%\u0016\u0004H.[2b%\u0016\fX/Z:u\u0013:4w.\u0001\fti>\u0004(+\u001a9mS\u000e\f'+Z9vKN$X*\u00199!\u0003y)\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\u0014%o\\6feN+G/F\u0001f!\rqemR\u0005\u0003O>\u00131aU3u\u0003})\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\u0014%o\\6feN+G\u000fI\u0001&kB$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u!\u0006\u0014H/\u001b;j_:LeNZ8NCB,\u0012a\u001b\t\u0005\u001dNcw\u000f\u0005\u0002nk6\taN\u0003\u0002pa\u000611m\\7n_:T!\u0001I9\u000b\u0005I\u001c\u0018AB1qC\u000eDWMC\u0001u\u0003\ry'oZ\u0005\u0003m:\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002y\u0003+q1!_A\b\u001d\rQ\u00181\u0002\b\u0004w\u0006%ab\u0001?\u0002\b9\u0019Q0!\u0002\u000f\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t!I\u0001\u0007yI|w\u000e\u001e \n\u0003QL!A]:\n\u0005\u0001\n\u0018BA8q\u0013\r\tiA\\\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t\t\"a\u0005\u00023U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0004\u0003\u001bq\u0017\u0002BA\f\u00033\u0011A$\u00169eCR,W*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8Ti\u0006$XM\u0003\u0003\u0002\u0012\u0005M\u0011AJ;qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e)beRLG/[8o\u0013:4w.T1qA\u0005I1/\u001a8e\u000bZ,g\u000e\u001e\u000b\u0005\u0003C\t9\u0003E\u0002%\u0003GI1!!\n&\u0005\u0011)f.\u001b;\t\u000f\u0005%r\u00021\u0001\u0002,\u0005)QM^3oiB\u0019\u0001(!\f\n\u0007\u0005=RDA\bD_:$(o\u001c7mKJ,e/\u001a8u\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\u0011\u0005\u0005\u0012QGA\u001d\u0003SBa!a\u000e\u0011\u0001\u00049\u0015\u0001\u00032s_.,'/\u00133\t\u000f\u0005m\u0002\u00031\u0001\u0002>\u00059!/Z9vKN$\b\u0007BA \u0003/\u0002b!!\u0011\u0002N\u0005Mc\u0002BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001dc.\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\tY%!\u0012\u0002-\u0005\u00137\u000f\u001e:bGR\u001cuN\u001c;s_2\u0014V-];fgRLA!a\u0014\u0002R\t9!)^5mI\u0016\u0014(\u0002BA&\u0003\u000b\u0002B!!\u0016\u0002X1\u0001A\u0001DA-\u0003s\t\t\u0011!A\u0003\u0002\u0005m#aA0%iE!\u0011QLA2!\r!\u0013qL\u0005\u0004\u0003C*#a\u0002(pi\"Lgn\u001a\t\u0005\u0003\u0007\n)'\u0003\u0003\u0002h\u0005\u0015#AF!cgR\u0014\u0018m\u0019;D_:$(o\u001c7SKF,Xm\u001d;\t\u0013\u0005-\u0004\u0003%AA\u0002\u00055\u0014\u0001C2bY2\u0014\u0017mY6\u0011\u000f\u0011\ny'a\u001d\u0002\"%\u0019\u0011\u0011O\u0013\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA\"\u0003kJA!a\u001e\u0002F\t\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/Z\u0001\u0016g\u0016tGMU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tiH\u000b\u0003\u0002n\u0005}4FAAA!\u0011\t\u0019)!$\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0013\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-U%\u0001\u0006b]:|G/\u0019;j_:LA!a$\u0002\u0006\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u00119,wOQ1uG\"$\"!!\t\u0002-M,GoQ8oi\u0006Lgn]!mYJ+\u0007\u000f\\5dCN$B!!\t\u0002\u001a\"9\u00111T\nA\u0002\u0005u\u0015!\u00032s_.,'/\u00133t!\u0015\ty*!)H\u001b\u0005\t\u0016BA4R\u0003\u0015\u0019G.Z1s\u0003\u0001\nG\r\u001a'fC\u0012,'/\u00118e\u0013N\u0014(+Z9vKN$hi\u001c:Ce>\\WM]:\u0015\u0019\u0005\u0005\u0012\u0011VAY\u0003k\u000by,!3\t\u000f\u0005mU\u00031\u0001\u0002,B)\u0011qTAW\u000f&\u0019\u0011qV)\u0003\u0007M+\u0017\u000f\u0003\u0004\u00024V\u0001\r\u0001\\\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t9,\u0006a\u0001\u0003s\u000b1\u0004\\3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007c\u0001\u001d\u0002<&\u0019\u0011QX\u000f\u000371+\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2i\u0011\u001d\t\t-\u0006a\u0001\u0003\u0007\f\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u!\rA\u0014QY\u0005\u0004\u0003\u000fl\"!\u0005*fa2L7-Y!tg&<g.\\3oi\"9\u00111Z\u000bA\u0002\u00055\u0017!B5t\u001d\u0016<\bc\u0001\u0013\u0002P&\u0019\u0011\u0011[\u0013\u0003\u000f\t{w\u000e\\3b]\u0006y\u0012\r\u001a3Ti>\u0004(+\u001a9mS\u000e\f'+Z9vKN$hi\u001c:Ce>\\WM]:\u0015\u0011\u0005\u0005\u0012q[Am\u00037Dq!a'\u0017\u0001\u0004\tY\u000b\u0003\u0004\u00024Z\u0001\r\u0001\u001c\u0005\b\u0003;4\u0002\u0019AAg\u0003=!W\r\\3uKB\u000b'\u000f^5uS>t\u0017AI1eIV\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u001a{'O\u0011:pW\u0016\u00148\u000f\u0006\u0004\u0002\"\u0005\r\u0018Q\u001d\u0005\b\u00037;\u0002\u0019AAV\u0011\u001d\t9o\u0006a\u0001\u0003S\f!\u0002]1si&$\u0018n\u001c8t!\u0015\ty*!)m\u0003]\u0019XM\u001c3MK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cH\u000f\u0006\u0004\u0002\"\u0005=\u00181\u001f\u0005\u0007\u0003cD\u0002\u0019A$\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00129pG\"Da!!>\u0019\u0001\u0004a\u0014AD:uCR,7\t[1oO\u0016dunZ\u0001\u001bg\u0016tG-\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHo\u001d\u000b\u0007\u0003C\tY0!@\t\r\u0005E\u0018\u00041\u0001H\u0011\u0019\t)0\u0007a\u0001y\u000592/\u001a8e'R|\u0007OU3qY&\u001c\u0017MU3rk\u0016\u001cHo\u001d\u000b\u0005\u0003C\u0011\u0019\u0001\u0003\u0004\u0002rj\u0001\raR\u0001\u0016g\u0016tGMU3rk\u0016\u001cHo\u001d+p\u0005J|7.\u001a:t)\u0011\t\tC!\u0003\t\r\u0005E8\u00041\u0001H\u0001")
public abstract class AbstractControllerBrokerRequestBatch
implements Logging {
    private final KafkaConfig config;
    private final ControllerContext controllerContext;
    private final StateChangeLogger stateChangeLogger;
    private final int controllerId;
    private final scala.collection.mutable.Map<Object, LeaderAndIsrRequestInfo> leaderAndIsrRequestMap;
    private final scala.collection.mutable.Map<Object, ListBuffer<StopReplicaRequestInfo>> stopReplicaRequestMap;
    private final scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet;
    private final scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> updateMetadataRequestPartitionInfoMap;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public scala.collection.mutable.Map<Object, LeaderAndIsrRequestInfo> leaderAndIsrRequestMap() {
        return this.leaderAndIsrRequestMap;
    }

    public scala.collection.mutable.Map<Object, ListBuffer<StopReplicaRequestInfo>> stopReplicaRequestMap() {
        return this.stopReplicaRequestMap;
    }

    public scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet() {
        return this.updateMetadataRequestBrokerSet;
    }

    public scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> updateMetadataRequestPartitionInfoMap() {
        return this.updateMetadataRequestPartitionInfoMap;
    }

    public abstract void sendEvent(ControllerEvent var1);

    public abstract void sendRequest(int var1, AbstractControlRequest.Builder<? extends AbstractControlRequest> var2, Function1<AbstractResponse, BoxedUnit> var3);

    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$3() {
        return null;
    }

    public void newBatch() {
        if (this.leaderAndIsrRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(135).append("Controller to broker state change requests batch is not empty while creating ").append("a new one. Some LeaderAndIsr state changes ").append(this.leaderAndIsrRequestMap()).append(" might be lost ").toString());
        }
        if (this.stopReplicaRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(134).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. Some StopReplica state changes ").append(this.stopReplicaRequestMap()).append(" might be lost ").toString());
        }
        if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(169).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. Some UpdateMetadata state changes to brokers ").append(this.updateMetadataRequestBrokerSet()).append(" with partition info ").append(this.updateMetadataRequestPartitionInfoMap()).append(" might be lost ").toString());
        }
    }

    public void setContainsAllReplicas(Set<Object> brokerIds) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            Option currentInfoOpt = this.leaderAndIsrRequestMap().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (currentInfoOpt == null) {
                throw null;
            }
            Object object = currentInfoOpt.isEmpty() ? None$.MODULE$ : new Some((Object)((LeaderAndIsrRequestInfo)currentInfoOpt.get()).copy(true, ((LeaderAndIsrRequestInfo)currentInfoOpt.get()).copy$default$2()));
            if (object == null) {
                throw null;
            }
            Object object2 = object.isEmpty() ? AbstractControllerBrokerRequestBatch.$anonfun$setContainsAllReplicas$3() : object.get();
            LeaderAndIsrRequestInfo updatedInfo = (LeaderAndIsrRequestInfo)object2;
            this.leaderAndIsrRequestMap().update((Object)BoxesRunTime.boxToInteger((int)brokerId), (Object)updatedInfo);
        });
    }

    public void clear() {
        this.leaderAndIsrRequestMap().clear();
        this.stopReplicaRequestMap().clear();
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
    }

    public void addLeaderAndIsrRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, ReplicaAssignment replicaAssignment, boolean isNew) {
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 >= 0)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> AbstractControllerBrokerRequestBatch.$anonfun$addLeaderAndIsrRequestForBrokers$2(this, topicPartition, leaderIsrAndControllerEpoch, replicaAssignment, isNew, BoxesRunTime.unboxToInt((Object)brokerId)));
        this.addUpdateMetadataRequestForBrokers((Seq<Object>)this.controllerContext.liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
    }

    public void addStopReplicaRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, boolean deletePartition) {
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$7 -> x$7 >= 0)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> ((ListBuffer)this.stopReplicaRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.empty())).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StopReplicaRequestInfo[]{new StopReplicaRequestInfo(new PartitionAndReplica(topicPartition, brokerId), deletePartition)})));
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, Set<TopicPartition> partitions) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((TraversableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 >= 0));
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            this.updateMetadataRequestPartitionInfo$1(partition, this.controllerContext.topicsToBeDeleted().contains((Object)partition.topic()));
            return BoxedUnit.UNIT;
        });
    }

    private void sendLeaderAndIsrRequest(int controllerEpoch, StateChangeLogger stateChangeLog) {
        short leaderAndIsrRequestVersion = this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_4_IV1$.MODULE$) ? (short)4 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_4_IV0$.MODULE$) ? (short)3 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? (short)2 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_1_0_IV0$.MODULE$) ? (short)1 : 0)));
        this.leaderAndIsrRequestMap().filterKeys((Function1)((JFunction1.mcZI.sp & Serializable & scala.Serializable)arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$1(this.controllerContext.liveOrShuttingDownBrokerIds(), arg_0))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$2(this, stateChangeLog, leaderAndIsrRequestVersion, controllerEpoch, x0$1);
            return BoxedUnit.UNIT;
        });
        this.leaderAndIsrRequestMap().clear();
    }

    private void sendUpdateMetadataRequests(int controllerEpoch, StateChangeLogger stateChangeLog) {
        this.updateMetadataRequestPartitionInfoMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$1(this, stateChangeLog, x0$1);
            return BoxedUnit.UNIT;
        });
        Buffer partitionStates = this.updateMetadataRequestPartitionInfoMap().values().toBuffer();
        int updateMetadataRequestVersion = this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_4_IV1$.MODULE$) ? 6 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? 5 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_1_0_IV0$.MODULE$) ? 4 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_2_IV0$.MODULE$) ? 3 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV1$.MODULE$) ? 2 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0)))));
        Buffer liveBrokers = this.controllerContext.liveOrShuttingDownBrokers().iterator().map(arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$3((short)updateMetadataRequestVersion, arg_0)).toBuffer();
        ((IterableLike)this.updateMetadataRequestBrokerSet().intersect(this.controllerContext.liveOrShuttingDownBrokerIds())).foreach((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$5(this, (short)updateMetadataRequestVersion, controllerEpoch, partitionStates, liveBrokers, arg_0)));
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
    }

    private void sendStopReplicaRequests(int controllerEpoch) {
        short stopReplicaRequestVersion = this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_4_IV1$.MODULE$) ? (short)2 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? (short)1 : 0);
        this.stopReplicaRequestMap().filterKeys((Function1)((JFunction1.mcZI.sp & Serializable & scala.Serializable)arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$4(this.controllerContext.liveOrShuttingDownBrokerIds(), arg_0))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$5(this, stopReplicaRequestVersion, controllerEpoch, x0$1);
            return BoxedUnit.UNIT;
        });
        this.stopReplicaRequestMap().clear();
    }

    public void sendRequestsToBrokers(int controllerEpoch) {
        try {
            StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(controllerEpoch);
            this.sendLeaderAndIsrRequest(controllerEpoch, stateChangeLog);
            this.sendUpdateMetadataRequests(controllerEpoch, stateChangeLog);
            this.sendStopReplicaRequests(controllerEpoch);
            return;
        }
        catch (Throwable e) {
            if (this.leaderAndIsrRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Haven't been able to send leader and isr requests, current state of ").append("the map is ").append(this.leaderAndIsrRequestMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Haven't been able to send metadata update requests to brokers ").append(this.updateMetadataRequestBrokerSet()).append(", ").append("current state of the partition info is ").append(this.updateMetadataRequestPartitionInfoMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.stopReplicaRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(98).append("Haven't been able to send stop replica requests, current state of ").append("the map is ").append(this.stopReplicaRequestMap()).append(". Exception message: ").append(e).toString());
            }
            throw new IllegalStateException(e);
        }
    }

    public static final /* synthetic */ LeaderAndIsrRequestInfo $anonfun$setContainsAllReplicas$3() {
        return new LeaderAndIsrRequestInfo(true, (scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>)Map$.MODULE$.empty());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$addLeaderAndIsrRequestForBrokers$2(AbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$1, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, ReplicaAssignment replicaAssignment$1, boolean isNew$1, int brokerId) {
        Object object;
        void map_bf;
        scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState> result = ((LeaderAndIsrRequestInfo)$this.leaderAndIsrRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> new LeaderAndIsrRequestInfo(false, (scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>)Map$.MODULE$.empty()))).partitionStates();
        Option option = result.get((Object)topicPartition$1);
        if (option == null) {
            throw null;
        }
        Option exists_this = option;
        boolean bl = !exists_this.isEmpty() && ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)exists_this.get()).isNew();
        LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch$1.leaderAndIsr();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topicPartition$1.topic()).setPartitionIndex(topicPartition$1.partition()).setControllerEpoch(leaderIsrAndControllerEpoch$1.controllerEpoch()).setLeader(leaderAndIsr.leader()).setLeaderEpoch(leaderAndIsr.leaderEpoch());
        List<Object> list = leaderAndIsr.isr();
        CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1);
        if (list == null) {
            throw null;
        }
        List<Object> map_this = list;
        if (map_bf == List$.MODULE$.ReusableCBF()) {
            if (map_this == Nil$.MODULE$) {
                object = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                .colon.colon map_t = map_h = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)map_this.head()), (List)Nil$.MODULE$);
                for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    .colon.colon map_nx = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)map_rest.head()), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object = map_h;
            }
        } else {
            void map_f;
            object = TraversableLike.map$(map_this, (Function1)map_f, (CanBuildFrom)map_bf);
        }
        return result.put((Object)topicPartition$1, (Object)leaderAndIsrPartitionState.setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)object).asJava()).setZkVersion(leaderAndIsr.zkVersion()).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.replicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setAddingReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.addingReplicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setRemovingReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.removingReplicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setObservers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.effectiveObservers().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setIsNew(isNew$1 || bl));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateMetadataRequestPartitionInfo$1(TopicPartition partition, boolean beingDeleted) {
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
        Option option = this.controllerContext.partitionLeadershipInfo().get((Object)partition);
        if (option instanceof Some && (leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value()) != null) {
            Object object;
            void map_bf;
            LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
            int controllerEpoch = leaderIsrAndControllerEpoch.controllerEpoch();
            ReplicaAssignment replicaAssignment = this.controllerContext.partitionFullReplicaAssignment(partition);
            Seq<Object> replicas = replicaAssignment.replicas();
            Seq offlineReplicas = (Seq)replicas.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> !$this.controllerContext.isReplicaOnline(x$8, partition, $this.controllerContext.isReplicaOnline$default$3()));
            LeaderAndIsr updatedLeaderAndIsr = beingDeleted ? LeaderAndIsr$.MODULE$.duringDelete(leaderAndIsr.isr()) : leaderAndIsr;
            UpdateMetadataRequestData.UpdateMetadataPartitionState updateMetadataPartitionState = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(partition.topic()).setPartitionIndex(partition.partition()).setControllerEpoch(controllerEpoch).setLeader(updatedLeaderAndIsr.leader()).setLeaderEpoch(updatedLeaderAndIsr.leaderEpoch());
            List<Object> list = updatedLeaderAndIsr.isr();
            CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1);
            if (list == null) {
                throw null;
            }
            List<Object> map_this = list;
            if (map_bf == List$.MODULE$.ReusableCBF()) {
                if (map_this == Nil$.MODULE$) {
                    object = Nil$.MODULE$;
                } else {
                    .colon.colon map_h;
                    .colon.colon map_t = map_h = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)map_this.head()), (List)Nil$.MODULE$);
                    for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                        .colon.colon map_nx = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)map_rest.head()), (List)Nil$.MODULE$);
                        map_t.tl_$eq((List)map_nx);
                        map_t = map_nx;
                    }
                    object = map_h;
                }
            } else {
                void map_f;
                object = TraversableLike.map$(map_this, (Function1)map_f, (CanBuildFrom)map_bf);
            }
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionStateInfo = updateMetadataPartitionState.setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)object).asJava()).setZkVersion(updatedLeaderAndIsr.zkVersion()).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setOfflineReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)offlineReplicas.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setObservers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment.effectiveObservers().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava());
            this.updateMetadataRequestPartitionInfoMap().put((Object)partition, (Object)partitionStateInfo);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Leader not yet assigned for partition ").append(partition).append(". Skip sending UpdateMetadataRequest.").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$sendLeaderAndIsrRequest$1(Set eta$0$1$1, int elem) {
        return eta$0$1$1.contains((Object)BoxesRunTime.boxToInteger((int)elem));
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$3(int broker$2, StateChangeLogger stateChangeLog$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState state = (LeaderAndIsrRequestData.LeaderAndIsrPartitionState)x0$2._2();
            String typeOfRequest = broker$2 == state.leader() ? "become-leader" : "become-follower";
            stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Sending ").append(typeOfRequest).append(" LeaderAndIsr request ").append(state).append(" to broker ").append(broker$2).append(" for partition ").append(topicPartition).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$sendLeaderAndIsrRequest$5(Tuple2 x$10) {
        return ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)x$10._2()).leader();
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$9(AbstractControllerBrokerRequestBatch $this, int broker$2, AbstractResponse r) {
        LeaderAndIsrResponse leaderAndIsrResponse = (LeaderAndIsrResponse)r;
        $this.sendEvent(new LeaderAndIsrResponseReceived(leaderAndIsrResponse, broker$2));
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$2(AbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int broker = x0$1._1$mcI$sp();
            LeaderAndIsrRequestInfo leaderAndIsrRequestInfo = (LeaderAndIsrRequestInfo)x0$1._2();
            scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState> leaderAndIsrPartitionStates = leaderAndIsrRequestInfo.partitionStates();
            boolean containsAllReplicas = leaderAndIsrRequestInfo.containsAllReplicas();
            if (stateChangeLog$1.isTraceEnabled()) {
                leaderAndIsrPartitionStates.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$3(broker, stateChangeLog$1, x0$2);
                    return BoxedUnit.UNIT;
                });
            }
            scala.collection.immutable.Set leaderIds = ((TraversableOnce)leaderAndIsrPartitionStates.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$5(x$10)), Iterable$.MODULE$.canBuildFrom())).toSet();
            Set leaders = (Set)((SetLike)$this.controllerContext.liveOrShuttingDownBrokers().filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)leaderIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.node($this.config.interBrokerListenerName()), Set$.MODULE$.canBuildFrom());
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
            if (Predef$.MODULE$.Boolean2boolean($this.config.tierFeature())) {
                leaderAndIsrPartitionStates.values().foreach((Function1 & Serializable & scala.Serializable)partitionState -> partitionState.setTopicId((UUID)$this.controllerContext.topicIds().apply((Object)partitionState.topicName())));
            }
            boolean useConfluentRequest = Predef$.MODULE$.Boolean2boolean($this.config.tierFeature()) && $this.config.interBrokerProtocolVersion().$less(KAFKA_2_4_IV1$.MODULE$);
            LeaderAndIsrRequest.Builder leaderAndIsrRequestBuilder = LeaderAndIsrRequest.Builder.create((short)leaderAndIsrRequestVersion$1, (int)$this.controllerId(), (int)controllerEpoch$1, (long)brokerEpoch, (java.util.List)((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(leaderAndIsrPartitionStates.values().toBuffer()).asJava()), (Collection)((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter(leaders).asJava()), (boolean)containsAllReplicas, (boolean)useConfluentRequest);
            $this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)leaderAndIsrRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)r -> {
                AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$9($this, broker, r);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$1(AbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$1._2();
            stateChangeLog$2.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Sending UpdateMetadata request ").append(partitionState).append(" to brokers ").append($this.updateMetadataRequestBrokerSet()).append(" ").append("for partition ").append(tp).toString());
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$sendUpdateMetadataRequests$3(short updateMetadataRequestVersion$1, Broker broker) {
        void orNull_ev;
        Seq seq;
        if (updateMetadataRequestVersion$1 == 0) {
            SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
            ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
            Node node = broker.node(listenerName);
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(node.host()).setPort(node.port()).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value())}));
        } else {
            seq = (Seq)broker.endPoints().map((Function1 & Serializable & scala.Serializable)endpoint -> new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(endpoint.host()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id).setListener(endpoint.listenerName().value()), Seq$.MODULE$.canBuildFrom());
        }
        Seq endpoints = seq;
        Option<String> option = broker.rack();
        Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
        if (option == null) {
            throw null;
        }
        Option<String> orNull_this = option;
        Object object = orNull_this.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : orNull_this.get();
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(broker.id()).setEndpoints((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(endpoints).asJava()).setRack((String)object);
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$6(AbstractControllerBrokerRequestBatch $this, int broker$3, AbstractResponse r) {
        UpdateMetadataResponse updateMetadataResponse = (UpdateMetadataResponse)r;
        $this.sendEvent(new UpdateMetadataResponseReceived(updateMetadataResponse, broker$3));
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$5(AbstractControllerBrokerRequestBatch $this, short updateMetadataRequestVersion$1, int controllerEpoch$2, Buffer partitionStates$1, Buffer liveBrokers$1, int broker) {
        long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
        UpdateMetadataRequest.Builder updateMetadataRequestBuilder = new UpdateMetadataRequest.Builder(updateMetadataRequestVersion$1, $this.controllerId(), controllerEpoch$2, brokerEpoch, (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionStates$1).asJava(), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(liveBrokers$1).asJava());
        $this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)updateMetadataRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)r -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$6($this, broker, r);
            return BoxedUnit.UNIT;
        });
    }

    private final void stopReplicaPartitionDeleteResponseCallback$1(int brokerId, AbstractResponse response) {
        StopReplicaResponse stopReplicaResponse = (StopReplicaResponse)response;
        scala.collection.immutable.Map partitionErrorsForDeletingTopics = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stopReplicaResponse.partitionErrors()).asScala()).iterator().filter((Function1 & Serializable & scala.Serializable)pe -> BoxesRunTime.boxToBoolean((boolean)this.controllerContext.isTopicDeletionInProgress(pe.topicName()))).map((Function1 & Serializable & scala.Serializable)pe -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Errors errors = Errors.forCode((short)pe.errorCode());
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(pe.topicName(), pe.partitionIndex()));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }).toMap(Predef$.MODULE$.$conforms());
        if (partitionErrorsForDeletingTopics.nonEmpty()) {
            this.sendEvent(new TopicDeletionStopReplicaResponseReceived(brokerId, stopReplicaResponse.error(), (Map<TopicPartition, Errors>)partitionErrorsForDeletingTopics));
        }
    }

    private final StopReplicaRequest.Builder createStopReplicaRequest$1(long brokerEpoch, Seq requests, boolean deletePartitions, short stopReplicaRequestVersion$1, int controllerEpoch$3) {
        java.util.List partitions = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requests.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.replica().topicPartition(), Seq$.MODULE$.canBuildFrom())).asJava();
        return new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, this.controllerId(), controllerEpoch$3, brokerEpoch, deletePartitions, (Collection)partitions);
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$4(Set eta$0$1$2, int elem) {
        return eta$0$1$2.contains((Object)BoxesRunTime.boxToInteger((int)elem));
    }

    public static final /* synthetic */ String $anonfun$sendStopReplicaRequests$7(int brokerId$2, ListBuffer stopReplicaWithDelete$1) {
        return new StringBuilder(60).append("The stop replica request (delete = true) sent to broker ").append(brokerId$2).append(" is ").append(stopReplicaWithDelete$1.mkString(",")).toString();
    }

    public static final /* synthetic */ String $anonfun$sendStopReplicaRequests$9(int brokerId$2, ListBuffer stopReplicaWithoutDelete$1) {
        return new StringBuilder(61).append("The stop replica request (delete = false) sent to broker ").append(brokerId$2).append(" is ").append(stopReplicaWithoutDelete$1.mkString(",")).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$5(AbstractControllerBrokerRequestBatch $this, short stopReplicaRequestVersion$1, int controllerEpoch$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            void var7_11;
            void var6_10;
            void partition_p;
            int brokerId = x0$1._1$mcI$sp();
            ListBuffer replicaInfoList = (ListBuffer)x0$1._2();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)r.deletePartition());
            if (replicaInfoList == null) {
                throw null;
            }
            Builder partition_l = replicaInfoList.newBuilder();
            Builder partition_r = replicaInfoList.newBuilder();
            replicaInfoList.foreach(arg_0 -> TraversableLike.$anonfun$partition$1((Function1)partition_p, (Builder)partition_l, (Builder)partition_r, arg_0));
            Object object = partition_r.result();
            ListBuffer stopReplicaWithDelete = (ListBuffer)partition_l.result();
            ListBuffer stopReplicaWithoutDelete = (ListBuffer)object;
            void stopReplicaWithDelete2 = var6_10;
            void stopReplicaWithoutDelete2 = var7_11;
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
            if (stopReplicaWithDelete2.nonEmpty()) {
                $this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$7(brokerId, (ListBuffer)stopReplicaWithDelete2)));
                StopReplicaRequest.Builder stopReplicaRequest = $this.createStopReplicaRequest$1(brokerEpoch, (Seq)stopReplicaWithDelete2, true, stopReplicaRequestVersion$1, controllerEpoch$3);
                Function1 & Serializable & scala.Serializable callback = (Function1 & Serializable & scala.Serializable)response -> {
                    $this.stopReplicaPartitionDeleteResponseCallback$1(brokerId, response);
                    return BoxedUnit.UNIT;
                };
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequest, (Function1<AbstractResponse, BoxedUnit>)callback);
            }
            if (stopReplicaWithoutDelete2.nonEmpty()) {
                $this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$9(brokerId, (ListBuffer)stopReplicaWithoutDelete2)));
                StopReplicaRequest.Builder stopReplicaRequest = $this.createStopReplicaRequest$1(brokerEpoch, (Seq)stopReplicaWithoutDelete2, false, stopReplicaRequestVersion$1, controllerEpoch$3);
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequest, $this.sendRequest$default$3());
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public AbstractControllerBrokerRequestBatch(KafkaConfig config, ControllerContext controllerContext, StateChangeLogger stateChangeLogger) {
        this.config = config;
        this.controllerContext = controllerContext;
        this.stateChangeLogger = stateChangeLogger;
        Logging.$init$(this);
        this.controllerId = config.brokerId();
        this.leaderAndIsrRequestMap = Map$.MODULE$.empty();
        this.stopReplicaRequestMap = Map$.MODULE$.empty();
        this.updateMetadataRequestBrokerSet = scala.collection.mutable.Set$.MODULE$.empty();
        this.updateMetadataRequestPartitionInfoMap = Map$.MODULE$.empty();
    }

    public static final /* synthetic */ Object $anonfun$addLeaderAndIsrRequestForBrokers$4$adapted(LeaderAndIsrRequestData.LeaderAndIsrPartitionState x$6) {
        return BoxesRunTime.boxToBoolean((boolean)x$6.isNew());
    }
}

