/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.ZkPartitionStateStore;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ReplicaManager;
import kafka.tier.TierReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Partition$
implements KafkaMetricsGroup {
    public static Partition$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new Partition$();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Partition apply(TopicPartition topicPartition, Time time, ReplicaManager replicaManager) {
        ZkPartitionStateStore zkIsrBackingStore = new ZkPartitionStateStore(topicPartition, replicaManager.zkClient(), replicaManager);
        DelayedOperations delayedOperations = new DelayedOperations(topicPartition, replicaManager.delayedProducePurgatory(), replicaManager.delayedFetchPurgatory(), replicaManager.delayedDeleteRecordsPurgatory());
        return new Partition(topicPartition, Predef$.MODULE$.Long2long(replicaManager.config().replicaLagTimeMaxMs()), replicaManager.config().interBrokerProtocolVersion(), replicaManager.config().brokerId(), time, zkIsrBackingStore, delayedOperations, replicaManager.metadataCache(), replicaManager.logManager(), replicaManager.tierReplicaComponents().replicaManagerOpt());
    }

    /*
     * WARNING - void declaration
     */
    public void removeMetrics(TopicPartition topicPartition) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Tuple2[] tuple2Array = new Tuple2[2];
        String string = topicPartition.topic();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"topic");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string2 = ((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())).toString();
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"partition");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map tags = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.removeMetric("UnderReplicated", (Map<String, String>)tags);
        this.removeMetric("UnderMinIsr", (Map<String, String>)tags);
        this.removeMetric("InSyncReplicasCount", (Map<String, String>)tags);
        this.removeMetric("CaughtUpReplicasCount", (Map<String, String>)tags);
        this.removeMetric("ReplicasCount", (Map<String, String>)tags);
        this.removeMetric("LastStableOffsetLag", (Map<String, String>)tags);
        this.removeMetric("AtMinIsr", (Map<String, String>)tags);
        this.removeMetric("IsNotCaughtUp", (Map<String, String>)tags);
        this.removeMetric("ObserverReplicasCount", (Map<String, String>)tags);
    }

    public void deleteLog(TopicPartition topicPartition, LogManager logManager, Option<TierReplicaManager> tierReplicaManagerOpt) {
        Option<AbstractLog> option = logManager.getLog(topicPartition, logManager.getLog$default$2());
        if (option == null) {
            throw null;
        }
        Option<AbstractLog> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            AbstractLog abstractLog = (AbstractLog)foreach_this.get();
            Partition$.$anonfun$deleteLog$3(logManager, topicPartition, tierReplicaManagerOpt, abstractLog);
        }
        Option<AbstractLog> option2 = logManager.getLog(topicPartition, true);
        if (option2 == null) {
            throw null;
        }
        Option<AbstractLog> foreach_this2 = option2;
        if (!foreach_this2.isEmpty()) {
            AbstractLog abstractLog = (AbstractLog)foreach_this2.get();
            Partition$.$anonfun$deleteLog$4(logManager, topicPartition, tierReplicaManagerOpt, abstractLog);
        }
    }

    public static final /* synthetic */ void $anonfun$deleteLog$1(AbstractLog log$1, Option tierReplicaManagerOpt$1, TopicIdPartition topicIdPartition) {
        log$1.stopTierMaterialization();
        if (tierReplicaManagerOpt$1 == null) {
            throw null;
        }
        if (!tierReplicaManagerOpt$1.isEmpty()) {
            TierReplicaManager tierReplicaManager = (TierReplicaManager)tierReplicaManagerOpt$1.get();
            tierReplicaManager.delete(topicIdPartition);
            return;
        }
    }

    private static final void maybeDeleteTieredLog$1(AbstractLog log, Option tierReplicaManagerOpt$1) {
        Option<TopicIdPartition> option = log.topicIdPartition();
        if (option == null) {
            throw null;
        }
        Option<TopicIdPartition> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            TopicIdPartition topicIdPartition = (TopicIdPartition)foreach_this.get();
            Partition$.$anonfun$deleteLog$1(log, tierReplicaManagerOpt$1, topicIdPartition);
            return;
        }
    }

    public static final /* synthetic */ Option $anonfun$deleteLog$3(LogManager logManager$1, TopicPartition topicPartition$1, Option tierReplicaManagerOpt$1, AbstractLog log) {
        Partition$.maybeDeleteTieredLog$1(log, tierReplicaManagerOpt$1);
        return logManager$1.asyncDelete(topicPartition$1, logManager$1.asyncDelete$default$2());
    }

    public static final /* synthetic */ Option $anonfun$deleteLog$4(LogManager logManager$1, TopicPartition topicPartition$1, Option tierReplicaManagerOpt$1, AbstractLog log) {
        Partition$.maybeDeleteTieredLog$1(log, tierReplicaManagerOpt$1);
        return logManager$1.asyncDelete(topicPartition$1, true);
    }

    private Partition$() {
        MODULE$ = this;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$deleteLog$2$adapted(TopicIdPartition topicIdPartition$1, TierReplicaManager x$2) {
        x$2.delete(topicIdPartition$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$deleteLog$1$adapted(AbstractLog log$1, Option tierReplicaManagerOpt$1, TopicIdPartition topicIdPartition) {
        Partition$.$anonfun$deleteLog$1(log$1, tierReplicaManagerOpt$1, topicIdPartition);
        return BoxedUnit.UNIT;
    }
}

