/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class Observer$ {
    public static Observer$ MODULE$;

    static {
        new Observer$();
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, ReplicaAssignment> getReplicaAssignment(Seq<BrokerMetadata> brokers, Option<TopicPlacement> topicPlacement, int numPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        void var9_12;
        void var8_11;
        None$ none$;
        if (topicPlacement == null) {
            throw null;
        }
        if (topicPlacement.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            TopicPlacement topicPlacement2 = (TopicPlacement)topicPlacement.get();
            none$ = new Some((Object)Observer$.$anonfun$getReplicaAssignment$1(brokers, topicPlacement2));
        }
        if (none$ == null) {
            throw null;
        }
        Object object = none$.isEmpty() ? Observer$.$anonfun$getReplicaAssignment$2(replicationFactor, brokers) : none$.get();
        Tuple2 tuple2 = (Tuple2)object;
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq replicationAndSyncEligible = (Seq)tuple2._1();
        Seq replicationAndObserverEligible = (Seq)tuple2._2();
        void replicationAndSyncEligible2 = var8_11;
        void replicationAndObserverEligible2 = var9_12;
        this.validatePartitioning((Seq<Tuple2<Object, Seq<BrokerMetadata>>>)((Seq)replicationAndSyncEligible2.$plus$plus((GenTraversableOnce)replicationAndObserverEligible2, Seq$.MODULE$.canBuildFrom())));
        return this.partitionReplicaAssignment((Map<Object, Seq<Object>>)this.assignReplicasToPartitions((Seq<Tuple2<Object, Seq<BrokerMetadata>>>)replicationAndSyncEligible2, numPartitions, fixedStartIndex, startPartitionId), (Map<Object, Seq<Object>>)this.assignReplicasToPartitions((Seq<Tuple2<Object, Seq<BrokerMetadata>>>)replicationAndObserverEligible2, numPartitions, fixedStartIndex, startPartitionId));
    }

    public int getReplicaAssignment$default$5() {
        return -1;
    }

    public int getReplicaAssignment$default$6() {
        return -1;
    }

    private scala.collection.mutable.Map<Object, Seq<Object>> assignReplicasToPartitions(Seq<Tuple2<Object, Seq<BrokerMetadata>>> replicationAndBrokers, int partitions, int fixedStartIndex, int startPartitionId) {
        return (scala.collection.mutable.Map)((TraversableOnce)replicationAndBrokers.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int replication = x0$1._1$mcI$sp();
            Seq brokerList = (Seq)x0$1._2();
            Map<Object, Seq<Object>> map = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)brokerList, partitions, replication, fixedStartIndex, startPartitionId);
            return map;
        }, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)Map$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(mergedAssignment, currentAssignment) -> MODULE$.mergeAssignmentMap((scala.collection.mutable.Map<Object, Seq<Object>>)mergedAssignment, (Map<Object, Seq<Object>>)currentAssignment));
    }

    private Map<Object, ReplicaAssignment> partitionReplicaAssignment(Map<Object, Seq<Object>> syncReplicas, Map<Object, Seq<Object>> observerReplicas) {
        if (observerReplicas.nonEmpty()) {
            Set set = syncReplicas.keySet();
            Set set2 = observerReplicas.keySet();
            if (set == null ? set2 != null : !set.equals(set2)) {
                int syncSize = syncReplicas.keySet().size();
                int observerSize = observerReplicas.keySet().size();
                throw new InvalidConfigurationException(new StringBuilder(115).append("Must assign observers to all or none of the partitions. ").append(syncSize).append(" partitions with sync replicas. ").append(observerSize).append(" partitions with observers.").toString());
            }
        }
        return (Map)syncReplicas.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                int partition = x0$1._1$mcI$sp();
                Seq replicas = (Seq)x0$1._2();
                Seq observerAssignment = (Seq)observerReplicas.getOrElse((Object)BoxesRunTime.boxToInteger((int)partition), (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
                ReplicaAssignment replicaAssignment = ReplicaAssignment$.MODULE$.apply((Seq<Object>)((Seq)replicas.$plus$plus((GenTraversableOnce)observerAssignment, Seq$.MODULE$.canBuildFrom())), (Seq<Object>)observerAssignment);
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<Object, Seq<BrokerMetadata>>> partitionBrokersByConstraint(Seq<BrokerMetadata> brokers, Seq<TopicPlacement.ConstraintCount> constraints) {
        return (Seq)constraints.map((Function1 & Serializable & scala.Serializable)constraint -> {
            Seq matchedBrokers = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, constraint)));
            if (matchedBrokers.size() < constraint.count()) {
                throw new InvalidConfigurationException(new StringBuilder(75).append("Number of broker found (").append(matchedBrokers.size()).append(") matching ").append("constraint ").append(constraint).append(" is less than required count ").append(constraint.count()).toString());
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)constraint.count()), (Object)matchedBrokers);
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public void validatePartitioning(Seq<Tuple2<Object, Seq<BrokerMetadata>>> partitionedBrokers) {
        void var4_4;
        void var3_3;
        Tuple2 tuple2 = (Tuple2)partitionedBrokers.foldLeft((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Predef$.MODULE$.Set().empty()), (Function2 & Serializable & scala.Serializable)(acc, current) -> {
            void var3_3;
            void var2_2;
            void var4_4;
            if (acc == null) {
                throw new MatchError(null);
            }
            int count = acc._1$mcI$sp();
            scala.collection.immutable.Set allBrokers = (scala.collection.immutable.Set)acc._2();
            if (current == null) {
                throw new MatchError(null);
            }
            Seq brokers = (Seq)current._2();
            if (var4_4.toSet().size() != var4_4.size()) {
                throw new InvalidConfigurationException(new StringBuilder(58).append("Duplicate eligible brokers ").append(var4_4).append(" match a placement constraints.").toString());
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)(var2_2 + var4_4.size())), (Object)var3_3.$plus$plus((GenTraversableOnce)var4_4));
        });
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int count = tuple2._1$mcI$sp();
        scala.collection.immutable.Set allBrokers = (scala.collection.immutable.Set)tuple2._2();
        if (var3_3 != var4_4.size()) {
            throw new InvalidConfigurationException(new StringBuilder(58).append("Some brokers satisfy more than one placement constraints: ").append(partitionedBrokers).toString());
        }
    }

    public scala.collection.mutable.Map<Object, Seq<Object>> mergeAssignmentMap(scala.collection.mutable.Map<Object, Seq<Object>> mergedAssignment, Map<Object, Seq<Object>> currentAssignment) {
        return mergedAssignment.$plus$plus((GenTraversableOnce)currentAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                int partitionId = x0$1._1$mcI$sp();
                Seq replicaIds = (Seq)x0$1._2();
                Seq<Object> seq = MODULE$.mergeReplicaLists((Seq<Object>)((Seq)mergedAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)partitionId), (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty())), (Seq<Object>)replicaIds);
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom()));
    }

    public Seq<Object> mergeReplicaLists(Seq<Object> brokerList1, Seq<Object> brokerList2) {
        SeqView commonReplicas = brokerList1.view().intersect(brokerList2);
        if (commonReplicas.nonEmpty()) {
            throw new InvalidConfigurationException(new StringBuilder(64).append("Replica with ids (").append(commonReplicas.force(Seq$.MODULE$.canBuildFrom())).append(") satisfy more than one placement constraints.").toString());
        }
        return (Seq)brokerList1.$plus$plus(brokerList2, Seq$.MODULE$.canBuildFrom());
    }

    public boolean brokerMatchesPlacementConstraint(BrokerMetadata broker, TopicPlacement.ConstraintCount constraint) {
        Option<String> option = broker.rack();
        if (option == null) {
            throw null;
        }
        Option<String> map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)Observer$.$anonfun$brokerMatchesPlacementConstraint$1((String)map_this.get()));
        scala.collection.immutable.Map properties = Option$.MODULE$.option2Iterable((Option)object).toMap(Predef$.MODULE$.$conforms());
        return constraint.matches((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)properties).asJava());
    }

    public Option<ApiError> validateAssignment(Option<TopicPlacement> topicPlacement, ReplicaAssignment.Assignment assignment, Map<Object, Map<String, String>> liveBrokerAttributes) {
        Option option = this.validateAssignmentStructure(assignment);
        if (option == null) {
            throw null;
        }
        Option orElse_this = option;
        Option option2 = orElse_this.isEmpty() ? Observer$.$anonfun$validateAssignment$1(topicPlacement, assignment, liveBrokerAttributes) : orElse_this;
        return option2;
    }

    public Option<ApiError> validateAssignmentStructure(ReplicaAssignment.Assignment assignment) {
        Seq<Object> replicas = assignment.replicas();
        scala.collection.immutable.Set replicaSet = replicas.toSet();
        if (replicas.isEmpty() || replicas.size() != replicaSet.size()) {
            return new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringBuilder(57).append("Duplicate replicas not allowed in partition assignment: ").append(replicas.mkString(", ")).append(".").toString()));
        }
        if (replicas.exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 < 0)) {
            return new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringBuilder(44).append("Invalid replica id in partition assignment: ").append(replicas.mkString(", ")).toString()));
        }
        if (!assignment.replicas().endsWith(assignment.observers())) {
            String observerMsg = assignment.observers().mkString(", ");
            return new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringBuilder(85).append("Assignment contains observers (").append(observerMsg).append(") and the replicas' (").append(replicas.mkString(", ")).append(") ").append("suffix doesn't match observers.").toString()));
        }
        return None$.MODULE$;
    }

    public Option<ApiError> validateReassignment(Option<TopicPlacement> topicPlacement, ReplicaAssignment reassignment, Map<Object, Map<String, String>> liveBrokerAttributes) {
        None$ none$;
        Option<ReplicaAssignment.Assignment> option = reassignment.targetAssignment();
        if (option == null) {
            throw null;
        }
        Option<ReplicaAssignment.Assignment> flatMap_this = option;
        if (flatMap_this.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            ReplicaAssignment.Assignment assignment = (ReplicaAssignment.Assignment)flatMap_this.get();
            none$ = Observer$.$anonfun$validateReassignment$1(topicPlacement, liveBrokerAttributes, reassignment, assignment);
        }
        return none$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$getReplicaAssignment$1(Seq brokers$1, TopicPlacement topicPlacement) {
        return new Tuple2(MODULE$.partitionBrokersByConstraint((Seq<BrokerMetadata>)brokers$1, (Seq<TopicPlacement.ConstraintCount>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala())), MODULE$.partitionBrokersByConstraint((Seq<BrokerMetadata>)brokers$1, (Seq<TopicPlacement.ConstraintCount>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(topicPlacement.observers()).asScala())));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$getReplicaAssignment$2(int replicationFactor$1, Seq brokers$1) {
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicationFactor$1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)brokers$1);
        return new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Object)Seq$.MODULE$.empty());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$brokerMatchesPlacementConstraint$1(String rack) {
        void $minus$greater$extension_$this;
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"rack");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)rack);
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateAssignment$3(Map liveBrokerAttributes$1, int id) {
        return TopicPlacement.Replica.of(id, Optional.of(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)liveBrokerAttributes$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0 & Serializable & scala.Serializable)() -> scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateAssignment$5(Map liveBrokerAttributes$1, int id) {
        return TopicPlacement.Replica.of(id, Optional.of(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)liveBrokerAttributes$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0 & Serializable & scala.Serializable)() -> scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ ApiError $anonfun$validateAssignment$7(String message) {
        return new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, message);
    }

    public static final /* synthetic */ Option $anonfun$validateAssignment$2(ReplicaAssignment.Assignment assignment$1, Map liveBrokerAttributes$1, TopicPlacement placementConstraint) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.validateAssignment(placementConstraint, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment$1.syncReplicas().map((Function1 & Serializable & scala.Serializable)id -> Observer$.$anonfun$validateAssignment$3(liveBrokerAttributes$1, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment$1.observers().map((Function1 & Serializable & scala.Serializable)id -> Observer$.$anonfun$validateAssignment$5(liveBrokerAttributes$1, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).asJava())));
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)Observer$.$anonfun$validateAssignment$7((String)map_this.get()));
        return object;
    }

    public static final /* synthetic */ Option $anonfun$validateAssignment$1(Option topicPlacement$1, ReplicaAssignment.Assignment assignment$1, Map liveBrokerAttributes$1) {
        None$ none$;
        if (topicPlacement$1 == null) {
            throw null;
        }
        if (topicPlacement$1.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            TopicPlacement topicPlacement = (TopicPlacement)topicPlacement$1.get();
            none$ = Observer$.$anonfun$validateAssignment$2(assignment$1, liveBrokerAttributes$1, topicPlacement);
        }
        return none$;
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateReassignment$3(Map liveBrokerAttributes$2, int id) {
        return TopicPlacement.Replica.of(id, Optional.of(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)liveBrokerAttributes$2.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0 & Serializable & scala.Serializable)() -> scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ Some $anonfun$validateReassignment$6() {
        return new Some((Object)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ java.util.Map $anonfun$validateReassignment$7(Map x$5) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(x$5).asJava();
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateReassignment$5(Map liveBrokerAttributes$2, ReplicaAssignment reassignment$1, int id) {
        Option attributes;
        Option option;
        Option attributes2 = liveBrokerAttributes$2.get((Object)BoxesRunTime.boxToInteger((int)id));
        if (reassignment$1.originAssignment().replicas().contains((Object)BoxesRunTime.boxToInteger((int)id))) {
            option = attributes2;
        } else {
            if (attributes2 == null) {
                throw null;
            }
            Object object = attributes2.isEmpty() ? Observer$.$anonfun$validateReassignment$6() : attributes2;
            option = attributes = object;
        }
        if (attributes == null) {
            throw null;
        }
        Object object = attributes.isEmpty() ? None$.MODULE$ : new Some((Object)Observer$.$anonfun$validateReassignment$7((Map)attributes.get()));
        return TopicPlacement.Replica.of(id, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)object)));
    }

    public static final /* synthetic */ ApiError $anonfun$validateReassignment$8(String message) {
        return new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, message);
    }

    public static final /* synthetic */ Option $anonfun$validateReassignment$2(ReplicaAssignment.Assignment assignment$2, Map liveBrokerAttributes$2, ReplicaAssignment reassignment$1, TopicPlacement placementConstraint) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.validateAssignment(placementConstraint, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment$2.syncReplicas().map((Function1 & Serializable & scala.Serializable)id -> Observer$.$anonfun$validateReassignment$3(liveBrokerAttributes$2, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment$2.observers().map((Function1 & Serializable & scala.Serializable)id -> Observer$.$anonfun$validateReassignment$5(liveBrokerAttributes$2, reassignment$1, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).asJava())));
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)Observer$.$anonfun$validateReassignment$8((String)map_this.get()));
        return object;
    }

    public static final /* synthetic */ Option $anonfun$validateReassignment$1(Option topicPlacement$2, Map liveBrokerAttributes$2, ReplicaAssignment reassignment$1, ReplicaAssignment.Assignment assignment) {
        None$ none$;
        if (topicPlacement$2 == null) {
            throw null;
        }
        if (topicPlacement$2.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            TopicPlacement topicPlacement = (TopicPlacement)topicPlacement$2.get();
            none$ = Observer$.$anonfun$validateReassignment$2(assignment, liveBrokerAttributes$2, reassignment$1, topicPlacement);
        }
        return none$;
    }

    private Observer$() {
        MODULE$ = this;
    }
}

