/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.log.Log;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.tools.TierTopicMaterializationToolConfig;
import kafka.tier.tools.TierTopicMaterializationUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;

public class TierMetadataValidator {
    private HashMap<TopicIdPartition, TierMetadataValidatorRecord> stateMap = new HashMap();
    public final String metadataStatesDir;
    public final String workDir;
    private final String snapshotDirSuffix = "snapshots";
    public Properties props = new Properties();

    TierMetadataValidator(String[] args) {
        this.parseArgs(args);
        this.workDir = this.props.getProperty("working-dir");
        this.metadataStatesDir = this.props.getProperty("metadata-states-dir");
    }

    private void parseArgs(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec workingDirSpec = parser.accepts("working-dir", "working-dir is the directory path where the tool will generate its data").withRequiredArg().describedAs("working-dir").ofType(String.class).defaultsTo((Object)"/tmp/workdir", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec metaStatesDirSpec = parser.accepts("metadata-states-dir", "data directory of kafka, to pull tier topic state files.").withRequiredArg().describedAs("metadata-states-dir").ofType(String.class);
        ArgumentAcceptingOptionSpec bootStrapServerSpec = parser.accepts("bootstrap-server", "The broker server and port string in form host:port").withRequiredArg().describedAs("The broker server and port string in form host:port").ofType(String.class).defaultsTo((Object)"localhost:9092", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec tierSytateTopicPartitionSpec = parser.accepts("tier-state-topic-partition", "tier topic partition. If selected all the processing will be limited from this partition.").withRequiredArg().describedAs("tier topic partition. If selected all the processing will be limited from this partition.").ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec dumpEventsSpec = parser.accepts("dump-events", "dumps the tier state topic's events on std out. By default its turned to be true. If chosen false it will still dump everty 1000th events for trackinglong runs.").withRequiredArg().describedAs("dumps the tier state topic's events on std out. By default its turned to be true. If chosen false it will still dump everty 1000th events for trackinglong runs.").ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]);
        OptionSet options = parser.parse(args);
        if (!options.hasArgument((OptionSpec)metaStatesDirSpec)) {
            System.err.println("Required arg metadata-states-dir");
            System.exit(1);
        }
        this.props.put("metadata-states-dir", options.valueOf((OptionSpec)metaStatesDirSpec));
        this.props.put("working-dir", options.valueOf((OptionSpec)workingDirSpec));
        this.props.put("dump-metadata", "true");
        this.props.put("bootstrap-server", options.valueOf((OptionSpec)bootStrapServerSpec));
        this.props.put("tier-state-topic-partition", options.valueOf((OptionSpec)tierSytateTopicPartitionSpec));
        this.props.put("dump-events", options.valueOf((OptionSpec)dumpEventsSpec));
        System.out.println("Starting Validation with following args " + this.props + " " + this.props.get("tier-state-topic-partition"));
    }

    private void createWorkDir(String dir) {
        File snapshotDir;
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.isDirectory() || file.listFiles().length != 0) {
            System.err.println("materialization-path needs to be directory and should be empty");
            System.exit(1);
        }
        if ((snapshotDir = new File(this.getSnapshotDir(dir))).exists() && (!snapshotDir.isDirectory() || snapshotDir.listFiles().length != 0)) {
            System.err.println("snapshot path " + snapshotDir.getAbsolutePath() + " exists but is not directory or is not empty.");
            System.exit(1);
        } else {
            snapshotDir.mkdir();
        }
    }

    private String getSnapshotDir(String dir) {
        return Paths.get(dir, "snapshots").toString();
    }

    private Path getSnapshotFilePath(TopicPartition id) {
        return Paths.get(this.getSnapshotDir(this.workDir), id.topic() + "-" + id.partition());
    }

    public void run() throws IOException {
        this.createWorkDir(this.workDir);
        System.out.println("**** Fetching target partition states from folder. \n");
        this.snapshotStateFiles(this.metadataStatesDir);
        HashMap<TopicIdPartition, Long> offsetMap = new HashMap<TopicIdPartition, Long>();
        for (Map.Entry<TopicIdPartition, TierMetadataValidatorRecord> entry : this.stateMap.entrySet()) {
            TopicIdPartition id = entry.getKey();
            offsetMap.put(id, entry.getValue().maxOffset);
        }
        System.out.println("**** Calling materialization for following partition to offset mapping " + offsetMap + " \n");
        if (offsetMap.size() != 0 && !this.props.get("tier-state-topic-partition").equals(-1)) {
            int endOffset = Collections.max(offsetMap.values()).intValue();
            this.props.put("end-offset", (Object)endOffset);
            System.out.println("Setting end-offset to " + endOffset);
        }
        TierTopicMaterializationUtils utils = new TierTopicMaterializationUtils(new TierTopicMaterializationToolConfig(this.props), offsetMap);
        utils.run();
        System.out.println("**** Calling validator. \n");
        Iterator<TopicIdPartition> it = utils.stateMap.keySet().iterator();
        while (it.hasNext()) {
            try {
                Path aFile;
                TopicIdPartition eid = it.next();
                Path eFile = utils.getTierStateFile(eid);
                if (!this.compareStates(eFile, aFile = this.stateMap.get((Object)eid).snapshot, eid.topicPartition()).booleanValue()) continue;
                System.out.println("Metadata states is consistent " + eFile + " Vs " + aFile);
            }
            catch (Exception ex) {
                System.out.println("Ignoring comparison for non local.");
            }
        }
    }

    private void snapshotStateFiles(String metadataStatesDir) throws IOException {
        File mdir = new File(metadataStatesDir);
        if (!mdir.isDirectory()) {
            System.err.println(metadataStatesDir + " is not metadata states directory");
            System.exit(1);
        }
        for (File dir : mdir.listFiles()) {
            if (!dir.isDirectory()) continue;
            try {
                TopicPartition topicPartition = Log.parseTopicPartitionName(dir);
                File snapShotFile = this.getSnapshotFilePath(topicPartition).toFile();
                if (!snapShotFile.exists()) {
                    snapShotFile.mkdir();
                }
                System.out.println("Found TierTopicPartition dir " + dir.toPath());
                for (File file : dir.listFiles()) {
                    if (!file.isFile() || !Log.isTierStateFile(file)) continue;
                    System.out.println("Taking snapshot of partition states for " + topicPartition);
                    Path ss = Paths.get(snapShotFile.toString(), file.getName());
                    Files.copy(file.toPath(), ss, new CopyOption[0]);
                    System.out.println("Copied state files " + ss);
                    TierMetadataValidatorRecord record = new TierMetadataValidatorRecord(ss, topicPartition);
                    this.stateMap.put(record.id, record);
                }
            }
            catch (KafkaException kafkaException) {
                // empty catch block
            }
        }
        if (this.stateMap.isEmpty()) {
            System.out.println("Can not find any metadata states file in " + this.metadataStatesDir);
            System.exit(1);
        }
    }

    private Boolean compareStates(Path expected, Path actual, TopicPartition id) throws IOException {
        byte[] f2;
        Header aheader;
        FileChannel echannel = FileChannel.open(expected, StandardOpenOption.READ);
        FileChannel achannel = FileChannel.open(expected, StandardOpenOption.READ);
        Header eheader = FileTierPartitionState.readHeader(echannel).get();
        if (!eheader.equals(aheader = FileTierPartitionState.readHeader(achannel).get())) {
            System.err.println("Metadata states(header) inconsistency " + expected + " Vs " + actual);
            return false;
        }
        byte[] f1 = Files.readAllBytes(expected);
        if (!Arrays.equals(f1, f2 = Files.readAllBytes(actual))) {
            System.out.println("Metadata inconsistency(files do not match) " + expected + " Vs " + actual);
            return false;
        }
        Optional<FileTierPartitionIterator> eiteratorOpt = FileTierPartitionState.iterator(id, echannel);
        Optional<FileTierPartitionIterator> aiteratorOpt = FileTierPartitionState.iterator(id, achannel);
        long prevBaseOffset = -1L;
        long prevEndOffset = -1L;
        boolean firstValid = true;
        while (eiteratorOpt.get().hasNext()) {
            TierObjectMetadata actualObject;
            if (!aiteratorOpt.get().hasNext()) {
                System.out.println("Metadata states inconsistency(more states in " + expected);
                return false;
            }
            TierObjectMetadata expectedObject = (TierObjectMetadata)eiteratorOpt.get().next();
            if (expectedObject.equals(actualObject = (TierObjectMetadata)aiteratorOpt.get().next())) {
                if (firstValid && (actualObject.state().equals((Object)TierObjectMetadata.State.SEGMENT_FENCED) || actualObject.state().equals((Object)TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE))) continue;
                long start = Math.max(expectedObject.baseOffset(), prevEndOffset + 1L);
                if (start - prevEndOffset != 1L || expectedObject.endOffset() <= prevEndOffset) {
                    if (firstValid) continue;
                    System.err.println("Metadata offset inconsistency " + prevBaseOffset + " : " + prevEndOffset);
                    System.err.println("Expected : " + expected);
                    return false;
                }
            } else {
                System.err.println("Metadata states inconsistency " + expected + " Vs " + actual);
                return false;
            }
            prevBaseOffset = expectedObject.baseOffset();
            prevEndOffset = expectedObject.endOffset();
            firstValid = false;
        }
        if (eiteratorOpt.get().hasNext() || aiteratorOpt.get().hasNext()) {
            System.out.println("Metadata states inconsistency(more states in " + expected);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Atleast metadata-states-dir needs to be set.");
            System.exit(1);
        }
        try {
            TierMetadataValidator validator = new TierMetadataValidator(args);
            validator.run();
        }
        catch (Exception ae) {
            System.out.println("Exception: " + ae.getMessage());
            ae.printStackTrace();
            System.exit(1);
        }
    }

    class TierMetadataValidatorRecord {
        public Path snapshot;
        public TopicIdPartition id;
        public Long maxOffset;

        public TierMetadataValidatorRecord(Path stateFile, TopicPartition topicPartition) throws IOException {
            FileChannel fileChannel = FileChannel.open(stateFile, StandardOpenOption.READ);
            Optional<Header> headerOpt = FileTierPartitionState.readHeader(fileChannel);
            if (!headerOpt.isPresent()) {
                return;
            }
            Header header = headerOpt.get();
            this.snapshot = stateFile;
            this.id = new TopicIdPartition(topicPartition.topic(), header.topicId(), topicPartition.partition());
            this.maxOffset = header.localMaterializedOffset();
        }
    }
}

