/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.time.Instant;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh!B\f\u0019\u0003\u0003y\u0002\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u000bu\u0002A\u0011\u0001 \t\u000f)\u0003\u0001\u0019!C\u0005\u0017\"9q\n\u0001a\u0001\n\u0013\u0001\u0006B\u0002,\u0001A\u0003&A\nC\u0004\\\u0001\u0001\u0007I\u0011\u0002/\t\u000f\u0019\u0004\u0001\u0019!C\u0005O\"1\u0011\u000e\u0001Q!\nuCqa\u001b\u0001A\u0002\u0013%A\u000eC\u0004{\u0001\u0001\u0007I\u0011B>\t\ru\u0004\u0001\u0015)\u0003n\u0011\u0019y\bA\"\u0001\u0002\u0002!9\u00111\u0002\u0001\u0007\u0002\u00055\u0001bBA\u000e\u0001\u0019\u0005\u0011Q\u0004\u0005\n\u0003\u000f\u0003\u0011\u0013!C\u0001\u0003\u0013Ca!a(\u0001\t\u0003a\u0006bBAQ\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003W\u0003A\u0011AAW\u0011!\t9\f\u0001C\t1\u0005e\u0006\u0002CAf\u0001\u0011E\u0001$!4\t\u000f\u0005U\u0007\u0001\"\u0005\u0002X\"9\u0011\u0011\u001c\u0001\u0005\u0012\u0005m'\u0001\u0003+jKJ$\u0016m]6\u000b\u0005eQ\u0012!\u0002;bg.\u001c(BA\u000e\u001d\u0003\u0011!\u0018.\u001a:\u000b\u0003u\tQa[1gW\u0006\u001c\u0001!\u0006\u0002!\u0007N\u0019\u0001!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\tA3&D\u0001*\u0015\tQC$A\u0003vi&d7/\u0003\u0002-S\t9Aj\\4hS:<\u0017\u0001\u0004:fiJL(+\u0019;f\u001fB$\bc\u0001\u00120c%\u0011\u0001g\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005IZT\"A\u001a\u000b\u0005Q*\u0014\u0001B2pe\u0016T!AN\u001c\u0002\u000f5,GO]5dg*\u0011\u0001(O\u0001\u0007s\u0006lW.\u001a:\u000b\u0003i\n1aY8n\u0013\ta4GA\u0003NKR,'/\u0001\u0004=S:LGO\u0010\u000b\u0003\u007f%\u00032\u0001\u0011\u0001B\u001b\u0005A\u0002C\u0001\"D\u0019\u0001!Q\u0001\u0012\u0001C\u0002\u0015\u0013\u0011\u0001V\t\u0003\r~\u0002\"AI$\n\u0005!\u001b#a\u0002(pi\"Lgn\u001a\u0005\u0006[\t\u0001\rAL\u0001\u000be\u0016$(/_\"pk:$X#\u0001'\u0011\u0005\tj\u0015B\u0001($\u0005\rIe\u000e^\u0001\u000fe\u0016$(/_\"pk:$x\fJ3r)\t\tF\u000b\u0005\u0002#%&\u00111k\t\u0002\u0005+:LG\u000fC\u0004V\t\u0005\u0005\t\u0019\u0001'\u0002\u0007a$\u0013'A\u0006sKR\u0014\u0018pQ8v]R\u0004\u0003FA\u0003Y!\t\u0011\u0013,\u0003\u0002[G\tAao\u001c7bi&dW-\u0001\u0007`a\u0006,8/\u001a3V]RLG.F\u0001^!\r\u0011sF\u0018\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\fA\u0001^5nK*\t1-\u0001\u0003kCZ\f\u0017BA3a\u0005\u001dIen\u001d;b]R\f\u0001c\u00189bkN,G-\u00168uS2|F%Z9\u0015\u0005EC\u0007bB+\b\u0003\u0003\u0005\r!X\u0001\u000e?B\fWo]3e+:$\u0018\u000e\u001c\u0011)\u0005!A\u0016AB0feJ|'/F\u0001n!\r\u0011sF\u001c\t\u0003_^t!\u0001];\u000f\u0005E$X\"\u0001:\u000b\u0005Mt\u0012A\u0002\u001fs_>$h(C\u0001%\u0013\t18%A\u0004qC\u000e\\\u0017mZ3\n\u0005aL(!\u0003+ie><\u0018M\u00197f\u0015\t18%\u0001\u0006`KJ\u0014xN]0%KF$\"!\u0015?\t\u000fUS\u0011\u0011!a\u0001[\u00069q,\u001a:s_J\u0004\u0003FA\u0006Y\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u0002\u0004A!\u0011QAA\u0004\u001b\u0005Q\u0012bAA\u00055\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u0004GRDXCAA\b!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b5\u00059a-\u001a;dQ\u0016\u0014\u0018\u0002BA\r\u0003'\u00111cQ1oG\u0016dG.\u0019;j_:\u001cuN\u001c;fqR\f!\u0002\u001e:b]NLG/[8o)1\ty\"a\u000e\u0002R\u0005\u0005\u0014\u0011OAA)\u0011\t\t#!\f\u0011\u000b\u0005\r\u0012\u0011F!\u000e\u0005\u0005\u0015\"bAA\u0014G\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005-\u0012Q\u0005\u0002\u0007\rV$XO]3\t\u000f\u0005=b\u0002q\u0001\u00022\u0005\u0011Qm\u0019\t\u0005\u0003G\t\u0019$\u0003\u0003\u00026\u0005\u0015\"\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0019\tg\u00021\u0001\u0002:A!\u00111HA'\u001b\t\tiDC\u0002+\u0003\u007fQA!!\u0011\u0002D\u000511m\\7n_:T1!HA#\u0015\u0011\t9%!\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tY%A\u0002pe\u001eLA!a\u0014\u0002>\t!A+[7f\u0011\u001d\t\u0019F\u0004a\u0001\u0003+\n\u0011\u0003^5feR{\u0007/[2BaB,g\u000eZ3s!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.5\u0005)Ao\u001c9jG&!\u0011qLA-\u0005E!\u0016.\u001a:U_BL7-\u00119qK:$WM\u001d\u0005\b\u0003Gr\u0001\u0019AA3\u0003=!\u0018.\u001a:PE*,7\r^*u_J,\u0007\u0003BA4\u0003[j!!!\u001b\u000b\u0007\u0005-$$A\u0003ti>\u0014X-\u0003\u0003\u0002p\u0005%$a\u0004+jKJ|%M[3diN#xN]3\t\u000f\u0005Md\u00021\u0001\u0002v\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\u0003BA<\u0003{j!!!\u001f\u000b\u0007\u0005mD$\u0001\u0004tKJ4XM]\u0005\u0005\u0003\u007f\nIH\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u0013\u0005\re\u0002%AA\u0002\u0005\u0015\u0015!E7bqJ+GO]=CC\u000e\\wN\u001a4NgB\u0019!e\f'\u0002)Q\u0014\u0018M\\:ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00136+\t\tYI\u000b\u0003\u0002\u0006\u000655FAAH!\u0011\t\t*a'\u000e\u0005\u0005M%\u0002BAK\u0003/\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e5%\u0001\u0006b]:|G/\u0019;j_:LA!!(\u0002\u0014\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0017A\fWo]3e+:$\u0018\u000e\\\u0001\rSN,%O]8s'R\fG/Z\u000b\u0003\u0003K\u00032AIAT\u0013\r\tIk\t\u0002\b\u0005>|G.Z1o\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\"!a,\u0011\t\u0005E\u00161W\u0007\u0003\u0003\u007fIA!!.\u0002@\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u0004:fiJLH+Y:l\u0019\u0006$XM\u001d\u000b\b#\u0006m\u0016QXAd\u0011\u0019\t\u0019i\u0005a\u0001\u0019\"9\u0011qX\nA\u0002\u0005\u0005\u0017!\u00028po6\u001b\bc\u0001\u0012\u0002D&\u0019\u0011QY\u0012\u0003\t1{gn\u001a\u0005\u0007\u0003\u0013\u001c\u0002\u0019\u00018\u0002\u0003Q\facY1oG\u0016d\u0017I\u001c3TKR,%O]8s'R\fG/\u001a\u000b\u0006#\u0006=\u00171\u001b\u0005\u0007\u0003#$\u0002\u0019A \u0002\u0011QLWM\u001d+bg.Da!!3\u0015\u0001\u0004q\u0017AF8o'V\u001c7-Z:tMVdGK]1og&$\u0018n\u001c8\u0015\u0003E\u000bqd\u001c8Tk\u000e\u001cWm]:gk2$&/\u00198tSRLwN\\,ji\"$U\r\\1z)\u0015\t\u0016Q\\Aq\u0011\u001d\tyN\u0006a\u0001\u0003\u0003\fq\u0001Z3mCfl5\u000fC\u0004\u0002@Z\u0001\r!!1")
public abstract class TierTask<T extends TierTask<T>>
implements Logging {
    private final Option<Meter> retryRateOpt;
    private volatile int retryCount;
    private volatile Option<Instant> _pausedUntil;
    private volatile Option<Throwable> _error;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int retryCount() {
        return this.retryCount;
    }

    private void retryCount_$eq(int x$1) {
        this.retryCount = x$1;
    }

    private Option<Instant> _pausedUntil() {
        return this._pausedUntil;
    }

    private void _pausedUntil_$eq(Option<Instant> x$1) {
        this._pausedUntil = x$1;
    }

    private Option<Throwable> _error() {
        return this._error;
    }

    private void _error_$eq(Option<Throwable> x$1) {
        this._error = x$1;
    }

    public abstract TopicIdPartition topicIdPartition();

    public abstract CancellationContext ctx();

    public abstract Future<T> transition(Time var1, TierTopicAppender var2, TierObjectStore var3, ReplicaManager var4, Option<Object> var5, ExecutionContext var6);

    public Option<Object> transition$default$5() {
        return None$.MODULE$;
    }

    public Option<Instant> pausedUntil() {
        return this._pausedUntil();
    }

    public boolean isErrorState() {
        return this._error().isDefined();
    }

    public TopicPartition topicPartition() {
        return this.topicIdPartition().topicPartition();
    }

    public void retryTaskLater(int maxRetryBackoffMs, long nowMs, Throwable t) {
        this.retryCount_$eq(this.retryCount() + 1);
        Option<Meter> option = this.retryRateOpt;
        if (option == null) {
            throw null;
        }
        Option<Meter> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            ((Meter)foreach_this.get()).mark();
        }
        Instant now = Instant.ofEpochMilli(nowMs);
        int pauseMs = Math.min(maxRetryBackoffMs, (Random$.MODULE$.nextInt(this.retryCount()) + 1) * 1000);
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("retrying ").append(this).append(" after ").append(pauseMs).append("ms").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(pauseMs)));
    }

    public void cancelAndSetErrorState(TierTask<T> tierTask, Throwable t) {
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Partition ").append(this.topicIdPartition()).append(", task ").append(tierTask).append(" moved to error state due to unhandled exception").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
        this._error_$eq((Option<Throwable>)new Some((Object)t));
        this.ctx().cancel();
    }

    public void onSuccessfulTransition() {
        this.retryCount_$eq(0);
        this._pausedUntil_$eq((Option<Instant>)None$.MODULE$);
    }

    public void onSuccessfulTransitionWithDelay(long delayMs, long nowMs) {
        Instant now = Instant.ofEpochMilli(nowMs);
        this.onSuccessfulTransition();
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(delayMs)));
    }

    public TierTask(Option<Meter> retryRateOpt) {
        this.retryRateOpt = retryRateOpt;
        Logging.$init$(this);
        this.retryCount = 0;
        this._pausedUntil = None$.MODULE$;
        this._error = None$.MODULE$;
    }

    public static final /* synthetic */ Object $anonfun$retryTaskLater$1$adapted(Meter x$1) {
        x$1.mark();
        return BoxedUnit.UNIT;
    }
}

