/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

public enum TierPartitionStatus {
    CLOSED(0),
    INIT(1),
    CATCHUP(2),
    ONLINE(3),
    DISK_OFFLINE(4);

    final byte value;

    private TierPartitionStatus(byte value) {
        this.value = value;
    }

    public boolean isOpen() {
        return this == INIT || this == CATCHUP || this == ONLINE;
    }

    public boolean isOpenForWrite() {
        return this == INIT || this == CATCHUP || this == ONLINE;
    }

    public static byte toByte(TierPartitionStatus status) {
        return status.value;
    }

    public static TierPartitionStatus fromByte(byte value) {
        if (value == TierPartitionStatus.CLOSED.value) {
            return CLOSED;
        }
        if (value == TierPartitionStatus.INIT.value) {
            return INIT;
        }
        if (value == TierPartitionStatus.CATCHUP.value) {
            return CATCHUP;
        }
        if (value == TierPartitionStatus.ONLINE.value) {
            return ONLINE;
        }
        if (value == TierPartitionStatus.DISK_OFFLINE.value) {
            return DISK_OFFLINE;
        }
        throw new IllegalArgumentException("Unrecognized TierPartitionStatus byte value " + value);
    }
}

