/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.File;
import java.io.IOException;
import kafka.log.LogConfig;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Topic;

public class TierPartitionStateFactory {
    private final boolean tierFeatureEnabled;

    public TierPartitionStateFactory(boolean tierFeatureEnabled) {
        this.tierFeatureEnabled = tierFeatureEnabled;
    }

    public TierPartitionState initState(File stateDir, TopicPartition topicPartition, LogConfig config) throws IOException {
        boolean enableTiering = this.mayEnableTiering(topicPartition, config);
        return new FileTierPartitionState(stateDir, topicPartition, enableTiering);
    }

    public boolean mayEnableTiering(TopicPartition topicPartition, LogConfig config) {
        return this.tierFeatureEnabled && config.tierEnable() != false && !config.compact() && !Topic.isInternal((String)topicPartition.topic());
    }
}

