/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Future;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.TierPartitionStatus;
import org.apache.kafka.common.TopicPartition;

public interface TierPartitionState {
    public TopicPartition topicPartition();

    public Optional<TopicIdPartition> topicIdPartition();

    public File dir();

    public Optional<Long> startOffset() throws IOException;

    public boolean setTopicId(UUID var1) throws IOException;

    public long committedEndOffset() throws IOException;

    public long endOffset() throws IOException;

    public int numSegments();

    public NavigableSet<Long> segmentOffsets();

    public NavigableSet<Long> segmentOffsets(long var1, long var3) throws IOException;

    public Optional<TierObjectMetadata> metadata(long var1) throws IOException;

    public Collection<TierObjectMetadata> fencedSegments();

    public AppendResult append(AbstractTierMetadata var1, long var2) throws IOException;

    public long totalSize() throws IOException;

    public int tierEpoch() throws IOException;

    public boolean isTieringEnabled();

    public void enableTierConfig() throws IOException;

    public void flush() throws IOException;

    public void beginCatchup();

    public void onCatchUpComplete();

    public Future<TierObjectMetadata> materializationListener(long var1) throws IOException;

    public TierPartitionStatus status();

    public void updateDir(File var1);

    public void delete() throws IOException;

    public void close() throws IOException;

    public void closeHandlers() throws IOException;

    public static enum AppendResult {
        NOT_TIERABLE,
        FENCED,
        ACCEPTED;

    }
}

