/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.server.checkpoints.LeaderEpochCheckpointBuffer;
import kafka.server.epoch.EpochEntry;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.immutable.List;

public class TierStateFetcher {
    private static final Logger log = LoggerFactory.getLogger(TierStateFetcher.class);
    private final TierObjectStore tierObjectStore;
    private final ExecutorService executorService;
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public TierStateFetcher(Integer numThreads, TierObjectStore tierObjectStore) {
        this.tierObjectStore = tierObjectStore;
        this.executorService = Executors.newFixedThreadPool(numThreads);
    }

    public void close() {
        if (this.stopped.compareAndSet(false, true)) {
            this.executorService.shutdownNow();
        }
    }

    public CompletableFuture<List<EpochEntry>> fetchLeaderEpochState(TierObjectStore.ObjectMetadata metadata) {
        CompletableFuture<List<EpochEntry>> entries = new CompletableFuture<List<EpochEntry>>();
        this.executorService.execute(() -> {
            try (TierObjectStoreResponse response = this.tierObjectStore.getObject(metadata, TierObjectStore.FileType.EPOCH_STATE);
                 InputStreamReader inputStreamReader = new InputStreamReader(response.getInputStream());
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                LeaderEpochCheckpointBuffer checkPointBuffer = new LeaderEpochCheckpointBuffer(metadata.toString(), bufferedReader);
                entries.complete(checkPointBuffer.read().toList());
            }
            catch (Throwable e) {
                entries.completeExceptionally(e);
            }
        });
        return entries;
    }

    public CompletableFuture<ByteBuffer> fetchProducerStateSnapshot(TierObjectStore.ObjectMetadata metadata) {
        return CompletableFuture.supplyAsync(() -> {
            try (TierObjectStoreResponse response = this.tierObjectStore.getObject(metadata, TierObjectStore.FileType.PRODUCER_STATE);){
                ByteBuffer byteBuffer = ByteBuffer.wrap(Utils.toArray((InputStream)response.getInputStream()));
                return byteBuffer;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, this.executorService);
    }
}

