/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierSegmentMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.serdes.SegmentDeleteInitiate;

public class TierSegmentDeleteInitiate
extends AbstractTierSegmentMetadata {
    private static final byte VERSION_V0 = 0;
    private static final byte CURRENT_VERSION = 0;
    private static final int INITIAL_BUFFER_SIZE = 60;
    private final TopicIdPartition topicIdPartition;
    private final SegmentDeleteInitiate metadata;

    public TierSegmentDeleteInitiate(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId) {
        FlatBufferBuilder builder = new FlatBufferBuilder(60).forceDefaults(true);
        SegmentDeleteInitiate.startSegmentDeleteInitiate(builder);
        SegmentDeleteInitiate.addVersion(builder, (byte)0);
        SegmentDeleteInitiate.addTierEpoch(builder, tierEpoch);
        int objectIdOffset = kafka.tier.serdes.UUID.createUUID(builder, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
        SegmentDeleteInitiate.addObjectId(builder, objectIdOffset);
        int entryId = SegmentDeleteInitiate.endSegmentDeleteInitiate(builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = SegmentDeleteInitiate.getRootAsSegmentDeleteInitiate(builder.dataBuffer());
    }

    public TierSegmentDeleteInitiate(TopicIdPartition topicIdPartition, SegmentDeleteInitiate metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.SegmentDeleteInitiate;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        return new UUID(this.metadata.objectId().mostSignificantBits(), this.metadata.objectId().leastSignificantBits());
    }

    @Override
    public TierObjectMetadata.State state() {
        return TierObjectMetadata.State.SEGMENT_DELETE_INITIATE;
    }

    public String toString() {
        return "TierSegmentDeleteInitiate(version=" + this.metadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", objectIdAsBase64=" + this.objectIdAsBase64() + ")";
    }
}

