/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import java.util.HashMap;
import java.util.Map;

public enum TierRecordType {
    InitLeader(0),
    SegmentUploadInitiate(1),
    SegmentUploadComplete(2),
    SegmentDeleteInitiate(3),
    SegmentDeleteComplete(4),
    PartitionDeleteInitiate(5),
    PartitionDeleteComplete(6);

    private static final Map<Byte, TierRecordType> ID_TO_TYPE;
    private final byte id;

    private TierRecordType(byte id) {
        this.id = id;
    }

    public static byte toByte(TierRecordType recordType) {
        return recordType.id;
    }

    public static TierRecordType toType(byte id) {
        TierRecordType type = ID_TO_TYPE.get(id);
        if (type == null) {
            throw new IllegalArgumentException("Unknown id " + id);
        }
        return type;
    }

    static {
        ID_TO_TYPE = new HashMap<Byte, TierRecordType>();
        for (TierRecordType type : TierRecordType.values()) {
            TierRecordType oldType = ID_TO_TYPE.put(type.id, type);
            if (oldType == null) continue;
            throw new ExceptionInInitializerError("id reused for ID_TO_TYPE " + (Object)((Object)oldType) + " and " + (Object)((Object)type));
        }
    }
}

