/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.client;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kafka.tier.client.TierTopicClient;
import kafka.tier.topic.TierTopicManagerConfig;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;

public class TierTopicProducerSupplier
implements Supplier<Producer<byte[], byte[]>> {
    private static final String CLIENT_TYPE = "producer";
    private static final String SEPARATOR = "-";
    private final TierTopicManagerConfig config;
    private final AtomicInteger instanceId = new AtomicInteger(0);

    public TierTopicProducerSupplier(TierTopicManagerConfig config) {
        this.config = config;
    }

    @Override
    public Producer<byte[], byte[]> get() {
        String clientId = TierTopicProducerSupplier.clientId(this.config.clusterId, this.config.brokerId, this.instanceId.getAndIncrement());
        return new KafkaProducer(TierTopicProducerSupplier.properties(this.config, clientId));
    }

    public static String clientId(String clusterId, int brokerId, long instanceId) {
        return TierTopicClient.clientIdPrefix(CLIENT_TYPE) + SEPARATOR + clusterId + SEPARATOR + brokerId + SEPARATOR + instanceId;
    }

    static Properties properties(TierTopicManagerConfig config, String clientId) {
        Properties properties = new Properties();
        for (Map.Entry<String, Object> configEntry : config.interBrokerClientConfigs.get().entrySet()) {
            properties.put(configEntry.getKey(), configEntry.getValue());
        }
        properties.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        properties.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        properties.put("acks", "all");
        properties.put("retries", Integer.toString(Integer.MAX_VALUE));
        properties.put("retry.backoff.ms", Integer.toString(2000));
        properties.put("delivery.timeout.ms", Integer.toString(Integer.MAX_VALUE));
        properties.put("client.id", clientId);
        properties.put("request.timeout.ms", config.requestTimeoutMs);
        properties.put("max.in.flight.requests.per.connection", (Object)1);
        properties.remove("metric.reporters");
        return properties;
    }
}

