/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.client;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kafka.tier.client.TierTopicClient;
import kafka.tier.topic.TierTopicManagerConfig;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class TierTopicConsumerSupplier
implements Supplier<Consumer<byte[], byte[]>> {
    private static final String CLIENT_TYPE = "consumer";
    private static final String SEPARATOR = "-";
    private final TierTopicManagerConfig config;
    private final String clientIdSuffix;
    private final AtomicInteger instanceId = new AtomicInteger(0);

    public TierTopicConsumerSupplier(TierTopicManagerConfig config, String clientIdSuffix) {
        this.config = config;
        this.clientIdSuffix = clientIdSuffix;
    }

    @Override
    public Consumer<byte[], byte[]> get() {
        String clientId = TierTopicConsumerSupplier.clientId(this.config.clusterId, this.config.brokerId, this.instanceId.getAndIncrement(), this.clientIdSuffix);
        return new KafkaConsumer(TierTopicConsumerSupplier.properties(this.config, clientId));
    }

    static Properties properties(TierTopicManagerConfig config, String clientId) {
        Properties properties = new Properties();
        for (Map.Entry<String, Object> configEntry : config.interBrokerClientConfigs.get().entrySet()) {
            properties.put(configEntry.getKey(), configEntry.getValue());
        }
        properties.put("auto.offset.reset", "earliest");
        properties.put("client.id", clientId);
        properties.put("enable.auto.commit", "false");
        properties.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        properties.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        properties.remove("metric.reporters");
        return properties;
    }

    static String clientId(String clusterId, int brokerId, int instanceId, String clientIdSuffix) {
        return TierTopicClient.clientIdPrefix(CLIENT_TYPE) + SEPARATOR + clusterId + SEPARATOR + brokerId + SEPARATOR + instanceId + SEPARATOR + clientIdSuffix;
    }
}

