/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.controller.KafkaController;
import kafka.log.AbstractLog;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigHandler;
import kafka.server.Constants$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\b\u0010\u0001QA\u0001\"\n\u0001\u0003\u0006\u0004%IA\n\u0005\tU\u0001\u0011\t\u0011)A\u0005O!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00050\u0001\t\u0015\r\u0011\"\u00011\u0011!y\u0004A!A!\u0002\u0013\t\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u000b\u001d\u0003A\u0011\u0001%\t\u000f9\u0003!\u0019!C\u0005\u001f\"1a\u000b\u0001Q\u0001\nACQa\u0016\u0001\u0005\naCQ!\u001e\u0001\u0005\u0002YDQ!\u001f\u0001\u0005\u0002iDq!a\u0005\u0001\t\u0003\t)B\u0001\nU_BL7mQ8oM&<\u0007*\u00198eY\u0016\u0014(B\u0001\t\u0012\u0003\u0019\u0019XM\u001d<fe*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001)2d\b\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qiR\"A\b\n\u0005yy!!D\"p]\u001aLw\rS1oI2,'\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002##\u0005)Q\u000f^5mg&\u0011A%\t\u0002\b\u0019><w-\u001b8h\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012a\n\t\u00039!J!!K\b\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%A\u0006lC\u001a\\\u0017mQ8oM&<\u0007C\u0001\u000f.\u0013\tqsBA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AB9v_R\f7/F\u00012!\t\u0011DH\u0004\u00024u9\u0011A'\u000f\b\u0003kaj\u0011A\u000e\u0006\u0003oM\ta\u0001\u0010:p_Rt\u0014\"\u0001\n\n\u0005A\t\u0012BA\u001e\u0010\u00031\tVo\u001c;b\r\u0006\u001cGo\u001c:z\u0013\tidHA\u0007Rk>$\u0018-T1oC\u001e,'o\u001d\u0006\u0003w=\tq!];pi\u0006\u001c\b%A\blC\u001a\\\u0017mQ8oiJ|G\u000e\\3s!\t\u0011U)D\u0001D\u0015\t!\u0015#\u0001\u0006d_:$(o\u001c7mKJL!AR\"\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJ\fa\u0001P5oSRtD#B%K\u00172k\u0005C\u0001\u000f\u0001\u0011\u0015)s\u00011\u0001(\u0011\u0015Ys\u00011\u0001-\u0011\u0015ys\u00011\u00012\u0011\u0015\u0001u\u00011\u0001B\u0003)awnZ'b]\u0006<WM]\u000b\u0002!B\u0011\u0011\u000bV\u0007\u0002%*\u00111+E\u0001\u0004Y><\u0017BA+S\u0005)aunZ'b]\u0006<WM]\u0001\fY><W*\u00198bO\u0016\u0014\b%A\bva\u0012\fG/\u001a'pO\u000e{gNZ5h)\u0011IFL\u001a9\u0011\u0005YQ\u0016BA.\u0018\u0005\u0011)f.\u001b;\t\u000buS\u0001\u0019\u00010\u0002\u000bQ|\u0007/[2\u0011\u0005}\u001bgB\u00011b!\t)t#\u0003\u0002c/\u00051\u0001K]3eK\u001aL!\u0001Z3\u0003\rM#(/\u001b8h\u0015\t\u0011w\u0003C\u0003h\u0015\u0001\u0007\u0001.A\u0006u_BL7mQ8oM&<\u0007CA5o\u001b\u0005Q'BA6m\u0003\u0011)H/\u001b7\u000b\u00035\fAA[1wC&\u0011qN\u001b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"B9\u000b\u0001\u0004\u0011\u0018\u0001F2p]\u001aLwMT1nKN$v.\u0012=dYV$W\rE\u0002`gzK!\u0001^3\u0003\u0007M+G/\u0001\u000bqe>\u001cWm]:D_:4\u0017nZ\"iC:<Wm\u001d\u000b\u00043^D\b\"B/\f\u0001\u0004q\u0006\"B4\f\u0001\u0004A\u0017\u0001\u00079beN,G\u000b\u001b:piRdW\r\u001a)beRLG/[8ogR910!\u0003\u0002\f\u0005=\u0001\u0003\u0002?\u0000\u0003\u0007i\u0011! \u0006\u0003}^\t!bY8mY\u0016\u001cG/[8o\u0013\r\t\t! \u0002\u0004'\u0016\f\bc\u0001\f\u0002\u0006%\u0019\u0011qA\f\u0003\u0007%sG\u000fC\u0003h\u0019\u0001\u0007\u0001\u000eC\u0004\u0002\u000e1\u0001\r!a\u0001\u0002\u0011\t\u0014xn[3s\u0013\u0012Da!!\u0005\r\u0001\u0004q\u0016\u0001\u00029s_B\fq\"\u001a=dYV$W\rZ\"p]\u001aLwm\u001d\u000b\u0006e\u0006]\u0011\u0011\u0004\u0005\u0006;6\u0001\rA\u0018\u0005\u0006O6\u0001\r\u0001\u001b")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final ReplicaManager replicaManager;
    private final KafkaConfig kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private final KafkaController kafkaController;
    private final LogManager logManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private void updateLogConfig(String topic, Properties topicConfig, Set<String> configNamesToExclude) {
        this.logManager().topicConfigUpdated(topic);
        Seq<AbstractLog> logs = this.logManager().logsByTopic(topic);
        if (logs.nonEmpty()) {
            Properties props = new Properties();
            ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfig).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String key = (String)x0$1._1();
                String value = (String)x0$1._2();
                BoxedUnit boxedUnit = !configNamesToExclude.contains((Object)key) ? props.put(key, value) : BoxedUnit.UNIT;
                return boxedUnit;
            });
            LogConfig logConfig = LogConfig$.MODULE$.fromProps(this.logManager().currentDefaultConfig().originals(), props);
            ((IterableLike)logs.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topicPartition(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                TopicConfigHandler.$anonfun$updateLogConfig$3(this, logConfig, topicPartition);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        Success success;
        Set<String> configNamesToExclude = this.excludedConfigs(topic, topicConfig);
        this.updateLogConfig(topic, topicConfig, configNamesToExclude);
        this.updateThrottledList$1(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.quotas().leader(), topicConfig, topic);
        this.updateThrottledList$1(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.quotas().follower(), topicConfig, topic);
        if (Try$.MODULE$ == null) {
            throw null;
        }
        try {
            success = new Success((Object)BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$processConfigChanges$3(topicConfig)));
        }
        catch (Throwable throwable) {
            Option option = NonFatal$.MODULE$.unapply(throwable);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable apply_e = (Throwable)option.get();
            Failure failure = new Failure(apply_e);
            success = failure;
        }
        if (BoxesRunTime.unboxToBoolean((Object)success.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
            this.kafkaController.enableTopicUncleanLeaderElection(topic);
        }
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator$.MODULE$.ensureValidString(prop, configValue);
        Seq seq = "".equals(configValue) ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : ("*".equals(configValue) ? Constants$.MODULE$.AllReplicas() : new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(","))), (Function1 & Serializable & scala.Serializable)x$2 -> x$2.split(":"), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).filterImpl((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$2(brokerId, x$3)), false))), (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)TopicConfigHandler.$anonfun$parseThrottledPartitions$3(x$4)), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSeq());
        return seq;
    }

    public Set<String> excludedConfigs(String topic, Properties topicConfig) {
        None$ none$;
        Option option = Option$.MODULE$.apply((Object)topicConfig.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp()));
        if (option == null) {
            throw null;
        }
        Option flatMap_this = option;
        if (flatMap_this.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String string = (String)flatMap_this.get();
            none$ = TopicConfigHandler.$anonfun$excludedConfigs$1(this, topic, string);
        }
        return Option$.MODULE$.option2Iterable((Option)none$).toSet();
    }

    public static final /* synthetic */ void $anonfun$updateLogConfig$3(TopicConfigHandler $this, LogConfig logConfig$1, TopicPartition topicPartition) {
        $this.replicaManager().updateLogConfig(topicPartition, logConfig$1);
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, Properties topicConfig$1, String topic$1) {
        if (topicConfig$1.containsKey(prop) && topicConfig$1.getProperty(prop).length() > 0) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, partitions);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Setting ").append(prop).append(" on broker ").append($this.kafkaConfig.brokerId()).append(" for topic: ").append(topic$1).append(" and partitions ").append(partitions).toString());
            return;
        }
        quotaManager.removeThrottle(topic$1);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing ").append(prop).append(" from broker ").append($this.kafkaConfig.brokerId()).append(" for topic ").append(topic$1).toString());
    }

    public static final /* synthetic */ boolean $anonfun$processConfigChanges$3(Properties topicConfig$1) {
        String string = topicConfig$1.getProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp());
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$parseThrottledPartitions$2(int brokerId$1, String[] x$3) {
        String string = x$3[1];
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).toInt() == brokerId$1;
    }

    public static final /* synthetic */ int $anonfun$parseThrottledPartitions$3(String[] x$4) {
        String string = x$4[0];
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).toInt();
    }

    public static final /* synthetic */ Option $anonfun$excludedConfigs$1(TopicConfigHandler $this, String topic$2, String versionString) {
        if ($this.kafkaConfig.interBrokerProtocolVersion().$less(ApiVersion$.MODULE$.apply(versionString))) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(109).append("Log configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append(" is ignored for `").append(topic$2).append("` because `").append(versionString).append("` ").append("is not compatible with Kafka inter-broker protocol version `").append($this.kafkaConfig.interBrokerProtocolVersionString()).append("`").toString());
            return new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
        }
        return None$.MODULE$;
    }

    public TopicConfigHandler(ReplicaManager replicaManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas, KafkaController kafkaController) {
        this.replicaManager = replicaManager;
        this.kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        this.kafkaController = kafkaController;
        Logging.$init$(this);
        this.logManager = replicaManager.logManager();
    }
}

