/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_1_IV2$;
import kafka.api.KAFKA_2_2_IV1$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.api.KAFKA_2_4_IV1$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierState;
import kafka.server.epoch.EpochEntry;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.CompletableFutureUtil$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.TierListOffsetRequestData;
import org.apache.kafka.common.message.TierListOffsetResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.requests.TierListOffsetRequest;
import org.apache.kafka.common.requests.TierListOffsetResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rme\u0001B!C\u0001\u001dC\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t5\u0002\u0011\t\u0011)A\u00057\"Iq\f\u0001B\u0001B\u0003%\u0001M\u001a\u0005\tO\u0002\u0011\t\u0011)A\u0005Q\"A1\u000e\u0001B\u0001B\u0003%A\u000e\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003q\u0011!\u0019\bA!A!\u0002\u0013!\bBCA\u0001\u0001\t\u0005\t\u0015!\u0003\u0002\u0004!Q\u0011q\u0002\u0001\u0003\u0002\u0003\u0006I!!\u0005\t\u0015\u0005]\u0001A!A!\u0002\u0013\tI\u0002\u0003\u0006\u00020\u0001\u0011\t\u0011)A\u0005\u0003cAq!!\u000f\u0001\t\u0003\tY\u0004C\u0005\u0002V\u0001\u0011\r\u0011\"\u0003\u0002X!9\u0011\u0011\f\u0001!\u0002\u0013Y\u0006\"CA.\u0001\t\u0007I\u0011BA/\u0011!\t)\u0007\u0001Q\u0001\n\u0005}\u0003\"CA4\u0001\t\u0007I\u0011BA5\u0011!\tY\u0007\u0001Q\u0001\n\u0005M\u0002BCA7\u0001\t\u0007I\u0011\u0001\"\u0002p!A\u0011q\u000f\u0001!\u0002\u0013\t\t\b\u0003\u0006\u0002z\u0001\u0011\r\u0011\"\u0001C\u0003_B\u0001\"a\u001f\u0001A\u0003%\u0011\u0011\u000f\u0005\u000b\u0003{\u0002!\u0019!C\u0001\u0005\u0006=\u0004\u0002CA@\u0001\u0001\u0006I!!\u001d\t\u0013\u0005\u0005\u0005A1A\u0005\n\u0005\r\u0005\u0002CAK\u0001\u0001\u0006I!!\"\t\u0013\u0005]\u0005A1A\u0005\n\u0005\r\u0005\u0002CAM\u0001\u0001\u0006I!!\"\t\u0013\u0005m\u0005A1A\u0005\n\u0005\r\u0005\u0002CAO\u0001\u0001\u0006I!!\"\t\u0013\u0005}\u0005A1A\u0005\n\u0005\r\u0005\u0002CAQ\u0001\u0001\u0006I!!\"\t\u0013\u0005\r\u0006A1A\u0005\n\u0005\u0015\u0006\u0002CAW\u0001\u0001\u0006I!a*\t\u0013\u0005=\u0006A1A\u0005\u0002\u0005E\u0006\u0002CA`\u0001\u0001\u0006I!a-\t\u000f\u0005\u0005\u0007\u0001\"\u0015\u0002D\"9\u00111\u001b\u0001\u0005R\u0005U\u0007bBAp\u0001\u0011E\u0013\u0011\u001d\u0005\b\u0003K\u0004A\u0011KAt\u0011\u001d\t9\u0010\u0001C!\u0003sDq!a?\u0001\t\u0003\ni\u0010C\u0004\u0003\u0006\u0001!\tEa\u0002\t\u000f\t%\u0002\u0001\"\u0011\u0003,!9!Q\b\u0001\u0005B\t}\u0002b\u0002B2\u0001\u0011\u0005#Q\r\u0005\b\u0005_\u0002A\u0011\u0001B9\u0011\u001d\u0011)\t\u0001C)\u0005\u000fCqA!,\u0001\t#\u0012y\u000bC\u0004\u00038\u0002!\tF!/\t\u000f\t}\u0006\u0001\"\u0015\u0003B\"9!q\u0019\u0001\u0005\n\t%\u0007b\u0002B{\u0001\u0011%!q\u001f\u0005\b\u0007\u0003\u0001A\u0011IB\u0002\u0011\u001d\u0019y\u0003\u0001C!\u0007cAqa!\u0011\u0001\t#\u001a\u0019\u0005C\u0004\u0004L\u0001!\te!\u0014\t\u000f\r\r\u0004\u0001\"\u0011\u0002&\"91Q\r\u0001\u0005\n\r\u001d\u0004\"DB9\u0001A\u0005\u0019\u0011!A\u0005\n\rMdmB\u0005\u0004v\t\u000b\t\u0011#\u0001\u0004x\u0019A\u0011IQA\u0001\u0012\u0003\u0019I\bC\u0004\u0002:y\"\ta!!\t\u0013\r\re(%A\u0005\u0002\r\u0015%\u0001\u0006*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fGM\u0003\u0002D\t\u000611/\u001a:wKJT\u0011!R\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\n\u0005\u0002J\u00156\t!)\u0003\u0002L\u0005\n)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017\u0001\u00028b[\u0016\u0004\"AT,\u000f\u0005=+\u0006C\u0001)T\u001b\u0005\t&B\u0001*G\u0003\u0019a$o\\8u})\tA+A\u0003tG\u0006d\u0017-\u0003\u0002W'\u00061\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t16+A\u0005gKR\u001c\u0007.\u001a:JIB\u0011A,X\u0007\u0002'&\u0011al\u0015\u0002\u0004\u0013:$\u0018\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\bCA1e\u001b\u0005\u0011'BA2E\u0003\u001d\u0019G.^:uKJL!!\u001a2\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi&\u0011qLS\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003\u0013&L!A\u001b\"\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\"!S7\n\u00059\u0014%\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0003\u0013FL!A\u001d\"\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u00069Q.\u001a;sS\u000e\u001c\bCA;\u007f\u001b\u00051(BA:x\u0015\tA\u00180\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bjT!a\u001f?\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0018aA8sO&\u0011qP\u001e\u0002\b\u001b\u0016$(/[2t\u0003\u0011!\u0018.\\3\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003x\u0003\u0015)H/\u001b7t\u0013\u0011\ti!a\u0002\u0003\tQKW.Z\u0001\u0006cV|G/\u0019\t\u0004\u0013\u0006M\u0011bAA\u000b\u0005\na!+\u001a9mS\u000e\f\u0017+^8uC\u0006\u0001B/[3s'R\fG/\u001a$fi\u000eDWM\u001d\t\u00069\u0006m\u0011qD\u0005\u0004\u0003;\u0019&AB(qi&|g\u000e\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u000f\u0019,Go\u00195fe*\u0019\u0011\u0011\u0006#\u0002\tQLWM]\u0005\u0005\u0003[\t\u0019C\u0001\tUS\u0016\u00148\u000b^1uK\u001a+Go\u00195fe\u0006QB.Z1eKJ,e\u000e\u001a9pS:$(\t\\8dW&twmU3oIB)A,a\u0007\u00024A\u0019\u0011*!\u000e\n\u0007\u0005]\"I\u0001\u0007CY>\u001c7.\u001b8h'\u0016tG-\u0001\u0004=S:LGO\u0010\u000b\u0019\u0003{\ty$!\u0011\u0002D\u0005\u0015\u0013qIA%\u0003\u0017\ni%a\u0014\u0002R\u0005M\u0003CA%\u0001\u0011\u0015aE\u00021\u0001N\u0011\u0015QF\u00021\u0001\\\u0011\u0015yF\u00021\u0001a\u0011\u00159G\u00021\u0001i\u0011\u0015YG\u00021\u0001m\u0011\u0015yG\u00021\u0001q\u0011\u0015\u0019H\u00021\u0001u\u0011\u001d\t\t\u0001\u0004a\u0001\u0003\u0007Aq!a\u0004\r\u0001\u0004\t\t\u0002C\u0004\u0002\u00181\u0001\r!!\u0007\t\u0013\u0005=B\u0002%AA\u0002\u0005E\u0012!\u0003:fa2L7-Y%e+\u0005Y\u0016A\u0003:fa2L7-Y%eA\u0005QAn\\4D_:$X\r\u001f;\u0016\u0005\u0005}\u0003\u0003BA\u0003\u0003CJA!a\u0019\u0002\b\tQAj\\4D_:$X\r\u001f;\u0002\u00171|wmQ8oi\u0016DH\u000fI\u0001\u000fY\u0016\fG-\u001a:F]\u0012\u0004x.\u001b8u+\t\t\u0019$A\bmK\u0006$WM]#oIB|\u0017N\u001c;!\u0003M1W\r^2i%\u0016\fX/Z:u-\u0016\u00148/[8o+\t\t\t\bE\u0002]\u0003gJ1!!\u001eT\u0005\u0015\u0019\u0006n\u001c:u\u0003Q1W\r^2i%\u0016\fX/Z:u-\u0016\u00148/[8oA\u0005\u0011sN\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u0014V-];fgR4VM]:j_:\f1e\u001c4gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD'+Z9vKN$h+\u001a:tS>t\u0007%\u0001\rmSN$xJ\u001a4tKR\u0014V-];fgR4VM]:j_:\f\u0011\u0004\\5ti>3gm]3u%\u0016\fX/Z:u-\u0016\u00148/[8oA\u00059Q.\u0019=XC&$XCAAC!\u0011\t9)!%\u000e\u0005\u0005%%\u0002BAF\u0003\u001b\u000bA\u0001\\1oO*\u0011\u0011qR\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0014\u0006%%aB%oi\u0016<WM]\u0001\t[\u0006Dx+Y5uA\u0005AQ.\u001b8CsR,7/A\u0005nS:\u0014\u0015\u0010^3tA\u0005AQ.\u0019=CsR,7/A\u0005nCb\u0014\u0015\u0010^3tA\u0005Ia-\u001a;dQNK'0Z\u0001\u000bM\u0016$8\r[*ju\u0016\u0004\u0013\u0001\t2s_.,'oU;qa>\u0014Ho\u001d'fC\u0012,'/\u00129pG\"\u0014V-];fgR,\"!a*\u0011\u0007q\u000bI+C\u0002\u0002,N\u0013qAQ8pY\u0016\fg.A\u0011ce>\\WM]*vaB|'\u000f^:MK\u0006$WM]#q_\u000eD'+Z9vKN$\b%A\ngKR\u001c\u0007nU3tg&|g\u000eS1oI2,'/\u0006\u0002\u00024B!\u0011QWA^\u001b\t\t9LC\u0002\u0002:f\fqa\u00197jK:$8/\u0003\u0003\u0002>\u0006]&a\u0005$fi\u000eD7+Z:tS>t\u0007*\u00198eY\u0016\u0014\u0018\u0001\u00064fi\u000eD7+Z:tS>t\u0007*\u00198eY\u0016\u0014\b%A\u0006mCR,7\u000f^#q_\u000eDG\u0003BAc\u0003\u000f\u0004B\u0001XA\u000e7\"9\u0011\u0011Z\u0013A\u0002\u0005-\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003\u001b\fy-D\u0001x\u0013\r\t\tn\u001e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u00039awnZ*uCJ$xJ\u001a4tKR$B!a6\u0002^B\u0019A,!7\n\u0007\u0005m7K\u0001\u0003M_:<\u0007bBAeM\u0001\u0007\u00111Z\u0001\rY><WI\u001c3PM\u001a\u001cX\r\u001e\u000b\u0005\u0003/\f\u0019\u000fC\u0004\u0002J\u001e\u0002\r!a3\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0004\u0002j\u0006E\u00181\u001f\t\u00069\u0006m\u00111\u001e\t\u0004\u0013\u00065\u0018bAAx\u0005\nqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007bBAeQ\u0001\u0007\u00111\u001a\u0005\u0007\u0003kD\u0003\u0019A.\u0002\u000b\u0015\u0004xn\u00195\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^tGCAAT\u00035\tw/Y5u'\",H\u000fZ8x]R\u0011\u0011q \t\u00049\n\u0005\u0011b\u0001B\u0002'\n!QK\\5u\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRA!\u0011\u0002B\f\u00053\u0011i\u0002E\u0003]\u00037\u0011Y\u0001\u0005\u0003\u0003\u000e\tMQB\u0001B\b\u0015\r\u0011\t\u0002R\u0001\u0004Y><\u0017\u0002\u0002B\u000b\u0005\u001f\u0011Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007bBAeW\u0001\u0007\u00111\u001a\u0005\b\u00057Y\u0003\u0019AAl\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u000f\t}1\u00061\u0001\u0003\"\u0005i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004BAa\t\u0003&5\t\u0001!C\u0002\u0003()\u0013\u0011BR3uG\"$\u0015\r^1\u0002%=t'+Z:u_J,G+[3s'R\fG/\u001a\u000b\t\u0003\u007f\u0014iCa\f\u00034!9\u0011\u0011\u001a\u0017A\u0002\u0005-\u0007b\u0002B\u0019Y\u0001\u0007\u0011q[\u0001\u0016aJ|\u0007o\\:fI2{7-\u00197M_\u001e\u001cF/\u0019:u\u0011\u001d\u0011)\u0004\fa\u0001\u0005o\t\u0011\u0002^5feN#\u0018\r^3\u0011\u0007%\u0013I$C\u0002\u0003<\t\u0013\u0011\u0002V5feN#\u0018\r^3\u0002\u001d\u0019,Go\u00195US\u0016\u00148\u000b^1uKR1!\u0011\tB)\u0005'\u0002bAa\u0011\u0003N\t]RB\u0001B#\u0015\u0011\u00119E!\u0013\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0003L\u00055\u0015\u0001B;uS2LAAa\u0014\u0003F\t1a)\u001e;ve\u0016Dq!!3.\u0001\u0004\tY\rC\u0004\u0003V5\u0002\rAa\u0016\u0002%QLWM](cU\u0016\u001cG/T3uC\u0012\fG/\u0019\t\u0005\u00053\u0012y&\u0004\u0002\u0003\\)!!QLA\u0014\u0003\u0019!w.\\1j]&!!\u0011\rB.\u0005I!\u0016.\u001a:PE*,7\r^'fi\u0006$\u0017\r^1\u0002?5\fG/\u001a:jC2L'0\u001a+jKJ\u001cF/\u0019;f+:$\u0018\u000e\\(gMN,G\u000f\u0006\u0004\u0003h\t%$1\u000e\t\u0007\u0005\u0007\u0012iEa\u0016\t\u000f\u0005%g\u00061\u0001\u0002L\"9!Q\u000e\u0018A\u0002\u0005]\u0017\u0001\u0004;be\u001e,Go\u00144gg\u0016$\u0018aG7bs\n,w+\u0019:o\u0013\u001a|e/\u001a:tSj,GMU3d_J$7\u000f\u0006\u0004\u0002\u0000\nM$1\u0011\u0005\b\u0005kz\u0003\u0019\u0001B<\u0003\u001d\u0011XmY8sIN\u0004BA!\u001f\u0003\u00005\u0011!1\u0010\u0006\u0004\u0005{:\u0018A\u0002:fG>\u0014H-\u0003\u0003\u0003\u0002\nm$!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0002J>\u0002\r!a3\u0002\u001f\u0019,Go\u00195Ge>lG*Z1eKJ$BA!#\u0003\u0016BA!1\u0012BI\u0003\u0017\u0014\t#\u0004\u0002\u0003\u000e*\u0019!qR*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0014\n5%aA'ba\"9!q\u0013\u0019A\u0002\te\u0015\u0001\u00044fi\u000eD'+Z9vKN$\b\u0003\u0002BN\u0005OsAA!(\u0003$6\u0011!q\u0014\u0006\u0004\u0005C;\u0018\u0001\u0003:fcV,7\u000f^:\n\t\t\u0015&qT\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f^\u0005\u0005\u0005S\u0013YKA\u0004Ck&dG-\u001a:\u000b\t\t\u0015&qT\u0001\u001eM\u0016$8\r[#be2LWm\u001d;PM\u001a\u001cX\r\u001e$s_6dU-\u00193feR1\u0011q\u001bBY\u0005gCq!!32\u0001\u0004\tY\r\u0003\u0004\u00036F\u0002\raW\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u0001\u0012gKR\u001c\u0007.R1sY&,7\u000f\u001e'pG\u0006dwJ\u001a4tKR4%o\\7MK\u0006$WM\u001d\u000b\u0007\u0003/\u0014YL!0\t\u000f\u0005%'\u00071\u0001\u0002L\"1!Q\u0017\u001aA\u0002m\u000b1DZ3uG\"d\u0015\r^3ti>3gm]3u\rJ|W\u000eT3bI\u0016\u0014HCBAl\u0005\u0007\u0014)\rC\u0004\u0002JN\u0002\r!a3\t\r\tU6\u00071\u0001\\\u0003i1W\r^2i\u0019>\u001c\u0017\r\\(gMN,GO\u0012:p[2+\u0017\rZ3s)!\t9Na3\u0003N\n=\u0007bBAei\u0001\u0007\u00111\u001a\u0005\u0007\u0005k#\u0004\u0019A.\t\u000f\tEG\u00071\u0001\u0003T\u0006QqN\u001a4tKR$\u0016\u0010]3\u0011\t\tU'q\u001e\b\u0005\u0005/\u0014YO\u0004\u0003\u0003Z\n%h\u0002\u0002Bn\u0005OtAA!8\u0003f:!!q\u001cBr\u001d\r\u0001&\u0011]\u0005\u0002{&\u00111\u0010`\u0005\u0003\u000bjL!\u0001_=\n\u0007\t\u0005v/\u0003\u0003\u0003n\n}\u0015!\u0006+jKJd\u0015n\u001d;PM\u001a\u001cX\r\u001e*fcV,7\u000f^\u0005\u0005\u0005c\u0014\u0019P\u0001\u0006PM\u001a\u001cX\r\u001e+za\u0016TAA!<\u0003 \u0006)b-\u001a;dQ>3gm]3u\rJ|W\u000eT3bI\u0016\u0014H\u0003CAl\u0005s\u0014YP!@\t\u000f\u0005%W\u00071\u0001\u0002L\"1!QW\u001bA\u0002mCqAa@6\u0001\u0004\t9.\u0001\tfCJd\u0017.Z:u\u001fJd\u0015\r^3ti\u0006Q!-^5mI\u001a+Go\u00195\u0015\t\r\u001511\u0005\t\u0007\u0007\u000f\u0019)ba\u0007\u000f\t\r%1\u0011\u0003\b\u0005\u0007\u0017\u0019yAD\u0002Q\u0007\u001bI\u0011!R\u0005\u0003\u0007\u0012K1aa\u0005C\u0003U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012LAaa\u0006\u0004\u001a\t!\"+Z:vYR<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]NT1aa\u0005C!\u0015a\u00161DB\u000f!\u0011\u00199aa\b\n\t\r\u00052\u0011\u0004\u0002\r%\u0016\u0004H.[2b\r\u0016$8\r\u001b\u0005\b\u0007K1\u0004\u0019AB\u0014\u00031\u0001\u0018M\u001d;ji&|g.T1q!!\u0011YI!%\u0002L\u000e%\u0002cA%\u0004,%\u00191Q\u0006\"\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\u0002\u0011Q\u0014XO\\2bi\u0016$b!a@\u00044\r]\u0002bBB\u001bo\u0001\u0007\u00111Z\u0001\u0003iBDqa!\u000f8\u0001\u0004\u0019Y$A\u000bpM\u001a\u001cX\r\u001e+sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\u0007%\u001bi$C\u0002\u0004@\t\u0013Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X-A\fueVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;BiR1\u0011q`B#\u0007\u000fBq!!39\u0001\u0004\tY\rC\u0004\u0004Ja\u0002\r!a6\u0002\r=4gm]3u\u0003Q1W\r^2i\u000bB|7\r[#oI>3gm]3ugR!1qJB,!!\u0011YI!%\u0002L\u000eE\u0003\u0003\u0002BO\u0007'JAa!\u0016\u0003 \nqQ\t]8dQ\u0016sGm\u00144gg\u0016$\bbBB-s\u0001\u000711L\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b\u0003\u0003BF\u0005#\u000bYm!\u0018\u0011\t\t\r2qL\u0005\u0004\u0007CR%!C#q_\u000eDG)\u0019;b\u0003}I7o\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD7+\u001e9q_J$X\rZ\u0001\u0017g\"|W\u000f\u001c3G_2dwn^3s)\"\u0014x\u000e\u001e;mKRA\u0011qUB5\u0007W\u001ay\u0007C\u0004\u0002\u0010m\u0002\r!!\u0005\t\u000f\r54\b1\u0001\u0004*\u0005Qa-\u001a;dQN#\u0018\r^3\t\u000f\u0005%7\b1\u0001\u0002L\u0006\u00112/\u001e9fe\u0012\u001ax.\u001e:dK\n\u0013xn[3s+\u0005\u0001\u0017\u0001\u0006*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG\r\u0005\u0002J}M\u0019aha\u001f\u0011\u0007q\u001bi(C\u0002\u0004\u0000M\u0013a!\u00118z%\u00164GCAB<\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cE*\"aa\"+\t\u0005E2\u0011R\u0016\u0003\u0007\u0017\u0003Ba!$\u0004\u00186\u00111q\u0012\u0006\u0005\u0007#\u001b\u0019*A\u0005v]\u000eDWmY6fI*\u00191QS*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\u001a\u000e=%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final Metrics metrics;
    private final Time time;
    private final ReplicaQuota quota;
    private final Option<TierStateFetcher> tierStateFetcher;
    private final int replicaId;
    private final LogContext logContext;
    private final BlockingSend leaderEndpoint;
    private final short fetchRequestVersion;
    private final short offsetForLeaderEpochRequestVersion;
    private final short listOffsetRequestVersion;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private final boolean brokerSupportsLeaderEpochRequest;
    private final FetchSessionHandler fetchSessionHandler;

    public static Option<BlockingSend> $lessinit$greater$default$11() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$11();
    }

    private /* synthetic */ BrokerEndPoint super$sourceBroker() {
        return super.sourceBroker();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private BlockingSend leaderEndpoint() {
        return this.leaderEndpoint;
    }

    public short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    public short offsetForLeaderEpochRequestVersion() {
        return this.offsetForLeaderEpochRequestVersion;
    }

    public short listOffsetRequestVersion() {
        return this.listOffsetRequestVersion;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private boolean brokerSupportsLeaderEpochRequest() {
        return this.brokerSupportsLeaderEpochRequest;
    }

    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                this.leaderEndpoint().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Failed to initiate shutdown of leader endpoint ").append(this.leaderEndpoint()).append(" after initiating replica fetcher thread shutdown").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
        return (boolean)var1_1;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            this.leaderEndpoint().close();
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Failed to close leader endpoint ").append(this.leaderEndpoint()).append(" after shutting down replica fetcher thread").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Partition partition = (Partition)this.replicaMgr.nonOfflinePartition(topicPartition).get();
        AbstractLog log = partition.localLogOrException();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != log.logEndOffset()) {
            String string = "Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new IllegalStateException(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)log.logEndOffset())})));
        }
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                String string = "Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData$1.highWatermark)}));
            });
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                String string = "Follower has replica log end offset %d after appending %d bytes of messages for partition %s";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition}));
            });
        }
        long leaderLogStartOffset = partitionData.logStartOffset;
        long followerHighWatermark = log.updateHighWatermark(partitionData.highWatermark);
        log.maybeIncrementLogStartOffset(leaderLogStartOffset);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Follower set replica high watermark for partition ").append(topicPartition).append(" to ").append(followerHighWatermark).toString());
        }
        if (this.quota.isThrottled(topicPartition)) {
            this.quota.record(records.sizeInBytes());
        }
        if (partition.isReassigning() && partition.isAddingLocalReplica()) {
            this.brokerTopicStats().updateReassignmentBytesIn(records.sizeInBytes());
        }
        this.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
        AbstractLog log = this.replicaMgr.localLogOrException(topicPartition);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Restoring tier state ").append(topicPartition).append(": ").append(tierState).toString());
        log.onRestoreTierState(proposedLocalLogStart, tierState);
    }

    @Override
    public Future<TierState> fetchTierState(TopicPartition topicPartition, TierObjectMetadata tierObjectMetadata) {
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(tierObjectMetadata);
        CompletableFuture<List<EpochEntry>> epochStateFut = ((TierStateFetcher)this.tierStateFetcher.get()).fetchLeaderEpochState(metadata);
        CompletableFuture<None$> producerStateFut = tierObjectMetadata.hasProducerState() ? ((TierStateFetcher)this.tierStateFetcher.get()).fetchProducerStateSnapshot(metadata).thenApply(new Function<ByteBuffer, Option<ByteBuffer>>(null){

            public <V> Function<V, Option<ByteBuffer>> compose(Function<? super V, ? extends ByteBuffer> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<ByteBuffer, V> andThen(Function<? super Option<ByteBuffer>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Option<ByteBuffer> apply(ByteBuffer buf) {
                return new Some((Object)buf);
            }
        }) : CompletableFutureUtil$.MODULE$.completed(None$.MODULE$);
        return epochStateFut.thenCombine(producerStateFut, new BiFunction<List<EpochEntry>, Option<ByteBuffer>, TierState>(null){

            public <V> BiFunction<List<EpochEntry>, Option<ByteBuffer>, V> andThen(Function<? super TierState, ? extends V> x$1) {
                return BiFunction.super.andThen(x$1);
            }

            public TierState apply(List<EpochEntry> epochEntries, Option<ByteBuffer> producerState) {
                return new TierState(epochEntries, producerState);
            }
        });
    }

    @Override
    public Future<TierObjectMetadata> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
        return this.replicaMgr.localLogOrException(topicPartition).materializeTierStateUntilOffset(targetOffset);
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (this.fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(412).append("Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ").append(topicPartition).append(". ").append("This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append("message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append("equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString());
        }
    }

    @Override
    public Map<TopicPartition, FetchResponse.PartitionData<Records>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        scala.collection.immutable.Map map;
        try {
            FetchResponse fetchResponse = (FetchResponse)this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest).responseBody();
            if (this.fetchSessionHandler().handleResponse(fetchResponse)) {
                return (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData()).asScala();
            }
            map = Map$.MODULE$.empty();
        }
        catch (Throwable t) {
            this.fetchSessionHandler().handleError(t);
            throw t;
        }
        return map;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -2L);
    }

    @Override
    public long fetchEarliestLocalOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig.tierFeature())) {
            if (this.brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_4_IV1$.MODULE$)) {
                return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -10000L);
            }
            return this.fetchLocalOffsetFromLeader(topicPartition, currentLeaderEpoch, TierListOffsetRequest.OffsetType.LOCAL_START_OFFSET);
        }
        throw new IllegalStateException("Incompatible configuration for tiered storage");
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -1L);
    }

    private long fetchLocalOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch, TierListOffsetRequest.OffsetType offsetType) {
        TierListOffsetRequestData.TierListOffsetTopic tierListOffsetTopic = new TierListOffsetRequestData.TierListOffsetTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new TierListOffsetRequestData.TierListOffsetPartition().setPartitionIndex(topicPartition.partition()).setOffsetType(TierListOffsetRequest.OffsetType.toId((TierListOffsetRequest.OffsetType)offsetType)).setCurrentLeaderEpoch(currentLeaderEpoch)));
        TierListOffsetRequest.Builder request = new TierListOffsetRequest.Builder(new TierListOffsetRequestData().setReplicaId(this.replicaId()).setTopics(Collections.singletonList(tierListOffsetTopic)));
        TierListOffsetResponse response = (TierListOffsetResponse)this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)request).responseBody();
        if (response.data().topics().size() != 1) {
            throw new IllegalStateException("Unexpected response from TIER_LIST_OFFSET request. Response contains more topics than expected.");
        }
        TierListOffsetResponseData.TierListOffsetTopicResponse topicResponse = (TierListOffsetResponseData.TierListOffsetTopicResponse)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(response.data().topics()).asScala()).last();
        TierListOffsetResponseData.TierListOffsetPartitionResponse partitionResponse = (TierListOffsetResponseData.TierListOffsetPartitionResponse)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicResponse.partitions()).asScala()).last();
        if (partitionResponse.errorCode() == Errors.NONE.code()) {
            return partitionResponse.offset();
        }
        throw Errors.forCode((short)partitionResponse.errorCode()).exception();
    }

    /*
     * WARNING - void declaration
     */
    private long fetchOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch, long earliestOrLatest) {
        void $minus$greater$extension_$this;
        ListOffsetRequest.PartitionData requestPartitionData = new ListOffsetRequest.PartitionData(earliestOrLatest, Optional.of(Predef$.MODULE$.int2Integer(currentLeaderEpoch)));
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)requestPartitionData);
        Map requestPartitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        ListOffsetRequest.Builder requestBuilder = ListOffsetRequest.Builder.forReplica((short)this.listOffsetRequestVersion(), (int)this.replicaId()).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(requestPartitions).asJava());
        ListOffsetResponse.PartitionData responsePartitionData = (ListOffsetResponse.PartitionData)((ListOffsetResponse)this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder).responseBody()).responseData().get(topicPartition);
        Errors errors = responsePartitionData.error;
        if (!Errors.NONE.equals(errors)) {
            throw errors.exception();
        }
        long l = this.brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(responsePartitionData.offset) : Predef$.MODULE$.Long2long((Long)responsePartitionData.offsets.get(0));
        return l;
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        None$ none$;
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder(partitionMap.size(), false);
        partitionMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
                if (fetchState.isReadyForFetch() && !this.shouldFollowerThrottle($this.quota, fetchState, topicPartition)) {
                    try {
                        long logStartOffset = this.logStartOffset(topicPartition);
                        builder.add(topicPartition, new FetchRequest.PartitionData(fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch()))));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        boxedUnit = partitionsWithError.$plus$eq((Object)topicPartition);
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError(null);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        if (fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)this.fetchRequestVersion(), (int)this.replicaId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), (java.util.Map)fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).toForget(fetchData.toForget()).metadata(fetchData.metadata());
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(fetchData.sessionPartitions(), requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = (Partition)this.replicaMgr.nonOfflinePartition(tp).get();
        AbstractLog log = partition.localLogOrException();
        partition.truncateTo(offsetTruncationState.offset(), false);
        if (offsetTruncationState.offset() < log.highWatermark()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Truncating ").append(tp).append(" to offset ").append(offsetTruncationState.offset()).append(" below high watermark ").append(log.highWatermark()).toString());
        }
        if (offsetTruncationState.truncationCompleted()) {
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        ((Partition)this.replicaMgr.nonOfflinePartition(topicPartition).get()).truncateFullyAndStartAt(offset, false);
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return Map$.MODULE$.empty();
        }
        OffsetsForLeaderEpochRequest.Builder epochRequest = OffsetsForLeaderEpochRequest.Builder.forFollower((short)this.offsetForLeaderEpochRequestVersion(), (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava()), (int)this.brokerConfig.brokerId());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Sending offset for leader epoch request ").append(epochRequest).toString());
        try {
            ClientResponse response = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Received leaderEpoch response ").append(response).toString());
            return (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(responseBody.responses()).asScala();
        }
        catch (Throwable t) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error when sending leader epoch request for ").append(partitions).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            Errors error = Errors.forException((Throwable)t);
            return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                if (x0$1 != null) {
                    TopicPartition tp = (TopicPartition)x0$1._1();
                    EpochEndOffset epochEndOffset = new EpochEndOffset(error, -1, -1L);
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)tp);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                return tuple2;
            }, Map$.MODULE$.canBuildFrom());
        }
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.brokerSupportsLeaderEpochRequest();
    }

    private boolean shouldFollowerThrottle(ReplicaQuota quota, PartitionFetchState fetchState, TopicPartition topicPartition) {
        return !fetchState.isReplicaInSync() && quota.isThrottled(topicPartition) && quota.isQuotaExceeded();
    }

    public static final /* synthetic */ ReplicaFetcherBlockingSend $anonfun$leaderEndpoint$1(ReplicaFetcherThread $this) {
        return new ReplicaFetcherBlockingSend($this.super$sourceBroker(), $this.brokerConfig, $this.metrics, $this.time, $this.fetcherId, new StringBuilder(16).append("broker-").append($this.replicaId()).append("-fetcher-").append($this.fetcherId).toString(), $this.logContext());
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, Option<TierStateFetcher> tierStateFetcher, Option<BlockingSend> leaderEndpointBlockingSend) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.metrics = metrics;
        this.time = time;
        this.quota = quota;
        this.tierStateFetcher = tierStateFetcher;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), tierStateFetcher, false, replicaMgr.brokerTopicStats());
        this.replicaId = brokerConfig.brokerId();
        this.logContext = new LogContext(new StringBuilder(51).append("[ReplicaFetcher replicaId=").append(this.replicaId()).append(", leaderId=").append(super.sourceBroker().id()).append(", ").append("fetcherId=").append(fetcherId).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        if (leaderEndpointBlockingSend == null) {
            throw null;
        }
        Object object = leaderEndpointBlockingSend.isEmpty() ? ReplicaFetcherThread.$anonfun$leaderEndpoint$1(this) : leaderEndpointBlockingSend.get();
        this.leaderEndpoint = (BlockingSend)object;
        this.fetchRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_3_IV1$.MODULE$) ? 11 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV2$.MODULE$) ? 10 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 8 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$) ? 7 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0)))))))));
        this.offsetForLeaderEpochRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_3_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV0$.MODULE$) ? 1 : 0)));
        this.listOffsetRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? 1 : 0)))));
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.brokerSupportsLeaderEpochRequest = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
        this.fetchSessionHandler = new FetchSessionHandler(this.logContext(), super.sourceBroker().id());
    }
}

