/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.TierState;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.fetcher.TierStateFetcher;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\tEg\u0001B\u0014)\u00015B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\n\u0001\u0002\u0011\t\u0011)A\u0005\u0003\u001eC\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011%A\u0006A!A!\u0002\u0013IF\fC\u0003^\u0001\u0011\u0005a\fC\u0004h\u0001\t\u0007I\u0011\u00025\t\r5\u0004\u0001\u0015!\u0003j\u0011\u001dq\u0007A1A\u0005\n=Da\u0001\u001f\u0001!\u0002\u0013\u0001\bbB=\u0001\u0005\u0004%Ia\u001c\u0005\u0007u\u0002\u0001\u000b\u0011\u00029\t\u000fm\u0004\u0001\u0019!C\u0005y\"I\u0011q\u0003\u0001A\u0002\u0013%\u0011\u0011\u0004\u0005\b\u0003K\u0001\u0001\u0015)\u0003~\u0011\u001d\t9\u0003\u0001C)\u0003SAq!!\r\u0001\t#\n\u0019\u0004C\u0004\u0002>\u0001!\t&a\u0010\t\u000f\u0005\r\u0003\u0001\"\u0015\u0002F!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBAC\u0001\u0011\u0005\u0013q\u0011\u0005\b\u0003\u001f\u0004A\u0011IAi\u0011\u001d\ty\u000e\u0001C)\u0003CDq!!;\u0001\t#\nY\u000fC\u0004\u0002r\u0002!\t&a=\t\u000f\u0005e\b\u0001\"\u0011\u0002|\"9!\u0011\u0003\u0001\u0005R\tM\u0001b\u0002B\u000e\u0001\u0011\u0005#Q\u0004\u0005\b\u0005W\u0001A\u0011\u000bB\u0017\u0011\u001d\u0011)\u0004\u0001C\u0005\u0005oAqA!\u0014\u0001\t\u0013\u0011y\u0005C\u0004\u0003T\u0001!IA!\u0016\t\u000f\tu\u0004\u0001\"\u0001\u0003\u0000!9!1\u0011\u0001\u0005R\t\u0015\u0005b\u0002BL\u0001\u0011E#\u0011\u0014\u0005\b\u0005\u0003\u0004A\u0011\u000bBb\u0005e\u0011V\r\u001d7jG\u0006\fE\u000e^3s\u0019><G)\u001b:t)\"\u0014X-\u00193\u000b\u0005%R\u0013AB:feZ,'OC\u0001,\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0018\u0011\u0005=\u0002T\"\u0001\u0015\n\u0005EB#!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0001\u0005]\u0006lW\r\u0005\u00025{9\u0011Qg\u000f\t\u0003mej\u0011a\u000e\u0006\u0003q1\na\u0001\u0010:p_Rt$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ\u0014A\u0002)sK\u0012,g-\u0003\u0002?\u007f\t11\u000b\u001e:j]\u001eT!\u0001P\u001d\u0002\u0019M|WO]2f\u0005J|7.\u001a:\u0011\u0005\t+U\"A\"\u000b\u0005\u0011S\u0013aB2mkN$XM]\u0005\u0003\r\u000e\u0013aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG/\u0003\u0002Aa\u0005a!M]8lKJ\u001cuN\u001c4jOB\u0011qFS\u0005\u0003\u0017\"\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006\u0001b-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0003_9K!a\u0014\u0015\u0003!\u0019\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\u0018A\u0003:fa2L7-Y'heB\u0011qFU\u0005\u0003'\"\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/A\u0003rk>$\u0018\r\u0005\u00020-&\u0011q\u000b\u000b\u0002\u0018%\u0016\u0004H.[2bi&|g.U;pi\u0006l\u0015M\\1hKJ\f\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0011\u0005=R\u0016BA.)\u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8/\u0003\u0002Ya\u00051A(\u001b8jiz\"\u0002b\u00181bE\u000e$WM\u001a\t\u0003_\u0001AQA\r\u0005A\u0002MBQ\u0001\u0011\u0005A\u0002\u0005CQ\u0001\u0013\u0005A\u0002%CQ\u0001\u0014\u0005A\u00025CQ\u0001\u0015\u0005A\u0002ECQ\u0001\u0016\u0005A\u0002UCQ\u0001\u0017\u0005A\u0002e\u000b\u0011B]3qY&\u001c\u0017-\u00133\u0016\u0003%\u0004\"A[6\u000e\u0003eJ!\u0001\\\u001d\u0003\u0007%sG/\u0001\u0006sKBd\u0017nY1JI\u0002\n\u0001\"\\1y\u0005f$Xm]\u000b\u0002aB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\u0005Y\u0006twMC\u0001v\u0003\u0011Q\u0017M^1\n\u0005]\u0014(aB%oi\u0016<WM]\u0001\n[\u0006D()\u001f;fg\u0002\n\u0011BZ3uG\"\u001c\u0016N_3\u0002\u0015\u0019,Go\u00195TSj,\u0007%A\nj]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|g.F\u0001~!\u0011Qg0!\u0001\n\u0005}L$AB(qi&|g\u000e\u0005\u0003\u0002\u0004\u0005MQBAA\u0003\u0015\u0011\t9!!\u0003\u0002\r\r|W.\\8o\u0015\rY\u00131\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003#\t1a\u001c:h\u0013\u0011\t)\"!\u0002\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u00069\u0012N\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]~#S-\u001d\u000b\u0005\u00037\t\t\u0003E\u0002k\u0003;I1!a\b:\u0005\u0011)f.\u001b;\t\u0011\u0005\r\u0002#!AA\u0002u\f1\u0001\u001f\u00132\u0003QIg\u000e\u0015:pOJ,7o\u001d)beRLG/[8oA\u0005YA.\u0019;fgR,\u0005o\\2i)\u0011\tY#!\f\u0011\u0007)t\u0018\u000eC\u0004\u00020I\u0001\r!!\u0001\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$H\u0003BA\u001b\u0003w\u00012A[A\u001c\u0013\r\tI$\u000f\u0002\u0005\u0019>tw\rC\u0004\u00020M\u0001\r!!\u0001\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0015\t\u0005U\u0012\u0011\t\u0005\b\u0003_!\u0002\u0019AA\u0001\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0007\u0003\u000f\ny%!\u0015\u0011\t)t\u0018\u0011\n\t\u0004_\u0005-\u0013bAA'Q\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007bBA\u0018+\u0001\u0007\u0011\u0011\u0001\u0005\u0007\u0003'*\u0002\u0019A5\u0002\u000b\u0015\u0004xn\u00195\u0002\u001f\u0019,Go\u00195Ge>lG*Z1eKJ$B!!\u0017\u0002nAA\u00111LA1\u0003\u0003\t)'\u0004\u0002\u0002^)\u0019\u0011qL\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002d\u0005u#aA'baB!\u0011qMA5\u001b\u0005\u0001\u0011bAA6a\tIa)\u001a;dQ\u0012\u000bG/\u0019\u0005\b\u0003_2\u0002\u0019AA9\u000311W\r^2i%\u0016\fX/Z:u!\u0011\t\u0019(a \u000f\t\u0005U\u00141P\u0007\u0003\u0003oRA!!\u001f\u0002\u0006\u0005A!/Z9vKN$8/\u0003\u0003\u0002~\u0005]\u0014\u0001\u0004$fi\u000eD'+Z9vKN$\u0018\u0002BAA\u0003\u0007\u0013qAQ;jY\u0012,'O\u0003\u0003\u0002~\u0005]\u0014\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0005\u0002\n\u0006]\u0015\u0011TAO!\u0011Qg0a#\u0011\t\u00055\u00151S\u0007\u0003\u0003\u001fS1!!%+\u0003\rawnZ\u0005\u0005\u0003+\u000byIA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0003_9\u0002\u0019AA\u0001\u0011\u001d\tYj\u0006a\u0001\u0003k\t1BZ3uG\"|eMZ:fi\"9\u0011qT\fA\u0002\u0005\u0005\u0016!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0004\u0002$\u0006u\u00161\u0019\b\u0005\u0003K\u000bIL\u0004\u0003\u0002(\u0006]f\u0002BAU\u0003ksA!a+\u00024:!\u0011QVAY\u001d\r1\u0014qV\u0005\u0003\u0003#IA!!\u0004\u0002\u0010%\u00191&a\u0003\n\t\u0005\u001d\u0011\u0011B\u0005\u0005\u0003s\n)!\u0003\u0003\u0002<\u0006]\u0014!\u0004$fi\u000eD'+Z:q_:\u001cX-\u0003\u0003\u0002@\u0006\u0005'!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0003\u0002<\u0006]\u0004\u0003BAc\u0003\u0017l!!a2\u000b\t\u0005%\u0017QA\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u00055\u0017q\u0019\u0002\b%\u0016\u001cwN\u001d3t\u00035\tG\r\u001a)beRLG/[8ogR!\u00111[Am!\u0019\tY&!6\u0002\u0002%!\u0011q[A/\u0005\r\u0019V\r\u001e\u0005\b\u00037D\u0002\u0019AAo\u0003IIg.\u001b;jC24U\r^2i'R\fG/Z:\u0011\u0011\u0005m\u0013\u0011MA\u0001\u0003\u0013\nQDZ3uG\",\u0015M\u001d7jKN$xJ\u001a4tKR4%o\\7MK\u0006$WM\u001d\u000b\u0007\u0003k\t\u0019/!:\t\u000f\u0005=\u0012\u00041\u0001\u0002\u0002!1\u0011q]\rA\u0002%\f1\u0002\\3bI\u0016\u0014X\t]8dQ\u0006\u0011c-\u001a;dQ\u0016\u000b'\u000f\\5fgRdunY1m\u001f\u001a47/\u001a;Ge>lG*Z1eKJ$b!!\u000e\u0002n\u0006=\bbBA\u00185\u0001\u0007\u0011\u0011\u0001\u0005\u0007\u0003OT\u0002\u0019A5\u00027\u0019,Go\u00195MCR,7\u000f^(gMN,GO\u0012:p[2+\u0017\rZ3s)\u0019\t)$!>\u0002x\"9\u0011qF\u000eA\u0002\u0005\u0005\u0001BBAt7\u0001\u0007\u0011.\u0001\u000bgKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0003{\u0014)\u0001\u0005\u0005\u0002\\\u0005\u0005\u0014\u0011AA\u0000!\u0011\t)H!\u0001\n\t\t\r\u0011q\u000f\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0011\u001d\u00119\u0001\ba\u0001\u0005\u0013\t!\u0002]1si&$\u0018n\u001c8t!!\tY&!\u0019\u0002\u0002\t-\u0001\u0003BA4\u0005\u001bI1Aa\u00041\u0005%)\u0005o\\2i\t\u0006$\u0018-A\u0010jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012,\"A!\u0006\u0011\u0007)\u00149\"C\u0002\u0003\u001ae\u0012qAQ8pY\u0016\fg.\u0001\u0005ueVt7-\u0019;f)\u0019\tYBa\b\u0003\"!9\u0011q\u0006\u0010A\u0002\u0005\u0005\u0001b\u0002B\u0012=\u0001\u0007!QE\u0001\u0010iJ,hnY1uS>t7\u000b^1uKB\u0019qFa\n\n\u0007\t%\u0002FA\u000bPM\u001a\u001cX\r\u001e+sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0002/Q\u0014XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#HCBA\u000e\u0005_\u0011\t\u0004C\u0004\u00020}\u0001\r!!\u0001\t\u000f\tMr\u00041\u0001\u00026\u00051qN\u001a4tKR\f!C\\3yiJ+\u0017\rZ=QCJ$\u0018\u000e^5p]R!!\u0011\bB$!\u0011QgPa\u000f\u0011\u000f)\u0014i$!\u0001\u0003B%\u0019!qH\u001d\u0003\rQ+\b\u000f\\33!\ry#1I\u0005\u0004\u0005\u000bB#a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0007b\u0002B%A\u0001\u0007!1J\u0001\ra\u0006\u0014H/\u001b;j_:l\u0015\r\u001d\t\t\u00037\n\t'!\u0001\u0003B\u000512/\u001a7fGR\u0004\u0016M\u001d;ji&|g\u000eV8GKR\u001c\u0007\u000e\u0006\u0003\u0003:\tE\u0003b\u0002B%C\u0001\u0007!1J\u0001\u0017EVLG\u000e\u001a$fi\u000eDgi\u001c:QCJ$\u0018\u000e^5p]R1!q\u000bB;\u0005s\u0002bA!\u0017\u0003h\t5d\u0002\u0002B.\u0005GrAA!\u0018\u0003b9\u0019aGa\u0018\n\u0003-J!!\u000b\u0016\n\u0007\t\u0015\u0004&A\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\n\t\t%$1\u000e\u0002\u0015%\u0016\u001cX\u000f\u001c;XSRD\u0007+\u0019:uSRLwN\\:\u000b\u0007\t\u0015\u0004\u0006\u0005\u0003k}\n=\u0004\u0003\u0002B-\u0005cJAAa\u001d\u0003l\ta!+\u001a9mS\u000e\fg)\u001a;dQ\"9!q\u000f\u0012A\u0002\u0005\u0005\u0011A\u0001;q\u0011\u001d\u0011YH\ta\u0001\u0005\u0003\n!BZ3uG\"\u001cF/\u0019;f\u0003)\u0011W/\u001b7e\r\u0016$8\r\u001b\u000b\u0005\u0005/\u0012\t\tC\u0004\u0003J\r\u0002\rAa\u0013\u0002%=t'+Z:u_J,G+[3s'R\fG/\u001a\u000b\t\u00037\u00119I!#\u0003\u000e\"9\u0011q\u0006\u0013A\u0002\u0005\u0005\u0001b\u0002BFI\u0001\u0007\u0011QG\u0001\u0016aJ|\u0007o\\:fI2{7-\u00197M_\u001e\u001cF/\u0019:u\u0011\u001d\u0011y\t\na\u0001\u0005#\u000b\u0011\u0002^5feN#\u0018\r^3\u0011\u0007=\u0012\u0019*C\u0002\u0003\u0016\"\u0012\u0011\u0002V5feN#\u0018\r^3\u0002\u001d\u0019,Go\u00195US\u0016\u00148\u000b^1uKR1!1\u0014BV\u0005[\u0003bA!(\u0003(\nEUB\u0001BP\u0015\u0011\u0011\tKa)\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0003&R\fA!\u001e;jY&!!\u0011\u0016BP\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\u0005\b\u0003_)\u0003\u0019AA\u0001\u0011\u001d\u0011y+\na\u0001\u0005c\u000b!\u0003^5fe>\u0013'.Z2u\u001b\u0016$\u0018\rZ1uCB!!1\u0017B_\u001b\t\u0011)L\u0003\u0003\u00038\ne\u0016A\u00023p[\u0006LgNC\u0002\u0003<*\nA\u0001^5fe&!!q\u0018B[\u0005I!\u0016.\u001a:PE*,7\r^'fi\u0006$\u0017\r^1\u0002?5\fG/\u001a:jC2L'0\u001a+jKJ\u001cF/\u0019;f+:$\u0018\u000e\\(gMN,G\u000f\u0006\u0004\u0003F\n-'Q\u001a\t\u0007\u0005;\u00139M!-\n\t\t%'q\u0014\u0002\u0007\rV$XO]3\t\u000f\u0005=b\u00051\u0001\u0002\u0002!9!q\u001a\u0014A\u0002\u0005U\u0012\u0001\u0004;be\u001e,Go\u00144gg\u0016$\b")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Map<TopicPartition, FetchResponse.PartitionData<Records>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        this.replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), false, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responsePartitionData -> {
            ReplicaAlterLogDirsThread.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, request.isolationLevel(), (Option<ClientMetadata>)None$.MODULE$);
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(request.fetchData().keySet().toArray())).mkString(",")).toString());
        }
        return ((Seq)partitionData.elem).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Partition partition = (Partition)this.replicaMgr.nonOfflinePartition(topicPartition).get();
        AbstractLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        if (fetchOffset != futureLog.logEndOffset()) {
            String string = "Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new IllegalStateException(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark);
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, OffsetAndEpoch> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            set = super.addPartitions((Map<TopicPartition, OffsetAndEpoch>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        return this.replicaMgr.getPartitionOrException(topicPartition, false).localLogOrException().logStartOffset();
    }

    @Override
    public long fetchEarliestLocalOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        throw new UnsupportedOperationException("Alter log dirs does not support tiered partitions");
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        return this.replicaMgr.getPartitionOrException(topicPartition, false).localLogOrException().logEndOffset();
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                OffsetsForLeaderEpochRequest.PartitionData epochData = (OffsetsForLeaderEpochRequest.PartitionData)x0$1._2();
                try {
                    void $minus$greater$extension_$this;
                    EpochEndOffset endOffset = epochData.leaderEpoch == -1 ? new EpochEndOffset(-1, -1L) : $this.replicaMgr.getPartitionOrException(tp, false).lastOffsetForLeaderEpoch(epochData.currentLeaderEpoch, epochData.leaderEpoch, false);
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)tp);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)endOffset);
                }
                catch (Throwable t) {
                    void $minus$greater$extension_y;
                    void $minus$greater$extension_$this;
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    EpochEndOffset epochEndOffset = new EpochEndOffset(Errors.forException((Throwable)t), -1, -1L);
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)tp);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return true;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition, false).truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        this.replicaMgr.getPartitionOrException(topicPartition, false).truncateFullyAndStartAt(offset, true);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitionMap) {
        return ((TraversableOnce)partitionMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2 & Serializable & scala.Serializable)(left, right) -> {
            block5: {
                block4: {
                    String string = ((TopicPartition)left._1()).topic();
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                    if (new StringOps(string).$less((Object)((TopicPartition)right._1()).topic())) break block4;
                    String string2 = ((TopicPartition)left._1()).topic();
                    String string3 = ((TopicPartition)right._1()).topic();
                    if ((string2 != null ? !string2.equals(string3) : string3 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block5;
                }
                return left;
            }
            return right;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        Object object = new Object();
        try {
            void var3_5;
            Option<TopicPartition> option = this.inProgressPartition();
            if (option == null) {
                throw null;
            }
            Option<TopicPartition> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                TopicPartition topicPartition = (TopicPartition)foreach_this.get();
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$1(partitionMap, object, topicPartition);
            }
            this.inProgressPartition_$eq((Option<TopicPartition>)None$.MODULE$);
            Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitionMap);
            if (nextPartitionOpt == null) {
                throw null;
            }
            if (!nextPartitionOpt.isEmpty()) {
                Tuple2 tuple2 = (Tuple2)nextPartitionOpt.get();
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$4(this, partitionMap, tuple2);
            }
            return var3_5;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    private AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetchForPartition(TopicPartition tp, PartitionFetchState fetchState) {
        None$ none$;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaMgr.futureLocalLogOrException(tp).logStartOffset();
            requestMap.put(tp, new FetchRequest.PartitionData(fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch()))));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Failed to build fetch for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            partitionsWithError.$plus$eq((Object)tp);
        }
        if (requestMap.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(requestMap, requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions;
        Tuple2 tuple2;
        if (this.quota.isQuotaExceeded()) {
            return new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)Set$.MODULE$.empty());
        }
        Option<Tuple2<TopicPartition, PartitionFetchState>> option = this.selectPartitionToFetch(partitionMap);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
            resultWithPartitions = this.buildFetchForPartition(tp, fetchState);
        } else if (None$.MODULE$.equals(option)) {
            resultWithPartitions = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)Set$.MODULE$.empty());
        } else {
            throw new MatchError(option);
        }
        return resultWithPartitions;
    }

    @Override
    public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
        throw new UnsupportedOperationException("Restoring tier state during an alter log dirs operation is not currently supported.");
    }

    public CompletableFuture<TierState> fetchTierState(TopicPartition topicPartition, TierObjectMetadata tierObjectMetadata) {
        throw new UnsupportedOperationException("Fetching tier state during an alter log dirs operation is not currently supported.");
    }

    @Override
    public Future<TierObjectMetadata> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
        throw new UnsupportedOperationException("Materializing tier state is not supported with alter log dirs.");
    }

    public static final /* synthetic */ java.util.List $anonfun$fetchFromLeader$2(List x$1) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)x$1).asJava();
    }

    public static final /* synthetic */ long $anonfun$fetchFromLeader$3() {
        return -1L;
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                void orNull_ev;
                TopicPartition tp = (TopicPartition)x0$1._1();
                FetchPartitionData data = (FetchPartitionData)x0$1._2();
                Option<List<FetchResponse.AbortedTransaction>> option = data.abortedTransactions();
                if (option == null) {
                    throw null;
                }
                Option<List<FetchResponse.AbortedTransaction>> map_this = option;
                Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)ReplicaAlterLogDirsThread.$anonfun$fetchFromLeader$2((List)map_this.get()));
                Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
                if (object == null) {
                    throw null;
                }
                Object object2 = object.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : object.get();
                java.util.List abortedTransactions = (java.util.List)object2;
                Option<Object> option2 = data.lastStableOffset();
                if (option2 == null) {
                    throw null;
                }
                Option<Object> getOrElse_this = option2;
                Object object3 = getOrElse_this.isEmpty() ? BoxesRunTime.boxToLong((long)ReplicaAlterLogDirsThread.$anonfun$fetchFromLeader$3()) : getOrElse_this.get();
                long lastStableOffset = BoxesRunTime.unboxToLong((Object)object3);
                FetchResponse.PartitionData partitionData = new FetchResponse.PartitionData(data.error(), data.highWatermark(), lastStableOffset, data.logStartOffset(), abortedTransactions, (BaseRecords)data.records());
                Object object4 = Predef$.MODULE$.ArrowAssoc((Object)tp);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)x0$1._1();
        boolean bl = $this.replicaMgr.futureLogExists(tp);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((PartitionFetchState)x0$1._2()).isReadyForFetch();
        return bl;
    }

    public static final /* synthetic */ Nothing$ $anonfun$selectPartitionToFetch$3(Object nonLocalReturnKey1$1, TopicPartition tp$2, PartitionFetchState fetchState) {
        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)tp$2, (Object)fetchState)));
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(Map partitionMap$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        Option fetchStateOpt = partitionMap$1.get((Object)tp);
        if (fetchStateOpt == null) {
            throw null;
        }
        Object object = fetchStateOpt.isEmpty() || ((PartitionFetchState)fetchStateOpt.get()).isReadyForFetch() ? fetchStateOpt : None$.MODULE$;
        if (object == null) {
            throw null;
        }
        if (!object.isEmpty()) {
            PartitionFetchState partitionFetchState = (PartitionFetchState)object.get();
            throw ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$3(nonLocalReturnKey1$1, tp, partitionFetchState);
        }
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(ReplicaAlterLogDirsThread $this, Map partitionMap$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
            $this.inProgressPartition_$eq((Option<TopicPartition>)new Some((Object)tp));
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(133).append("Beginning/resuming copy of partition ").append(tp).append(" from offset ").append(fetchState.fetchOffset()).append(". ").append("Including this partition, there are ").append(partitionMap$1.size()).append(" remaining partitions to copy by this thread.").toString());
            return;
        }
        throw new MatchError(null);
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), (Option<TierStateFetcher>)None$.MODULE$, false, brokerTopicStats);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
    }

    public static final /* synthetic */ Object $anonfun$selectPartitionToFetch$1$adapted(Map partitionMap$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$1(partitionMap$1, nonLocalReturnKey1$1, tp);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$selectPartitionToFetch$4$adapted(ReplicaAlterLogDirsThread $this, Map partitionMap$1, Tuple2 x0$1) {
        ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$4($this, partitionMap$1, x0$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$selectPartitionToFetch$2$adapted(PartitionFetchState x$2) {
        return BoxesRunTime.boxToBoolean((boolean)x$2.isReadyForFetch());
    }
}

