/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.server.KafkaApis;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\f\u0019\u0001uA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005a!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003:\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0011M\u0003!Q1A\u0005\u0002QC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\t9\u0002\u0011)\u0019!C\u0001;\"A1\u000e\u0001B\u0001B\u0003%a\f\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003n\u0011!\t\bA!A!\u0002\u0013\u0011\b\"B<\u0001\t\u0003A\b\"CA\u0003\u0001\t\u0007I\u0011BA\u0004\u0011!\t\t\u0002\u0001Q\u0001\n\u0005%\u0001\"CA\n\u0001\u0001\u0007I\u0011BA\u000b\u0011%\ti\u0002\u0001a\u0001\n\u0013\ty\u0002\u0003\u0005\u0002,\u0001\u0001\u000b\u0015BA\f\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u000f\u0001\t\u0003\t9\u0004C\u0004\u0002<\u0001!\t!a\u000e\t\u000f\u0005u\u0002\u0001\"\u0001\u00028\t\u00192*\u00194lCJ+\u0017/^3ti\"\u000bg\u000e\u001a7fe*\u0011\u0011DG\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003m\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001=\u0019J\u0003CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0011a\u0017M\\4\u000b\u0003\r\nAA[1wC&\u0011Q\u0005\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005}9\u0013B\u0001\u0015!\u0005!\u0011VO\u001c8bE2,\u0007C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u001b\u0003\u0015)H/\u001b7t\u0013\tq3FA\u0004M_\u001e<\u0017N\\4\u0002\u0005%$\u0007CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$aA%oi\u0006A!M]8lKJLE-\u0001\nbO\u001e\u0014XmZ1uK&#G.Z'fi\u0016\u0014X#A\u001d\u0011\u0005i\u001aU\"A\u001e\u000b\u0005qj\u0014\u0001B2pe\u0016T!AP \u0002\u000f5,GO]5dg*\u0011\u0001)Q\u0001\u0007s\u0006lW.\u001a:\u000b\u0003\t\u000b1aY8n\u0013\t!5HA\u0003NKR,'/A\nbO\u001e\u0014XmZ1uK&#G.Z'fi\u0016\u0014\b%A\nu_R\fG\u000eS1oI2,'\u000f\u00165sK\u0006$7/F\u0001I!\tI\u0005+D\u0001K\u0015\tYE*\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\u001b:\u000b!bY8oGV\u0014(/\u001a8u\u0015\ty%%\u0001\u0003vi&d\u0017BA)K\u00055\tEo\\7jG&sG/Z4fe\u0006!Bo\u001c;bY\"\u000bg\u000e\u001a7feRC'/Z1eg\u0002\naB]3rk\u0016\u001cHo\u00115b]:,G.F\u0001V!\t1\u0016,D\u0001X\u0015\tA&$A\u0004oKR<xN]6\n\u0005i;&A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0010e\u0016\fX/Z:u\u0007\"\fgN\\3mA\u0005\u0001\"/Z9vKN$Hj\\4GS2$XM]\u000b\u0002=B\u0011q,[\u0007\u0002A*\u0011\u0011MY\u0001\te\u0016\fX/Z:ug*\u00111\rZ\u0001\u0007G>lWn\u001c8\u000b\u0005m)'B\u00014h\u0003\u0019\t\u0007/Y2iK*\t\u0001.A\u0002pe\u001eL!A\u001b1\u0003!I+\u0017/^3ti2{wMR5mi\u0016\u0014\u0018!\u0005:fcV,7\u000f\u001e'pO\u001aKG\u000e^3sA\u0005!\u0011\r]5t!\tqw.D\u0001\u0019\u0013\t\u0001\bDA\u0005LC\u001a\\\u0017-\u00119jg\u0006!A/[7f!\t\u0019X/D\u0001u\u0015\ta#-\u0003\u0002wi\n!A+[7f\u0003\u0019a\u0014N\\5u}QY\u0011P_>}{z|\u0018\u0011AA\u0002!\tq\u0007\u0001C\u00030\u001b\u0001\u0007\u0001\u0007C\u00037\u001b\u0001\u0007\u0001\u0007C\u00038\u001b\u0001\u0007\u0011\bC\u0003G\u001b\u0001\u0007\u0001\nC\u0003T\u001b\u0001\u0007Q\u000bC\u0003]\u001b\u0001\u0007a\fC\u0003m\u001b\u0001\u0007Q\u000eC\u0003r\u001b\u0001\u0007!/\u0001\ttQV$Hm\\<o\u0007>l\u0007\u000f\\3uKV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\ti!D\u0001M\u0013\r\ty\u0001\u0014\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0003E\u0019\b.\u001e;e_^t7i\\7qY\u0016$X\rI\u0001\bgR|\u0007\u000f]3e+\t\t9\u0002E\u00022\u00033I1!a\u00073\u0005\u001d\u0011un\u001c7fC:\f1b\u001d;paB,Gm\u0018\u0013fcR!\u0011\u0011EA\u0014!\r\t\u00141E\u0005\u0004\u0003K\u0011$\u0001B+oSRD\u0011\"!\u000b\u0012\u0003\u0003\u0005\r!a\u0006\u0002\u0007a$\u0013'\u0001\u0005ti>\u0004\b/\u001a3!Q\r\u0011\u0012q\u0006\t\u0004c\u0005E\u0012bAA\u001ae\tAao\u001c7bi&dW-A\u0002sk:$\"!!\t\u0002\tM$x\u000e]\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:\fQ\"Y<bSR\u001c\u0006.\u001e;e_^t\u0007")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final RequestLogFilter requestLogFilter;
    private final KafkaApis apis;
    private final Time time;
    private final CountDownLatch shutdownComplete;
    private volatile boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public RequestLogFilter requestLogFilter() {
        return this.requestLogFilter;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public void run() {
        while (!this.stopped()) {
            long startSelectTime = this.time.nanoseconds();
            RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(300L);
            long endTime = this.time.nanoseconds();
            long idleTime = endTime - startSelectTime;
            this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads().get());
            if (RequestChannel$ShutdownRequest$.MODULE$.equals(req)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" received shut down command").toString());
                this.shutdownComplete().countDown();
                return;
            }
            if (req instanceof RequestChannel.Request) {
                RequestChannel.Request request = (RequestChannel.Request)req;
                try {
                    try {
                        request.requestDequeueTimeNanos_$eq(endTime);
                        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" handling request ").append(request).toString());
                        request.shouldLogRequest_$eq(RequestChannel$.MODULE$.isRequestLoggingEnabled() || this.requestLogFilter().shouldLogRequest(request.context(), request.startTimeNanos()));
                        this.apis.handle(request);
                        continue;
                    }
                    catch (FatalExitError e) {
                        this.shutdownComplete().countDown();
                        throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
                    }
                    catch (Throwable e) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        continue;
                    }
                }
                finally {
                    request.releaseBuffer();
                    continue;
                }
            }
            if (req == null) continue;
            throw new MatchError((Object)req);
        }
        this.shutdownComplete().countDown();
    }

    public void stop() {
        this.stopped_$eq(true);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
    }

    public KafkaRequestHandler(int id, int brokerId, Meter aggregateIdleMeter, AtomicInteger totalHandlerThreads, RequestChannel requestChannel, RequestLogFilter requestLogFilter, KafkaApis apis, Time time) {
        this.id = id;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.requestLogFilter = requestLogFilter;
        this.apis = apis;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(37).append("[Kafka Request Handler ").append(id).append(" on Broker ").append(brokerId).append("], ").toString());
        this.shutdownComplete = new CountDownLatch(1);
        this.stopped = false;
    }
}

