/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogOffsetSnapshot;
import kafka.server.AbstractLogReadResult;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLag$;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionData;
import kafka.server.FetchPartitionStatus;
import kafka.server.FetchTxnCommitted$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierLogReadResult;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.TierFetchResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001u4AAD\b\u0001)!I\u0011\u0004\u0001B\u0001B\u0003%!\u0004\t\u0005\tC\u0001\u0011\t\u0011)A\u0005E!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011!i\u0003A!A!\u0002\u0013q\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011!\u0003!\u0011!Q\u0001\n%C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006]\u0002!\te\u001c\u0005\u0006g\u0002!\t\u0005\u001e\u0005\u0006k\u0002!IA\u001e\u0005\u0006y\u0002!\t\u0005\u001e\u0002\r\t\u0016d\u0017-_3e\r\u0016$8\r\u001b\u0006\u0003!E\taa]3sm\u0016\u0014(\"\u0001\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0006\t\u0003-]i\u0011aD\u0005\u00031=\u0011\u0001\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\u0002\u000f\u0011,G.Y=NgB\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!Aj\u001c8h\u0013\tIr#A\u0007gKR\u001c\u0007.T3uC\u0012\fG/\u0019\t\u0003-\rJ!\u0001J\b\u0003\u001b\u0019+Go\u00195NKR\fG-\u0019;b\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"AF\u0014\n\u0005!z!A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0006cV|G/\u0019\t\u0003--J!\u0001L\b\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1\u0002\u0019QLWM\u001d$fi\u000eDw\n\u001d;\u0011\u0007my\u0013'\u0003\u000219\t1q\n\u001d;j_:\u0004\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\u000f\u0019,Go\u00195fe*\u0011a'E\u0001\u0005i&,'/\u0003\u00029g\ta\u0001+\u001a8eS:<g)\u001a;dQ\u0006q1\r\\5f]RlU\r^1eCR\f\u0007cA\u000e0wA\u0011AHR\u0007\u0002{)\u0011ahP\u0001\be\u0016\u0004H.[2b\u0015\t\u0001\u0015)\u0001\u0004d_6lwN\u001c\u0006\u0003%\tS!a\u0011#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0015aA8sO&\u0011q)\u0010\u0002\u000f\u00072LWM\u001c;NKR\fG-\u0019;b\u0003A\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000f\u0005\u0002\u0017\u0015&\u00111j\u0004\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biN\f\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\tmq\u0005\u000bY\u0005\u0003\u001fr\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0007E#f+D\u0001S\u0015\t\u0019F$\u0001\u0006d_2dWm\u0019;j_:L!!\u0016*\u0003\u0007M+\u0017\u000f\u0005\u0003\u001c/fk\u0016B\u0001-\u001d\u0005\u0019!V\u000f\u001d7feA\u0011!lW\u0007\u0002\u007f%\u0011Al\u0010\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\t1b,\u0003\u0002`\u001f\t\u0011b)\u001a;dQB\u000b'\u000f^5uS>tG)\u0019;b!\tY\u0012-\u0003\u0002c9\t!QK\\5u\u0003\u0019a\u0014N\\5u}QIQMZ4iS*\\G.\u001c\t\u0003-\u0001AQ!G\u0005A\u0002iAQ!I\u0005A\u0002\tBQ!J\u0005A\u0002\u0019BQ!K\u0005A\u0002)BQ!L\u0005A\u00029BQ!O\u0005A\u0002iBQ\u0001S\u0005A\u0002%CQ\u0001T\u0005A\u00025\u000b1\u0002\u001e:z\u0007>l\u0007\u000f\\3uKR\t\u0001\u000f\u0005\u0002\u001cc&\u0011!\u000f\b\u0002\b\u0005>|G.Z1o\u00031yg.\u0012=qSJ\fG/[8o)\u0005\u0001\u0017!F2pY2,7\r\u001e'pOJ+\u0017\r\u001a*fgVdGo\u001d\u000b\u0002oB\u0019\u0011\u000b\u0016=\u0011\tm9\u0016,\u001f\t\u0003-iL!a_\b\u0003+\u0005\u00137\u000f\u001e:bGRdun\u001a*fC\u0012\u0014Vm];mi\u0006QqN\\\"p[BdW\r^3")
public class DelayedFetch
extends DelayedOperation {
    private final FetchMetadata fetchMetadata;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Option<PendingFetch> tierFetchOpt;
    private final Option<ClientMetadata> clientMetadata;
    private final BrokerTopicStats brokerTopicStats;
    private final Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        boolean bl;
        Object object = new Object();
        try {
            IntRef accumulatedSize = IntRef.create((int)0);
            this.fetchMetadata.fetchPartitionStatus().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DelayedFetch.$anonfun$tryComplete$1(this, object, accumulatedSize, x0$1);
                return BoxedUnit.UNIT;
            });
            Option<PendingFetch> option = this.tierFetchOpt;
            if (option == null) {
                throw null;
            }
            Option<PendingFetch> map_this = option;
            if (map_this.isEmpty()) {
            } else {
                PendingFetch pendingFetch = (PendingFetch)map_this.get();
                DelayedFetch.$anonfun$tryComplete$10(this, object, pendingFetch);
                new Some((Object)BoxedUnit.UNIT);
            }
            if (accumulatedSize.elem < this.fetchMetadata.fetchMinBytes() || !this.tierFetchOpt.isEmpty()) {
                return false;
            }
            bl = this.forceComplete();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public void onExpiration() {
        Option<PendingFetch> option = this.tierFetchOpt;
        if (option == null) {
            throw null;
        }
        Option<PendingFetch> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            ((PendingFetch)foreach_this.get()).cancel();
        }
        if (this.fetchMetadata.isFromFollower()) {
            DelayedFetchMetrics$.MODULE$.followerExpiredRequestMeter().mark();
            return;
        }
        DelayedFetchMetrics$.MODULE$.consumerExpiredRequestMeter().mark();
    }

    private Seq<Tuple2<TopicPartition, AbstractLogReadResult>> collectLogReadResults() {
        int x$1 = this.fetchMetadata.replicaId();
        boolean x$2 = this.fetchMetadata.fetchOnlyLeader();
        FetchIsolation x$3 = this.fetchMetadata.fetchIsolation();
        int x$4 = this.fetchMetadata.fetchMaxBytes();
        boolean x$5 = this.fetchMetadata.hardMaxBytesLimit();
        Seq x$6 = (Seq)this.fetchMetadata.fetchPartitionStatus().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                FetchPartitionStatus status = (FetchPartitionStatus)x0$1._2();
                FetchRequest.PartitionData partitionData = status.fetchInfo();
                Object object = Predef$.MODULE$.ArrowAssoc((Object)tp);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
        Option<ClientMetadata> x$7 = this.clientMetadata;
        ReplicaQuota x$8 = this.quota;
        return this.replicaManager.readFromLocalLog(x$1, x$2, x$3, x$4, x$5, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)x$6, x$8, x$7);
    }

    @Override
    public void onComplete() {
        Option<PendingFetch> option = this.tierFetchOpt;
        if (option == null) {
            throw null;
        }
        Option<PendingFetch> exists_this = option;
        boolean bl = !exists_this.isEmpty() && ((PendingFetch)exists_this.get()).isComplete();
        None$ tierFetcherReadResults = bl ? new Some(JavaConverters$.MODULE$.mapAsScalaMapConverter(((PendingFetch)this.tierFetchOpt.get()).finish()).asScala()) : None$.MODULE$;
        Seq fetchPartitionData = (Seq)this.collectLogReadResults().map(arg_0 -> DelayedFetch.$anonfun$onComplete$2(this, (Option)tierFetcherReadResults, arg_0), Seq$.MODULE$.canBuildFrom());
        this.responseCallback.apply((Object)fetchPartitionData);
    }

    public static final /* synthetic */ boolean $anonfun$tryComplete$4(LogOffsetSnapshot offsetSnapshot$1, Replica r) {
        return offsetSnapshot$1.highWatermark().messageOffset() > r.lastSentHighWatermark();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$tryComplete$1(DelayedFetch $this, Object nonLocalReturnKey1$1, IntRef accumulatedSize$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError((Object)x0$1);
        TopicPartition topicPartition = (TopicPartition)x0$1._1();
        FetchPartitionStatus fetchStatus = (FetchPartitionStatus)x0$1._2();
        if (fetchStatus == null) throw new MatchError((Object)x0$1);
        LogOffsetMetadata fetchOffset = fetchStatus.startOffsetMetadata();
        Optional fetchLeaderEpoch = fetchStatus.fetchInfo().currentLeaderEpoch;
        try {
            LogOffsetMetadata logOffsetMetadata;
            Partition partition = $this.replicaManager.getPartitionOrException(topicPartition, $this.fetchMetadata.fetchOnlyLeader());
            LogOffsetSnapshot offsetSnapshot = partition.fetchOffsetSnapshot(fetchLeaderEpoch, $this.fetchMetadata.fetchOnlyLeader());
            LogOffsetMetadata logOffsetMetadata2 = fetchOffset;
            LogOffsetMetadata logOffsetMetadata3 = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
            if (logOffsetMetadata2 == null) {
                if (logOffsetMetadata3 == null) return;
            } else if (((Object)logOffsetMetadata2).equals(logOffsetMetadata3)) return;
            FetchIsolation fetchIsolation = $this.fetchMetadata.fetchIsolation();
            if (FetchLogEnd$.MODULE$.equals(fetchIsolation)) {
                logOffsetMetadata = offsetSnapshot.logEndOffset();
            } else if (FetchHighWatermark$.MODULE$.equals(fetchIsolation)) {
                logOffsetMetadata = offsetSnapshot.highWatermark();
            } else {
                if (!FetchTxnCommitted$.MODULE$.equals(fetchIsolation)) throw new MatchError((Object)fetchIsolation);
                logOffsetMetadata = offsetSnapshot.lastStableOffset();
            }
            if (logOffsetMetadata.messageOffset() != fetchOffset.messageOffset()) {
                if (logOffsetMetadata.onOlderSegment(fetchOffset)) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Satisfying fetch ").append($this.fetchMetadata).append(" since it is fetching later segments of partition ").append(topicPartition).append(".").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                }
                if (fetchOffset.onOlderSegment(logOffsetMetadata)) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Satisfying fetch ").append($this.fetchMetadata).append(" immediately since it is fetching older segments.").toString());
                    if (!$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.fetchMetadata.replicaId())) {
                        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                    }
                } else if (fetchOffset.messageOffset() < logOffsetMetadata.messageOffset()) {
                    int bytesAvailable = package$.MODULE$.min(logOffsetMetadata.positionDiff(fetchOffset), fetchStatus.fetchInfo().maxBytes);
                    if (!$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.fetchMetadata.replicaId())) {
                        accumulatedSize$1.elem += bytesAvailable;
                    }
                }
            }
            if (!$this.fetchMetadata.isFromFollower()) return;
            Option<Replica> option = partition.getReplica($this.fetchMetadata.replicaId());
            if (option == null) {
                throw null;
            }
            Option<Replica> exists_this = option;
            if (exists_this.isEmpty()) return;
            Replica replica = (Replica)exists_this.get();
            if (!DelayedFetch.$anonfun$tryComplete$4(offsetSnapshot, replica)) return;
            boolean bl = true;
            if (!bl) return;
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
        catch (NotLeaderForPartitionException notLeaderForPartitionException) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Broker is no longer the leader of ").append(topicPartition).append(", satisfy ").append($this.fetchMetadata).append(" immediately").toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
        catch (ReplicaNotAvailableException replicaNotAvailableException) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Broker no longer has a replica of ").append(topicPartition).append(", satisfy ").append($this.fetchMetadata).append(" immediately").toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Broker no longer knows of partition ").append(topicPartition).append(", satisfy ").append($this.fetchMetadata).append(" immediately").toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
        catch (KafkaStorageException kafkaStorageException) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Partition ").append(topicPartition).append(" is in an offline log directory, satisfy ").append($this.fetchMetadata).append(" immediately").toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
        catch (FencedLeaderEpochException fencedLeaderEpochException) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(119).append("Broker is the leader of partition ").append(topicPartition).append(", but the requested epoch ").append(fetchLeaderEpoch).append(" is fenced by the latest leader epoch, satisfy ").append($this.fetchMetadata).append(" immediately").toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
    }

    public static final /* synthetic */ void $anonfun$tryComplete$10(DelayedFetch $this, Object nonLocalReturnKey1$1, PendingFetch tierFetch) {
        if (tierFetch.isComplete()) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
    }

    public static final /* synthetic */ TierFetchResult $anonfun$onComplete$4() {
        return TierFetchResult.emptyFetchResult();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$onComplete$2(DelayedFetch $this, Option tierFetcherReadResults$1, Tuple2 x0$1) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        if (x0$1 != null) {
            LogReadResult logReadResult;
            TopicPartition tp = (TopicPartition)x0$1._1();
            AbstractLogReadResult logReadResult2 = (AbstractLogReadResult)x0$1._2();
            if (logReadResult2 instanceof TierLogReadResult) {
                None$ none$;
                TierLogReadResult tierLogReadResult = (TierLogReadResult)logReadResult2;
                if (tierFetcherReadResults$1 == null) {
                    throw null;
                }
                if (tierFetcherReadResults$1.isEmpty()) {
                    none$ = None$.MODULE$;
                } else {
                    Map map = (Map)tierFetcherReadResults$1.get();
                    none$ = map.get((Object)tp);
                }
                if (none$ == null) {
                    throw null;
                }
                Object object = none$.isEmpty() ? DelayedFetch.$anonfun$onComplete$4() : none$.get();
                TierFetchResult tierFetchResult = (TierFetchResult)object;
                logReadResult = tierLogReadResult.intoLogReadResult(tierFetchResult, !tierFetchResult.isEmpty());
            } else if (logReadResult2 instanceof LogReadResult) {
                logReadResult = (LogReadResult)logReadResult2;
            } else {
                throw new MatchError((Object)logReadResult2);
            }
            FetchLag$.MODULE$.maybeRecordConsumerFetchTimeLag(!$this.fetchMetadata.isFromFollower(), logReadResult, $this.brokerTopicStats);
            FetchPartitionData fetchPartitionData = new FetchPartitionData(logReadResult.error(), logReadResult.highWatermark(), logReadResult.leaderLogStartOffset(), logReadResult.info().records(), logReadResult.lastStableOffset(), logReadResult.info().abortedTransactions(), logReadResult.preferredReadReplica(), $this.fetchMetadata.isFromFollower() && $this.replicaManager.isAddingReplica(tp, $this.fetchMetadata.replicaId()));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)tp);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
        } else {
            throw new MatchError(null);
        }
        Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        return tuple2;
    }

    public DelayedFetch(long delayMs, FetchMetadata fetchMetadata, ReplicaManager replicaManager, ReplicaQuota quota, Option<PendingFetch> tierFetchOpt, Option<ClientMetadata> clientMetadata, BrokerTopicStats brokerTopicStats, Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit> responseCallback) {
        this.fetchMetadata = fetchMetadata;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.tierFetchOpt = tierFetchOpt;
        this.clientMetadata = clientMetadata;
        this.brokerTopicStats = brokerTopicStats;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }

    public static final /* synthetic */ Object $anonfun$tryComplete$10$adapted(DelayedFetch $this, Object nonLocalReturnKey1$1, PendingFetch tierFetch) {
        DelayedFetch.$anonfun$tryComplete$10($this, nonLocalReturnKey1$1, tierFetch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$onExpiration$1$adapted(PendingFetch x$1) {
        x$1.cancel();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$onComplete$1$adapted(PendingFetch x$2) {
        return BoxesRunTime.boxToBoolean((boolean)x$2.isComplete());
    }

    public static final /* synthetic */ Object $anonfun$tryComplete$4$adapted(LogOffsetSnapshot offsetSnapshot$1, Replica r) {
        return BoxesRunTime.boxToBoolean((boolean)DelayedFetch.$anonfun$tryComplete$4(offsetSnapshot$1, r));
    }
}

