/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Observer$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AdminManager$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedCreatePartitions;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.LogLevelConfig;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.ReassignmentInProgressException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.interceptor.TopicMetadataListener;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011}a\u0001B\u001a5\u0001eB\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005\u001d\"A\u0011\n\u0001BC\u0002\u0013\u00051\u000b\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003U\u0011!\t\u0007A!b\u0001\n\u0003\u0011\u0007\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011\u001d\u0004!Q1A\u0005\u0002!D\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\u0006a\u0002!\t!\u001d\u0005\bo\u0002\u0011\r\u0011\"\u0003y\u0011\u0019y\b\u0001)A\u0005s\"I\u0011\u0011\u0001\u0001C\u0002\u0013%\u00111\u0001\u0005\t\u0003\u0017\u0001\u0001\u0015!\u0003\u0002\u0006!I\u0011Q\u0002\u0001C\u0002\u0013%\u0011q\u0002\u0005\t\u0003K\u0001\u0001\u0015!\u0003\u0002\u0012!I\u0011q\u0005\u0001C\u0002\u0013%\u0011\u0011\u0006\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002,!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002\"CA \u0001\t\u0007I\u0011BA!\u0011!\tI\u0005\u0001Q\u0001\n\u0005\r\u0003\"CA&\u0001\t\u0007I\u0011BA'\u0011!\t)\u0006\u0001Q\u0001\n\u0005=\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003w\u0002A\u0011AA?\u0011%\ti\u000fAI\u0001\n\u0003\ty\u000fC\u0004\u0003\u0006\u0001!\tAa\u0002\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*!9!1\f\u0001\u0005\u0002\tu\u0003b\u0002BM\u0001\u0011\u0005!1\u0014\u0005\b\u0005k\u0003A\u0011\u0001B\\\u0011\u001d\u0011Y\r\u0001C\u0005\u0005\u001bDqAa>\u0001\t\u0013\u0011I\u0010C\u0004\u0004\u0006\u0001!Iaa\u0002\t\u000f\r5\u0001\u0001\"\u0003\u0004\u0010!91q\u0007\u0001\u0005\n\re\u0002bBB \u0001\u0011%1\u0011\t\u0005\b\u0007\u0013\u0002A\u0011AB&\u0011\u001d\u0019)\u0006\u0001C\u0005\u0007/Bqaa\u0017\u0001\t\u0013\u0019i\u0006C\u0004\u0004|\u0001!\ta! \t\u000f\r}\u0004\u0001\"\u0003\u0004\u0002\"91q\u0011\u0001\u0005\n\r%\u0005bBBI\u0001\u0011%11\u0013\u0005\b\u0007O\u0003A\u0011BBU\u0011\u001d\u0019)\u000e\u0001C\u0005\u0007/Dqa!:\u0001\t\u0013\u00199oB\u0004\u0004\u0000RB\t\u0001\"\u0001\u0007\rM\"\u0004\u0012\u0001C\u0002\u0011\u0019\u0001\b\u0007\"\u0001\u0005\u0006!9Aq\u0001\u0019\u0005\u0002\u0011%!\u0001D!e[&tW*\u00198bO\u0016\u0014(BA\u001b7\u0003\u0019\u0019XM\u001d<fe*\tq'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001Q\u0004I\u0012\t\u0003wyj\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r3\u0014!B;uS2\u001c\u0018BA#C\u0005\u001daunZ4j]\u001e\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u001c\u0002\u000f5,GO]5dg&\u00111\n\u0013\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018AB2p]\u001aLw-F\u0001O!\ty\u0005+D\u00015\u0013\t\tFGA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u000b\u0002)B\u0011QKX\u0007\u0002-*\u0011\u0011j\u0016\u0006\u00031f\u000baaY8n[>t'BA\u001c[\u0015\tYF,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0006\u0019qN]4\n\u0005}3&aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012a\u0019\t\u0003\u001f\u0012L!!\u001a\u001b\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u00039iW\r^1eCR\f7)Y2iK\u0002\n\u0001B_6DY&,g\u000e^\u000b\u0002SB\u0011!.\\\u0007\u0002W*\u0011ANN\u0001\u0003u.L!A\\6\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003%Q8n\u00117jK:$\b%\u0001\u0004=S:LGO\u0010\u000b\u0006eN$XO\u001e\t\u0003\u001f\u0002AQ\u0001T\u0005A\u00029CQ!S\u0005A\u0002QCQ!Y\u0005A\u0002\rDQaZ\u0005A\u0002%\fa\u0002^8qS\u000e\u0004VO]4bi>\u0014\u00180F\u0001z!\ry%\u0010`\u0005\u0003wR\u0012\u0011\u0004R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8QkJ<\u0017\r^8ssB\u0011q*`\u0005\u0003}R\u0012\u0001\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QkJ<\u0017\r^8ss\u0002\nQ\"\u00193nS:T6n\u00117jK:$XCAA\u0003!\rQ\u0017qA\u0005\u0004\u0003\u0013Y'!D!e[&t'l[\"mS\u0016tG/\u0001\bbI6LgNW6DY&,g\u000e\u001e\u0011\u0002#\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)pY&\u001c\u00170\u0006\u0002\u0002\u0012A)1(a\u0005\u0002\u0018%\u0019\u0011Q\u0003\u001f\u0003\r=\u0003H/[8o!\u0011\tI\"!\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\ta\u0001]8mS\u000eL(BA\u001bZ\u0013\u0011\t\u0019#a\u0007\u0003#\r\u0013X-\u0019;f)>\u0004\u0018n\u0019)pY&\u001c\u00170\u0001\nde\u0016\fG/\u001a+pa&\u001c\u0007k\u001c7jGf\u0004\u0013!E1mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5dsV\u0011\u00111\u0006\t\u0006w\u0005M\u0011Q\u0006\t\u0005\u00033\ty#\u0003\u0003\u00022\u0005m!!E!mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5ds\u0006\u0011\u0012\r\u001c;fe\u000e{gNZ5h!>d\u0017nY=!\u0003eA\u0017m\u001d#fY\u0006LX\r\u001a+pa&\u001cw\n]3sCRLwN\\:\u0016\u0005\u0005e\u0002cA\u001e\u0002<%\u0019\u0011Q\b\u001f\u0003\u000f\t{w\u000e\\3b]\u0006!B-\u001a4bk2$h*^7QCJ$\u0018\u000e^5p]N,\"!a\u0011\u0011\u0007m\n)%C\u0002\u0002Hq\u00121!\u00138u\u0003U!WMZ1vYRtU/\u001c)beRLG/[8og\u0002\n\u0001\u0004Z3gCVdGOU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s+\t\ty\u0005E\u0002<\u0003#J1!a\u0015=\u0005\u0015\u0019\u0006n\u001c:u\u0003e!WMZ1vYR\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0011\u0002CQ\u0014\u0018pQ8na2,G/\u001a#fY\u0006LX\r\u001a+pa&\u001cw\n]3sCRLwN\\:\u0015\t\u0005m\u0013\u0011\r\t\u0004w\u0005u\u0013bAA0y\t!QK\\5u\u0011\u001d\t\u0019g\u0006a\u0001\u0003K\nQ\u0001^8qS\u000e\u0004B!a\u001a\u0002v9!\u0011\u0011NA9!\r\tY\u0007P\u0007\u0003\u0003[R1!a\u001c9\u0003\u0019a$o\\8u}%\u0019\u00111\u000f\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\t9(!\u001f\u0003\rM#(/\u001b8h\u0015\r\t\u0019\bP\u0001\rGJ,\u0017\r^3U_BL7m\u001d\u000b\u000f\u00037\ny(a!\u0002\b\u0006u\u0016\u0011[Au\u0011\u001d\t\t\t\u0007a\u0001\u0003\u0007\nq\u0001^5nK>,H\u000fC\u0004\u0002\u0006b\u0001\r!!\u000f\u0002\u0019Y\fG.\u001b3bi\u0016|e\u000e\\=\t\u000f\u0005%\u0005\u00041\u0001\u0002\f\u0006AAo\\\"sK\u0006$X\r\u0005\u0005\u0002\u000e\u0006M\u0015QMAL\u001b\t\tyIC\u0002\u0002\u0012r\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)*a$\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u001a\u0006]f\u0002BAN\u0003csA!!(\u0002.:!\u0011qTAV\u001d\u0011\t\t+!+\u000f\t\u0005\r\u0016q\u0015\b\u0005\u0003W\n)+C\u0001^\u0013\tYF,\u0003\u000285&\u0011\u0001,W\u0005\u0004\u0003_;\u0016aB7fgN\fw-Z\u0005\u0005\u0003g\u000b),A\fDe\u0016\fG/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000fR1uC*\u0019\u0011qV,\n\t\u0005e\u00161\u0018\u0002\u000f\u0007J,\u0017\r^1cY\u0016$v\u000e]5d\u0015\u0011\t\u0019,!.\t\u000f\u0005}\u0006\u00041\u0001\u0002B\u0006Y\u0012N\\2mk\u0012,7i\u001c8gS\u001e\u001c\u0018I\u001c3NKR\fG/\u00193bi\u0006\u0004\u0002\"!$\u0002\u0014\u0006\u0015\u00141\u0019\t\u0005\u0003\u000b\fYM\u0004\u0003\u0002\u001c\u0006\u001d\u0017\u0002BAe\u0003k\u000b\u0001d\u0011:fCR,Gk\u001c9jGN\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\ti-a4\u0003)\r\u0013X-\u0019;bE2,Gk\u001c9jGJ+7/\u001e7u\u0015\u0011\tI-!.\t\u000f\u0005M\u0007\u00041\u0001\u0002V\u0006\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\bw\u0005]\u00171\\A.\u0013\r\tI\u000e\u0010\u0002\n\rVt7\r^5p]F\u0002\u0002\"!$\u0002\u0014\u0006\u0015\u0014Q\u001c\t\u0005\u0003?\f)/\u0004\u0002\u0002b*\u0019\u00111],\u0002\u0011I,\u0017/^3tiNLA!a:\u0002b\nA\u0011\t]5FeJ|'\u000fC\u0005\u0002lb\u0001\n\u00111\u0001\u0002:\u0005i1M]3bi\u0016$v\u000e]5d\u0013\u0012\fac\u0019:fCR,Gk\u001c9jGN$C-\u001a4bk2$HEN\u000b\u0003\u0003cTC!!\u000f\u0002t.\u0012\u0011Q\u001f\t\u0005\u0003o\u0014\t!\u0004\u0002\u0002z*!\u00111`A\u007f\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0000r\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019!!?\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0007eK2,G/\u001a+pa&\u001c7\u000f\u0006\u0005\u0002\\\t%!1\u0002B\u000b\u0011\u001d\t\tI\u0007a\u0001\u0003\u0007BqA!\u0004\u001b\u0001\u0004\u0011y!\u0001\u0004u_BL7m\u001d\t\u0007\u0003\u001b\u0013\t\"!\u001a\n\t\tM\u0011q\u0012\u0002\u0004'\u0016$\bbBAj5\u0001\u0007!q\u0003\t\bw\u0005]'\u0011DA.!!\ti)a%\u0002f\tm\u0001\u0003\u0002B\u000f\u0005Gi!Aa\b\u000b\u0007\t\u0005r+\u0001\u0005qe>$xnY8m\u0013\u0011\u0011)Ca\b\u0003\r\u0015\u0013(o\u001c:t\u0003A\u0019'/Z1uKB\u000b'\u000f^5uS>t7\u000f\u0006\u0007\u0002\\\t-\"Q\u0006B#\u0005\u000f\u00129\u0006C\u0004\u0002\u0002n\u0001\r!a\u0011\t\u000f\t=2\u00041\u0001\u00032\u0005ia.Z<QCJ$\u0018\u000e^5p]N\u0004b!!$\u00034\t]\u0012\u0002\u0002B\u001b\u0003\u001f\u00131aU3r!\u0011\u0011IDa\u0010\u000f\t\u0005m%1H\u0005\u0005\u0005{\t),A\u000eDe\u0016\fG/\u001a)beRLG/[8ogJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0005\u0003\u0012\u0019EA\u000bDe\u0016\fG/\u001a)beRLG/[8ogR{\u0007/[2\u000b\t\tu\u0012Q\u0017\u0005\b\u0003\u000b[\u0002\u0019AA\u001d\u0011\u001d\u0011Ie\u0007a\u0001\u0005\u0017\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004BA!\u0014\u0003T5\u0011!q\n\u0006\u0004\u0005#:\u0016a\u00028fi^|'o[\u0005\u0005\u0005+\u0012yE\u0001\u0007MSN$XM\\3s\u001d\u0006lW\rC\u0004\u0003Zm\u0001\r!!6\u0002\u0011\r\fG\u000e\u001c2bG.\fq\u0002Z3tGJL'-Z\"p]\u001aLwm\u001d\u000b\t\u0005?\u0012IH!!\u0003\u0006BA\u0011QRAJ\u0005C\u0012Y\u0007\u0005\u0003\u0003d\t\u001dTB\u0001B3\u0015\tau+\u0003\u0003\u0003j\t\u0015$AD\"p]\u001aLwMU3t_V\u00148-\u001a\t\u0005\u0005[\u0012\u0019H\u0004\u0003\u0002`\n=\u0014\u0002\u0002B9\u0003C\fq\u0003R3tGJL'-Z\"p]\u001aLwm\u001d*fgB|gn]3\n\t\tU$q\u000f\u0002\u0007\u0007>tg-[4\u000b\t\tE\u0014\u0011\u001d\u0005\b\u0005wb\u0002\u0019\u0001B?\u0003U\u0011Xm]8ve\u000e,Gk\\\"p]\u001aLwMT1nKN\u0004\u0002\"!$\u0002\u0014\n\u0005$q\u0010\t\u0006w\u0005M!q\u0002\u0005\b\u0005\u0007c\u0002\u0019AA\u001d\u0003=Ign\u00197vI\u0016\u001c\u0016P\\8os6\u001c\bb\u0002BD9\u0001\u0007!\u0011R\u0001\naJLgnY5qC2\u0004BAa#\u0003\u00166\u0011!Q\u0012\u0006\u0005\u0005\u001f\u0013\t*\u0001\u0003bkRD'b\u0001BJ/\u0006A1/Z2ve&$\u00180\u0003\u0003\u0003\u0018\n5%AD&bM.\f\u0007K]5oG&\u0004\u0018\r\\\u0001\rC2$XM]\"p]\u001aLwm\u001d\u000b\t\u0005;\u0013yJ!-\u00034BA\u0011QRAJ\u0005C\ni\u000eC\u0004\u0003\"v\u0001\rAa)\u0002\u000f\r|gNZ5hgBA\u0011QRAJ\u0005C\u0012)\u000b\u0005\u0003\u0003(\n5f\u0002BAp\u0005SKAAa+\u0002b\u0006\u0019\u0012\t\u001c;fe\u000e{gNZ5hgJ+\u0017/^3ti&!!Q\u000fBX\u0015\u0011\u0011Y+!9\t\u000f\u0005\u0015U\u00041\u0001\u0002:!9!qQ\u000fA\u0002\t%\u0015aD7fi\u0006$\u0017\r^1Va\u0012\fG/\u001a3\u0015\r\u0005m#\u0011\u0018Bd\u0011\u001d\u0011YL\ba\u0001\u0005{\u000bQ\"\u00197m!\u0006\u0014H/\u001b;j_:\u001c\bCBAG\u0005#\u0011y\f\u0005\u0003\u0003B\n\rW\"A,\n\u0007\t\u0015wK\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\t%g\u00041\u0001\u0003>\u0006\tR\u000f\u001d3bi\u0016$\u0007+\u0019:uSRLwN\\:\u0002#\u0005dG/\u001a:U_BL7mQ8oM&<7\u000f\u0006\u0007\u0003P\nU'\u0011\u001cBn\u0005_\u0014)\u0010E\u0004<\u0005#\u0014\t'!8\n\u0007\tMGH\u0001\u0004UkBdWM\r\u0005\b\u0005/|\u0002\u0019\u0001B1\u0003!\u0011Xm]8ve\u000e,\u0007bBAC?\u0001\u0007\u0011\u0011\b\u0005\b\u0005;|\u0002\u0019\u0001Bp\u0003-\u0019wN\u001c4jOB\u0013x\u000e]:\u0011\t\t\u0005(1^\u0007\u0003\u0005GTAA!:\u0003h\u0006!Q\u000f^5m\u0015\t\u0011I/\u0001\u0003kCZ\f\u0017\u0002\u0002Bw\u0005G\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0011\tp\ba\u0001\u0005g\f\u0001cY8oM&<WI\u001c;sS\u0016\u001cX*\u00199\u0011\u0011\u00055\u00151SA3\u0003KBqAa\" \u0001\u0004\u0011I)\u0001\nbYR,'O\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001cH\u0003\u0004Bh\u0005w\u0014iPa@\u0004\u0002\r\r\u0001b\u0002BlA\u0001\u0007!\u0011\r\u0005\b\u0003\u000b\u0003\u0003\u0019AA\u001d\u0011\u001d\u0011i\u000e\ta\u0001\u0005?DqA!=!\u0001\u0004\u0011\u0019\u0010C\u0004\u0003\b\u0002\u0002\rA!#\u0002\u001fQ|Gj\\4hC\ndW\r\u0015:paN$bAa=\u0004\n\r-\u0001b\u0002BlC\u0001\u0007!\u0011\r\u0005\b\u0005;\f\u0003\u0019\u0001Bp\u0003Q\tG\u000e^3s\u0019><G*\u001a<fY\u000e{gNZ5hgR!\u00111LB\t\u0011\u001d\u0019\u0019B\ta\u0001\u0007+\ta\"\u00197uKJ\u001cuN\u001c4jO>\u00038\u000f\u0005\u0004\u0004\u0018\r\u00052q\u0005\b\u0005\u00073\u0019iB\u0004\u0003\u0002l\rm\u0011\"A\u001f\n\u0007\r}A(A\u0004qC\u000e\\\u0017mZ3\n\t\r\r2Q\u0005\u0002\u0005\u0019&\u001cHOC\u0002\u0004 q\u0002Ba!\u000b\u000445\u001111\u0006\u0006\u0005\u0007[\u0019y#A\u0003bI6LgNC\u0002\u00042e\u000bqa\u00197jK:$8/\u0003\u0003\u00046\r-\"!D!mi\u0016\u00148i\u001c8gS\u001e|\u0005/A\u0006hKR\u0014%o\\6fe&#G\u0003BB\u001e\u0007{\u0001RaOA\n\u0003\u0007BqAa6$\u0001\u0004\u0011\t'\u0001\u000bwC2LG-\u0019;f\u0007>tg-[4Q_2L7-\u001f\u000b\t\u00037\u001a\u0019e!\u0012\u0004H!9!q\u001b\u0013A\u0002\t\u0005\u0004b\u0002ByI\u0001\u0007!1\u001f\u0005\b\u0005\u000f#\u0003\u0019\u0001BE\u0003]Ign\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7\u000f\u0006\u0005\u0003\u001e\u000e53\u0011KB*\u0011\u001d\u0011\t+\na\u0001\u0007\u001f\u0002\u0002\"!$\u0002\u0014\n\u00054Q\u0003\u0005\b\u0003\u000b+\u0003\u0019AA\u001d\u0011\u001d\u00119)\na\u0001\u0005\u0013\u000bqC^1mS\u0012\fG/\u001a'pO2+g/\u001a7D_:4\u0017nZ:\u0015\t\u0005m3\u0011\f\u0005\b\u0007'1\u0003\u0019AB\u000b\u0003e\u0001(/\u001a9be\u0016Len\u0019:f[\u0016tG/\u00197D_:4\u0017nZ:\u0015\u0011\u0005m3qLB1\u0007GBqaa\u0005(\u0001\u0004\u0019)\u0002C\u0004\u0003^\u001e\u0002\rAa8\t\u000f\r\u0015t\u00051\u0001\u0004h\u0005Q1m\u001c8gS\u001e\\U-_:\u0011\u0011\u00055\u00151SA3\u0007S\u0002Baa\u001b\u0004v9!1QNB9\u001d\u0011\tija\u001c\n\u00051;\u0016\u0002BB:\u0005K\n\u0011bQ8oM&<G)\u001a4\n\t\r]4\u0011\u0010\u0002\n\u0007>tg-[4LKfTAaa\u001d\u0003f\u0005A1\u000f[;uI><h\u000e\u0006\u0002\u0002\\\u00051\"/Z:pkJ\u001cWMT1nKR{'I]8lKJLE\r\u0006\u0003\u0002D\r\r\u0005bBBCS\u0001\u0007\u0011QM\u0001\re\u0016\u001cx.\u001e:dK:\u000bW.Z\u0001\u000fEJ|7.\u001a:Ts:|g._7t)\u0011\u0019Yi!$\u0011\r\r]1\u0011EA3\u0011\u001d\u0019yI\u000ba\u0001\u0003K\nAA\\1nK\u0006q1m\u001c8gS\u001e\u001c\u0016P\\8os6\u001cH\u0003CBK\u0007;\u001byja)\u0011\r\r]1\u0011EBL!\u0011\u0011ig!'\n\t\rm%q\u000f\u0002\u000e\u0007>tg-[4Ts:|g._7\t\u000f\r=5\u00061\u0001\u0002f!91\u0011U\u0016A\u0002\r-\u0015\u0001C:z]>t\u00170\\:\t\u000f\r\u00156\u00061\u0001\u0002:\u0005Y\u0011n]*f]NLG/\u001b<f\u0003Y\u0019'/Z1uKR{\u0007/[2D_:4\u0017nZ#oiJLH\u0003CBV\u0007\u007f\u001byma5\u0015\r\r561WB[!\u0011\u0011iga,\n\t\rE&q\u000f\u0002\f\u0007>tg-[4F]R\u0014\u0018\u0010C\u0004\u0004\u00102\u0002\r!!\u001a\t\u000f\r]F\u00061\u0001\u0004:\u0006)a/\u00197vKB\u00191ha/\n\u0007\ruFHA\u0002B]fDqa!1-\u0001\u0004\u0019\u0019-A\u0005m_\u001e\u001cuN\u001c4jOB!1QYBf\u001b\t\u00199MC\u0002\u0004JZ\n1\u0001\\8h\u0013\u0011\u0019ima2\u0003\u00131{wmQ8oM&<\u0007bBBiY\u0001\u0007!q\\\u0001\u000bi>\u0004\u0018n\u0019)s_B\u001c\bb\u0002BBY\u0001\u0007\u0011\u0011H\u0001\u0018GJ,\u0017\r^3Ce>\\WM]\"p]\u001aLw-\u00128uef$ba!7\u0004`\u000e\rHCBBW\u00077\u001ci\u000eC\u0004\u0004\u00106\u0002\r!!\u001a\t\u000f\r]V\u00061\u0001\u0004:\"91\u0011]\u0017A\u0002\u0005e\u0012a\u00049fe\n\u0013xn[3s\u0007>tg-[4\t\u000f\t\rU\u00061\u0001\u0002:\u0005\u0011b-\u001b7uKJ$v\u000e]5d\u0007>tg-[4t)\u0019\u0019Ioa>\u0004|B111^By\u0007kl!a!<\u000b\t\r=\u0018qR\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0019\u0019p!<\u0003\r\t+hMZ3s!\u001dY$\u0011[A3\u0007sCqA!)/\u0001\u0004\u0019I\u0010\u0005\u0005\u0002\u000e\u0006M\u0015QMB]\u0011\u001d\u0019iP\fa\u0001\u0005\u007f\n1bY8oM&<g*Y7fg\u0006a\u0011\tZ7j]6\u000bg.Y4feB\u0011q\nM\n\u0003ai\"\"\u0001\"\u0001\u00029Y\fG.\u001b3bi\u0016\fe\u000eZ$fiR{\u0007/[2QY\u0006\u001cW-\\3oiRAA1\u0002C\f\t7!i\u0002E\u0003<\u0003'!i\u0001\u0005\u0003\u0005\u0010\u0011MQB\u0001C\t\u0015\tAf'\u0003\u0003\u0005\u0016\u0011E!A\u0004+pa&\u001c\u0007\u000b\\1dK6,g\u000e\u001e\u0005\u0007\t3\u0011\u0004\u0019\u0001(\u0002\u0017-\fgm[1D_:4\u0017n\u001a\u0005\b\u0007\u0003\u0014\u0004\u0019ABb\u0011\u001d\t\u0019G\ra\u0001\u0003/\u0003")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final KafkaZkClient zkClient;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final AdminZkClient adminZkClient;
    private final Option<CreateTopicPolicy> createTopicPolicy;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final int defaultNumPartitions;
    private final short defaultReplicationFactor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<TopicPlacement> validateAndGetTopicPlacement(KafkaConfig kafkaConfig, LogConfig logConfig, CreateTopicsRequestData.CreatableTopic creatableTopic) {
        return AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, logConfig, creatableTopic);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    private AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    private Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().numDelayed() != 0;
    }

    private int defaultNumPartitions() {
        return this.defaultNumPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Request key ").append(key.keyLabel()).append(" unblocked ").append(completed).append(" topic requests.").toString());
    }

    public void createTopics(int timeout, boolean validateOnly, Map<String, CreateTopicsRequestData.CreatableTopic> toCreate, Map<String, CreateTopicsResponseData.CreatableTopicResult> includeConfigsAndMetatadata, Function1<Map<String, ApiError>, BoxedUnit> responseCallback, boolean createTopicId) {
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), Seq$.MODULE$.canBuildFrom());
        Buffer metadata = ((TraversableOnce)toCreate.values().map((Function1 & Serializable & scala.Serializable)topic -> {
            try {
                scala.collection.mutable.Map map;
                if (this.metadataCache().contains(topic.name())) {
                    throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic.name()).append("' already exists.").toString());
                }
                Properties configs = new Properties();
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)topic.configs()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> configs.setProperty(entry.name(), entry.value()));
                if (topic.replicationFactor() == -1 && !configs.containsKey(LogConfig$.MODULE$.TopicPlacementConstraintsProp())) {
                    Option<TopicPlacement> option = this.config().topicPlacementConstraints();
                    if (option == null) {
                        throw null;
                    }
                    Option<TopicPlacement> foreach_this = option;
                    if (!foreach_this.isEmpty()) {
                        TopicPlacement topicPlacement = (TopicPlacement)foreach_this.get();
                        configs.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), topicPlacement.toJson());
                    }
                }
                LogConfig$.MODULE$.validate(configs);
                LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(this.config()), configs);
                if (!(topic.numPartitions() == -1 && topic.replicationFactor() == -1 || topic.assignments().isEmpty())) {
                    throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                }
                int resolvedNumPartitions = topic.numPartitions() == -1 ? this.defaultNumPartitions() : topic.numPartitions();
                short resolvedReplicationFactor = topic.replicationFactor() == -1 ? this.defaultReplicationFactor() : topic.replicationFactor();
                Option<TopicPlacement> replicaPlacement = AdminManager$.MODULE$.validateAndGetTopicPlacement(this.config(), logConfig, (CreateTopicsRequestData.CreatableTopic)topic);
                if (topic.assignments().isEmpty()) {
                    map = Observer$.MODULE$.getReplicaAssignment((Seq<BrokerMetadata>)brokers, replicaPlacement, resolvedNumPartitions, resolvedReplicationFactor, Observer$.MODULE$.getReplicaAssignment$default$5(), Observer$.MODULE$.getReplicaAssignment$default$6());
                } else {
                    scala.collection.mutable.Map assignments = Map$.MODULE$.empty();
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)topic.assignments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)assignment -> {
                        assignments.update((Object)BoxesRunTime.boxToInteger((int)assignment.partitionIndex()), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(assignment.brokerIds()).asScala()).map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(a)), Buffer$.MODULE$.canBuildFrom())), (Seq<Object>)((Seq)Seq$.MODULE$.empty())));
                        return BoxedUnit.UNIT;
                    });
                    map = assignments;
                }
                scala.collection.mutable.Map assignments = map;
                this.trace((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> AdminManager.$anonfun$createTopics$7(topic, (Map)assignments)));
                Option<CreateTopicPolicy> option = this.createTopicPolicy();
                if (option instanceof Some) {
                    CreateTopicPolicy policy = (CreateTopicPolicy)((Some)option).value();
                    this.adminZkClient().validateTopicCreate(topic.name(), (Map<Object, ReplicaAssignment>)assignments, configs);
                    Integer numPartitions = topic.assignments().isEmpty() ? Predef$.MODULE$.int2Integer(resolvedNumPartitions) : null;
                    Short replicationFactor = topic.assignments().isEmpty() ? Predef$.MODULE$.short2Short(resolvedReplicationFactor) : null;
                    java.util.Map javaAssignments = topic.assignments().isEmpty() ? null : (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)assignments.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        if (x0$1 != null) {
                            int k = x0$1._1$mcI$sp();
                            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
                            Object object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)v.replicas().map((Function1 & Serializable & scala.Serializable)i -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)i)), Seq$.MODULE$.canBuildFrom())).asJava();
                            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(k));
                            if (Predef.ArrowAssoc$.MODULE$ == null) {
                                throw null;
                            }
                        } else {
                            throw new MatchError(null);
                        }
                        Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                        return tuple2;
                    }, scala.collection.Map$.MODULE$.canBuildFrom())).asJava();
                    HashMap javaConfigs = new HashMap();
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)topic.configs()).asScala()).foreach((Function1 & Serializable & scala.Serializable)config -> javaConfigs.put(config.name(), config.value()));
                    policy.validate(new CreateTopicPolicy.RequestMetadata(topic.name(), numPartitions, replicationFactor, javaAssignments, javaConfigs));
                    if (!validateOnly) {
                        this.adminZkClient().createTopicWithAssignment(topic.name(), configs, (Map<Object, ReplicaAssignment>)assignments, createTopicId);
                    }
                } else if (None$.MODULE$.equals(option)) {
                    if (validateOnly) {
                        this.adminZkClient().validateTopicCreate(topic.name(), (Map<Object, ReplicaAssignment>)assignments, configs);
                    } else {
                        this.adminZkClient().createTopicWithAssignment(topic.name(), configs, (Map<Object, ReplicaAssignment>)assignments, createTopicId);
                    }
                } else {
                    throw new MatchError(option);
                }
                Option option2 = includeConfigsAndMetatadata.get((Object)topic.name());
                if (option2 == null) {
                    throw null;
                }
                Option foreach_this = option2;
                if (!foreach_this.isEmpty()) {
                    CreateTopicsResponseData.CreatableTopicResult creatableTopicResult = (CreateTopicsResponseData.CreatableTopicResult)foreach_this.get();
                    AdminManager.$anonfun$createTopics$11(this, logConfig, configs, (Map)assignments, creatableTopicResult);
                }
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)assignments.keySet(), ApiError.NONE);
            }
            catch (TopicExistsException e) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Topic creation failed since topic '").append(topic.name()).append("' already exists.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
            catch (ApiException e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
            catch (ConfigException e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)new InvalidConfigurationException(e.getMessage(), e.getCause())));
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
        }, Iterable$.MODULE$.canBuildFrom())).toBuffer();
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$25(x$4)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createTopicMetadata -> {
                if (createTopicMetadata.error().isSuccess() && !validateOnly) {
                    return new Tuple2((Object)createTopicMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null));
                }
                return new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error());
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
            return;
        }
        DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata, this, responseCallback);
        Buffer delayedCreateKeys = ((TraversableOnce)toCreate.values().map((Function1 & Serializable & scala.Serializable)topic -> new TopicKey(topic.name()), Iterable$.MODULE$.canBuildFrom())).toBuffer();
        this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
    }

    public boolean createTopics$default$6() {
        return false;
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1 & Serializable & scala.Serializable)topic -> {
            try {
                this.adminZkClient().deleteTopic((String)topic);
                return new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                return new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error processing delete topic request for topic ").append((String)topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new DeleteTopicMetadata((String)topic, Errors.forException((Throwable)e));
            }
        }, Set$.MODULE$.canBuildFrom());
        if (timeout <= 0 || !metadata.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$deleteTopics$4(x$5)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)deleteTopicMetadata -> {
                Errors errors = deleteTopicMetadata.error();
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    return new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT);
                }
                return new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
            return;
        }
        DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
        Seq delayedDeleteKeys = ((SetLike)topics.map((Function1 & Serializable & scala.Serializable)x$6 -> new TopicKey((String)x$6), Set$.MODULE$.canBuildFrom())).toSeq();
        this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
    }

    public void createPartitions(int timeout, Seq<CreatePartitionsRequestData.CreatePartitionsTopic> newPartitions, boolean validateOnly, ListenerName listenerName, Function1<Map<String, ApiError>, BoxedUnit> callback) {
        Seq<BrokerMetadata> allBrokers = this.adminZkClient().getBrokerMetadatas(this.adminZkClient().getBrokerMetadatas$default$1(), this.adminZkClient().getBrokerMetadatas$default$2());
        Seq allBrokerIds = (Seq)allBrokers.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map allBrokerProperties = ((TraversableOnce)allBrokers.map((Function1 & Serializable & scala.Serializable)broker -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Option<String> option = broker.rack();
            if (option == null) {
                throw null;
            }
            Option<String> map_this = option;
            Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)AdminManager.$anonfun$createPartitions$3((String)map_this.get()));
            scala.collection.immutable.Map map = Option$.MODULE$.option2Iterable((Option)object).toMap(Predef$.MODULE$.$conforms());
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)broker.id()));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq metadata = (Seq)newPartitions.map((Function1 & Serializable & scala.Serializable)newPartition -> {
            String topic = newPartition.name();
            try {
                None$ none$;
                Map existingAssignment = (Map)this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    void $minus$greater$extension_$this;
                    ReplicaAssignment assignment;
                    if (x0$1 != null) {
                        TopicPartition topicPartition = (TopicPartition)x0$1._1();
                        assignment = (ReplicaAssignment)x0$1._2();
                        if (assignment.isBeingReassigned()) {
                            throw new ReassignmentInProgressException(new StringBuilder(57).append("A partition reassignment is in progress for the topic '").append(topic).append("'.").toString());
                        }
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                    } else {
                        throw new MatchError(null);
                    }
                    Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment);
                    return tuple2;
                }, scala.collection.Map$.MODULE$.canBuildFrom());
                if (existingAssignment.isEmpty()) {
                    throw new UnknownTopicOrPartitionException(new StringBuilder(28).append("The topic '").append(topic).append("' does not exist.").toString());
                }
                int oldNumPartitions = existingAssignment.size();
                int newNumPartitions = newPartition.count();
                int numPartitionsIncrement = newNumPartitions - oldNumPartitions;
                if (numPartitionsIncrement < 0) {
                    throw new InvalidPartitionsException(new StringBuilder(69).append("Topic currently has ").append(oldNumPartitions).append(" partitions, which is higher than the requested ").append(newNumPartitions).append(".").toString());
                }
                if (numPartitionsIncrement == 0) {
                    throw new InvalidPartitionsException(new StringBuilder(30).append("Topic already has ").append(oldNumPartitions).append(" partitions.").toString());
                }
                Option<TopicPlacement> topicPlacement = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(this.config()), this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic)).topicPlacementConstraints();
                Option option = Option$.MODULE$.apply((Object)newPartition.assignments());
                if (option == null) {
                    throw null;
                }
                Option map_this = option;
                if (map_this.isEmpty()) {
                    none$ = None$.MODULE$;
                } else {
                    java.util.List list = (java.util.List)map_this.get();
                    none$ = new Some((Object)AdminManager.$anonfun$createPartitions$6(allBrokerIds, numPartitionsIncrement, topicPlacement, allBrokerProperties, existingAssignment, list));
                }
                if (Predef$.MODULE$.Boolean2boolean(this.config().applyCreateTopicsPolicyToCreatePartitions())) {
                    Option<CreateTopicPolicy> option2 = this.createTopicPolicy();
                    if (option2 instanceof Some) {
                        ((CreateTopicPolicy)((Some)option2).value()).validate(new CreateTopicPolicy.RequestMetadata(topic, Predef$.MODULE$.int2Integer(numPartitionsIncrement), null, null, new HashMap()));
                    } else if (!None$.MODULE$.equals(option2)) {
                        throw new MatchError(option2);
                    }
                }
                Map<Object, ReplicaAssignment> updatedReplicaAssignment = this.adminZkClient().addPartitions(topic, (Map<Object, ReplicaAssignment>)existingAssignment, allBrokers, newPartition.count(), (Option<Map<Object, ReplicaAssignment>>)none$, validateOnly, topicPlacement);
                return new CreatePartitionsMetadata(topic, (Set<Object>)updatedReplicaAssignment.keySet(), ApiError.NONE);
            }
            catch (AdminOperationException e) {
                return new CreatePartitionsMetadata(topic, (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
            catch (ApiException e) {
                return new CreatePartitionsMetadata(topic, (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createPartitions$11(x$10)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createPartitionMetadata -> {
                if (createPartitionMetadata.error().isSuccess() && !validateOnly) {
                    return new Tuple2((Object)createPartitionMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null));
                }
                return new Tuple2((Object)createPartitionMetadata.topic(), (Object)createPartitionMetadata.error());
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            callback.apply((Object)results);
            return;
        }
        DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata, this, callback);
        Seq delayedCreateKeys = (Seq)newPartitions.map((Function1 & Serializable & scala.Serializable)createPartitionTopic -> new TopicKey(createPartitionTopic.name()), Seq$.MODULE$.canBuildFrom());
        this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
    }

    public Map<ConfigResource, DescribeConfigsResponse.Config> describeConfigs(Map<ConfigResource, Option<Set<String>>> resourceToConfigNames, boolean includeSynonyms, KafkaPrincipal principal) {
        return ((TraversableOnce)resourceToConfigNames.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                Option configNames = (Option)x0$1._2();
                try {
                    void $minus$greater$extension_$this;
                    DescribeConfigsResponse.Config config;
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        DescribeConfigsResponse.Config config2;
                        String topic = resource.name();
                        Topic.validate((String)topic);
                        if (this.metadataCache().contains(topic)) {
                            void createResponseConfig$1_createConfigEntry;
                            Properties topicProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
                            LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(this.config()), topicProps);
                            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, (String)name, value);
                            scala.collection.mutable.Map createResponseConfig$1_configs = AdminManager.allConfigs$1(logConfig);
                            Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)configNames).map(arg_0 -> AdminManager.$anonfun$describeConfigs$3((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                            config2 = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                        } else {
                            config2 = new DescribeConfigsResponse.Config(new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, null), Collections.emptyList());
                        }
                        config = config2;
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        DescribeConfigsResponse.Config config3;
                        if (resource.name() == null || resource.name().isEmpty()) {
                            void createResponseConfig$1_createConfigEntry;
                            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, (String)name, value);
                            Map<String, String> createResponseConfig$1_configs = this.config().dynamicConfig().currentDynamicDefaultConfigs();
                            Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs(createResponseConfig$1_configs, (Option<Set<String>>)configNames).map(arg_0 -> AdminManager.$anonfun$describeConfigs$3((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                            config3 = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                        } else if (this.resourceNameToBrokerId(resource.name()) == this.config().brokerId()) {
                            void createResponseConfig$1_createConfigEntry;
                            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, (String)name, value);
                            scala.collection.mutable.Map createResponseConfig$1_configs = AdminManager.allConfigs$1(this.config());
                            Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)configNames).map(arg_0 -> AdminManager.$anonfun$describeConfigs$3((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                            config3 = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                        } else {
                            throw new InvalidRequestException(new StringBuilder(62).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(" or empty string, but received ").append(resource.name()).toString());
                        }
                        config = config3;
                    } else if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                        void createResponseConfig$1_createConfigEntry;
                        if (resource.name() == null || resource.name().isEmpty()) {
                            throw new InvalidRequestException("Broker id must not be empty");
                        }
                        if (this.resourceNameToBrokerId(resource.name()) != this.config().brokerId()) {
                            throw new InvalidRequestException(new StringBuilder(45).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(" but received ").append(resource.name()).toString());
                        }
                        this.validateConfigPolicy(resource, (Map<String, String>)scala.collection.Map$.MODULE$.empty(), principal);
                        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> new DescribeConfigsResponse.ConfigEntry(name, value.toString(), DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG, false, false, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava());
                        scala.collection.mutable.Map<String, String> createResponseConfig$1_configs = Log4jController$.MODULE$.loggers();
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)configNames).map(arg_0 -> AdminManager.$anonfun$describeConfigs$3((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                        config = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                    } else {
                        throw new InvalidRequestException(new StringBuilder(27).append("Unsupported resource type: ").append(type).toString());
                    }
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)config);
                }
                catch (Throwable e) {
                    void $minus$greater$extension_y;
                    void $minus$greater$extension_$this;
                    String message = new StringBuilder(55).append("Error processing describe configs request for resource ").append(resource).toString();
                    if (e instanceof ApiException) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    } else {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    }
                    DescribeConfigsResponse.Config config = new DescribeConfigsResponse.Config(ApiError.fromThrowable((Throwable)e), Collections.emptyList());
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<ConfigResource, ApiError> alterConfigs(Map<ConfigResource, AlterConfigsRequest.Config> configs, boolean validateOnly, KafkaPrincipal principal) {
        return ((TraversableOnce)configs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                AlterConfigsRequest.Config config = (AlterConfigsRequest.Config)x0$1._2();
                try {
                    Tuple2 tuple22;
                    scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), (Object)entry.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    Properties configProps = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)configEntry -> configProps.setProperty(configEntry.name(), configEntry.value()));
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        tuple22 = this.alterTopicConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap, principal);
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        tuple22 = this.alterBrokerConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap, principal);
                    } else {
                        throw new InvalidRequestException(new StringBuilder(76).append("AlterConfigs is only supported for topics and brokers, but resource type is ").append(type).toString());
                    }
                    tuple2 = tuple22;
                }
                catch (Throwable throwable) {
                    Tuple2 tuple23;
                    boolean bl = throwable instanceof ConfigException ? true : throwable instanceof IllegalArgumentException;
                    if (bl) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        String message = new StringBuilder(36).append("Invalid config value for resource ").append(resource).append(": ").append(throwable.getMessage()).toString();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                        ApiError apiError = ApiError.fromThrowable((Throwable)new InvalidRequestException(message, throwable));
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple23 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else if (throwable != null) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        Properties configProps = new Properties();
                        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$alterConfigs$5(x$12)))).foreach((Function1 & Serializable & scala.Serializable)configEntry -> configProps.setProperty(configEntry.name(), configEntry.value()));
                        String message = new StringBuilder(61).append("Error processing alter configs request for resource ").append(resource).append(", config ").append(this.toLoggableProps(resource, configProps).mkString(",")).toString();
                        if (throwable instanceof ApiException) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                        } else {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                        }
                        ApiError apiError = ApiError.fromThrowable((Throwable)throwable);
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple23 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else {
                        throw null;
                    }
                    tuple2 = tuple23;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple24 = tuple2;
            return tuple24;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    public void metadataUpdated(Set<TopicPartition> allPartitions, Set<TopicPartition> updatedPartitions) {
        void collect_pf;
        Option<CreateTopicPolicy> option = this.createTopicPolicy();
        scala.Serializable serializable = new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends CreateTopicPolicy, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof TopicMetadataListener ? x1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(CreateTopicPolicy x1) {
                boolean bl = x1 instanceof TopicMetadataListener;
                return bl;
            }
        };
        if (option == null) {
            throw null;
        }
        Option<CreateTopicPolicy> collect_this = option;
        Object object = !collect_this.isEmpty() ? (Option)collect_pf.lift().apply(collect_this.get()) : None$.MODULE$;
        if (object == null) {
            throw null;
        }
        if (!object.isEmpty()) {
            CreateTopicPolicy createTopicPolicy = (CreateTopicPolicy)object.get();
            AdminManager.$anonfun$metadataUpdated$2(allPartitions, createTopicPolicy);
        }
        if (this.hasDelayedTopicOperations()) {
            ((IterableLike)updatedPartitions.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.topic(), Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)topic -> {
                this.tryCompleteDelayedTopicOperations(topic);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<ConfigResource, ApiError> alterTopicConfigs(ConfigResource resource, boolean validateOnly, Properties configProps, Map<String, String> configEntriesMap, KafkaPrincipal principal) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        String topic = resource.name();
        java.util.Map<String, Object> currentDefault = this.config().originals();
        LogConfig currentConfigs = LogConfig$.MODULE$.fromProps(currentDefault, this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic));
        LogConfig proposedConfigs = LogConfig$.MODULE$.fromProps(currentDefault, configProps);
        LogConfig$.MODULE$.validateChange(currentConfigs, proposedConfigs, this.config().interBrokerProtocolVersion());
        this.adminZkClient().validateTopicConfig(topic, configProps);
        this.validateConfigPolicy(resource, configEntriesMap, principal);
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Updating topic ").append(topic).append(" with new configuration : ").append(this.toLoggableProps(resource, configProps).mkString(",")).toString());
            this.adminZkClient().changeTopicConfig(topic, configProps);
        }
        ApiError apiError = ApiError.NONE;
        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<ConfigResource, ApiError> alterBrokerConfigs(ConfigResource resource, boolean validateOnly, Properties configProps, Map<String, String> configEntriesMap, KafkaPrincipal principal) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Option<Object> brokerId = this.getBrokerId(resource);
        boolean perBrokerConfig = brokerId.nonEmpty();
        this.config().dynamicConfig().validate(configProps, perBrokerConfig);
        this.validateConfigPolicy(resource, configEntriesMap, principal);
        if (!validateOnly) {
            if (perBrokerConfig) {
                this.config().dynamicConfig().reloadUpdatedFilesWithoutConfigChange(configProps);
            }
            if (perBrokerConfig) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Updating broker ").append(brokerId.get()).append(" with new configuration : ").append(this.toLoggableProps(resource, configProps).mkString(",")).toString());
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Updating brokers with new configuration : ").append(this.toLoggableProps(resource, configProps).mkString(",")).toString());
            }
            this.adminZkClient().changeBrokerConfig(brokerId, this.config().dynamicConfig().toPersistentProps(configProps, perBrokerConfig));
        }
        ApiError apiError = ApiError.NONE;
        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    private Map<String, String> toLoggableProps(ConfigResource resource, Properties configProps) {
        return (Map)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configProps).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)key, (Object)KafkaConfig$.MODULE$.loggableValue(resource.type(), key, value));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    private void alterLogLevelConfigs(List<AlterConfigOp> alterConfigOps) {
        if (alterConfigOps == null) {
            throw null;
        }
        List foreach_these = alterConfigOps;
        while (!foreach_these.isEmpty()) {
            AlterConfigOp alterConfigOp = (AlterConfigOp)foreach_these.head();
            AdminManager.$anonfun$alterLogLevelConfigs$1(this, alterConfigOp);
            foreach_these = (List)foreach_these.tail();
        }
    }

    private Option<Object> getBrokerId(ConfigResource resource) {
        if (resource.name() == null || resource.name().isEmpty()) {
            return None$.MODULE$;
        }
        int id = this.resourceNameToBrokerId(resource.name());
        if (id != this.config().brokerId()) {
            throw new InvalidRequestException(new StringBuilder(46).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(", but received ").append(resource.name()).toString());
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)id));
    }

    private void validateConfigPolicy(ConfigResource resource, Map<String, String> configEntriesMap, KafkaPrincipal principal) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy();
        if (option instanceof Some) {
            ((AlterConfigPolicy)((Some)option).value()).validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resource.type(), resource.name()), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(configEntriesMap).asJava(), principal));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public Map<ConfigResource, ApiError> incrementalAlterConfigs(Map<ConfigResource, List<AlterConfigOp>> configs, boolean validateOnly, KafkaPrincipal principal) {
        return ((TraversableOnce)configs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2<ConfigResource, ApiError> tuple2;
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                List alterConfigOps = (List)x0$1._2();
                try {
                    Tuple2<ConfigResource, ApiError> tuple22;
                    Object object;
                    void map_bf;
                    scala.collection.immutable.Set duplicateKeys = ((MapLike)alterConfigOps.groupBy((Function1 & Serializable & scala.Serializable)config -> config.configEntry().name()).mapValues((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.size())).filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$incrementalAlterConfigs$4(x$15)))).keys().toSet();
                    if (duplicateKeys.nonEmpty()) {
                        throw new InvalidRequestException(new StringBuilder(37).append("Error due to duplicate config keys : ").append(duplicateKeys.mkString(",")).toString());
                    }
                    CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
                    Function1 & Serializable & scala.Serializable map_f = (Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.configEntry().name(), (Object)entry.configEntry().value());
                    if (map_bf == List$.MODULE$.ReusableCBF()) {
                        if (alterConfigOps == Nil$.MODULE$) {
                            object = Nil$.MODULE$;
                        } else {
                            .colon.colon map_h;
                            .colon.colon map_t = map_h = new .colon.colon((Object)AdminManager.$anonfun$incrementalAlterConfigs$5((AlterConfigOp)alterConfigOps.head()), (List)Nil$.MODULE$);
                            for (List map_rest = (List)alterConfigOps.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                                .colon.colon map_nx = new .colon.colon((Object)AdminManager.$anonfun$incrementalAlterConfigs$5((AlterConfigOp)map_rest.head()), (List)Nil$.MODULE$);
                                map_t.tl_$eq((List)map_nx);
                                map_t = map_nx;
                            }
                            object = map_h;
                        }
                    } else {
                        object = TraversableLike.map$((TraversableLike)alterConfigOps, (Function1)map_f, (CanBuildFrom)map_bf);
                    }
                    scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)object).toMap(Predef$.MODULE$.$conforms());
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        Properties configProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), resource.name());
                        this.prepareIncrementalConfigs((List<AlterConfigOp>)alterConfigOps, configProps, LogConfig$.MODULE$.configKeys());
                        tuple22 = this.alterTopicConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap, principal);
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        Option<Object> brokerId = this.getBrokerId(resource);
                        boolean perBrokerConfig = brokerId.nonEmpty();
                        Properties persistentProps = perBrokerConfig ? this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), brokerId.get().toString()) : this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default());
                        Properties configProps = this.config().dynamicConfig().fromPersistentProps(persistentProps, perBrokerConfig);
                        this.prepareIncrementalConfigs((List<AlterConfigOp>)alterConfigOps, configProps, KafkaConfig$.MODULE$.configKeys());
                        tuple22 = this.alterBrokerConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap, principal);
                    } else if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        this.getBrokerId(resource);
                        this.validateConfigPolicy(resource, (Map<String, String>)scala.collection.Map$.MODULE$.empty(), principal);
                        this.validateLogLevelConfigs((List<AlterConfigOp>)alterConfigOps);
                        if (!validateOnly) {
                            this.alterLogLevelConfigs((List<AlterConfigOp>)alterConfigOps);
                        }
                        ApiError apiError = ApiError.NONE;
                        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple22 = new Tuple2<ConfigResource, ApiError>((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else {
                        throw new InvalidRequestException(new StringBuilder(76).append("AlterConfigs is only supported for topics and brokers, but resource type is ").append(type).toString());
                    }
                    tuple2 = tuple22;
                }
                catch (Throwable throwable) {
                    Tuple2<ConfigResource, ApiError> tuple23;
                    boolean bl = throwable instanceof ConfigException ? true : throwable instanceof IllegalArgumentException;
                    if (bl) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        String message = new StringBuilder(36).append("Invalid config value for resource ").append(resource).append(": ").append(throwable.getMessage()).toString();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                        ApiError apiError = ApiError.fromThrowable((Throwable)new InvalidRequestException(message, throwable));
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple23 = new Tuple2<ConfigResource, ApiError>((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else if (throwable != null) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        String message = new StringBuilder(61).append("Error processing alter configs request for resource ").append(resource).append(", config ").append(alterConfigOps).toString();
                        if (throwable instanceof ApiException) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                        } else {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                        }
                        ApiError apiError = ApiError.fromThrowable((Throwable)throwable);
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple23 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else {
                        throw null;
                    }
                    tuple2 = tuple23;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2<ConfigResource, ApiError> tuple24 = tuple2;
            return tuple24;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private void validateLogLevelConfigs(List<AlterConfigOp> alterConfigOps) {
        if (alterConfigOps == null) {
            throw null;
        }
        List foreach_these = alterConfigOps;
        while (!foreach_these.isEmpty()) {
            AdminManager.$anonfun$validateLogLevelConfigs$1((AlterConfigOp)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
    }

    private void prepareIncrementalConfigs(List<AlterConfigOp> alterConfigOps, Properties configProps, Map<String, ConfigDef.ConfigKey> configKeys) {
        if (alterConfigOps == null) {
            throw null;
        }
        List foreach_these = alterConfigOps;
        while (!foreach_these.isEmpty()) {
            AlterConfigOp alterConfigOp = (AlterConfigOp)foreach_these.head();
            AdminManager.$anonfun$prepareIncrementalConfigs$1(configProps, configKeys, alterConfigOp);
            foreach_these = (List)foreach_these.tail();
        }
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option<CreateTopicPolicy> option = this.createTopicPolicy();
            if (option == null) {
                throw null;
            }
            Option<CreateTopicPolicy> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                ((CreateTopicPolicy)foreach_this.get()).close();
                return;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option<AlterConfigPolicy> option = this.alterConfigPolicy();
            if (option == null) {
                throw null;
            }
            Option<AlterConfigPolicy> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                ((AlterConfigPolicy)foreach_this.get()).close();
                return;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
    }

    private int resourceNameToBrokerId(String resourceName) {
        try {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return new StringOps(resourceName).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(41).append("Broker id must be an integer, but it is: ").append(resourceName).toString());
        }
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private List<DescribeConfigsResponse.ConfigSynonym> configSynonyms(String name, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config().dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map<String, String> map = dynamicConfig.currentDynamicBrokerConfigs();
        if (synonyms == null) {
            throw null;
        }
        List foreach_these = synonyms;
        while (!foreach_these.isEmpty()) {
            String string = (String)foreach_these.head();
            AdminManager.maybeAddSynonym$1(map, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, string, isSensitive, allSynonyms);
            foreach_these = (List)foreach_these.tail();
        }
        Map<String, String> map2 = dynamicConfig.currentDynamicDefaultConfigs();
        List foreach_these2 = synonyms;
        while (!foreach_these2.isEmpty()) {
            String string = (String)foreach_these2.head();
            AdminManager.maybeAddSynonym$1(map2, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, string, isSensitive, allSynonyms);
            foreach_these2 = (List)foreach_these2.tail();
        }
        List foreach_these3 = synonyms;
        while (!foreach_these3.isEmpty()) {
            String string = (String)foreach_these3.head();
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, string, isSensitive, allSynonyms);
            foreach_these3 = (List)foreach_these3.tail();
        }
        List foreach_these4 = synonyms;
        while (!foreach_these4.isEmpty()) {
            String string = (String)foreach_these4.head();
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, string, isSensitive, allSynonyms);
            foreach_these4 = (List)foreach_these4.tail();
        }
        return ((TraversableOnce)allSynonyms.dropWhile((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$configSynonyms$6(name, s)))).toList();
    }

    /*
     * WARNING - void declaration
     */
    private DescribeConfigsResponse.ConfigEntry createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, String name, Object value) {
        Object object;
        None$ none$;
        String string;
        Option<ConfigDef.Type> configEntryType = LogConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        if (isSensitive) {
            string = null;
        } else {
            void orNull_ev;
            Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
            if (configEntryType == null) {
                throw null;
            }
            Object object2 = configEntryType.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : configEntryType.get();
            string = ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)object2));
        }
        String valueAsString = string;
        Option option = LogConfig$.MODULE$.TopicConfigSynonyms().get((Object)name);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String string2 = (String)map_this.get();
            none$ = new Some((Object)this.configSynonyms(string2, this.brokerSynonyms(string2), isSensitive));
        }
        if (none$ == null) {
            throw null;
        }
        Object object3 = none$.isEmpty() ? List$.MODULE$.empty() : none$.get();
        Object list = object3;
        if (!topicProps.containsKey(name)) {
            object = list;
        } else {
            DescribeConfigsResponse.ConfigSynonym configSynonym = new DescribeConfigsResponse.ConfigSynonym(name, valueAsString, DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG);
            object = (List)list.$plus$colon((Object)configSynonym, List$.MODULE$.canBuildFrom());
        }
        Object allSynonyms = object;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        Object synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, false, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    /*
     * WARNING - void declaration
     */
    private DescribeConfigsResponse.ConfigEntry createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, String name, Object value) {
        String string;
        List<String> allNames = this.brokerSynonyms(name);
        Option<ConfigDef.Type> configEntryType = KafkaConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        if (isSensitive) {
            string = null;
        } else {
            String string2;
            if (value instanceof String) {
                string2 = (String)value;
            } else {
                void orNull_ev;
                Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
                if (configEntryType == null) {
                    throw null;
                }
                Object object = configEntryType.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : configEntryType.get();
                string2 = ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)object));
            }
            string = string2;
        }
        String valueAsString = string;
        List allSynonyms = (List)this.configSynonyms(name, allNames, isSensitive).filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$20)));
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        boolean readOnly = !DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)name);
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, readOnly, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    private Buffer<Tuple2<String, Object>> filterTopicConfigs(Map<String, Object> configs, Option<Set<String>> configNames) {
        return ((MapLike)configs.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$filterTopicConfigs$1(this, configNames, x0$1)))).toBuffer();
    }

    public static final /* synthetic */ String $anonfun$createTopics$7(CreateTopicsRequestData.CreatableTopic topic$1, Map assignments$2) {
        return new StringBuilder(28).append("Assignments for topic ").append(topic$1).append(" are ").append(assignments$2).append(" ").toString();
    }

    public static final /* synthetic */ byte $anonfun$createTopics$14(int x$3) {
        return (byte)x$3;
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$15(DescribeConfigsResponse.ConfigEntry entry$1, byte i) {
        DescribeConfigsResponse.ConfigSource configSource = DescribeConfigsResponse.ConfigSource.forId((byte)i);
        DescribeConfigsResponse.ConfigSource configSource2 = entry$1.source();
        return !(configSource != null ? !configSource.equals(configSource2) : configSource2 != null);
    }

    public static final /* synthetic */ byte $anonfun$createTopics$16() {
        return (byte)0;
    }

    public static final /* synthetic */ CreateTopicsResponseData.CreatableTopicResult $anonfun$createTopics$11(AdminManager $this, LogConfig logConfig$1, Properties configs$1, Map assignments$2, CreateTopicsResponseData.CreatableTopicResult result) {
        Function2 & Serializable & scala.Serializable createEntry = (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> $this.createTopicConfigEntry(logConfig$1, configs$1, false, (String)x$1, x$2);
        java.util.List topicConfigs = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)$this.filterTopicConfigs((Map<String, Object>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(logConfig$1.values()).asScala()), (Option<Set<String>>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Option option;
            DescribeConfigsResponse.ConfigEntry entry;
            String k;
            if (x0$2 != null) {
                k = (String)x0$2._1();
                Object v = x0$2._2();
                entry = (DescribeConfigsResponse.ConfigEntry)createEntry.apply((Object)k, v);
                option = ((IterableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DescribeConfigsResponse.ConfigSource.values())).indices().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToByte((byte)AdminManager.$anonfun$createTopics$14(BoxesRunTime.unboxToInt((Object)x$3))), IndexedSeq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$15(entry, BoxesRunTime.unboxToByte((Object)i))));
                if (option == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToByte((byte)AdminManager.$anonfun$createTopics$16()) : getOrElse_this.get();
            byte source = BoxesRunTime.unboxToByte((Object)object);
            CreateTopicsResponseData.CreatableTopicConfigs creatableTopicConfigs = new CreateTopicsResponseData.CreatableTopicConfigs().setConfigName(k).setValue(entry.value()).setIsSensitive(entry.isSensitive()).setReadOnly(entry.isReadOnly()).setConfigSource(source);
            return creatableTopicConfigs;
        }, Buffer$.MODULE$.canBuildFrom())).toList()).asJava();
        result.setConfigs(topicConfigs);
        result.setNumPartitions(assignments$2.size());
        return result.setReplicationFactor((short)((ReplicaAssignment)assignments$2.apply((Object)BoxesRunTime.boxToInteger((int)0))).replicas().size());
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$25(CreatePartitionsMetadata x$4) {
        return x$4.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopics$4(DeleteTopicMetadata x$5) {
        Errors errors = x$5.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$createPartitions$3(String x$8) {
        void $minus$greater$extension_$this;
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"rack");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)x$8);
    }

    public static final /* synthetic */ Nothing$ $anonfun$createPartitions$10(ApiError err) {
        throw err.exception();
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createPartitions$6(Seq allBrokerIds$1, int numPartitionsIncrement$1, Option topicPlacement$1, scala.collection.immutable.Map allBrokerProperties$1, Map existingAssignment$1, java.util.List assignmentMap) {
        Buffer assignments = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(assignmentMap).asScala()).map((Function1 & Serializable & scala.Serializable)createPartitionAssignment -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(createPartitionAssignment.brokerIds()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$9)), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set unknownBrokers = (scala.collection.immutable.Set)((TraversableOnce)assignments.flatten((Function1)Predef$.MODULE$.$conforms())).toSet().$minus$minus((GenTraversableOnce)allBrokerIds$1);
        if (unknownBrokers.nonEmpty()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(42).append("Unknown broker(s) in replica assignment: ").append(unknownBrokers.mkString(", ")).append(".").toString());
        }
        if (assignments.size() != numPartitionsIncrement$1) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(66).append("Increasing the number of partitions by ").append(numPartitionsIncrement$1).append(" ").append("but ").append(assignments.size()).append(" assignments provided.").toString());
        }
        return ((TraversableOnce)((TraversableLike)assignments.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$2 != null) {
                Buffer replicas = (Buffer)x0$2._1();
                int index = x0$2._2$mcI$sp();
                Option<ApiError> maybeError = Observer$.MODULE$.validateAssignment((Option<TopicPlacement>)topicPlacement$1, new ReplicaAssignment.Assignment((Seq<Object>)replicas, (Seq<Object>)((Seq)Seq$.MODULE$.empty())), (Map<Object, Map<String, String>>)allBrokerProperties$1);
                if (maybeError == null) {
                    throw null;
                }
                if (!maybeError.isEmpty()) {
                    throw AdminManager.$anonfun$createPartitions$10((ApiError)maybeError.get());
                }
                ReplicaAssignment replicaAssignment = ReplicaAssignment$.MODULE$.apply((Seq<Object>)replicas, (Seq<Object>)((Seq)Seq$.MODULE$.empty()));
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(existingAssignment$1.size() + index)));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$createPartitions$11(CreatePartitionsMetadata x$10) {
        return x$10.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$2(Tuple2 x$11) {
        return x$11._2() != null;
    }

    private static final scala.collection.mutable.Map allConfigs$1(AbstractConfig config) {
        return ((scala.collection.mutable.MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$2(x$11)))).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala());
    }

    private final DescribeConfigsResponse.Config createResponseConfig$1(Map configs, Function2 createConfigEntry, Option configNames$1) {
        Buffer configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)configs, (Option<Set<String>>)configNames$1).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            Object value = x0$1._2();
            DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createConfigEntry.apply((Object)name, value);
            return configEntry;
        }, Buffer$.MODULE$.canBuildFrom());
        return new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(configEntries).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$alterConfigs$5(AlterConfigsRequest.ConfigEntry x$12) {
        return x$12.value() != null;
    }

    public static final /* synthetic */ void $anonfun$metadataUpdated$2(Set allPartitions$1, CreateTopicPolicy l) {
        ((TopicMetadataListener)l).topicMetadataUpdated((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter(allPartitions$1).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$alterLogLevelConfigs$1(AdminManager $this, AlterConfigOp alterConfigOp) {
        boolean bl;
        String loggerName = alterConfigOp.configEntry().name();
        String logLevel = alterConfigOp.configEntry().value();
        AlterConfigOp.OpType opType = alterConfigOp.opType();
        if (AlterConfigOp.OpType.SET.equals(opType)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Updating the log level of ").append(loggerName).append(" to ").append(logLevel).toString());
            bl = Log4jController$.MODULE$.logLevel(loggerName, logLevel);
        } else if (AlterConfigOp.OpType.DELETE.equals(opType)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Unset the log level of ").append(loggerName).toString());
            bl = Log4jController$.MODULE$.unsetLogLevel(loggerName);
        } else {
            throw new IllegalArgumentException(new StringBuilder(40).append("Log level cannot be changed for OpType: ").append(alterConfigOp.opType()).toString());
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$incrementalAlterConfigs$4(Tuple2 x$15) {
        return x$15._2$mcI$sp() > 1;
    }

    private static final void validateLoggerNameExists$1(String loggerName) {
        if (!Log4jController$.MODULE$.loggerExists(loggerName)) {
            throw new ConfigException(new StringBuilder(23).append("Logger ").append(loggerName).append(" does not exist!").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$validateLogLevelConfigs$1(AlterConfigOp alterConfigOp) {
        block8: {
            AlterConfigOp.OpType opType;
            block9: {
                block11: {
                    String string;
                    String string2;
                    block10: {
                        String loggerName;
                        block7: {
                            loggerName = alterConfigOp.configEntry().name();
                            opType = alterConfigOp.opType();
                            if (!AlterConfigOp.OpType.SET.equals(opType)) break block7;
                            AdminManager.validateLoggerNameExists$1(loggerName);
                            String logLevel = alterConfigOp.configEntry().value();
                            if (!LogLevelConfig.VALID_LOG_LEVELS.contains(logLevel)) {
                                String validLevelsStr = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(LogLevelConfig.VALID_LOG_LEVELS).asScala()).mkString(", ");
                                throw new ConfigException(new StringBuilder(90).append("Cannot set the log level of ").append(loggerName).append(" to ").append(logLevel).append(" as it is not a supported log level. ").append("Valid log levels are ").append(validLevelsStr).toString());
                            }
                            break block8;
                        }
                        if (!AlterConfigOp.OpType.DELETE.equals(opType)) break block9;
                        AdminManager.validateLoggerNameExists$1(loggerName);
                        string2 = loggerName;
                        string = Log4jController$.MODULE$.ROOT_LOGGER();
                        if (string2 != null) break block10;
                        if (string != null) {
                            return;
                        }
                        break block11;
                    }
                    if (!string2.equals(string)) break block8;
                }
                throw new InvalidRequestException(new StringBuilder(52).append("Removing the log level of the ").append(Log4jController$.MODULE$.ROOT_LOGGER()).append(" logger is not allowed").toString());
            }
            if (AlterConfigOp.OpType.APPEND.equals(opType)) {
                throw new InvalidRequestException(new StringBuilder(43).append(AlterConfigOp.OpType.APPEND).append(" operation is not allowed for the ").append(ConfigResource.Type.BROKER_LOGGER).append(" resource").toString());
            }
            if (AlterConfigOp.OpType.SUBTRACT.equals(opType)) {
                throw new InvalidRequestException(new StringBuilder(43).append(AlterConfigOp.OpType.SUBTRACT).append(" operation is not allowed for the ").append(ConfigResource.Type.BROKER_LOGGER).append(" resource").toString());
            }
            throw new MatchError((Object)opType);
        }
    }

    private static final boolean listType$1(String configName, Map configKeys) {
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configKeys.apply((Object)configName);
        if (configKey == null) {
            throw new InvalidConfigurationException(new StringBuilder(27).append("Unknown topic config name: ").append(configName).toString());
        }
        ConfigDef.Type type = configKey.type;
        ConfigDef.Type type2 = ConfigDef.Type.LIST;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ Object $anonfun$prepareIncrementalConfigs$1(Properties configProps$5, Map configKeys$1, AlterConfigOp alterConfigOp) {
        Object object;
        AlterConfigOp.OpType opType = alterConfigOp.opType();
        if (AlterConfigOp.OpType.SET.equals(opType)) {
            object = configProps$5.setProperty(alterConfigOp.configEntry().name(), alterConfigOp.configEntry().value());
        } else if (AlterConfigOp.OpType.DELETE.equals(opType)) {
            object = configProps$5.remove(alterConfigOp.configEntry().name());
        } else if (AlterConfigOp.OpType.APPEND.equals(opType)) {
            if (!AdminManager.listType$1(alterConfigOp.configEntry().name(), configKeys$1)) {
                throw new InvalidRequestException(new StringBuilder(51).append("Config value append is not allowed for config key: ").append(alterConfigOp.configEntry().name()).toString());
            }
            List oldValueList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configProps$5.getProperty(alterConfigOp.configEntry().name()).split(","))).toList();
            List newValueList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterConfigOp.configEntry().value().split(","))).toList().$colon$colon$colon(oldValueList);
            object = configProps$5.setProperty(alterConfigOp.configEntry().name(), newValueList.mkString(","));
        } else if (AlterConfigOp.OpType.SUBTRACT.equals(opType)) {
            if (!AdminManager.listType$1(alterConfigOp.configEntry().name(), configKeys$1)) {
                throw new InvalidRequestException(new StringBuilder(53).append("Config value subtract is not allowed for config key: ").append(alterConfigOp.configEntry().name()).toString());
            }
            List newValueList = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configProps$5.getProperty(alterConfigOp.configEntry().name()).split(","))).toList().diff((GenSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterConfigOp.configEntry().value().split(","))).toList());
            object = configProps$5.setProperty(alterConfigOp.configEntry().name(), newValueList.mkString(","));
        } else {
            throw new MatchError((Object)opType);
        }
        return object;
    }

    public static final /* synthetic */ Buffer $anonfun$configSynonyms$1(boolean isSensitive$1, Buffer allSynonyms$1, String name$1, DescribeConfigsResponse.ConfigSource source$1, String value) {
        String configValue = isSensitive$1 ? null : value;
        return allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponse.ConfigSynonym(name$1, configValue, source$1));
    }

    private static final void maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$1, Buffer allSynonyms$1) {
        Option option = map.get((Object)name);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            return;
        }
        String string = (String)map_this.get();
        new Some((Object)AdminManager.$anonfun$configSynonyms$1(isSensitive$1, allSynonyms$1, name, source, string));
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$2, DescribeConfigsResponse.ConfigSynonym s) {
        String string = s.name();
        return string == null ? name$2 != null : !string.equals(name$2);
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponse.ConfigSynonym x$20) {
        block3: {
            block2: {
                if (perBrokerConfig$1) break block2;
                DescribeConfigsResponse.ConfigSource configSource = x$20.source();
                DescribeConfigsResponse.ConfigSource configSource2 = DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
                if (configSource != null ? !configSource.equals(configSource2) : configSource2 != null) break block3;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$filterTopicConfigs$1(AdminManager $this, Option configNames$2, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        String configName = (String)x0$1._1();
        boolean tierFeatureCheck = Predef$.MODULE$.Boolean2boolean($this.config().tierFeature()) || !configName.startsWith(KafkaConfig$.MODULE$.ConfluentTierPrefix());
        boolean recordInterceptorCheck = !configName.equals(LogConfig$.MODULE$.AppendRecordInterceptorClassesProp());
        boolean schemaRegistryUrlCheck = !configName.equals("confluent.schema.registry.url");
        boolean basicAuthCredentialsSourceCheck = !configName.equals("confluent.basic.auth.credentials.source");
        boolean userInfoCheck = !configName.equals("confluent.basic.auth.user.info");
        boolean bearerAuthCredentialsCheck = !configName.equals("confluent.bearer.auth.credentials.source");
        boolean bearerAuthTokenCheck = !configName.equals("confluent.bearer.auth.token");
        boolean sslProtocolCheck = !configName.equals("confluent.ssl.protocol");
        boolean sslKeystoreTypeCheck = !configName.equals("confluent.ssl.keystore.type");
        boolean sslKeystoreLocationCheck = !configName.equals("confluent.ssl.keystore.location");
        boolean sslKeystorePasswordCheck = !configName.equals("confluent.ssl.keystore.password");
        boolean sslKeyPasswordCheck = !configName.equals("confluent.ssl.key.password");
        boolean sslTruststoreTypeCheck = !configName.equals("confluent.ssl.truststore.type");
        boolean sslTruststoreLocationCheck = !configName.equals("confluent.ssl.truststore.location");
        boolean sslTruststorePasswordCheck = !configName.equals("confluent.ssl.truststore.password");
        if (!basicAuthCredentialsSourceCheck) return false;
        if (!userInfoCheck) return false;
        if (!bearerAuthCredentialsCheck) return false;
        if (!bearerAuthTokenCheck) return false;
        if (!tierFeatureCheck) return false;
        if (!recordInterceptorCheck) return false;
        if (!schemaRegistryUrlCheck) return false;
        if (!sslProtocolCheck) return false;
        if (!sslKeystoreTypeCheck) return false;
        if (!sslKeystoreLocationCheck) return false;
        if (!sslKeystorePasswordCheck) return false;
        if (!sslKeyPasswordCheck) return false;
        if (!sslTruststoreTypeCheck) return false;
        if (!sslTruststoreLocationCheck) return false;
        if (!sslTruststorePasswordCheck) return false;
        if (configNames$2 == null) {
            throw null;
        }
        if (configNames$2.isEmpty()) return true;
        Set set = (Set)configNames$2.get();
        if (!set.contains((Object)configName)) return false;
        return true;
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, KafkaZkClient zkClient) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkClient = zkClient;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq(new StringBuilder(28).append("[Admin Manager on Broker ").append(config.brokerId()).append("]: ").toString());
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5());
        this.adminZkClient = new AdminZkClient(zkClient);
        this.createTopicPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class));
        this.alterConfigPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class));
        this.defaultNumPartitions = config.numPartitions();
        this.defaultReplicationFactor = Predef$.MODULE$.int2Integer(config.defaultReplicationFactor()).shortValue();
    }

    public static final /* synthetic */ Object $anonfun$metadataUpdated$2$adapted(Set allPartitions$1, CreateTopicPolicy l) {
        AdminManager.$anonfun$metadataUpdated$2(allPartitions$1, l);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$alterLogLevelConfigs$1$adapted(AdminManager $this, AlterConfigOp alterConfigOp) {
        return BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$alterLogLevelConfigs$1($this, alterConfigOp));
    }

    public static final /* synthetic */ Object $anonfun$validateLogLevelConfigs$1$adapted(AlterConfigOp alterConfigOp) {
        AdminManager.$anonfun$validateLogLevelConfigs$1(alterConfigOp);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$2$adapted(Map eta$0$1$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(eta$0$1$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$3$adapted(Map eta$0$2$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(eta$0$2$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$4$adapted(DynamicBrokerConfig dynamicConfig$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(dynamicConfig$1.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$5$adapted(DynamicBrokerConfig dynamicConfig$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(dynamicConfig$1.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$shutdown$2$adapted(CreateTopicPolicy x$17) {
        x$17.close();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$shutdown$4$adapted(AlterConfigPolicy x$18) {
        x$18.close();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$filterTopicConfigs$2$adapted(String configName$1, Set x$21) {
        return BoxesRunTime.boxToBoolean((boolean)x$21.contains((Object)configName$1));
    }
}

