/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0011UuAB6m\u0011\u0003q\u0007O\u0002\u0004sY\"\u0005an\u001d\u0005\u0006u\u0006!\t\u0001 \u0005\b{\u0006\u0011\r\u0011\"\u0001\u007f\u0011\u001d\ty!\u0001Q\u0001\n}D\u0001\"!\u0005\u0002\u0005\u0004%\tA \u0005\b\u0003'\t\u0001\u0015!\u0003\u0000\u0011!\t)\"\u0001b\u0001\n\u0003q\bbBA\f\u0003\u0001\u0006Ia \u0005\n\u00033\t!\u0019!C\u0001\u00037A\u0001\"a\t\u0002A\u0003%\u0011Q\u0004\u0005\n\u0003K\t\u0011\u0013!C\u0001\u0003O1aA\u001d7\u0001]\u0006u\u0002BCA)\u0019\t\u0015\r\u0011\"\u0001\u0002\u001c!Q\u00111\u000b\u0007\u0003\u0002\u0003\u0006I!!\b\t\u0015\u0005UCB!A!\u0002\u0013\t9\u0006\u0003\u0006\u0002r1\u0011\t\u0011)A\u0005\u0003;A!\"a\u001d\r\u0005\u0003\u0005\u000b\u0011BA;\u0011)\tY\b\u0004B\u0001B\u0003%\u0011Q\u0010\u0005\u000b\u0003\u0007c!\u0011!Q\u0001\n\u0005\u0015\u0005BCAF\u0019\t\u0005\t\u0015!\u0003\u0002\u001e!Q\u0011Q\u0012\u0007\u0003\u0002\u0003\u0006I!a$\t\u0015\u0005eEB!A!\u0002\u0013\tY\n\u0003\u0006\u0002,2\u0011\t\u0011)A\u0005\u0003[C!\"a\u0013\r\u0005\u0003\u0005\u000b\u0011BA]\u0011)\t\u0019\r\u0004B\u0001B\u0003%\u0011Q\u0019\u0005\u000b\u0003\u001fd!\u0011!Q\u0001\n\u0005E\u0007BCAo\u0019\t\u0005\t\u0015!\u0003\u0002`\"Q\u0011Q\u001d\u0007\u0003\u0002\u0003\u0006I!!\b\t\ridA\u0011AAt\u000f\u001d\u0011I\u0001\u0004E\u0005\u0005\u00171qAa\u0004\r\u0011\u0013\u0011\t\u0002\u0003\u0004{?\u0011\u0005!\u0011\u0004\u0005\b\u00057yB\u0011\u0001B\u000f\u0011%\u0011\tmHA\u0001\n\u0003\u0013\u0019\rC\u0005\u0003P~\t\t\u0011\"!\u0003R\u001a9!q\u0002\u0007AY\n\u001d\u0002B\u0003B\u0018I\tU\r\u0011\"\u0001\u00032!Q!q\t\u0013\u0003\u0012\u0003\u0006IAa\r\t\u0015\t%CE!f\u0001\n\u0003\tY\u0002\u0003\u0006\u0003L\u0011\u0012\t\u0012)A\u0005\u0003;A!B!\u0014%\u0005+\u0007I\u0011\u0001B\u0019\u0011)\u0011y\u0005\nB\tB\u0003%!1\u0007\u0005\u000b\u0005#\"#Q3A\u0005\u0002\u0005m\u0001B\u0003B*I\tE\t\u0015!\u0003\u0002\u001e!Q!Q\u000b\u0013\u0003\u0016\u0004%\t!a\u0007\t\u0015\t]CE!E!\u0002\u0013\ti\u0002\u0003\u0004{I\u0011\u0005!\u0011\f\u0005\b\u0005K\"C\u0011\tB4\u0011%\u0011I\u0007JA\u0001\n\u0003\u0011Y\u0007C\u0005\u0003x\u0011\n\n\u0011\"\u0001\u0003z!I!Q\u0010\u0013\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0005\u007f\"\u0013\u0013!C\u0001\u0005sB\u0011B!!%#\u0003%\t!a\n\t\u0013\t\rE%%A\u0005\u0002\u0005\u001d\u0002\u0002\u0003BCI\u0005\u0005I\u0011\t@\t\u0013\t\u001dE%!A\u0005\u0002\u0005m\u0001\"\u0003BEI\u0005\u0005I\u0011\u0001BF\u0011%\u00119\nJA\u0001\n\u0003\u0012I\nC\u0005\u0003(\u0012\n\t\u0011\"\u0001\u0003*\"I!1\u0017\u0013\u0002\u0002\u0013\u0005#Q\u0017\u0005\n\u0005o#\u0013\u0011!C!\u0005sC\u0011Ba8\r\u0005\u0004%IA!9\t\u0011\r\rA\u0002)A\u0005\u0005GD\u0011b!\u0002\r\u0005\u0004%Iaa\u0002\t\u0011\r\rB\u0002)A\u0005\u0007\u0013A\u0011b!\n\r\u0005\u0004%Iaa\n\t\u0011\r=B\u0002)A\u0005\u0007SA!b!\r\r\u0005\u0004%\tA\\B\u001a\u0011!\u0019Y\u0004\u0004Q\u0001\n\rU\u0002\"CB\u001f\u0019\t\u0007I\u0011AB \u0011!\u0019i\u0005\u0004Q\u0001\n\r\u0005\u0003\"CB(\u0019\t\u0007I\u0011BB)\u0011!\u0019Y\u0006\u0004Q\u0001\n\rM\u0003\"CB/\u0019\t\u0007I\u0011BB0\u0011!\u00199\u0007\u0004Q\u0001\n\r\u0005\u0004\u0002CB5\u0019\u0011EAna\u001b\t\u0013\r]D\u00021A\u0005\n\u0005m\u0001\"CB=\u0019\u0001\u0007I\u0011BB>\u0011!\u0019)\t\u0004Q!\n\u0005u\u0001bBBD\u0019\u0011\u00053\u0011\u0012\u0005\t\u0007\u0017cA\u0011\u00017\u0004\u000e\"91\u0011\u0016\u0007\u0005\n\r-\u0006bBB[\u0019\u0011%1\u0011\u0012\u0005\t\u0007ocA\u0011\u00037\u0004:\"91\u0011\u001a\u0007\u0005\n\r-\u0007bBBu\u0019\u0011%1\u0011\u0012\u0005\b\u0007WdA\u0011BBE\u0011\u001d\u0019i\u000f\u0004C\u0005\u0007\u0013Cqaa<\r\t\u0013\u0019\t\u0010C\u0004\u0004v2!Ia!#\t\u000f\r]H\u0002\"\u0003\u0004\n\"91\u0011 \u0007\u0005\n\rm\bb\u0002C\u0001\u0019\u0011\u0005A1\u0001\u0005\b\tOaA\u0011BBE\u0011\u001d!I\u0003\u0004C\u0005\u0007\u0013C\u0001ba@\r\t#aG1\u0006\u0005\t\t{aA\u0011\u00017\u0005@!9A1\t\u0007\u0005\n\u0011\u0015\u0003\u0002\u0003C$\u0019\u0011\u0005A.a\u0007\t\u0011\u0011%C\u0002\"\u0001m\u00037A\u0001\u0002b\u0013\r\t\u0003aGQ\n\u0005\b\t3bA\u0011\u0002C.\u0011\u001d!)\t\u0004C\u0005\t\u000fC\u0001\u0002b#\r\t\u0003aGQ\u0012\u0005\b\t#cA\u0011IBE\u0011\u001d!\u0019\n\u0004C!\u0007\u0013\u000b\u0011\u0002\u0015:pG\u0016\u001c8o\u001c:\u000b\u00055t\u0017a\u00028fi^|'o\u001b\u0006\u0002_\u0006)1.\u00194lCB\u0011\u0011/A\u0007\u0002Y\nI\u0001K]8dKN\u001cxN]\n\u0003\u0003Q\u0004\"!\u001e=\u000e\u0003YT\u0011a^\u0001\u0006g\u000e\fG.Y\u0005\u0003sZ\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003A\fQ#\u00133mKB+'oY3oi6+GO]5d\u001d\u0006lW-F\u0001\u0000!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\tA\u0001\\1oO*\u0011\u0011\u0011B\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u000e\u0005\r!AB*ue&tw-\u0001\fJI2,\u0007+\u001a:dK:$X*\u001a;sS\u000et\u0015-\\3!\u0003eqU\r^<pe.\u0004&o\\2fgN|'/T3ue&\u001cG+Y4\u000259+Go^8sWB\u0013xnY3tg>\u0014X*\u001a;sS\u000e$\u0016m\u001a\u0011\u0002#1K7\u000f^3oKJlU\r\u001e:jGR\u000bw-\u0001\nMSN$XM\\3s\u001b\u0016$(/[2UC\u001e\u0004\u0013aE\"p]:,7\r^5p]F+X-^3TSj,WCAA\u000f!\r)\u0018qD\u0005\u0004\u0003C1(aA%oi\u0006!2i\u001c8oK\u000e$\u0018n\u001c8Rk\u0016,XmU5{K\u0002\nA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nT'\u0006\u0002\u0002*)\"\u0011QDA\u0016W\t\ti\u0003\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001cm\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0012\u0011\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,7#\u0002\u0007\u0002@\u0005\u0015\u0003cA9\u0002B%\u0019\u00111\t7\u0003)\u0005\u00137\u000f\u001e:bGR\u001cVM\u001d<feRC'/Z1e!\u0011\t9%!\u0014\u000e\u0005\u0005%#bAA&]\u00069Q.\u001a;sS\u000e\u001c\u0018\u0002BA(\u0003\u0013\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003\tIG-A\u0002jI\u0002\nA\u0001^5nKB!\u0011\u0011LA7\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013!B;uS2\u001c(\u0002BA1\u0003G\naaY8n[>t'bA8\u0002f)!\u0011qMA5\u0003\u0019\t\u0007/Y2iK*\u0011\u00111N\u0001\u0004_J<\u0017\u0002BA8\u00037\u0012A\u0001V5nK\u0006qQ.\u0019=SKF,Xm\u001d;TSj,\u0017A\u0004:fcV,7\u000f^\"iC:tW\r\u001c\t\u0004c\u0006]\u0014bAA=Y\nq!+Z9vKN$8\t[1o]\u0016d\u0017\u0001E2p]:,7\r^5p]F+x\u000e^1t!\r\t\u0018qP\u0005\u0004\u0003\u0003c'\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003Q\u0019wN\u001c8fGRLwN\\:NCbLE\r\\3NgB\u0019Q/a\"\n\u0007\u0005%eO\u0001\u0003M_:<\u0017a\u00074bS2,G-Q;uQ\u0016tG/[2bi&|g\u000eR3mCfl5/\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002\u0012\u0006UUBAAJ\u0015\ri\u0017qL\u0005\u0005\u0003/\u000b\u0019J\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYB!\u0011QTAT\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0016\u0001B1vi\"TA!!*\u0002`\u0005A1/Z2ve&$\u00180\u0003\u0003\u0002*\u0006}%\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u0003\u0019\u0019wN\u001c4jOB!\u0011qVA[\u001b\t\t\tLC\u0002\u00024:\faa]3sm\u0016\u0014\u0018\u0002BA\\\u0003c\u00131bS1gW\u0006\u001cuN\u001c4jOB!\u00111XA`\u001b\t\tiL\u0003\u0003\u0002L\u0005}\u0013\u0002BAa\u0003{\u0013q!T3ue&\u001c7/\u0001\nde\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014\b\u0003BAd\u0003\u0017l!!!3\u000b\u0007\u0005\u0015f.\u0003\u0003\u0002N\u0006%'AE\"sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\f!\"\\3n_JL\bk\\8m!\u0011\t\u0019.!7\u000e\u0005\u0005U'\u0002BAl\u0003?\na!\\3n_JL\u0018\u0002BAn\u0003+\u0014!\"T3n_JL\bk\\8m\u0003)awnZ\"p]R,\u0007\u0010\u001e\t\u0005\u00033\n\t/\u0003\u0003\u0002d\u0006m#A\u0003'pO\u000e{g\u000e^3yi\u0006\u00192m\u001c8oK\u000e$\u0018n\u001c8Rk\u0016,XmU5{KR\u0001\u0013\u0011^Av\u0003[\fy/!=\u0002t\u0006U\u0018q_A}\u0003w\fi0a@\u0003\u0002\t\r!Q\u0001B\u0004!\t\tH\u0002C\u0004\u0002Ru\u0001\r!!\b\t\u000f\u0005US\u00041\u0001\u0002X!9\u0011\u0011O\u000fA\u0002\u0005u\u0001bBA:;\u0001\u0007\u0011Q\u000f\u0005\b\u0003wj\u0002\u0019AA?\u0011\u001d\t\u0019)\ba\u0001\u0003\u000bCq!a#\u001e\u0001\u0004\ti\u0002C\u0004\u0002\u000ev\u0001\r!a$\t\u000f\u0005eU\u00041\u0001\u0002\u001c\"9\u00111V\u000fA\u0002\u00055\u0006bBA&;\u0001\u0007\u0011\u0011\u0018\u0005\b\u0003\u0007l\u0002\u0019AAc\u0011\u001d\ty-\ba\u0001\u0003#Dq!!8\u001e\u0001\u0004\ty\u000eC\u0005\u0002fv\u0001\n\u00111\u0001\u0002\u001e\u0005a1i\u001c8oK\u000e$\u0018n\u001c8JIB\u0019!QB\u0010\u000e\u00031\u0011AbQ8o]\u0016\u001cG/[8o\u0013\u0012\u001cBa\b;\u0003\u0014A\u0019QO!\u0006\n\u0007\t]aO\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003\f\u0005QaM]8n'R\u0014\u0018N\\4\u0015\t\t}!Q\u0018\t\u0006k\n\u0005\"QE\u0005\u0004\u0005G1(AB(qi&|g\u000eE\u0002\u0003\u000e\u0011\u001ab\u0001\n;\u0003*\tM\u0001cA;\u0003,%\u0019!Q\u0006<\u0003\u000fA\u0013x\u000eZ;di\u0006IAn\\2bY\"{7\u000f^\u000b\u0003\u0005g\u0001BA!\u000e\u0003D9!!q\u0007B !\r\u0011ID^\u0007\u0003\u0005wQ1A!\u0010|\u0003\u0019a$o\\8u}%\u0019!\u0011\t<\u0002\rA\u0013X\rZ3g\u0013\u0011\tiA!\u0012\u000b\u0007\t\u0005c/\u0001\u0006m_\u000e\fG\u000eS8ti\u0002\n\u0011\u0002\\8dC2\u0004vN\u001d;\u0002\u00151|7-\u00197Q_J$\b%\u0001\u0006sK6|G/\u001a%pgR\f1B]3n_R,\u0007j\\:uA\u0005Q!/Z7pi\u0016\u0004vN\u001d;\u0002\u0017I,Wn\u001c;f!>\u0014H\u000fI\u0001\u0006S:$W\r_\u0001\u0007S:$W\r\u001f\u0011\u0015\u0019\t\u0015\"1\fB/\u0005?\u0012\tGa\u0019\t\u000f\t=r\u00061\u0001\u00034!9!\u0011J\u0018A\u0002\u0005u\u0001b\u0002B'_\u0001\u0007!1\u0007\u0005\b\u0005#z\u0003\u0019AA\u000f\u0011\u001d\u0011)f\fa\u0001\u0003;\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005g\tAaY8qsRa!Q\u0005B7\u0005_\u0012\tHa\u001d\u0003v!I!qF\u0019\u0011\u0002\u0003\u0007!1\u0007\u0005\n\u0005\u0013\n\u0004\u0013!a\u0001\u0003;A\u0011B!\u00142!\u0003\u0005\rAa\r\t\u0013\tE\u0013\u0007%AA\u0002\u0005u\u0001\"\u0003B+cA\u0005\t\u0019AA\u000f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u001f+\t\tM\u00121F\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!$\u0003\u0014B\u0019QOa$\n\u0007\tEeOA\u0002B]fD\u0011B!&:\u0003\u0003\u0005\r!!\b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011Y\n\u0005\u0004\u0003\u001e\n\r&QR\u0007\u0003\u0005?S1A!)w\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005K\u0013yJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002BV\u0005c\u00032!\u001eBW\u0013\r\u0011yK\u001e\u0002\b\u0005>|G.Z1o\u0011%\u0011)jOA\u0001\u0002\u0004\u0011i)\u0001\u0005iCND7i\u001c3f)\t\ti\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005W\u0013Y\fC\u0005\u0003\u0016v\n\t\u00111\u0001\u0003\u000e\"9!qX\u0011A\u0002\tM\u0012!A:\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\t\u0015\"Q\u0019Bd\u0005\u0013\u0014YM!4\t\u000f\t=\"\u00051\u0001\u00034!9!\u0011\n\u0012A\u0002\u0005u\u0001b\u0002B'E\u0001\u0007!1\u0007\u0005\b\u0005#\u0012\u0003\u0019AA\u000f\u0011\u001d\u0011)F\ta\u0001\u0003;\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003T\nm\u0007#B;\u0003\"\tU\u0007#D;\u0003X\nM\u0012Q\u0004B\u001a\u0003;\ti\"C\u0002\u0003ZZ\u0014a\u0001V;qY\u0016,\u0004\"\u0003BoG\u0005\u0005\t\u0019\u0001B\u0013\u0003\rAH\u0005M\u0001\u000f]\u0016<8i\u001c8oK\u000e$\u0018n\u001c8t+\t\u0011\u0019\u000f\u0005\u0004\u0003f\n=(1_\u0007\u0003\u0005OTAA!;\u0003l\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\t5\u0018qA\u0001\u0005kRLG.\u0003\u0003\u0003r\n\u001d(AE!se\u0006L(\t\\8dW&tw-U;fk\u0016\u0004BA!>\u0003\u00006\u0011!q\u001f\u0006\u0005\u0005s\u0014Y0\u0001\u0005dQ\u0006tg.\u001a7t\u0015\u0011\u0011i0a\u0002\u0002\u00079Lw.\u0003\u0003\u0004\u0002\t](!D*pG.,Go\u00115b]:,G.A\boK^\u001cuN\u001c8fGRLwN\\:!\u0003EIgN\u001a7jO\"$(+Z:q_:\u001cXm]\u000b\u0003\u0007\u0013\u0001\u0002ba\u0003\u0004\u0012\tM2QC\u0007\u0003\u0007\u001bQAaa\u0004\u0003 \u00069Q.\u001e;bE2,\u0017\u0002BB\n\u0007\u001b\u00111!T1q!\u0011\u00199b!\b\u000f\u0007E\u001cI\"C\u0002\u0004\u001c1\faBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0003\u0004 \r\u0005\"\u0001\u0003*fgB|gn]3\u000b\u0007\rmA.\u0001\nj]\u001ad\u0017n\u001a5u%\u0016\u001c\bo\u001c8tKN\u0004\u0013!\u0004:fgB|gn]3Rk\u0016,X-\u0006\u0002\u0004*A1!Q]B\u0016\u0007+IAa!\f\u0003h\n\u0019B*\u001b8lK\u0012\u0014En\\2lS:<G)Z9vK\u0006q!/Z:q_:\u001cX-U;fk\u0016\u0004\u0013AC7fiJL7\rV1hgV\u00111Q\u0007\t\u0007\u0007o\u0019Id`@\u000e\u0005\t-\u0018\u0002BB\n\u0005W\f1\"\\3ue&\u001cG+Y4tA\u0005iR\r\u001f9je\u0016$7i\u001c8oK\u000e$\u0018n\u001c8t\u0017&dG.\u001a3D_VtG/\u0006\u0002\u0004BA!11IB%\u001b\t\u0019)E\u0003\u0003\u0004H\u0005u\u0016!B:uCR\u001c\u0018\u0002BB&\u0007\u000b\u0012QbQ;nk2\fG/\u001b<f'Vl\u0017AH3ya&\u0014X\rZ\"p]:,7\r^5p]N\\\u0015\u000e\u001c7fI\u000e{WO\u001c;!\u0003\u001d*\u0007\u0010]5sK\u0012\u001cuN\u001c8fGRLwN\\:LS2dW\rZ\"pk:$X*\u001a;sS\u000et\u0015-\\3\u0016\u0005\rM\u0003\u0003BB+\u0007/j!!a\u0018\n\t\re\u0013q\f\u0002\u000b\u001b\u0016$(/[2OC6,\u0017\u0001K3ya&\u0014X\rZ\"p]:,7\r^5p]N\\\u0015\u000e\u001c7fI\u000e{WO\u001c;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013\u0001C:fY\u0016\u001cGo\u001c:\u0016\u0005\r\u0005\u0004\u0003BAI\u0007GJAa!\u001a\u0002\u0014\nA1+\u001a7fGR|'/A\u0005tK2,7\r^8sA\u0005q1M]3bi\u0016\u001cV\r\\3di>\u0014H\u0003BB1\u0007[Bqaa\u001cM\u0001\u0004\u0019\t(\u0001\bdQ\u0006tg.\u001a7Ck&dG-\u001a:\u0011\t\u0005E51O\u0005\u0005\u0007k\n\u0019J\u0001\bDQ\u0006tg.\u001a7Ck&dG-\u001a:\u0002'9,\u0007\u0010^\"p]:,7\r^5p]&sG-\u001a=\u0002/9,\u0007\u0010^\"p]:,7\r^5p]&sG-\u001a=`I\u0015\fH\u0003BB?\u0007\u0007\u00032!^B@\u0013\r\u0019\tI\u001e\u0002\u0005+:LG\u000fC\u0005\u0003\u0016:\u000b\t\u00111\u0001\u0002\u001e\u0005!b.\u001a=u\u0007>tg.Z2uS>t\u0017J\u001c3fq\u0002\n1A];o)\t\u0019i(\u0001\tqe>\u001cWm]:Fq\u000e,\u0007\u000f^5p]R11QPBH\u0007'Cqa!%R\u0001\u0004\u0011\u0019$\u0001\u0007feJ|'/T3tg\u0006<W\rC\u0004\u0004\u0016F\u0003\raa&\u0002\u0013QD'o\\<bE2,\u0007\u0003BBM\u0007GsAaa'\u0004 :!!\u0011HBO\u0013\u00059\u0018bABQm\u00069\u0001/Y2lC\u001e,\u0017\u0002BBS\u0007O\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\r\u0005f/A\fqe>\u001cWm]:DQ\u0006tg.\u001a7Fq\u000e,\u0007\u000f^5p]RA1QPBW\u0007c\u001b\u0019\fC\u0004\u00040J\u0003\rAa\r\u0002\u0013\rD\u0017M\u001c8fY&#\u0007bBBI%\u0002\u0007!1\u0007\u0005\b\u0007+\u0013\u0006\u0019ABL\u0003M\u0001(o\\2fgNtUm\u001e*fgB|gn]3t\u00031\u0019XM\u001c3SKN\u0004xN\\:f)\u0019\u0019iha/\u0004@\"91Q\u0018+A\u0002\rU\u0011\u0001\u0003:fgB|gn]3\t\u000f\r\u0005G\u000b1\u0001\u0004D\u0006a!/Z:q_:\u001cXmU3oIB!\u0011\u0011SBc\u0013\u0011\u00199-a%\u0003\tM+g\u000eZ\u0001\u0011]><h*\u00198pgN+\b\u000f\u001d7jKJ,\"a!4\u0013\r\r=71[Bm\r\u0019\u0019\t.\u0016\u0001\u0004N\naAH]3gS:,W.\u001a8u}A!\u0011\u0011ABk\u0013\u0011\u00199.a\u0001\u0003\r=\u0013'.Z2u!\u0019\u0019Yn!9\u0004f6\u00111Q\u001c\u0006\u0005\u0007?\u0014Y/\u0001\u0005gk:\u001cG/[8o\u0013\u0011\u0019\u0019o!8\u0003\u0011M+\b\u000f\u001d7jKJ\u0004B!!\u0001\u0004h&!\u0011\u0011RA\u0002\u0003\u0011\u0001x\u000e\u001c7\u00021A\u0014xnY3tg\u000e{W\u000e\u001d7fi\u0016$'+Z2fSZ,7/A\u000bqe>\u001cWm]:D_6\u0004H.\u001a;fIN+g\u000eZ:\u0002)U\u0004H-\u0019;f%\u0016\fX/Z:u\u001b\u0016$(/[2t)\u0011\u0019iha=\t\u000f\ru\u0016\f1\u0001\u0004\u0016\u0005\u0019\u0002O]8dKN\u001cH)[:d_:tWm\u0019;fI\u000612\r\\8tK\u0016C8-Z:t\u0007>tg.Z2uS>t7/A\u0003dY>\u001cX\r\u0006\u0003\u0004~\ru\bbBB\u00009\u0002\u0007!1G\u0001\rG>tg.Z2uS>t\u0017\nZ\u0001\u0007C\u000e\u001cW\r\u001d;\u0015\u0011\t-FQ\u0001C\u0005\t\u001bAq\u0001b\u0002^\u0001\u0004\u0011\u00190A\u0007t_\u000e\\W\r^\"iC:tW\r\u001c\u0005\b\t\u0017i\u0006\u0019\u0001BV\u0003!i\u0017-\u001f\"m_\u000e\\\u0007b\u0002C\b;\u0002\u0007A\u0011C\u0001\u0019C\u000e\u001cW\r\u001d;pe&#G.\u001a)fe\u000e,g\u000e^'fi\u0016\u0014\b\u0003\u0002C\n\tGi!\u0001\"\u0006\u000b\t\u0011]A\u0011D\u0001\u0005G>\u0014XM\u0003\u0003\u0002L\u0011m!\u0002\u0002C\u000f\t?\ta!_1n[\u0016\u0014(B\u0001C\u0011\u0003\r\u0019w.\\\u0005\u0005\tK!)BA\u0003NKR,'/A\fd_:4\u0017nZ;sK:+woQ8o]\u0016\u001cG/[8og\u0006A1\r\\8tK\u0006cG\u000e\u0006\u0003\u00034\u00115\u0002b\u0002C\u0018A\u0002\u0007A\u0011G\u0001\u0007g>\u001c7.\u001a;\u0011\t\u0011MB\u0011H\u0007\u0003\tkQA\u0001b\u000e\u0002\b\u0005\u0019a.\u001a;\n\t\u0011mBQ\u0007\u0002\u0007'>\u001c7.\u001a;\u0002\u001f\u0015t\u0017/^3vKJ+7\u000f]8og\u0016$Ba! \u0005B!91QX1A\u0002\rU\u0011a\u00043fcV,W/\u001a*fgB|gn]3\u0015\u0005\rU\u0011!\u0005:fgB|gn]3Rk\u0016,XmU5{K\u0006)\u0012N\u001c4mS\u001eDGOU3ta>t7/Z\"pk:$\u0018\u0001F8qK:|%o\u00117pg&twm\u00115b]:,G\u000e\u0006\u0003\u0005P\u0011]\u0003#B;\u0003\"\u0011E\u0003\u0003BAI\t'JA\u0001\"\u0016\u0002\u0014\na1*\u00194lC\u000eC\u0017M\u001c8fY\"91q`3A\u0002\tM\u0012A\u00065b]\u0012dWm\u00115b]:,G.T;uK\u00163XM\u001c;\u0015\r\ruDQ\fC0\u0011\u001d\u0019yP\u001aa\u0001\u0005gAq\u0001\"\u0019g\u0001\u0004!\u0019'A\u0003fm\u0016tG\u000f\u0005\u0003\u0005f\u0011}d\u0002\u0002C4\twrA\u0001\"\u001b\u0005z9!A1\u000eC<\u001d\u0011!i\u0007\"\u001e\u000f\t\u0011=D1\u000f\b\u0005\u0005s!\t(\u0003\u0002\u0002l%!\u0011qMA5\u0013\ry\u0017QM\u0005\u0005\u0003C\n\u0019'C\u0002n\u0003?JA\u0001\" \u0002\u0014\u0006a1*\u00194lC\u000eC\u0017M\u001c8fY&!A\u0011\u0011CB\u0005A\u0019\u0005.\u00198oK2lU\u000f^3Fm\u0016tGO\u0003\u0003\u0005~\u0005M\u0015\u0001\u0005;ssVsW.\u001e;f\u0007\"\fgN\\3m)\u0011\u0019i\b\"#\t\u000f\r}x\r1\u0001\u00034\u000591\r[1o]\u0016dG\u0003\u0002C(\t\u001fCqaa@i\u0001\u0004\u0011\u0019$\u0001\u0004xC.,W\u000f]\u0001\tg\",H\u000fZ8x]\u0002")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    public final Time kafka$network$Processor$$time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final int failedAuthenticationDelayMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    public final Metrics kafka$network$Processor$$metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final int connectionQueueSize;
    private final ArrayBlockingQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final CumulativeSum expiredConnectionsKilledCount;
    private final MetricName expiredConnectionsKilledCountMetricName;
    private final Selector selector;
    private int nextConnectionIndex;

    public static int $lessinit$greater$default$15() {
        return Processor$.MODULE$.$lessinit$greater$default$15();
    }

    public static int ConnectionQueueSize() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    public static String IdlePercentMetricName() {
        return Processor$.MODULE$.IdlePercentMetricName();
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ArrayBlockingQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    public CumulativeSum expiredConnectionsKilledCount() {
        return this.expiredConnectionsKilledCount;
    }

    private MetricName expiredConnectionsKilledCountMetricName() {
        return this.expiredConnectionsKilledCountMetricName;
    }

    private Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.failedAuthenticationDelayMs, this.kafka$network$Processor$$metrics, this.kafka$network$Processor$$time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.configureNewConnections();
                    this.processNewResponses();
                    this.poll();
                    this.processCompletedReceives();
                    this.processCompletedSends();
                    this.processDisconnected();
                    this.closeExcessConnections();
                }
                catch (Throwable e) {
                    this.processException("Processor got uncaught exception.", e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Closing selector - processor ").append(this.id()).toString());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll(), this, Level.ERROR);
            this.shutdownComplete();
        }
    }

    public void processException(String errorMessage, Throwable throwable) {
        if (throwable instanceof ControlThrowable) {
            throw (Throwable)((ControlThrowable)throwable);
        }
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Closing socket for ").append(channelId).append(" because of error").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                if (currentResponse instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)currentResponse;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Socket server received empty response to send, registering for read: ").append(noOpResponse).toString());
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)currentResponse;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    continue;
                }
                if (currentResponse instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)currentResponse;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                throw new IllegalArgumentException(new StringBuilder(23).append("Unknown response type: ").append(currentResponse.getClass()).toString());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, new StringBuilder(40).append("Exception while processing response for ").append(channelId).toString(), e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        String connectionId = response.request().context().connectionId;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Socket server received response to send to ").append(connectionId).append(", registering for write and sending data: ").append(response).toString());
        if (this.channel(connectionId).isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Attempting to send response via channel for which there is no open connection, connection id ").append(connectionId).toString());
            response.request().updateRequestMetrics(0L, 0L, response);
        }
        if (this.openOrClosingChannel(connectionId).isDefined()) {
            void $minus$greater$extension_$this;
            this.selector().send(responseSend);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)connectionId);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            this.inflightResponses().$plus$eq(new Tuple2((Object)$minus$greater$extension_$this, (Object)response));
        }
    }

    private Supplier<Long> nowNanosSupplier() {
        return new Supplier<Long>(this){
            private final /* synthetic */ Processor $outer;

            public Long get() {
                return Predef$.MODULE$.long2Long(this.$outer.kafka$network$Processor$$time.nanoseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private void poll() {
        int pollTimeout = this.newConnections().isEmpty() ? 300 : 0;
        try {
            this.selector().poll((long)pollTimeout);
            return;
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IllegalStateException ? true : throwable instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Processor ").append(this.id()).append(" poll failed").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                return;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.selector().completedReceives()).asScala()).foreach((Function1 & Serializable & scala.Serializable)receive -> {
            Processor.$anonfun$processCompletedReceives$1(this, receive);
            return BoxedUnit.UNIT;
        });
        this.selector().clearCompletedReceives();
    }

    private void processCompletedSends() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedSends()).asScala()).foreach((Function1 & Serializable & scala.Serializable)send -> {
            Processor.$anonfun$processCompletedSends$1(this, send);
            return BoxedUnit.UNIT;
        });
        this.selector().clearCompletedSends();
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        long l;
        long l2;
        RequestChannel.Request request = response.request();
        Option<KafkaChannel> option = this.openOrClosingChannel(request.context().connectionId);
        if (option instanceof Some) {
            KafkaChannel channel = (KafkaChannel)((Some)option).value();
            long l3 = channel.writeIoTimeNanos();
            long l4 = channel.networkIoTimeNanos();
            channel.resetNetworkIoTimes();
            l2 = l3;
            l = l4;
        } else if (None$.MODULE$.equals(option)) {
            l2 = 0L;
            l = 0L;
        } else {
            throw new MatchError(option);
        }
        request.updateRequestMetrics(l, l2, response);
    }

    private void processDisconnected() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.selector().disconnected().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)connectionId -> {
            Processor.$anonfun$processDisconnected$1(this, connectionId);
            return BoxedUnit.UNIT;
        });
    }

    private void closeExcessConnections() {
        KafkaChannel channel;
        if (this.connectionQuotas.maxConnectionsExceeded(this.listenerName) && (channel = this.selector().lowestPriorityChannel()) != null) {
            this.close(channel.id());
            return;
        }
    }

    private void close(String connectionId) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            KafkaChannel kafkaChannel = (KafkaChannel)foreach_this.get();
            Processor.$anonfun$close$4(this, connectionId, kafkaChannel);
            return;
        }
    }

    public boolean accept(SocketChannel socketChannel, boolean mayBlock, Meter acceptorIdlePercentMeter) {
        boolean accepted;
        boolean bl;
        if (this.newConnections().offer(socketChannel)) {
            bl = true;
        } else if (mayBlock) {
            long startNs = this.kafka$network$Processor$$time.nanoseconds();
            this.newConnections().put(socketChannel);
            acceptorIdlePercentMeter.mark(this.kafka$network$Processor$$time.nanoseconds() - startNs);
            bl = true;
        } else {
            bl = accepted = false;
        }
        if (accepted) {
            this.wakeup();
        }
        return accepted;
    }

    private void configureNewConnections() {
        int connectionsProcessed = 0;
        while (connectionsProcessed < this.connectionQueueSize && !this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Processor ").append(this.id()).append(" listening to new connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
                this.selector().register(this.connectionId(channel.socket()), channel);
                ++connectionsProcessed;
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.close(this.listenerName, channel);
                this.processException(new StringBuilder(34).append("Processor ").append(this.id()).append(" closed connection from ").append(remoteAddress).toString(), e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void closeAll() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().channels()).asScala()).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            this.close(channel.id());
            return BoxedUnit.UNIT;
        });
        this.selector().close();
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ((Object)BoxesRunTime.boxToInteger((int)this.id())).toString();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.removeMetric(Processor$.MODULE$.IdlePercentMetricName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
    }

    public String connectionId(Socket socket) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        String connId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort, this.nextConnectionIndex()).toString();
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     */
    private RequestChannel.Response dequeueResponse() {
        void var1_1;
        RequestChannel.Response response = this.responseQueue().poll();
        if (response != null) {
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return var1_1;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        Option option = Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
        if (option == null) {
            throw null;
        }
        Option orElse_this = option;
        Option option2 = orElse_this.isEmpty() ? Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)) : orElse_this;
        return option2;
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            KafkaChannel kafkaChannel = (KafkaChannel)foreach_this.get();
            kafkaChannel.handleChannelMuteEvent(event);
            return;
        }
    }

    private void tryUnmuteChannel(String connectionId) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            KafkaChannel kafkaChannel = (KafkaChannel)foreach_this.get();
            Processor.$anonfun$tryUnmuteChannel$1(this, kafkaChannel);
            return;
        }
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void shutdown() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        super.shutdown();
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = ((Object)BoxesRunTime.boxToInteger((int)this.id())).toString();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.removeMetric("IdlePercent", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
        this.kafka$network$Processor$$metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
    }

    private final void ConnectionId$lzycompute$1() {
        synchronized (this) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedReceives$1(Processor $this, NetworkReceive receive) {
        block9: {
            try {
                Option<KafkaChannel> option = $this.openOrClosingChannel(receive.source());
                if (option instanceof Some) {
                    KafkaChannel channel = (KafkaChannel)((Some)option).value();
                    RequestHeader header = RequestHeader.parse((ByteBuffer)receive.payload());
                    ApiKeys apiKeys = header.apiKey();
                    ApiKeys apiKeys2 = ApiKeys.SASL_HANDSHAKE;
                    if (!(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null) && channel.maybeBeginServerReauthentication(receive, $this.nowNanosSupplier())) {
                        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Begin re-authentication: ").append(channel).toString());
                    } else {
                        long nowNanos = $this.kafka$network$Processor$$time.nanoseconds();
                        if (channel.serverAuthenticationSessionExpired(nowNanos)) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Disconnecting expired channel: ").append(channel).append(" : ").append(header).toString());
                            $this.close(channel.id());
                            $this.expiredConnectionsKilledCount().record(null, 1.0, 0L);
                        } else {
                            ApiVersionsRequest apiVersionsRequest;
                            String connectionId = receive.source();
                            RequestContext context = channel.newRequestContext(header, $this.listenerName, $this.securityProtocol, channel.channelMetadataRegistry().clientInformation(), $this.kafka$network$Processor$$metrics);
                            RequestChannel.Request req = new RequestChannel.Request($this.id(), context, nowNanos, $this.memoryPool, receive.payload(), $this.requestChannel.metrics());
                            ApiKeys apiKeys3 = header.apiKey();
                            ApiKeys apiKeys4 = ApiKeys.API_VERSIONS;
                            if (!(apiKeys3 != null ? !apiKeys3.equals(apiKeys4) : apiKeys4 != null) && (apiVersionsRequest = (ApiVersionsRequest)req.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).isValid()) {
                                channel.channelMetadataRegistry().registerClientInformation(new ClientInformation(apiVersionsRequest.data.clientSoftwareName(), apiVersionsRequest.data.clientSoftwareVersion()));
                            }
                            $this.requestChannel.sendRequest(req);
                            $this.selector().mute(connectionId);
                            $this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
                        }
                    }
                    break block9;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(66).append("Channel ").append(receive.source()).append(" removed from selector before processing completed receive").toString());
                }
                throw new MatchError(option);
            }
            catch (Throwable e) {
                $this.processChannelException(receive.source(), new StringBuilder(40).append("Exception while processing request from ").append(receive.source()).toString(), e);
            }
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$processCompletedSends$2(Send send$1) {
        throw new IllegalStateException(new StringBuilder(51).append("Send for ").append(send$1.destination()).append(" completed, but not in `inflightResponses`").toString());
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$3(Send send$1, Function1 onComplete) {
        onComplete.apply((Object)send$1);
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$1(Processor $this, Send send) {
        try {
            Option option = $this.inflightResponses().remove((Object)send.destination());
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                throw Processor.$anonfun$processCompletedSends$2(send);
            }
            RequestChannel.Response response = (RequestChannel.Response)getOrElse_this.get();
            $this.updateRequestMetrics(response);
            Option<Function1<Send, BoxedUnit>> option2 = response.onComplete();
            if (option2 == null) {
                throw null;
            }
            Option<Function1<Send, BoxedUnit>> foreach_this = option2;
            if (!foreach_this.isEmpty()) {
                ((Function1)foreach_this.get()).apply((Object)send);
            }
            $this.handleChannelMuteEvent(send.destination(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
            $this.tryUnmuteChannel(send.destination());
            return;
        }
        catch (Throwable e) {
            $this.processChannelException(send.destination(), new StringBuilder(45).append("Exception while processing completed send to ").append(send.destination()).toString(), e);
            return;
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$processDisconnected$2(String connectionId$2) {
        throw new IllegalStateException(new StringBuilder(36).append("connectionId has unexpected format: ").append(connectionId$2).toString());
    }

    public static final /* synthetic */ void $anonfun$processDisconnected$1(Processor $this, String connectionId) {
        try {
            Option<ConnectionId> option = $this.ConnectionId().fromString(connectionId);
            if (option == null) {
                throw null;
            }
            Option<ConnectionId> getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                throw Processor.$anonfun$processDisconnected$2(connectionId);
            }
            String remoteHost = ((ConnectionId)getOrElse_this.get()).remoteHost();
            Option option2 = $this.inflightResponses().remove((Object)connectionId);
            if (option2 == null) {
                throw null;
            }
            Option foreach_this = option2;
            if (!foreach_this.isEmpty()) {
                RequestChannel.Response response = (RequestChannel.Response)foreach_this.get();
                $this.updateRequestMetrics(response);
            }
            $this.connectionQuotas.dec($this.listenerName, InetAddress.getByName(remoteHost));
            return;
        }
        catch (Throwable e) {
            $this.processException(new StringBuilder(44).append("Exception while processing disconnection of ").append(connectionId).toString(), e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$close$4(Processor $this, String connectionId$3, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Closing selector connection ").append(connectionId$3).toString());
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec($this.listenerName, address);
        }
        $this.selector().close(connectionId$3);
        Option option = $this.inflightResponses().remove((Object)connectionId$3);
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            RequestChannel.Response response = (RequestChannel.Response)foreach_this.get();
            $this.updateRequestMetrics(response);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    /*
     * WARNING - void declaration
     */
    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, int failedAuthenticationDelayMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext, int connectionQueueSize) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        this.id = id;
        this.kafka$network$Processor$$time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.kafka$network$Processor$$metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        this.connectionQueueSize = connectionQueueSize;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.newConnections = new ArrayBlockingQueue(connectionQueueSize);
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        Tuple2[] tuple2Array = new Tuple2[2];
        String string = listenerName.value();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string2 = ((Object)BoxesRunTime.boxToInteger((int)id)).toString();
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        this.metricTags = (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        Tuple2[] tuple2Array2 = new Tuple2[1];
        String string3 = ((Object)BoxesRunTime.boxToInteger((int)id)).toString();
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.newGauge(Processor$.MODULE$.IdlePercentMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public double value() {
                Option option = Option$.MODULE$.apply((Object)this.$outer.kafka$network$Processor$$metrics.metric(this.$outer.kafka$network$Processor$$metrics.metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), this.$outer.metricTags())));
                if (option == null) {
                    throw null;
                }
                Option fold_this = option;
                double d = fold_this.isEmpty() ? $anon$7.$anonfun$value$19() : $anon$7.$anonfun$value$20((KafkaMetric)fold_this.get());
                return d;
            }

            public static final /* synthetic */ double $anonfun$value$19() {
                return 0.0;
            }

            public static final /* synthetic */ double $anonfun$value$20(KafkaMetric m) {
                return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            public static final /* synthetic */ Object $anonfun$value$20$adapted(KafkaMetric m) {
                return BoxesRunTime.boxToDouble((double)$anon$7.$anonfun$value$20(m));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$19(), $anonfun$value$20$adapted(org.apache.kafka.common.metrics.KafkaMetric )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))));
        this.expiredConnectionsKilledCount = new CumulativeSum();
        this.expiredConnectionsKilledCountMetricName = metrics.metricName("expired-connections-killed-count", "socket-server-metrics", this.metricTags());
        metrics.addMetric(this.expiredConnectionsKilledCountMetricName(), (Measurable)this.expiredConnectionsKilledCount());
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (listenerName.equals(config.interBrokerListenerName()) ? 1 : 0) != 0, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache(), (DelegationTokenCache)credentialProvider.tokenCache(), (Time)time, (LogContext)logContext));
        this.nextConnectionIndex = 0;
    }

    public static final /* synthetic */ Object $anonfun$close$4$adapted(Processor $this, String connectionId$3, KafkaChannel channel) {
        Processor.$anonfun$close$4($this, connectionId$3, channel);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$handleChannelMuteEvent$1$adapted(KafkaChannel.ChannelMuteEvent event$1, KafkaChannel c) {
        c.handleChannelMuteEvent(event$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$tryUnmuteChannel$1$adapted(Processor $this, KafkaChannel c) {
        Processor.$anonfun$tryUnmuteChannel$1($this, c);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$processCompletedSends$3$adapted(Send send$1, Function1 onComplete) {
        onComplete.apply((Object)send$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$processDisconnected$3$adapted(Processor $this, RequestChannel.Response response) {
        $this.updateRequestMetrics(response);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$close$6$adapted(Processor $this, RequestChannel.Response response) {
        $this.updateRequestMetrics(response);
        return BoxedUnit.UNIT;
    }

    public class ConnectionId
    implements Product,
    scala.Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        private final int index;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return new StringBuilder(4).append(this.localHost()).append(":").append(this.localPort()).append("-").append(this.remoteHost()).append(":").append(this.remotePort()).append("-").append(this.index()).toString();
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort, int index) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort, index);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public int copy$default$5() {
            return this.index();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.localHost();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.localPort());
                }
                case 2: {
                    return this.remoteHost();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this.remotePort());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this.index());
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.localHost())), (int)this.localPort()), (int)Statics.anyHash((Object)this.remoteHost())), (int)this.remotePort()), (int)this.index()), (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ConnectionId)) return false;
            if (((ConnectionId)x$1).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (this.index() != connectionId.index()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort, int index) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

