/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.TooManyConnectionsException;
import kafka.server.ThreadUsageMetrics$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.KafkaThread;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0005]h!B\u0012%\u0001\u0019B\u0003\u0002C\u001a\u0001\u0005\u000b\u0007I\u0011A\u001b\t\u0011q\u0002!\u0011!Q\u0001\nYB\u0001\"\u0010\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u007f!Aa\t\u0001BC\u0002\u0013\u0005a\b\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003@\u0011!A\u0005A!A!\u0002\u0013y\u0004\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0011A\u0002!\u0011!Q\u0001\n5C\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\u0006K\u0002!\tA\u001a\u0005\b_\u0002\u0011\r\u0011\"\u0003q\u0011\u0019Y\b\u0001)A\u0005c\"9A\u0010\u0001b\u0001\n\u0003i\bbBA\u0002\u0001\u0001\u0006IA \u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"a\b\u0001A\u0003%\u0011\u0011\u0002\u0005\n\u0003C\u0001!\u0019!C\u0005\u0003GA\u0001\"!\u000f\u0001A\u0003%\u0011Q\u0005\u0005\n\u0003w\u0001!\u0019!C\u0005\u0003{A\u0001\"!\u0016\u0001A\u0003%\u0011q\b\u0005\n\u0003/\u0002!\u0019!C\u0005\u00033B\u0001\"!\u0019\u0001A\u0003%\u00111\f\u0005\t\u0003G\u0002A\u0011\u0001\u0013\u0002f!A\u00111\u0010\u0001\u0005\u0002\u0011\ni\bC\u0004\u0002|\u0001!I!!!\t\u0011\u0005=\u0005\u0001\"\u0001%\u0003#Cq!!)\u0001\t\u0003\n\u0019\u000bC\u0004\u0002&\u0002!\t!a)\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"9\u00111\u0017\u0001\u0005\n\u0005U\u0006bBAg\u0001\u0011%\u0011q\u001a\u0005\b\u0003G\u0004A\u0011BAs\u0011\u001d\t9\u000f\u0001C\u0001\u0003G\u0013\u0001\"Q2dKB$xN\u001d\u0006\u0003K\u0019\nqA\\3uo>\u00148NC\u0001(\u0003\u0015Y\u0017MZ6b'\r\u0001\u0011&\f\t\u0003U-j\u0011\u0001J\u0005\u0003Y\u0011\u0012A#\u00112tiJ\f7\r^*feZ,'\u000f\u00165sK\u0006$\u0007C\u0001\u00182\u001b\u0005y#B\u0001\u0019'\u0003\u001diW\r\u001e:jGNL!AM\u0018\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/\u0001\u0005f]\u0012\u0004v.\u001b8u\u0007\u0001)\u0012A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0003s\u0019\nqa\u00197vgR,'/\u0003\u0002<q\tAQI\u001c3Q_&tG/A\u0005f]\u0012\u0004v.\u001b8uA\u0005q1/\u001a8e\u0005V4g-\u001a:TSj,W#A \u0011\u0005\u0001\u001bU\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\u0007%sG/A\btK:$')\u001e4gKJ\u001c\u0016N_3!\u00039\u0011Xm\u0019<Ck\u001a4WM]*ju\u0016\fqB]3dm\n+hMZ3s'&TX\rI\u0001\tEJ|7.\u001a:JI\u0006\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\t\u0003U-K!\u0001\u0014\u0013\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\bC\u0001(X\u001b\u0005y%B\u0001\u0019Q\u0015\t\t&+\u0001\u0004d_6lwN\u001c\u0006\u0003OMS!\u0001V+\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0016aA8sO&\u0011\u0001l\u0014\u0002\b\u001b\u0016$(/[2t\u00031iW\r\u001e:jGB\u0013XMZ5y!\tY&M\u0004\u0002]AB\u0011Q,Q\u0007\u0002=*\u0011q\fN\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005\f\u0015A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!Y!\u0002\rqJg.\u001b;?)!9\u0007.\u001b6lY6t\u0007C\u0001\u0016\u0001\u0011\u0015\u00194\u00021\u00017\u0011\u0015i4\u00021\u0001@\u0011\u001515\u00021\u0001@\u0011\u0015A5\u00021\u0001@\u0011\u0015I5\u00021\u0001K\u0011\u0015\u00014\u00021\u0001N\u0011\u0015I6\u00021\u0001[\u0003-q\u0017n\\*fY\u0016\u001cGo\u001c:\u0016\u0003E\u0004\"A]=\u000e\u0003MT!\u0001^;\u0002\u0011\rD\u0017M\u001c8fYNT!A^<\u0002\u00079LwNC\u0001y\u0003\u0011Q\u0017M^1\n\u0005i\u001c(\u0001C*fY\u0016\u001cGo\u001c:\u0002\u00199LwnU3mK\u000e$xN\u001d\u0011\u0002\u001bM,'O^3s\u0007\"\fgN\\3m+\u0005q\bC\u0001:\u0000\u0013\r\t\ta\u001d\u0002\u0014'\u0016\u0014h/\u001a:T_\u000e\\W\r^\"iC:tW\r\\\u0001\u000fg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7!\u0003)\u0001(o\\2fgN|'o]\u000b\u0003\u0003\u0013\u0001b!a\u0003\u0002\u0016\u0005eQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u000f5,H/\u00192mK*\u0019\u00111C!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0018\u00055!aC!se\u0006L()\u001e4gKJ\u00042AKA\u000e\u0013\r\ti\u0002\n\u0002\n!J|7-Z:t_J\f1\u0002\u001d:pG\u0016\u001c8o\u001c:tA\u0005\t\u0002O]8dKN\u001cxN]:Ti\u0006\u0014H/\u001a3\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003ki!!!\u000b\u000b\t\u0005-\u0012QF\u0001\u0007CR|W.[2\u000b\t\u0005=\u0012\u0011G\u0001\u000bG>t7-\u001e:sK:$(bAA\u001ao\u0006!Q\u000f^5m\u0013\u0011\t9$!\u000b\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003I\u0001(o\\2fgN|'o]*uCJ$X\r\u001a\u0011\u0002'\tdwnY6fIB+'oY3oi6+G/\u001a:\u0016\u0005\u0005}\u0002\u0003BA!\u0003#j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0005G>\u0014XMC\u00021\u0003\u0013RA!a\u0013\u0002N\u00051\u00110Y7nKJT!!a\u0014\u0002\u0007\r|W.\u0003\u0003\u0002T\u0005\r#!B'fi\u0016\u0014\u0018\u0001\u00062m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014\b%\u0001\u000foKR<xN]6UQJ,\u0017\rZ:DCB\f7-\u001b;z'\u0016t7o\u001c:\u0016\u0005\u0005m\u0003c\u0001(\u0002^%\u0019\u0011qL(\u0003\rM+gn]8s\u0003uqW\r^<pe.$\u0006N]3bIN\u001c\u0015\r]1dSRL8+\u001a8t_J\u0004\u0013!D1eIB\u0013xnY3tg>\u00148\u000f\u0006\u0004\u0002h\u00055\u0014q\u000f\t\u0004\u0001\u0006%\u0014bAA6\u0003\n!QK\\5u\u0011\u001d\ty\u0007\u0007a\u0001\u0003c\nQB\\3x!J|7-Z:t_J\u001c\bCBA\u0006\u0003g\nI\"\u0003\u0003\u0002v\u00055!A\u0002\"vM\u001a,'\u000f\u0003\u0004\u0002za\u0001\rAW\u0001\u0016aJ|7-Z:t_J$\u0006N]3bIB\u0013XMZ5y\u0003=\u0019H/\u0019:u!J|7-Z:t_J\u001cH\u0003BA4\u0003\u007fBa!!\u001f\u001a\u0001\u0004QFCBA4\u0003\u0007\u000bi\tC\u0004\u0002\u0006i\u0001\r!!\"\u0011\r\u0005\u001d\u0015\u0011RA\r\u001b\t\t\t\"\u0003\u0003\u0002\f\u0006E!aA*fc\"1\u0011\u0011\u0010\u000eA\u0002i\u000b\u0001C]3n_Z,\u0007K]8dKN\u001cxN]:\u0015\r\u0005\u001d\u00141SAL\u0011\u0019\t)j\u0007a\u0001\u007f\u0005Y!/Z7pm\u0016\u001cu.\u001e8u\u0011\u001d\tIj\u0007a\u0001\u00037\u000baB]3rk\u0016\u001cHo\u00115b]:,G\u000eE\u0002+\u0003;K1!a(%\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003O\n1A];o\u0003Ay\u0007/\u001a8TKJ4XM]*pG.,G\u000fF\u0003\u007f\u0003W\u000by\u000b\u0003\u0004\u0002.z\u0001\rAW\u0001\u0005Q>\u001cH\u000f\u0003\u0004\u00022z\u0001\raP\u0001\u0005a>\u0014H/\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\u0005\u0003o\u000b\u0019\rE\u0003A\u0003s\u000bi,C\u0002\u0002<\u0006\u0013aa\u00149uS>t\u0007c\u0001:\u0002@&\u0019\u0011\u0011Y:\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0011\u001d\t)m\ba\u0001\u0003\u000f\f1a[3z!\r\u0011\u0018\u0011Z\u0005\u0004\u0003\u0017\u001c(\u0001D*fY\u0016\u001cG/[8o\u0017\u0016L\u0018aE1tg&<gNT3x\u0007>tg.Z2uS>tG\u0003CAi\u0003/\fY.a8\u0011\u0007\u0001\u000b\u0019.C\u0002\u0002V\u0006\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002Z\u0002\u0002\r!!0\u0002\u001bM|7m[3u\u0007\"\fgN\\3m\u0011\u001d\ti\u000e\ta\u0001\u00033\t\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\t\u000f\u0005\u0005\b\u00051\u0001\u0002R\u0006AQ.Y=CY>\u001c7.\u0001\u0012de\u0016\fG/\u001a(fi^|'o\u001b+ie\u0016\fGm]\"ba\u0006\u001c\u0017\u000e^=TK:\u001cxN\u001d\u000b\u0003\u00037\naa^1lKV\u0004\bf\u0001\u0012\u0002lB!\u0011Q^Az\u001b\t\tyOC\u0002\u0002r^\fA\u0001\\1oO&!\u0011Q_Ax\u0005!ye/\u001a:sS\u0012,\u0007")
public class Acceptor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private final EndPoint endPoint;
    private final int sendBufferSize;
    private final int recvBufferSize;
    private final int brokerId;
    private final ConnectionQuotas connectionQuotas;
    private final Metrics metrics;
    private final String metricPrefix;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final AtomicBoolean processorsStarted;
    private final Meter blockedPercentMeter;
    private final Sensor networkThreadsCapacitySensor;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public int recvBufferSize() {
        return this.recvBufferSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    private ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private AtomicBoolean processorsStarted() {
        return this.processorsStarted;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private Sensor networkThreadsCapacitySensor() {
        return this.networkThreadsCapacitySensor;
    }

    public synchronized void addProcessors(Buffer<Processor> newProcessors, String processorThreadPrefix) {
        this.processors().$plus$plus$eq(newProcessors);
        if (this.processorsStarted().get()) {
            this.startProcessors((Seq<Processor>)newProcessors, processorThreadPrefix);
        }
        this.networkThreadsCapacitySensor().record(100.0 * (double)this.processors().size());
    }

    public synchronized void startProcessors(String processorThreadPrefix) {
        if (!this.processorsStarted().getAndSet(true)) {
            this.startProcessors((Seq<Processor>)this.processors(), processorThreadPrefix);
        }
    }

    private synchronized void startProcessors(Seq<Processor> processors, String processorThreadPrefix) {
        processors.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            Acceptor.$anonfun$startProcessors$1(this, processorThreadPrefix, processor);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeProcessors(int removeCount, RequestChannel requestChannel) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.shutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
        this.networkThreadsCapacitySensor().record(100.0 * (double)this.processors().size());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void shutdown() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        super.shutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
                x$16.shutdown();
                return BoxedUnit.UNIT;
            });
        }
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = this.endPoint().listenerName().value();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.removeMetric(new StringBuilder(22).append(this.metricPrefix).append("AcceptorBlockedPercent").toString(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
        this.metrics.removeSensor(this.networkThreadsCapacitySensor().name());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        this.startupComplete();
        try {
            IntRef currentProcessorIndex = IntRef.create((int)0);
            while (this.isRunning()) {
                try {
                    if (this.nioSelector().select(500L) <= 0) continue;
                    Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
                    while (iter.hasNext() && this.isRunning()) {
                        try {
                            Option<SocketChannel> foreach_this;
                            SelectionKey key = iter.next();
                            iter.remove();
                            if (!key.isAcceptable()) throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                            if (this.accept(key) == null) {
                                throw null;
                            }
                            if (foreach_this.isEmpty()) continue;
                            SocketChannel socketChannel = (SocketChannel)foreach_this.get();
                            Acceptor.$anonfun$run$1(this, currentProcessorIndex, socketChannel);
                        }
                        catch (Throwable e) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ControlThrowable) {
                        throw (Throwable)((ControlThrowable)throwable);
                    }
                    if (throwable == null) throw null;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                    continue;
                    return;
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing server socket and selector.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.shutdownComplete();
        }
    }

    private ServerSocketChannel openServerSocket(String host, int port) {
        InetSocketAddress socketAddress = host == null || host.trim().isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (this.recvBufferSize() != -1) {
            serverChannel.socket().setReceiveBufferSize(this.recvBufferSize());
        }
        try {
            serverChannel.socket().bind(socketAddress);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas.inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            socketChannel.configureBlocking(false);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setKeepAlive(true);
            if (this.sendBufferSize() != -1) {
                socketChannel.socket().setSendBufferSize(this.sendBufferSize());
            }
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.close(this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(138).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Sensor createNetworkThreadsCapacitySensor() {
        void var2_2;
        String listenerName = this.endPoint().listenerName().value();
        Sensor networkThreadsCapacitySensor = this.metrics.sensor(new StringBuilder(30).append("TotalNetworkThreadsPercentage-").append(listenerName).toString());
        networkThreadsCapacitySensor.add(ThreadUsageMetrics$.MODULE$.networkThreadPoolCapacityMetricName(this.metrics, listenerName), (MeasurableStat)new Value());
        return var2_2;
    }

    @Override
    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public static final /* synthetic */ void $anonfun$startProcessors$1(Acceptor $this, String processorThreadPrefix$1, Processor processor) {
        String nonDaemon_name = new StringBuilder(25).append(processorThreadPrefix$1).append("-kafka-network-thread-").append($this.brokerId).append("-").append($this.endPoint().listenerName()).append("-").append($this.endPoint().securityProtocol()).append("-").append(processor.id()).toString();
        new KafkaThread(nonDaemon_name, (Runnable)processor, false).start();
    }

    public static final /* synthetic */ void $anonfun$run$1(Acceptor $this, IntRef currentProcessorIndex$1, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                currentProcessorIndex$1.elem %= $this.processors().length();
                processor = (Processor)$this.processors().apply(currentProcessorIndex$1.elem);
            }
            ++currentProcessorIndex$1.elem;
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    /*
     * WARNING - void declaration
     */
    public Acceptor(EndPoint endPoint, int sendBufferSize, int recvBufferSize, int brokerId, ConnectionQuotas connectionQuotas, Metrics metrics, String metricPrefix) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.endPoint = endPoint;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
        this.brokerId = brokerId;
        this.connectionQuotas = connectionQuotas;
        this.metrics = metrics;
        this.metricPrefix = metricPrefix;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port());
        this.processors = new ArrayBuffer();
        this.processorsStarted = new AtomicBoolean();
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = endPoint.listenerName().value();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.blockedPercentMeter = this.newMeter(new StringBuilder(22).append(metricPrefix).append("AcceptorBlockedPercent").toString(), "blocked time", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
        this.networkThreadsCapacitySensor = this.createNetworkThreadsCapacitySensor();
    }

    public static final /* synthetic */ Object $anonfun$run$1$adapted(Acceptor $this, IntRef currentProcessorIndex$1, SocketChannel socketChannel) {
        Acceptor.$anonfun$run$1($this, currentProcessorIndex$1, socketChannel);
        return BoxedUnit.UNIT;
    }
}

