/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.AbstractLog;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\rua\u0001B A\u0001\u0015C\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\tG\u0002\u0011)\u0019!C\u0001I\"A1\u000f\u0001B\u0001B\u0003%Q\r\u0003\u0005u\u0001\t\u0015\r\u0011\"\u0001v\u0011%\ty\u0001\u0001B\u0001B\u0003%a\u000f\u0003\u0006\u0002\u0012\u0001\u0011)\u0019!C\u0001\u0003'A!\"a\u0007\u0001\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011)\ti\u0002\u0001B\u0001B\u0003%\u0011q\u0004\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011%\tI\u0004\u0001a\u0001\n\u0013\tY\u0004C\u0005\u0002>\u0001\u0001\r\u0011\"\u0003\u0002@!9\u00111\n\u0001!B\u0013y\u0006BCA+\u0001\t\u0007I\u0011\u0001!\u0002X!A\u0011q\f\u0001!\u0002\u0013\tI\u0006C\u0005\u0002b\u0001\u0011\r\u0011\"\u0003\u0002d!A\u00111\u000e\u0001!\u0002\u0013\t)\u0007\u0003\u0006\u0002n\u0001\u0011\r\u0011\"\u0001A\u0003_B\u0001Ba\u0011\u0001A\u0003%\u0011\u0011\u000f\u0005\t\u0005\u000b\u0002A\u0011\u0001!\u0003H!9!\u0011\n\u0001\u0005\u0002\u0005\u0015\bb\u0002B&\u0001\u0011\u0005\u0011Q\u001d\u0005\b\u0005\u001b\u0002A\u0011\tB(\u0011\u001d\u00119\u0006\u0001C!\u00053BqA!\u001a\u0001\t\u0003\u00129\u0007C\u0004\u0003p\u0001!\tA!\u001d\t\u000f\tU\u0004\u0001\"\u0001\u0003x!9!Q\u0010\u0001\u0005\u0002\t}\u0004b\u0002BF\u0001\u0011\u0005!Q\u0012\u0005\b\u0005'\u0003A\u0011\u0001BK\u0011\u001d\u0011y\n\u0001C\u0001\u0005CCqA!*\u0001\t\u0003\u00119\u000bC\u0004\u00034\u0002!\tA!.\t\u0013\t}\u0006!%A\u0005\u0002\t\u0005\u0007b\u0002Bl\u0001\u0011\u0005!\u0011\u001c\u0005\t\u0005G\u0004A\u0011\u0001\"\u0002<!A!Q\u001d\u0001\u0005\u0002\u0001\u00139EB\u0004\u0002\u0002\u0002\u0001\u0001)a!\t\u0015\u0005-UE!A!\u0002\u0013\ti\tC\u0004\u0002*\u0015\"\t!a%\t\u000f\u0005]U\u0005\"\u0015\u0002\u001a\"I\u0011qU\u0013C\u0002\u0013\u0005\u0011\u0011\u0016\u0005\t\u0003c+\u0003\u0015!\u0003\u0002,\"I\u00111W\u0013A\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u0003{+\u0003\u0019!C\u0001\u0003\u007fC\u0001\"a1&A\u0003&\u0011q\u0017\u0005\n\u0003\u000f,\u0003\u0019!C\u0001\u0003\u0013D\u0011\"!5&\u0001\u0004%\t!a5\t\u0011\u0005]W\u0005)Q\u0005\u0003\u0017Dq!a7&\t\u0013\ti\u000eC\u0004\u0002d\u0016\"\t%!:\t\u000f\u0005\u001dX\u0005\"\u0003\u0002j\"9\u0011\u0011_\u0013\u0005\n\u0005%\bb\u0002B\u0002K\u0011%!Q\u0001\u0005\b\u0005#)C\u0011\u0001B\n\u000f\u001d\u00119\u000f\u0011E\u0001\u0005S4aa\u0010!\t\u0002\t-\bbBA\u0015q\u0011\u0005!Q\u001e\u0005\n\u0005_D$\u0019!C\u0001\u0005cD\u0001B!>9A\u0003%!1\u001f\u0005\b\u0005oDD\u0011\u0001B}\u0011\u001d\u0011i\u0010\u000fC\u0001\u0005\u007fD\u0011ba\u00069#\u0003%\ta!\u0007\u0003\u00151{wm\u00117fC:,'O\u0003\u0002B\u0005\u0006\u0019An\\4\u000b\u0003\r\u000bQa[1gW\u0006\u001c\u0001aE\u0003\u0001\r2\u0013\u0006\f\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\n\u000bQ!\u001e;jYNL!!\u0015(\u0003\u000f1{wmZ5oOB\u00111KV\u0007\u0002)*\u0011QKQ\u0001\b[\u0016$(/[2t\u0013\t9FKA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\u0004\"!\u0017/\u000e\u0003iS!a\u0017\"\u0002\rM,'O^3s\u0013\ti&L\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\u000eS:LG/[1m\u0007>tg-[4\u0011\u0005\u0001\fW\"\u0001!\n\u0005\t\u0004%!D\"mK\u0006tWM]\"p]\u001aLw-A\u0004m_\u001e$\u0015N]:\u0016\u0003\u0015\u00042AZ5l\u001b\u00059'B\u00015I\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003U\u001e\u00141aU3r!\ta\u0017/D\u0001n\u0015\tqw.\u0001\u0002j_*\t\u0001/\u0001\u0003kCZ\f\u0017B\u0001:n\u0005\u00111\u0015\u000e\\3\u0002\u00111|w\rR5sg\u0002\nA\u0001\\8hgV\ta\u000fE\u0003Nof\fI!\u0003\u0002y\u001d\n!\u0001k\\8m!\rQ\u0018QA\u0007\u0002w*\u0011A0`\u0001\u0007G>lWn\u001c8\u000b\u0005\rs(bA@\u0002\u0002\u00051\u0011\r]1dQ\u0016T!!a\u0001\u0002\u0007=\u0014x-C\u0002\u0002\bm\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002a\u0003\u0017I1!!\u0004A\u0005-\t%m\u001d;sC\u000e$Hj\\4\u0002\u000b1|wm\u001d\u0011\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\t\t)\u0002E\u0002Z\u0003/I1!!\u0007[\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0006)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004\u0013\u0001\u0002;j[\u0016\u0004B!!\t\u0002&5\u0011\u00111\u0005\u0006\u0003\u001fnLA!a\n\u0002$\t!A+[7f\u0003\u0019a\u0014N\\5u}Qa\u0011QFA\u0018\u0003c\t\u0019$!\u000e\u00028A\u0011\u0001\r\u0001\u0005\u0006=&\u0001\ra\u0018\u0005\u0006G&\u0001\r!\u001a\u0005\u0006i&\u0001\rA\u001e\u0005\b\u0003#I\u0001\u0019AA\u000b\u0011%\ti\"\u0003I\u0001\u0002\u0004\ty\"\u0001\u0004d_:4\u0017nZ\u000b\u0002?\u0006Q1m\u001c8gS\u001e|F%Z9\u0015\t\u0005\u0005\u0013q\t\t\u0004\u000f\u0006\r\u0013bAA#\u0011\n!QK\\5u\u0011!\tIeCA\u0001\u0002\u0004y\u0016a\u0001=%c\u000591m\u001c8gS\u001e\u0004\u0003f\u0001\u0007\u0002PA\u0019q)!\u0015\n\u0007\u0005M\u0003J\u0001\u0005w_2\fG/\u001b7f\u00039\u0019G.Z1oKJl\u0015M\\1hKJ,\"!!\u0017\u0011\u0007\u0001\fY&C\u0002\u0002^\u0001\u0013\u0011\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s\u0003=\u0019G.Z1oKJl\u0015M\\1hKJ\u0004\u0013!\u0003;ie>$H\u000f\\3s+\t\t)\u0007E\u0002N\u0003OJ1!!\u001bO\u0005%!\u0006N]8ui2,'/\u0001\u0006uQJ|G\u000f\u001e7fe\u0002\n\u0001b\u00197fC:,'o]\u000b\u0003\u0003c\u0002b!a\u001d\u0002z\u0005uTBAA;\u0015\r\t9hZ\u0001\b[V$\u0018M\u00197f\u0013\u0011\tY(!\u001e\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004\u0003\u007f*S\"\u0001\u0001\u0003\u001b\rcW-\u00198feRC'/Z1e'\r)\u0013Q\u0011\t\u0004\u001b\u0006\u001d\u0015bAAE\u001d\n\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0003!!\bN]3bI&#\u0007cA$\u0002\u0010&\u0019\u0011\u0011\u0013%\u0003\u0007%sG\u000f\u0006\u0003\u0002~\u0005U\u0005bBAFO\u0001\u0007\u0011QR\u0001\u000bY><w-\u001a:OC6,WCAAN!\u0011\ti*a)\u000e\u0005\u0005}%bAAQ_\u0006!A.\u00198h\u0013\u0011\t)+a(\u0003\rM#(/\u001b8h\u0003\u001d\u0019G.Z1oKJ,\"!a+\u0011\u0007\u0001\fi+C\u0002\u00020\u0002\u0013qa\u00117fC:,'/\u0001\u0005dY\u0016\fg.\u001a:!\u0003%a\u0017m\u001d;Ti\u0006$8/\u0006\u0002\u00028B\u0019\u0001-!/\n\u0007\u0005m\u0006I\u0001\u0007DY\u0016\fg.\u001a:Ti\u0006$8/A\u0007mCN$8\u000b^1ug~#S-\u001d\u000b\u0005\u0003\u0003\n\t\rC\u0005\u0002J1\n\t\u00111\u0001\u00028\u0006QA.Y:u'R\fGo\u001d\u0011)\u00075\ny%A\tmCN$\bK]3DY\u0016\fgn\u0015;biN,\"!a3\u0011\u0007\u0001\fi-C\u0002\u0002P\u0002\u0013Q\u0002\u0015:f\u00072,\u0017M\\*uCR\u001c\u0018!\u00067bgR\u0004&/Z\"mK\u0006t7\u000b^1ug~#S-\u001d\u000b\u0005\u0003\u0003\n)\u000eC\u0005\u0002J=\n\t\u00111\u0001\u0002L\u0006\u0011B.Y:u!J,7\t\\3b]N#\u0018\r^:!Q\r\u0001\u0014qJ\u0001\nG\",7m\u001b#p]\u0016$B!!\u0011\u0002`\"1\u0011\u0011]\u0019A\u0002e\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003\u0003\nA\u0003\u001e:z\u00072,\u0017M\u001c$jYRD\u0017.Z:u\u0019><GCAAv!\r9\u0015Q^\u0005\u0004\u0003_D%a\u0002\"p_2,\u0017M\\\u0001\u0012G2,\u0017M\u001c$jYRD\u0017.Z:u\u0019><\u0007&\u0002\u001b\u0002v\n\u0005\u0001#B$\u0002x\u0006m\u0018bAA}\u0011\n1A\u000f\u001b:poN\u00042\u0001YA\u007f\u0013\r\ty\u0010\u0011\u0002\u0015\u0019><7\t\\3b]&tw-\u0012=dKB$\u0018n\u001c8$\u0005\u0005m\u0018\u0001C2mK\u0006tGj\\4\u0015\t\u0005\u0005#q\u0001\u0005\b\u0005\u0013)\u0004\u0019\u0001B\u0006\u0003%\u0019G.Z1oC\ndW\rE\u0002a\u0005\u001bI1Aa\u0004A\u0005)aun\u001a+p\u00072,\u0017M\\\u0001\fe\u0016\u001cwN\u001d3Ti\u0006$8\u000f\u0006\u0007\u0002B\tU!\u0011\u0004B\u0019\u0005w\u0011y\u0004C\u0004\u0003\u0018Y\u0002\r!!$\u0002\u0005%$\u0007b\u0002B\u000em\u0001\u0007!QD\u0001\u0005]\u0006lW\r\u0005\u0003\u0003 \t5b\u0002\u0002B\u0011\u0005S\u00012Aa\tI\u001b\t\u0011)CC\u0002\u0003(\u0011\u000ba\u0001\u0010:p_Rt\u0014b\u0001B\u0016\u0011\u00061\u0001K]3eK\u001aLA!!*\u00030)\u0019!1\u0006%\t\u000f\tMb\u00071\u0001\u00036\u0005!aM]8n!\r9%qG\u0005\u0004\u0005sA%\u0001\u0002'p]\u001eDqA!\u00107\u0001\u0004\u0011)$\u0001\u0002u_\"9!\u0011\t\u001cA\u0002\u0005]\u0016!B:uCR\u001c\u0018!C2mK\u0006tWM]:!\u0003=!W-\u00193UQJ,\u0017\rZ\"pk:$XCAAG\u0003\u001d\u0019H/\u0019:ukB\f\u0001b\u001d5vi\u0012|wO\\\u0001\u0016e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\u0011\t\u0006E\u0003g\u0005'\u0012i\"C\u0002\u0003V\u001d\u00141aU3u\u0003]1\u0018\r\\5eCR,'+Z2p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0003\u0002B\tm\u0003b\u0002B//\u0001\u0007!qL\u0001\n]\u0016<8i\u001c8gS\u001e\u00042!\u0017B1\u0013\r\u0011\u0019G\u0017\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006sK\u000e|gNZ5hkJ,GCBA!\u0005S\u0012i\u0007C\u0004\u0003la\u0001\rAa\u0018\u0002\u0013=dGmQ8oM&<\u0007b\u0002B/1\u0001\u0007!qL\u0001\u000eC\n|'\u000f^\"mK\u0006t\u0017N\\4\u0015\t\u0005\u0005#1\u000f\u0005\u0007\u0003CL\u0002\u0019A=\u0002#U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000f\u0006\u0003\u0002B\te\u0004B\u0002B>5\u0001\u00071.A\u0004eCR\fG)\u001b:\u0002%\u0005dG/\u001a:DQ\u0016\u001c7\u000e]8j]R$\u0015N\u001d\u000b\t\u0003\u0003\u0012\tIa!\u0003\b\"1\u0011\u0011]\u000eA\u0002eDaA!\"\u001c\u0001\u0004Y\u0017\u0001D:pkJ\u001cW\rT8h\t&\u0014\bB\u0002BE7\u0001\u00071.\u0001\u0006eKN$Hj\\4ESJ\f1\u0003[1oI2,Gj\\4ESJ4\u0015-\u001b7ve\u0016$B!!\u0011\u0003\u0010\"9!\u0011\u0013\u000fA\u0002\tu\u0011a\u00013je\u00069R.Y=cKR\u0013XO\\2bi\u0016\u001c\u0005.Z2la>Lg\u000e\u001e\u000b\t\u0003\u0003\u00129J!'\u0003\u001c\"1!1P\u000fA\u0002-Da!!9\u001e\u0001\u0004I\bb\u0002BO;\u0001\u0007!QG\u0001\u0007_\u001a47/\u001a;\u0002+\u0005\u0014wN\u001d;B]\u0012\u0004\u0016-^:f\u00072,\u0017M\\5oOR!\u0011\u0011\tBR\u0011\u0019\t\tO\ba\u0001s\u0006q!/Z:v[\u0016\u001cE.Z1oS:<G\u0003BA!\u0005SCqAa+ \u0001\u0004\u0011i+A\bu_BL7\rU1si&$\u0018n\u001c8t!\u00111'qV=\n\u0007\tEvM\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u00031\tw/Y5u\u00072,\u0017M\\3e)!\tYOa.\u0003:\nm\u0006BBAqA\u0001\u0007\u0011\u0010C\u0004\u0003\u001e\u0002\u0002\rA!\u000e\t\u0013\tu\u0006\u0005%AA\u0002\tU\u0012!C7bq^\u000b\u0017\u000e^'t\u0003Y\tw/Y5u\u00072,\u0017M\\3eI\u0011,g-Y;mi\u0012\u001aTC\u0001BbU\u0011\u0011)D!2,\u0005\t\u001d\u0007\u0003\u0002Be\u0005'l!Aa3\u000b\t\t5'qZ\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!5I\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005+\u0014YMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa\u0005]1vg\u0016\u001cE.Z1oS:<gi\u001c:O_:\u001cu.\u001c9bGR,G\rU1si&$\u0018n\u001c8t)\t\u0011Y\u000eE\u0003g\u0005_\u0013i\u000e\u0005\u0004H\u0005?L\u0018\u0011B\u0005\u0004\u0005CD%A\u0002+va2,''A\u0007dkJ\u0014XM\u001c;D_:4\u0017nZ\u0001\rG2,\u0017M\\3s\u0007>,h\u000e^\u0001\u000b\u0019><7\t\\3b]\u0016\u0014\bC\u000119'\tAd\t\u0006\u0002\u0003j\u0006)\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cXC\u0001Bz!\u00151'1KAN\u0003Y\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\u0004\u0013!D2mK\u0006tWM]\"p]\u001aLw\rF\u0002`\u0005wDq!!\u000f=\u0001\u0004\u0011y&A\fde\u0016\fG/\u001a(fo\u000ecW-\u00198fIN+w-\\3oiRA1\u0011AB\u0004\u0007\u0013\u0019\u0019\u0002E\u0002a\u0007\u0007I1a!\u0002A\u0005)aunZ*fO6,g\u000e\u001e\u0005\u0007\u0005#k\u0004\u0019A6\t\u000f\r-Q\b1\u0001\u0004\u000e\u0005IAn\\4D_:4\u0017n\u001a\t\u0004A\u000e=\u0011bAB\t\u0001\nIAj\\4D_:4\u0017n\u001a\u0005\b\u0007+i\u0004\u0019\u0001B\u001b\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\rm!\u0006BA\u0010\u0005\u000b\u0004")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, AbstractLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static LogSegment createNewCleanedSegment(File file, LogConfig logConfig, long l) {
        return LogCleaner$.MODULE$.createNewCleanedSegment(file, logConfig, l);
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, AbstractLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.kafka$log$LogCleaner$$config().numThreads());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogCleaner.$anonfun$startup$2(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            x$11.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig(newConfig).numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, AbstractLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ void $anonfun$startup$2(LogCleaner $this, int i) {
        CleanerThread cleaner = $this.new CleanerThread(i);
        $this.cleaners().$plus$eq((Object)cleaner);
        cleaner.start();
    }

    public static final /* synthetic */ boolean $anonfun$awaitCleaned$1() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$awaitCleaned$2(long offset$1, long x$12) {
        return x$12 >= offset$1;
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        boolean bl;
        Option option = this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1);
        if (option == null) {
            throw null;
        }
        Option fold_this = option;
        if (fold_this.isEmpty()) {
            bl = LogCleaner.$anonfun$awaitCleaned$1();
        } else {
            long l = BoxesRunTime.unboxToLong((Object)fold_this.get());
            bl = LogCleaner.$anonfun$awaitCleaned$2(offset$1, l);
        }
        return bl;
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.cleaners().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)$anon$1.$anonfun$value$2(x$2)), ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$2(CleanerStats x$2) {
                return (double)100 * x$2.bufferUtilization();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$2$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                ArrayBuffer stats = (ArrayBuffer)this.$outer.cleaners().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$4(x$4)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$5(x$5)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }

            public static final /* synthetic */ long $anonfun$value$4(CleanerStats x$4) {
                return x$4.bytesWritten();
            }

            public static final /* synthetic */ long $anonfun$value$5(CleanerStats x$5) {
                return x$5.bytesRead();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$4$adapted(kafka.log.CleanerStats ), $anonfun$value$5$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.cleaners().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)$anon$3.$anonfun$value$7(x$7)), ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$7(CleanerStats x$7) {
                return x$7.elapsedSecs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$6(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$7$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("max-compaction-delay-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return Math.max(0, (int)(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)this.$outer.cleaners().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.lastPreCleanStats(), ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)$anon$4.$anonfun$value$9(x$9)), ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)) / 1000L));
            }

            public static final /* synthetic */ long $anonfun$value$9(PreCleanStats x$9) {
                return x$9.maxCompactionDelayMs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$8(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$9$adapted(kafka.log.PreCleanStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return this.$outer.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        @Override
        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
            }
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().dir().getParent(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(option)) {
                bl = false;
            } else if (option instanceof Some) {
                boolean bl2;
                LogToClean cleanable = (LogToClean)((Some)option).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    boolean bl3 = throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable;
                    if (bl3) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
                bl = bl2;
            } else {
                throw new MatchError(option);
            }
            Iterable<Tuple2<TopicPartition, AbstractLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                this.maybeDeleteOldSegments$1(deletable);
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable & scala.Serializable)x$13 -> (TopicPartition)x$13._1(), Iterable$.MODULE$.canBuildFrom())));
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long endOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var5_4;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, (CleanerStats)var7_5);
                    endOffset = var5_4;
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().dir().getParent();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String string = "%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string2 = "\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string3 = "\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string4 = "\tBuffer utilization: %.1f%%%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string5 = "\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string6 = "\tStart size: %,.1f MB (%,d messages)%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string7 = "\tEnd size: %,.1f MB (%,d messages)%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string8 = "\t%.1f%% size reduction (%.1f%% fewer messages)%n";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String message = new StringBuilder(0).append(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(string2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(string3).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(string4).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(string5).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(string6).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(string7).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(string8).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                    String string = "\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d";
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                    return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())}));
                });
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                    String string = "\tFound %d invalid messages during compaction.";
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                    return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())}));
                });
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ void $anonfun$cleanFilthiestLog$1(CleanerThread $this, IntRef total$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
            if (x0$1 != null) {
                AbstractLog log = (AbstractLog)x0$1._2();
                if (total$1.elem >= $this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun()) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Log cleanup reached the limit of maximum segments that can be deleted limit ").append($this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun()).append(", ").append(total$1.elem).append(" files deleted").toString());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Garbage collecting '").append(log.name()).append("'").toString());
                try {
                    int limit = $this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun() - total$1.elem;
                    total$1.elem += log.deleteOldSegments(limit);
                    return;
                }
                catch (Throwable throwable) {
                    boolean bl = throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable;
                    if (bl) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private final void maybeDeleteOldSegments$1(Iterable deletableLogs) {
            Object object = new Object();
            try {
                IntRef total = IntRef.create((int)0);
                deletableLogs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    CleanerThread.$anonfun$cleanFilthiestLog$1(this, total, object, x0$1);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    ex.value$mcV$sp();
                    return;
                }
                throw ex;
            }
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

