/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.ApiVersion;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin$Coordinator$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.FetchDataInfo;
import kafka.server.FetchLogEnd$;
import kafka.server.ReplicaManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;

@ScalaSignature(bytes="\u0006\u0001\r%s!B\u001e=\u0011\u0003\u0019e!B#=\u0011\u00031\u0005\"B'\u0002\t\u0003q\u0005bB(\u0002\u0005\u0004%\t\u0001\u0015\u0005\u0007)\u0006\u0001\u000b\u0011B)\t\u000fU\u000b!\u0019!C\u0001!\"1a+\u0001Q\u0001\nECqaV\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004Y\u0003\u0001\u0006I!\u0015\u0005\b3\u0006\u0011\r\u0011\"\u0001Q\u0011\u0019Q\u0016\u0001)A\u0005#\u001a!Q\t\u0010\u0001\\\u0011!\u00117B!A!\u0002\u0013\t\u0006\u0002C2\f\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011)\\!\u0011!Q\u0001\n-D\u0001B\\\u0006\u0003\u0002\u0003\u0006Ia\u001c\u0005\tk.\u0011\t\u0011)A\u0005m\"A\u0011p\u0003B\u0001B\u0003%!\u0010\u0003\u0006\u0002\u000e-\u0011\t\u0011)A\u0005\u0003\u001fA!\"!\u0007\f\u0005\u0003\u0005\u000b\u0011BA\u000e\u0011\u0019i5\u0002\"\u0001\u0002(\u00151\u00111H\u0006\u0001\u0003{A\u0011\"a\u001e\f\u0005\u0004%I!!\u001f\t\u0011\u0005M5\u0002)A\u0005\u0003wB\u0011\"!&\f\u0005\u0004%I!a&\t\u0011\u0005\u00156\u0002)A\u0005\u00033C!\"a*\f\u0005\u0004%\t\u0001PAU\u0011!\t\tm\u0003Q\u0001\n\u0005-\u0006BCAb\u0017\t\u0007I\u0011\u0001\u001f\u0002F\"A\u00111[\u0006!\u0002\u0013\t9\r\u0003\u0005\u0002V.\u0011\r\u0011\"\u0003Q\u0011\u001d\t9n\u0003Q\u0001\nEC\u0011\"!7\f\u0005\u0004%I!a7\t\u0011\u0005\r8\u0002)A\u0005\u0003;D\u0001\"!:\f\t\u0003a\u0014q\u001d\u0005\t\u0003c\\A\u0011\u0001\u001f\u0002t\"9!\u0011A\u0006\u0005\u0002\t\r\u0001b\u0002B\u000f\u0017\u0011%!q\u0004\u0005\b\u0005cYA\u0011\u0002B\u001a\u0011\u001d\u0011Ie\u0003C\u0005\u0005\u0017B\u0001B!\b\f\t\u0003a$\u0011\r\u0005\b\u0005GZA\u0011\u0002B3\u0011\u001d\u0011yh\u0003C\u0001\u0005CBqA!!\f\t\u0003\u0011\u0019\tC\u0004\u0003(.!\tA!+\t\u000f\t=6\u0002\"\u0003\u00032\"9!1X\u0006\u0005\u0002\tu\u0006b\u0002Bb\u0017\u0011\u0005!Q\u0019\u0005\b\u0005\u001f\\A\u0011\u0001Bi\u0011\u0019\u0011)n\u0003C\u0005!\"9!q[\u0006\u0005\n\te\u0007\u0002\u0003Bt\u0017\u0011\u0005AH!;\t\u000f\tU8\u0002\"\u0001\u0003x\"91QA\u0006\u0005\u0002\r\u001d\u0001bBB\u0003\u0017\u0011\u000511\u0002\u0005\b\u0007#YA\u0011\u0002B1\u0011\u001d\u0019\u0019b\u0003C\u0001\u0007+A\u0011ba\f\f#\u0003%\ta!\r\t\u000f\r\u001d3\u0002\"\u0001\u0003b\u00059BK]1og\u0006\u001cG/[8o'R\fG/Z'b]\u0006<WM\u001d\u0006\u0003{y\n1\u0002\u001e:b]N\f7\r^5p]*\u0011q\bQ\u0001\fG>|'\u000fZ5oCR|'OC\u0001B\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001R\u0001\u000e\u0003q\u0012q\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:\u0014\u0005\u00059\u0005C\u0001%L\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0007\u0006yB)\u001a4bk2$HK]1og\u0006\u001cG/[8og6\u000b\u0007\u0010V5nK>,H/T:\u0016\u0003E\u0003\"\u0001\u0013*\n\u0005MK%aA%oi\u0006\u0001C)\u001a4bk2$HK]1og\u0006\u001cG/[8og6\u000b\u0007\u0010V5nK>,H/T:!\u0003\t\"UMZ1vYR$&/\u00198tC\u000e$\u0018n\u001c8bY&#W\t\u001f9je\u0006$\u0018n\u001c8Ng\u0006\u0019C)\u001a4bk2$HK]1og\u0006\u001cG/[8oC2LE-\u0012=qSJ\fG/[8o\u001bN\u0004\u0013A\u000b#fM\u0006,H\u000e^!c_J$H+[7fI>+H\u000f\u0016:b]N\f7\r^5p]NLe\u000e^3sm\u0006dWj]\u0001,\t\u00164\u0017-\u001e7u\u0003\n|'\u000f\u001e+j[\u0016$w*\u001e;Ue\u0006t7/Y2uS>t7/\u00138uKJ4\u0018\r\\'tA\u0005qC)\u001a4bk2$(+Z7pm\u0016,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7/\u00138uKJ4\u0018\r\\'t\u0003=\"UMZ1vYR\u0014V-\\8wK\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\u0018J\u001c;feZ\fG.T:!'\rYq\t\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\u0002\u000bQ!\u001e;jYNL!!\u00190\u0003\u000f1{wmZ5oO\u0006A!M]8lKJLE-\u0001\u0005{W\u000ec\u0017.\u001a8u!\t)\u0007.D\u0001g\u0015\t9\u0007)\u0001\u0002{W&\u0011\u0011N\u001a\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bCA/m\u0013\tigLA\u0005TG\",G-\u001e7fe\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bC\u00019t\u001b\u0005\t(B\u0001:A\u0003\u0019\u0019XM\u001d<fe&\u0011A/\u001d\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0019\u0019wN\u001c4jOB\u0011Ai^\u0005\u0003qr\u0012\u0011\u0003\u0016:b]N\f7\r^5p]\u000e{gNZ5h\u0003\u0011!\u0018.\\3\u0011\u0007m\fI!D\u0001}\u0015\tyVP\u0003\u0002\u007f\u007f\u000611m\\7n_:T1!QA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t9!A\u0002pe\u001eL1!a\u0003}\u0005\u0011!\u0016.\\3\u0002\u000f5,GO]5dgB!\u0011\u0011CA\u000b\u001b\t\t\u0019BC\u0002\u0002\u000euLA!a\u0006\u0002\u0014\t9Q*\u001a;sS\u000e\u001c\u0018AG5oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dg+\u001a:tS>t\u0007\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005\u0002)A\u0002ba&LA!!\n\u0002 \tQ\u0011\t]5WKJ\u001c\u0018n\u001c8\u0015%\u0005%\u00121FA\u0017\u0003_\t\t$a\r\u00026\u0005]\u0012\u0011\b\t\u0003\t.AQA\u0019\u000bA\u0002ECQa\u0019\u000bA\u0002\u0011DQA\u001b\u000bA\u0002-DQA\u001c\u000bA\u0002=DQ!\u001e\u000bA\u0002YDQ!\u001f\u000bA\u0002iDq!!\u0004\u0015\u0001\u0004\ty\u0001C\u0004\u0002\u001aQ\u0001\r!a\u0007\u0003-M+g\u000e\u001a+y]6\u000b'o[3sg\u000e\u000bG\u000e\u001c2bG.\u0004b\u0002SA \u0003\u0007\n\u0016\u0011LA3\u0003W\n\t(C\u0002\u0002B%\u0013\u0011BR;oGRLwN\\\u001b\u0011\t\u0005\u0015\u00131\u000b\b\u0005\u0003\u000f\ny\u0005E\u0002\u0002J%k!!a\u0013\u000b\u0007\u00055#)\u0001\u0004=e>|GOP\u0005\u0004\u0003#J\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002V\u0005]#AB*ue&twMC\u0002\u0002R%\u0003B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?j\u0018\u0001\u0003:fcV,7\u000f^:\n\t\u0005\r\u0014Q\f\u0002\u0012)J\fgn]1di&|gNU3tk2$\bc\u0001#\u0002h%\u0019\u0011\u0011\u000e\u001f\u0003'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0011\u0007\u0011\u000bi'C\u0002\u0002pq\u0012!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uCB\u0019\u0001*a\u001d\n\u0007\u0005U\u0014J\u0001\u0003V]&$\u0018\u0001D:ikR$\u0018N\\4E_^tWCAA>!\u0011\ti(a$\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000ba!\u0019;p[&\u001c'\u0002BAC\u0003\u000f\u000b!bY8oGV\u0014(/\u001a8u\u0015\u0011\tI)a#\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u001b\u000bAA[1wC&!\u0011\u0011SA@\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006i1\u000f[;ui&tw\rR8x]\u0002\n\u0011b\u001d;bi\u0016dunY6\u0016\u0005\u0005e\u0005\u0003BAN\u0003Ck!!!(\u000b\t\u0005}\u00151Q\u0001\u0006Y>\u001c7n]\u0005\u0005\u0003G\u000biJ\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0003)\u0019H/\u0019;f\u0019>\u001c7\u000eI\u0001\u0012Y>\fG-\u001b8h!\u0006\u0014H/\u001b;j_:\u001cXCAAV!\u0019\ti+a.\u0002<6\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019,A\u0004nkR\f'\r\\3\u000b\u0007\u0005U\u0016*\u0001\u0006d_2dWm\u0019;j_:LA!!/\u00020\n\u00191+\u001a;\u0011\u0007\u0011\u000bi,C\u0002\u0002@r\u0012!\u0005\u0016:b]N\f7\r^5p]B\u000b'\u000f^5uS>t\u0017I\u001c3MK\u0006$WM]#q_\u000eD\u0017A\u00057pC\u0012Lgn\u001a)beRLG/[8og\u0002\n\u0001\u0004\u001e:b]N\f7\r^5p]6+G/\u00193bi\u0006\u001c\u0015m\u00195f+\t\t9\rE\u0004\u0002.\u0006%\u0017+!4\n\t\u0005-\u0017q\u0016\u0002\u0004\u001b\u0006\u0004\bc\u0001#\u0002P&\u0019\u0011\u0011\u001b\u001f\u0003+QCh.T3uC\u0012\fG/Y\"bG\",WI\u001c;ss\u0006IBO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003y!(/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtG/A\u0010ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oi\u0002\n1\u0003]1si&$\u0018n\u001c8M_\u0006$7+\u001a8t_J,\"!!8\u0011\t\u0005E\u0011q\\\u0005\u0005\u0003C\f\u0019B\u0001\u0004TK:\u001cxN]\u0001\u0015a\u0006\u0014H/\u001b;j_:du.\u00193TK:\u001cxN\u001d\u0011\u0002'\u0005$G\rT8bI&tw\rU1si&$\u0018n\u001c8\u0015\r\u0005E\u0014\u0011^Aw\u0011\u0019\tYO\ta\u0001#\u0006Y\u0001/\u0019:uSRLwN\\%e\u0011\u0019\tyO\ta\u0001#\u0006\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r[\u0001\u000egR\fG/\u001a*fC\u0012dunY6\u0016\u0005\u0005U\b\u0003BA|\u0003{l!!!?\u000b\t\u0005m\u0018QT\u0001\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW&!\u0011q`A}\u0005!\u0011V-\u00193M_\u000e\\\u0017\u0001\u0006;j[\u0016$w*\u001e;Ue\u0006t7/Y2uS>t7\u000f\u0006\u0002\u0003\u0006A1!q\u0001B\t\u0005/qAA!\u0003\u0003\u000e9!\u0011\u0011\nB\u0006\u0013\u0005Q\u0015b\u0001B\b\u0013\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\n\u0005+\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005\u001fI\u0005c\u0001#\u0003\u001a%\u0019!1\u0004\u001f\u0003CQ\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\fe\u000e\u001a)s_\u0012,8-\u001a:JI\u0016\u0003xn\u00195\u0002;I,Wn\u001c<f\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JIN$b!!\u001d\u0003\"\t5\u0002b\u0002B\u0012K\u0001\u0007!QE\u0001\u0015iJ\fgn]1di&|g\u000eU1si&$\u0018n\u001c8\u0011\t\t\u001d\"\u0011F\u0007\u0002{&\u0019!1F?\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9!qF\u0013A\u0002\u00055\u0017!\u0006;y]6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u000b:$(/_\u0001\rg\"|W\u000f\u001c3FqBL'/\u001a\u000b\u0007\u0005k\u0011YDa\u0010\u0011\u0007!\u00139$C\u0002\u0003:%\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0003>\u0019\u0002\r!!\u001a\u0002\u0017QDh.T3uC\u0012\fG/\u0019\u0005\b\u0005\u00032\u0003\u0019\u0001B\"\u00035\u0019WO\u001d:f]R$\u0016.\\3NgB\u0019\u0001J!\u0012\n\u0007\t\u001d\u0013J\u0001\u0003M_:<\u0017!F7bs\n,\u0017\t\u001d9f]\u0012,\u0005\u0010]5sCRLwN\u001c\u000b\t\u0005k\u0011iEa\u0014\u0003`!9!QH\u0014A\u0002\u0005\u0015\u0004b\u0002B)O\u0001\u0007!1K\u0001\u000fe\u0016\u001cwN\u001d3t\u0005VLG\u000eZ3s!\u0011\u0011)Fa\u0017\u000e\u0005\t]#b\u0001B-{\u00061!/Z2pe\u0012LAA!\u0018\u0003X\t!R*Z7pef\u0014VmY8sIN\u0014U/\u001b7eKJDqA!\u0011(\u0001\u0004\u0011\u0019\u0005\u0006\u0002\u0002r\u0005IsO]5uKR{WNY:u_:,7OR8s\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JIN$\u0002\"!\u001d\u0003h\t%$Q\u000f\u0005\b\u0005GI\u0003\u0019\u0001B\u0013\u0011\u001d\u0011Y'\u000ba\u0001\u0005[\n1#\u001a=qSJ,GMR8s!\u0006\u0014H/\u001b;j_:\u0004bAa\u0002\u0003\u0012\t=\u0004c\u0001#\u0003r%\u0019!1\u000f\u001f\u0003UQ\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001cun\u001c:eS:\fGo\u001c:Fa>\u001c\u0007.\u00118e\u001b\u0016$\u0018\rZ1uC\"9!qO\u0015A\u0002\te\u0014\u0001\u0005;p[\n\u001cHo\u001c8f%\u0016\u001cwN\u001d3t!\u0011\u0011)Fa\u001f\n\t\tu$q\u000b\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\u0002?\u0015t\u0017M\u00197f)J\fgn]1di&|g.\u00197JI\u0016C\b/\u001b:bi&|g.A\nhKR$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\r\u0006\u0003\u0003\u0006\n\r\u0006\u0003\u0003B\u0004\u0005\u000f\u0013YIa&\n\t\t%%Q\u0003\u0002\u0007\u000b&$\b.\u001a:\u0011\t\t5%1S\u0007\u0003\u0005\u001fS1A!%~\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002BK\u0005\u001f\u0013a!\u0012:s_J\u001c\b#\u0002%\u0003\u001a\nu\u0015b\u0001BN\u0013\n1q\n\u001d;j_:\u00042\u0001\u0012BP\u0013\r\u0011\t\u000b\u0010\u0002\u001f\u0007>|'\u000fZ5oCR|'/\u00129pG\"\fe\u000e\u001a+y]6+G/\u00193bi\u0006DqA!*,\u0001\u0004\t\u0019%A\bue\u0006t7/Y2uS>t\u0017\r\\%e\u0003y\u0001X\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u0013\u001atu\u000e^#ySN$8\u000f\u0006\u0003\u0003,\n5\u0006\u0003\u0003B\u0004\u0005\u000f\u0013YI!(\t\u000f\tuB\u00061\u0001\u0002f\u0005qr-\u001a;B]\u0012l\u0015-\u001f2f\u0003\u0012$GK]1og\u0006\u001cG/[8o'R\fG/\u001a\u000b\u0007\u0005\u000b\u0013\u0019L!.\t\u000f\t\u0015V\u00061\u0001\u0002D!9!qW\u0017A\u0002\te\u0016!F2sK\u0006$X\r\u001a+y]6+G/\u00193bi\u0006|\u0005\u000f\u001e\t\u0006\u0011\ne\u0015QM\u0001\u001dm\u0006d\u0017\u000eZ1uKR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'t)\u0011\u0011)Da0\t\r\t\u0005g\u00061\u0001R\u00031!\bP\u001c+j[\u0016|W\u000f^'t\u0003]!(/\u00198tC\u000e$\u0018n\u001c8U_BL7mQ8oM&<7/\u0006\u0002\u0003HB!!\u0011\u001aBf\u001b\t\t9)\u0003\u0003\u0003N\u0006\u001d%A\u0003)s_B,'\u000f^5fg\u0006a\u0001/\u0019:uSRLwN\u001c$peR\u0019\u0011Ka5\t\u000f\t\u0015\u0006\u00071\u0001\u0002D\u0005\ts-\u001a;Ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oi\u00069Bn\\1e)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u000b\u0007\u00057\u0014\tO!:\u0011\u000fu\u0013i.a\u0011\u0002f%\u0019!q\u001c0\u0003\tA{w\u000e\u001c\u0005\b\u0005G\u0014\u0004\u0019\u0001B\u0013\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Da!a<3\u0001\u0004\t\u0016\u0001H1eI2{\u0017\rZ3e)J\fgn]1di&|gn\u001d+p\u0007\u0006\u001c\u0007.\u001a\u000b\t\u0003c\u0012YOa<\u0003r\"1!Q^\u001aA\u0002E\u000b\u0011\u0003\u001e=o)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\tyo\ra\u0001#\"9!1_\u001aA\u0002\tm\u0017A\u00057pC\u0012,G\r\u0016:b]N\f7\r^5p]N\fA\u0005\\8bIR\u0013\u0018M\\:bGRLwN\\:G_J$\u0006P\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u000b\t\u0003c\u0012IPa?\u0003~\"1\u00111\u001e\u001bA\u0002ECa!a<5\u0001\u0004\t\u0006b\u0002B\u0000i\u0001\u00071\u0011A\u0001\u000fg\u0016tG\r\u0016=o\u001b\u0006\u00148.\u001a:t!\r\u0019\u0019!F\u0007\u0002\u0017\u00051#/Z7pm\u0016$&/\u00198tC\u000e$\u0018n\u001c8t\r>\u0014H\u000b\u001f8U_BL7\rU1si&$\u0018n\u001c8\u0015\t\u0005E4\u0011\u0002\u0005\u0007\u0003W,\u0004\u0019A)\u0015\r\u0005E4QBB\b\u0011\u0019\tYO\u000ea\u0001#\"1\u0011q\u001e\u001cA\u0002E\u000baF^1mS\u0012\fG/\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u\u0013N\u001cF/\u00192mK\u00061\u0012\r\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8U_2{w\r\u0006\u0007\u0002r\r]1\u0011DB\u000e\u0007?\u0019I\u0003C\u0004\u0003&b\u0002\r!a\u0011\t\r\u0005=\b\b1\u0001R\u0011\u001d\u0019i\u0002\u000fa\u0001\u0003W\n1B\\3x\u001b\u0016$\u0018\rZ1uC\"91\u0011\u0005\u001dA\u0002\r\r\u0012\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u001dA5Q\u0005BF\u0003cJ1aa\nJ\u0005%1UO\\2uS>t\u0017\u0007C\u0005\u0004,a\u0002\n\u00111\u0001\u0004.\u0005a!/\u001a;ss>sWI\u001d:peB9\u0001j!\n\u0003\f\nU\u0012\u0001I1qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4%I\u00164\u0017-\u001e7uIU*\"aa\r+\t\r52QG\u0016\u0003\u0007o\u0001Ba!\u000f\u0004D5\u001111\b\u0006\u0005\u0007{\u0019y$A\u0005v]\u000eDWmY6fI*\u00191\u0011I%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004F\rm\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006A1\u000f[;uI><h\u000e")
public class TransactionStateManager
implements Logging {
    private final KafkaZkClient zkClient;
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private final int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    /*
     * WARNING - void declaration
     */
    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        void inWriteLock_lock;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$addLoadingPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public ReentrantReadWriteLock.ReadLock stateReadLock() {
        return this.stateLock().readLock();
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        Iterable iterable;
        void inReadLock_lock;
        long now = this.time.milliseconds();
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            iterable = TransactionStateManager.$anonfun$timedOutTransactions$1(this, now);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    private void removeExpiredTransactionalIds(TopicPartition transactionPartition, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$1(this, transactionPartition, txnMetadataCacheEntry);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private boolean shouldExpire(TransactionMetadata txnMetadata, long currentTimeMs) {
        return txnMetadata.state().isExpirationAllowed() && txnMetadata.txnLastUpdateTimestamp() <= currentTimeMs - (long)this.config.transactionalIdExpirationMs();
    }

    private boolean maybeAppendExpiration(TransactionMetadata txnMetadata, MemoryRecordsBuilder recordsBuilder, long currentTimeMs) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(txnMetadata.transactionalId());
        if (recordsBuilder.hasRoomFor(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS)) {
            recordsBuilder.append(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void removeExpiredTransactionalIds() {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$4(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeTombstonesForExpiredTransactionalIds(TopicPartition transactionPartition, Iterable<TransactionalIdCoordinatorEpochAndMetadata> expiredForPartition, MemoryRecords tombstoneRecords) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$7(this, transactionPartition, tombstoneRecords, expiredForPartition);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.removeExpiredTransactionalIds(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(TransactionMetadata txnMetadata) {
        Either either;
        Either.RightProjection rightProjection = this.getAndMaybeAddTransactionState(txnMetadata.transactionalId(), (Option<TransactionMetadata>)new Some((Object)txnMetadata)).right();
        if (rightProjection == null) {
            throw null;
        }
        Either.RightProjection map_this = rightProjection;
        Either either2 = map_this.e();
        if (either2 instanceof Right) {
            Object map_b = ((Right)either2).value();
            Option option = (Option)map_b;
            either = new Right((Object)TransactionStateManager.$anonfun$putTransactionStateIfNotExists$1(txnMetadata, option));
        } else {
            either = map_this.e();
        }
        return either;
    }

    /*
     * WARNING - void declaration
     */
    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        Either either;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            either = TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$1(this, transactionalId, createdTxnMetadataOpt);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return either;
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Properties transactionTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)this.config.transactionLogMinInsyncReplicas())).toString());
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.config.transactionLogSegmentBytes())).toString());
        return var1_1;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private int getTransactionTopicPartitionCount() {
        Option<Object> option = this.zkClient.getTopicPartitionCount("__transaction_state");
        if (option == null) {
            throw null;
        }
        Option<Object> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToInteger((int)this.config.transactionLogNumPartitions()) : getOrElse_this.get();
        return BoxesRunTime.unboxToInt((Object)object);
    }

    /*
     * WARNING - void declaration
     */
    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        long startMs = this.time.milliseconds();
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)Pool$.MODULE$.$lessinit$greater$default$1());
        Option<AbstractLog> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
        } else if (option instanceof Some) {
            AbstractLog log = (AbstractLog)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            boolean readAtLeastOneRecord = true;
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                    MemoryRecords memoryRecords;
                    boolean bl;
                    void inReadLock_lock;
                    ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
                    if (CoreUtils$.MODULE$ == null) {
                        throw null;
                    }
                    Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
                    inReadLock_inLock_lock.lock();
                    try {
                        bl = TransactionStateManager.$anonfun$loadTransactionMetadata$3(this, topicPartition, coordinatorEpoch);
                    }
                    finally {
                        inReadLock_inLock_lock.unlock();
                    }
                    if (!bl) break;
                    AbstractFetchDataInfo abstractFetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchLogEnd$.MODULE$, true, false);
                    if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
                        throw new IllegalStateException("Unexpected tiered segment for __transaction_state topic");
                    }
                    FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
                    readAtLeastOneRecord = fetchDataInfo.records().sizeInBytes() > 0;
                    Records records = fetchDataInfo.records();
                    if (records instanceof MemoryRecords) {
                        memoryRecords = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(125).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                        } else {
                            buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(memoryRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$6(loadedTransactions, currOffset, batch);
                        return BoxedUnit.UNIT;
                    });
                    long endMs = this.time.milliseconds();
                    long timeLapse = endMs - startMs;
                    this.partitionLoadSensor().record((double)timeLapse, endMs, false);
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Finished loading ").append(loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition).append(" in ").append(timeLapse).append(" milliseconds").toString());
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        Option previousTxnMetadataCacheEntryOpt = this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry);
        if (previousTxnMetadataCacheEntryOpt == null) {
            throw null;
        }
        if (!previousTxnMetadataCacheEntryOpt.isEmpty()) {
            TxnMetadataCacheEntry txnMetadataCacheEntry2 = (TxnMetadataCacheEntry)previousTxnMetadataCacheEntryOpt.get();
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").append("loading metadata at epoch ").append(coordinatorEpoch$2).toString());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function5<String, Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        void inWriteLock_lock;
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        this.scheduler.schedule(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void loadTransactions$1_inWriteLock_lock;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition).append(" at epoch ").append(coordinatorEpoch).toString());
            this.validateTransactionTopicPartitionCountIsStable();
            Pool<String, TransactionMetadata> loadTransactions$1_loadedTransactions = this.loadTransactionMetadata(topicPartition, coordinatorEpoch);
            ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
            if (CoreUtils$.MODULE$ == null) {
                throw null;
            }
            Lock loadTransactions$1_inWriteLock_inLock_lock = loadTransactions$1_inWriteLock_lock.writeLock();
            loadTransactions$1_inWriteLock_inLock_lock.lock();
            try {
                TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$3(this, partitionAndLeaderEpoch, topicPartition, coordinatorEpoch, loadTransactions$1_loadedTransactions, sendTxnMarkers);
            }
            finally {
                loadTransactions$1_inWriteLock_inLock_lock.unlock();
            }
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition).append(" for coordinator epoch ").append(coordinatorEpoch).toString());
        }, this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    /*
     * WARNING - void declaration
     */
    public void removeTransactionsForTxnTopicPartition(int partitionId) {
        void inWriteLock_lock;
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$1(this, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        void inWriteLock_lock;
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$5(this, partitionAndLeaderEpoch, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        if (this.transactionTopicPartitionCount() != curTransactionTopicPartitionCount) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(this.transactionTopicPartitionCount()).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError) {
        void inReadLock_lock;
        void $minus$greater$extension_$this;
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        long timestamp = this.time.milliseconds();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)});
        TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)records);
        scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$appendTransactionToLog$13(this, transactionalId, responseCallback, coordinatorEpoch, newMetadata, recordsPerPartition, topicPartition, retryOnError);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$5));
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(long now$1, Tuple2 x0$2) {
        boolean bl;
        if (x0$2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)x0$2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                bl = false;
            } else {
                TransactionState transactionState = txnMetadata.state();
                boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1 : false;
                bl = bl2;
            }
        } else {
            throw new MatchError(null);
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final /* synthetic */ Iterable $anonfun$timedOutTransactions$1(TransactionStateManager $this, long now$1) {
        return (Iterable)$this.transactionMetadataCache().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Iterable iterable = (Iterable)((TraversableLike)((TxnMetadataCacheEntry)x0$1._2()).metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(now$1, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                String txnId = (String)x0$3._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$3._2();
                TransactionalIdAndProducerIdEpoch transactionalIdAndProducerIdEpoch = new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                return transactionalIdAndProducerIdEpoch;
            }, Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
    }

    private final void flushRecordsBuilder$1(TopicPartition transactionPartition$1, ListBuffer expired$1, ObjectRef recordsBuilder$1) {
        this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired$1.toSeq(), ((MemoryRecordsBuilder)recordsBuilder$1.elem).build());
        expired$1.clear();
        recordsBuilder$1.elem = null;
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$1(TransactionStateManager $this, TopicPartition transactionPartition$1, TxnMetadataCacheEntry txnMetadataCacheEntry$1) {
        Option<LogConfig> option = $this.replicaManager.getLogConfig(transactionPartition$1);
        if (option instanceof Some) {
            LogConfig logConfig = (LogConfig)((Object)((Some)option).value());
            long currentTimeMs = $this.time.milliseconds();
            Integer maxBatchSize = logConfig.maxMessageSize();
            ListBuffer expired = (ListBuffer)ListBuffer$.MODULE$.empty();
            ObjectRef recordsBuilder = ObjectRef.create(null);
            BufferedIterator stateEntries = txnMetadataCacheEntry$1.metadataPerTransactionalId().values().iterator().buffered();
            while (stateEntries.hasNext()) {
                TransactionMetadata txnMetadata = (TransactionMetadata)stateEntries.head();
                String transactionalId = txnMetadata.transactionalId();
                BooleanRef fullBatch = BooleanRef.create((boolean)false);
                txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadata.pendingState().isEmpty() && $this.shouldExpire(txnMetadata, currentTimeMs)) {
                        if ((MemoryRecordsBuilder)recordsBuilder$1.elem == null) {
                            recordsBuilder$1.elem = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(16384, Predef$.MODULE$.Integer2int(maxBatchSize))), (CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (TimestampType)TimestampType.CREATE_TIME, (long)0L, (int)Predef$.MODULE$.Integer2int(maxBatchSize));
                        }
                        if ($this.maybeAppendExpiration(txnMetadata, (MemoryRecordsBuilder)recordsBuilder$1.elem, currentTimeMs)) {
                            TxnTransitMetadata transitMetadata = txnMetadata.prepareDead();
                            return expired.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, txnMetadataCacheEntry$1.coordinatorEpoch(), transitMetadata));
                        }
                        fullBatch$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                });
                if (fullBatch.elem) {
                    $this.flushRecordsBuilder$1(transactionPartition$1, expired, recordsBuilder);
                    continue;
                }
                stateEntries.next();
            }
            if (expired.nonEmpty()) {
                $this.flushRecordsBuilder$1(transactionPartition$1, expired, recordsBuilder);
                return;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(156).append("Transaction expiration for partition ").append(transactionPartition$1).append(" failed because the log ").append("config was not available, which likely means the partition is not online or is no longer local.").toString());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$5(TransactionStateManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            int partitionId = x0$1._1$mcI$sp();
            TxnMetadataCacheEntry partitionCacheEntry = (TxnMetadataCacheEntry)x0$1._2();
            TopicPartition transactionPartition = new TopicPartition("__transaction_state", partitionId);
            $this.removeExpiredTransactionalIds(transactionPartition, partitionCacheEntry);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$4(TransactionStateManager $this) {
        $this.transactionMetadataCache().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$5($this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$2(TransactionStateManager $this, TopicPartition topicPartition$1, Iterable expiredForPartition$1, ProduceResponse.PartitionResponse response$1) {
        Option option = $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition$1.partition()));
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)foreach_this.get();
            expiredForPartition$1.foreach((Function1 & Serializable & scala.Serializable)idCoordinatorEpochAndMetadata -> {
                String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                return txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                            return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                        }
                    }
                    $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(192).append("Failed to remove expired transactionalId: ").append(transactionalId).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").append(idCoordinatorEpochAndMetadata.coordinatorEpoch()).toString());
                    txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            });
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$1(TransactionStateManager $this, Iterable expiredForPartition$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            void inReadLock_lock;
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            ProduceResponse.PartitionResponse response = (ProduceResponse.PartitionResponse)x0$1._2();
            ReentrantReadWriteLock reentrantReadWriteLock = $this.stateLock();
            if (CoreUtils$.MODULE$ == null) {
                throw null;
            }
            Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
            inReadLock_inLock_lock.lock();
            try {
                TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$2($this, topicPartition, expiredForPartition$1, response);
            }
            finally {
                inReadLock_inLock_lock.unlock();
            }
            return;
        }
        throw new MatchError(null);
    }

    private final void removeFromCacheCallback$1(Map responses, Iterable expiredForPartition$1) {
        responses.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$1(this, expiredForPartition$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$7(TransactionStateManager $this, TopicPartition transactionPartition$2, MemoryRecords tombstoneRecords$1, Iterable expiredForPartition$1) {
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)transactionPartition$2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)tombstoneRecords$1);
        $this.replicaManager.appendRecords($this.config.requestTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responses -> {
            $this.removeFromCacheCallback$1(responses, expiredForPartition$1);
            return BoxedUnit.UNIT;
        }, (Option<Lock>)new Some((Object)$this.stateLock().readLock()), $this.replicaManager.appendRecords$default$8());
    }

    public static final /* synthetic */ Nothing$ $anonfun$putTransactionStateIfNotExists$2(TransactionMetadata txnMetadata$3) {
        throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata$3).toString());
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$putTransactionStateIfNotExists$1(TransactionMetadata txnMetadata$3, Option x$1) {
        if (x$1 == null) {
            throw null;
        }
        if (x$1.isEmpty()) {
            throw TransactionStateManager.$anonfun$putTransactionStateIfNotExists$2(txnMetadata$3);
        }
        return (CoordinatorEpochAndTxnMetadata)x$1.get();
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$2) {
        return x$2.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ TransactionMetadata $anonfun$getAndMaybeAddTransactionState$4(TxnMetadataCacheEntry cacheEntry$1, String transactionalId$3, TransactionMetadata createdTxnMetadata) {
        Option option = Option$.MODULE$.apply((Object)cacheEntry$1.metadataPerTransactionalId().putIfNotExists(transactionalId$3, createdTxnMetadata));
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? createdTxnMetadata : getOrElse_this.get();
        return (TransactionMetadata)object;
    }

    public static final /* synthetic */ Option $anonfun$getAndMaybeAddTransactionState$3(Option createdTxnMetadataOpt$1, TxnMetadataCacheEntry cacheEntry$1, String transactionalId$3) {
        None$ none$;
        if (createdTxnMetadataOpt$1 == null) {
            throw null;
        }
        if (createdTxnMetadataOpt$1.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            TransactionMetadata transactionMetadata = (TransactionMetadata)createdTxnMetadataOpt$1.get();
            none$ = new Some((Object)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$4(cacheEntry$1, transactionalId$3, transactionMetadata));
        }
        return none$;
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$getAndMaybeAddTransactionState$6(TxnMetadataCacheEntry cacheEntry$1, TransactionMetadata x$3) {
        return new CoordinatorEpochAndTxnMetadata(cacheEntry$1.coordinatorEpoch(), x$3);
    }

    public static final /* synthetic */ Either $anonfun$getAndMaybeAddTransactionState$1(TransactionStateManager $this, String transactionalId$3, Option createdTxnMetadataOpt$1) {
        Left left;
        int partitionId = $this.partitionFor(transactionalId$3);
        if ($this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$2)))) {
            return scala.package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        Option option = $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (option instanceof Some) {
            None$ none$;
            TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            Option option2 = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId$3));
            if (option2 == null) {
                throw null;
            }
            Option orElse_this = option2;
            Option option3 = orElse_this.isEmpty() ? TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$3(createdTxnMetadataOpt$1, cacheEntry, transactionalId$3) : orElse_this;
            Right$ right$ = scala.package$.MODULE$.Right();
            if (option3 == null) {
                throw null;
            }
            if (option3.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                TransactionMetadata transactionMetadata = (TransactionMetadata)option3.get();
                none$ = new Some((Object)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$6(cacheEntry, transactionMetadata));
            }
            left = right$.apply((Object)none$);
        } else if (None$.MODULE$.equals(option)) {
            left = scala.package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    public static final /* synthetic */ long $anonfun$loadTransactionMetadata$1() {
        return -1L;
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        Option<Object> option = this.replicaManager.getLogEndOffset(topicPartition$2);
        if (option == null) {
            throw null;
        }
        Option<Object> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToLong((long)TransactionStateManager.$anonfun$loadTransactionMetadata$1()) : getOrElse_this.get();
        return BoxesRunTime.unboxToLong((Object)object);
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$3(TransactionStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$1) {
        return $this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition$2, coordinatorEpoch$1, idAndEpoch)));
    }

    public static final /* synthetic */ String $anonfun$loadTransactionMetadata$8() {
        return "Transaction state log's key should not be null";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        void require_requirement;
        boolean bl = record.hasKey();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (require_requirement == false) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)TransactionStateManager.$anonfun$loadTransactionMetadata$8()).toString());
        }
        String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
        Option<TransactionMetadata> option = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
        if (None$.MODULE$.equals(option)) {
            TransactionMetadata cfr_ignored_0 = (TransactionMetadata)loadedTransactions$1.remove(transactionalId);
        } else if (option instanceof Some) {
            TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
            loadedTransactions$1.put(transactionalId, txnMetadata);
        } else {
            throw new MatchError(option);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$6(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch) {
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionStateManager.$anonfun$loadTransactionMetadata$7(loadedTransactions$1, currOffset$1, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$6(Function5 sendTxnMarkers$1, TransactionalIdCoordinatorEpochAndTransitMetadata txnTransitMetadata) {
        sendTxnMarkers$1.apply((Object)txnTransitMetadata.transactionalId(), (Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$3(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, TopicPartition topicPartition$3, int coordinatorEpoch$3, Pool loadedTransactions$2, Function5 sendTxnMarkers$1) {
        if ($this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
            $this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions$2);
            ListBuffer transactionsPendingForCompletion = new ListBuffer();
            loadedTransactions$2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String transactionalId = (String)x0$1._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                Object t = txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    TransactionState transactionState = txnMetadata.state();
                    Object object = PrepareAbort$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : (PrepareCommit$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : BoxedUnit.UNIT);
                    return object;
                });
                return t;
            });
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
            Function1 & Serializable & scala.Serializable foreach_f = (Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                sendTxnMarkers$1.apply((Object)txnTransitMetadata.transactionalId(), (Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                return BoxedUnit.UNIT;
            };
            transactionsPendingForCompletion.underlying().foreach((Function1)foreach_f);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadTransactions$1(TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, Function5 sendTxnMarkers$1) {
        void inWriteLock_lock;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition).append(" at epoch ").append(coordinatorEpoch).toString());
        this.validateTransactionTopicPartitionCountIsStable();
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$3(this, partitionAndLeaderEpoch$2, topicPartition$3, coordinatorEpoch$3, loadedTransactions, sendTxnMarkers$1);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition).append(" for coordinator epoch ").append(coordinatorEpoch).toString());
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$2(int partitionId$2, TransactionPartitionAndLeaderEpoch x$4) {
        return x$4.txnPartitionId() != partitionId$2;
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$1(TransactionStateManager $this, int partitionId$2, TopicPartition topicPartition$4) {
        $this.loadingPartitions().retain((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(partitionId$2, x$4)));
        Option option = $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$2));
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)foreach_this.get();
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").append("local partition deletion").toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$5(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$3, TopicPartition topicPartition$5) {
        $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$3);
        Option option = $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$3));
        if (option instanceof Some) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$5).append(" on become-follower transition").toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("No cached transaction metadata found for ").append(topicPartition$5).append(" during become-follower transition").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$5, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$5).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$5, Errors err$1) {
        return new StringBuilder(140).append("Accessing the cached transaction metadata for ").append(transactionalId$5).append(" returns ").append(err$1).append(" error; ").append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$4, String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$4) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(231).append("The cached coordinator epoch for ").append(transactionalId$5).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
            return;
        }
        metadata$1.completeTransitionTo(newMetadata$1);
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$5).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" for ").append(transactionalId$5).append(" succeeded").toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4) {
        return new StringBuilder(254).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$5).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$4) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(169).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString());
                return;
            }
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(159).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString());
            metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(187).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$4).toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(190).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(173).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1) {
        block16: {
            block14: {
                block18: {
                    block17: {
                        block15: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                var33_8 = "Append status %s should only have one partition %s";
                                if (Predef$.MODULE$ == null) {
                                    throw null;
                                }
                                throw new IllegalStateException(new StringOps(var33_8).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = status.error;
                            var14_10 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var14_10) == false : var14_10 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var15_11 = status.error;
                                var11_12 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var15_11) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var15_11) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var15_11) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var15_11) != false));
                                if (var11_12) {
                                    var8_13 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var10_14 = Errors.NOT_LEADER_FOR_PARTITION.equals(var15_11) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var15_11) != false;
                                    if (var10_14) {
                                        var8_13 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var9_15 = Errors.MESSAGE_TOO_LARGE.equals(var15_11) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var15_11) != false;
                                        var8_13 = var9_15 != false ? Errors.UNKNOWN_SERVER_ERROR : var15_11;
                                    }
                                }
                                v1 = var8_13;
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var16_17 = Errors.NONE;
                            if (v2 != null ? v2.equals(var16_17) == false : var16_17 != null) break block14;
                            var17_18 = false;
                            var18_19 = null;
                            var19_20 = this.getTransactionState(transactionalId$5);
                            if (!(var19_20 instanceof Left)) break block15;
                            err = (Errors)((Left)var19_20).value();
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)err));
                            responseError.elem = err;
                            break block16;
                        }
                        if (!(var19_20 instanceof Right)) break block17;
                        var17_18 = true;
                        var18_19 = (Right)var19_20;
                        var21_22 = (Option)var18_19.value();
                        if (!(var21_22 instanceof Some)) break block17;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var21_22).value();
                        metadata = epochAndMetadata.transactionMetadata();
                        (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block16;
                    }
                    if (!var17_18 || !None$.MODULE$.equals(var24_25 = (Option)var18_19.value())) break block18;
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    break block16;
                }
                throw new MatchError(var19_20);
            }
            var25_26 = false;
            var26_27 = null;
            var27_28 = this.getTransactionState(transactionalId$5);
            if (!(var27_28 instanceof Right)) ** GOTO lbl-1000
            var25_26 = true;
            var26_27 = (Right)var27_28;
            var28_29 = (Option)var26_27.value();
            if (var28_29 instanceof Some) {
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_29).value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var25_26 && None$.MODULE$.equals(var31_32 = (Option)var26_27.value())) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
            } else if (var27_28 instanceof Left) {
                error = (Errors)((Left)var27_28).value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
            } else {
                throw new MatchError(var27_28);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$appendTransactionToLog$15(TransactionStateManager $this, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1, Map responseStatus) {
        block16: {
            block14: {
                block18: {
                    block17: {
                        block15: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                var33_8 = "Append status %s should only have one partition %s";
                                if (Predef$.MODULE$ == null) {
                                    throw null;
                                }
                                throw new IllegalStateException(new StringOps(var33_8).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            updateCacheCallback$1_status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = updateCacheCallback$1_status.error;
                            var14_10 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var14_10) == false : var14_10 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)updateCacheCallback$1_status));
                                var15_11 = updateCacheCallback$1_status.error;
                                var11_12 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var15_11) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var15_11) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var15_11) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var15_11) != false));
                                if (var11_12) {
                                    var8_13 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var10_14 = Errors.NOT_LEADER_FOR_PARTITION.equals(var15_11) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var15_11) != false;
                                    if (var10_14) {
                                        var8_13 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var9_15 = Errors.MESSAGE_TOO_LARGE.equals(var15_11) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var15_11) != false;
                                        var8_13 = var9_15 != false ? Errors.UNKNOWN_SERVER_ERROR : var15_11;
                                    }
                                }
                                v1 = var8_13;
                            }
                            updateCacheCallback$1_responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)updateCacheCallback$1_responseError.elem;
                            var16_17 = Errors.NONE;
                            if (v2 != null ? v2.equals(var16_17) == false : var16_17 != null) break block14;
                            var17_18 = false;
                            var18_19 = null;
                            var19_20 = $this.getTransactionState(transactionalId$5);
                            if (!(var19_20 instanceof Left)) break block15;
                            updateCacheCallback$1_err = (Errors)((Left)var19_20).value();
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)updateCacheCallback$1_err));
                            updateCacheCallback$1_responseError.elem = updateCacheCallback$1_err;
                            break block16;
                        }
                        if (!(var19_20 instanceof Right)) break block17;
                        var17_18 = true;
                        var18_19 = (Right)var19_20;
                        var21_22 = (Option)var18_19.value();
                        if (!(var21_22 instanceof Some)) break block17;
                        updateCacheCallback$1_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var21_22).value();
                        updateCacheCallback$1_metadata = updateCacheCallback$1_epochAndMetadata.transactionMetadata();
                        (BoxedUnit)updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)updateCacheCallback$1_epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError, (TransactionMetadata)updateCacheCallback$1_metadata));
                        break block16;
                    }
                    if (!var17_18 || !None$.MODULE$.equals(var24_25 = (Option)var18_19.value())) break block18;
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)$this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    updateCacheCallback$1_responseError.elem = Errors.NOT_COORDINATOR;
                    break block16;
                }
                throw new MatchError(var19_20);
            }
            var25_26 = false;
            var26_27 = null;
            var27_28 = $this.getTransactionState(transactionalId$5);
            if (!(var27_28 instanceof Right)) ** GOTO lbl-1000
            var25_26 = true;
            var26_27 = (Right)var27_28;
            var28_29 = (Option)var26_27.value();
            if (var28_29 instanceof Some) {
                updateCacheCallback$1_epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_29).value();
                updateCacheCallback$1_metadata = updateCacheCallback$1_epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)updateCacheCallback$1_epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)updateCacheCallback$1_responseError, (TransactionMetadata)updateCacheCallback$1_metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var25_26 && None$.MODULE$.equals(var31_32 = (Option)var26_27.value())) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError));
            } else if (var27_28 instanceof Left) {
                updateCacheCallback$1_error = (Errors)((Left)var27_28).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError, (Errors)updateCacheCallback$1_error));
            } else {
                throw new MatchError(var27_28);
            }
        }
        responseCallback$1.apply((Object)((Errors)updateCacheCallback$1_responseError.elem));
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$13(TransactionStateManager $this, String transactionalId$5, Function1 responseCallback$1, int coordinatorEpoch$4, TxnTransitMetadata newMetadata$1, scala.collection.immutable.Map recordsPerPartition$1, TopicPartition topicPartition$6, Function1 retryOnError$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.getTransactionState(transactionalId$5);
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$1.apply((Object)err);
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (BoxesRunTime.unboxToBoolean(epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$4) {
                    responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                    return false;
                }
                return true;
            }))) {
                $this.replicaManager.appendRecords(newMetadata$1.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition$1, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)((Function1 & Serializable & scala.Serializable)arg_0 -> TransactionStateManager.$anonfun$appendTransactionToLog$15$adapted($this, topicPartition$6, transactionalId$5, newMetadata$1, coordinatorEpoch$4, retryOnError$1, responseCallback$1, arg_0)), (Option<Lock>)new Some((Object)$this.stateLock().readLock()), $this.replicaManager.appendRecords$default$8());
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata$1).append(" for transaction id ").append(transactionalId$5).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" to the local transaction log").toString());
                return;
            }
        } else {
            throw new MatchError(either);
        }
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$5) {
        return false;
    }

    public TransactionStateManager(int brokerId, KafkaZkClient zkClient, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time, Metrics metrics, ApiVersion interBrokerProtocolVersion) {
        this.zkClient = zkClient;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        this.partitionLoadSensor = metrics.sensor("PartitionLoadTime");
        this.partitionLoadSensor().add(metrics.metricName("partition-load-time-max", "transaction-coordinator-metrics", "The max time it took to load the partitions in the last 30sec"), (MeasurableStat)new Max());
        this.partitionLoadSensor().add(metrics.metricName("partition-load-time-avg", "transaction-coordinator-metrics", "The avg time it took to load the partitions in the last 30sec"), (MeasurableStat)new Avg());
    }

    public static final /* synthetic */ Object $anonfun$addLoadedTransactionsToCache$1$adapted(TransactionStateManager $this, int txnTopicPartition$1, int coordinatorEpoch$2, TxnMetadataCacheEntry previousTxnMetadataCacheEntry) {
        $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").append("loading metadata at epoch ").append(coordinatorEpoch$2).toString());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$writeTombstonesForExpiredTransactionalIds$3$adapted(TransactionStateManager $this, Iterable expiredForPartition$1, ProduceResponse.PartitionResponse response$1, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        expiredForPartition$1.foreach((Function1 & Serializable & scala.Serializable)idCoordinatorEpochAndMetadata -> {
            String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
            TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
            return txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                    Errors errors = response$1.error;
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                        return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                    }
                }
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(192).append("Failed to remove expired transactionalId: ").append(transactionalId).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").append(idCoordinatorEpochAndMetadata.coordinatorEpoch()).toString());
                txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                return BoxedUnit.UNIT;
            });
        });
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$removeTransactionsForTxnTopicPartition$3$adapted(TransactionStateManager $this, TopicPartition topicPartition$4, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").append("local partition deletion").toString());
        return BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$appendTransactionToLog$15$adapted(TransactionStateManager $this, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1, Map responseStatus) {
        block16: {
            block14: {
                block18: {
                    block17: {
                        block15: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                var33_8 = "Append status %s should only have one partition %s";
                                if (Predef$.MODULE$ == null) {
                                    throw null;
                                }
                                throw new IllegalStateException(new StringOps(var33_8).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status.error;
                            var14_10 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var14_10) == false : var14_10 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_status));
                                var15_11 = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status.error;
                                var11_12 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var15_11) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var15_11) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var15_11) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var15_11) != false));
                                if (var11_12) {
                                    var8_13 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var10_14 = Errors.NOT_LEADER_FOR_PARTITION.equals(var15_11) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var15_11) != false;
                                    if (var10_14) {
                                        var8_13 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var9_15 = Errors.MESSAGE_TOO_LARGE.equals(var15_11) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var15_11) != false;
                                        var8_13 = var9_15 != false ? Errors.UNKNOWN_SERVER_ERROR : var15_11;
                                    }
                                }
                                v1 = var8_13;
                            }
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem;
                            var16_17 = Errors.NONE;
                            if (v2 != null ? v2.equals(var16_17) == false : var16_17 != null) break block14;
                            var17_18 = false;
                            var18_19 = null;
                            var19_20 = $this.getTransactionState(transactionalId$5);
                            if (!(var19_20 instanceof Left)) break block15;
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_err = (Errors)((Left)var19_20).value();
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_err));
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_err;
                            break block16;
                        }
                        if (!(var19_20 instanceof Right)) break block17;
                        var17_18 = true;
                        var18_19 = (Right)var19_20;
                        var21_22 = (Option)var18_19.value();
                        if (!(var21_22 instanceof Some)) break block17;
                        $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var21_22).value();
                        $anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata.transactionMetadata();
                        (BoxedUnit)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (TransactionMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata));
                        break block16;
                    }
                    if (!var17_18 || !None$.MODULE$.equals(var24_25 = (Option)var18_19.value())) break block18;
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)$this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem = Errors.NOT_COORDINATOR;
                    break block16;
                }
                throw new MatchError(var19_20);
            }
            var25_26 = false;
            var26_27 = null;
            var27_28 = $this.getTransactionState(transactionalId$5);
            if (!(var27_28 instanceof Right)) ** GOTO lbl-1000
            var25_26 = true;
            var26_27 = (Right)var27_28;
            var28_29 = (Option)var26_27.value();
            if (var28_29 instanceof Some) {
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_29).value();
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (TransactionMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var25_26 && None$.MODULE$.equals(var31_32 = (Option)var26_27.value())) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError));
            } else if (var27_28 instanceof Left) {
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_error = (Errors)((Left)var27_28).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_error));
            } else {
                throw new MatchError(var27_28);
            }
        }
        responseCallback$1.apply((Object)((Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem));
        return BoxedUnit.UNIT;
    }
}

