/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.controller.ControllerContext;
import kafka.controller.QueueItem;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001\u0002\u000e\u001c\u0001\u0001B\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005S!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00033\u0011!9\u0004A!b\u0001\n\u0003A\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011\u001d\u0003!Q1A\u0005\u0002!C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t+\u0002\u0011)\u0019!C\u0001-\"AQ\f\u0001B\u0001B\u0003%q\u000b\u0003\u0005_\u0001\t\u0015\r\u0011\"\u0001`\u0011!1\u0007A!A!\u0002\u0013\u0001\u0007\u0002C4\u0001\u0005\u000b\u0007I\u0011\u00015\t\u00119\u0004!\u0011!Q\u0001\n%D\u0001b\u001c\u0001\u0003\u0006\u0004%\t\u0001\u001d\u0005\t{\u0002\u0011\t\u0011)A\u0005c\"Aa\u0010\u0001BC\u0002\u0013\u0005q\u0010\u0003\u0006\u0002\b\u0001\u0011\t\u0011)A\u0005\u0003\u0003AA\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0006\u0003CAq!a\t\u0001\t\u0003\t)\u0003\u0003\u0005\u0002>\u0001\u0011\r\u0011\"\u0003)\u0011\u001d\ty\u0004\u0001Q\u0001\n%Bq!!\u0011\u0001\t\u0003\n\u0019\u0005C\u0004\u0002L\u0001!I!!\u0014\t\u000f\u0005U\u0003\u0001\"\u0011\u0002N\t\t\"+Z9vKN$8+\u001a8e)\"\u0014X-\u00193\u000b\u0005qi\u0012AC2p]R\u0014x\u000e\u001c7fe*\ta$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u001e\u0003\u0015)H/\u001b7t\u0013\t13E\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017\u0001D2p]R\u0014x\u000e\u001c7fe&#W#A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\u0007%sG/A\u0007d_:$(o\u001c7mKJLE\rI\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#\u0001\u001a\u0011\u0005M\"T\"A\u000e\n\u0005UZ\"!E\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\u0006\u00112m\u001c8ue>dG.\u001a:D_:$X\r\u001f;!\u0003\u0015\tX/Z;f+\u0005I\u0004c\u0001\u001eB\u00076\t1H\u0003\u0002={\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005yz\u0014\u0001B;uS2T\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002Cw\ti!\t\\8dW&tw-U;fk\u0016\u0004\"a\r#\n\u0005\u0015[\"!C)vKV,\u0017\n^3n\u0003\u0019\tX/Z;fA\u0005ia.\u001a;x_J\\7\t\\5f]R,\u0012!\u0013\t\u0003\u0015Jk\u0011a\u0013\u0006\u0003\u00196\u000bqa\u00197jK:$8O\u0003\u0002\u001f\u001d*\u0011q\nU\u0001\u0007CB\f7\r[3\u000b\u0003E\u000b1a\u001c:h\u0013\t\u00196JA\u0007OKR<xN]6DY&,g\u000e^\u0001\u000f]\u0016$xo\u001c:l\u00072LWM\u001c;!\u0003)\u0011'o\\6fe:{G-Z\u000b\u0002/B\u0011\u0001lW\u0007\u00023*\u0011!,T\u0001\u0007G>lWn\u001c8\n\u0005qK&\u0001\u0002(pI\u0016\f1B\u0019:pW\u0016\u0014hj\u001c3fA\u000511m\u001c8gS\u001e,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003Gv\taa]3sm\u0016\u0014\u0018BA3c\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005!A/[7f+\u0005I\u0007C\u00016m\u001b\u0005Y'B\u0001\u0013Z\u0013\ti7N\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013A\b:fcV,7\u000f\u001e*bi\u0016\fe\u000eZ)vKV,G+[7f\u001b\u0016$(/[2t+\u0005\t\bC\u0001:|\u001b\u0005\u0019(B\u0001;v\u0003\u0011\u0019wN]3\u000b\u0005Y<\u0018aB7fiJL7m\u001d\u0006\u0003qf\fa!_1n[\u0016\u0014(\"\u0001>\u0002\u0007\r|W.\u0003\u0002}g\n)A+[7fe\u0006y\"/Z9vKN$(+\u0019;f\u0003:$\u0017+^3vKRKW.Z'fiJL7m\u001d\u0011\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0006\u0002\u0002\u0002A\u00191'a\u0001\n\u0007\u0005\u00151DA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\f!c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3sA\u0005!a.Y7f!\u0011\ti!a\u0007\u000f\t\u0005=\u0011q\u0003\t\u0004\u0003#YSBAA\n\u0015\r\t)bH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005e1&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003;\tyB\u0001\u0004TiJLgn\u001a\u0006\u0004\u00033Y\u0013bAA\u0005K\u00051A(\u001b8jiz\"b#a\n\u0002*\u0005-\u0012QFA\u0018\u0003c\t\u0019$!\u000e\u00028\u0005e\u00121\b\t\u0003g\u0001AQa\n\u000bA\u0002%BQ\u0001\r\u000bA\u0002IBQa\u000e\u000bA\u0002eBQa\u0012\u000bA\u0002%CQ!\u0016\u000bA\u0002]CQA\u0018\u000bA\u0002\u0001DQa\u001a\u000bA\u0002%DQa\u001c\u000bA\u0002EDaA \u000bA\u0002\u0005\u0005\u0001bBA\u0005)\u0001\u0007\u00111B\u0001\u0010g>\u001c7.\u001a;US6,w.\u001e;Ng\u0006\u00012o\\2lKR$\u0016.\\3pkRl5\u000fI\u0001\u0007I><vN]6\u0015\u0005\u0005\u0015\u0003c\u0001\u0016\u0002H%\u0019\u0011\u0011J\u0016\u0003\tUs\u0017\u000e^\u0001\fEJ|7.\u001a:SK\u0006$\u0017\u0010\u0006\u0002\u0002PA\u0019!&!\u0015\n\u0007\u0005M3FA\u0004C_>dW-\u00198\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^t\u0007")
public class RequestSendThread
extends ShutdownableThread {
    private final int controllerId;
    private final ControllerContext controllerContext;
    private final BlockingQueue<QueueItem> queue;
    private final NetworkClient networkClient;
    private final Node brokerNode;
    private final KafkaConfig config;
    private final Time time;
    private final Timer requestRateAndQueueTimeMetrics;
    private final StateChangeLogger stateChangeLogger;
    private final int socketTimeoutMs;

    public int controllerId() {
        return this.controllerId;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public BlockingQueue<QueueItem> queue() {
        return this.queue;
    }

    public NetworkClient networkClient() {
        return this.networkClient;
    }

    public Node brokerNode() {
        return this.brokerNode;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Time time() {
        return this.time;
    }

    public Timer requestRateAndQueueTimeMetrics() {
        return this.requestRateAndQueueTimeMetrics;
    }

    public StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private int socketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doWork() {
        QueueItem queueItem = this.queue().take();
        if (queueItem == null) {
            throw new MatchError(null);
        }
        ApiKeys apiKey = queueItem.apiKey();
        AbstractControlRequest.Builder<? extends AbstractControlRequest> requestBuilder = queueItem.request();
        Function1<AbstractResponse, BoxedUnit> callback = queueItem.callback();
        long l = queueItem.enqueueTimeMs();
        this.requestRateAndQueueTimeMetrics().update(this.time().milliseconds() - l, TimeUnit.MILLISECONDS);
        ClientResponse clientResponse = null;
        try {
            boolean isSendSuccessful = false;
            while (this.isRunning() && !isSendSuccessful) {
                void var3_3;
                try {
                    if (!this.brokerReady()) {
                        isSendSuccessful = false;
                        this.backoff$1();
                        continue;
                    }
                    ClientRequest clientRequest = this.networkClient().newClientRequest(this.brokerNode().idString(), (AbstractRequest.Builder)var3_3, this.time().milliseconds(), true);
                    clientResponse = NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time());
                    isSendSuccessful = true;
                }
                catch (Throwable e) {
                    this.warn((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> RequestSendThread.$anonfun$doWork$1(this, (AbstractControlRequest.Builder)var3_3)), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    this.networkClient().close(this.brokerNode().idString());
                    isSendSuccessful = false;
                    this.backoff$1();
                }
            }
            if (clientResponse != null) {
                void var4_4;
                ApiKeys api;
                RequestHeader requestHeader = clientResponse.requestHeader();
                ApiKeys apiKeys = api = requestHeader.apiKey();
                ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
                if (apiKeys == null ? apiKeys2 != null : !apiKeys.equals(apiKeys2)) {
                    ApiKeys apiKeys3 = api;
                    ApiKeys apiKeys4 = ApiKeys.CONFLUENT_LEADER_AND_ISR;
                    if (apiKeys3 == null ? apiKeys4 != null : !apiKeys3.equals(apiKeys4)) {
                        ApiKeys apiKeys5 = api;
                        ApiKeys apiKeys6 = ApiKeys.STOP_REPLICA;
                        if (apiKeys5 == null ? apiKeys6 != null : !apiKeys5.equals(apiKeys6)) {
                            ApiKeys apiKeys7 = api;
                            ApiKeys apiKeys8 = ApiKeys.UPDATE_METADATA;
                            if (apiKeys7 == null ? apiKeys8 != null : !apiKeys7.equals(apiKeys8)) {
                                void var2_2;
                                throw new KafkaException(new StringBuilder(28).append("Unexpected apiKey received: ").append(var2_2).toString());
                            }
                        }
                    }
                }
                AbstractResponse response = clientResponse.responseBody();
                this.stateChangeLogger().withControllerEpoch(this.controllerContext().epoch()).trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Received response ").append(response.toString(requestHeader.apiVersion())).append(" for request ").append(api).append(" with correlation id ").append(requestHeader.correlationId()).append(" sent to broker ").append(this.brokerNode()).toString());
                if (var4_4 != null) {
                    var4_4.apply((Object)response);
                }
            }
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Controller ").append(this.controllerId()).append(" fails to send a request to broker ").append(this.brokerNode()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.networkClient().close(this.brokerNode().idString());
        }
    }

    private boolean brokerReady() {
        try {
            if (!NetworkClientUtils.isReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (long)this.time().milliseconds())) {
                if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (Time)this.time(), (long)this.socketTimeoutMs())) {
                    throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeoutMs()).append(" ms").toString());
                }
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Controller ").append(this.controllerId()).append(" connected to ").append(this.brokerNode()).append(" for sending state change requests").toString());
            }
            return true;
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Controller ").append(this.controllerId()).append("'s connection to broker ").append(this.brokerNode()).append(" was unsuccessful").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.networkClient().close(this.brokerNode().idString());
            return false;
        }
    }

    @Override
    public boolean initiateShutdown() {
        if (super.initiateShutdown()) {
            this.networkClient().initiateClose();
            return true;
        }
        return false;
    }

    private final void backoff$1() {
        this.pause(100L, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ String $anonfun$doWork$1(RequestSendThread $this, AbstractControlRequest.Builder requestBuilder$1) {
        return new StringBuilder(77).append("Controller ").append($this.controllerId()).append(" epoch ").append($this.controllerContext().epoch()).append(" fails to send request ").append(requestBuilder$1).append(" ").append("to broker ").append($this.brokerNode()).append(". Reconnecting to broker.").toString();
    }

    public RequestSendThread(int controllerId, ControllerContext controllerContext, BlockingQueue<QueueItem> queue, NetworkClient networkClient, Node brokerNode, KafkaConfig config, Time time, Timer requestRateAndQueueTimeMetrics, StateChangeLogger stateChangeLogger, String name) {
        this.controllerId = controllerId;
        this.controllerContext = controllerContext;
        this.queue = queue;
        this.networkClient = networkClient;
        this.brokerNode = brokerNode;
        this.config = config;
        this.time = time;
        this.requestRateAndQueueTimeMetrics = requestRateAndQueueTimeMetrics;
        this.stateChangeLogger = stateChangeLogger;
        super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        this.logIdent_$eq(new StringBuilder(34).append("[RequestSendThread controllerId=").append(controllerId).append("] ").toString());
        this.socketTimeoutMs = config.controllerSocketTimeoutMs();
    }
}

