/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import kafka.admin.ReplicaStatusCommand;
import kafka.admin.ReplicaStatusCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.WrappedArray;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class ReplicaStatusCommand$
implements Logging {
    public static ReplicaStatusCommand$ MODULE$;
    private final List<String> allColumns;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReplicaStatusCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private List<String> allColumns() {
        return this.allColumns;
    }

    public void main(String[] args) {
        this.run(args, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).second());
    }

    public void run(String[] args, Duration timeout) {
        ReplicaStatusCommandOptions commandOptions = new ReplicaStatusCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(commandOptions, "This tool prints out the replica status of partitions.");
        ReplicaStatusCommand.Args initializedArgs = this.validateAndInitializeArgs(commandOptions);
        try (ConfluentAdmin adminClient = this.createAdminClient(commandOptions, timeout);){
            this.replicaStatus(initializedArgs, adminClient);
        }
    }

    private ConfluentAdmin createAdminClient(ReplicaStatusCommandOptions commandOptions, Duration timeout) {
        Properties props = commandOptions.options().has(commandOptions.adminClientConfigOpt()) ? Utils.loadProps((String)((String)commandOptions.options().valueOf(commandOptions.adminClientConfigOpt()))) : new Properties();
        props.setProperty("bootstrap.servers", (String)commandOptions.options().valueOf(commandOptions.bootstrapServer()));
        props.setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)timeout.toMillis())).toString());
        return (KafkaAdminClient)AdminClient.create((Properties)props);
    }

    private void replicaStatus(ReplicaStatusCommand.Args args, ConfluentAdmin client) {
        try {
            this.doReplicaStatus(args, client);
            return;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)throwable;
                String message = "Timeout waiting for results";
                Predef$.MODULE$.println((Object)message);
                throw new AdminCommandFailedException(message, timeoutException);
            }
            if (throwable instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                String message = "Not authorized";
                Predef$.MODULE$.println((Object)message);
                throw new AdminCommandFailedException(message, (Throwable)clusterAuthorizationException);
            }
            throw e;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)"Error while issuing request");
            throw e;
        }
    }

    private void doReplicaStatus(ReplicaStatusCommand.Args args, ConfluentAdmin client) {
        Iterable topicPartitions;
        Iterable iterable;
        Seq topics;
        Seq seq;
        if (args.topics() != null) {
            seq = (Seq)args.topics().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStatusCommand$.$anonfun$doReplicaStatus$1(args, x$1)));
        } else {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(ReplicaStatusCommand$.$anonfun$doReplicaStatus$2()));
            }
            seq = topics = ((SetLike)JavaConverters$.MODULE$.asScalaSetConverter((java.util.Set)client.listTopics(new ListTopicsOptions().listInternal(!args.excludeInternalTopics())).names().get()).asScala()).toSeq();
        }
        if (args.partitions() != null) {
            iterable = (Iterable)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> (Seq)args.partitions().map((Function1 & Serializable & scala.Serializable)x$2 -> ReplicaStatusCommand$.$anonfun$doReplicaStatus$4(topic, BoxesRunTime.unboxToInt((Object)x$2)), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        } else {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(ReplicaStatusCommand$.$anonfun$doReplicaStatus$5(topics)));
            }
            iterable = topicPartitions = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Map)client.describeTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)topics).asJavaCollection()).all().get()).values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)td -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(td.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)pi -> new TopicPartition(td.name(), pi.partition()), Buffer$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(ReplicaStatusCommand$.$anonfun$doReplicaStatus$8(topicPartitions)));
        }
        ReplicaStatusResult result = client.replicaStatus((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)topicPartitions.toSet()).asJava(), new ReplicaStatusOptions());
        ListBuffer entries = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        List list = (List)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(result.result()).asScala()).toList().sortBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition key = (TopicPartition)x0$1._1();
            Tuple2 tuple2 = new Tuple2((Object)key.topic(), (Object)BoxesRunTime.boxToInteger((int)key.partition()));
            return tuple2;
        }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        if (list == null) {
            throw null;
        }
        List foreach_these = list;
        while (!foreach_these.isEmpty()) {
            Tuple2 tuple2 = (Tuple2)foreach_these.head();
            ReplicaStatusCommand$.$anonfun$doReplicaStatus$10(args, entries, tuple2);
            foreach_these = (List)foreach_these.tail();
        }
        if (args.jsonOutput()) {
            this.printJson((List<List<String>>)entries.toList());
            return;
        }
        if (args.verboseOutput()) {
            this.printVerbose((List<List<String>>)entries.toList());
            return;
        }
        this.printCompact(args, (List<List<String>>)entries.toList());
    }

    private List<String> toEntries(ReplicaStatusCommand.Args args, TopicPartition partition, ReplicaStatus status, long leaderTimeMs) {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{partition.topic(), ((Object)BoxesRunTime.boxToInteger((int)partition.partition())).toString(), ((Object)BoxesRunTime.boxToInteger((int)status.brokerId())).toString(), ((Object)BoxesRunTime.boxToBoolean((boolean)status.isLeader())).toString(), ((Object)BoxesRunTime.boxToBoolean((boolean)status.isObserver())).toString(), ((Object)BoxesRunTime.boxToBoolean((boolean)status.isIsrEligible())).toString(), ((Object)BoxesRunTime.boxToBoolean((boolean)status.isInIsr())).toString(), ((Object)BoxesRunTime.boxToBoolean((boolean)status.isCaughtUp())).toString(), ReplicaStatusCommand$.toLagMsStr$1(status.lastCaughtUpTimeMs(), leaderTimeMs), ReplicaStatusCommand$.toLagMsStr$1(status.lastFetchTimeMs(), leaderTimeMs), ReplicaStatusCommand$.toLogOffsetStr$1(status.logStartOffset()), ReplicaStatusCommand$.toLogOffsetStr$1(status.logEndOffset())}));
    }

    private void printJson(List<List<String>> entries) {
        if (entries.isEmpty()) {
            Predef$.MODULE$.println((Object)"[]");
            return;
        }
        ObjectRef lastTopic = ObjectRef.create((Object)"");
        ObjectRef lastPartition = ObjectRef.create((Object)"");
        Predef$.MODULE$.println((Object)"[");
        List list = (List)entries.zipWithIndex(List$.MODULE$.canBuildFrom());
        if (list == null) {
            throw null;
        }
        List foreach_these = list;
        while (!foreach_these.isEmpty()) {
            Tuple2 tuple2 = (Tuple2)foreach_these.head();
            ReplicaStatusCommand$.$anonfun$printJson$1(lastTopic, lastPartition, tuple2);
            foreach_these = (List)foreach_these.tail();
        }
        ReplicaStatusCommand$.closePartition$1();
        ReplicaStatusCommand$.closeTopic$1();
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"]");
    }

    private void printVerbose(List<List<String>> entries) {
        List list = (List)entries.zipWithIndex(List$.MODULE$.canBuildFrom());
        if (list == null) {
            throw null;
        }
        List foreach_these = list;
        while (!foreach_these.isEmpty()) {
            Tuple2 tuple2 = (Tuple2)foreach_these.head();
            ReplicaStatusCommand$.$anonfun$printVerbose$1(entries, tuple2);
            foreach_these = (List)foreach_these.tail();
        }
    }

    private void printCompact(ReplicaStatusCommand.Args args, List<List<String>> entries) {
        ArrayBuffer maxWidth = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        List list = (List)this.allColumns().zipWithIndex(List$.MODULE$.canBuildFrom());
        if (list == null) {
            throw null;
        }
        List foreach_these = list;
        while (!foreach_these.isEmpty()) {
            Tuple2 tuple2 = (Tuple2)foreach_these.head();
            ReplicaStatusCommand$.$anonfun$printCompact$1(maxWidth, tuple2);
            foreach_these = (List)foreach_these.tail();
        }
        if (entries == null) {
            throw null;
        }
        List foreach_these2 = entries;
        while (!foreach_these2.isEmpty()) {
            List list2 = (List)foreach_these2.head();
            ReplicaStatusCommand$.$anonfun$printCompact$2(maxWidth, list2);
            foreach_these2 = (List)foreach_these2.tail();
        }
        ReplicaStatusCommand$.printEntries$1(this.allColumns(), maxWidth);
        List foreach_these3 = entries;
        while (!foreach_these3.isEmpty()) {
            List list3 = (List)foreach_these3.head();
            ReplicaStatusCommand$.printEntries$1(list3, maxWidth);
            foreach_these3 = (List)foreach_these3.tail();
        }
    }

    private ReplicaStatusCommand.Args validateAndInitializeArgs(ReplicaStatusCommandOptions commandOptions) {
        List missingOptions = List$.MODULE$.empty();
        if (!commandOptions.options().has(commandOptions.bootstrapServer())) {
            String string = (String)commandOptions.bootstrapServer().options().get(0);
            missingOptions = missingOptions.$colon$colon((Object)string);
        }
        if (missingOptions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(28).append("Missing required option(s): ").append(missingOptions.mkString(", ")).toString());
        }
        WrappedArray topicsArg = null;
        if (commandOptions.options().has(commandOptions.topicsOpt())) {
            topicsArg = Predef$.MODULE$.wrapRefArray((Object[])((String)commandOptions.options().valueOf(commandOptions.topicsOpt())).split(","));
            topicsArg.foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                ReplicaStatusCommand$.$anonfun$validateAndInitializeArgs$1(x$11);
                return BoxedUnit.UNIT;
            });
        }
        ListBuffer partitionsArg = null;
        if (commandOptions.options().has(commandOptions.partitionsOpt())) {
            ListBuffer tmpPartitions = new ListBuffer();
            ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)commandOptions.options().valueOf(commandOptions.partitionsOpt())).split(",")));
            int foreach_len = foreach_this.length();
            for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
                String string = (String)foreach_this.apply(foreach_i);
                ReplicaStatusCommand$.$anonfun$validateAndInitializeArgs$2(tmpPartitions, string);
            }
            partitionsArg = tmpPartitions;
        }
        boolean verboseOutputArg = commandOptions.options().has((OptionSpec)commandOptions.verboseOutputOpt());
        boolean jsonOutputArg = commandOptions.options().has((OptionSpec)commandOptions.jsonOutputOpt());
        boolean excludeInternalTopicsArg = commandOptions.options().has((OptionSpec)commandOptions.excludeInternalTopicsOpt());
        Option leadersArg = ReplicaStatusCommand$.parseBoolOpt$1(commandOptions.leadersOpt(), commandOptions);
        Option observersArg = ReplicaStatusCommand$.parseBoolOpt$1(commandOptions.observersOpt(), commandOptions);
        return new ReplicaStatusCommand.Args((Seq<String>)topicsArg, (Seq<Object>)partitionsArg, (Option<Object>)leadersArg, (Option<Object>)observersArg, verboseOutputArg, jsonOutputArg, excludeInternalTopicsArg);
    }

    public static final /* synthetic */ boolean $anonfun$doReplicaStatus$1(ReplicaStatusCommand.Args args$1, String x$1) {
        return Topic.isInternal((String)x$1) && args$1.excludeInternalTopics();
    }

    public static final /* synthetic */ String $anonfun$doReplicaStatus$2() {
        return "Calling AdminClient.listTopics()";
    }

    public static final /* synthetic */ TopicPartition $anonfun$doReplicaStatus$4(String topic$1, int x$2) {
        return new TopicPartition(topic$1, x$2);
    }

    public static final /* synthetic */ String $anonfun$doReplicaStatus$5(Seq topics$1) {
        return new StringBuilder(35).append("Calling AdminClient.describeTopics(").append(topics$1).toString();
    }

    public static final /* synthetic */ String $anonfun$doReplicaStatus$8(Iterable topicPartitions$1) {
        return new StringBuilder(35).append("Calling AdminClient.replicaStatus(").append(topicPartitions$1).append(")").toString();
    }

    public static final /* synthetic */ long $anonfun$doReplicaStatus$14() {
        return 0L;
    }

    public static final /* synthetic */ boolean $anonfun$doReplicaStatus$16(ReplicaStatus st$1, boolean x$6) {
        return x$6 != st$1.isLeader();
    }

    public static final /* synthetic */ boolean $anonfun$doReplicaStatus$17(ReplicaStatus st$1, boolean x$7) {
        return x$7 != st$1.isObserver();
    }

    public static final /* synthetic */ boolean $anonfun$doReplicaStatus$15(ReplicaStatusCommand.Args args$1, ReplicaStatus st) {
        block6: {
            block5: {
                Object object;
                Object object2;
                Option<Object> option = args$1.leaders();
                if (option == null) {
                    throw null;
                }
                Option<Object> exists_this = option;
                boolean bl = !exists_this.isEmpty() && ReplicaStatusCommand$.$anonfun$doReplicaStatus$16(st, BoxesRunTime.unboxToBoolean((Object)(object2 = exists_this.get())));
                if (bl) break block5;
                Option<Object> option2 = args$1.observers();
                if (option2 == null) {
                    throw null;
                }
                Option<Object> exists_this2 = option2;
                boolean bl2 = !exists_this2.isEmpty() && ReplicaStatusCommand$.$anonfun$doReplicaStatus$17(st, BoxesRunTime.unboxToBoolean((Object)(object = exists_this2.get())));
                if (!bl2) break block6;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ Buffer $anonfun$doReplicaStatus$10(ReplicaStatusCommand.Args args$1, ListBuffer entries$1, Tuple2 x0$2) {
        Option option;
        Buffer status;
        TopicPartition partition;
        if (x0$2 != null) {
            partition = (TopicPartition)x0$2._1();
            KafkaFuture replicas = (KafkaFuture)x0$2._2();
            status = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)replicas.get()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.brokerId()), (Ordering)Ordering.Int$.MODULE$);
            option = ((TraversableLike)((TraversableLike)status.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isLeader()))).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.lastCaughtUpTimeMs()), Buffer$.MODULE$.canBuildFrom())).headOption();
            if (option == null) {
                throw null;
            }
        } else {
            throw new MatchError(null);
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToLong((long)ReplicaStatusCommand$.$anonfun$doReplicaStatus$14()) : getOrElse_this.get();
        long leaderTimeMs = BoxesRunTime.unboxToLong((Object)object);
        Buffer buffer = (Buffer)((TraversableLike)status.filterNot((Function1 & Serializable & scala.Serializable)st -> BoxesRunTime.boxToBoolean((boolean)ReplicaStatusCommand$.$anonfun$doReplicaStatus$15(args$1, st)))).map((Function1 & Serializable & scala.Serializable)x$8 -> entries$1.$plus$eq(MODULE$.toEntries(args$1, partition, (ReplicaStatus)x$8, leaderTimeMs)), Buffer$.MODULE$.canBuildFrom());
        return buffer;
    }

    private static final String toLagMsStr$1(long timeMs, long leaderTimeMs$2) {
        if (timeMs > 0L) {
            return ((Object)BoxesRunTime.boxToLong((long)(leaderTimeMs$2 - timeMs))).toString();
        }
        return "-1";
    }

    private static final String toLogOffsetStr$1(long logOffset) {
        if (logOffset >= 0L) {
            return ((Object)BoxesRunTime.boxToLong((long)logOffset)).toString();
        }
        return "-1";
    }

    private static final String addQuotes$1(String string) {
        return new StringBuilder(2).append("\"").append(string).append("\"").toString();
    }

    private static final void closeTopic$1() {
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    ]");
        Predef$.MODULE$.print((Object)"  }");
    }

    private static final void closePartition$1() {
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"        ]");
        Predef$.MODULE$.print((Object)"      }");
    }

    public static final /* synthetic */ void $anonfun$printJson$2(List entry$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String subEntry = (String)x0$2._1();
            int subIndex = x0$2._2$mcI$sp();
            if (subIndex >= 2) {
                Predef$.MODULE$.print((Object)new StringBuilder(14).append("            ").append(ReplicaStatusCommand$.addQuotes$1((String)MODULE$.allColumns().apply(subIndex))).append(": ").append(subEntry).toString());
                if (subIndex < entry$1.size() - 1) {
                    Predef$.MODULE$.println((Object)",");
                    return;
                }
                Predef$.MODULE$.println();
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$printJson$1(ObjectRef lastTopic$1, ObjectRef lastPartition$1, Tuple2 x0$1) {
        block12: {
            if (x0$1 == null) break block12;
            entry = (List)x0$1._1();
            index = x0$1._2$mcI$sp();
            v0 = (String)lastTopic$1.elem;
            var6_5 = entry.apply(0);
            v1 = (v0 == null ? var6_5 != null : v0.equals(var6_5) == false) ? true : (newTopic = false);
            if (newTopic) ** GOTO lbl-1000
            v2 = (String)lastPartition$1.elem;
            var8_7 = entry.apply(1);
            if (v2 == null ? var8_7 != null : v2.equals(var8_7) == false) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = newPartition = false;
            }
            if (index > 0) {
                if (newPartition) {
                    ReplicaStatusCommand$.closePartition$1();
                }
                if (newTopic) {
                    ReplicaStatusCommand$.closeTopic$1();
                }
            }
            if (newTopic) {
                if (index > 0) {
                    Predef$.MODULE$.println((Object)",");
                }
                Predef$.MODULE$.println((Object)"  {");
                Predef$.MODULE$.println((Object)new StringBuilder(14).append("    \"Topic\": ").append(ReplicaStatusCommand$.addQuotes$1((String)entry.apply(0))).append(",").toString());
                Predef$.MODULE$.println((Object)"    \"Partitions\": [");
            }
            if (newPartition) {
                if (!newTopic) {
                    Predef$.MODULE$.println((Object)",");
                }
                Predef$.MODULE$.println((Object)"      {");
                Predef$.MODULE$.println((Object)new StringBuilder(22).append("        \"Partition\": ").append(entry.apply(1)).append(",").toString());
                Predef$.MODULE$.println((Object)"        \"Replicas\": [");
            }
            lastTopic$1.elem = (String)entry.apply(0);
            lastPartition$1.elem = (String)entry.apply(1);
            if (!newPartition) {
                Predef$.MODULE$.println((Object)",");
            }
            Predef$.MODULE$.println((Object)"          {");
            v4 = (List)entry.zipWithIndex(List$.MODULE$.canBuildFrom());
            if (v4 == null) {
                throw null;
            }
            foreach_these = v4;
            while (!foreach_these.isEmpty()) {
                var10_10 = (Tuple2)foreach_these.head();
                ReplicaStatusCommand$.$anonfun$printJson$2(entry, var10_10);
                foreach_these = (List)foreach_these.tail();
            }
            Predef$.MODULE$.print((Object)"          }");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$printVerbose$1(List entries$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            List entry = (List)x0$1._1();
            int index = x0$1._2$mcI$sp();
            List list = (List)MODULE$.allColumns().zip((GenIterable)entry, List$.MODULE$.canBuildFrom());
            if (list == null) {
                throw null;
            }
            List foreach_these = list;
            while (!foreach_these.isEmpty()) {
                Predef$.MODULE$.println((Object)new StringBuilder(2).append(((Tuple2)foreach_these.head())._1()).append(": ").append(((Tuple2)foreach_these.head())._2()).toString());
                foreach_these = (List)foreach_these.tail();
            }
            if (index < entries$2.size() - 1) {
                Predef$.MODULE$.println();
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$printCompact$1(ArrayBuffer maxWidth$1, Tuple2 x0$1) {
        String name;
        if (x0$1 != null) {
            name = (String)x0$1._1();
            if (Predef$.MODULE$ == null) {
                throw null;
            }
        } else {
            throw new MatchError(null);
        }
        ArrayBuffer arrayBuffer = maxWidth$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)new StringOps(name).size()));
        return arrayBuffer;
    }

    public static final /* synthetic */ void $anonfun$printCompact$3(ArrayBuffer maxWidth$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String subEntry = (String)x0$2._1();
            int index = x0$2._2$mcI$sp();
            int n = BoxesRunTime.unboxToInt((Object)maxWidth$1.apply(index));
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            maxWidth$1.update(index, (Object)BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.max$extension(n, new StringOps(subEntry).size())));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$printCompact$2(ArrayBuffer maxWidth$1, List entry) {
        List list = (List)entry.zipWithIndex(List$.MODULE$.canBuildFrom());
        if (list == null) {
            throw null;
        }
        List foreach_these = list;
        while (!foreach_these.isEmpty()) {
            Tuple2 tuple2 = (Tuple2)foreach_these.head();
            ReplicaStatusCommand$.$anonfun$printCompact$3(maxWidth$1, tuple2);
            foreach_these = (List)foreach_these.tail();
        }
    }

    private static final void printEntry$1(String string, int index, ArrayBuffer maxWidth$1) {
        Predef$.MODULE$.print((Object)string);
        String string2 = " ";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.print((Object)new StringOps(string2).$times(BoxesRunTime.unboxToInt((Object)maxWidth$1.apply(index)) - new StringOps(string).size() + 1));
    }

    private static final void printEntries$1(List entries, ArrayBuffer maxWidth$1) {
        List list = (List)entries.zipWithIndex(List$.MODULE$.canBuildFrom());
        if (list == null) {
            throw null;
        }
        List foreach_these = list;
        while (!foreach_these.isEmpty()) {
            Tuple2 tuple2 = (Tuple2)foreach_these.head();
            ReplicaStatusCommand$.printEntry$1((String)tuple2._1(), tuple2._2$mcI$sp(), maxWidth$1);
            foreach_these = (List)foreach_these.tail();
        }
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$validateAndInitializeArgs$1(String x$11) {
        Topic.validate((String)x$11);
    }

    public static final /* synthetic */ Object $anonfun$validateAndInitializeArgs$2(ListBuffer tmpPartitions$1, String partitionStr) {
        ListBuffer listBuffer;
        String[] divPartitions = partitionStr.split("-");
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])divPartitions)).isEmpty() || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])divPartitions)).size() > 2) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Invalid partition range: ").append(partitionStr).toString());
        }
        try {
            String string = divPartitions[0];
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            int first = new StringOps(string).toInt();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])divPartitions)).size() != 1) {
                String string2 = divPartitions[1];
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                int second = new StringOps(string2).toInt();
                if (first > second) {
                    throw new IllegalArgumentException(new StringBuilder(25).append("Invalid partition range: ").append(partitionStr).toString());
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Range range = RichInt$.MODULE$.until$extension0(first, second + 1);
                if (range == null) {
                    throw null;
                }
                Range foreach_this = range;
                if (!foreach_this.isEmpty()) {
                    int foreach_i = foreach_this.start();
                    while (true) {
                        tmpPartitions$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)foreach_i));
                        if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                        foreach_i += foreach_this.step();
                    }
                }
                return BoxedUnit.UNIT;
            }
            listBuffer = tmpPartitions$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)first));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Failed to parse partition: ").append(partitionStr).toString());
        }
        return listBuffer;
    }

    private static final Option parseBoolOpt$1(ArgumentAcceptingOptionSpec spec, ReplicaStatusCommandOptions commandOptions$1) {
        Some some;
        if (!commandOptions$1.options().has((OptionSpec)spec)) {
            return None$.MODULE$;
        }
        if (commandOptions$1.options().valueOf((OptionSpec)spec) == null) {
            return new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        String string = ((String)commandOptions$1.options().valueOf((OptionSpec)spec)).toLowerCase();
        if ("only".equals(string)) {
            some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if ("exclude".equals(string)) {
            some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            throw new IllegalArgumentException(new StringBuilder(18).append("Unexpected value: ").append(string).toString());
        }
        return some;
    }

    private ReplicaStatusCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.allColumns = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic", "Partition", "Replica", "IsLeader", "IsObserver", "IsIsrEligible", "IsInIsr", "IsCaughtUp", "LastCaughtUpLagMs", "LastFetchLagMs", "LogStartOffset", "LogEndOffset"}));
    }

    public static final /* synthetic */ Object $anonfun$printJson$1$adapted(ObjectRef lastTopic$1, ObjectRef lastPartition$1, Tuple2 x0$1) {
        ReplicaStatusCommand$.$anonfun$printJson$1(lastTopic$1, lastPartition$1, x0$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$printVerbose$1$adapted(List entries$2, Tuple2 x0$1) {
        ReplicaStatusCommand$.$anonfun$printVerbose$1(entries$2, x0$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$printCompact$2$adapted(ArrayBuffer maxWidth$1, List entry) {
        ReplicaStatusCommand$.$anonfun$printCompact$2(maxWidth$1, entry);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$printCompact$5$adapted(ArrayBuffer maxWidth$1, List x$9) {
        ReplicaStatusCommand$.printEntries$1(x$9, maxWidth$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$doReplicaStatus$16$adapted(ReplicaStatus st$1, Object x$6) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaStatusCommand$.$anonfun$doReplicaStatus$16(st$1, BoxesRunTime.unboxToBoolean((Object)x$6)));
    }

    public static final /* synthetic */ Object $anonfun$doReplicaStatus$17$adapted(ReplicaStatus st$1, Object x$7) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaStatusCommand$.$anonfun$doReplicaStatus$17(st$1, BoxesRunTime.unboxToBoolean((Object)x$7)));
    }

    public static final /* synthetic */ Object $anonfun$printJson$2$adapted(List entry$1, Tuple2 x0$2) {
        ReplicaStatusCommand$.$anonfun$printJson$2(entry$1, x0$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$printVerbose$2$adapted(Tuple2 subEntry) {
        Predef$.MODULE$.println((Object)new StringBuilder(2).append(subEntry._1()).append(": ").append(subEntry._2()).toString());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$printCompact$3$adapted(ArrayBuffer maxWidth$1, Tuple2 x0$2) {
        ReplicaStatusCommand$.$anonfun$printCompact$3(maxWidth$1, x0$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$printCompact$4$adapted(ArrayBuffer maxWidth$1, Tuple2 e) {
        ReplicaStatusCommand$.printEntry$1((String)e._1(), e._2$mcI$sp(), maxWidth$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ ListBuffer $anonfun$validateAndInitializeArgs$3$adapted(ListBuffer tmpPartitions$1, Object i) {
        return tmpPartitions$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)));
    }
}

