/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.controller.KafkaController;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigHandler;
import kafka.server.Constants$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.Logging;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0006\r\u0001EA\u0001B\t\u0001\u0003\u0006\u0004%Ia\t\u0005\tU\u0001\u0011\t\u0011)A\u0005I!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00050\u0001\t\u0015\r\u0011\"\u00011\u0011!y\u0004A!A!\u0002\u0013\t\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u000b\u001d\u0003A\u0011\u0001%\t\u000b9\u0003A\u0011A(\t\u000b\u001d\u0004A\u0011\u00015\t\u000bi\u0004A\u0011A>\u0003%Q{\u0007/[2D_:4\u0017n\u001a%b]\u0012dWM\u001d\u0006\u0003\u001b9\taa]3sm\u0016\u0014(\"A\b\u0002\u000b-\fgm[1\u0004\u0001M!\u0001A\u0005\r\u001d!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u0011\u0011DG\u0007\u0002\u0019%\u00111\u0004\u0004\u0002\u000e\u0007>tg-[4IC:$G.\u001a:\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}q\u0011!B;uS2\u001c\u0018BA\u0011\u001f\u0005\u001daunZ4j]\u001e\f!\u0002\\8h\u001b\u0006t\u0017mZ3s+\u0005!\u0003CA\u0013)\u001b\u00051#BA\u0014\u000f\u0003\rawnZ\u0005\u0003S\u0019\u0012!\u0002T8h\u001b\u0006t\u0017mZ3s\u0003-awnZ'b]\u0006<WM\u001d\u0011\u0002\u0017-\fgm[1D_:4\u0017n\u001a\t\u000335J!A\f\u0007\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0007cV|G/Y:\u0016\u0003E\u0002\"A\r\u001f\u000f\u0005MRdB\u0001\u001b:\u001d\t)\u0004(D\u00017\u0015\t9\u0004#\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QBD\u0005\u0003w1\tA\"U;pi\u00064\u0015m\u0019;pefL!!\u0010 \u0003\u001bE+x\u000e^1NC:\fw-\u001a:t\u0015\tYD\"A\u0004rk>$\u0018m\u001d\u0011\u0002\u001f-\fgm[1D_:$(o\u001c7mKJ\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\b\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0002G\u0007\ny1*\u00194lC\u000e{g\u000e\u001e:pY2,'/\u0001\u0004=S:LGO\u0010\u000b\u0006\u0013*[E*\u0014\t\u00033\u0001AQAI\u0004A\u0002\u0011BQaK\u0004A\u00021BQaL\u0004A\u0002EBQ\u0001Q\u0004A\u0002\u0005\u000bA\u0003\u001d:pG\u0016\u001c8oQ8oM&<7\t[1oO\u0016\u001cHc\u0001)T;B\u00111#U\u0005\u0003%R\u0011A!\u00168ji\")A\u000b\u0003a\u0001+\u0006)Ao\u001c9jGB\u0011aK\u0017\b\u0003/b\u0003\"!\u000e\u000b\n\u0005e#\u0012A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!\u0017\u000b\t\u000byC\u0001\u0019A0\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\fA!\u001e;jY*\tA-\u0001\u0003kCZ\f\u0017B\u00014b\u0005)\u0001&o\u001c9feRLWm]\u0001\u0019a\u0006\u00148/\u001a+ie>$H\u000f\\3e!\u0006\u0014H/\u001b;j_:\u001cH\u0003B5vmb\u00042A[8s\u001d\tYWN\u0004\u00026Y&\tQ#\u0003\u0002o)\u00059\u0001/Y2lC\u001e,\u0017B\u00019r\u0005\r\u0019V-\u001d\u0006\u0003]R\u0001\"aE:\n\u0005Q$\"aA%oi\")a,\u0003a\u0001?\")q/\u0003a\u0001e\u0006A!M]8lKJLE\rC\u0003z\u0013\u0001\u0007Q+\u0001\u0003qe>\u0004\u0018aD3yG2,H-\u001a3D_:4\u0017nZ:\u0015\tq|\u0018\u0011\u0001\t\u0004-v,\u0016B\u0001@]\u0005\r\u0019V\r\u001e\u0005\u0006)*\u0001\r!\u0016\u0005\u0006=*\u0001\ra\u0018")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final LogManager logManager;
    private final KafkaConfig kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private final KafkaController kafkaController;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TopicConfigHandler topicConfigHandler = this;
        synchronized (topicConfigHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        block1: {
            scala.collection.immutable.Set<String> configNamesToExclude = this.excludedConfigs(topic, topicConfig);
            Buffer logs = this.logManager().logsByTopic(topic).toBuffer();
            if (logs.nonEmpty()) {
                Properties props = new Properties();
                ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfig).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    BoxedUnit boxedUnit = !configNamesToExclude.contains((Object)key) ? props.put(key, value) : BoxedUnit.UNIT;
                    return boxedUnit;
                });
                LogConfig logConfig = LogConfig$.MODULE$.fromProps(this.logManager().currentDefaultConfig().originals(), props);
                logs.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.updateConfig((Set<String>)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfig).asScala()).keySet(), logConfig);
                    return BoxedUnit.UNIT;
                });
            }
            this.updateThrottledList$1(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.quotas().leader(), topicConfig, topic);
            this.updateThrottledList$1(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.quotas().follower(), topicConfig, topic);
            if (!BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(topicConfig.getProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp()))).toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) break block1;
            this.kafkaController.enableTopicUncleanLeaderElection(topic);
        }
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator$.MODULE$.ensureValidString(prop, configValue);
        String string = configValue;
        Seq seq = "".equals(string) ? (Seq)Nil$.MODULE$ : ("*".equals(string) ? Constants$.MODULE$.AllReplicas() : new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(","))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.split(":"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$2(brokerId, x$3))))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)TopicConfigHandler.$anonfun$parseThrottledPartitions$3(x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSeq());
        return seq;
    }

    public scala.collection.immutable.Set<String> excludedConfigs(String topic, Properties topicConfig) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)topicConfig.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).flatMap((Function1 & Serializable & scala.Serializable)versionString -> {
            None$ none$;
            if ($this.kafkaConfig.interBrokerProtocolVersion().$less(ApiVersion$.MODULE$.apply((String)versionString))) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(109).append("Log configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append(" is ignored for `").append(topic).append("` because `").append((String)versionString).append("` ").append("is not compatible with Kafka inter-broker protocol version `").append($this.kafkaConfig.interBrokerProtocolVersionString()).append("`").toString());
                none$ = new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        })).toSet();
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, Properties topicConfig$1, String topic$1) {
        if (topicConfig$1.containsKey(prop) && topicConfig$1.getProperty(prop).length() > 0) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, partitions);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Setting ").append(prop).append(" on broker ").append($this.kafkaConfig.brokerId()).append(" for topic: ").append(topic$1).append(" and partitions ").append(partitions).toString());
        } else {
            quotaManager.removeThrottle(topic$1);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing ").append(prop).append(" from broker ").append($this.kafkaConfig.brokerId()).append(" for topic ").append(topic$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseThrottledPartitions$2(int brokerId$1, String[] x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3[1])).toInt() == brokerId$1;
    }

    public static final /* synthetic */ int $anonfun$parseThrottledPartitions$3(String[] x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4[0])).toInt();
    }

    public TopicConfigHandler(LogManager logManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas, KafkaController kafkaController) {
        this.logManager = logManager;
        this.kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        this.kafkaController = kafkaController;
        Logging.$init$(this);
    }
}

