/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogAppendInfo;
import kafka.log.LogOffsetSnapshot;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\ted\u0001B\u0012%\u0001%B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\ny\u0001\u0011\t\u0011)A\u0005{\rC\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"AA\n\u0001B\u0001B\u0003%Q\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011!!\u0006A!A!\u0002\u0013)\u0006\"\u0002-\u0001\t\u0003I\u0006b\u00022\u0001\u0005\u0004%Ia\u0019\u0005\u0007Q\u0002\u0001\u000b\u0011\u00023\t\u000f%\u0004!\u0019!C\u0005U\"11\u000f\u0001Q\u0001\n-Dq\u0001\u001e\u0001C\u0002\u0013%!\u000e\u0003\u0004v\u0001\u0001\u0006Ia\u001b\u0005\bm\u0002\u0001\r\u0011\"\u0003x\u0011%\ti\u0001\u0001a\u0001\n\u0013\ty\u0001C\u0004\u0002\u001c\u0001\u0001\u000b\u0015\u0002=\t\u000f\u0005u\u0001\u0001\"\u0015\u0002 !9\u0011q\u0005\u0001\u0005R\u0005%\u0002bBA\u001a\u0001\u0011E\u0013Q\u0007\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\tY\b\u0001C!\u0003{Bq!!2\u0001\t\u0003\n9\rC\u0004\u0002Z\u0002!\t&a7\t\u000f\u0005\r\b\u0001\"\u0015\u0002f\"9\u00111\u001e\u0001\u0005\n\u00055\bbBA}\u0001\u0011\u0005\u00131 \u0005\b\u0005#\u0001A\u0011\u000bB\n\u0011\u001d\u0011Y\u0002\u0001C!\u0005;AqAa\u000b\u0001\t#\u0012i\u0003C\u0004\u00036\u0001!IAa\u000e\t\u000f\t%\u0003\u0001\"\u0003\u0003L!9!q\n\u0001\u0005\n\tE\u0003b\u0002B:\u0001\u0011\u0005!Q\u000f\u0002\u001a%\u0016\u0004H.[2b\u00032$XM\u001d'pO\u0012K'o\u001d+ie\u0016\fGM\u0003\u0002&M\u000511/\u001a:wKJT\u0011aJ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0006\u0005\u0002,Y5\tA%\u0003\u0002.I\t)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017\u0001\u00028b[\u0016\u0004\"\u0001M\u001d\u000f\u0005E:\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b)\u0003\u0019a$o\\8u})\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\rM#(/\u001b8h\u0015\tAT'\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002?\u00036\tqH\u0003\u0002AM\u000591\r\\;ti\u0016\u0014\u0018B\u0001\"@\u00059\u0011%o\\6fe\u0016sG\rU8j]RL!\u0001\u0010\u0017\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u0005-2\u0015BA$%\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\bCA\u0016K\u0013\tYEE\u0001\tGC&dW\r\u001a)beRLG/[8og\u0006Q!/\u001a9mS\u000e\fWj\u001a:\u0011\u0005-r\u0015BA(%\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fQ!];pi\u0006\u0004\"a\u000b*\n\u0005M##a\u0006*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003A\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000f\u0005\u0002,-&\u0011q\u000b\n\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biN\fa\u0001P5oSRtD\u0003\u0003.\\9vsv\fY1\u0011\u0005-\u0002\u0001\"\u0002\u0018\t\u0001\u0004y\u0003\"\u0002\u001f\t\u0001\u0004i\u0004\"\u0002#\t\u0001\u0004)\u0005\"\u0002%\t\u0001\u0004I\u0005\"\u0002'\t\u0001\u0004i\u0005\"\u0002)\t\u0001\u0004\t\u0006\"\u0002+\t\u0001\u0004)\u0016!\u0003:fa2L7-Y%e+\u0005!\u0007CA3g\u001b\u0005)\u0014BA46\u0005\rIe\u000e^\u0001\u000be\u0016\u0004H.[2b\u0013\u0012\u0004\u0013\u0001C7bq\nKH/Z:\u0016\u0003-\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\t1\fgn\u001a\u0006\u0002a\u0006!!.\u0019<b\u0013\t\u0011XNA\u0004J]R,w-\u001a:\u0002\u00135\f\u0007PQ=uKN\u0004\u0013!\u00034fi\u000eD7+\u001b>f\u0003)1W\r^2i'&TX\rI\u0001\u0014S:\u0004&o\\4sKN\u001c\b+\u0019:uSRLwN\\\u000b\u0002qB\u0019Q-_>\n\u0005i,$AB(qi&|g\u000eE\u0002}\u0003\u0013i\u0011! \u0006\u0003}~\faaY8n[>t'bA\u0014\u0002\u0002)!\u00111AA\u0003\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qA\u0001\u0004_J<\u0017bAA\u0006{\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017aF5o!J|wM]3tgB\u000b'\u000f^5uS>tw\fJ3r)\u0011\t\t\"a\u0006\u0011\u0007\u0015\f\u0019\"C\u0002\u0002\u0016U\u0012A!\u00168ji\"A\u0011\u0011\u0004\t\u0002\u0002\u0003\u0007\u00010A\u0002yIE\nA#\u001b8Qe><'/Z:t!\u0006\u0014H/\u001b;j_:\u0004\u0013a\u00037bi\u0016\u001cH/\u00129pG\"$B!!\t\u0002$A\u0019Q-\u001f3\t\r\u0005\u0015\"\u00031\u0001|\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\fA\u0002\\8h\u000b:$wJ\u001a4tKR$B!a\u000b\u00022A\u0019Q-!\f\n\u0007\u0005=RG\u0001\u0003M_:<\u0007BBA\u0013'\u0001\u000710A\tf]\u0012|eMZ:fi\u001a{'/\u00129pG\"$b!a\u000e\u0002@\u0005\u0005\u0003\u0003B3z\u0003s\u00012aKA\u001e\u0013\r\ti\u0004\n\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0011\u0019\t)\u0003\u0006a\u0001w\"1\u00111\t\u000bA\u0002\u0011\fQ!\u001a9pG\"\fqBZ3uG\"4%o\\7MK\u0006$WM\u001d\u000b\u0005\u0003\u0013\n\u0019\u0007\u0005\u0004\u0002L\u0005E\u0013QK\u0007\u0003\u0003\u001bR1!a\u00146\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003'\niEA\u0002TKF\u0004b!ZA,w\u0006m\u0013bAA-k\t1A+\u001e9mKJ\u0002B!!\u0018\u0002`5\t\u0001!C\u0002\u0002b1\u0012\u0011BR3uG\"$\u0015\r^1\t\u000f\u0005\u0015T\u00031\u0001\u0002h\u0005aa-\u001a;dQJ+\u0017/^3tiB!\u0011\u0011NA;\u001d\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8{\u0006A!/Z9vKN$8/\u0003\u0003\u0002t\u00055\u0014\u0001\u0004$fi\u000eD'+Z9vKN$\u0018\u0002BA<\u0003s\u0012qAQ;jY\u0012,'O\u0003\u0003\u0002t\u00055\u0014\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0005\u0002\u0000\u00055\u0015qRAJ!\u0011)\u00170!!\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"'\u0003\rawnZ\u0005\u0005\u0003\u0017\u000b)IA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\u0007\u0003K1\u0002\u0019A>\t\u000f\u0005Ee\u00031\u0001\u0002,\u0005Ya-\u001a;dQ>3gm]3u\u0011\u001d\t)J\u0006a\u0001\u0003/\u000bQ\u0002]1si&$\u0018n\u001c8ECR\f\u0007CBAM\u0003g\u000bIL\u0004\u0003\u0002\u001c\u0006=f\u0002BAO\u0003[sA!a(\u0002,:!\u0011\u0011UAU\u001d\u0011\t\u0019+a*\u000f\u0007I\n)+\u0003\u0002\u0002\b%!\u00111AA\u0003\u0013\r9\u0013\u0011A\u0005\u0003}~L1!a\u001c~\u0013\u0011\t\t,!\u001c\u0002\u001b\u0019+Go\u00195SKN\u0004xN\\:f\u0013\u0011\t),a.\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\u0011\t\t,!\u001c\u0011\t\u0005m\u0016\u0011Y\u0007\u0003\u0003{S1!a0~\u0003\u0019\u0011XmY8sI&!\u00111YA_\u0005\u001d\u0011VmY8sIN\fQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0003BAe\u0003\u001f\u0004R!a\u0013\u0002LnLA!!4\u0002N\t\u00191+\u001a;\t\u000f\u0005Ew\u00031\u0001\u0002T\u0006\u0011\u0012N\\5uS\u0006dg)\u001a;dQN#\u0018\r^3t!\u001d\tY%!6|\u0003sIA!a6\u0002N\t\u0019Q*\u00199\u0002;\u0019,Go\u00195FCJd\u0017.Z:u\u001f\u001a47/\u001a;Ge>lG*Z1eKJ$b!a\u000b\u0002^\u0006}\u0007BBA\u00131\u0001\u00071\u0010\u0003\u0004\u0002bb\u0001\r\u0001Z\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007.A\u000egKR\u001c\u0007\u000eT1uKN$xJ\u001a4tKR4%o\\7MK\u0006$WM\u001d\u000b\u0007\u0003W\t9/!;\t\r\u0005\u0015\u0012\u00041\u0001|\u0011\u0019\t\t/\u0007a\u0001I\u0006\u0001sN\u001a4tKR\u001cf.\u00199tQ>$hI]8n\u0007V\u0014(/\u001a8u%\u0016\u0004H.[2b)\u0019\ty/!>\u0002xB!\u00111QAy\u0013\u0011\t\u00190!\"\u0003#1{wm\u00144gg\u0016$8K\\1qg\"|G\u000f\u0003\u0004\u0002&i\u0001\ra\u001f\u0005\u0007\u0003CT\u0002\u0019\u00013\u0002)\u0019,Go\u00195Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;t)\u0011\tiP!\u0002\u0011\u000f\u0005-\u0013Q[>\u0002\u0000B!\u00111\u000eB\u0001\u0013\u0011\u0011\u0019!!\u001c\u0003\u001d\u0015\u0003xn\u00195F]\u0012|eMZ:fi\"9!qA\u000eA\u0002\t%\u0011A\u00039beRLG/[8ogB9\u00111JAkw\n-\u0001\u0003BA/\u0005\u001bI1Aa\u0004-\u0005%)\u0005o\\2i\t\u0006$\u0018-A\u0010jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012,\"A!\u0006\u0011\u0007\u0015\u00149\"C\u0002\u0003\u001aU\u0012qAQ8pY\u0016\fg.\u0001\u0005ueVt7-\u0019;f)\u0019\t\tBa\b\u0003\"!1\u0011QE\u000fA\u0002mDqAa\t\u001e\u0001\u0004\u0011)#A\bueVt7-\u0019;j_:\u001cF/\u0019;f!\rY#qE\u0005\u0004\u0005S!#!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/Z\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$b!!\u0005\u00030\tE\u0002BBA\u0013=\u0001\u00071\u0010C\u0004\u00034y\u0001\r!a\u000b\u0002\r=4gm]3u\u0003IqW\r\u001f;SK\u0006$\u0017\u0010U1si&$\u0018n\u001c8\u0015\t\te\"1\t\t\u0005Kf\u0014Y\u0004\u0005\u0004f\u0003/Z(Q\b\t\u0004W\t}\u0012b\u0001B!I\t\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\"9!QI\u0010A\u0002\t\u001d\u0013\u0001\u00049beRLG/[8o\u001b\u0006\u0004\bcBA&\u0003+\\(QH\u0001\u0017g\u0016dWm\u0019;QCJ$\u0018\u000e^5p]R{g)\u001a;dQR!!\u0011\bB'\u0011\u001d\u0011)\u0005\ta\u0001\u0005\u000f\naCY;jY\u00124U\r^2i\r>\u0014\b+\u0019:uSRLwN\u001c\u000b\u0007\u0005'\u0012YGa\u001c\u0011\r\tU#1\rB5\u001d\u0011\u00119Fa\u0018\u000f\t\te#Q\f\b\u0004e\tm\u0013\"A\u0014\n\u0005\u00152\u0013b\u0001B1I\u0005)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017\u0002\u0002B3\u0005O\u0012ACU3tk2$x+\u001b;i!\u0006\u0014H/\u001b;j_:\u001c(b\u0001B1IA!Q-_A4\u0011\u0019\u0011i'\ta\u0001w\u0006\u0011A\u000f\u001d\u0005\b\u0005c\n\u0003\u0019\u0001B\u001f\u0003)1W\r^2i'R\fG/Z\u0001\u000bEVLG\u000e\u001a$fi\u000eDG\u0003\u0002B*\u0005oBqA!\u0012#\u0001\u0004\u00119\u0005")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalReplicaOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalReplicaOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalReplicaOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        this.replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), false, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responsePartitionData -> {
            ReplicaAlterLogDirsThread.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, request.isolationLevel());
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(request.fetchData().keySet().toArray())).mkString(",")).toString());
        }
        return (Seq)partitionData.elem;
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Replica futureReplica = this.replicaMgr.futureLocalReplicaOrException(topicPartition);
        Partition partition = (Partition)this.replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        if (fetchOffset != futureReplica.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureReplica.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        long futureReplicaHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(futureReplica.logEndOffset()), partitionData.highWatermark);
        futureReplica.highWatermark_$eq(new LogOffsetMetadata(futureReplicaHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        futureReplica.maybeIncrementLogStartOffset(partitionData.logStartOffset);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, OffsetAndEpoch> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            set = super.addPartitions((Map<TopicPartition, OffsetAndEpoch>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        LogOffsetSnapshot offsetSnapshot = this.offsetSnapshotFromCurrentReplica(topicPartition, leaderEpoch);
        return offsetSnapshot.logStartOffset();
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        LogOffsetSnapshot offsetSnapshot = this.offsetSnapshotFromCurrentReplica(topicPartition, leaderEpoch);
        return offsetSnapshot.logEndOffset().messageOffset();
    }

    private LogOffsetSnapshot offsetSnapshotFromCurrentReplica(TopicPartition topicPartition, int leaderEpoch) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        return partition.fetchOffsetSnapshot(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false);
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null) {
                TopicPartition tp = (TopicPartition)tuple22._1();
                OffsetsForLeaderEpochRequest.PartitionData epochData = (OffsetsForLeaderEpochRequest.PartitionData)tuple22._2();
                try {
                    EpochEndOffset epochEndOffset;
                    if (epochData.leaderEpoch == -1) {
                        epochEndOffset = new EpochEndOffset(-1, -1L);
                    } else {
                        Partition partition = $this.replicaMgr.getPartitionOrException(tp, false);
                        epochEndOffset = partition.lastOffsetForLeaderEpoch(epochData.currentLeaderEpoch, epochData.leaderEpoch, false);
                    }
                    EpochEndOffset endOffset = epochEndOffset;
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.forException((Throwable)t), -1, -1L));
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return true;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        partition.truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        partition.truncateFullyAndStartAt(offset, true);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitionMap) {
        return ((TraversableOnce)partitionMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2 & Serializable & scala.Serializable)(left, right) -> {
            Tuple2 tuple2;
            block3: {
                block2: {
                    if (new StringOps(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic())).$less((Object)((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                tuple2 = left;
                return tuple2;
            }
            tuple2 = right;
            return tuple2;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        Option option;
        Object object = new Object();
        try {
            void var3_3;
            this.inProgressPartition().foreach((Function1 & Serializable & scala.Serializable)tp -> {
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$1(partitionMap, object, tp);
                return BoxedUnit.UNIT;
            });
            this.inProgressPartition_$eq((Option<TopicPartition>)None$.MODULE$);
            Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitionMap);
            nextPartitionOpt.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$4(this, partitionMap, x0$1);
                return BoxedUnit.UNIT;
            });
            option = var3_3;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetchForPartition(TopicPartition tp, PartitionFetchState fetchState) {
        SetLike setLike;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaMgr.futureLocalReplicaOrException(tp).logStartOffset();
            setLike = requestMap.put(tp, new FetchRequest.PartitionData(fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch()))));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Failed to build fetch for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            setLike = partitionsWithError.$plus$eq((Object)tp);
        }
        None$ fetchRequestOpt = requestMap.isEmpty() ? None$.MODULE$ : new Some((Object)FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())));
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions;
        if (this.quota.isQuotaExceeded()) {
            resultWithPartitions = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)Set$.MODULE$.empty());
        } else {
            AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions2;
            Some some;
            Tuple2 tuple2;
            Option<Tuple2<TopicPartition, PartitionFetchState>> option = this.selectPartitionToFetch(partitionMap);
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
                resultWithPartitions2 = this.buildFetchForPartition(tp, fetchState);
            } else if (None$.MODULE$.equals(option)) {
                resultWithPartitions2 = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)Set$.MODULE$.empty());
            } else {
                throw new MatchError(option);
            }
            resultWithPartitions = resultWithPartitions2;
        }
        return resultWithPartitions;
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            FetchPartitionData data = (FetchPartitionData)tuple2._2();
            List abortedTransactions = (List)data.abortedTransactions().map((Function1 & Serializable & scala.Serializable)x$1 -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)x$1).asJava()).orNull(Predef$.MODULE$.$conforms());
            long lastStableOffset = BoxesRunTime.unboxToLong((Object)data.lastStableOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchResponse.PartitionData(data.error(), data.highWatermark(), lastStableOffset, data.logStartOffset(), abortedTransactions, (BaseRecords)data.records()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        boolean bl = $this.replicaMgr.futureLogExists(tp);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
        boolean bl = partitionFetchState.isReadyForFetch();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(Map partitionMap$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        Option fetchStateOpt = partitionMap$1.get((Object)tp);
        fetchStateOpt.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isReadyForFetch())).foreach((Function1 & Serializable & scala.Serializable)fetchState -> {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)tp, fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(ReplicaAlterLogDirsThread $this, Map partitionMap$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
        $this.inProgressPartition_$eq((Option<TopicPartition>)new Some((Object)tp));
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(133).append("Beginning/resuming copy of partition ").append(tp).append(" from offset ").append(fetchState.fetchOffset()).append(". ").append("Including this partition, there are ").append(partitionMap$1.size()).append(" remaining partitions to copy by this thread.").toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
    }
}

