/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicThreadPool;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.utils.ConfigUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\ruw!\u0002)R\u0011\u00031f!\u0002-R\u0011\u0003I\u0006\"\u00021\u0002\t\u0003\t\u0007\u0002\u00032\u0002\u0005\u0004%\t!U2\t\rQ\f\u0001\u0015!\u0003e\u0011\u001d)\u0018A1A\u0005\u0002\rDaA^\u0001!\u0002\u0013!\u0007bB<\u0002\u0005\u0004%I\u0001\u001f\u0005\u0007y\u0006\u0001\u000b\u0011B=\t\u000fu\f!\u0019!C\u0005G\"1a0\u0001Q\u0001\n\u0011Dqa`\u0001C\u0002\u0013%\u0001\u0010C\u0004\u0002\u0002\u0005\u0001\u000b\u0011B=\t\u0011\u0005\r\u0011A1A\u0005\naDq!!\u0002\u0002A\u0003%\u0011\u0010C\u0005\u0002\b\u0005\u0011\r\u0011\"\u0001\u0002\n!A\u00111D\u0001!\u0002\u0013\tY\u0001\u0003\u0005\u0002\u001e\u0005\u0011\r\u0011\"\u0003d\u0011\u001d\ty\"\u0001Q\u0001\n\u0011Dq!!\t\u0002\t\u0003\t\u0019\u0003C\u0004\u0002D\u0005!\t!!\u0012\t\u000f\u0005}\u0013\u0001\"\u0001\u0002b!9\u00111P\u0001\u0005\n\u0005u\u0004bBAB\u0003\u0011%\u0011Q\u0011\u0005\b\u0003\u0013\u000bA\u0011BAF\u0011\u001d\ty)\u0001C\u0005\u0003#C\u0001\"!&\u0002\t\u0003\t\u0016q\u0013\u0005\t\u0003o\u000bA\u0011A)\u0002:\u001a)\u0001,\u0015\u0001\u0002B\"Q\u0011q\u001a\u000f\u0003\u0006\u0004%I!!5\t\u0015\u0005eGD!A!\u0002\u0013\t\u0019\u000e\u0003\u0004a9\u0011\u0005\u00111\u001c\u0005\u000b\u0003Cd\"\u0019!C\u0001#\u0006\r\b\u0002CAu9\u0001\u0006I!!:\t\u0015\u0005-HD1A\u0005\u0002E\u000b\u0019\u000f\u0003\u0005\u0002nr\u0001\u000b\u0011BAs\u0011%\ty\u000f\bb\u0001\n\u0013\t\t\u0010\u0003\u0005\u0002vr\u0001\u000b\u0011BAz\u0011%\t9\u0010\bb\u0001\n\u0013\t\t\u0010\u0003\u0005\u0002zr\u0001\u000b\u0011BAz\u0011%\tY\u0010\bb\u0001\n\u0013\ti\u0010\u0003\u0005\u0003\u000eq\u0001\u000b\u0011BA\u0000\u0011%\u0011y\u0001\bb\u0001\n\u0013\u0011\t\u0002\u0003\u0005\u0003\u001cq\u0001\u000b\u0011\u0002B\n\u0011%\u0011i\u0002\bb\u0001\n\u0013\u0011y\u0002\u0003\u0005\u00032q\u0001\u000b\u0011\u0002B\u0011\u0011%\u0011\u0019\u0004\ba\u0001\n\u0013\t\t\u000eC\u0005\u00036q\u0001\r\u0011\"\u0003\u00038!A!Q\b\u000f!B\u0013\t\u0019\u000eC\u0005\u0003@q\u0011\r\u0011\"\u0003\u0003B!A!q\n\u000f!\u0002\u0013\u0011\u0019\u0005\u0003\u0005\u0003Rq!\t!\u0015B*\u0011!\u0011)\u0007\bC\u0001#\n\u001d\u0004b\u0002B59\u0011\u0005!1\u000e\u0005\b\u0005obB\u0011\u0001B=\u0011\u001d\u0011y\b\bC\u0001\u0005\u0003CqA!\"\u001d\t\u0003\u00119\tC\u0004\u0003\fr!IA!$\t\u0011\tME\u0004\"\u0001R\u0003#D\u0001B!&\u001d\t\u0003\t&q\u0013\u0005\t\u0005;cB\u0011A)\u0003\u0018\"A!q\u0014\u000f\u0005\u0002E\u0013\t\u000b\u0003\u0005\u00032r!\t!\u0015BZ\u0011!\u00119\f\bC\u0001#\ne\u0006b\u0002B`9\u0011%!\u0011\u0019\u0005\b\u0005+dB\u0011\u0002Bl\u0011!\u0011I\u000e\bC\u0001#\nm\u0007\u0002\u0003Br9\u0011\u0005\u0011K!:\t\u000f\t-H\u0004\"\u0003\u0003n\"9!1 \u000f\u0005\n\tu\b\u0002CB\u00039\u0011\u0005\u0011ka\u0002\t\u000f\r5A\u0004\"\u0003\u0004\u0010!A1Q\u0003\u000f\u0005\u0002E\u001b9\u0002C\u0004\u0004>q!Iaa\u0010\t\u000f\r-D\u0004\"\u0003\u0004n!911\u000f\u000f\u0005\n\t\u001d\u0004bBB;9\u0011%1q\u000f\u0005\b\u0007\u000fcB\u0011BBE\u0011\u001d\u00199\n\bC\u0005\u00073Cqaa0\u001d\t\u0013\u0019\t-A\nEs:\fW.[2Ce>\\WM]\"p]\u001aLwM\u0003\u0002S'\u000611/\u001a:wKJT\u0011\u0001V\u0001\u0006W\u000647.Y\u0002\u0001!\t9\u0016!D\u0001R\u0005M!\u0015P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5h'\t\t!\f\u0005\u0002\\=6\tALC\u0001^\u0003\u0015\u00198-\u00197b\u0013\tyFL\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u000ba\u0003R=oC6L7mU3dkJLG/_\"p]\u001aLwm]\u000b\u0002IB\u0019QM\u001b7\u000e\u0003\u0019T!a\u001a5\u0002\u000f5,H/\u00192mK*\u0011\u0011\u000eX\u0001\u000bG>dG.Z2uS>t\u0017BA6g\u0005\r\u0019V\r\u001e\t\u0003[Jl\u0011A\u001c\u0006\u0003_B\fA\u0001\\1oO*\t\u0011/\u0001\u0003kCZ\f\u0017BA:o\u0005\u0019\u0019FO]5oO\u00069B)\u001f8b[&\u001c7+Z2ve&$\u0018pQ8oM&<7\u000fI\u0001\u0012\u00032dG)\u001f8b[&\u001c7i\u001c8gS\u001e\u001c\u0018AE!mY\u0012Kh.Y7jG\u000e{gNZ5hg\u0002\n1d\u00117vgR,'\u000fT3wK2d\u0015n\u001d;f]\u0016\u00148i\u001c8gS\u001e\u001cX#A=\u0011\u0007i\\H.D\u0001i\u0013\tY\u0007.\u0001\u000fDYV\u001cH/\u001a:MKZ,G\u000eT5ti\u0016tWM]\"p]\u001aLwm\u001d\u0011\u0002!A+'O\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\u0018!\u0005)fe\n\u0013xn[3s\u0007>tg-[4tA\u0005AB*[:uK:,'/T3dQ\u0006t\u0017n]7D_:4\u0017nZ:\u000231K7\u000f^3oKJlUm\u00195b]&\u001cXnQ8oM&<7\u000fI\u0001\u0016%\u0016dw.\u00193bE2,g)\u001b7f\u0007>tg-[4t\u0003Y\u0011V\r\\8bI\u0006\u0014G.\u001a$jY\u0016\u001cuN\u001c4jON\u0004\u0013a\u0005'jgR,g.\u001a:D_:4\u0017n\u001a*fO\u0016DXCAA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t\u0001\"\\1uG\"Lgn\u001a\u0006\u0004\u0003+a\u0016\u0001B;uS2LA!!\u0007\u0002\u0010\t)!+Z4fq\u0006!B*[:uK:,'oQ8oM&<'+Z4fq\u0002\na\u0003R=oC6L7\rU1tg^|'\u000fZ\"p]\u001aLwm]\u0001\u0018\tft\u0017-\\5d!\u0006\u001c8o^8sI\u000e{gNZ5hg\u0002\n\u0001#[:QCN\u001cxo\u001c:e\u0007>tg-[4\u0015\t\u0005\u0015\u00121\u0006\t\u00047\u0006\u001d\u0012bAA\u00159\n9!i\\8mK\u0006t\u0007bBA\u0017'\u0001\u0007\u0011qF\u0001\u0005]\u0006lW\r\u0005\u0003\u00022\u0005}b\u0002BA\u001a\u0003w\u00012!!\u000e]\u001b\t\t9DC\u0002\u0002:U\u000ba\u0001\u0010:p_Rt\u0014bAA\u001f9\u00061\u0001K]3eK\u001aL1a]A!\u0015\r\ti\u0004X\u0001\u0015EJ|7.\u001a:D_:4\u0017nZ*z]>t\u00170\\:\u0015\r\u0005\u001d\u0013\u0011LA.!\u0019\tI%a\u0015\u000209!\u00111JA(\u001d\u0011\t)$!\u0014\n\u0003uK1!!\u0015]\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0016\u0002X\t!A*[:u\u0015\r\t\t\u0006\u0018\u0005\b\u0003[!\u0002\u0019AA\u0018\u0011\u001d\ti\u0006\u0006a\u0001\u0003K\tQ#\\1uG\"d\u0015n\u001d;f]\u0016\u0014xJ^3se&$W-A\bwC2LG-\u0019;f\u0007>tg-[4t)\u0019\t\u0019'!\u001b\u0002xA\u00191,!\u001a\n\u0007\u0005\u001dDL\u0001\u0003V]&$\bbBA6+\u0001\u0007\u0011QN\u0001\u0006aJ|\u0007o\u001d\t\u0005\u0003_\n\u0019(\u0004\u0002\u0002r)\u0019\u0011Q\u00039\n\t\u0005U\u0014\u0011\u000f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA=+\u0001\u0007\u0011QE\u0001\u0010a\u0016\u0014(I]8lKJ\u001cuN\u001c4jO\u0006\u0001\u0002/\u001a:Ce>\\WM]\"p]\u001aLwm\u001d\u000b\u0005\u0003\u007f\n\t\t\u0005\u0003{w\u0006=\u0002bBA6-\u0001\u0007\u0011QN\u0001\u0012]>tG)\u001f8b[&\u001c7i\u001c8gS\u001e\u001cH\u0003BA@\u0003\u000fCq!a\u001b\u0018\u0001\u0004\ti'\u0001\u0013tK\u000e,(/\u001b;z\u0007>tg-[4t/&$\bn\\;u\u0019&\u001cH/\u001a8feB\u0013XMZ5y)\u0011\ty(!$\t\u000f\u0005-\u0004\u00041\u0001\u0002n\u0005\u0019b/\u00197jI\u0006$XmQ8oM&<G+\u001f9fgR!\u00111MAJ\u0011\u001d\tY'\u0007a\u0001\u0003[\n\u0011#\u00193e\tft\u0017-\\5d\u0007>tg-[4t)\u0011\t\u0019'!'\t\u000f\u0005m%\u00041\u0001\u0002\u001e\u0006I1m\u001c8gS\u001e$UM\u001a\t\u0005\u0003?\u000b\u0019,\u0004\u0002\u0002\"*!\u00111UAS\u0003\u0019\u0019wN\u001c4jO*!\u0011qUAU\u0003\u0019\u0019w.\\7p]*\u0019A+a+\u000b\t\u00055\u0016qV\u0001\u0007CB\f7\r[3\u000b\u0005\u0005E\u0016aA8sO&!\u0011QWAQ\u0005%\u0019uN\u001c4jO\u0012+g-\u0001\res:\fW.[2D_:4\u0017nZ+qI\u0006$X-T8eKN,\"!a/\u0011\u0011\u0005=\u0014QXA\u0018\u0003_IA!a0\u0002r\t\u0019Q*\u00199\u0014\tqQ\u00161\u0019\t\u0005\u0003\u000b\fY-\u0004\u0002\u0002H*\u0019\u0011\u0011Z*\u0002\u000bU$\u0018\u000e\\:\n\t\u00055\u0017q\u0019\u0002\b\u0019><w-\u001b8h\u0003-Y\u0017MZ6b\u0007>tg-[4\u0016\u0005\u0005M\u0007cA,\u0002V&\u0019\u0011q[)\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\rW\u000647.Y\"p]\u001aLw\r\t\u000b\u0005\u0003;\fy\u000e\u0005\u0002X9!9\u0011qZ\u0010A\u0002\u0005M\u0017aE:uCRL7M\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001cXCAAs!\u0015)\u0017q\u001d7m\u0013\r\tyLZ\u0001\u0015gR\fG/[2Ce>\\WM]\"p]\u001aLwm\u001d\u0011\u0002)M$\u0018\r^5d\t\u00164\u0017-\u001e7u\u0007>tg-[4t\u0003U\u0019H/\u0019;jG\u0012+g-Y;mi\u000e{gNZ5hg\u0002\nA\u0003Z=oC6L7M\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001cXCAAz!\u001d)\u0017q]A\u0018\u0003_\tQ\u0003Z=oC6L7M\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\b%A\u000bes:\fW.[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:\u0002-\u0011Lh.Y7jG\u0012+g-Y;mi\u000e{gNZ5hg\u0002\nqB]3d_:4\u0017nZ;sC\ndWm]\u000b\u0003\u0003\u007f\u0004R!\u001aB\u0001\u0005\u000bI1Aa\u0001g\u0005\u0019\u0011UO\u001a4feB!!q\u0001B\u0005\u001b\t\t)+\u0003\u0003\u0003\f\u0005\u0015&A\u0004*fG>tg-[4ve\u0006\u0014G.Z\u0001\u0011e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197fg\u0002\nQC\u0019:pW\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,7/\u0006\u0002\u0003\u0014A)QM!\u0001\u0003\u0016A\u0019qKa\u0006\n\u0007\te\u0011K\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\u0017EJ|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3tA\u0005!An\\2l+\t\u0011\t\u0003\u0005\u0003\u0003$\t5RB\u0001B\u0013\u0015\u0011\u00119C!\u000b\u0002\u000b1|7m[:\u000b\t\t-\u0012\u0011O\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002\u0002B\u0018\u0005K\u0011aCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m[\u0001\u0006Y>\u001c7\u000eI\u0001\u000eGV\u0014(/\u001a8u\u0007>tg-[4\u0002#\r,(O]3oi\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002d\te\u0002\"\u0003B\u001e_\u0005\u0005\t\u0019AAj\u0003\rAH%M\u0001\u000fGV\u0014(/\u001a8u\u0007>tg-[4!\u0003q!\u0017P\\1nS\u000e\u001cuN\u001c4jOB\u000b7o]<pe\u0012,enY8eKJ,\"Aa\u0011\u0011\u000bm\u0013)E!\u0013\n\u0007\t\u001dCL\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u000b\u0014Y%\u0003\u0003\u0003N\u0005\u001d'a\u0004)bgN<xN\u001d3F]\u000e|G-\u001a:\u0002;\u0011Lh.Y7jG\u000e{gNZ5h!\u0006\u001c8o^8sI\u0016s7m\u001c3fe\u0002\n!\"\u001b8ji&\fG.\u001b>f)\u0011\t\u0019G!\u0016\t\u000f\t]3\u00071\u0001\u0003Z\u0005A!p[\"mS\u0016tG\u000f\u0005\u0003\u0003\\\t\u0005TB\u0001B/\u0015\r\u0011yfU\u0001\u0003u.LAAa\u0019\u0003^\ti1*\u00194lCj[7\t\\5f]R\fQa\u00197fCJ$\"!a\u0019\u0002%\u0005$GMU3d_:4\u0017nZ;sC\ndWm\u001d\u000b\u0005\u0003G\u0012i\u0007C\u0004\u0003pU\u0002\rA!\u001d\u0002\u0017-\fgm[1TKJ4XM\u001d\t\u0004/\nM\u0014b\u0001B;#\nY1*\u00194lCN+'O^3s\u0003E\tG\r\u001a*fG>tg-[4ve\u0006\u0014G.\u001a\u000b\u0005\u0003G\u0012Y\bC\u0004\u0003~Y\u0002\rA!\u0002\u0002\u001dI,7m\u001c8gS\u001e,(/\u00192mK\u00069\u0012\r\u001a3Ce>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\u000b\u0005\u0003G\u0012\u0019\tC\u0004\u0003~]\u0002\rA!\u0006\u0002)I,Wn\u001c<f%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)\u0011\t\u0019G!#\t\u000f\tu\u0004\b1\u0001\u0003\u0006\u0005Yb/\u001a:jMf\u0014VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON$B!a\u0019\u0003\u0010\"9!\u0011S\u001dA\u0002\u0005}\u0014aC2p]\u001aLwMT1nKN\f!cY;se\u0016tGoS1gW\u0006\u001cuN\u001c4jO\u0006Y2-\u001e:sK:$H)\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jON,\"A!'\u0011\u000fi\u0014Y*a\f\u00020%\u0019\u0011q\u00185\u00029\r,(O]3oi\u0012Kh.Y7jG\u0012+g-Y;mi\u000e{gNZ5hg\u0006\u0011R\u000f\u001d3bi\u0016\u0014%o\\6fe\u000e{gNZ5h)\u0019\t\u0019Ga)\u0003.\"9!QU\u001fA\u0002\t\u001d\u0016\u0001\u00032s_.,'/\u00133\u0011\u0007m\u0013I+C\u0002\u0003,r\u00131!\u00138u\u0011\u001d\u0011y+\u0010a\u0001\u0003[\nq\u0002]3sg&\u001cH/\u001a8u!J|\u0007o]\u0001\u0014kB$\u0017\r^3EK\u001a\fW\u000f\u001c;D_:4\u0017n\u001a\u000b\u0005\u0003G\u0012)\fC\u0004\u00030z\u0002\r!!\u001c\u0002KI,Gn\\1e+B$\u0017\r^3e\r&dWm],ji\"|W\u000f^\"p]\u001aLwm\u00115b]\u001e,G\u0003BA2\u0005wCqA!0@\u0001\u0004\ti'\u0001\u0005oK^\u0004&o\u001c9t\u0003ii\u0017-\u001f2f\u0007J,\u0017\r^3QCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3s)\u0011\u0011\u0019Ea1\t\u000f\t\u0015\u0007\t1\u0001\u0003H\u000611/Z2sKR\u0004Ra\u0017B#\u0005\u0013\u0004BAa3\u0003R6\u0011!Q\u001a\u0006\u0005\u0005\u001f\f\t+A\u0003usB,7/\u0003\u0003\u0003T\n5'\u0001\u0003)bgN<xN\u001d3\u0002\u001fA\f7o]<pe\u0012,enY8eKJ,\"A!\u0013\u0002#Q|\u0007+\u001a:tSN$XM\u001c;Qe>\u00048\u000f\u0006\u0004\u0002n\tu'\u0011\u001d\u0005\b\u0005?\u0014\u0005\u0019AA7\u0003-\u0019wN\u001c4jOB\u0013x\u000e]:\t\u000f\u0005e$\t1\u0001\u0002&\u0005\u0019bM]8n!\u0016\u00148/[:uK:$\bK]8qgR1\u0011Q\u000eBt\u0005SDqAa,D\u0001\u0004\ti\u0007C\u0004\u0002z\r\u0003\r!!\n\u0002-5\f\u0017PY3SK\u0016s7m\u001c3f!\u0006\u001c8o^8sIN$b!!\u001c\u0003p\nE\bb\u0002BX\t\u0002\u0007\u0011Q\u000e\u0005\b\u0005g$\u0005\u0019\u0001B{\u00035\tG-\\5o5.\u001cE.[3oiB!!1\fB|\u0013\u0011\u0011IP!\u0018\u0003\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u\u0003M1\u0018\r\\5eCR,GmS1gW\u0006\u0004&o\u001c9t)\u0019\u0011IJa@\u0004\u0004!91\u0011A#A\u0002\u00055\u0014!\u00049s_B\u001cxJ^3se&$W\rC\u0004\u0002z\u0015\u0003\r!!\n\u0002\u0011Y\fG.\u001b3bi\u0016$b!a\u0019\u0004\n\r-\u0001bBA6\r\u0002\u0007\u0011Q\u000e\u0005\b\u0003s2\u0005\u0019AA\u0013\u0003Q\u0011X-\\8wK&sg/\u00197jI\u000e{gNZ5hgR1\u00111MB\t\u0007'Aq!a\u001bH\u0001\u0004\ti\u0007C\u0004\u0002z\u001d\u0003\r!!\n\u0002!5\f\u0017PY3SK\u000e|gNZ5hkJ,G\u0003CA2\u00073\u0019Yba\b\t\u000f\tu\u0004\n1\u0001\u0003\u0006!91Q\u0004%A\u0002\u0005M\u0017!C8mI\u000e{gNZ5h\u0011\u001d\u0019\t\u0003\u0013a\u0001\u0007G\t\u0011B\\3x\u0007>tg-[41\t\r\u001521\u0006\t\t\u0003_\ni,a\f\u0004(A!1\u0011FB\u0016\u0019\u0001!Ab!\f\u0004 \u0005\u0005\t\u0011!B\u0001\u0007_\u00111a\u0018\u00132#\u0011\u0019\tda\u000e\u0011\u0007m\u001b\u0019$C\u0002\u00046q\u0013qAT8uQ&tw\rE\u0002\\\u0007sI1aa\u000f]\u0005\r\te._\u0001\u000fkB$\u0017\r^3e\u0007>tg-[4t)\u0019\u0019\tea\u0013\u0004XA\"11IB$!\u001d)\u0017q]A\u0018\u0007\u000b\u0002Ba!\u000b\u0004H\u0011Y1\u0011J%\u0002\u0002\u0003\u0005)\u0011AB\u0018\u0005\ryF%\u000e\u0005\b\u0005{K\u0005\u0019AB'a\u0011\u0019yea\u0015\u0011\u0011\u0005=\u0014QXA\u0018\u0007#\u0002Ba!\u000b\u0004T\u0011a1QKB&\u0003\u0003\u0005\tQ!\u0001\u00040\t\u0019q\f\n\u001a\t\u000f\re\u0013\n1\u0001\u0004\\\u0005a1-\u001e:sK:$\bK]8qgB21QLB1\u0007O\u0002\u0002\"a\u001c\u0002>\u000e}3Q\r\t\u0005\u0007S\u0019\t\u0007\u0002\u0007\u0004d\r]\u0013\u0011!A\u0001\u0006\u0003\u0019yCA\u0002`IM\u0002Ba!\u000b\u0004h\u0011a1\u0011NB,\u0003\u0003\u0005\tQ!\u0001\u00040\t\u0019q\f\n\u001b\u0002\u001b=4XM\u001d:jI\u0016\u0004&o\u001c9t)\u0019\t\u0019ga\u001c\u0004r!9\u00111\u000e&A\u0002\u0005M\bbBB\u0001\u0015\u0002\u0007\u00111_\u0001\u0014kB$\u0017\r^3DkJ\u0014XM\u001c;D_:4\u0017nZ\u0001\u0017aJ|7-Z:t%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R11\u0011PBA\u0007\u0007\u0003raWB>\u0003'\u001cy(C\u0002\u0004~q\u0013a\u0001V;qY\u0016\u0014\u0004CBA%\u0003'\u0012)\u0002C\u0004\u0003>2\u0003\rA!'\t\u000f\r\u0015E\n1\u0001\u0002&\u0005aa/\u00197jI\u0006$Xm\u00148ms\u0006!b.Z3egJ+7m\u001c8gS\u001e,(/\u0019;j_:$b!!\n\u0004\f\u000eM\u0005bBBG\u001b\u0002\u00071qR\u0001\u0016e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t!\u0019\tyg!%\u00020%\u00191.!\u001d\t\u000f\rUU\n1\u0001\u0002\u0000\u0005YQ\u000f\u001d3bi\u0016$7*Z=t\u0003u\u0001(o\\2fgNd\u0015n\u001d;f]\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,G\u0003DA2\u00077\u001bYk!,\u0004:\u000em\u0006bBBO\u001d\u0002\u00071qT\u0001\u0017Y&\u001cH/\u001a8feJ+7m\u001c8gS\u001e,(/\u00192mKB!1\u0011UBT\u001b\t\u0019\u0019K\u0003\u0003\u0004&\u0006\u0015\u0016a\u00028fi^|'o[\u0005\u0005\u0007S\u001b\u0019K\u0001\fMSN$XM\\3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0011\u001d\u0019\tC\u0014a\u0001\u0003'Dqaa,O\u0001\u0004\u0019\t,A\u0007dkN$x.\\\"p]\u001aLwm\u001d\t\t\u0003_\ni,a\f\u00044B\u0019Qn!.\n\u0007\r]fN\u0001\u0004PE*,7\r\u001e\u0005\b\u0007\u000bs\u0005\u0019AA\u0013\u0011\u001d\u0019iL\u0014a\u0001\u0003K\t!B]3m_\u0006$wJ\u001c7z\u0003U\u0001(o\\2fgN\u0014VmY8oM&<WO]1cY\u0016$B\"a\u0019\u0004D\u000e\u00157\u0011ZBl\u00077DqA! P\u0001\u0004\u0011)\u0001C\u0004\u0004H>\u0003\r!a \u0002%U\u0004H-\u0019;fI\u000e{gNZ5h\u001d\u0006lWm\u001d\u0005\b\u0007\u0017|\u0005\u0019ABg\u00035\tG\u000e\u001c(fo\u000e{gNZ5hgB\"1qZBj!!\ty'!0\u00020\rE\u0007\u0003BB\u0015\u0007'$Ab!6\u0004J\u0006\u0005\t\u0011!B\u0001\u0007_\u00111a\u0018\u00137\u0011\u001d\u0019In\u0014a\u0001\u0007c\u000b\u0001C\\3x\u0007V\u001cHo\\7D_:4\u0017nZ:\t\u000f\r\u0015u\n1\u0001\u0002&\u0001")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final Buffer<Reconfigurable> reconfigurables;
    private final Buffer<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private KafkaConfig currentConfig;
    private final Option<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties properties, boolean bl) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(properties, bl);
    }

    public static List<String> brokerConfigSynonyms(String string, boolean bl) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(string, bl);
    }

    public static boolean isPasswordConfig(String string) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(string);
    }

    public static Regex ListenerConfigRegex() {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex();
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DynamicBrokerConfig dynamicBrokerConfig = this;
        synchronized (dynamicBrokerConfig) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    private Buffer<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private Buffer<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Option<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(KafkaZkClient zkClient) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$));
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        this.updateDefaultConfig(adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default()));
        Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)this.kafkaConfig().brokerId())).toString());
        Properties brokerConfig = this.maybeReEncodePasswords(props, adminZkClient);
        this.updateBrokerConfig(this.kafkaConfig().brokerId(), brokerConfig);
    }

    public void clear() {
        this.dynamicBrokerConfigs().clear();
        this.dynamicDefaultConfigs().clear();
        this.reconfigurables().clear();
        this.brokerReconfigurables().clear();
    }

    public void addReconfigurables(KafkaServer kafkaServer) {
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer));
        this.addReconfigurable(new DynamicClientQuotaCallback(this.kafkaConfig().brokerId(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicThreadPool(kafkaServer));
        if (kafkaServer.logManager().cleaner() != null) {
            this.addBrokerReconfigurable(kafkaServer.logManager().cleaner());
        }
        this.addBrokerReconfigurable(new DynamicLogConfig(kafkaServer.logManager(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.socketServer());
    }

    public void addReconfigurable(Reconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            this.verifyReconfigurableConfigs((Set<String>)((Set)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()));
            return this.reconfigurables().$plus$eq((Object)reconfigurable);
        });
    }

    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            this.verifyReconfigurableConfigs(reconfigurable.reconfigurableConfigs());
            return this.brokerReconfigurables().$plus$eq((Object)reconfigurable);
        });
    }

    public void removeReconfigurable(Reconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.reconfigurables().$minus$eq((Object)reconfigurable));
    }

    private void verifyReconfigurableConfigs(Set<String> configNames) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Set nonDynamic = (Set)configNames.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$2(elem)));
            Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Reconfigurable contains non-dynamic configs ").append(nonDynamic).toString());
        });
    }

    public KafkaConfig currentKafkaConfig() {
        return (KafkaConfig)((Object)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.currentConfig()));
    }

    public Map<String, String> currentDynamicBrokerConfigs() {
        return (Map)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.dynamicBrokerConfigs().clone());
    }

    public Map<String, String> currentDynamicDefaultConfigs() {
        return (Map)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.dynamicDefaultConfigs().clone());
    }

    public void updateBrokerConfig(int brokerId, Properties persistentProps) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                Properties props = this.fromPersistentProps(persistentProps, true);
                this.dynamicBrokerConfigs().clear();
                this.dynamicBrokerConfigs().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
                this.updateCurrentConfig();
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Per-broker configs of ").append(brokerId).append(" could not be applied: ").append(persistentProps.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        });
    }

    public void updateDefaultConfig(Properties persistentProps) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                Properties props = this.fromPersistentProps(persistentProps, false);
                this.dynamicDefaultConfigs().clear();
                this.dynamicDefaultConfigs().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
                this.updateCurrentConfig();
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cluster default configs could not be applied: ").append(persistentProps.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        });
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties newProps) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)this.reconfigurables().filter((Function1 & Serializable & scala.Serializable)reconfigurable -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$2(reconfigurable)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$4(this, newProps, x0$1);
            return BoxedUnit.UNIT;
        }));
    }

    private Option<PasswordEncoder> maybeCreatePasswordEncoder(Option<Password> secret2) {
        return secret2.map((Function1 & Serializable & scala.Serializable)secret -> new PasswordEncoder((Password)secret, this.kafkaConfig().passwordEncoderKeyFactoryAlgorithm(), this.kafkaConfig().passwordEncoderCipherAlgorithm(), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderKeyLength()), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderIterations())));
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        void var3_3;
        Properties props = (Properties)configProps.clone();
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configProps).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$2(this, perBrokerConfig, props, x0$1);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        void var3_3;
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs configured in ZooKeeper will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$6(this, props, x0$1);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Properties maybeReEncodePasswords(Properties persistentProps, AdminZkClient adminZkClient) {
        void var3_3;
        block0: {
            Properties props = (Properties)persistentProps.clone();
            if (!((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)))) break block0;
            this.maybeCreatePasswordEncoder(this.kafkaConfig().passwordEncoderOldSecret()).foreach((Function1 & Serializable & scala.Serializable)passwordDecoder -> {
                DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$2(this, persistentProps, props, adminZkClient, passwordDecoder);
                return BoxedUnit.UNIT;
            });
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> validatedKafkaProps(Properties propsOverride, boolean perBrokerConfig) {
        void var3_3;
        DynamicBrokerConfig$.MODULE$.validateConfigs(propsOverride, perBrokerConfig);
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        if (perBrokerConfig) {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(propsOverride).asScala()));
        } else {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(propsOverride).asScala()));
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        }
        return var3_3;
    }

    public void validate(Properties props, boolean perBrokerConfig) {
        CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Map<String, String> newProps = this.validatedKafkaProps(props, perBrokerConfig);
            return this.processReconfiguration(newProps, true);
        });
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala();
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$1)));
            invalidProps.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Dynamic ").append(configSource).append(" config contains invalid values: ").append(invalidProps.keys()).append(", these configs will be ignored").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        block0: {
            if (!((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()).exists((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) break block0;
            reconfigurable.reconfigure(newConfig);
        }
    }

    private scala.collection.mutable.Map<String, ?> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<?, ?> currentProps) {
        return (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(newProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$1)));
    }

    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        propsOverride.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(k, false).foreach((Function1 & Serializable & scala.Serializable)key -> props.remove(key));
            Option option = props.put((Object)k, (Object)v);
            return option;
        });
    }

    private void updateCurrentConfig() {
        block1: {
            scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            newProps.$plus$plus$eq(this.staticBrokerConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
            KafkaConfig oldConfig = this.currentConfig();
            Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            KafkaConfig newConfig = (KafkaConfig)((Object)tuple2._1());
            List brokerReconfigurablesToUpdate = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate);
            Tuple2 tuple23 = tuple22;
            KafkaConfig newConfig2 = (KafkaConfig)((Object)tuple23._1());
            List brokerReconfigurablesToUpdate2 = (List)tuple23._2();
            if (newConfig2 == this.currentConfig()) break block1;
            this.currentConfig_$eq(newConfig2);
            this.kafkaConfig().updateCurrentConfig(newConfig2);
            brokerReconfigurablesToUpdate2.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.reconfigure(oldConfig, newConfig2);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly) {
        Tuple2 tuple2;
        KafkaConfig newConfig = new KafkaConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(newProps).asJava(), !validateOnly, (Option<DynamicBrokerConfig>)None$.MODULE$);
        scala.collection.mutable.Map<String, ?> updatedMap = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (updatedMap.nonEmpty()) {
            try {
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(newConfig.valuesFromThisConfig().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> customConfigs.remove(x$1));
                this.reconfigurables().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    DynamicBrokerConfig.$anonfun$processReconfiguration$2(this, newConfig, customConfigs, validateOnly, updatedMap, x0$1);
                    return BoxedUnit.UNIT;
                });
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
                    Object object;
                    if (this.needsReconfiguration((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(reconfigurable.reconfigurableConfigs()).asJava(), (Set<String>)updatedMap.keySet())) {
                        reconfigurable.validateReconfiguration(newConfig);
                        object = !validateOnly ? brokerReconfigurablesToUpdate.$plus$eq(reconfigurable) : BoxedUnit.UNIT;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                });
                tuple2 = new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Failed to update broker configuration with configs : ").append(ConfigUtils.configMapToRedactedString(newConfig.originalsFromThisConfig(), (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        } else {
            tuple2 = new Tuple2((Object)this.currentConfig(), (Object)List$.MODULE$.empty());
        }
        return tuple2;
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys) {
        return ((TraversableOnce)((GenSetLike)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(updatedKeys)).nonEmpty();
    }

    private void processListenerReconfigurable(ListenerReconfigurable listenerReconfigurable, KafkaConfig newConfig, java.util.Map<String, Object> customConfigs, boolean validateOnly, boolean reloadOnly) {
        block0: {
            ListenerName listenerName = listenerReconfigurable.listenerName();
            java.util.Map<String, Object> oldValues = this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
            java.util.Map<String, Object> newValues = newConfig.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
            Set updatedKeys = this.updatedConfigs(newValues, oldValues).keySet();
            boolean configsChanged = this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys);
            if (reloadOnly == configsChanged) break block0;
            this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs, validateOnly);
        }
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        block3: {
            HashMap<String, Object> newConfigs = new HashMap<String, Object>();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(allNewConfigs).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Object object = newConfigs.put(k, v);
                return object;
            });
            newConfigs.putAll(newCustomConfigs);
            try {
                reconfigurable.validateReconfiguration(newConfigs);
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (Exception exception) {
                throw new ConfigException(new StringBuilder(58).append("Validation of dynamic config update of ").append(updatedConfigNames).append(" failed with class ").append(reconfigurable.getClass()).toString());
            }
            if (validateOnly) break block3;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Reconfiguring ").append(reconfigurable).append(", updated configs: ").append(updatedConfigNames).append(" ").append("custom configs: ").append(ConfigUtils.configMapToRedactedString((java.util.Map)newCustomConfigs, (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString());
            reconfigurable.reconfigure(newConfigs);
        }
    }

    public static final /* synthetic */ boolean $anonfun$verifyReconfigurableConfigs$2(String elem) {
        return DynamicConfig$Broker$.MODULE$.nonDynamicProps().contains((Object)elem);
    }

    public static final /* synthetic */ boolean $anonfun$reloadUpdatedFilesWithoutConfigChange$2(Reconfigurable reconfigurable) {
        java.util.Set set = reconfigurable.reconfigurableConfigs();
        return DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)set.contains(x$1)));
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$4(DynamicBrokerConfig $this, Properties newProps$1, Reconfigurable x0$1) {
        Reconfigurable reconfigurable = x0$1;
        if (reconfigurable instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)reconfigurable;
            Map<String, String> kafkaProps = $this.validatedKafkaProps(newProps$1, true);
            KafkaConfig newConfig = new KafkaConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(kafkaProps).asJava(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig, Collections.emptyMap(), false, true);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Files will not be reloaded without config change for ").append(reconfigurable).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$1, Properties props$2) {
        block1: {
            if (value == null) break block1;
            if (!perBrokerConfig$1) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$2.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$2(DynamicBrokerConfig $this, boolean perBrokerConfig$1, Properties props$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        String value = (String)tuple2._2();
        $this.encodePassword$1(name, value, perBrokerConfig$1, props$2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$3) {
        block0: {
            if (!invalidPropNames.nonEmpty()) break block0;
            invalidPropNames.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props$3.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$3) {
        block2: {
            if (value == null) break block2;
            try {
                props$3.setProperty(configName, this.passwordEncoder().decode(value).value());
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Dynamic password config ").append(configName).append(" could not be decoded, ignoring.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                props$3.remove(configName);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$6(DynamicBrokerConfig $this, Properties props$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        String value = (String)tuple2._2();
        $this.decodePassword$1(name, value, props$3);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$4(DynamicBrokerConfig $this, PasswordEncoder passwordDecoder$1, Properties props$4, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String configName = (String)tuple2._1();
            String value2 = (String)tuple2._2();
            if (value2 != null) {
                Some some;
                try {
                    some = new Some((Object)passwordDecoder$1.decode(value2).value());
                }
                catch (Exception exception) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Dynamic password config ").append(configName).append(" could not be decoded using old secret, new secret will be used.").toString());
                    some = None$.MODULE$;
                }
                Some decoded = some;
                decoded.foreach((Function1 & Serializable & scala.Serializable)value -> props$4.put(configName, $this.passwordEncoder().encode(new Password(value))));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$2(DynamicBrokerConfig $this, Properties persistentProps$3, Properties props$4, AdminZkClient adminZkClient$1, PasswordEncoder passwordDecoder) {
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(persistentProps$3).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$4($this, passwordDecoder, props$4, x0$1);
            return BoxedUnit.UNIT;
        });
        adminZkClient$1.changeBrokerConfig((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)$this.kafkaConfig().brokerId())), props$4);
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$1) {
        boolean bl;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                bl = false;
            }
            catch (Exception exception) {
                bl = true;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        Object v = tuple2._2();
        boolean bl = !BoxesRunTime.equals((Object)v, currentProps$1.get(k));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$2(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map updatedMap$1, Reconfigurable x0$1) {
        Reconfigurable reconfigurable = x0$1;
        if (reconfigurable instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)reconfigurable;
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig$3, customConfigs$1, validateOnly$1, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if ($this.needsReconfiguration(reconfigurable.reconfigurableConfigs(), (Set<String>)updatedMap$1.keySet())) {
                $this.processReconfigurable(reconfigurable, (Set<String>)updatedMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
        Logging.$init$(this);
        this.staticBrokerConfigs = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(KafkaConfig$.MODULE$.defaultValues()).asJava()))).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.brokerReconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantReadWriteLock();
        this.currentConfig = kafkaConfig;
        this.dynamicConfigPasswordEncoder = this.maybeCreatePasswordEncoder(kafkaConfig.passwordEncoderSecret());
    }
}

