/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ClientIdAndBroker;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread$;
import kafka.server.FailedPartitions;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherStats;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.ReplicaState;
import kafka.server.Truncating$;
import kafka.utils.CoreUtils$;
import kafka.utils.DelayedItem;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.PartitionStates;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.SetLike;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00115e!B-[\u0003\u0003y\u0006\"\u00034\u0001\u0005\u0003\u0005\u000b\u0011B4u\u0011!)\bA!A!\u0002\u00139\u0007\u0002\u0003<\u0001\u0005\u000b\u0007I\u0011A<\t\u0011y\u0004!\u0011!Q\u0001\naD\u0011b \u0001\u0003\u0002\u0003\u0006I!!\u0001\t\u0015\u0005%\u0001A!A!\u0002\u0013\tY\u0001\u0003\u0007\u0002\u0014\u0001\u0011\t\u0011)A\u0005\u0003+\tY\u0002C\u0004\u0002\u001e\u0001!\t!a\b\u0006\r\u0005=\u0002\u0001AA\u0019\u000b\u0019\ty\u0006\u0001\u0001\u0002b!I\u0011Q\u000e\u0001C\u0002\u0013%\u0011q\u000e\u0005\t\u0003\u0007\u0003\u0001\u0015!\u0003\u0002r!I\u0011Q\u0011\u0001C\u0002\u0013E\u0011q\u0011\u0005\t\u0003C\u0003\u0001\u0015!\u0003\u0002\n\"I\u00111\u0015\u0001C\u0002\u0013%\u0011Q\u0015\u0005\t\u0003[\u0003\u0001\u0015!\u0003\u0002(\"I\u0011q\u0016\u0001C\u0002\u0013%\u0011\u0011\u0017\u0005\t\u0003{\u0003\u0001\u0015!\u0003\u00024\"I\u0011q\u0018\u0001C\u0002\u0013\u0005\u0011\u0011\u0019\u0005\t\u0003\u0013\u0004\u0001\u0015!\u0003\u0002D\"I\u00111\u001a\u0001C\u0002\u0013\u0005\u0011Q\u001a\u0005\t\u0003+\u0004\u0001\u0015!\u0003\u0002P\"9\u0011q\u001b\u0001\u0007\u0012\u0005e\u0007b\u0002B\u0006\u0001\u0019E!Q\u0002\u0005\b\u0005C\u0001a\u0011\u0003B\u0012\u0011\u001d\u0011Y\u0003\u0001D\t\u0005[Aqa!\u0017\u0001\r#\u0019Y\u0006C\u0004\u0004b\u00011\tba\u0019\t\u000f\r\u001d\u0004A\"\u0005\u0004j!91\u0011\u0010\u0001\u0007\u0012\rm\u0004bBBG\u0001\u0019E1q\u0012\u0005\b\u0007S\u0003a\u0011CBV\u0011\u001d\u0019\u0019\f\u0001D\t\u0007kCqaa/\u0001\r#\u0019i\fC\u0004\u0004@\u0002!\te!1\t\u000f\r\r\u0007\u0001\"\u0011\u0004B\"91Q\u0019\u0001\u0005\n\r\u0005\u0007bBBd\u0001\u0011%1\u0011\u001a\u0005\b\u0007/\u0004A\u0011BBm\u0011\u001d\u0019i\u000e\u0001C\u0005\u0007\u0003Dqaa8\u0001\t\u0013\u0019\t\u000fC\u0004\u0004h\u0002!Ia!;\t\u0011\r=\b\u0001\"\u0001[\u0007cDqa!>\u0001\t\u0013\u00199\u0010C\u0004\u0005\u0004\u0001!I\u0001\"\u0002\t\u000f\u0011=\u0001\u0001\"\u0003\u0005\u0012!9A\u0011\u0004\u0001\u0005\u0002\u0011m\u0001b\u0002C\u0012\u0001\u0011%AQ\u0005\u0005\b\tS\u0001A\u0011\u0001C\u0016\u0011\u001d!\u0019\u0004\u0001C\u0005\tkAq\u0001b\u000f\u0001\t\u0013!i\u0004C\u0004\u0005F\u0001!I\u0001b\u0012\t\u000f\u0011E\u0003\u0001\"\u0005\u0005T!9A\u0011\f\u0001\u0005\u0002\u0011m\u0003b\u0002C2\u0001\u0011\u0005AQ\r\u0005\b\tW\u0002A\u0011\u0001Bw\u0011!!i\u0005\u0001C\u00015\u00125\u0004\u0002\u0003C:\u0001\u0011\u0005!\f\"\u001e\t\u000f\u0011}\u0004\u0001\"\u0005\u0005\u0002\u001e9!1\u0007.\t\u0002\tUbAB-[\u0011\u0003\u00119\u0004C\u0004\u0002\u001eu\"\tAa\u0010\u0007\r\t\u0005S\b\u0011B\"\u0011)\u0011\u0019f\u0010BK\u0002\u0013\u0005!Q\u000b\u0005\u000b\u0005[z$\u0011#Q\u0001\n\t]\u0003B\u0003B8\u007f\tU\r\u0011\"\u0001\u0003r!Q!qP \u0003\u0012\u0003\u0006IAa\u001d\t\u000f\u0005uq\b\"\u0001\u0003\u0002\"I!1R \u0002\u0002\u0013\u0005!Q\u0012\u0005\n\u00057{\u0014\u0013!C\u0001\u0005;C\u0011Ba.@#\u0003%\tA!/\t\u0013\t\u0005w(!A\u0005B\t\r\u0007\"\u0003Bh\u007f\u0005\u0005I\u0011\u0001Bi\u0011%\u0011\u0019nPA\u0001\n\u0003\u0011)\u000eC\u0005\u0003\\~\n\t\u0011\"\u0011\u0003^\"I!Q] \u0002\u0002\u0013\u0005!q\u001d\u0005\n\u0005W|\u0014\u0011!C!\u0005[D\u0011Ba<@\u0003\u0003%\tE!=\t\u0013\tMx(!A\u0005B\tUx!\u0003B}{\u0005\u0005\t\u0012\u0001B~\r%\u0011\t%PA\u0001\u0012\u0003\u0011i\u0010C\u0004\u0002\u001eE#\tAa@\t\u0013\t=\u0018+!A\u0005F\tE\b\"CB\u0001#\u0006\u0005I\u0011QB\u0002\u0011%\u0019\t\"UA\u0001\n\u0003\u001b\u0019\u0002C\u0005\u0004*E\u000b\t\u0011\"\u0003\u0004,!I11G\u001f\u0012\u0002\u0013\u00051Q\u0007\u0005\n\u0007si\u0014\u0013!C\u0001\u0007w\u0011Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fGM\u0003\u0002\\9\u000611/\u001a:wKJT\u0011!X\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\r\u0005\u0002bI6\t!M\u0003\u0002d9\u0006)Q\u000f^5mg&\u0011QM\u0019\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG-\u0001\u0003oC6,\u0007C\u00015r\u001d\tIw\u000e\u0005\u0002k[6\t1N\u0003\u0002m=\u00061AH]8pizR\u0011A\\\u0001\u0006g\u000e\fG.Y\u0005\u0003a6\fa\u0001\u0015:fI\u00164\u0017B\u0001:t\u0005\u0019\u0019FO]5oO*\u0011\u0001/\\\u0005\u0003M\u0012\f\u0001b\u00197jK:$\u0018\nZ\u0001\rg>,(oY3Ce>\\WM]\u000b\u0002qB\u0011\u0011\u0010`\u0007\u0002u*\u00111\u0010X\u0001\bG2,8\u000f^3s\u0013\ti(P\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\u0002\u001bM|WO]2f\u0005J|7.\u001a:!\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000f\u0005\u0003\u0002\u0004\u0005\u0015Q\"\u0001.\n\u0007\u0005\u001d!L\u0001\tGC&dW\r\u001a)beRLG/[8og\u0006qa-\u001a;dQ\n\u000b7m[(gM6\u001b\b\u0003BA\u0007\u0003\u001fi\u0011!\\\u0005\u0004\u0003#i'aA%oi\u0006y\u0011n]%oi\u0016\u0014(/\u001e9uS\ndW\r\u0005\u0003\u0002\u000e\u0005]\u0011bAA\r[\n9!i\\8mK\u0006t\u0017bAA\nI\u00061A(\u001b8jiz\"b\"!\t\u0002$\u0005\u0015\u0012qEA\u0015\u0003W\ti\u0003E\u0002\u0002\u0004\u0001AQA\u001a\u0005A\u0002\u001dDQ!\u001e\u0005A\u0002\u001dDQA\u001e\u0005A\u0002aDaa \u0005A\u0002\u0005\u0005\u0001\"CA\u0005\u0011A\u0005\t\u0019AA\u0006\u0011%\t\u0019\u0002\u0003I\u0001\u0002\u0004\t)BA\u0005GKR\u001c\u0007\u000eR1uCB1\u00111GA'\u0003'rA!!\u000e\u0002J5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\ti$a\u0010\u0002\r\r|W.\\8o\u0015\ri\u0016\u0011\t\u0006\u0005\u0003\u0007\n)%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000f\n1a\u001c:h\u0013\u0011\tY%a\u000e\u0002\u001b\u0019+Go\u00195SKN\u0004xN\\:f\u0013\u0011\ty%!\u0015\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\u0011\tY%a\u000e\u0011\t\u0005U\u00131L\u0007\u0003\u0003/RA!!\u0017\u0002<\u00051!/Z2pe\u0012LA!!\u0018\u0002X\t9!+Z2pe\u0012\u001c(!C#q_\u000eDG)\u0019;b!\u0011\t\u0019'!\u001b\u000f\t\u0005U\u0012QM\u0005\u0005\u0003O\n9$\u0001\u000fPM\u001a\u001cX\r^:G_JdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;\n\t\u0005=\u00131\u000e\u0006\u0005\u0003O\n9$A\bqCJ$\u0018\u000e^5p]N#\u0018\r^3t+\t\t\t\b\u0005\u0004\u0002t\u0005e\u0014QP\u0007\u0003\u0003kRA!a\u001e\u0002<\u0005I\u0011N\u001c;fe:\fGn]\u0005\u0005\u0003w\n)HA\bQCJ$\u0018\u000e^5p]N#\u0018\r^3t!\u0011\t\u0019!a \n\u0007\u0005\u0005%LA\nQCJ$\u0018\u000e^5p]\u001a+Go\u00195Ti\u0006$X-\u0001\tqCJ$\u0018\u000e^5p]N#\u0018\r^3tA\u0005\u0001\u0002/\u0019:uSRLwN\\'ba2{7m[\u000b\u0003\u0003\u0013\u0003B!a#\u0002\u001e6\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*A\u0003m_\u000e\\7O\u0003\u0003\u0002\u0014\u0006U\u0015AC2p]\u000e,(O]3oi*!\u0011qSAM\u0003\u0011)H/\u001b7\u000b\u0005\u0005m\u0015\u0001\u00026bm\u0006LA!a(\u0002\u000e\ni!+Z3oiJ\fg\u000e\u001e'pG.\f\u0011\u0003]1si&$\u0018n\u001c8NCBdunY6!\u0003A\u0001\u0018M\u001d;ji&|g.T1q\u0007>tG-\u0006\u0002\u0002(B!\u00111RAU\u0013\u0011\tY+!$\u0003\u0013\r{g\u000eZ5uS>t\u0017!\u00059beRLG/[8o\u001b\u0006\u00048i\u001c8eA\u0005AQ.\u001a;sS\u000eLE-\u0006\u0002\u00024B!\u0011QWA]\u001b\t\t9LC\u0002\u0002>qKA!a/\u00028\n\t2\t\\5f]RLE-\u00118e\u0005J|7.\u001a:\u0002\u00135,GO]5d\u0013\u0012\u0004\u0013\u0001\u00044fi\u000eDWM]*uCR\u001cXCAAb!\u0011\t\u0019!!2\n\u0007\u0005\u001d'L\u0001\u0007GKR\u001c\u0007.\u001a:Ti\u0006$8/A\u0007gKR\u001c\u0007.\u001a:Ti\u0006$8\u000fI\u0001\u0010M\u0016$8\r[3s\u0019\u0006<7\u000b^1ugV\u0011\u0011q\u001a\t\u0005\u0003\u0007\t\t.C\u0002\u0002Tj\u0013qBR3uG\",'\u000fT1h'R\fGo]\u0001\u0011M\u0016$8\r[3s\u0019\u0006<7\u000b^1ug\u0002\nA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fG\u0003CAn\u0003[\fIPa\u0001\u0011\r\u00055\u0011Q\\Aq\u0013\r\ty.\u001c\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\r\u0018\u0011^\u0007\u0003\u0003KT1!a:]\u0003\rawnZ\u0005\u0005\u0003W\f)OA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0003_<\u0002\u0019AAy\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!a=\u0002v6\u0011\u00111H\u0005\u0005\u0003o\fYD\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005mx\u00031\u0001\u0002~\u0006Ya-\u001a;dQ>3gm]3u!\u0011\ti!a@\n\u0007\t\u0005QN\u0001\u0003M_:<\u0007b\u0002B\u0003/\u0001\u0007!qA\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\u0007\t%\u0011\"D\u0001\u0001\u0003!!(/\u001e8dCR,GC\u0002B\b\u0005+\u00119\u0002\u0005\u0003\u0002\u000e\tE\u0011b\u0001B\n[\n!QK\\5u\u0011\u001d\ty\u000f\u0007a\u0001\u0003cDqA!\u0007\u0019\u0001\u0004\u0011Y\"A\bueVt7-\u0019;j_:\u001cF/\u0019;f!\u0011\t\u0019A!\b\n\u0007\t}!LA\u000bPM\u001a\u001cX\r\u001e+sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0002/Q\u0014XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#HC\u0002B\b\u0005K\u00119\u0003C\u0004\u0002pf\u0001\r!!=\t\u000f\t%\u0012\u00041\u0001\u0002~\u00061qN\u001a4tKR\f!BY;jY\u00124U\r^2i)\u0011\u0011yca\u0014\u0011\u000b\tErha\u0010\u000f\u0007\u0005\rA(A\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0011\u0007\u0005\rQhE\u0002>\u0005s\u0001B!!\u0004\u0003<%\u0019!QH7\u0003\r\u0005s\u0017PU3g)\t\u0011)D\u0001\u000bSKN,H\u000e^,ji\"\u0004\u0016M\u001d;ji&|gn]\u000b\u0005\u0005\u000b\u0012YfE\u0004@\u0005s\u00119E!\u0014\u0011\t\u00055!\u0011J\u0005\u0004\u0005\u0017j'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u001b\u0011y%C\u0002\u0003R5\u0014AbU3sS\u0006d\u0017N_1cY\u0016\faA]3tk2$XC\u0001B,!\u0011\u0011IFa\u0017\r\u0001\u00119!QL C\u0002\t}#!\u0001*\u0012\t\t\u0005$q\r\t\u0005\u0003\u001b\u0011\u0019'C\u0002\u0003f5\u0014qAT8uQ&tw\r\u0005\u0003\u0002\u000e\t%\u0014b\u0001B6[\n\u0019\u0011I\\=\u0002\u000fI,7/\u001e7uA\u0005\u0019\u0002/\u0019:uSRLwN\\:XSRDWI\u001d:peV\u0011!1\u000f\t\u0007\u0005k\u0012Y(!=\u000e\u0005\t]$b\u0001B=[\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tu$q\u000f\u0002\u0004'\u0016$\u0018\u0001\u00069beRLG/[8og^KG\u000f[#se>\u0014\b\u0005\u0006\u0004\u0003\u0004\n\u001d%\u0011\u0012\t\u0006\u0005\u000b{$qK\u0007\u0002{!9!1\u000b#A\u0002\t]\u0003b\u0002B8\t\u0002\u0007!1O\u0001\u0005G>\u0004\u00180\u0006\u0003\u0003\u0010\nUEC\u0002BI\u0005/\u0013I\nE\u0003\u0003\u0006~\u0012\u0019\n\u0005\u0003\u0003Z\tUEa\u0002B/\u000b\n\u0007!q\f\u0005\n\u0005'*\u0005\u0013!a\u0001\u0005'C\u0011Ba\u001cF!\u0003\u0005\rAa\u001d\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU!!q\u0014B[+\t\u0011\tK\u000b\u0003\u0003X\t\r6F\u0001BS!\u0011\u00119K!-\u000e\u0005\t%&\u0002\u0002BV\u0005[\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=V.\u0001\u0006b]:|G/\u0019;j_:LAAa-\u0003*\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\tucI1\u0001\u0003`\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002B^\u0005\u007f+\"A!0+\t\tM$1\u0015\u0003\b\u0005;:%\u0019\u0001B0\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u0019\t\u0005\u0005\u000f\u0014i-\u0004\u0002\u0003J*!!1ZAM\u0003\u0011a\u0017M\\4\n\u0007I\u0014I-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\f\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B4\u0005/D\u0011B!7K\u0003\u0003\u0005\r!a\u0003\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011y\u000e\u0005\u0004\u0003v\t\u0005(qM\u0005\u0005\u0005G\u00149H\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u000b\u0005SD\u0011B!7M\u0003\u0003\u0005\rAa\u001a\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0003\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!2\u0002\r\u0015\fX/\u00197t)\u0011\t)Ba>\t\u0013\tew*!AA\u0002\t\u001d\u0014\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7\u000fE\u0002\u0003\u0006F\u001bR!\u0015B\u001d\u0005\u001b\"\"Aa?\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\r\u001511\u0002\u000b\u0007\u0007\u000f\u0019iaa\u0004\u0011\u000b\t\u0015uh!\u0003\u0011\t\te31\u0002\u0003\b\u0005;\"&\u0019\u0001B0\u0011\u001d\u0011\u0019\u0006\u0016a\u0001\u0007\u0013AqAa\u001cU\u0001\u0004\u0011\u0019(A\u0004v]\u0006\u0004\b\u000f\\=\u0016\t\rU1\u0011\u0005\u000b\u0005\u0007/\u0019\u0019\u0003\u0005\u0004\u0002\u000e\u0005u7\u0011\u0004\t\t\u0003\u001b\u0019Yba\b\u0003t%\u00191QD7\u0003\rQ+\b\u000f\\33!\u0011\u0011If!\t\u0005\u000f\tuSK1\u0001\u0003`!I1QE+\u0002\u0002\u0003\u00071qE\u0001\u0004q\u0012\u0002\u0004#\u0002BC\u007f\r}\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!\f\u0011\t\t\u001d7qF\u0005\u0005\u0007c\u0011IM\u0001\u0004PE*,7\r^\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r]\"\u0006BA\u0006\u0005G\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122TCAB\u001fU\u0011\t)Ba)\u0011\r\u00055\u0011Q\\B!!\u0011\u0019\u0019e!\u0013\u000f\t\u0005U2QI\u0005\u0005\u0007\u000f\n9$\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0004L\r5#a\u0002\"vS2$WM\u001d\u0006\u0005\u0007\u000f\n9\u0004C\u0004\u0004Ri\u0001\raa\u0015\u0002\u0019A\f'\u000f^5uS>tW*\u00199\u0011\u0011\tU4QKAy\u0003{JAaa\u0016\u0003x\t\u0019Q*\u00199\u0002\u00171\fG/Z:u\u000bB|7\r\u001b\u000b\u0005\u0007;\u001ay\u0006\u0005\u0004\u0002\u000e\u0005u\u00171\u0002\u0005\b\u0003_\\\u0002\u0019AAy\u00031awnZ#oI>3gm]3u)\u0011\tip!\u001a\t\u000f\u0005=H\u00041\u0001\u0002r\u0006\tRM\u001c3PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\r\r-41OB;!\u0019\ti!!8\u0004nA!\u00111AB8\u0013\r\u0019\tH\u0017\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0011\u001d\ty/\ba\u0001\u0003cDqaa\u001e\u001e\u0001\u0004\tY!A\u0003fa>\u001c\u0007.\u0001\u000bgKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0007{\u001a)\t\u0005\u0005\u0003v\rU\u0013\u0011_B@!\u0011\t)d!!\n\t\r\r\u0015q\u0007\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0011\u001d\u00199I\ba\u0001\u0007\u0013\u000b!\u0002]1si&$\u0018n\u001c8t!!\u0011)h!\u0016\u0002r\u000e-\u0005c\u0001B\u0005\u0015\u0005ya-\u001a;dQ\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0003\u0004\u0012\u000e\u0015\u0006CBBJ\u0007;\u001b\u0019K\u0004\u0003\u0004\u0016\u000eeeb\u00016\u0004\u0018&\ta.C\u0002\u0004\u001c6\fq\u0001]1dW\u0006<W-\u0003\u0003\u0004 \u000e\u0005&aA*fc*\u001911T7\u0011\u0011\u0005511DAy\u0005\u000fAqaa* \u0001\u0004\u0019\t%\u0001\u0007gKR\u001c\u0007NU3rk\u0016\u001cH/A\u000fgKR\u001c\u0007.R1sY&,7\u000f^(gMN,GO\u0012:p[2+\u0017\rZ3s)\u0019\tip!,\u00040\"9\u0011q\u001e\u0011A\u0002\u0005E\bbBBYA\u0001\u0007\u00111B\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.A\u000egKR\u001c\u0007\u000eT1uKN$xJ\u001a4tKR4%o\\7MK\u0006$WM\u001d\u000b\u0007\u0003{\u001c9l!/\t\u000f\u0005=\u0018\u00051\u0001\u0002r\"91\u0011W\u0011A\u0002\u0005-\u0011aH5t\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195TkB\u0004xN\u001d;fIV\u0011\u0011QC\u0001\tg\",H\u000fZ8x]R\u0011!qB\u0001\u0007I><vN]6\u0002\u00155\f\u0017PY3GKR\u001c\u0007.\u0001\u000eiC:$G.\u001a)beRLG/[8og^KG\u000f[#se>\u00148\u000f\u0006\u0004\u0003\u0010\r-71\u001b\u0005\b\u0007\u000f3\u0003\u0019ABg!\u0019\u0019\u0019ja4\u0002r&!1\u0011[BQ\u0005!IE/\u001a:bE2,\u0007BBBkM\u0001\u0007q-\u0001\u0006nKRDw\u000e\u001a(b[\u0016\f\u0011DZ3uG\"$&/\u001e8dCRLgn\u001a)beRLG/[8ogR\u001111\u001c\t\t\u0003\u001b\u0019Yb!#\u0003t\u0005iQ.Y=cKR\u0013XO\\2bi\u0016\f!\u0002Z8UeVt7-\u0019;f)\u0019\t)ba9\u0004f\"9\u0011q^\u0015A\u0002\u0005E\bb\u0002B\rS\u0001\u0007!1D\u0001\u001aiJ,hnY1uKR{W\t]8dQ\u0016sGm\u00144gg\u0016$8\u000f\u0006\u0003\u0003\u0010\r-\bbBBwU\u0001\u00071\u0011R\u0001\u001aY\u0006$Xm\u001d;Fa>\u001c\u0007n\u001d$peB\u000b'\u000f^5uS>t7/A\fueVt7-\u0019;f)>D\u0015n\u001a5XCR,'/\\1sWR!!qBBz\u0011\u001d\u00199i\u000ba\u0001\u0005g\na$\\1zE\u0016$&/\u001e8dCR,Gk\\#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:\u0015\r\re8Q C\u0001!\u0015\u0011\tdPB~!!\u0011)h!\u0016\u0002r\nm\u0001bBB\u0000Y\u0001\u00071QP\u0001\u000eM\u0016$8\r[3e\u000bB|7\r[:\t\u000f\r5H\u00061\u0001\u0004\n\u0006\trN\u001c)beRLG/[8o\r\u0016t7-\u001a3\u0015\r\u0005UAq\u0001C\u0006\u0011\u001d!I!\fa\u0001\u0003c\f!\u0001\u001e9\t\u000f\u00115Q\u00061\u0001\u0004^\u0005a!/Z9vKN$X\t]8dQ\u0006\u0019\u0002O]8dKN\u001ch)\u001a;dQJ+\u0017/^3tiR1!q\u0002C\n\t/Aq\u0001\"\u0006/\u0001\u0004\u0019\u0019&A\u0006gKR\u001c\u0007n\u0015;bi\u0016\u001c\bbBBT]\u0001\u00071\u0011I\u0001\u001c[\u0006\u00148\u000eU1si&$\u0018n\u001c8t\r>\u0014HK];oG\u0006$\u0018n\u001c8\u0015\r\t=AQ\u0004C\u0010\u0011\u001d\tyo\fa\u0001\u0003cDq\u0001\"\t0\u0001\u0004\ti0\u0001\tueVt7-\u0019;j_:|eMZ:fi\u0006\u0019R.\u0019:l!\u0006\u0014H/\u001b;j_:4\u0015-\u001b7fIR!!q\u0002C\u0014\u0011\u001d\ty\u000f\ra\u0001\u0003c\fQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u0002B:\t[Aq\u0001b\f2\u0001\u0004!\t$\u0001\nj]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016\u001c\b\u0003\u0003B;\u0007+\n\tp!\u001c\u0002_U\u0004H-\u0019;f\r\u0016$8\r[(gMN,G/\u00118e\u001b\u0006L(-Z'be.$&/\u001e8dCRLwN\\\"p[BdW\r^3\u0015\t\t=Aq\u0007\u0005\b\ts\u0011\u0004\u0019AB~\u000311W\r^2i\u001f\u001a47/\u001a;t\u0003a9W\r^(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/\u001a\u000b\u0007\u00057!y\u0004\"\u0011\t\u000f\u0011%1\u00071\u0001\u0002r\"9A1I\u001aA\u0002\r}\u0014!\u00057fC\u0012,'/\u00129pG\"|eMZ:fi\u0006)\u0002.\u00198eY\u0016|U\u000f^(g%\u0006tw-Z#se>\u0014H\u0003CA\u000b\t\u0013\"Y\u0005b\u0014\t\u000f\u0005=H\u00071\u0001\u0002r\"9AQ\n\u001bA\u0002\u0005u\u0014A\u00034fi\u000eD7\u000b^1uK\"9AQ\u0002\u001bA\u0002\ru\u0013A\u00064fi\u000eDwJ\u001a4tKR\fe\u000e\u001a+sk:\u001c\u0017\r^3\u0015\r\u0005uHQ\u000bC,\u0011\u001d\ty/\u000ea\u0001\u0003cDqa!-6\u0001\u0004\tY!A\beK2\f\u0017\u0010U1si&$\u0018n\u001c8t)\u0019\u0011y\u0001\"\u0018\u0005`!91q\u0011\u001cA\u0002\r5\u0007b\u0002C1m\u0001\u0007\u0011Q`\u0001\u0006I\u0016d\u0017-_\u0001\u0011e\u0016lwN^3QCJ$\u0018\u000e^5p]N$BAa\u0004\u0005h!9A\u0011N\u001cA\u0002\tM\u0014a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0002\u001dA\f'\u000f^5uS>t7i\\;oiR!Aq\u000eC9!\u0019\ti!!8\u0002~!9\u0011q^\u001dA\u0002\u0005E\u0018\u0001\u00069beRLG/[8og\u0006sGm\u00144gg\u0016$8/\u0006\u0002\u0005xAA!QOB+\u0003c$I\b\u0005\u0003\u0002\u0004\u0011m\u0014b\u0001C?5\n\t\u0012J\\5uS\u0006dg)\u001a;dQN#\u0018\r^3\u0002\u001fQ|W*Z7pef\u0014VmY8sIN$B\u0001b!\u0005\nB!\u0011Q\u000bCC\u0013\u0011!9)a\u0016\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d!Yi\u000fa\u0001\u0003'\nqA]3d_J$7\u000f")
public abstract class AbstractFetcherThread
extends ShutdownableThread {
    private final BrokerEndPoint sourceBroker;
    private final FailedPartitions failedPartitions;
    private final int fetchBackOffMs;
    private final PartitionStates<PartitionFetchState> partitionStates;
    private final ReentrantLock partitionMapLock;
    private final Condition partitionMapCond;
    private final ClientIdAndBroker metricId;
    private final FetcherStats fetcherStats;
    private final FetcherLagStats fetcherLagStats;

    public static boolean $lessinit$greater$default$6() {
        return AbstractFetcherThread$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$5() {
        return AbstractFetcherThread$.MODULE$.$lessinit$greater$default$5();
    }

    public BrokerEndPoint sourceBroker() {
        return this.sourceBroker;
    }

    private PartitionStates<PartitionFetchState> partitionStates() {
        return this.partitionStates;
    }

    public ReentrantLock partitionMapLock() {
        return this.partitionMapLock;
    }

    private Condition partitionMapCond() {
        return this.partitionMapCond;
    }

    private ClientIdAndBroker metricId() {
        return this.metricId;
    }

    public FetcherStats fetcherStats() {
        return this.fetcherStats;
    }

    public FetcherLagStats fetcherLagStats() {
        return this.fetcherLagStats;
    }

    public abstract Option<LogAppendInfo> processPartitionData(TopicPartition var1, long var2, FetchResponse.PartitionData<Records> var4);

    public abstract void truncate(TopicPartition var1, OffsetTruncationState var2);

    public abstract void truncateFullyAndStartAt(TopicPartition var1, long var2);

    public abstract ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> var1);

    public abstract Option<Object> latestEpoch(TopicPartition var1);

    public abstract long logEndOffset(TopicPartition var1);

    public abstract Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition var1, int var2);

    public abstract Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> var1);

    public abstract Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder var1);

    public abstract long fetchEarliestOffsetFromLeader(TopicPartition var1, int var2);

    public abstract long fetchLatestOffsetFromLeader(TopicPartition var1, int var2);

    public abstract boolean isOffsetForLeaderEpochSupported();

    @Override
    public void shutdown() {
        this.initiateShutdown();
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.partitionMapCond().signalAll());
        this.awaitShutdown();
        this.fetcherStats().unregister();
        this.fetcherLagStats().unregister();
    }

    @Override
    public void doWork() {
        this.maybeTruncate();
        this.maybeFetch();
    }

    private void maybeFetch() {
        Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            scala.collection.mutable.Map fetchStates = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.partitionStates().partitionStateMap()).asScala();
            ResultWithPartitions<Option<FetchRequest.Builder>> resultWithPartitions = this.buildFetch((Map<TopicPartition, PartitionFetchState>)fetchStates);
            if (resultWithPartitions == null) {
                throw new MatchError(resultWithPartitions);
            }
            Option<FetchRequest.Builder> fetchRequestOpt = resultWithPartitions.result();
            Set<TopicPartition> partitionsWithError = resultWithPartitions.partitionsWithError();
            Tuple2 tuple2 = new Tuple2(fetchRequestOpt, partitionsWithError);
            Tuple2 tuple22 = tuple2;
            Option fetchRequestOpt2 = (Option)tuple22._1();
            Set partitionsWithError2 = (Set)tuple22._2();
            this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError2, "maybeFetch");
            if (fetchRequestOpt2.isEmpty()) {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("There are no active partitions. Back off for ").append($this.fetchBackOffMs).append(" ms before sending a fetch request").toString());
                object = BoxesRunTime.boxToBoolean((boolean)this.partitionMapCond().await($this.fetchBackOffMs, TimeUnit.MILLISECONDS));
            } else {
                object = BoxedUnit.UNIT;
            }
            return new Tuple2((Object)fetchStates, (Object)fetchRequestOpt2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.mutable.Map fetchStates = (scala.collection.mutable.Map)tuple2._1();
        Option fetchRequestOpt = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fetchStates, (Object)fetchRequestOpt);
        Tuple2 tuple23 = tuple22;
        scala.collection.mutable.Map fetchStates2 = (scala.collection.mutable.Map)tuple23._1();
        Option fetchRequestOpt2 = (Option)tuple23._2();
        fetchRequestOpt2.foreach((Function1 & Serializable & scala.Serializable)fetchRequest -> {
            this.processFetchRequest((Map<TopicPartition, PartitionFetchState>)fetchStates2, fetchRequest);
            return BoxedUnit.UNIT;
        });
    }

    private void handlePartitionsWithErrors(Iterable<TopicPartition> partitions, String methodName) {
        block0: {
            if (!partitions.nonEmpty()) break block0;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Handling errors in ").append(methodName).append(" for partitions ").append(partitions).toString());
            this.delayPartitions(partitions, this.fetchBackOffMs);
        }
    }

    private Tuple2<Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData>, Set<TopicPartition>> fetchTruncatingPartitions() {
        return (Tuple2)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map partitionsWithEpochs = Map$.MODULE$.empty();
            scala.collection.mutable.Set partitionsWithoutEpochs = scala.collection.mutable.Set$.MODULE$.empty();
            this.partitionStates().stream().forEach(new Consumer<PartitionStates.PartitionState<PartitionFetchState>>(this, partitionsWithEpochs, partitionsWithoutEpochs){
                private final /* synthetic */ AbstractFetcherThread $outer;
                private final scala.collection.mutable.Map partitionsWithEpochs$1;
                private final scala.collection.mutable.Set partitionsWithoutEpochs$1;

                public Consumer<PartitionStates.PartitionState<PartitionFetchState>> andThen(Consumer<? super PartitionStates.PartitionState<PartitionFetchState>> x$1) {
                    return Consumer.super.andThen(x$1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public void accept(PartitionStates.PartitionState<PartitionFetchState> state) {
                    if (!((PartitionFetchState)state.value()).isTruncating()) return;
                    TopicPartition tp = state.topicPartition();
                    Option<Object> option = this.$outer.latestEpoch(tp);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int epoch = BoxesRunTime.unboxToInt((Object)some.value());
                        if (this.$outer.isOffsetForLeaderEpochSupported()) {
                            this.partitionsWithEpochs$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetsForLeaderEpochRequest.PartitionData(Optional.of(Predef$.MODULE$.int2Integer(((PartitionFetchState)state.value()).currentLeaderEpoch())), epoch)));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                    this.partitionsWithoutEpochs$1.$plus$eq((Object)tp);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partitionsWithEpochs$1 = partitionsWithEpochs$1;
                    this.partitionsWithoutEpochs$1 = partitionsWithoutEpochs$1;
                }
            });
            return new Tuple2((Object)partitionsWithEpochs, (Object)partitionsWithoutEpochs);
        });
    }

    private void maybeTruncate() {
        block2: {
            Tuple2<Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData>, Set<TopicPartition>> tuple2 = this.fetchTruncatingPartitions();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Map partitionsWithEpochs = (Map)tuple2._1();
            Set partitionsWithoutEpochs = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)partitionsWithEpochs, (Object)partitionsWithoutEpochs);
            Tuple2 tuple23 = tuple22;
            Map partitionsWithEpochs2 = (Map)tuple23._1();
            Set partitionsWithoutEpochs2 = (Set)tuple23._2();
            if (partitionsWithEpochs2.nonEmpty()) {
                this.truncateToEpochEndOffsets((Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData>)partitionsWithEpochs2);
            }
            if (!partitionsWithoutEpochs2.nonEmpty()) break block2;
            this.truncateToHighWatermark((Set<TopicPartition>)partitionsWithoutEpochs2);
        }
    }

    private boolean doTruncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        boolean bl;
        try {
            this.truncate(topicPartition, truncationState);
            bl = true;
        }
        catch (KafkaStorageException e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Failed to truncate ").append(topicPartition).append(" at offset ").append(truncationState.offset()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.markPartitionFailed(topicPartition);
            bl = false;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Unexpected error occurred during truncation for ").append(topicPartition).append(" ").append("at offset ").append(truncationState.offset()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            this.markPartitionFailed(topicPartition);
            bl = false;
        }
        return bl;
    }

    private void truncateToEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> latestEpochsForPartitions) {
        Map<TopicPartition, EpochEndOffset> endOffsets = this.fetchEpochEndOffsets(latestEpochsForPartitions);
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map epochEndOffsets = (Map)endOffsets.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherThread.$anonfun$truncateToEpochEndOffsets$2(this, latestEpochsForPartitions, x0$1)));
            ResultWithPartitions<Map<TopicPartition, OffsetTruncationState>> resultWithPartitions = this.maybeTruncateToEpochEndOffsets((Map<TopicPartition, EpochEndOffset>)epochEndOffsets, latestEpochsForPartitions);
            if (resultWithPartitions == null) {
                throw new MatchError(resultWithPartitions);
            }
            Map<TopicPartition, OffsetTruncationState> fetchOffsets = resultWithPartitions.result();
            Set<TopicPartition> partitionsWithError = resultWithPartitions.partitionsWithError();
            Tuple2 tuple2 = new Tuple2(fetchOffsets, partitionsWithError);
            Tuple2 tuple22 = tuple2;
            Map fetchOffsets2 = (Map)tuple22._1();
            Set partitionsWithError2 = (Set)tuple22._2();
            this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError2, "truncateToEpochEndOffsets");
            this.updateFetchOffsetAndMaybeMarkTruncationComplete((Map<TopicPartition, OffsetTruncationState>)fetchOffsets2);
        });
    }

    public void truncateToHighWatermark(Set<TopicPartition> partitions) {
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            HashMap fetchOffsets = HashMap$.MODULE$.empty();
            partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
                Object object;
                PartitionFetchState partitionState = (PartitionFetchState)this.partitionStates().stateValue(tp);
                if (partitionState != null) {
                    long highWatermark = partitionState.fetchOffset();
                    OffsetTruncationState truncationState = new OffsetTruncationState(highWatermark, true);
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Truncating partition ").append(tp).append(" to local high watermark ").append(highWatermark).toString());
                    object = this.doTruncate((TopicPartition)tp, truncationState) ? fetchOffsets.put(tp, (Object)truncationState) : BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            this.updateFetchOffsetAndMaybeMarkTruncationComplete((Map<TopicPartition, OffsetTruncationState>)fetchOffsets);
        });
    }

    private ResultWithPartitions<Map<TopicPartition, OffsetTruncationState>> maybeTruncateToEpochEndOffsets(Map<TopicPartition, EpochEndOffset> fetchedEpochs, Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> latestEpochsForPartitions) {
        HashMap fetchOffsets = HashMap$.MODULE$.empty();
        HashSet partitionsWithError = HashSet$.MODULE$.empty();
        fetchedEpochs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                EpochEndOffset leaderEpochOffset = (EpochEndOffset)tuple2._2();
                Errors errors = leaderEpochOffset.error();
                if (Errors.NONE.equals(errors)) {
                    OffsetTruncationState offsetTruncationState = this.getOffsetTruncationState(tp, leaderEpochOffset);
                    boxedUnit = this.doTruncate(tp, offsetTruncationState) ? fetchOffsets.put((Object)tp, (Object)offsetTruncationState) : BoxedUnit.UNIT;
                } else if (Errors.FENCED_LEADER_EPOCH.equals(errors)) {
                    boxedUnit = this.onPartitionFenced(tp, (Option<Object>)latestEpochsForPartitions.get((Object)tp).flatMap((Function1 & Serializable & scala.Serializable)p -> p.currentLeaderEpoch.isPresent() ? new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)p.currentLeaderEpoch.get()))) : None$.MODULE$)) ? partitionsWithError.$plus$eq((Object)tp) : BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Retrying leaderEpoch request for partition ").append(tp).append(" as the leader reported an error: ").append(errors).toString());
                    boxedUnit = partitionsWithError.$plus$eq((Object)tp);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        return new ResultWithPartitions<HashMap>(fetchOffsets, (Set<TopicPartition>)partitionsWithError);
    }

    private boolean onPartitionFenced(TopicPartition tp, Option<Object> requestEpoch) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Option$.MODULE$.apply(this.partitionStates().stateValue(tp)).exists((Function1 & Serializable & scala.Serializable)currentFetchState -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherThread.$anonfun$onPartitionFenced$2(this, requestEpoch, tp, currentFetchState)))));
    }

    private void processFetchRequest(Map<TopicPartition, PartitionFetchState> fetchStates, FetchRequest.Builder fetchRequest) {
        block3: {
            Object object;
            scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            ObjectRef responseData = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
            try {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Sending fetch request ").append(fetchRequest).toString());
                responseData.elem = this.fetchFromLeader(fetchRequest);
                object = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                if (this.isRunning()) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Error in response for fetch request ").append(fetchRequest).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    object = CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                        partitionsWithError.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.partitionStates().partitionSet()).asScala());
                        return this.partitionMapCond().await($this.fetchBackOffMs, TimeUnit.MILLISECONDS);
                    });
                }
                object = BoxedUnit.UNIT;
            }
            this.fetcherStats().requestRate().mark();
            Object object2 = ((Seq)responseData.elem).nonEmpty() ? CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Seq)responseData$1.elem).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                AbstractFetcherThread.$anonfun$processFetchRequest$6(this, fetchStates, partitionsWithError, x0$1);
                return BoxedUnit.UNIT;
            })) : BoxedUnit.UNIT;
            if (!partitionsWithError.nonEmpty()) break block3;
            this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError, "processFetchRequest");
        }
    }

    public void markPartitionsForTruncation(TopicPartition topicPartition, long truncationOffset) {
        this.partitionMapLock().lockInterruptibly();
        try {
            Option$.MODULE$.apply(this.partitionStates().stateValue(topicPartition)).foreach((Function1 & Serializable & scala.Serializable)state -> {
                AbstractFetcherThread.$anonfun$markPartitionsForTruncation$1(this, truncationOffset, topicPartition, state);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    private void markPartitionFailed(TopicPartition topicPartition) {
        this.partitionMapLock().lock();
        try {
            this.failedPartitions.add(topicPartition);
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        finally {
            this.partitionMapLock().unlock();
        }
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Partition ").append(topicPartition).append(" marked as failed").toString());
    }

    public Set<TopicPartition> addPartitions(Map<TopicPartition, OffsetAndEpoch> initialFetchStates) {
        Set set;
        this.partitionMapLock().lockInterruptibly();
        try {
            this.failedPartitions.removeAll((Set<TopicPartition>)initialFetchStates.keySet());
            initialFetchStates.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                AbstractFetcherThread.$anonfun$addPartitions$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            this.partitionMapCond().signalAll();
            set = initialFetchStates.keySet();
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    private void updateFetchOffsetAndMaybeMarkTruncationComplete(Map<TopicPartition, OffsetTruncationState> fetchOffsets) {
        scala.collection.immutable.Map newStates = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitionStates().partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)state -> {
            PartitionFetchState partitionFetchState;
            PartitionFetchState currentFetchState = (PartitionFetchState)state.value();
            Option option = fetchOffsets.get((Object)state.topicPartition());
            if (option instanceof Some) {
                Some some = (Some)option;
                OffsetTruncationState offsetTruncationState = (OffsetTruncationState)some.value();
                Product state2 = offsetTruncationState.truncationCompleted() ? Fetching$.MODULE$ : Truncating$.MODULE$;
                partitionFetchState = new PartitionFetchState(offsetTruncationState.offset(), currentFetchState.currentLeaderEpoch(), currentFetchState.delay(), (ReplicaState)state2);
            } else if (None$.MODULE$.equals(option)) {
                partitionFetchState = currentFetchState;
            } else {
                throw new MatchError((Object)option);
            }
            PartitionFetchState maybeTruncationComplete = partitionFetchState;
            return new Tuple2((Object)state.topicPartition(), (Object)maybeTruncationComplete);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.partitionStates().set((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)newStates).asJava());
    }

    private OffsetTruncationState getOffsetTruncationState(TopicPartition tp, EpochEndOffset leaderEpochOffset) {
        return (OffsetTruncationState)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> {
            OffsetTruncationState offsetTruncationState;
            if (leaderEpochOffset.endOffset() == -1L) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(130).append("Based on replica's leader epoch, leader replied with an unknown offset in ").append(tp).append(". ").append("The initial fetch offset ").append(((PartitionFetchState)this.partitionStates().stateValue(tp)).fetchOffset()).append(" will be used for truncation.").toString());
                offsetTruncationState = new OffsetTruncationState(((PartitionFetchState)this.partitionStates().stateValue(tp)).fetchOffset(), true);
            } else if (leaderEpochOffset.leaderEpoch() == -1) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(170).append("Leader or replica is on protocol version where leader epoch is not considered in the OffsetsForLeaderEpoch response. ").append("The leader's offset ").append(leaderEpochOffset.endOffset()).append(" will be used for truncation in ").append(tp).append(".").toString());
                offsetTruncationState = new OffsetTruncationState(package$.MODULE$.min(leaderEpochOffset.endOffset(), this.logEndOffset(tp)), true);
            } else {
                OffsetTruncationState offsetTruncationState2;
                Some some;
                OffsetAndEpoch offsetAndEpoch;
                long replicaEndOffset = this.logEndOffset(tp);
                Option<OffsetAndEpoch> option = this.endOffsetForEpoch(tp, leaderEpochOffset.leaderEpoch());
                if (option instanceof Some && (offsetAndEpoch = (OffsetAndEpoch)(some = (Some)option).value()) != null) {
                    OffsetTruncationState offsetTruncationState3;
                    long followerEndOffset = offsetAndEpoch.offset();
                    int followerEpoch = offsetAndEpoch.leaderEpoch();
                    if (followerEpoch != leaderEpochOffset.leaderEpoch()) {
                        long intermediateOffsetToTruncateTo = package$.MODULE$.min(followerEndOffset, replicaEndOffset);
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(159).append("Based on replica's leader epoch, leader replied with epoch ").append(leaderEpochOffset.leaderEpoch()).append(" ").append("unknown to the replica for ").append(tp).append(". ").append("Will truncate to ").append(intermediateOffsetToTruncateTo).append(" and send another leader epoch request to the leader.").toString());
                        offsetTruncationState3 = new OffsetTruncationState(intermediateOffsetToTruncateTo, false);
                    } else {
                        long offsetToTruncateTo = package$.MODULE$.min(followerEndOffset, leaderEpochOffset.endOffset());
                        offsetTruncationState3 = new OffsetTruncationState(package$.MODULE$.min(offsetToTruncateTo, replicaEndOffset), true);
                    }
                    offsetTruncationState2 = offsetTruncationState3;
                } else if (None$.MODULE$.equals(option)) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(155).append("Based on replica's leader epoch, leader replied with epoch ").append(leaderEpochOffset.leaderEpoch()).append(" ").append("below any replica's tracked epochs for ").append(tp).append(". ").append("The leader's offset only ").append(leaderEpochOffset.endOffset()).append(" will be used for truncation.").toString());
                    offsetTruncationState2 = new OffsetTruncationState(package$.MODULE$.min(leaderEpochOffset.endOffset(), replicaEndOffset), true);
                } else {
                    throw new MatchError(option);
                }
                offsetTruncationState = offsetTruncationState2;
            }
            return offsetTruncationState;
        });
    }

    private boolean handleOutOfRangeError(TopicPartition topicPartition, PartitionFetchState fetchState, Option<Object> requestEpoch) {
        boolean bl;
        try {
            long newOffset = this.fetchOffsetAndTruncate(topicPartition, fetchState.currentLeaderEpoch());
            PartitionFetchState newFetchState = PartitionFetchState$.MODULE$.apply(newOffset, fetchState.currentLeaderEpoch(), Fetching$.MODULE$);
            this.partitionStates().updateAndMoveToEnd(topicPartition, (Object)newFetchState);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("Current offset ").append(fetchState.fetchOffset()).append(" for partition ").append(topicPartition).append(" is ").append("out of range, which typically implies a leader change. Reset fetch offset to ").append(newOffset).toString());
            bl = false;
        }
        catch (Throwable throwable) {
            boolean bl2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FencedLeaderEpochException) {
                bl2 = this.onPartitionFenced(topicPartition, requestEpoch);
            } else {
                boolean bl3 = throwable2 instanceof UnknownTopicOrPartitionException ? true : (throwable2 instanceof UnknownLeaderEpochException ? true : throwable2 instanceof NotLeaderForPartitionException);
                if (bl3) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Could not fetch offset for ").append(topicPartition).append(" due to error: ").append(throwable2.getMessage()).toString());
                    bl2 = true;
                } else if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error getting offset for partition ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                    bl2 = true;
                } else {
                    throw throwable;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    public long fetchOffsetAndTruncate(TopicPartition topicPartition, int currentLeaderEpoch) {
        long l;
        long replicaEndOffset = this.logEndOffset(topicPartition);
        long leaderEndOffset = this.fetchLatestOffsetFromLeader(topicPartition, currentLeaderEpoch);
        if (leaderEndOffset < replicaEndOffset) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Reset fetch offset for partition ").append(topicPartition).append(" from ").append(replicaEndOffset).append(" to current ").append("leader's latest offset ").append(leaderEndOffset).toString());
            this.truncate(topicPartition, new OffsetTruncationState(leaderEndOffset, true));
            l = leaderEndOffset;
        } else {
            long leaderStartOffset = this.fetchEarliestOffsetFromLeader(topicPartition, currentLeaderEpoch);
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Reset fetch offset for partition ").append(topicPartition).append(" from ").append(replicaEndOffset).append(" to current ").append("leader's start offset ").append(leaderStartOffset).toString());
            long offsetToFetch = Math.max(leaderStartOffset, replicaEndOffset);
            if (leaderStartOffset > replicaEndOffset) {
                this.truncateFullyAndStartAt(topicPartition, leaderStartOffset);
            }
            l = offsetToFetch;
        }
        return l;
    }

    public void delayPartitions(Iterable<TopicPartition> partitions, long delay) {
        this.partitionMapLock().lockInterruptibly();
        try {
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                AbstractFetcherThread.$anonfun$delayPartitions$1(this, delay, partition);
                return BoxedUnit.UNIT;
            });
            this.partitionMapCond().signalAll();
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void removePartitions(Set<TopicPartition> topicPartitions) {
        this.partitionMapLock().lockInterruptibly();
        try {
            topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                AbstractFetcherThread.$anonfun$removePartitions$1(this, topicPartition);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public int partitionCount() {
        int n;
        this.partitionMapLock().lockInterruptibly();
        try {
            n = this.partitionStates().size();
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return n;
    }

    public Option<PartitionFetchState> fetchState(TopicPartition topicPartition) {
        return (Option)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply(this.partitionStates().stateValue(topicPartition)));
    }

    public Map<TopicPartition, InitialFetchState> partitionsAndOffsets() {
        return (Map)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitionStates().partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)state -> {
            InitialFetchState initialFetchState = new InitialFetchState(this.sourceBroker(), ((PartitionFetchState)state.value()).currentLeaderEpoch(), ((PartitionFetchState)state.value()).fetchOffset());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state.topicPartition()), (Object)initialFetchState);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public MemoryRecords toMemoryRecords(Records records) {
        MemoryRecords memoryRecords;
        Records records2 = records;
        if (records2 instanceof MemoryRecords) {
            MemoryRecords memoryRecords2;
            memoryRecords = memoryRecords2 = (MemoryRecords)records2;
        } else if (records2 instanceof FileRecords) {
            FileRecords fileRecords = (FileRecords)records2;
            ByteBuffer buffer = ByteBuffer.allocate(fileRecords.sizeInBytes());
            fileRecords.readInto(buffer, 0);
            memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
        } else {
            throw new MatchError((Object)records2);
        }
        return memoryRecords;
    }

    public static final /* synthetic */ boolean $anonfun$truncateToEpochEndOffsets$2(AbstractFetcherThread $this, Map latestEpochsForPartitions$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        PartitionFetchState curPartitionState = (PartitionFetchState)$this.partitionStates().stateValue(tp);
        OffsetsForLeaderEpochRequest.PartitionData partitionEpochRequest = (OffsetsForLeaderEpochRequest.PartitionData)latestEpochsForPartitions$1.get((Object)tp).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(77).append("Leader replied with partition ").append(tp).append(" not requested in OffsetsForLeaderEpoch request").toString());
        });
        Integer leaderEpochInRequest = (Integer)partitionEpochRequest.currentLeaderEpoch.get();
        boolean bl = curPartitionState != null && BoxesRunTime.equalsNumObject((Number)leaderEpochInRequest, (Object)BoxesRunTime.boxToInteger((int)curPartitionState.currentLeaderEpoch()));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onPartitionFenced$2(AbstractFetcherThread $this, Option requestEpoch$1, TopicPartition tp$4, PartitionFetchState currentFetchState) {
        boolean bl;
        int currentLeaderEpoch = currentFetchState.currentLeaderEpoch();
        if (requestEpoch$1.contains((Object)BoxesRunTime.boxToInteger((int)currentLeaderEpoch))) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(121).append("Partition ").append(tp$4).append(" has an older epoch (").append(currentLeaderEpoch).append(") than the current leader. Will await ").append("the new LeaderAndIsr state before resuming fetching.").toString());
            $this.markPartitionFailed(tp$4);
            bl = false;
        } else {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("Partition ").append(tp$4).append(" has an new epoch (").append(currentLeaderEpoch).append(") than the current leader. retry the partition later").toString());
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$8(AbstractFetcherThread $this, PartitionFetchState currentFetchState$1, TopicPartition topicPartition$2, FetchResponse.PartitionData partitionData$1, PartitionFetchState fetchState$1, LogAppendInfo logAppendInfo) {
        block0: {
            int validBytes = logAppendInfo.validBytes();
            long nextOffset = validBytes > 0 ? logAppendInfo.lastOffset() + 1L : currentFetchState$1.fetchOffset();
            $this.fetcherLagStats().getAndMaybePut(topicPartition$2).lag_$eq(Math.max(0L, partitionData$1.highWatermark - nextOffset));
            if (validBytes <= 0 || !$this.partitionStates().contains(topicPartition$2)) break block0;
            PartitionFetchState newFetchState = PartitionFetchState$.MODULE$.apply(nextOffset, fetchState$1.currentLeaderEpoch(), Fetching$.MODULE$);
            $this.partitionStates().updateAndMoveToEnd(topicPartition$2, (Object)newFetchState);
            $this.fetcherStats().byteRate().mark((long)validBytes);
        }
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$6(AbstractFetcherThread $this, Map fetchStates$2, scala.collection.mutable.Set partitionsWithError$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)tuple2._2();
        Option$.MODULE$.apply($this.partitionStates().stateValue(topicPartition)).foreach((Function1 & Serializable & scala.Serializable)currentFetchState -> {
            BoxedUnit boxedUnit;
            PartitionFetchState fetchState = (PartitionFetchState)fetchStates$2.apply((Object)topicPartition);
            if (fetchState.fetchOffset() == currentFetchState.fetchOffset() && currentFetchState.isReadyForFetch()) {
                BoxedUnit boxedUnit2;
                None$ requestEpoch = fetchState.currentLeaderEpoch() >= 0 ? new Some((Object)BoxesRunTime.boxToInteger((int)fetchState.currentLeaderEpoch())) : None$.MODULE$;
                Errors errors = partitionData$1.error;
                if (Errors.NONE.equals(errors)) {
                    SetLike setLike;
                    try {
                        Option<LogAppendInfo> logAppendInfoOpt = $this.processPartitionData(topicPartition, currentFetchState.fetchOffset(), (FetchResponse.PartitionData<Records>)partitionData);
                        logAppendInfoOpt.foreach((Function1 & Serializable & scala.Serializable)logAppendInfo -> {
                            AbstractFetcherThread.$anonfun$processFetchRequest$8($this, currentFetchState, topicPartition, partitionData, fetchState, logAppendInfo);
                            return BoxedUnit.UNIT;
                        });
                        setLike = BoxedUnit.UNIT;
                    }
                    catch (CorruptRecordException ime) {
                        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Found invalid messages during fetch for partition ").append(topicPartition).append(" ").append("offset ").append(currentFetchState.fetchOffset()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ime);
                        setLike = partitionsWithError$2.$plus$eq((Object)topicPartition);
                    }
                    catch (KafkaStorageException e) {
                        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Error while processing data for partition ").append(topicPartition).append(" ").append("at offset ").append(currentFetchState.fetchOffset()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        $this.markPartitionFailed(topicPartition);
                        setLike = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Unexpected error occurred while processing data for partition ").append(topicPartition).append(" ").append("at offset ").append(currentFetchState.fetchOffset()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                        $this.markPartitionFailed(topicPartition);
                        setLike = BoxedUnit.UNIT;
                    }
                    boxedUnit2 = setLike;
                } else if (Errors.OFFSET_OUT_OF_RANGE.equals(errors)) {
                    boxedUnit2 = $this.handleOutOfRangeError(topicPartition, (PartitionFetchState)currentFetchState, (Option<Object>)requestEpoch) ? partitionsWithError$2.$plus$eq((Object)topicPartition) : BoxedUnit.UNIT;
                } else if (Errors.UNKNOWN_LEADER_EPOCH.equals(errors)) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Remote broker has a smaller leader epoch for partition ").append(topicPartition).append(" than ").append("this replica's current leader epoch of ").append(fetchState.currentLeaderEpoch()).append(".").toString());
                    boxedUnit2 = partitionsWithError$2.$plus$eq((Object)topicPartition);
                } else if (Errors.FENCED_LEADER_EPOCH.equals(errors)) {
                    boxedUnit2 = $this.onPartitionFenced(topicPartition, (Option<Object>)requestEpoch) ? partitionsWithError$2.$plus$eq((Object)topicPartition) : BoxedUnit.UNIT;
                } else if (Errors.NOT_LEADER_FOR_PARTITION.equals(errors)) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(102).append("Remote broker is not the leader for partition ").append(topicPartition).append(", which could indicate ").append("that the partition is being moved").toString());
                    boxedUnit2 = partitionsWithError$2.$plus$eq((Object)topicPartition);
                } else {
                    $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Error for partition ").append(topicPartition).append(" at offset ").append(currentFetchState.fetchOffset()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> partitionData$1.error.exception());
                    boxedUnit2 = partitionsWithError$2.$plus$eq((Object)topicPartition);
                }
                boxedUnit = boxedUnit2;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$markPartitionsForTruncation$1(AbstractFetcherThread $this, long truncationOffset$1, TopicPartition topicPartition$3, PartitionFetchState state) {
        PartitionFetchState newState = new PartitionFetchState(package$.MODULE$.min(truncationOffset$1, state.fetchOffset()), state.currentLeaderEpoch(), state.delay(), Truncating$.MODULE$);
        $this.partitionStates().updateAndMoveToEnd(topicPartition$3, (Object)newState);
        $this.partitionMapCond().signalAll();
    }

    public static final /* synthetic */ void $anonfun$addPartitions$1(AbstractFetcherThread $this, Tuple2 x0$1) {
        PartitionFetchState partitionFetchState;
        TopicPartition tp;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            tp = (TopicPartition)tuple2._1();
            OffsetAndEpoch initialFetchState = (OffsetAndEpoch)tuple2._2();
            PartitionFetchState currentState = (PartitionFetchState)$this.partitionStates().stateValue(tp);
            if (currentState != null && currentState.currentLeaderEpoch() == initialFetchState.leaderEpoch()) {
                partitionFetchState = currentState;
            } else {
                long initialFetchOffset = initialFetchState.offset() < 0L ? $this.fetchOffsetAndTruncate(tp, initialFetchState.leaderEpoch()) : initialFetchState.offset();
                partitionFetchState = PartitionFetchState$.MODULE$.apply(initialFetchOffset, initialFetchState.leaderEpoch(), Truncating$.MODULE$);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        PartitionFetchState updatedState = partitionFetchState;
        $this.partitionStates().updateAndMoveToEnd(tp, (Object)updatedState);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$delayPartitions$2(AbstractFetcherThread $this, TopicPartition partition$1, long delay$1, PartitionFetchState currentFetchState) {
        block0: {
            if (currentFetchState.isDelayed()) break block0;
            $this.partitionStates().updateAndMoveToEnd(partition$1, (Object)new PartitionFetchState(currentFetchState.fetchOffset(), currentFetchState.currentLeaderEpoch(), new DelayedItem(delay$1), currentFetchState.state()));
        }
    }

    public static final /* synthetic */ void $anonfun$delayPartitions$1(AbstractFetcherThread $this, long delay$1, TopicPartition partition) {
        Option$.MODULE$.apply($this.partitionStates().stateValue(partition)).foreach((Function1 & Serializable & scala.Serializable)currentFetchState -> {
            AbstractFetcherThread.$anonfun$delayPartitions$2($this, partition, delay$1, currentFetchState);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removePartitions$1(AbstractFetcherThread $this, TopicPartition topicPartition) {
        $this.partitionStates().remove(topicPartition);
        $this.fetcherLagStats().unregister(topicPartition);
    }

    public AbstractFetcherThread(String name, String clientId, BrokerEndPoint sourceBroker, FailedPartitions failedPartitions, int fetchBackOffMs, boolean isInterruptible) {
        this.sourceBroker = sourceBroker;
        this.failedPartitions = failedPartitions;
        this.fetchBackOffMs = fetchBackOffMs;
        super(name, isInterruptible);
        this.partitionStates = new PartitionStates();
        this.partitionMapLock = new ReentrantLock();
        this.partitionMapCond = this.partitionMapLock().newCondition();
        this.metricId = new ClientIdAndBroker(clientId, sourceBroker.host(), sourceBroker.port());
        this.fetcherStats = new FetcherStats(this.metricId());
        this.fetcherLagStats = new FetcherLagStats(this.metricId());
    }

    public static class ResultWithPartitions<R>
    implements Product,
    scala.Serializable {
        private final R result;
        private final Set<TopicPartition> partitionsWithError;

        public R result() {
            return this.result;
        }

        public Set<TopicPartition> partitionsWithError() {
            return this.partitionsWithError;
        }

        public <R> ResultWithPartitions<R> copy(R result, Set<TopicPartition> partitionsWithError) {
            return new ResultWithPartitions<R>(result, partitionsWithError);
        }

        public <R> R copy$default$1() {
            return this.result();
        }

        public <R> Set<TopicPartition> copy$default$2() {
            return this.partitionsWithError();
        }

        public String productPrefix() {
            return "ResultWithPartitions";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.result();
                    break;
                }
                case 1: {
                    object = this.partitionsWithError();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResultWithPartitions;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResultWithPartitions)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResultWithPartitions resultWithPartitions = (ResultWithPartitions)x$1;
            if (!BoxesRunTime.equals(this.result(), resultWithPartitions.result())) return false;
            Set<TopicPartition> set = this.partitionsWithError();
            Set<TopicPartition> set2 = resultWithPartitions.partitionsWithError();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (!resultWithPartitions.canEqual(this)) return false;
            return true;
        }

        public ResultWithPartitions(R result, Set<TopicPartition> partitionsWithError) {
            this.result = result;
            this.partitionsWithError = partitionsWithError;
            Product.$init$((Product)this);
        }
    }
}

