/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import kafka.log.BatchMetadata;
import kafka.log.ProducerStateEntry$;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001duA\u0002\u0014(\u0011\u000393F\u0002\u0004.O!\u0005qE\f\u0005\u0006k\u0005!\ta\u000e\u0005\tq\u0005\u0011\r\u0011\"\u0001(s!1Q(\u0001Q\u0001\niBQAP\u0001\u0005\u0002}2Q!L\u0014\u0001O\u0005C\u0001B\u0011\u0004\u0003\u0006\u0004%\ta\u0011\u0005\t\u000f\u001a\u0011\t\u0011)A\u0005\t\"A\u0001J\u0002BC\u0002\u0013\u0005\u0011\n\u0003\u0005V\r\t\u0005\t\u0015!\u0003K\u0011!1fA!a\u0001\n\u00039\u0006\u0002C.\u0007\u0005\u0003\u0007I\u0011\u0001/\t\u0011\t4!\u0011!Q!\naC\u0001b\u0019\u0004\u0003\u0002\u0004%\t!\u000f\u0005\tI\u001a\u0011\t\u0019!C\u0001K\"AqM\u0002B\u0001B\u0003&!\b\u0003\u0005i\r\t\u0005\r\u0011\"\u0001D\u0011!IgA!a\u0001\n\u0003Q\u0007\u0002\u00037\u0007\u0005\u0003\u0005\u000b\u0015\u0002#\t\u001154!\u00111A\u0005\u00029D\u0001B\u001d\u0004\u0003\u0002\u0004%\ta\u001d\u0005\tk\u001a\u0011\t\u0011)Q\u0005_\")QG\u0002C\u0001m\")QP\u0002C\u0001s!)aP\u0002C\u0001\u0007\")qP\u0002C\u0001s!1\u0011\u0011\u0001\u0004\u0005\u0002\rCa!a\u0001\u0007\t\u0003I\u0004bBA\u0003\r\u0011\u0005\u0011q\u0001\u0005\b\u0003\u001f1A\u0011AA\t\u0011\u001d\t\u0019C\u0002C\u0001\u0003KAq!!\u000b\u0007\t\u0013\tY\u0003C\u0004\u00022\u0019!\t!a\r\t\u000f\u0005eb\u0001\"\u0001\u0002<!9\u0011\u0011\t\u0004\u0005\u0002\u0005\r\u0003bBA2\r\u0011\u0005\u0011Q\r\u0005\b\u0003W2A\u0011IA7\u0003I\u0001&o\u001c3vG\u0016\u00148\u000b^1uK\u0016sGO]=\u000b\u0005!J\u0013a\u00017pO*\t!&A\u0003lC\u001a\\\u0017\r\u0005\u0002-\u00035\tqE\u0001\nQe>$WoY3s'R\fG/Z#oiJL8CA\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001,\u0003IqU/\u001c\"bi\u000eDWm\u001d+p%\u0016$\u0018-\u001b8\u0016\u0003i\u0002\"\u0001M\u001e\n\u0005q\n$aA%oi\u0006\u0019b*^7CCR\u001c\u0007.Z:U_J+G/Y5oA\u0005)Q-\u001c9usR\u0019\u0001)!\"\u0011\u0005121C\u0001\u00040\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\nZ\u000b\u0002\tB\u0011\u0001'R\u0005\u0003\rF\u0012A\u0001T8oO\u0006Y\u0001O]8ek\u000e,'/\u00133!\u00035\u0011\u0017\r^2i\u001b\u0016$\u0018\rZ1uCV\t!\nE\u0002L!Jk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bq!\\;uC\ndWM\u0003\u0002Pc\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ec%!B)vKV,\u0007C\u0001\u0017T\u0013\t!vEA\u0007CCR\u001c\u0007.T3uC\u0012\fG/Y\u0001\u000fE\u0006$8\r['fi\u0006$\u0017\r^1!\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQV\t\u0001\f\u0005\u000213&\u0011!,\r\u0002\u0006'\"|'\u000f^\u0001\u0012aJ|G-^2fe\u0016\u0003xn\u00195`I\u0015\fHCA/a!\t\u0001d,\u0003\u0002`c\t!QK\\5u\u0011\u001d\tG\"!AA\u0002a\u000b1\u0001\u001f\u00132\u00039\u0001(o\u001c3vG\u0016\u0014X\t]8dQ\u0002\n\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002)\r|wN\u001d3j]\u0006$xN]#q_\u000eDw\fJ3r)\tif\rC\u0004b\u001f\u0005\u0005\t\u0019\u0001\u001e\u0002#\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007%A\u0007mCN$H+[7fgR\fW\u000e]\u0001\u0012Y\u0006\u001cH\u000fV5nKN$\u0018-\u001c9`I\u0015\fHCA/l\u0011\u001d\t'#!AA\u0002\u0011\u000ba\u0002\\1tiRKW.Z:uC6\u0004\b%A\u000bdkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;\u0016\u0003=\u00042\u0001\r9E\u0013\t\t\u0018G\u0001\u0004PaRLwN\\\u0001\u001aGV\u0014(/\u001a8u)btg)\u001b:ti>3gm]3u?\u0012*\u0017\u000f\u0006\u0002^i\"9\u0011-FA\u0001\u0002\u0004y\u0017AF2veJ,g\u000e\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r\u001e\u0011\u0015\u000f\u0001;\b0\u001f>|y\")!i\u0006a\u0001\t\")\u0001j\u0006a\u0001\u0015\")ak\u0006a\u00011\")1m\u0006a\u0001u!)\u0001n\u0006a\u0001\t\")Qn\u0006a\u0001_\u0006Aa-\u001b:tiN+\u0017/A\bgSJ\u001cH\u000fR1uC>3gm]3u\u0003\u001da\u0017m\u001d;TKF\fa\u0002\\1ti\u0012\u000bG/Y(gMN,G/A\bmCN$xJ\u001a4tKR$U\r\u001c;b\u0003\u001dI7/R7qif,\"!!\u0003\u0011\u0007A\nY!C\u0002\u0002\u000eE\u0012qAQ8pY\u0016\fg.\u0001\u0005bI\u0012\u0014\u0015\r^2i)-i\u00161CA\u000b\u0003/\tY\"a\b\t\u000bYs\u0002\u0019\u0001-\t\u000b}t\u0002\u0019\u0001\u001e\t\r\u0005ea\u00041\u0001E\u0003)a\u0017m\u001d;PM\u001a\u001cX\r\u001e\u0005\u0007\u0003;q\u0002\u0019\u0001\u001e\u0002\u0017=4gm]3u\t\u0016dG/\u0019\u0005\u0007\u0003Cq\u0002\u0019\u0001#\u0002\u0013QLW.Z:uC6\u0004\u0018\u0001G7bs\n,W\u000b\u001d3bi\u0016\u0004&o\u001c3vG\u0016\u0014X\t]8dQR!\u0011\u0011BA\u0014\u0011\u00151v\u00041\u0001Y\u0003A\tG\r\u001a\"bi\u000eDW*\u001a;bI\u0006$\u0018\rF\u0002^\u0003[Aa!a\f!\u0001\u0004\u0011\u0016!\u00022bi\u000eD\u0017AB;qI\u0006$X\rF\u0002^\u0003kAa!a\u000e\"\u0001\u0004\u0001\u0015!\u00038fqR,e\u000e\u001e:z\u0003Y\u0011X-\\8wK\n\u000bGo\u00195fg>cG-\u001a:UQ\u0006tGcA/\u0002>!1\u0011q\b\u0012A\u0002\u0011\u000baa\u001c4gg\u0016$\u0018A\u00054j]\u0012$U\u000f\u001d7jG\u0006$XMQ1uG\"$B!!\u0012\u0002HA\u0019\u0001\u0007\u001d*\t\u000f\u0005=2\u00051\u0001\u0002JA!\u00111JA0\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013A\u0002:fG>\u0014HM\u0003\u0003\u0002T\u0005U\u0013AB2p[6|gNC\u0002+\u0003/RA!!\u0017\u0002\\\u00051\u0011\r]1dQ\u0016T!!!\u0018\u0002\u0007=\u0014x-\u0003\u0003\u0002b\u00055#a\u0003*fG>\u0014HMQ1uG\"\faCY1uG\"<\u0016\u000e\u001e5TKF,XM\\2f%\u0006tw-\u001a\u000b\u0007\u0003\u000b\n9'!\u001b\t\u000bu$\u0003\u0019\u0001\u001e\t\u000b}$\u0003\u0019\u0001\u001e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001c\u0011\t\u0005E\u0014q\u0010\b\u0005\u0003g\nY\bE\u0002\u0002vEj!!a\u001e\u000b\u0007\u0005ed'\u0001\u0004=e>|GOP\u0005\u0004\u0003{\n\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0002\u0006\r%AB*ue&twMC\u0002\u0002~EBQAQ\u0003A\u0002\u0011\u0003")
public class ProducerStateEntry {
    private final long producerId;
    private final Queue<BatchMetadata> batchMetadata;
    private short producerEpoch;
    private int coordinatorEpoch;
    private long lastTimestamp;
    private Option<Object> currentTxnFirstOffset;

    public static ProducerStateEntry empty(long l) {
        return ProducerStateEntry$.MODULE$.empty(l);
    }

    public long producerId() {
        return this.producerId;
    }

    public Queue<BatchMetadata> batchMetadata() {
        return this.batchMetadata;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public void coordinatorEpoch_$eq(int x$1) {
        this.coordinatorEpoch = x$1;
    }

    public long lastTimestamp() {
        return this.lastTimestamp;
    }

    public void lastTimestamp_$eq(long x$1) {
        this.lastTimestamp = x$1;
    }

    public Option<Object> currentTxnFirstOffset() {
        return this.currentTxnFirstOffset;
    }

    public void currentTxnFirstOffset_$eq(Option<Object> x$1) {
        this.currentTxnFirstOffset = x$1;
    }

    public int firstSeq() {
        return this.isEmpty() ? -1 : ((BatchMetadata)this.batchMetadata().front()).firstSeq();
    }

    public long firstDataOffset() {
        return this.isEmpty() ? -1L : ((BatchMetadata)this.batchMetadata().front()).firstOffset();
    }

    public int lastSeq() {
        return this.isEmpty() ? -1 : ((BatchMetadata)this.batchMetadata().last()).lastSeq();
    }

    public long lastDataOffset() {
        return this.isEmpty() ? -1L : ((BatchMetadata)this.batchMetadata().last()).lastOffset();
    }

    public int lastOffsetDelta() {
        return this.isEmpty() ? 0 : ((BatchMetadata)this.batchMetadata().last()).offsetDelta();
    }

    public boolean isEmpty() {
        return this.batchMetadata().isEmpty();
    }

    public void addBatch(short producerEpoch, int lastSeq, long lastOffset, int offsetDelta, long timestamp) {
        this.maybeUpdateProducerEpoch(producerEpoch);
        this.addBatchMetadata(new BatchMetadata(lastSeq, lastOffset, offsetDelta, timestamp));
        this.lastTimestamp_$eq(timestamp);
    }

    public boolean maybeUpdateProducerEpoch(short producerEpoch) {
        boolean bl;
        if (this.producerEpoch() != producerEpoch) {
            this.batchMetadata().clear();
            this.producerEpoch_$eq(producerEpoch);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void addBatchMetadata(BatchMetadata batch) {
        Object object = this.batchMetadata().size() == ProducerStateEntry$.MODULE$.NumBatchesToRetain() ? this.batchMetadata().dequeue() : BoxedUnit.UNIT;
        this.batchMetadata().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{batch}));
    }

    public void update(ProducerStateEntry nextEntry) {
        this.maybeUpdateProducerEpoch(nextEntry.producerEpoch());
        while (nextEntry.batchMetadata().nonEmpty()) {
            this.addBatchMetadata((BatchMetadata)nextEntry.batchMetadata().dequeue());
        }
        this.coordinatorEpoch_$eq(nextEntry.coordinatorEpoch());
        this.currentTxnFirstOffset_$eq(nextEntry.currentTxnFirstOffset());
        this.lastTimestamp_$eq(nextEntry.lastTimestamp());
    }

    public void removeBatchesOlderThan(long offset) {
        this.batchMetadata().dropWhile((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateEntry.$anonfun$removeBatchesOlderThan$1(offset, x$1)));
    }

    public Option<BatchMetadata> findDuplicateBatch(RecordBatch batch) {
        return batch.producerEpoch() != this.producerEpoch() ? None$.MODULE$ : this.batchWithSequenceRange(batch.baseSequence(), batch.lastSequence());
    }

    public Option<BatchMetadata> batchWithSequenceRange(int firstSeq, int lastSeq) {
        Queue duplicate = (Queue)this.batchMetadata().filter((Function1 & java.io.Serializable & Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)ProducerStateEntry.$anonfun$batchWithSequenceRange$1(firstSeq, lastSeq, metadata)));
        return duplicate.headOption();
    }

    public String toString() {
        return new StringBuilder(121).append("ProducerStateEntry(").append("producerId=").append(this.producerId()).append(", ").append("producerEpoch=").append(this.producerEpoch()).append(", ").append("currentTxnFirstOffset=").append(this.currentTxnFirstOffset()).append(", ").append("coordinatorEpoch=").append(this.coordinatorEpoch()).append(", ").append("lastTimestamp=").append(this.lastTimestamp()).append(", ").append("batchMetadata=").append(this.batchMetadata()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$removeBatchesOlderThan$1(long offset$1, BatchMetadata x$1) {
        return x$1.lastOffset() < offset$1;
    }

    public static final /* synthetic */ boolean $anonfun$batchWithSequenceRange$1(int firstSeq$1, int lastSeq$1, BatchMetadata metadata) {
        return firstSeq$1 == metadata.firstSeq() && lastSeq$1 == metadata.lastSeq();
    }

    public ProducerStateEntry(long producerId, Queue<BatchMetadata> batchMetadata, short producerEpoch, int coordinatorEpoch, long lastTimestamp, Option<Object> currentTxnFirstOffset) {
        this.producerId = producerId;
        this.batchMetadata = batchMetadata;
        this.producerEpoch = producerEpoch;
        this.coordinatorEpoch = coordinatorEpoch;
        this.lastTimestamp = lastTimestamp;
        this.currentTxnFirstOffset = currentTxnFirstOffset;
    }
}

