/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Iterator;
import kafka.log.AppendOrigin;
import kafka.log.AppendOrigin$Client$;
import kafka.log.AppendOrigin$Replication$;
import kafka.log.CompletedTxn;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.TxnMetadata;
import kafka.log.TxnMetadata$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ef!\u0002\u000e\u001c\u0001my\u0002\u0002\u0003\u0017\u0001\u0005\u000b\u0007I\u0011\u0001\u0018\t\u0011i\u0002!\u0011!Q\u0001\n=B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005{!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003D\u0011!A\u0005A!b\u0001\n\u0003I\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u000b9\u0003A\u0011A(\t\u000fU\u0003!\u0019!C\u0005-\"1!\r\u0001Q\u0001\n]Cqa\u0019\u0001C\u0002\u0013%!\t\u0003\u0004e\u0001\u0001\u0006Ia\u0011\u0005\u0006K\u0002!IA\u001a\u0005\u0006m\u0002!Ia\u001e\u0005\u0006u\u0002!Ia\u001f\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+Aq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002b\u0001!I!a\u0019\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!1\u0011q\u0010\u0001\u0005\u0002\tCq!!!\u0001\t\u0003\t\u0019\tC\u0004\u0002\u001e\u0002!\t!a(\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\n\u0011\u0002K]8ek\u000e,'/\u00119qK:$\u0017J\u001c4p\u0015\taR$A\u0002m_\u001eT\u0011AH\u0001\u0006W\u000647.Y\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(U5\t\u0001F\u0003\u0002*;\u0005)Q\u000f^5mg&\u00111\u0006\u000b\u0002\b\u0019><w-\u001b8h\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\u0001!F\u00010!\t\u0001\u0004(D\u00012\u0015\t\u00114'\u0001\u0004d_6lwN\u001c\u0006\u0003=QR!!\u000e\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0014aA8sO&\u0011\u0011(\r\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013A\u00039s_\u0012,8-\u001a:JIV\tQ\b\u0005\u0002\"}%\u0011qH\t\u0002\u0005\u0019>tw-A\u0006qe>$WoY3s\u0013\u0012\u0004\u0013\u0001D2veJ,g\u000e^#oiJLX#A\"\u0011\u0005\u0011+U\"A\u000e\n\u0005\u0019[\"A\u0005)s_\u0012,8-\u001a:Ti\u0006$X-\u00128uef\fQbY;se\u0016tG/\u00128uef\u0004\u0013AB8sS\u001eLg.F\u0001K!\t!5*\u0003\u0002M7\ta\u0011\t\u001d9f]\u0012|%/[4j]\u00069qN]5hS:\u0004\u0013A\u0002\u001fj]&$h\bF\u0003Q#J\u001bF\u000b\u0005\u0002E\u0001!)A&\u0003a\u0001_!)1(\u0003a\u0001{!)\u0011)\u0003a\u0001\u0007\")\u0001*\u0003a\u0001\u0015\u0006aAO]1og\u0006\u001cG/[8ogV\tq\u000bE\u0002Y;~k\u0011!\u0017\u0006\u00035n\u000bq!\\;uC\ndWM\u0003\u0002]E\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005yK&A\u0003'jgR\u0014UO\u001a4feB\u0011A\tY\u0005\u0003Cn\u00111\u0002\u0016=o\u001b\u0016$\u0018\rZ1uC\u0006iAO]1og\u0006\u001cG/[8og\u0002\nA\"\u001e9eCR,G-\u00128uef\fQ\"\u001e9eCR,G-\u00128uef\u0004\u0013AF7bs\n,g+\u00197jI\u0006$X\rR1uC\n\u000bGo\u00195\u0015\t\u001dTw\u000e\u001e\t\u0003C!L!!\u001b\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006W:\u0001\r\u0001\\\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0005\u0005j\u0017B\u00018#\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0015\u0001h\u00021\u0001r\u0003!1\u0017N]:u'\u0016\f\bCA\u0011s\u0013\t\u0019(EA\u0002J]RDQ!\u001e\bA\u0002u\naa\u001c4gg\u0016$\u0018AE2iK\u000e\\\u0007K]8ek\u000e,'/\u00129pG\"$2a\u001a=z\u0011\u0015Yw\u00021\u0001m\u0011\u0015)x\u00021\u0001>\u00035\u0019\u0007.Z2l'\u0016\fX/\u001a8dKR!q\r`?\u0000\u0011\u0015Y\u0007\u00031\u0001m\u0011\u0015q\b\u00031\u0001r\u00039\t\u0007\u000f]3oI\u001aK'o\u001d;TKFDQ!\u001e\tA\u0002u\n!\"\u001b8TKF,XM\\2f)\u0019\t)!a\u0003\u0002\u0010A\u0019\u0011%a\u0002\n\u0007\u0005%!EA\u0004C_>dW-\u00198\t\r\u00055\u0011\u00031\u0001r\u0003\u001da\u0017m\u001d;TKFDa!!\u0005\u0012\u0001\u0004\t\u0018a\u00028fqR\u001cV-]\u0001\u0007CB\u0004XM\u001c3\u0015\r\u0005]\u00111EA\u001a!\u0015\t\u0013\u0011DA\u000f\u0013\r\tYB\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u0011\u000by\"C\u0002\u0002\"m\u0011AbQ8na2,G/\u001a3Uq:Dq!!\n\u0013\u0001\u0004\t9#A\u0003cCR\u001c\u0007\u000e\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ti#M\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005E\u00121\u0006\u0002\f%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000eC\u0004\u00026I\u0001\r!a\u000e\u0002-\u0019L'o\u001d;PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1PaR\u0004R!IA\r\u0003s\u0001B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007fi\u0012AB:feZ,'/\u0003\u0003\u0002D\u0005u\"!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uC\u0006y\u0011\r\u001d9f]\u0012$\u0015\r^1CCR\u001c\u0007\u000eF\bh\u0003\u0013\ni%a\u0014\u0002R\u0005U\u0013\u0011LA/\u0011\u0019\tYe\u0005a\u0001Y\u0006)Q\r]8dQ\")\u0001o\u0005a\u0001c\"1\u0011QB\nA\u0002EDa!a\u0015\u0014\u0001\u0004i\u0014!\u00047bgR$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0002XM\u0001\r!!\u000f\u0002'\u0019L'o\u001d;PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\t\r\u0005m3\u00031\u0001>\u0003)a\u0017m\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0003?\u001a\u0002\u0019AA\u0003\u0003=I7\u000f\u0016:b]N\f7\r^5p]\u0006d\u0017!F2iK\u000e\\7i\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u000b\u0006O\u0006\u0015\u0014q\u000e\u0005\b\u0003O\"\u0002\u0019AA5\u00031)g\u000e\u001a+y]6\u000b'o[3s!\u0011\tI#a\u001b\n\t\u00055\u00141\u0006\u0002\u0015\u000b:$GK]1og\u0006\u001cG/[8o\u001b\u0006\u00148.\u001a:\t\u000bU$\u0002\u0019A\u001f\u0002%\u0005\u0004\b/\u001a8e\u000b:$G\u000b\u001f8NCJ\\WM\u001d\u000b\u000b\u0003;\t)(a\u001e\u0002z\u0005m\u0004bBA4+\u0001\u0007\u0011\u0011\u000e\u0005\u0006WV\u0001\r\u0001\u001c\u0005\u0006kV\u0001\r!\u0010\u0005\u0007\u0003{*\u0002\u0019A\u001f\u0002\u0013QLW.Z:uC6\u0004\u0018a\u0002;p\u000b:$(/_\u0001\u0014gR\f'\u000f^3e)J\fgn]1di&|gn]\u000b\u0003\u0003\u000b\u0003R!a\"\u0002\u0018~sA!!#\u0002\u0014:!\u00111RAI\u001b\t\tiIC\u0002\u0002\u00106\na\u0001\u0010:p_Rt\u0014\"A\u0012\n\u0007\u0005U%%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00151\u0014\u0002\u0005\u0019&\u001cHOC\u0002\u0002\u0016\n\n\u0001%\\1zE\u0016\u001c\u0015m\u00195f)btg)\u001b:ti>3gm]3u\u001b\u0016$\u0018\rZ1uCR\u0019q-!)\t\u000f\u0005\r\u0006\u00041\u0001\u0002:\u0005\tBn\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!+\u0011\t\u0005-\u00161\u0017\b\u0005\u0003[\u000by\u000bE\u0002\u0002\f\nJ1!!-#\u0003\u0019\u0001&/\u001a3fM&!\u0011QWA\\\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0017\u0012")
public class ProducerAppendInfo
implements Logging {
    private final TopicPartition topicPartition;
    private final long producerId;
    private final ProducerStateEntry currentEntry;
    private final AppendOrigin origin;
    private final ListBuffer<TxnMetadata> transactions;
    private final ProducerStateEntry updatedEntry;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ProducerAppendInfo producerAppendInfo = this;
        synchronized (producerAppendInfo) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public long producerId() {
        return this.producerId;
    }

    public ProducerStateEntry currentEntry() {
        return this.currentEntry;
    }

    public AppendOrigin origin() {
        return this.origin;
    }

    private ListBuffer<TxnMetadata> transactions() {
        return this.transactions;
    }

    private ProducerStateEntry updatedEntry() {
        return this.updatedEntry;
    }

    private void maybeValidateDataBatch(short producerEpoch, int firstSeq, long offset) {
        block0: {
            this.checkProducerEpoch(producerEpoch, offset);
            AppendOrigin appendOrigin = this.origin();
            AppendOrigin$Client$ appendOrigin$Client$ = AppendOrigin$Client$.MODULE$;
            if (appendOrigin != null ? !appendOrigin.equals(appendOrigin$Client$) : appendOrigin$Client$ != null) break block0;
            this.checkSequence(producerEpoch, firstSeq, offset);
        }
    }

    private void checkProducerEpoch(short producerEpoch, long offset) {
        if (producerEpoch < this.updatedEntry().producerEpoch()) {
            String message = new StringBuilder(79).append("Producer's epoch at offset ").append(offset).append(" in ").append(this.topicPartition()).append(" is ").append(producerEpoch).append(", which is ").append("smaller than the last seen epoch ").append(this.updatedEntry().producerEpoch()).toString();
            AppendOrigin appendOrigin = this.origin();
            AppendOrigin$Replication$ appendOrigin$Replication$ = AppendOrigin$Replication$.MODULE$;
            if (!(appendOrigin != null ? !appendOrigin.equals(appendOrigin$Replication$) : appendOrigin$Replication$ != null)) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            } else {
                throw new ProducerFencedException(message);
            }
        }
    }

    private void checkSequence(short producerEpoch, int appendFirstSeq, long offset) {
        if (producerEpoch != this.updatedEntry().producerEpoch()) {
            if (appendFirstSeq != 0) {
                if (this.updatedEntry().producerEpoch() != -1) {
                    throw new OutOfOrderSequenceException(new StringBuilder(96).append("Invalid sequence number for new epoch at offset ").append(offset).append(" in ").append("partition ").append(this.topicPartition()).append(": ").append(producerEpoch).append(" (request epoch), ").append(appendFirstSeq).append(" (seq. number)").toString());
                }
                throw new UnknownProducerIdException(new StringBuilder(180).append("Found no record of producerId=").append(this.producerId()).append(" on the broker at offset ").append(offset).append("in partition ").append(this.topicPartition()).append(". It is possible that the last message with the producerId=").append(this.producerId()).append(" has ").append("been removed due to hitting the retention limit.").toString());
            }
        } else {
            int currentLastSeq;
            int n = !this.updatedEntry().isEmpty() ? this.updatedEntry().lastSeq() : (currentLastSeq = producerEpoch == this.currentEntry().producerEpoch() ? this.currentEntry().lastSeq() : -1);
            if (currentLastSeq == -1 && appendFirstSeq != 0) {
                throw new UnknownProducerIdException(new StringBuilder(138).append("Local producer state matches expected epoch ").append(producerEpoch).append(" ").append("for producerId=").append(this.producerId()).append(" at offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(", but the next expected ").append("sequence number is not known.").toString());
            }
            if (!this.inSequence(currentLastSeq, appendFirstSeq)) {
                throw new OutOfOrderSequenceException(new StringBuilder(126).append("Out of order sequence number for producerId ").append(this.producerId()).append(" at ").append("offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(": ").append(appendFirstSeq).append(" (incoming seq. number), ").append(currentLastSeq).append(" (current end sequence number)").toString());
            }
        }
    }

    private boolean inSequence(int lastSeq, int nextSeq) {
        return (long)nextSeq == (long)lastSeq + 1L || nextSeq == 0 && lastSeq == Integer.MAX_VALUE;
    }

    public Option<CompletedTxn> append(RecordBatch batch, Option<LogOffsetMetadata> firstOffsetMetadataOpt) {
        None$ none$;
        if (batch.isControlBatch()) {
            Iterator recordIterator = batch.iterator();
            if (recordIterator.hasNext()) {
                Record record = (Record)recordIterator.next();
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record);
                CompletedTxn completedTxn = this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record.timestamp());
                none$ = new Some((Object)completedTxn);
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            LogOffsetMetadata firstOffsetMetadata = (LogOffsetMetadata)firstOffsetMetadataOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> new LogOffsetMetadata(batch.baseOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
            this.appendDataBatch(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), firstOffsetMetadata, batch.lastOffset(), batch.isTransactional());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void appendDataBatch(short epoch, int firstSeq, int lastSeq, long lastTimestamp, LogOffsetMetadata firstOffsetMetadata, long lastOffset, boolean isTransactional) {
        long firstOffset = firstOffsetMetadata.messageOffset();
        this.maybeValidateDataBatch(epoch, firstSeq, firstOffset);
        this.updatedEntry().addBatch(epoch, lastSeq, lastOffset, (int)(lastOffset - firstOffset), lastTimestamp);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some && !isTransactional) {
            throw new InvalidTxnStateException(new StringBuilder(68).append("Expected transactional write from producer ").append(this.producerId()).append(" at ").append("offset ").append(firstOffset).append(" in partition ").append(this.topicPartition()).toString());
        }
        if (None$.MODULE$.equals(option) && isTransactional) {
            this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)firstOffset)));
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), firstOffsetMetadata, TxnMetadata$.MODULE$.apply$default$3()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void checkCoordinatorEpoch(EndTransactionMarker endTxnMarker, long offset) {
        if (this.updatedEntry().coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
            AppendOrigin appendOrigin = this.origin();
            AppendOrigin$Replication$ appendOrigin$Replication$ = AppendOrigin$Replication$.MODULE$;
            if (!(appendOrigin != null ? !appendOrigin.equals(appendOrigin$Replication$) : appendOrigin$Replication$ != null)) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(127).append("Detected invalid coordinator epoch for producerId ").append(this.producerId()).append(" at ").append("offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(": ").append(endTxnMarker.coordinatorEpoch()).append(" ").append("is older than previously known coordinator epoch ").append(this.updatedEntry().coordinatorEpoch()).toString());
            } else {
                throw new TransactionCoordinatorFencedException(new StringBuilder(89).append("Invalid coordinator epoch for producerId ").append(this.producerId()).append(" at ").append("offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(": ").append(endTxnMarker.coordinatorEpoch()).append(" ").append("(zombie), ").append(this.updatedEntry().coordinatorEpoch()).append(" (current)").toString());
            }
        }
    }

    public CompletedTxn appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset, long timestamp) {
        long l;
        this.checkProducerEpoch(producerEpoch, offset);
        this.checkCoordinatorEpoch(endTxnMarker, offset);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some) {
            long txnFirstOffset;
            Some some = (Some)option;
            l = txnFirstOffset = BoxesRunTime.unboxToLong((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), offset));
            l = offset;
        } else {
            throw new MatchError(option);
        }
        long firstOffset = l;
        this.updatedEntry().maybeUpdateProducerEpoch(producerEpoch);
        this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)None$.MODULE$);
        this.updatedEntry().coordinatorEpoch_$eq(endTxnMarker.coordinatorEpoch());
        this.updatedEntry().lastTimestamp_$eq(timestamp);
        ControlRecordType controlRecordType = endTxnMarker.controlType();
        ControlRecordType controlRecordType2 = ControlRecordType.ABORT;
        return new CompletedTxn(this.producerId(), firstOffset, offset, !(controlRecordType != null ? !controlRecordType.equals(controlRecordType2) : controlRecordType2 != null));
    }

    public ProducerStateEntry toEntry() {
        return this.updatedEntry();
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions().toList();
    }

    public void maybeCacheTxnFirstOffsetMetadata(LogOffsetMetadata logOffsetMetadata) {
        this.transactions().headOption().foreach((Function1 & Serializable & scala.Serializable)txn -> {
            ProducerAppendInfo.$anonfun$maybeCacheTxnFirstOffsetMetadata$1(logOffsetMetadata, txn);
            return BoxedUnit.UNIT;
        });
    }

    public String toString() {
        return new StringBuilder(159).append("ProducerAppendInfo(").append("producerId=").append(this.producerId()).append(", ").append("producerEpoch=").append(this.updatedEntry().producerEpoch()).append(", ").append("firstSequence=").append(this.updatedEntry().firstSeq()).append(", ").append("lastSequence=").append(this.updatedEntry().lastSeq()).append(", ").append("currentTxnFirstOffset=").append(this.updatedEntry().currentTxnFirstOffset()).append(", ").append("coordinatorEpoch=").append(this.updatedEntry().coordinatorEpoch()).append(", ").append("lastTimestamp=").append(this.updatedEntry().lastTimestamp()).append(", ").append("startedTransactions=").append(this.transactions()).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$maybeCacheTxnFirstOffsetMetadata$1(LogOffsetMetadata logOffsetMetadata$1, TxnMetadata txn) {
        block0: {
            if (txn.firstOffset().messageOffset() != logOffsetMetadata$1.messageOffset()) break block0;
            txn.firstOffset_$eq(logOffsetMetadata$1);
        }
    }

    public ProducerAppendInfo(TopicPartition topicPartition, long producerId, ProducerStateEntry currentEntry, AppendOrigin origin) {
        this.topicPartition = topicPartition;
        this.producerId = producerId;
        this.currentEntry = currentEntry;
        this.origin = origin;
        Logging.$init$(this);
        this.transactions = (ListBuffer)ListBuffer$.MODULE$.empty();
        this.updatedEntry = ProducerStateEntry$.MODULE$.empty(producerId);
        this.updatedEntry().producerEpoch_$eq(currentEntry.producerEpoch());
        this.updatedEntry().coordinatorEpoch_$eq(currentEntry.coordinatorEpoch());
        this.updatedEntry().lastTimestamp_$eq(currentEntry.lastTimestamp());
        this.updatedEntry().currentTxnFirstOffset_$eq(currentEntry.currentTxnFirstOffset());
    }
}

