/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\r\u001da\u0001B\u001f?\u0001\rC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tC\u0002\u0011)\u0019!C\u0001E\"Aq\u000f\u0001B\u0001B\u0003%1\r\u0003\u0005y\u0001\t\u0015\r\u0011\"\u0001z\u0011%\t9\u0002\u0001B\u0001B\u0003%!\u0010\u0003\u0006\u0002\u001a\u0001\u0011)\u0019!C\u0001\u00037A!\"a\t\u0001\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\t)\u0003\u0001B\u0001B\u0003%\u0011q\u0005\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011%\t\t\u0005\u0001a\u0001\n\u0013\t\u0019\u0005C\u0005\u0002F\u0001\u0001\r\u0011\"\u0003\u0002H!9\u00111\u000b\u0001!B\u0013i\u0006BCA/\u0001\t\u0007I\u0011\u0001 \u0002`!A\u0011q\r\u0001!\u0002\u0013\t\t\u0007C\u0005\u0002j\u0001\u0011\r\u0011\"\u0003\u0002l!A\u00111\u000f\u0001!\u0002\u0013\ti\u0007C\u0005\u0002v\u0001\u0011\r\u0011\"\u0003\u0002x!A!q\u0007\u0001!\u0002\u0013\tI\bC\u0004\u0003:\u0001!\t!!=\t\u000f\tm\u0002\u0001\"\u0001\u0002r\"9!Q\b\u0001\u0005B\t}\u0002b\u0002B%\u0001\u0011\u0005#1\n\u0005\b\u0005/\u0002A\u0011\tB-\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0005GBqAa\u001a\u0001\t\u0003\u0011I\u0007C\u0004\u0003p\u0001!\tA!\u001d\t\u000f\tu\u0004\u0001\"\u0001\u0003\u0000!9!Q\u0011\u0001\u0005\u0002\t\u001d\u0005b\u0002BI\u0001\u0011\u0005!1\u0013\u0005\b\u0005/\u0003A\u0011\u0001BM\u0011\u001d\u0011)\u000b\u0001C\u0001\u0005OC\u0011B!-\u0001#\u0003%\tAa-\t\u000f\t%\u0007\u0001\"\u0001\u0003L\"A!Q\u001b\u0001\u0005\u0002\u0001\u000b\u0019\u0005\u0003\u0005\u0003X\u0002!\tA\u0010Bm\r\u0019\ti\t\u0001\u0003\u0002\u0010\"Q\u0011q\u0013\u0013\u0003\u0002\u0003\u0006I!!'\t\u000f\u0005EB\u0005\"\u0001\u0002 \"9\u00111\u0015\u0013\u0005R\u0005\u0015\u0006\"CAZI\t\u0007I\u0011AA[\u0011!\ti\f\nQ\u0001\n\u0005]\u0006\"CA`I\u0001\u0007I\u0011AAa\u0011%\tI\r\na\u0001\n\u0003\tY\r\u0003\u0005\u0002P\u0012\u0002\u000b\u0015BAb\u0011%\t\u0019\u000e\na\u0001\n\u0003\t)\u000eC\u0005\u0002^\u0012\u0002\r\u0011\"\u0001\u0002`\"A\u00111\u001d\u0013!B\u0013\t9\u000eC\u0004\u0002h\u0012\"I!!;\t\u000f\u0005=H\u0005\"\u0011\u0002r\"9\u00111\u001f\u0013\u0005\n\u0005U\bbBA\u007fI\u0011%\u0011q \u0005\b\u0005\u0017!C\u0011\u0001B\u0007\u000f\u001d\u0011YN\u0010E\u0001\u0005;4a!\u0010 \t\u0002\t}\u0007bBA\u0019m\u0011\u0005!\u0011\u001d\u0005\n\u0005G4$\u0019!C\u0001\u0005KD\u0001B!;7A\u0003%!q\u001d\u0005\b\u0005W4D\u0011\u0001Bw\u0011\u001d\u0011\tP\u000eC\u0001\u0005gD\u0011b!\u00017#\u0003%\taa\u0001\u0003\u00151{wm\u00117fC:,'O\u0003\u0002@\u0001\u0006\u0019An\\4\u000b\u0003\u0005\u000bQa[1gW\u0006\u001c\u0001aE\u0003\u0001\t*\u0003f\u000b\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b\u0002\u000bQ!\u001e;jYNL!a\u0014'\u0003\u000f1{wmZ5oOB\u0011\u0011\u000bV\u0007\u0002%*\u00111\u000bQ\u0001\b[\u0016$(/[2t\u0013\t)&KA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\u0004\"a\u0016.\u000e\u0003aS!!\u0017!\u0002\rM,'O^3s\u0013\tY\u0006L\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\u000eS:LG/[1m\u0007>tg-[4\u0011\u0005y{V\"\u0001 \n\u0005\u0001t$!D\"mK\u0006tWM]\"p]\u001aLw-A\u0004m_\u001e$\u0015N]:\u0016\u0003\r\u00042\u0001\u001a7p\u001d\t)'N\u0004\u0002gS6\tqM\u0003\u0002i\u0005\u00061AH]8pizJ\u0011aR\u0005\u0003W\u001a\u000bq\u0001]1dW\u0006<W-\u0003\u0002n]\n\u00191+Z9\u000b\u0005-4\u0005C\u00019v\u001b\u0005\t(B\u0001:t\u0003\tIwNC\u0001u\u0003\u0011Q\u0017M^1\n\u0005Y\f(\u0001\u0002$jY\u0016\f\u0001\u0002\\8h\t&\u00148\u000fI\u0001\u0005Y><7/F\u0001{!\u0015Y50`A\t\u0013\taHJ\u0001\u0003Q_>d\u0007c\u0001@\u0002\u000e5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011AB2p[6|gNC\u0002B\u0003\u000bQA!a\u0002\u0002\n\u00051\u0011\r]1dQ\u0016T!!a\u0003\u0002\u0007=\u0014x-C\u0002\u0002\u0010}\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002_\u0003'I1!!\u0006?\u0005\raunZ\u0001\u0006Y><7\u000fI\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0016\u0005\u0005u\u0001cA,\u0002 %\u0019\u0011\u0011\u0005-\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0003Uawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0002\nA\u0001^5nKB!\u0011\u0011FA\u0017\u001b\t\tYC\u0003\u0002N\u007f&!\u0011qFA\u0016\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)1\t)$a\u000e\u0002:\u0005m\u0012QHA !\tq\u0006\u0001C\u0003]\u0013\u0001\u0007Q\fC\u0003b\u0013\u0001\u00071\rC\u0003y\u0013\u0001\u0007!\u0010C\u0004\u0002\u001a%\u0001\r!!\b\t\u0013\u0005\u0015\u0012\u0002%AA\u0002\u0005\u001d\u0012AB2p]\u001aLw-F\u0001^\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0005\u0003\u0013\ny\u0005E\u0002F\u0003\u0017J1!!\u0014G\u0005\u0011)f.\u001b;\t\u0011\u0005E3\"!AA\u0002u\u000b1\u0001\u001f\u00132\u0003\u001d\u0019wN\u001c4jO\u0002B3\u0001DA,!\r)\u0015\u0011L\u0005\u0004\u000372%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u001d\rdW-\u00198fe6\u000bg.Y4feV\u0011\u0011\u0011\r\t\u0004=\u0006\r\u0014bAA3}\t\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0002\u001f\rdW-\u00198fe6\u000bg.Y4fe\u0002\n\u0011\u0002\u001e5s_R$H.\u001a:\u0016\u0005\u00055\u0004cA&\u0002p%\u0019\u0011\u0011\u000f'\u0003\u0013QC'o\u001c;uY\u0016\u0014\u0018A\u0003;ie>$H\u000f\\3sA\u0005A1\r\\3b]\u0016\u00148/\u0006\u0002\u0002zA1\u00111PAC\u0003\u0013k!!! \u000b\t\u0005}\u0014\u0011Q\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019IR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAD\u0003{\u00121\"\u0011:sCf\u0014UO\u001a4feB\u0019\u00111\u0012\u0013\u000e\u0003\u0001\u0011Qb\u00117fC:,'\u000f\u00165sK\u0006$7c\u0001\u0013\u0002\u0012B\u00191*a%\n\u0007\u0005UEJ\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017\u0001\u0003;ie\u0016\fG-\u00133\u0011\u0007\u0015\u000bY*C\u0002\u0002\u001e\u001a\u00131!\u00138u)\u0011\tI)!)\t\u000f\u0005]e\u00051\u0001\u0002\u001a\u0006QAn\\4hKJt\u0015-\\3\u0016\u0005\u0005\u001d\u0006\u0003BAU\u0003_k!!a+\u000b\u0007\u000556/\u0001\u0003mC:<\u0017\u0002BAY\u0003W\u0013aa\u0015;sS:<\u0017aB2mK\u0006tWM]\u000b\u0003\u0003o\u00032AXA]\u0013\r\tYL\u0010\u0002\b\u00072,\u0017M\\3s\u0003!\u0019G.Z1oKJ\u0004\u0013!\u00037bgR\u001cF/\u0019;t+\t\t\u0019\rE\u0002_\u0003\u000bL1!a2?\u00051\u0019E.Z1oKJ\u001cF/\u0019;t\u00035a\u0017m\u001d;Ti\u0006$8o\u0018\u0013fcR!\u0011\u0011JAg\u0011%\t\tfKA\u0001\u0002\u0004\t\u0019-\u0001\u0006mCN$8\u000b^1ug\u0002B3\u0001LA,\u0003Ea\u0017m\u001d;Qe\u0016\u001cE.Z1o'R\fGo]\u000b\u0003\u0003/\u00042AXAm\u0013\r\tYN\u0010\u0002\u000e!J,7\t\\3b]N#\u0018\r^:\u0002+1\f7\u000f\u001e)sK\u000ecW-\u00198Ti\u0006$8o\u0018\u0013fcR!\u0011\u0011JAq\u0011%\t\tFLA\u0001\u0002\u0004\t9.\u0001\nmCN$\bK]3DY\u0016\fgn\u0015;biN\u0004\u0003fA\u0018\u0002X\u0005I1\r[3dW\u0012{g.\u001a\u000b\u0005\u0003\u0013\nY\u000f\u0003\u0004\u0002nB\u0002\r!`\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0019!wnV8sWR\u0011\u0011\u0011J\u0001\u0012G2,\u0017M\u001c$jYRD\u0017.Z:u\u0019><GCAA|!\r)\u0015\u0011`\u0005\u0004\u0003w4%a\u0002\"p_2,\u0017M\\\u0001\tG2,\u0017M\u001c'pOR!\u0011\u0011\nB\u0001\u0011\u001d\u0011\u0019a\ra\u0001\u0005\u000b\t\u0011b\u00197fC:\f'\r\\3\u0011\u0007y\u00139!C\u0002\u0003\ny\u0012!\u0002T8h)>\u001cE.Z1o\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0019\u0005%#q\u0002B\n\u0005K\u0011yCa\r\t\u000f\tEA\u00071\u0001\u0002\u001a\u0006\u0011\u0011\u000e\u001a\u0005\b\u0005+!\u0004\u0019\u0001B\f\u0003\u0011q\u0017-\\3\u0011\t\te!\u0011\u0005\b\u0005\u00057\u0011i\u0002\u0005\u0002g\r&\u0019!q\u0004$\u0002\rA\u0013X\rZ3g\u0013\u0011\t\tLa\t\u000b\u0007\t}a\tC\u0004\u0003(Q\u0002\rA!\u000b\u0002\t\u0019\u0014x.\u001c\t\u0004\u000b\n-\u0012b\u0001B\u0017\r\n!Aj\u001c8h\u0011\u001d\u0011\t\u0004\u000ea\u0001\u0005S\t!\u0001^8\t\u000f\tUB\u00071\u0001\u0002D\u0006)1\u000f^1ug\u0006I1\r\\3b]\u0016\u00148\u000fI\u0001\bgR\f'\u000f^;q\u0003!\u0019\b.\u001e;e_^t\u0017!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0003\u0005\u0003\u0002bAa\u0011\u0003F\t]QBAAA\u0013\u0011\u00119%!!\u0003\u0007M+G/A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R!\u0011\u0011\nB'\u0011\u001d\u0011yE\u0006a\u0001\u0005#\n\u0011B\\3x\u0007>tg-[4\u0011\u0007]\u0013\u0019&C\u0002\u0003Va\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0019\tIEa\u0017\u0003`!9!QL\fA\u0002\tE\u0013!C8mI\u000e{gNZ5h\u0011\u001d\u0011ye\u0006a\u0001\u0005#\nQ\"\u00192peR\u001cE.Z1oS:<G\u0003BA%\u0005KBa!!<\u0019\u0001\u0004i\u0018!E;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ugR!\u0011\u0011\nB6\u0011\u0019\u0011i'\u0007a\u0001_\u00069A-\u0019;b\t&\u0014\u0018AE1mi\u0016\u00148\t[3dWB|\u0017N\u001c;ESJ$\u0002\"!\u0013\u0003t\tU$\u0011\u0010\u0005\u0007\u0003[T\u0002\u0019A?\t\r\t]$\u00041\u0001p\u00031\u0019x.\u001e:dK2{w\rR5s\u0011\u0019\u0011YH\u0007a\u0001_\u0006QA-Z:u\u0019><G)\u001b:\u0002'!\fg\u000e\u001a7f\u0019><G)\u001b:GC&dWO]3\u0015\t\u0005%#\u0011\u0011\u0005\b\u0005\u0007[\u0002\u0019\u0001B\f\u0003\r!\u0017N]\u0001\u0018[\u0006L(-\u001a+sk:\u001c\u0017\r^3DQ\u0016\u001c7\u000e]8j]R$\u0002\"!\u0013\u0003\n\n-%Q\u0012\u0005\u0007\u0005[b\u0002\u0019A8\t\r\u00055H\u00041\u0001~\u0011\u001d\u0011y\t\ba\u0001\u0005S\taa\u001c4gg\u0016$\u0018!F1c_J$\u0018I\u001c3QCV\u001cXm\u00117fC:Lgn\u001a\u000b\u0005\u0003\u0013\u0012)\n\u0003\u0004\u0002nv\u0001\r!`\u0001\u000fe\u0016\u001cX/\\3DY\u0016\fg.\u001b8h)\u0011\tIEa'\t\u000f\tue\u00041\u0001\u0003 \u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000fE\u0003\u0003D\t\u0005V0\u0003\u0003\u0003$\u0006\u0005%\u0001C%uKJ\f'\r\\3\u0002\u0019\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3\u0015\u0011\u0005](\u0011\u0016BV\u0005[Ca!!< \u0001\u0004i\bb\u0002BH?\u0001\u0007!\u0011\u0006\u0005\n\u0005_{\u0002\u0013!a\u0001\u0005S\t\u0011\"\\1y/\u0006LG/T:\u0002-\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3%I\u00164\u0017-\u001e7uIM*\"A!.+\t\t%\"qW\u0016\u0003\u0005s\u0003BAa/\u0003F6\u0011!Q\u0018\u0006\u0005\u0005\u007f\u0013\t-A\u0005v]\u000eDWmY6fI*\u0019!1\u0019$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003H\nu&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061\u0003/Y;tK\u000ecW-\u00198j]\u001e4uN\u001d(p]\u000e{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\\:\u0015\u0005\t5\u0007C\u0002B\"\u0005C\u0013y\r\u0005\u0004F\u0005#l\u0018\u0011C\u0005\u0004\u0005'4%A\u0002+va2,''A\u0007dkJ\u0014XM\u001c;D_:4\u0017nZ\u0001\rG2,\u0017M\\3s\u0007>,h\u000e^\u000b\u0003\u00033\u000b!\u0002T8h\u00072,\u0017M\\3s!\tqfg\u0005\u00027\tR\u0011!Q\\\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\u00119\u000f\u0005\u0004\u0003D\t\u0015\u0013qU\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0005i1\r\\3b]\u0016\u00148i\u001c8gS\u001e$2!\u0018Bx\u0011\u001d\t\tE\u000fa\u0001\u0005#\nqc\u0019:fCR,g*Z<DY\u0016\fg.\u001a3TK\u001elWM\u001c;\u0015\r\tU(1 B\u007f!\rq&q_\u0005\u0004\u0005st$A\u0003'pON+w-\\3oi\"1qh\u000fa\u0001\u0003#AqAa@<\u0001\u0004\u0011I#\u0001\u0006cCN,wJ\u001a4tKR\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAB\u0003U\u0011\t9Ca.")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final ArrayBuffer<CleanerThread> kafka$log$LogCleaner$$cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static LogSegment createNewCleanedSegment(Log log, long l) {
        return LogCleaner$.MODULE$.createNewCleanedSegment(log, l);
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public ArrayBuffer<CleanerThread> kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.kafka$log$LogCleaner$$cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.shutdown();
            return BoxedUnit.UNIT;
        });
        this.kafka$log$LogCleaner$$cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        CleanerConfig newCleanerConfig = LogCleaner$.MODULE$.cleanerConfig(newConfig);
        int numThreads = newCleanerConfig.numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, Log>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.kafka$log$LogCleaner$$cleaners().size();
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$11 -> x$11 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)$anon$1.$anonfun$value$2(x$2)), ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$2(CleanerStats x$2) {
                return (double)100 * x$2.bufferUtilization();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$2$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                ArrayBuffer stats = (ArrayBuffer)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$4(x$4)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$5(x$5)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }

            public static final /* synthetic */ long $anonfun$value$4(CleanerStats x$4) {
                return x$4.bytesWritten();
            }

            public static final /* synthetic */ long $anonfun$value$5(CleanerStats x$5) {
                return x$5.bytesRead();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$4$adapted(kafka.log.CleanerStats ), $anonfun$value$5$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)$anon$3.$anonfun$value$7(x$7)), ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$7(CleanerStats x$7) {
                return x$7.elapsedSecs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$6(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$7$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("max-compaction-delay-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return Math.max(0, (int)(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.lastPreCleanStats(), ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)$anon$4.$anonfun$value$9(x$9)), ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)) / 1000L));
            }

            public static final /* synthetic */ long $anonfun$value$9(PreCleanStats x$9) {
                return x$9.maxCompactionDelayMs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$8(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$9$adapted(kafka.log.PreCleanStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        @Override
        public void doWork() {
            block0: {
                boolean cleaned = this.cleanFilthiestLog();
                if (cleaned) break block0;
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
            }
        }

        private boolean cleanFilthiestLog() {
            boolean bl;
            ObjectRef currentLog = ObjectRef.create((Object)None$.MODULE$);
            try {
                boolean bl2;
                PreCleanStats preCleanStats = new PreCleanStats();
                Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
                if (None$.MODULE$.equals(option)) {
                    bl2 = false;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    LogToClean cleanable = (LogToClean)some.value();
                    this.lastPreCleanStats_$eq(preCleanStats);
                    currentLog.elem = new Some((Object)cleanable.log());
                    this.cleanLog(cleanable);
                    bl2 = true;
                } else {
                    throw new MatchError(option);
                }
                boolean cleaned = bl2;
                Iterable<Tuple2<TopicPartition, Log>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
                try {
                    deletable.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(currentLog, x0$1)));
                }
                finally {
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable & scala.Serializable)x$12 -> (TopicPartition)x$12._1(), Iterable$.MODULE$.canBuildFrom())));
                }
                bl = cleaned;
            }
            catch (Throwable throwable) {
                Exception exception;
                Throwable throwable2 = throwable;
                boolean bl3 = throwable2 instanceof ThreadShutdownException ? true : throwable2 instanceof ControlThrowable;
                if (bl3) {
                    throw throwable2;
                }
                if (throwable2 instanceof Exception) {
                    exception = (Exception)throwable2;
                    if (((Option)currentLog.elem).isEmpty()) {
                        throw new IllegalStateException("currentLog cannot be empty on an unexpected exception", exception);
                    }
                } else {
                    throw throwable;
                }
                Log erroneousLog = (Log)((Option)currentLog.elem).get();
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(erroneousLog).append(". Marking its partition (").append(erroneousLog.topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(erroneousLog.dir().getParent(), erroneousLog.topicPartition());
                boolean bl4 = false;
                bl = bl4;
            }
            return bl;
        }

        private void cleanLog(LogToClean cleanable) {
            long endOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)nextDirtyOffset), (Object)cleanerStats);
                    Tuple2 tuple23 = tuple22;
                    long nextDirtyOffset2 = tuple23._1$mcJ$sp();
                    CleanerStats cleanerStats2 = (CleanerStats)tuple23._2();
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, cleanerStats2);
                    endOffset = nextDirtyOffset2;
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().dir().getParent();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            block1: {
                this.lastStats_$eq(stats);
                String message = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                if (this.lastPreCleanStats().delayedPartitions() > 0) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
                }
                if (stats.invalidMessagesRead() <= 0L) break block1;
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(ObjectRef currentLog$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Log log = (Log)tuple2._2();
            currentLog$1.elem = new Some((Object)log);
            int n = log.deleteOldSegments();
            return n;
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

