/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AppendOrigin$Coordinator$;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.FetchDataInfo;
import kafka.server.ReplicaManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t\u0005w!B\u001a5\u0011\u0003Yd!B\u001f5\u0011\u0003q\u0004\"B#\u0002\t\u00031\u0005bB$\u0002\u0005\u0004%\t\u0001\u0013\u0005\u0007\u0019\u0006\u0001\u000b\u0011B%\t\u000f5\u000b!\u0019!C\u0001\u0011\"1a*\u0001Q\u0001\n%CqaT\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004Q\u0003\u0001\u0006I!\u0013\u0005\b#\u0006\u0011\r\u0011\"\u0001I\u0011\u0019\u0011\u0016\u0001)A\u0005\u0013\u001a!Q\b\u000e\u0001T\u0011!Q6B!A!\u0002\u0013I\u0005\u0002C.\f\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\t\\!\u0011!Q\u0001\n\rD\u0001BZ\u0006\u0003\u0002\u0003\u0006Ia\u001a\u0005\t[.\u0011\t\u0011)A\u0005]\"A\u0011o\u0003B\u0001B\u0003%!\u000fC\u0003F\u0017\u0011\u0005a0\u0002\u0004\u0002\u000e-\u0001\u0011q\u0002\u0005\n\u0003\u0013Z!\u0019!C\u0005\u0003\u0017B\u0001\"!\u001a\fA\u0003%\u0011Q\n\u0005\n\u0003OZ!\u0019!C\u0005\u0003SB\u0001\"a\u001e\fA\u0003%\u00111\u000e\u0005\u000b\u0003sZ!\u0019!C\u0001i\u0005m\u0004\u0002CAJ\u0017\u0001\u0006I!! \t\u0015\u0005U5B1A\u0005\u0002Q\nY\b\u0003\u0005\u0002\u0018.\u0001\u000b\u0011BA?\u0011)\tIj\u0003b\u0001\n\u0003!\u00141\u0014\u0005\t\u0003S[\u0001\u0015!\u0003\u0002\u001e\"A\u00111V\u0006C\u0002\u0013%\u0001\nC\u0004\u0002..\u0001\u000b\u0011B%\t\u0011\u0005=6\u0002\"\u00015\u0003cC\u0001\"a/\f\t\u0003!\u0014Q\u0018\u0005\b\u0003\u0017\\A\u0011AAg\u0011\u001d\t9o\u0003C\u0001\u0003SDq!a;\f\t\u0003\ti\u000fC\u0004\u0003\u0012-!\tAa\u0005\t\u000f\tu1\u0002\"\u0003\u0003 !9!\u0011F\u0006\u0005\u0002\t-\u0002b\u0002B\u001c\u0017\u0011\u0005!\u0011\b\u0005\b\u0005\u0007ZA\u0011\u0001B#\u0011\u0019\u0011Ie\u0003C\u0005\u0011\"9!1J\u0006\u0005\n\t5\u0003\u0002\u0003B2\u0017\u0011\u0005AG!\u001a\t\u000f\tE4\u0002\"\u0001\u0003t!9!\u0011Q\u0006\u0005\u0002\t\r\u0005b\u0002BE\u0017\u0011%\u0011\u0011\u001e\u0005\b\u0005\u0017[A\u0011\u0001BG\u0011%\u00119kCI\u0001\n\u0003\u0011I\u000bC\u0004\u0003@.!\t!!;\u0002/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014(BA\u001b7\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005]B\u0014aC2p_J$\u0017N\\1u_JT\u0011!O\u0001\u0006W\u000647.Y\u0002\u0001!\ta\u0014!D\u00015\u0005]!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'o\u0005\u0002\u0002\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001e\u0002?\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\:NCb$\u0016.\\3pkRl5/F\u0001J!\t\u0001%*\u0003\u0002L\u0003\n\u0019\u0011J\u001c;\u0002A\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\:NCb$\u0016.\\3pkRl5\u000fI\u0001#\t\u00164\u0017-\u001e7u)J\fgn]1di&|g.\u00197JI\u0016C\b/\u001b:bi&|g.T:\u0002G\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0005\u0010]5sCRLwN\\'tA\u0005QC)\u001a4bk2$\u0018IY8siRKW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t\u0013:$XM\u001d<bY6\u001b\u0018a\u000b#fM\u0006,H\u000e^!c_J$H+[7fI>+H\u000f\u0016:b]N\f7\r^5p]NLe\u000e^3sm\u0006dWj\u001d\u0011\u0002]\u0011+g-Y;miJ+Wn\u001c<f\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JINLe\u000e^3sm\u0006dWj]\u00010\t\u00164\u0017-\u001e7u%\u0016lwN^3FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%eg&sG/\u001a:wC2l5\u000fI\n\u0004\u0017}\"\u0006CA+Y\u001b\u00051&BA,9\u0003\u0015)H/\u001b7t\u0013\tIfKA\u0004M_\u001e<\u0017N\\4\u0002\u0011\t\u0014xn[3s\u0013\u0012\f\u0001B_6DY&,g\u000e\u001e\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?b\n!A_6\n\u0005\u0005t&!D&bM.\f'l[\"mS\u0016tG/A\u0005tG\",G-\u001e7feB\u0011Q\u000bZ\u0005\u0003KZ\u0013\u0011bU2iK\u0012,H.\u001a:\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011\u0001n[\u0007\u0002S*\u0011!\u000eO\u0001\u0007g\u0016\u0014h/\u001a:\n\u00051L'A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0007G>tg-[4\u0011\u0005qz\u0017B\u000195\u0005E!&/\u00198tC\u000e$\u0018n\u001c8D_:4\u0017nZ\u0001\u0005i&lW\r\u0005\u0002ty6\tAO\u0003\u0002Xk*\u0011ao^\u0001\u0007G>lWn\u001c8\u000b\u0005eB(BA={\u0003\u0019\t\u0007/Y2iK*\t10A\u0002pe\u001eL!! ;\u0003\tQKW.\u001a\u000b\u000e\u007f\u0006\u0005\u00111AA\u0003\u0003\u000f\tI!a\u0003\u0011\u0005qZ\u0001\"\u0002.\u0013\u0001\u0004I\u0005\"B.\u0013\u0001\u0004a\u0006\"\u00022\u0013\u0001\u0004\u0019\u0007\"\u00024\u0013\u0001\u00049\u0007\"B7\u0013\u0001\u0004q\u0007\"B9\u0013\u0001\u0004\u0011(AF*f]\u0012$\u0006P\\'be.,'o]\"bY2\u0014\u0017mY6\u0011\u001d\u0001\u000b\t\"!\u0006J\u0003W\t9$!\u0010\u0002D%\u0019\u00111C!\u0003\u0013\u0019+hn\u0019;j_:,\u0004\u0003BA\f\u0003KqA!!\u0007\u0002\"A\u0019\u00111D!\u000e\u0005\u0005u!bAA\u0010u\u00051AH]8pizJ1!a\tB\u0003\u0019\u0001&/\u001a3fM&!\u0011qEA\u0015\u0005\u0019\u0019FO]5oO*\u0019\u00111E!\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\rv\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u001b\u0003_\u0011\u0011\u0003\u0016:b]N\f7\r^5p]J+7/\u001e7u!\ra\u0014\u0011H\u0005\u0004\u0003w!$a\u0005+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007c\u0001\u001f\u0002@%\u0019\u0011\u0011\t\u001b\u0003%QCh\u000e\u0016:b]NLG/T3uC\u0012\fG/\u0019\t\u0004\u0001\u0006\u0015\u0013bAA$\u0003\n!QK\\5u\u00031\u0019\b.\u001e;uS:<Gi\\<o+\t\ti\u0005\u0005\u0003\u0002P\u0005\u0005TBAA)\u0015\u0011\t\u0019&!\u0016\u0002\r\u0005$x.\\5d\u0015\u0011\t9&!\u0017\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\\\u0005u\u0013\u0001B;uS2T!!a\u0018\u0002\t)\fg/Y\u0005\u0005\u0003G\n\tFA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000eg\",H\u000f^5oO\u0012{wO\u001c\u0011\u0002\u0013M$\u0018\r^3M_\u000e\\WCAA6!\u0011\ti'a\u001d\u000e\u0005\u0005=$\u0002BA9\u0003+\nQ\u0001\\8dWNLA!!\u001e\u0002p\t1\"+Z3oiJ\fg\u000e\u001e*fC\u0012<&/\u001b;f\u0019>\u001c7.\u0001\u0006ti\u0006$X\rT8dW\u0002\n\u0011\u0003\\8bI&tw\rU1si&$\u0018n\u001c8t+\t\ti\b\u0005\u0004\u0002\u0000\u0005%\u0015QR\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u00069Q.\u001e;bE2,'bAAD\u0003\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0015\u0011\u0011\u0002\u0004'\u0016$\bc\u0001\u001f\u0002\u0010&\u0019\u0011\u0011\u0013\u001b\u0003EQ\u0013\u0018M\\:bGRLwN\u001c)beRLG/[8o\u0003:$G*Z1eKJ,\u0005o\\2i\u0003Iaw.\u00193j]\u001e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002#1,\u0017M^5oOB\u000b'\u000f^5uS>t7/\u0001\nmK\u00064\u0018N\\4QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001\u0007;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f7)Y2iKV\u0011\u0011Q\u0014\t\b\u0003\u007f\ny*SAR\u0013\u0011\t\t+!!\u0003\u00075\u000b\u0007\u000fE\u0002=\u0003KK1!a*5\u0005U!\u0006P\\'fi\u0006$\u0017\r^1DC\u000eDW-\u00128uef\f\u0011\u0004\u001e:b]N\f7\r^5p]6+G/\u00193bi\u0006\u001c\u0015m\u00195fA\u0005qBO]1og\u0006\u001cG/[8o)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e^\u0001 iJ\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R\u0004\u0013aE1eI2{\u0017\rZ5oOB\u000b'\u000f^5uS>tGCBA\"\u0003g\u000b9\f\u0003\u0004\u00026\u0002\u0002\r!S\u0001\fa\u0006\u0014H/\u001b;j_:LE\r\u0003\u0004\u0002:\u0002\u0002\r!S\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"\fQb\u001d;bi\u0016\u0014V-\u00193M_\u000e\\WCAA`!\u0011\t\t-a2\u000e\u0005\u0005\r'\u0002BAc\u0003_\naCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m[\u0005\u0005\u0003\u0013\f\u0019M\u0001\u0005SK\u0006$Gj\\2l\u0003Q!\u0018.\\3e\u001fV$HK]1og\u0006\u001cG/[8ogR\u0011\u0011q\u001a\t\u0007\u0003#\fY.!9\u000f\t\u0005M\u0017q\u001b\b\u0005\u00037\t).C\u0001C\u0013\r\tI.Q\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti.a8\u0003\u0011%#XM]1cY\u0016T1!!7B!\ra\u00141]\u0005\u0004\u0003K$$!\t+sC:\u001c\u0018m\u0019;j_:\fG.\u00133B]\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#q_\u000eD\u0017aH3oC\ndW\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]R\u0011\u00111I\u0001\u0014O\u0016$HK]1og\u0006\u001cG/[8o'R\fG/\u001a\u000b\u0005\u0003_\u0014i\u0001\u0005\u0005\u0002R\u0006E\u0018Q\u001fB\u0001\u0013\u0011\t\u00190a8\u0003\r\u0015KG\u000f[3s!\u0011\t90!@\u000e\u0005\u0005e(bAA~k\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002\u0000\u0006e(AB#se>\u00148\u000fE\u0003A\u0005\u0007\u00119!C\u0002\u0003\u0006\u0005\u0013aa\u00149uS>t\u0007c\u0001\u001f\u0003\n%\u0019!1\u0002\u001b\u0003=\r{wN\u001d3j]\u0006$xN]#q_\u000eD\u0017I\u001c3Uq:lU\r^1eCR\f\u0007b\u0002B\bI\u0001\u0007\u0011QC\u0001\u0010iJ\fgn]1di&|g.\u00197JI\u0006q\u0002/\u001e;Ue\u0006t7/Y2uS>t7\u000b^1uK&3gj\u001c;Fq&\u001cHo\u001d\u000b\u0007\u0005+\u00119B!\u0007\u0011\u0011\u0005E\u0017\u0011_A{\u0005\u000fAqAa\u0004&\u0001\u0004\t)\u0002C\u0004\u0003\u001c\u0015\u0002\r!a\u000e\u0002\u0017QDh.T3uC\u0012\fG/Y\u0001\u001fO\u0016$\u0018I\u001c3NCf\u0014W-\u00113e)J\fgn]1di&|gn\u0015;bi\u0016$b!a<\u0003\"\t\r\u0002b\u0002B\bM\u0001\u0007\u0011Q\u0003\u0005\b\u0005K1\u0003\u0019\u0001B\u0014\u0003U\u0019'/Z1uK\u0012$\u0006P\\'fi\u0006$\u0017\r^1PaR\u0004R\u0001\u0011B\u0002\u0003o\tAD^1mS\u0012\fG/\u001a+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5\u000f\u0006\u0003\u0003.\tM\u0002c\u0001!\u00030%\u0019!\u0011G!\u0003\u000f\t{w\u000e\\3b]\"1!QG\u0014A\u0002%\u000bA\u0002\u001e=o)&lWm\\;u\u001bN\fq\u0003\u001e:b]N\f7\r^5p]R{\u0007/[2D_:4\u0017nZ:\u0016\u0005\tm\u0002\u0003\u0002B\u001f\u0005\u007fi!!!\u0017\n\t\t\u0005\u0013\u0011\f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001\u00049beRLG/[8o\r>\u0014HcA%\u0003H!9!qB\u0015A\u0002\u0005U\u0011!I4fiR\u0013\u0018M\\:bGRLwN\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$\u0018a\u00067pC\u0012$&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b)\u0019\u0011yE!\u0016\u0003bA9QK!\u0015\u0002\u0016\u0005]\u0012b\u0001B*-\n!\u0001k\\8m\u0011\u001d\u00119f\u000ba\u0001\u00053\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0003\\\tuS\"A;\n\u0007\t}SO\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r\u0005e6\u00061\u0001J\u0003q\tG\r\u001a'pC\u0012,G\r\u0016:b]N\f7\r^5p]N$vnQ1dQ\u0016$\u0002\"a\u0011\u0003h\t-$Q\u000e\u0005\u0007\u0005Sb\u0003\u0019A%\u0002#QDh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002:2\u0002\r!\u0013\u0005\b\u0005_b\u0003\u0019\u0001B(\u0003Iaw.\u00193fIR\u0013\u0018M\\:bGRLwN\\:\u0002I1|\u0017\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001chi\u001c:Uq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:$\u0002\"a\u0011\u0003v\t]$\u0011\u0010\u0005\u0007\u0003kk\u0003\u0019A%\t\r\u0005eV\u00061\u0001J\u0011\u001d\u0011Y(\fa\u0001\u0005{\nab]3oIRCh.T1sW\u0016\u00148\u000fE\u0002\u0003\u0000Mi\u0011aC\u0001'e\u0016lwN^3Ue\u0006t7/Y2uS>t7OR8s)btGk\u001c9jGB\u000b'\u000f^5uS>tGCBA\"\u0005\u000b\u00139\t\u0003\u0004\u00026:\u0002\r!\u0013\u0005\u0007\u0003ss\u0003\u0019A%\u0002]Y\fG.\u001b3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtG/S:Ti\u0006\u0014G.Z\u0001\u0017CB\u0004XM\u001c3Ue\u0006t7/Y2uS>tGk\u001c'pORa\u00111\tBH\u0005#\u0013\u0019Ja&\u0003\"\"9!q\u0002\u0019A\u0002\u0005U\u0001BBA]a\u0001\u0007\u0011\nC\u0004\u0003\u0016B\u0002\r!!\u0010\u0002\u00179,w/T3uC\u0012\fG/\u0019\u0005\b\u00053\u0003\u0004\u0019\u0001BN\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0004A\u0005;\u000b)0a\u0011\n\u0007\t}\u0015IA\u0005Gk:\u001cG/[8oc!I!1\u0015\u0019\u0011\u0002\u0003\u0007!QU\u0001\re\u0016$(/_(o\u000bJ\u0014xN\u001d\t\b\u0001\nu\u0015Q\u001fB\u0017\u0003\u0001\n\u0007\u000f]3oIR\u0013\u0018M\\:bGRLwN\u001c+p\u0019><G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t-&\u0006\u0002BS\u0005[[#Aa,\u0011\t\tE&1X\u0007\u0003\u0005gSAA!.\u00038\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005s\u000b\u0015AC1o]>$\u0018\r^5p]&!!Q\u0018BZ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\tg\",H\u000fZ8x]\u0002")
public class TransactionStateManager
implements Logging {
    private final KafkaZkClient zkClient;
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final Set<TransactionPartitionAndLeaderEpoch> leavingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private final int transactionTopicPartitionCount;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TransactionStateManager transactionStateManager = this;
        synchronized (transactionStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public Set<TransactionPartitionAndLeaderEpoch> leavingPartitions() {
        return this.leavingPartitions;
    }

    public scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.leavingPartitions().remove((Object)partitionAndLeaderEpoch);
            return this.loadingPartitions().add((Object)partitionAndLeaderEpoch);
        });
    }

    public ReentrantReadWriteLock.ReadLock stateReadLock() {
        return this.stateLock().readLock();
    }

    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        long now = this.time.milliseconds();
        return (Iterable)CoreUtils$.MODULE$.inReadLock(this.stateLock(), (Function0 & Serializable & scala.Serializable)() -> (Iterable)((TraversableLike)this.transactionMetadataCache().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$2(this, x0$1)))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)tuple2._2();
            Iterable iterable = (Iterable)((TraversableLike)entry.metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$5(now, x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String txnId = (String)tuple2._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
                TransactionalIdAndProducerIdEpoch transactionalIdAndProducerIdEpoch = new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                return transactionalIdAndProducerIdEpoch;
            }, Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long now = $this.time.milliseconds();
            CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                scala.collection.immutable.Map transactionalIdByPartition = ((TraversableLike)this.transactionMetadataCache().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)tuple2._2();
                    Iterable iterable = (Iterable)((TraversableLike)((TraversableLike)entry.metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$4(x0$2)))).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$5(this, now, x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String transactionalId = (String)tuple2._1();
                        TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
                        TxnTransitMetadata txnMetadataTransition = (TxnTransitMetadata)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> txnMetadata.prepareDead());
                        TransactionalIdCoordinatorEpochAndMetadata transactionalIdCoordinatorEpochAndMetadata = new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, entry.coordinatorEpoch(), txnMetadataTransition);
                        return transactionalIdCoordinatorEpochAndMetadata;
                    }, Iterable$.MODULE$.canBuildFrom());
                    return iterable;
                }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)transactionalIdCoordinatorEpochAndMetadata -> BoxesRunTime.boxToInteger((int)this.partitionFor(transactionalIdCoordinatorEpochAndMetadata.transactionalId())));
                scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)transactionalIdByPartition.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                    Tuple2 tuple2 = x0$5;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int partition = tuple2._1$mcI$sp();
                    scala.collection.mutable.Iterable transactionalIdCoordinatorEpochAndMetadatas = (scala.collection.mutable.Iterable)tuple2._2();
                    SimpleRecord[] deletes = (SimpleRecord[])((TraversableOnce)transactionalIdCoordinatorEpochAndMetadatas.map((Function1 & Serializable & scala.Serializable)entry -> new SimpleRecord(now, TransactionLog$.MODULE$.keyToBytes(entry.transactionalId()), null), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
                    MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])deletes);
                    TopicPartition topicPartition = new TopicPartition("__transaction_state", partition);
                    Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)records);
                    return tuple22;
                }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                $this.replicaManager.appendRecords($this.config.requestTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responses -> {
                    this.removeFromCacheCallback$1(responses, transactionalIdByPartition);
                    return BoxedUnit.UNIT;
                }, (Option<Lock>)new Some((Object)this.stateLock().readLock()), $this.replicaManager.appendRecords$default$8());
            });
        }, this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(String transactionalId, TransactionMetadata txnMetadata) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)new Some((Object)txnMetadata)).right().map((Function1 & Serializable & scala.Serializable)x$2 -> (CoordinatorEpochAndTxnMetadata)x$2.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata).toString());
        }));
    }

    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        return (Either)CoreUtils$.MODULE$.inReadLock(this.stateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            Left left;
            int partitionId = this.partitionFor(transactionalId);
            if (this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$3)))) {
                left = package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
            } else if (this.leavingPartitions().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$3(partitionId, x$4)))) {
                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
            } else {
                Left left2;
                Option option = this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)some.value();
                    Option txnMetadata = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId)).orElse((Function0 & Serializable & scala.Serializable)() -> createdTxnMetadataOpt.map((Function1 & Serializable & scala.Serializable)createdTxnMetadata -> (TransactionMetadata)Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().putIfNotExists(transactionalId, (TransactionMetadata)createdTxnMetadata)).getOrElse((Function0 & Serializable & scala.Serializable)() -> createdTxnMetadata)));
                    left2 = package$.MODULE$.Right().apply((Object)txnMetadata.map((Function1 & Serializable & scala.Serializable)x$5 -> new CoordinatorEpochAndTxnMetadata(cacheEntry.coordinatorEpoch(), (TransactionMetadata)x$5)));
                } else if (None$.MODULE$.equals(option)) {
                    left2 = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                } else {
                    throw new MatchError((Object)option);
                }
                left = left2;
            }
            return left;
        });
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Properties transactionTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)this.config.transactionLogMinInsyncReplicas())).toString());
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.config.transactionLogSegmentBytes())).toString());
        return var1_1;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private int getTransactionTopicPartitionCount() {
        return BoxesRunTime.unboxToInt((Object)this.zkClient.getTopicPartitionCount("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.config.transactionLogNumPartitions()));
    }

    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        long startMs = this.time.milliseconds();
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)Pool$.MODULE$.$lessinit$greater$default$1());
        Option<Log> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            Log log = (Log)some.value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && !this.shuttingDown().get() && BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition, coordinatorEpoch, idAndEpoch)))))) {
                    MemoryRecords memoryRecords;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), (Option<Object>)None$.MODULE$, true, false);
                    Records records = fetchDataInfo.records();
                    if (records instanceof MemoryRecords) {
                        MemoryRecords memoryRecords2;
                        memoryRecords = memoryRecords2 = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        Buffer buffer2;
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(125).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                            buffer2 = BoxedUnit.UNIT;
                        } else {
                            buffer2 = buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    MemoryRecords memRecords = memoryRecords;
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(memRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$6(loadedTransactions, currOffset, batch);
                        return BoxedUnit.UNIT;
                    });
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Finished loading ").append(loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition).append(" in ").append($this.time.milliseconds() - startMs).append(" milliseconds").toString());
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        Option previousTxnMetadataCacheEntryOpt = this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry);
        previousTxnMetadataCacheEntryOpt.foreach((Function1 & Serializable & scala.Serializable)previousTxnMetadataCacheEntry -> {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").append("loading metadata at epoch ").append(coordinatorEpoch$2).toString());
            return BoxedUnit.UNIT;
        });
    }

    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function5<String, Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.leavingPartitions().remove((Object)partitionAndLeaderEpoch);
            return this.loadingPartitions().add((Object)partitionAndLeaderEpoch);
        });
        this.scheduler.schedule(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.loadTransactions$1(topicPartition, coordinatorEpoch, partitionAndLeaderEpoch, sendTxnMarkers), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.loadingPartitions().remove((Object)partitionAndLeaderEpoch);
            return this.leavingPartitions().add((Object)partitionAndLeaderEpoch);
        });
        this.scheduler.schedule(new StringBuilder(26).append("remove-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.removeTransactions$1(partitionAndLeaderEpoch, partitionId, topicPartition), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        if (this.transactionTopicPartitionCount() != curTransactionTopicPartitionCount) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(this.transactionTopicPartitionCount()).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        long timestamp = this.time.milliseconds();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)});
        TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            boolean bl = false;
            Right right = null;
            Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.getTransactionState(transactionalId);
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                BoxedUnit boxedUnit2 = (BoxedUnit)responseCallback.apply((Object)err);
                return;
            }
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                Option option = (Option)right.value();
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit3 = (BoxedUnit)responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                    return;
                }
            }
            if (!bl) throw new MatchError(either);
            Option option = (Option)right.value();
            if (!(option instanceof Some)) throw new MatchError(either);
            Some some = (Some)option;
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
            TransactionMetadata metadata = epochAndMetadata.transactionMetadata();
            boolean append = BoxesRunTime.unboxToBoolean(metadata.inLock((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch) {
                    responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }));
            if (append) {
                $this.replicaManager.appendRecords(newMetadata.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responseStatus -> {
                    this.updateCacheCallback$1(responseStatus, topicPartition, transactionalId, newMetadata, coordinatorEpoch, retryOnError, responseCallback);
                    return BoxedUnit.UNIT;
                }, (Option<Lock>)new Some((Object)this.stateLock().readLock()), $this.replicaManager.appendRecords$default$8());
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata).append(" for transaction id ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append(" to the local transaction log").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        });
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$6));
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(int txnPartitionId$1, TransactionPartitionAndLeaderEpoch x$1) {
        return x$1.txnPartitionId() == txnPartitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$2(TransactionStateManager $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int txnPartitionId = tuple2._1$mcI$sp();
        boolean bl = !$this.leavingPartitions().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(txnPartitionId, x$1)));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$5(long now$1, Tuple2 x0$3) {
        boolean bl;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                bl = false;
            } else {
                TransactionState transactionState = txnMetadata.state();
                boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1 : false;
                bl = bl2;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
        TransactionState transactionState = txnMetadata.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        boolean bl3 = bl2;
        return bl3;
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$5(TransactionStateManager $this, long now$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
        boolean bl = txnMetadata.txnLastUpdateTimestamp() <= now$2 - (long)$this.config.transactionalIdExpirationMs();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$11(TransactionStateManager $this, scala.collection.immutable.Map transactionalIdByPartition$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse response = (ProduceResponse.PartitionResponse)tuple2._2();
        BoxedUnit boxedUnit = (BoxedUnit)CoreUtils$.MODULE$.inReadLock($this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Iterable toRemove = (scala.collection.mutable.Iterable)transactionalIdByPartition$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
            $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())).foreach((Function1 & Serializable & scala.Serializable)txnMetadataCacheEntry -> {
                toRemove.foreach((Function1 & Serializable & scala.Serializable)idCoordinatorEpochAndMetadata -> {
                    String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                    TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                    return txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        Object object;
                        if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                            Errors errors = response$1.error;
                            Errors errors2 = Errors.NONE;
                            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                                object = txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                                return object;
                            }
                        }
                        $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(192).append("Failed to remove expired transactionalId: ").append(transactionalId).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").append(idCoordinatorEpochAndMetadata.coordinatorEpoch()).toString());
                        txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                        object = BoxedUnit.UNIT;
                        return object;
                    });
                });
                return BoxedUnit.UNIT;
            });
        });
    }

    private final void removeFromCacheCallback$1(Map responses, scala.collection.immutable.Map transactionalIdByPartition$1) {
        responses.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionStateManager.$anonfun$enableTransactionalIdExpiration$11(this, transactionalIdByPartition$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$3) {
        return x$3.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$3(int partitionId$1, TransactionPartitionAndLeaderEpoch x$4) {
        return x$4.txnPartitionId() == partitionId$1;
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        Object object;
        Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable & scala.Serializable)() -> "Transaction state log's key should not be null");
        TxnKey txnKey = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
        String transactionalId = txnKey.transactionalId();
        if (!record.hasValue()) {
            object = loadedTransactions$1.remove(transactionalId);
        } else {
            TransactionMetadata txnMetadata = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
            object = loadedTransactions$1.put(transactionalId, txnMetadata);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$6(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch) {
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionStateManager.$anonfun$loadTransactionMetadata$7(loadedTransactions$1, currOffset$1, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    private final void loadTransactions$1(TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, Function5 sendTxnMarkers$1) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition$3).append(" at epoch ").append(coordinatorEpoch$3).toString());
        this.validateTransactionTopicPartitionCountIsStable();
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) break block0;
                this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions);
                ListBuffer transactionsPendingForCompletion = new ListBuffer();
                loadedTransactions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String transactionalId = (String)tuple2._1();
                    TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
                    Object t = txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        TransactionState transactionState = txnMetadata.state();
                        Object object = PrepareAbort$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : (PrepareCommit$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : BoxedUnit.UNIT);
                        return object;
                    });
                    return t;
                });
                this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
                transactionsPendingForCompletion.foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                    sendTxnMarkers$1.apply((Object)txnTransitMetadata.transactionalId(), (Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                    return BoxedUnit.UNIT;
                });
            }
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition$3).append(" for coordinator epoch ").append(coordinatorEpoch$3).toString());
    }

    private final void removeTransactions$1(TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$2, TopicPartition topicPartition$4) {
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            if (this.leavingPartitions().contains((Object)partitionAndLeaderEpoch$3)) {
                Option option = this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$2));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)some.value();
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" on become-follower transition").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("No cached transaction metadata found for ").append(topicPartition$4).append(" during become-follower transition").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                object = BoxesRunTime.boxToBoolean((boolean)this.leavingPartitions().remove((Object)partitionAndLeaderEpoch$3));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$4, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$4).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$4, Errors err$1) {
        return new StringBuilder(140).append("Accessing the cached transaction metadata for ").append(transactionalId$4).append(" returns ").append(err$1).append(" error; ").append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$4, String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$4) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(231).append("The cached coordinator epoch for ").append(transactionalId$4).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$4)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
        } else {
            metadata$1.completeTransitionTo(newMetadata$1);
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$4).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" for ").append(transactionalId$4).append(" succeeded").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4) {
        return new StringBuilder(254).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$4).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$4)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$4) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(169).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString());
            } else {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(159).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString());
                metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            }
        } else {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(187).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$4).toString());
        }
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(190).append("TransactionalId ").append(transactionalId$4).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(173).append("TransactionalId ").append(transactionalId$4).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$5, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1) {
        block15: {
            block13: {
                block17: {
                    block16: {
                        block14: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$5)) {
                                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$5})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$5);
                            v0 = status.error;
                            var16_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var16_9) == false : var16_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var17_10 = status.error;
                                var13_11 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var17_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var17_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var17_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var17_10) != false));
                                if (var13_11) {
                                    var10_12 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var12_13 = Errors.NOT_LEADER_FOR_PARTITION.equals(var17_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var17_10) != false;
                                    if (var12_13) {
                                        var10_12 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var11_14 = Errors.MESSAGE_TOO_LARGE.equals(var17_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var17_10) != false;
                                        var10_12 = var11_14 != false ? Errors.UNKNOWN_SERVER_ERROR : var17_10;
                                    }
                                }
                                v1 = var10_12;
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var18_16 = Errors.NONE;
                            if (v2 != null ? v2.equals(var18_16) == false : var18_16 != null) break block13;
                            var19_17 = false;
                            var20_18 = null;
                            var21_19 = this.getTransactionState(transactionalId$4);
                            if (!(var21_19 instanceof Left)) break block14;
                            var22_20 = (Left)var21_19;
                            err = (Errors)var22_20.value();
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (Errors)err));
                            responseError.elem = err;
                            var9_22 = BoxedUnit.UNIT;
                            break block15;
                        }
                        if (!(var21_19 instanceof Right)) break block16;
                        var19_17 = true;
                        var20_18 = (Right)var21_19;
                        var24_25 = (Option)var20_18.value();
                        if (!(var24_25 instanceof Some)) break block16;
                        var25_26 = (Some)var24_25;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)var25_26.value();
                        metadata = epochAndMetadata.transactionMetadata();
                        var9_23 = (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block15;
                    }
                    if (!var19_17 || !None$.MODULE$.equals(var28_29 = (Option)var20_18.value())) break block17;
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    var9_24 = BoxedUnit.UNIT;
                    break block15;
                }
                throw new MatchError(var21_19);
            }
            var29_30 = false;
            var30_31 = null;
            var31_32 = this.getTransactionState(transactionalId$4);
            if (!(var31_32 instanceof Right)) ** GOTO lbl-1000
            var29_30 = true;
            var30_31 = (Right)var31_32;
            var32_33 = (Option)var30_31.value();
            if (var32_33 instanceof Some) {
                var33_34 = (Some)var32_33;
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)var33_34.value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                var8_37 = (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var29_30 && None$.MODULE$.equals(var36_40 = (Option)var30_31.value())) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
                var8_38 = BoxedUnit.UNIT;
            } else if (var31_32 instanceof Left) {
                var37_41 = (Left)var31_32;
                error = (Errors)var37_41.value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
                var8_39 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(var31_32);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$6) {
        return false;
    }

    public TransactionStateManager(int brokerId, KafkaZkClient zkClient, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time) {
        this.zkClient = zkClient;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.leavingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
    }
}

