/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_0_IV0$;
import kafka.api.KAFKA_2_2_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEvent;
import kafka.controller.LeaderAndIsrResponseReceived;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.PartitionAndReplica;
import kafka.controller.StateChangeLogger;
import kafka.controller.StopReplicaRequestInfo;
import kafka.controller.TopicDeletionStopReplicaResponseReceived;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]h!B\u000e\u001d\u0003\u0003\t\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u0011U\u0002!\u0011!Q\u0001\nYB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0006}\u0001!\ta\u0010\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0011\u0019I\u0005\u0001)A\u0005\r\"9!\n\u0001b\u0001\n\u0003Y\u0005B\u00026\u0001A\u0003%A\nC\u0004l\u0001\t\u0007I\u0011\u00017\t\rQ\u0004\u0001\u0015!\u0003n\u0011\u001d)\bA1A\u0005\u0002YDaA\u001f\u0001!\u0002\u00139\bbB>\u0001\u0005\u0004%\t\u0001 \u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003~\u0011\u001d\tY\u0001\u0001D\u0001\u0003\u001bAq!a\b\u0001\r\u0003\t\t\u0003C\u0005\u0002b\u0001\t\n\u0011\"\u0001\u0002d!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004bBA?\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u007f\u0002A\u0011AAA\u0011\u001d\tY\f\u0001C\u0001\u0003{Cq!a2\u0001\t\u0003\tI\rC\u0004\u0002X\u0002!I!!7\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\"9\u00111\u001e\u0001\u0005\n\u00055\bbBAy\u0001\u0011\u0005\u00111\u001f\u0002%\u0003\n\u001cHO]1di\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ*\u0011QDH\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0010\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g!\tIC&D\u0001+\u0015\tYc$A\u0003vi&d7/\u0003\u0002.U\t9Aj\\4hS:<\u0017AB2p]\u001aLw\r\u0005\u00021g5\t\u0011G\u0003\u00023=\u000511/\u001a:wKJL!\u0001N\u0019\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$\bCA\u001c9\u001b\u0005a\u0012BA\u001d\u001d\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\bCA\u001c=\u0013\tiDDA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\fa\u0001P5oSRtD\u0003\u0002!B\u0005\u000e\u0003\"a\u000e\u0001\t\u000b9\"\u0001\u0019A\u0018\t\u000bU\"\u0001\u0019\u0001\u001c\t\u000bi\"\u0001\u0019A\u001e\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0003\u0019\u0003\"aI$\n\u0005!##aA%oi\u0006i1m\u001c8ue>dG.\u001a:JI\u0002\na\u0003\\3bI\u0016\u0014\u0018I\u001c3JgJ\u0014V-];fgRl\u0015\r]\u000b\u0002\u0019B!QJ\u0015$U\u001b\u0005q%BA(Q\u0003\u001diW\u000f^1cY\u0016T!!\u0015\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002T\u001d\n\u0019Q*\u00199\u0011\t5\u0013V\u000b\u0019\t\u0003-zk\u0011a\u0016\u0006\u00031f\u000baaY8n[>t'BA\u0010[\u0015\tYF,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0006\u0019qN]4\n\u0005};&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003C\u001et!AY3\u000e\u0003\rT!\u0001Z,\u0002\u0011I,\u0017/^3tiNL!AZ2\u0002'1+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;\n\u0005!L'A\u0004)beRLG/[8o'R\fG/\u001a\u0006\u0003M\u000e\fq\u0003\\3bI\u0016\u0014\u0018I\u001c3JgJ\u0014V-];fgRl\u0015\r\u001d\u0011\u0002+M$x\u000e\u001d*fa2L7-\u0019*fcV,7\u000f^'baV\tQ\u000e\u0005\u0003N%\u001as\u0007cA'pc&\u0011\u0001O\u0014\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bCA\u001cs\u0013\t\u0019HD\u0001\fTi>\u0004(+\u001a9mS\u000e\f'+Z9vKN$\u0018J\u001c4p\u0003Y\u0019Ho\u001c9SKBd\u0017nY1SKF,Xm\u001d;NCB\u0004\u0013AH;qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\"s_.,'oU3u+\u00059\bcA'y\r&\u0011\u0011P\u0014\u0002\u0004'\u0016$\u0018aH;qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\"s_.,'oU3uA\u0005)S\u000f\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$\b+\u0019:uSRLwN\\%oM>l\u0015\r]\u000b\u0002{B!QJU+\u007f!\ry\u0018Q\u0001\b\u0004E\u0006\u0005\u0011bAA\u0002G\u0006)R\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$\u0018b\u00015\u0002\b)\u0019\u00111A2\u0002MU\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiB\u000b'\u000f^5uS>t\u0017J\u001c4p\u001b\u0006\u0004\b%A\u0005tK:$WI^3oiR!\u0011qBA\u000b!\r\u0019\u0013\u0011C\u0005\u0004\u0003'!#\u0001B+oSRDq!a\u0006\u0010\u0001\u0004\tI\"A\u0003fm\u0016tG\u000fE\u00028\u00037I1!!\b\u001d\u0005=\u0019uN\u001c;s_2dWM]#wK:$\u0018aC:f]\u0012\u0014V-];fgR$\u0002\"a\u0004\u0002$\u0005\u001d\u0012\u0011\u000b\u0005\u0007\u0003K\u0001\u0002\u0019\u0001$\u0002\u0011\t\u0014xn[3s\u0013\u0012Dq!!\u000b\u0011\u0001\u0004\tY#A\u0004sKF,Xm\u001d;1\t\u00055\u0012q\b\t\u0007\u0003_\t)$a\u000f\u000f\u0007\t\f\t$C\u0002\u00024\r\fa#\u00112tiJ\f7\r^\"p]R\u0014x\u000e\u001c*fcV,7\u000f^\u0005\u0005\u0003o\tIDA\u0004Ck&dG-\u001a:\u000b\u0007\u0005M2\r\u0005\u0003\u0002>\u0005}B\u0002\u0001\u0003\r\u0003\u0003\n9#!A\u0001\u0002\u000b\u0005\u00111\t\u0002\u0004?\u0012\"\u0014\u0003BA#\u0003\u0017\u00022aIA$\u0013\r\tI\u0005\n\u0002\b\u001d>$\b.\u001b8h!\r\u0011\u0017QJ\u0005\u0004\u0003\u001f\u001a'AF!cgR\u0014\u0018m\u0019;D_:$(o\u001c7SKF,Xm\u001d;\t\u0013\u0005M\u0003\u0003%AA\u0002\u0005U\u0013\u0001C2bY2\u0014\u0017mY6\u0011\u000f\r\n9&a\u0017\u0002\u0010%\u0019\u0011\u0011\f\u0013\u0003\u0013\u0019+hn\u0019;j_:\f\u0004c\u00012\u0002^%\u0019\u0011qL2\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0017!F:f]\u0012\u0014V-];fgR$C-\u001a4bk2$HeM\u000b\u0003\u0003KRC!!\u0016\u0002h-\u0012\u0011\u0011\u000e\t\u0005\u0003W\n)(\u0004\u0002\u0002n)!\u0011qNA9\u0003%)hn\u00195fG.,GMC\u0002\u0002t\u0011\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9(!\u001c\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0005oK^\u0014\u0015\r^2i)\t\ty!A\u0003dY\u0016\f'/\u0001\u0011bI\u0012dU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u\r>\u0014(I]8lKJ\u001cH\u0003DA\b\u0003\u0007\u000by*a)\u0002.\u0006E\u0006bBAC)\u0001\u0007\u0011qQ\u0001\nEJ|7.\u001a:JIN\u0004R!!#\u0002\u001a\u001asA!a#\u0002\u0016:!\u0011QRAJ\u001b\t\tyIC\u0002\u0002\u0012\u0002\na\u0001\u0010:p_Rt\u0014\"A\u0013\n\u0007\u0005]E%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0015Q\u0014\u0002\u0004'\u0016\f(bAALI!1\u0011\u0011\u0015\u000bA\u0002U\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002&R\u0001\r!a*\u000271,\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2i!\r9\u0014\u0011V\u0005\u0004\u0003Wc\"a\u0007'fC\u0012,'/S:s\u0003:$7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eC\u0004\u00020R\u0001\r!a\"\u0002\u0011I,\u0007\u000f\\5dCNDq!a-\u0015\u0001\u0004\t),A\u0003jg:+w\u000fE\u0002$\u0003oK1!!/%\u0005\u001d\u0011un\u001c7fC:\fq$\u00193e'R|\u0007OU3qY&\u001c\u0017MU3rk\u0016\u001cHOR8s\u0005J|7.\u001a:t)!\ty!a0\u0002B\u0006\r\u0007bBAC+\u0001\u0007\u0011q\u0011\u0005\u0007\u0003C+\u0002\u0019A+\t\u000f\u0005\u0015W\u00031\u0001\u00026\u0006yA-\u001a7fi\u0016\u0004\u0016M\u001d;ji&|g.\u0001\u0012bI\u0012,\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR4uN\u001d\"s_.,'o\u001d\u000b\u0007\u0003\u001f\tY-!4\t\u000f\u0005\u0015e\u00031\u0001\u0002\b\"9\u0011q\u001a\fA\u0002\u0005E\u0017A\u00039beRLG/[8ogB)\u00111[Ak+6\t\u0001+\u0003\u0002z!\u000692/\u001a8e\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fcV,7\u000f\u001e\u000b\u0007\u0003\u001f\tY.a8\t\r\u0005uw\u00031\u0001G\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007BBAq/\u0001\u00071(\u0001\bti\u0006$Xm\u00115b]\u001e,Gj\\4\u00025M,g\u000eZ+qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f^:\u0015\r\u0005=\u0011q]Au\u0011\u0019\ti\u000e\u0007a\u0001\r\"1\u0011\u0011\u001d\rA\u0002m\nqc]3oIN#x\u000e\u001d*fa2L7-\u0019*fcV,7\u000f^:\u0015\t\u0005=\u0011q\u001e\u0005\u0007\u0003;L\u0002\u0019\u0001$\u0002+M,g\u000e\u001a*fcV,7\u000f^:U_\n\u0013xn[3sgR!\u0011qBA{\u0011\u0019\tiN\u0007a\u0001\r\u0002")
public abstract class AbstractControllerBrokerRequestBatch
implements Logging {
    private final KafkaConfig config;
    private final ControllerContext controllerContext;
    private final StateChangeLogger stateChangeLogger;
    private final int controllerId;
    private final scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequest.PartitionState>> leaderAndIsrRequestMap;
    private final scala.collection.mutable.Map<Object, ListBuffer<StopReplicaRequestInfo>> stopReplicaRequestMap;
    private final scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet;
    private final scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequest.PartitionState> updateMetadataRequestPartitionInfoMap;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AbstractControllerBrokerRequestBatch abstractControllerBrokerRequestBatch = this;
        synchronized (abstractControllerBrokerRequestBatch) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequest.PartitionState>> leaderAndIsrRequestMap() {
        return this.leaderAndIsrRequestMap;
    }

    public scala.collection.mutable.Map<Object, ListBuffer<StopReplicaRequestInfo>> stopReplicaRequestMap() {
        return this.stopReplicaRequestMap;
    }

    public scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet() {
        return this.updateMetadataRequestBrokerSet;
    }

    public scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequest.PartitionState> updateMetadataRequestPartitionInfoMap() {
        return this.updateMetadataRequestPartitionInfoMap;
    }

    public abstract void sendEvent(ControllerEvent var1);

    public abstract void sendRequest(int var1, AbstractControlRequest.Builder<? extends AbstractControlRequest> var2, Function1<AbstractResponse, BoxedUnit> var3);

    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$3() {
        return null;
    }

    public void newBatch() {
        if (this.leaderAndIsrRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(135).append("Controller to broker state change requests batch is not empty while creating ").append("a new one. Some LeaderAndIsr state changes ").append(this.leaderAndIsrRequestMap()).append(" might be lost ").toString());
        }
        if (this.stopReplicaRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(134).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. Some StopReplica state changes ").append(this.stopReplicaRequestMap()).append(" might be lost ").toString());
        }
        if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(169).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. Some UpdateMetadata state changes to brokers ").append(this.updateMetadataRequestBrokerSet()).append(" with partition info ").append(this.updateMetadataRequestPartitionInfoMap()).append(" might be lost ").toString());
        }
    }

    public void clear() {
        this.leaderAndIsrRequestMap().clear();
        this.stopReplicaRequestMap().clear();
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
    }

    public void addLeaderAndIsrRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, Seq<Object> replicas, boolean isNew) {
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 >= 0)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> AbstractControllerBrokerRequestBatch.$anonfun$addLeaderAndIsrRequestForBrokers$2(this, topicPartition, leaderIsrAndControllerEpoch, replicas, isNew, BoxesRunTime.unboxToInt((Object)brokerId)));
        this.addUpdateMetadataRequestForBrokers((Seq<Object>)this.controllerContext.liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
    }

    public void addStopReplicaRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, boolean deletePartition) {
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 >= 0)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            ListBuffer stopReplicaInfos = (ListBuffer)this.stopReplicaRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.empty());
            stopReplicaInfos.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StopReplicaRequestInfo[]{new StopReplicaRequestInfo(new PartitionAndReplica(topicPartition, brokerId), deletePartition)}));
        });
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, Set<TopicPartition> partitions) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((TraversableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 >= 0));
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            this.updateMetadataRequestPartitionInfo$1(partition, this.controllerContext.topicsToBeDeleted().contains((Object)partition.topic()));
            return BoxedUnit.UNIT;
        });
    }

    private void sendLeaderAndIsrRequest(int controllerEpoch, StateChangeLogger stateChangeLog) {
        short leaderAndIsrRequestVersion = this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? (short)2 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_1_0_IV0$.MODULE$) ? (short)1 : 0);
        Set<Object> set = this.controllerContext.liveOrShuttingDownBrokerIds();
        this.leaderAndIsrRequestMap().filterKeys((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)elem -> set.contains((Object)BoxesRunTime.boxToInteger((int)elem))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$2(this, stateChangeLog, leaderAndIsrRequestVersion, controllerEpoch, x0$1);
            return BoxedUnit.UNIT;
        });
        this.leaderAndIsrRequestMap().clear();
    }

    private void sendUpdateMetadataRequests(int controllerEpoch, StateChangeLogger stateChangeLog) {
        this.updateMetadataRequestPartitionInfoMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$1(this, stateChangeLog, x0$1);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map partitionStates = Predef$.MODULE$.Map().empty().$plus$plus(this.updateMetadataRequestPartitionInfoMap());
        short updateMetadataRequestVersion = this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? (short)5 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_1_0_IV0$.MODULE$) ? (short)4 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_2_IV0$.MODULE$) ? (short)3 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV1$.MODULE$) ? (short)2 : (this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? (short)1 : 0))));
        Set liveBrokers = updateMetadataRequestVersion == 0 ? (Set)this.controllerContext.liveOrShuttingDownBrokers().map((Function1 & Serializable & scala.Serializable)broker -> {
            SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
            ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
            Node node = broker.node(listenerName);
            Seq endPoints = (Seq)new .colon.colon((Object)new UpdateMetadataRequest.EndPoint(node.host(), node.port(), securityProtocol, listenerName), (List)Nil$.MODULE$);
            return new UpdateMetadataRequest.Broker(broker.id(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(endPoints).asJava(), (String)broker.rack().orNull(Predef$.MODULE$.$conforms()));
        }, Set$.MODULE$.canBuildFrom()) : (Set)this.controllerContext.liveOrShuttingDownBrokers().map((Function1 & Serializable & scala.Serializable)broker -> {
            Seq endPoints = (Seq)broker.endPoints().map((Function1 & Serializable & scala.Serializable)endPoint -> new UpdateMetadataRequest.EndPoint(endPoint.host(), endPoint.port(), endPoint.securityProtocol(), endPoint.listenerName()), Seq$.MODULE$.canBuildFrom());
            return new UpdateMetadataRequest.Broker(broker.id(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(endPoints).asJava(), (String)broker.rack().orNull(Predef$.MODULE$.$conforms()));
        }, Set$.MODULE$.canBuildFrom());
        ((IterableLike)this.updateMetadataRequestBrokerSet().intersect(this.controllerContext.liveOrShuttingDownBrokerIds())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> {
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
            UpdateMetadataRequest.Builder updateMetadataRequest = new UpdateMetadataRequest.Builder(updateMetadataRequestVersion, this.controllerId(), controllerEpoch, brokerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(liveBrokers).asJava());
            this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)updateMetadataRequest, this.sendRequest$default$3());
        });
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
    }

    private void sendStopReplicaRequests(int controllerEpoch) {
        short stopReplicaRequestVersion = this.config.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? (short)1 : 0;
        Set<Object> set = this.controllerContext.liveOrShuttingDownBrokerIds();
        this.stopReplicaRequestMap().filterKeys((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)elem -> set.contains((Object)BoxesRunTime.boxToInteger((int)elem))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$4(this, stopReplicaRequestVersion, controllerEpoch, x0$1);
            return BoxedUnit.UNIT;
        });
        this.stopReplicaRequestMap().clear();
    }

    public void sendRequestsToBrokers(int controllerEpoch) {
        try {
            StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(controllerEpoch);
            this.sendLeaderAndIsrRequest(controllerEpoch, stateChangeLog);
            this.sendUpdateMetadataRequests(controllerEpoch, stateChangeLog);
            this.sendStopReplicaRequests(controllerEpoch);
        }
        catch (Throwable e) {
            if (this.leaderAndIsrRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Haven't been able to send leader and isr requests, current state of ").append("the map is ").append(this.leaderAndIsrRequestMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Haven't been able to send metadata update requests to brokers ").append(this.updateMetadataRequestBrokerSet()).append(", ").append("current state of the partition info is ").append(this.updateMetadataRequestPartitionInfoMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.stopReplicaRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(98).append("Haven't been able to send stop replica requests, current state of ").append("the map is ").append(this.stopReplicaRequestMap()).append(". Exception message: ").append(e).toString());
            }
            throw new IllegalStateException(e);
        }
    }

    public static final /* synthetic */ Option $anonfun$addLeaderAndIsrRequestForBrokers$2(AbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$1, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, Seq replicas$1, boolean isNew$1, int brokerId) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)$this.leaderAndIsrRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
        boolean alreadyNew = result.get((Object)topicPartition$1).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isNew));
        return result.put((Object)topicPartition$1, (Object)new LeaderAndIsrRequest.PartitionState(leaderIsrAndControllerEpoch$1.controllerEpoch(), leaderIsrAndControllerEpoch$1.leaderAndIsr().leader(), leaderIsrAndControllerEpoch$1.leaderAndIsr().leaderEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)leaderIsrAndControllerEpoch$1.leaderAndIsr().isr().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava(), leaderIsrAndControllerEpoch$1.leaderAndIsr().zkVersion(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas$1.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava(), isNew$1 || alreadyNew));
    }

    private final void updateMetadataRequestPartitionInfo$1(TopicPartition partition, boolean beingDeleted) {
        Some some;
        LeaderIsrAndControllerEpoch l;
        Option leaderIsrAndControllerEpochOpt = this.controllerContext.partitionLeadershipInfo().get((Object)partition);
        Option option = leaderIsrAndControllerEpochOpt;
        if (option instanceof Some && (l = (LeaderIsrAndControllerEpoch)(some = (Some)option).value()) != null) {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
            LeaderAndIsr leaderAndIsr = l.leaderAndIsr();
            int controllerEpoch = l.controllerEpoch();
            Seq<Object> replicas = this.controllerContext.partitionReplicaAssignment(partition);
            Seq offlineReplicas = (Seq)replicas.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$7 -> !$this.controllerContext.isReplicaOnline(x$7, partition, $this.controllerContext.isReplicaOnline$default$3()));
            if (beingDeleted) {
                LeaderAndIsr leaderDuringDelete = LeaderAndIsr$.MODULE$.duringDelete(leaderAndIsr.isr());
                leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderDuringDelete, controllerEpoch);
            } else {
                leaderIsrAndControllerEpoch = l;
            }
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = leaderIsrAndControllerEpoch;
            UpdateMetadataRequest.PartitionState partitionStateInfo = new UpdateMetadataRequest.PartitionState(leaderIsrAndControllerEpoch2.controllerEpoch(), leaderIsrAndControllerEpoch2.leaderAndIsr().leader(), leaderIsrAndControllerEpoch2.leaderAndIsr().leaderEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)leaderIsrAndControllerEpoch2.leaderAndIsr().isr().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava(), leaderIsrAndControllerEpoch2.leaderAndIsr().zkVersion(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)offlineReplicas.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava());
            this.updateMetadataRequestPartitionInfoMap().put((Object)partition, (Object)partitionStateInfo);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Leader not yet assigned for partition ").append(partition).append(". Skip sending UpdateMetadataRequest.").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$3(int broker$2, StateChangeLogger stateChangeLog$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        LeaderAndIsrRequest.PartitionState state = (LeaderAndIsrRequest.PartitionState)tuple2._2();
        String typeOfRequest = broker$2 == state.basePartitionState.leader ? "become-leader" : "become-follower";
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Sending ").append(typeOfRequest).append(" LeaderAndIsr request ").append(state).append(" to broker ").append(broker$2).append(" for partition ").append(topicPartition).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$2(AbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int broker = tuple2._1$mcI$sp();
        scala.collection.mutable.Map leaderAndIsrPartitionStates = (scala.collection.mutable.Map)tuple2._2();
        leaderAndIsrPartitionStates.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$3(broker, stateChangeLog$1, x0$2);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set leaderIds = ((TraversableOnce)leaderAndIsrPartitionStates.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)((LeaderAndIsrRequest.PartitionState)x$9._2()).basePartitionState.leader), Iterable$.MODULE$.canBuildFrom())).toSet();
        Set leaders = (Set)((SetLike)$this.controllerContext.liveOrShuttingDownBrokers().filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)leaderIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.node($this.config.interBrokerListenerName()), Set$.MODULE$.canBuildFrom());
        long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
        LeaderAndIsrRequest.Builder leaderAndIsrRequestBuilder = new LeaderAndIsrRequest.Builder(leaderAndIsrRequestVersion$1, $this.controllerId(), controllerEpoch$1, brokerEpoch, (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(leaderAndIsrPartitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(leaders).asJava());
        $this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)leaderAndIsrRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)r -> {
            $this.sendEvent(new LeaderAndIsrResponseReceived(r, broker));
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$1(AbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)tuple2._2();
        stateChangeLog$2.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Sending UpdateMetadata request ").append(partitionState).append(" to brokers ").append($this.updateMetadataRequestBrokerSet()).append(" ").append("for partition ").append(tp).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void stopReplicaPartitionDeleteResponseCallback$1(int brokerId, AbstractResponse response) {
        block0: {
            StopReplicaResponse stopReplicaResponse = (StopReplicaResponse)response;
            scala.collection.immutable.Map partitionErrorsForDeletingTopics = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(stopReplicaResponse.responses()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)this.controllerContext.isTopicDeletionInProgress(partition.topic()))).toMap(Predef$.MODULE$.$conforms());
            if (!partitionErrorsForDeletingTopics.nonEmpty()) break block0;
            this.sendEvent(new TopicDeletionStopReplicaResponseReceived(brokerId, stopReplicaResponse.error(), (Map<TopicPartition, Errors>)partitionErrorsForDeletingTopics));
        }
    }

    private final StopReplicaRequest.Builder createStopReplicaRequest$1(long brokerEpoch, Seq requests, boolean deletePartitions, short stopReplicaRequestVersion$1, int controllerEpoch$3) {
        java.util.List partitions = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requests.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.replica().topicPartition(), Seq$.MODULE$.canBuildFrom())).asJava();
        return new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, this.controllerId(), controllerEpoch$3, brokerEpoch, deletePartitions, (Collection)partitions);
    }

    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$4(AbstractControllerBrokerRequestBatch $this, short stopReplicaRequestVersion$1, int controllerEpoch$3, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int brokerId = tuple2._1$mcI$sp();
            ListBuffer replicaInfoList = (ListBuffer)tuple2._2();
            Tuple2 tuple22 = replicaInfoList.partition((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)r.deletePartition()));
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            ListBuffer stopReplicaWithDelete = (ListBuffer)tuple22._1();
            ListBuffer stopReplicaWithoutDelete = (ListBuffer)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)stopReplicaWithDelete, (Object)stopReplicaWithoutDelete);
            Tuple2 tuple24 = tuple23;
            ListBuffer stopReplicaWithDelete2 = (ListBuffer)tuple24._1();
            ListBuffer stopReplicaWithoutDelete2 = (ListBuffer)tuple24._2();
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
            if (stopReplicaWithDelete2.nonEmpty()) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("The stop replica request (delete = true) sent to broker ").append(brokerId).append(" is ").append(stopReplicaWithDelete2.mkString(",")).toString());
                StopReplicaRequest.Builder stopReplicaRequest = $this.createStopReplicaRequest$1(brokerEpoch, (Seq)stopReplicaWithDelete2, true, stopReplicaRequestVersion$1, controllerEpoch$3);
                Function1 & Serializable & scala.Serializable callback = (Function1 & Serializable & scala.Serializable)response -> {
                    $this.stopReplicaPartitionDeleteResponseCallback$1(brokerId, response);
                    return BoxedUnit.UNIT;
                };
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequest, (Function1<AbstractResponse, BoxedUnit>)callback);
            }
            if (stopReplicaWithoutDelete2.nonEmpty()) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("The stop replica request (delete = false) sent to broker ").append(brokerId).append(" is ").append(stopReplicaWithoutDelete2.mkString(",")).toString());
                StopReplicaRequest.Builder stopReplicaRequest = $this.createStopReplicaRequest$1(brokerEpoch, (Seq)stopReplicaWithoutDelete2, false, stopReplicaRequestVersion$1, controllerEpoch$3);
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequest, $this.sendRequest$default$3());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public AbstractControllerBrokerRequestBatch(KafkaConfig config, ControllerContext controllerContext, StateChangeLogger stateChangeLogger) {
        this.config = config;
        this.controllerContext = controllerContext;
        this.stateChangeLogger = stateChangeLogger;
        Logging.$init$(this);
        this.controllerId = config.brokerId();
        this.leaderAndIsrRequestMap = Map$.MODULE$.empty();
        this.stopReplicaRequestMap = Map$.MODULE$.empty();
        this.updateMetadataRequestBrokerSet = scala.collection.mutable.Set$.MODULE$.empty();
        this.updateMetadataRequestPartitionInfoMap = Map$.MODULE$.empty();
    }
}

