/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.Random;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtilities;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$User$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class AdminUtils$
implements Logging,
AdminUtilities {
    public static AdminUtils$ MODULE$;
    private final Random rand;
    private final String AdminClientId;
    private final String EntityConfigChangeZnodePrefix;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new AdminUtils$();
    }

    @Override
    public void changeConfigs(ZkUtils zkUtils, String entityType, String entityName, Properties configs) {
        AdminUtilities.changeConfigs$(this, zkUtils, entityType, entityName, configs);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AdminUtils$ adminUtils$ = this;
        synchronized (adminUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Random rand() {
        return this.rand;
    }

    public String AdminClientId() {
        return this.AdminClientId;
    }

    public String EntityConfigChangeZnodePrefix() {
        return this.EntityConfigChangeZnodePrefix;
    }

    public Map<Object, Seq<Object>> assignReplicasToBrokers(Seq<BrokerMetadata> brokerMetadatas, int nPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        Map<Object, Seq<Object>> map;
        if (nPartitions <= 0) {
            throw new InvalidPartitionsException("Number of partitions must be larger than 0.");
        }
        if (replicationFactor <= 0) {
            throw new InvalidReplicationFactorException("Replication factor must be larger than 0.");
        }
        if (replicationFactor > brokerMetadatas.size()) {
            throw new InvalidReplicationFactorException(new StringBuilder(53).append("Replication factor: ").append(replicationFactor).append(" larger than available brokers: ").append(brokerMetadatas.size()).append(".").toString());
        }
        if (brokerMetadatas.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$assignReplicasToBrokers$1(x$1)))) {
            map = this.assignReplicasToBrokersRackUnaware(nPartitions, replicationFactor, (Seq<Object>)((Seq)brokerMetadatas.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Seq$.MODULE$.canBuildFrom())), fixedStartIndex, startPartitionId);
        } else {
            if (brokerMetadatas.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$assignReplicasToBrokers$3(x$3)))) {
                throw new AdminOperationException("Not all brokers have rack information for replica rack aware assignment.");
            }
            map = this.assignReplicasToBrokersRackAware(nPartitions, replicationFactor, brokerMetadatas, fixedStartIndex, startPartitionId);
        }
        return map;
    }

    public int assignReplicasToBrokers$default$4() {
        return -1;
    }

    public int assignReplicasToBrokers$default$5() {
        return -1;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackUnaware(int nPartitions, int replicationFactor, Seq<Object> brokerList, int fixedStartIndex, int startPartitionId) {
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        int[] brokerArray = (int[])brokerList.toArray(ClassTag$.MODULE$.Int());
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length);
        IntRef currentPartitionId = IntRef.create((int)package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = IntRef.create((int)(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            if (currentPartitionId$1.elem > 0 && currentPartitionId$1.elem % brokerArray.length == 0) {
                ++nextReplicaShift$1.elem;
            }
            int firstReplicaIndex = (currentPartitionId$1.elem + startIndex) % brokerArray.length;
            ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerArray[firstReplicaIndex]}));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), replicationFactor - 1).foreach((Function1 & Serializable & scala.Serializable)j -> replicaBuffer.$plus$eq((Object)BoxesRunTime.boxToInteger((int)brokerArray[AdminUtils$.MODULE$.replicaIndex(firstReplicaIndex, nextReplicaShift.elem, BoxesRunTime.unboxToInt((Object)j), brokerArray.length)])));
            ret.put((Object)BoxesRunTime.boxToInteger((int)currentPartitionId$1.elem), (Object)replicaBuffer);
            ++currentPartitionId$1.elem;
        });
        return ret;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackAware(int nPartitions, int replicationFactor, Seq<BrokerMetadata> brokerMetadatas, int fixedStartIndex, int startPartitionId) {
        scala.collection.immutable.Map brokerRackMap = ((TraversableOnce)brokerMetadatas.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends BrokerMetadata, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int id = A1.id();
                    Option<String> option = A1.rack();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String rack = (String)some.value();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)), (Object)rack);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(BrokerMetadata x1) {
                Option<String> option;
                BrokerMetadata brokerMetadata = x1;
                boolean bl = brokerMetadata != null && (option = brokerMetadata.rack()) instanceof Some;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int numRacks = brokerRackMap.values().toSet().size();
        IndexedSeq<Object> arrangedBrokerList = this.getRackAlternatedBrokerList((Map<Object, String>)brokerRackMap);
        int numBrokers = arrangedBrokerList.size();
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size());
        IntRef currentPartitionId = IntRef.create((int)package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = IntRef.create((int)(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size())));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_2 -> {
            if (currentPartitionId$2.elem > 0 && currentPartitionId$2.elem % arrangedBrokerList.size() == 0) {
                ++nextReplicaShift$2.elem;
            }
            int firstReplicaIndex = (currentPartitionId$2.elem + startIndex) % arrangedBrokerList.size();
            int leader = BoxesRunTime.unboxToInt((Object)arrangedBrokerList.apply(firstReplicaIndex));
            ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
            scala.collection.mutable.Set racksWithReplicas = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)brokerRackMap.apply((Object)BoxesRunTime.boxToInteger((int)leader))}));
            scala.collection.mutable.Set brokersWithReplicas = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
            IntRef k = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), replicationFactor - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                boolean done = false;
                while (!done) {
                    int broker = BoxesRunTime.unboxToInt((Object)arrangedBrokerList.apply(MODULE$.replicaIndex(firstReplicaIndex, nextReplicaShift$2.elem * numRacks, k$1.elem, arrangedBrokerList.size())));
                    String rack = (String)brokerRackMap.apply((Object)BoxesRunTime.boxToInteger((int)broker));
                    if (!(racksWithReplicas.contains((Object)rack) && racksWithReplicas.size() != numRacks || brokersWithReplicas.contains((Object)BoxesRunTime.boxToInteger((int)broker)) && brokersWithReplicas.size() != numBrokers)) {
                        replicaBuffer.$plus$eq((Object)BoxesRunTime.boxToInteger((int)broker));
                        racksWithReplicas.$plus$eq((Object)rack);
                        brokersWithReplicas.$plus$eq((Object)BoxesRunTime.boxToInteger((int)broker));
                        done = true;
                    }
                    ++k$1.elem;
                }
            });
            ret.put((Object)BoxesRunTime.boxToInteger((int)currentPartitionId$2.elem), (Object)replicaBuffer);
            ++currentPartitionId$2.elem;
        });
        return ret;
    }

    public IndexedSeq<Object> getRackAlternatedBrokerList(Map<Object, String> brokerRackMap) {
        Map brokersIteratorByRack = (Map)this.getInverseMap(brokerRackMap).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String rack = (String)tuple2._1();
            Seq brokers = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)rack, (Object)brokers.toIterator());
            return tuple22;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        String[] racks = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokersIteratorByRack.keys().toArray(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering.String$.MODULE$);
        ArrayBuffer result = new ArrayBuffer();
        int rackIndex = 0;
        while (result.size() < brokerRackMap.size()) {
            Iterator rackIterator = (Iterator)brokersIteratorByRack.apply((Object)racks[rackIndex]);
            Object object = rackIterator.hasNext() ? result.$plus$eq(rackIterator.next()) : BoxedUnit.UNIT;
            rackIndex = (rackIndex + 1) % racks.length;
        }
        return result;
    }

    public Map<String, Seq<Object>> getInverseMap(Map<Object, String> brokerRackMap) {
        return (Map)((TraversableLike)brokerRackMap.toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            String rack = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)rack, (Object)BoxesRunTime.boxToInteger((int)id));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x0$2 -> {
            String rack;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = rack = (String)tuple2._1();
            return string;
        }).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String rack = (String)tuple2._1();
            Seq rackAndIdList = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)rack, ((SeqLike)rackAndIdList.map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)AdminUtils$.$anonfun$getInverseMap$4(x0$4)), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    public Map<Object, Seq<Object>> addPartitions(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment, boolean validateOnly) {
        Map proposedAssignment;
        block1: {
            Seq existingAssignmentPartition0 = (Seq)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable & scala.Serializable)() -> {
                throw new AdminOperationException(new StringBuilder(92).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").append("Assignment: ").append(existingAssignment).toString());
            });
            int partitionsToAdd = numPartitions - existingAssignment.size();
            if (partitionsToAdd <= 0) {
                throw new InvalidPartitionsException(new StringBuilder(120).append("The number of partitions for a topic can only be increased. ").append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").append(numPartitions).append(" would not be an increase.").toString());
            }
            replicaAssignment.foreach((Function1 & Serializable & scala.Serializable)proposedReplicaAssignment -> {
                AdminUtils$.MODULE$.validateReplicaAssignment((Map<Object, Seq<Object>>)proposedReplicaAssignment, (Seq<Object>)existingAssignmentPartition0, (Set<Object>)((TraversableOnce)allBrokers.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Seq$.MODULE$.canBuildFrom())).toSet());
                return BoxedUnit.UNIT;
            });
            Map proposedAssignmentForNewPartitions = (Map)replicaAssignment.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                int startIndex = package$.MODULE$.max(0, allBrokers.indexWhere((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$addPartitions$5(existingAssignmentPartition0, x$5))));
                return MODULE$.assignReplicasToBrokers(allBrokers, partitionsToAdd, existingAssignmentPartition0.size(), startIndex, existingAssignment.size());
            });
            proposedAssignment = existingAssignment.$plus$plus((GenTraversableOnce)proposedAssignmentForNewPartitions);
            if (validateOnly) break block1;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Creating ").append(partitionsToAdd).append(" partitions for '").append(topic).append("' with the following replica assignment: ").append(proposedAssignmentForNewPartitions).append(".").toString());
            ZkUtils x$1 = zkUtils;
            String x$2 = topic;
            Map x$3 = proposedAssignment;
            boolean x$4 = true;
            Properties x$5 = this.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
            this.createOrUpdateTopicPartitionAssignmentPathInZK(x$1, x$2, (Map<Object, Seq<Object>>)x$3, x$5, x$4);
        }
        return proposedAssignment;
    }

    public int addPartitions$default$5() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> addPartitions$default$6() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$7() {
        return false;
    }

    public Map<Object, Seq<Object>> parseReplicaAssignment(String replicaAssignmentsString, int startPartitionId) {
        String[] assignmentStrings = replicaAssignmentsString.split(",");
        scala.collection.mutable.Map assignmentMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        IntRef partitionId = IntRef.create((int)startPartitionId);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])assignmentStrings)).foreach((Function1 & Serializable & scala.Serializable)assignmentString -> {
            AdminUtils$.$anonfun$parseReplicaAssignment$1(assignmentMap, partitionId, assignmentString);
            return BoxedUnit.UNIT;
        });
        return assignmentMap;
    }

    private void validateReplicaAssignment(Map<Object, Seq<Object>> replicaAssignment, Seq<Object> existingAssignmentPartition0, Set<Object> availableBrokerIds) {
        replicaAssignment.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq replicas;
            int partitionId;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                partitionId = tuple2._1$mcI$sp();
                replicas = (Seq)tuple2._2();
                if (replicas.isEmpty()) {
                    throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
                }
                if (replicas.size() != replicas.toSet().size()) {
                    throw new InvalidReplicaAssignmentException(new StringBuilder(72).append("Duplicate brokers not allowed in replica assignment: ").append(replicas.mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString());
                }
                if (!replicas.toSet().subsetOf((GenSet)availableBrokerIds)) {
                    throw new BrokerNotAvailableException(new StringBuilder(101).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").append("Specified brokers: ").append(replicas.mkString(", ")).append(", ").append("available brokers: ").append(availableBrokerIds.mkString(", ")).append(".").toString());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
            return tuple22;
        });
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new scala.Serializable(existingAssignmentPartition0){
            public static final long serialVersionUID = 0L;
            private final Seq existingAssignmentPartition0$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Seq<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int partition = A1._1$mcI$sp();
                    Seq replicas = (Seq)A1._2();
                    if (replicas.size() != this.existingAssignmentPartition0$2.size()) {
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Seq<Object>> x1) {
                Seq replicas;
                Tuple2<Object, Seq<Object>> tuple2 = x1;
                boolean bl = tuple2 != null && (replicas = (Seq)tuple2._2()).size() != this.existingAssignmentPartition0$2.size();
                return bl;
            }
            {
                this.existingAssignmentPartition0$2 = existingAssignmentPartition0$2;
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        if (badRepFactors.nonEmpty()) {
            Seq sortedBadRepFactors = (Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminUtils$.$anonfun$validateReplicaAssignment$2(x0$2)), (Ordering)Ordering.Int$.MODULE$);
            Seq partitions = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminUtils$.$anonfun$validateReplicaAssignment$3(x0$3)), Seq$.MODULE$.canBuildFrom());
            Seq repFactors = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)AdminUtils$.$anonfun$validateReplicaAssignment$4(x0$4)), Seq$.MODULE$.canBuildFrom());
            throw new InvalidReplicaAssignmentException(new StringBuilder(131).append("Inconsistent replication factor between partitions, ").append("partition 0 has ").append(existingAssignmentPartition0.size()).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString());
        }
    }

    public void deleteTopic(ZkUtils zkUtils, String topic) {
        if (this.topicExists(zkUtils, topic)) {
            try {
                zkUtils.createPersistentPath(ZkUtils$.MODULE$.getDeleteTopicPath(topic), zkUtils.createPersistentPath$default$2(), zkUtils.createPersistentPath$default$3());
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(new StringOps(Predef$.MODULE$.augmentString("topic %s is already marked for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e2) {
                throw new AdminOperationException(e2);
            }
        } else {
            throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
        }
    }

    public boolean topicExists(ZkUtils zkUtils, String topic) {
        return zkUtils.pathExists(ZkUtils$.MODULE$.getTopicPath(topic));
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(ZkUtils zkUtils, RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        RackAwareMode rackAwareMode2;
        Seq<Broker> allBrokers = zkUtils.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable & scala.Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable & scala.Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$getBrokerMetadatas$4(x$7)));
        RackAwareMode rackAwareMode3 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode3 != null ? !rackAwareMode3.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        Seq seq = RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode2 = rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode2) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack()), Seq$.MODULE$.canBuildFrom()));
        Seq brokerMetadatas = seq;
        return (Seq)brokerMetadatas.sortBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$2() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$3() {
        return None$.MODULE$;
    }

    public void createTopic(ZkUtils zkUtils, String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(zkUtils, rackAwareMode, this.getBrokerMetadatas$default$3());
        Map<Object, Seq<Object>> replicaAssignment = this.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, this.assignReplicasToBrokers$default$4(), this.assignReplicasToBrokers$default$5());
        this.createOrUpdateTopicPartitionAssignmentPathInZK(zkUtils, topic, replicaAssignment, topicConfig, this.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
    }

    public Properties createTopic$default$5() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$6() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public void validateCreateOrUpdateTopic(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config, boolean update) {
        block6: {
            Topic.validate((String)topic);
            if (!update) {
                if (this.topicExists(zkUtils, topic)) {
                    throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
                }
                if (Topic.hasCollisionChars((String)topic)) {
                    Seq<String> allTopics = zkUtils.getAllTopics();
                    if (allTopics.contains((Object)topic)) {
                        throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
                    }
                    Seq collidingTopics = (Seq)allTopics.filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$validateCreateOrUpdateTopic$1(topic, x$9)));
                    if (collidingTopics.nonEmpty()) {
                        throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
                    }
                }
            }
            if (((TraversableOnce)partitionReplicaAssignment.values().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size()), Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
                throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
            }
            partitionReplicaAssignment.values().foreach((Function1 & Serializable & scala.Serializable)reps -> {
                AdminUtils$.$anonfun$validateCreateOrUpdateTopic$3(partitionReplicaAssignment, reps);
                return BoxedUnit.UNIT;
            });
            if (update) break block6;
            LogConfig$.MODULE$.validate(config);
        }
    }

    public void createOrUpdateTopicPartitionAssignmentPathInZK(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config, boolean update) {
        this.validateCreateOrUpdateTopic(zkUtils, topic, partitionReplicaAssignment, config, update);
        if (!update) {
            this.writeEntityConfig(zkUtils, ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Topic(), topic), config);
        }
        this.writeTopicPartitionAssignment(zkUtils, topic, partitionReplicaAssignment, update);
    }

    public Properties createOrUpdateTopicPartitionAssignmentPathInZK$default$4() {
        return new Properties();
    }

    public boolean createOrUpdateTopicPartitionAssignmentPathInZK$default$5() {
        return false;
    }

    private void writeTopicPartitionAssignment(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> replicaAssignment, boolean update) {
        try {
            String zkPath = ZkUtils$.MODULE$.getTopicPath(topic);
            String jsonPartitionData = zkUtils.replicaAssignmentZkData((Map<String, Seq<Object>>)((Map)replicaAssignment.map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)BoxesRunTime.boxToInteger((int)e._1$mcI$sp())).toString()), e._2()), scala.collection.Map$.MODULE$.canBuildFrom())));
            if (!update) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Topic creation ").append(jsonPartitionData).toString());
                zkUtils.createPersistentPath(zkPath, jsonPartitionData, zkUtils.createPersistentPath$default$3());
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Topic update ").append(jsonPartitionData).toString());
                zkUtils.updatePersistentPath(zkPath, jsonPartitionData, zkUtils.updatePersistentPath$default$3());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{zkPath, jsonPartitionData})));
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    @Override
    public void changeClientIdConfig(ZkUtils zkUtils, String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(zkUtils, ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    @Override
    public void changeUserOrUserClientIdConfig(ZkUtils zkUtils, String sanitizedEntityName, Properties configs) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        java.util.Map<String, Object> map = !(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients") ? DynamicConfig$Client$.MODULE$.validate(configs) : DynamicConfig$User$.MODULE$.validate(configs);
        this.changeEntityConfig(zkUtils, ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateTopicConfig(ZkUtils zkUtils, String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.topicExists(zkUtils, topic)) {
            throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" does not exist.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
        LogConfig$.MODULE$.validate(configs);
    }

    @Override
    public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configs) {
        this.validateTopicConfig(zkUtils, topic, configs);
        this.changeEntityConfig(zkUtils, ConfigType$.MODULE$.Topic(), topic, configs);
    }

    @Override
    public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokers, Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> MODULE$.changeEntityConfig(zkUtils, ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)broker)).toString(), configs));
    }

    private void changeEntityConfig(ZkUtils zkUtils, String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder(0).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        String entityConfigPath = ZkUtils$.MODULE$.getEntityConfigPath(rootEntityType, fullSanitizedEntityName);
        this.writeEntityConfig(zkUtils, entityConfigPath, configs);
        String seqNode = new StringBuilder(1).append(ZkUtils$.MODULE$.ConfigChangesPath()).append("/").append(this.EntityConfigChangeZnodePrefix()).toString();
        String content = Json$.MODULE$.legacyEncodeAsString(this.getConfigChangeZnodeData(sanitizedEntityPath));
        zkUtils.createSequentialPersistentPath(seqNode, content, zkUtils.createSequentialPersistentPath$default$3());
    }

    public Map<String, Object> getConfigChangeZnodeData(String sanitizedEntityPath) {
        return (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_path"), (Object)sanitizedEntityPath)}));
    }

    private void writeEntityConfig(ZkUtils zkUtils, String entityPath, Properties config) {
        Map map = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), JavaConverters$.MODULE$.propertiesAsScalaMapConverter(config).asScala())}));
        zkUtils.updatePersistentPath(entityPath, Json$.MODULE$.legacyEncodeAsString(map), zkUtils.updatePersistentPath$default$3());
    }

    @Override
    public Properties fetchEntityConfig(ZkUtils zkUtils, String rootEntityType, String sanitizedEntityName) {
        Properties props;
        block0: {
            String entityConfigPath = ZkUtils$.MODULE$.getEntityConfigPath(rootEntityType, sanitizedEntityName);
            String str = (String)((Option)zkUtils.readDataMaybeNull(entityConfigPath)._1()).orNull(Predef$.MODULE$.$conforms());
            props = new Properties();
            if (str == null) break block0;
            Json$.MODULE$.parseFull(str).foreach((Function1 & Serializable & scala.Serializable)jsValue -> {
                AdminUtils$.$anonfun$fetchEntityConfig$1(str, entityConfigPath, props, jsValue);
                return BoxedUnit.UNIT;
            });
        }
        return props;
    }

    public Map<String, Properties> fetchAllTopicConfigs(ZkUtils zkUtils) {
        return ((TraversableOnce)zkUtils.getAllTopics().map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)MODULE$.fetchEntityConfig(zkUtils, ConfigType$.MODULE$.Topic(), (String)topic)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(ZkUtils zkUtils, String entityType) {
        return ((TraversableOnce)zkUtils.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable & scala.Serializable)entity -> new Tuple2(entity, (Object)MODULE$.fetchEntityConfig(zkUtils, entityType, (String)entity)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(ZkUtils zkUtils, String rootEntityType, String childEntityType) {
        return ((TraversableOnce)((TraversableLike)AdminUtils$.entityPaths$1(zkUtils, (Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable & scala.Serializable)entity -> AdminUtils$.entityPaths$1(zkUtils, (Option)new Some((Object)new StringBuilder(0).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)entityPath -> new Tuple2(entityPath, (Object)MODULE$.fetchEntityConfig(zkUtils, rootEntityType, (String)entityPath)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private int replicaIndex(int firstReplicaIndex, int secondReplicaShift, int replicaIndex, int nBrokers) {
        int shift = 1 + (secondReplicaShift + replicaIndex) % (nBrokers - 1);
        return (firstReplicaIndex + shift) % nBrokers;
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToBrokers$1(BrokerMetadata x$1) {
        return x$1.rack().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToBrokers$3(BrokerMetadata x$3) {
        return x$3.rack().isEmpty();
    }

    public static final /* synthetic */ int $anonfun$getInverseMap$4(Tuple2 x0$4) {
        int id;
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = id = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$5(Seq existingAssignmentPartition0$1, BrokerMetadata x$5) {
        return x$5.id() >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ int $anonfun$parseReplicaAssignment$2(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6.trim())).toInt();
    }

    public static final /* synthetic */ void $anonfun$parseReplicaAssignment$1(scala.collection.mutable.Map assignmentMap$1, IntRef partitionId$1, String assignmentString) {
        Seq brokerIds = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])assignmentString.split(":"))).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)AdminUtils$.$anonfun$parseReplicaAssignment$2(x$6)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSeq();
        assignmentMap$1.put((Object)BoxesRunTime.boxToInteger((int)partitionId$1.elem), (Object)brokerIds);
        ++partitionId$1.elem;
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$2) {
        int partitionId;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = partitionId = tuple2._1$mcI$sp();
        return n;
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$3) {
        int partitionId;
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = partitionId = tuple2._1$mcI$sp();
        return n;
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$4) {
        int rf;
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = rf = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$7) {
        return x$7.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateCreateOrUpdateTopic$1(String topic$2, String x$9) {
        return Topic.hasCollision((String)topic$2, (String)x$9);
    }

    public static final /* synthetic */ void $anonfun$validateCreateOrUpdateTopic$3(Map partitionReplicaAssignment$1, Seq reps) {
        if (reps.size() != reps.toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$1).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$fetchEntityConfig$1(String str$1, String entityConfigPath$1, Properties props$1, JsonValue jsValue) {
        JsonObject jsObject = (JsonObject)jsValue.asJsonObjectOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(50).append("Unexpected value in config: ").append(str$1).append(", entity_config_path: ").append(entityConfigPath$1).toString());
        });
        Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)jsObject.apply("version").to(DecodeJson$DecodeInt$.MODULE$)) == 1);
        JsonObject config = (JsonObject)jsObject.get("config").flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.asJsonObjectOption()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(17).append("Invalid ").append(entityConfigPath$1).append(" config: ").append(str$1).toString());
        });
        config.iterator().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            JsonValue v = (JsonValue)tuple2._2();
            Object object = props$1.setProperty(k, v.to(DecodeJson$DecodeString$.MODULE$));
            return object;
        });
    }

    private static final Seq entityPaths$1(ZkUtils zkUtils, Option rootPath, String rootEntityType$1) {
        Seq seq;
        String string;
        Option option = rootPath;
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            string = new StringBuilder(0).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)option);
        }
        String root = string;
        Seq entityNames = zkUtils.getAllEntitiesWithConfig(root);
        Option option2 = rootPath;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String path = (String)some.value();
            seq = (Seq)entityNames.map((Function1 & Serializable & scala.Serializable)entityName -> new StringBuilder(0).append(path).append('/').append((String)entityName).toString(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option2)) {
            seq = entityNames;
        } else {
            throw new MatchError((Object)option2);
        }
        return seq;
    }

    private AdminUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        AdminUtilities.$init$(this);
        this.rand = new Random();
        this.AdminClientId = "__admin_client";
        this.EntityConfigChangeZnodePrefix = "config_change_";
    }
}

