/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0011#\u0001\u001dB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\n\u0003\u0002\u0011\t\u0011)A\u0005Y\tC\u0011b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001R$\t\u0013!\u0003!\u0011!Q\u0001\n%c\u0005\"B'\u0001\t\u0003q\u0005b\u0002+\u0001\u0001\u0004%I!\u0016\u0005\b3\u0002\u0001\r\u0011\"\u0003[\u0011\u0019\u0001\u0007\u0001)Q\u0005-\")Q\r\u0001C!M\")q\r\u0001C!Q\")\u0011\u000e\u0001C\u0005U\")Q\u000f\u0001C\u0005m\")\u0011\u0010\u0001C\u0001+\")!\u0010\u0001C\u0005+\")1\u0010\u0001C\u0001y\")a\u0010\u0001C!\u007f\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001\"CA\r\u0001E\u0005I\u0011AA\u000e\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!!\u000f\u0001\t\u0003\nY\u0004C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F!9\u00111\n\u0001\u0005\n\u00055\u0003bBA*\u0001\u0011\u0005\u00131\b\u0005\r\u0003+\u0002\u0001\u0013aA\u0001\u0002\u0013%am\u0012\u0005\u000e\u0003/\u0002\u0001\u0013aA\u0001\u0002\u0013%\u0011\u0011\f\"\t\u001d\u0005m\u0003\u0001%A\u0002\u0002\u0003%I!!\u0018\u0002b\u001dI\u00111\r\u0012\u0002\u0002#\u0005\u0011Q\r\u0004\tC\t\n\t\u0011#\u0001\u0002h!1Q*\bC\u0001\u0003_B\u0011\"!\u001d\u001e#\u0003%\t!a\u001d\t\u0013\u0005]T$%A\u0005\u0002\u0005m!!\u0003+j[\u0016Le\u000eZ3y\u0015\t\u0019C%A\u0002m_\u001eT\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001F\r\t\u0005S)bC&D\u0001#\u0013\tY#EA\u0007BEN$(/Y2u\u0013:$W\r\u001f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0005\u0019>tw\r\u0005\u00024m5\tAG\u0003\u00026I\u0005)Q\u000f^5mg&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0003\u0015yf-\u001b7f!\tQt(D\u0001<\u0015\taT(\u0001\u0002j_*\ta(\u0001\u0003kCZ\f\u0017B\u0001!<\u0005\u00111\u0015\u000e\\3\u0002\u0015\t\f7/Z(gMN,G/\u0003\u0002BU\u0005aQ.\u0019=J]\u0012,\u0007pU5{KB\u0011Q&R\u0005\u0003\r:\u00121!\u00138u\u0013\t\u0019%&\u0001\u0005xe&$\u0018M\u00197f!\ti#*\u0003\u0002L]\t9!i\\8mK\u0006t\u0017B\u0001%+\u0003\u0019a\u0014N\\5u}Q)q\nU)S'B\u0011\u0011\u0006\u0001\u0005\u0006q\u0015\u0001\r!\u000f\u0005\u0006\u0003\u0016\u0001\r\u0001\f\u0005\b\u0007\u0016\u0001\n\u00111\u0001E\u0011\u001dAU\u0001%AA\u0002%\u000b!b\u00187bgR,e\u000e\u001e:z+\u00051\u0006CA\u0015X\u0013\tA&EA\bUS6,7\u000f^1na>3gm]3u\u00039yF.Y:u\u000b:$(/_0%KF$\"a\u00170\u0011\u00055b\u0016BA//\u0005\u0011)f.\u001b;\t\u000f};\u0011\u0011!a\u0001-\u0006\u0019\u0001\u0010J\u0019\u0002\u0017}c\u0017m\u001d;F]R\u0014\u0018\u0010\t\u0015\u0003\u0011\t\u0004\"!L2\n\u0005\u0011t#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0013\u0015tGO]=TSj,W#\u0001#\u0002\r%\u001ch)\u001e7m+\u0005I\u0015!\u0003;j[\u0016\u001cH/Y7q)\ra3n\u001d\u0005\u0006Y.\u0001\r!\\\u0001\u0007EV4g-\u001a:\u0011\u00059\fX\"A8\u000b\u0005Al\u0014a\u00018j_&\u0011!o\u001c\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"\u0002;\f\u0001\u0004!\u0015!\u00018\u0002\u001dI,G.\u0019;jm\u0016|eMZ:fiR\u0019Ai\u001e=\t\u000b1d\u0001\u0019A7\t\u000bQd\u0001\u0019\u0001#\u0002\u00131\f7\u000f^#oiJL\u0018A\u00067bgR,e\u000e\u001e:z\rJ|W.\u00138eKb4\u0015\u000e\\3\u0002\u000b\u0015tGO]=\u0015\u0005Yk\b\"\u0002;\u0010\u0001\u0004!\u0015A\u00039beN,WI\u001c;ssR1\u0011\u0011AA\u0004\u0003\u0013\u00012!KA\u0002\u0013\r\t)A\t\u0002\u000b\u0013:$W\r_#oiJL\b\"\u00027\u0011\u0001\u0004i\u0007\"\u0002;\u0011\u0001\u0004!\u0015aC7bs\n,\u0017\t\u001d9f]\u0012$raWA\b\u0003#\t)\u0002C\u0003j#\u0001\u0007A\u0006\u0003\u0004\u0002\u0014E\u0001\r\u0001L\u0001\u0007_\u001a47/\u001a;\t\u0011\u0005]\u0011\u0003%AA\u0002%\u000bQb]6ja\u001a+H\u000e\\\"iK\u000e\\\u0017!F7bs\n,\u0017\t\u001d9f]\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0003;Q3!SA\u0010W\t\t\t\u0003\u0005\u0003\u0002$\u00055RBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0016]\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0012Q\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u00027p_.,\b\u000fF\u0002W\u0003kAa!a\u000e\u0014\u0001\u0004a\u0013a\u0004;be\u001e,G\u000fV5nKN$\u0018-\u001c9\u0002\u0011Q\u0014XO\\2bi\u0016$\u0012aW\u0001\u000biJ,hnY1uKR{GcA.\u0002B!1\u00111C\u000bA\u00021\naA]3tSj,GcA%\u0002H!1\u0011\u0011\n\fA\u0002\u0011\u000bqA\\3x'&TX-A\tueVt7-\u0019;f)>,e\u000e\u001e:jKN$2aWA(\u0011\u0019\t\tf\u0006a\u0001\t\u00069QM\u001c;sS\u0016\u001c\u0018aC:b]&$\u0018p\u00115fG.\f!c];qKJ$S.\u0019=J]\u0012,\u0007pU5{K\u0006\u00012/\u001e9fe\u0012\u0012\u0017m]3PM\u001a\u001cX\r^\u000b\u0002Y\u0005a1/\u001e9fe\u0012\u0012Xm]5{KR\u0019\u0011*a\u0018\t\r\u0005%3\u00041\u0001E\u0013\r\t\u0019EK\u0001\n)&lW-\u00138eKb\u0004\"!K\u000f\u0014\u0007u\tI\u0007E\u0002.\u0003WJ1!!\u001c/\u0005\u0019\te.\u001f*fMR\u0011\u0011QM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005U$f\u0001#\u0002 \u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\u0002")
public class TimeIndex
extends AbstractIndex<Object, Object> {
    private volatile TimestampOffset _lastEntry = this.lastEntryFromIndexFile();

    public static boolean $lessinit$greater$default$4() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$3();
    }

    private /* synthetic */ int super$maxIndexSize() {
        return super.maxIndexSize();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    private /* synthetic */ boolean super$resize(int newSize) {
        return super.resize(newSize);
    }

    private TimestampOffset _lastEntry() {
        return this._lastEntry;
    }

    private void _lastEntry_$eq(TimestampOffset x$1) {
        this._lastEntry = x$1;
    }

    @Override
    public int entrySize() {
        return 12;
    }

    @Override
    public boolean isFull() {
        return this.entries() >= this.maxEntries() - 1;
    }

    private long timestamp(ByteBuffer buffer, int n) {
        return buffer.getLong(n * this.entrySize());
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 8);
    }

    public TimestampOffset lastEntry() {
        return this._lastEntry();
    }

    private TimestampOffset lastEntryFromIndexFile() {
        return (TimestampOffset)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            TimestampOffset timestampOffset;
            int n = this._entries();
            switch (n) {
                case 0: {
                    timestampOffset = new TimestampOffset(-1L, this.super$baseOffset());
                    break;
                }
                default: {
                    timestampOffset = (TimestampOffset)this.parseEntry(this.mmap(), n - 1);
                    break;
                }
            }
            return timestampOffset;
        });
    }

    public TimestampOffset entry(int n) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringBuilder(48).append("Attempt to fetch the ").append(n).append("th entry from  time index ").append(this.file().getAbsolutePath()).append(" ").append(new StringBuilder(16).append("which has size ").append(this._entries()).append(".").toString()).toString());
            }
            ByteBuffer idx = this.mmap().duplicate();
            return new TimestampOffset(this.timestamp(idx, n), this.relativeOffset(idx, n));
        });
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new TimestampOffset(this.timestamp(buffer, n), super.baseOffset() + (long)this.relativeOffset(buffer, n));
    }

    public void maybeAppend(long timestamp, long offset, boolean skipFullCheck) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block3: {
                if (!skipFullCheck) {
                    Predef$.MODULE$.require(!this.isFull(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Attempt to append to a full time index (size = ").append(this._entries()).append(").").toString());
                }
                if (this._entries() != 0 && offset < this.lastEntry().offset()) {
                    throw new InvalidOffsetException(new StringBuilder(54).append("Attempt to append an offset (").append(offset).append(") to slot ").append(this._entries()).append(" no larger than").append(new StringBuilder(33).append(" the last offset appended (").append(this.lastEntry().offset()).append(") to ").append(this.file().getAbsolutePath()).append(".").toString()).toString());
                }
                if (this._entries() != 0 && timestamp < this.lastEntry().timestamp()) {
                    throw new IllegalStateException(new StringBuilder(51).append("Attempt to append a timestamp (").append(timestamp).append(") to slot ").append(this._entries()).append(" no larger").append(new StringBuilder(41).append(" than the last timestamp appended (").append(this.lastEntry().timestamp()).append(") to ").append(this.file().getAbsolutePath()).append(".").toString()).toString());
                }
                if (timestamp <= this.lastEntry().timestamp()) break block3;
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Adding index entry ").append(timestamp).append(" => ").append(offset).append(" to ").append(this.file().getAbsolutePath()).append(".").toString());
                this.mmap().putLong(timestamp);
                this.mmap().putInt(this.relativeOffset(offset));
                this._entries_$eq(this._entries() + 1);
                this._lastEntry_$eq(new TimestampOffset(timestamp, offset));
                Predef$.MODULE$.require(this._entries() * this.entrySize() == this.mmap().position(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append(this._entries()).append(" entries but file position in index is ").append(this.mmap().position()).append(".").toString());
            }
        });
    }

    public boolean maybeAppend$default$3() {
        return false;
    }

    public TimestampOffset lookup(long targetTimestamp) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            TimestampOffset timestampOffset;
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetTimestamp, IndexSearchType$.MODULE$.KEY());
            if (slot == -1) {
                timestampOffset = new TimestampOffset(-1L, this.super$baseOffset());
            } else {
                TimestampOffset entry = (TimestampOffset)this.parseEntry(idx, slot);
                timestampOffset = new TimestampOffset(entry.timestamp(), entry.offset());
            }
            return timestampOffset;
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, offset, IndexSearchType$.MODULE$.VALUE());
            int newEntries = slot < 0 ? 0 : ((long)this.relativeOffset(idx, slot) == offset - this.super$baseOffset() ? slot : slot + 1);
            this.truncateToEntries(newEntries);
        });
    }

    @Override
    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            if (this.super$resize(newSize)) {
                this._lastEntry_$eq(this.lastEntryFromIndexFile());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }));
    }

    private void truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this._entries_$eq(entries);
            this.mmap().position(this._entries() * this.entrySize());
            this._lastEntry_$eq(this.lastEntryFromIndexFile());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Truncated index ").append(this.file().getAbsolutePath()).append(" to ").append(entries).append(" entries; position is now ").append(this.mmap().position()).append(" and last entry is now ").append(this._lastEntry()).toString());
        });
    }

    @Override
    public void sanityCheck() {
        long lastTimestamp = this.lastEntry().timestamp();
        long lastOffset = this.lastEntry().offset();
        if (this._entries() != 0 && lastTimestamp < this.timestamp(this.mmap(), 0)) {
            throw new CorruptIndexException(new StringBuilder(49).append("Corrupt time index found, time index file (").append(this.file().getAbsolutePath()).append(") has ").append(new StringBuilder(80).append("non-zero size but the last timestamp is ").append(lastTimestamp).append(" which is less than the first timestamp ").toString()).append(String.valueOf(BoxesRunTime.boxToLong((long)this.timestamp(this.mmap(), 0)))).toString());
        }
        if (this._entries() != 0 && lastOffset < super.baseOffset()) {
            throw new CorruptIndexException(new StringBuilder(49).append("Corrupt time index found, time index file (").append(this.file().getAbsolutePath()).append(") has ").append(new StringBuilder(74).append("non-zero size but the last offset is ").append(lastOffset).append(" which is less than the first offset ").append(super.baseOffset()).toString()).toString());
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringBuilder(42).append("Time index file ").append(this.file().getAbsolutePath()).append(" is corrupt, found ").append(this.length()).append(" bytes ").append(new StringBuilder(45).append("which is neither positive nor a multiple of ").append(this.entrySize()).append(".").toString()).toString());
        }
    }

    public TimeIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Loaded index file ").append(this.file().getAbsolutePath()).append(" with maxEntries = ").append(this.maxEntries()).append(", maxIndexSize = ").append(this.super$maxIndexSize()).append(",").append(new StringBuilder(44).append(" entries = ").append(this._entries()).append(", lastOffset = ").append(this._lastEntry()).append(", file position = ").append(this.mmap().position()).toString()).toString());
    }
}

