/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import kafka.log.BatchMetadata;
import kafka.log.ProducerStateEntry$;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005etA\u0002\u0013&\u0011\u0003)\u0013F\u0002\u0004,K!\u0005Q\u0005\f\u0005\u0006g\u0005!\t!\u000e\u0005\tm\u0005\u0011\r\u0011\"\u0001&o!11(\u0001Q\u0001\naBQ\u0001P\u0001\u0005\u0002u2QaK\u0013\u0001K}B\u0001\u0002\u0011\u0004\u0003\u0006\u0004%\t!\u0011\u0005\t\u000b\u001a\u0011\t\u0011)A\u0005\u0005\"AaI\u0002BC\u0002\u0013\u0005q\t\u0003\u0005T\r\t\u0005\t\u0015!\u0003I\u0011!!fA!a\u0001\n\u0003)\u0006\u0002C-\u0007\u0005\u0003\u0007I\u0011\u0001.\t\u0011\u00014!\u0011!Q!\nYC\u0001\"\u0019\u0004\u0003\u0002\u0004%\ta\u000e\u0005\tE\u001a\u0011\t\u0019!C\u0001G\"AQM\u0002B\u0001B\u0003&\u0001\b\u0003\u0005g\r\t\u0005\r\u0011\"\u0001h\u0011!YgA!a\u0001\n\u0003a\u0007\u0002\u00038\u0007\u0005\u0003\u0005\u000b\u0015\u00025\t\u000bM2A\u0011A8\t\u000bU4A\u0011A\u001c\t\u000bY4A\u0011A!\t\u000b]4A\u0011A\u001c\t\u000ba4A\u0011A!\t\u000be4A\u0011A!\t\u000bi4A\u0011A\u001c\t\u000bm4A\u0011\u0001?\t\u000f\u0005\u0005a\u0001\"\u0001\u0002\u0004!9\u0011Q\u0003\u0004\u0005\u0002\u0005]\u0001bBA\u000e\r\u0011%\u0011Q\u0004\u0005\b\u0003G1A\u0011AA\u0013\u0011\u001d\tYC\u0002C\u0001\u0003[Aq!a\r\u0007\t\u0003\t)\u0004C\u0004\u0002V\u0019!\t!a\u0016\t\u000f\u0005uc\u0001\"\u0011\u0002`\u0005\u0011\u0002K]8ek\u000e,'o\u0015;bi\u0016,e\u000e\u001e:z\u0015\t1s%A\u0002m_\u001eT\u0011\u0001K\u0001\u0006W\u000647.\u0019\t\u0003U\u0005i\u0011!\n\u0002\u0013!J|G-^2feN#\u0018\r^3F]R\u0014\u0018p\u0005\u0002\u0002[A\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002S\u0005\u0011b*^7CCR\u001c\u0007.Z:U_J+G/Y5o+\u0005A\u0004C\u0001\u0018:\u0013\tQtFA\u0002J]R\f1CT;n\u0005\u0006$8\r[3t)>\u0014V\r^1j]\u0002\nQ!Z7qif$2APA<!\tQca\u0005\u0002\u0007[\u0005Q\u0001O]8ek\u000e,'/\u00133\u0016\u0003\t\u0003\"AL\"\n\u0005\u0011{#\u0001\u0002'p]\u001e\f1\u0002\u001d:pIV\u001cWM]%eA\u0005i!-\u0019;dQ6+G/\u00193bi\u0006,\u0012\u0001\u0013\t\u0004\u0013:\u0003V\"\u0001&\u000b\u0005-c\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u001b>\n!bY8mY\u0016\u001cG/[8o\u0013\ty%JA\u0003Rk\u0016,X\r\u0005\u0002+#&\u0011!+\n\u0002\u000e\u0005\u0006$8\r['fi\u0006$\u0017\r^1\u0002\u001d\t\fGo\u00195NKR\fG-\u0019;bA\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\u0012A\u0016\t\u0003]]K!\u0001W\u0018\u0003\u000bMCwN\u001d;\u0002#A\u0014x\u000eZ;dKJ,\u0005o\\2i?\u0012*\u0017\u000f\u0006\u0002\\=B\u0011a\u0006X\u0005\u0003;>\u0012A!\u00168ji\"9q\fDA\u0001\u0002\u00041\u0016a\u0001=%c\u0005q\u0001O]8ek\u000e,'/\u00129pG\"\u0004\u0013\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0003Q\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007n\u0018\u0013fcR\u00111\f\u001a\u0005\b?>\t\t\u00111\u00019\u0003E\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eI\u0001\u0016GV\u0014(/\u001a8u)btg)\u001b:ti>3gm]3u+\u0005A\u0007c\u0001\u0018j\u0005&\u0011!n\f\u0002\u0007\u001fB$\u0018n\u001c8\u00023\r,(O]3oiRChNR5sgR|eMZ:fi~#S-\u001d\u000b\u000376Dqa\u0018\n\u0002\u0002\u0003\u0007\u0001.\u0001\fdkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;!)\u0019q\u0004/\u001d:ti\")\u0001\t\u0006a\u0001\u0005\")a\t\u0006a\u0001\u0011\")A\u000b\u0006a\u0001-\")\u0011\r\u0006a\u0001q!)a\r\u0006a\u0001Q\u0006Aa-\u001b:tiN+\u0017/A\u0006gSJ\u001cHo\u00144gg\u0016$\u0018a\u00027bgR\u001cV-]\u0001\u000fY\u0006\u001cH\u000fR1uC>3gm]3u\u00035a\u0017m\u001d;US6,7\u000f^1na\u0006yA.Y:u\u001f\u001a47/\u001a;EK2$\u0018-A\u0004jg\u0016k\u0007\u000f^=\u0016\u0003u\u0004\"A\f@\n\u0005}|#a\u0002\"p_2,\u0017M\\\u0001\tC\u0012$')\u0019;dQRY1,!\u0002\u0002\b\u0005%\u0011QBA\t\u0011\u0015!F\u00041\u0001W\u0011\u00159H\u00041\u00019\u0011\u0019\tY\u0001\ba\u0001\u0005\u0006QA.Y:u\u001f\u001a47/\u001a;\t\r\u0005=A\u00041\u00019\u0003-ygMZ:fi\u0012+G\u000e^1\t\r\u0005MA\u00041\u0001C\u0003%!\u0018.\\3ti\u0006l\u0007/\u0001\tnCf\u0014W-\u00169eCR,W\t]8dQR\u0019Q0!\u0007\t\u000bQk\u0002\u0019\u0001,\u0002!\u0005$GMQ1uG\"lU\r^1eCR\fGcA.\u0002 !1\u0011\u0011\u0005\u0010A\u0002A\u000bQAY1uG\"\fa!\u001e9eCR,GcA.\u0002(!1\u0011\u0011F\u0010A\u0002y\n\u0011B\\3yi\u0016sGO]=\u0002-I,Wn\u001c<f\u0005\u0006$8\r[3t\u001f2$WM\u001d+iC:$2aWA\u0018\u0011\u0019\t\t\u0004\ta\u0001\u0005\u00061qN\u001a4tKR\f!CZ5oI\u0012+\b\u000f\\5dCR,')\u0019;dQR!\u0011qGA\u001d!\rq\u0013\u000e\u0015\u0005\b\u0003C\t\u0003\u0019AA\u001e!\u0011\ti$!\u0015\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\naA]3d_J$'\u0002BA#\u0003\u000f\naaY8n[>t'b\u0001\u0015\u0002J)!\u00111JA'\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qJ\u0001\u0004_J<\u0017\u0002BA*\u0003\u007f\u00111BU3d_J$')\u0019;dQ\u00061\"-\u0019;dQ^KG\u000f[*fcV,gnY3SC:<W\r\u0006\u0004\u00028\u0005e\u00131\f\u0005\u0006k\n\u0002\r\u0001\u000f\u0005\u0006o\n\u0002\r\u0001O\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\r\t\u0005\u0003G\n\tH\u0004\u0003\u0002f\u00055\u0004cAA4_5\u0011\u0011\u0011\u000e\u0006\u0004\u0003W\"\u0014A\u0002\u001fs_>$h(C\u0002\u0002p=\na\u0001\u0015:fI\u00164\u0017\u0002BA:\u0003k\u0012aa\u0015;sS:<'bAA8_!)\u0001)\u0002a\u0001\u0005\u0002")
public class ProducerStateEntry {
    private final long producerId;
    private final Queue<BatchMetadata> batchMetadata;
    private short producerEpoch;
    private int coordinatorEpoch;
    private Option<Object> currentTxnFirstOffset;

    public static ProducerStateEntry empty(long l) {
        return ProducerStateEntry$.MODULE$.empty(l);
    }

    public long producerId() {
        return this.producerId;
    }

    public Queue<BatchMetadata> batchMetadata() {
        return this.batchMetadata;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public void coordinatorEpoch_$eq(int x$1) {
        this.coordinatorEpoch = x$1;
    }

    public Option<Object> currentTxnFirstOffset() {
        return this.currentTxnFirstOffset;
    }

    public void currentTxnFirstOffset_$eq(Option<Object> x$1) {
        this.currentTxnFirstOffset = x$1;
    }

    public int firstSeq() {
        return this.isEmpty() ? -1 : ((BatchMetadata)this.batchMetadata().front()).firstSeq();
    }

    public long firstOffset() {
        return this.isEmpty() ? -1L : ((BatchMetadata)this.batchMetadata().front()).firstOffset();
    }

    public int lastSeq() {
        return this.isEmpty() ? -1 : ((BatchMetadata)this.batchMetadata().last()).lastSeq();
    }

    public long lastDataOffset() {
        return this.isEmpty() ? -1L : ((BatchMetadata)this.batchMetadata().last()).lastOffset();
    }

    public long lastTimestamp() {
        return this.isEmpty() ? -1L : ((BatchMetadata)this.batchMetadata().last()).timestamp();
    }

    public int lastOffsetDelta() {
        return this.isEmpty() ? 0 : ((BatchMetadata)this.batchMetadata().last()).offsetDelta();
    }

    public boolean isEmpty() {
        return this.batchMetadata().isEmpty();
    }

    public void addBatch(short producerEpoch, int lastSeq, long lastOffset, int offsetDelta, long timestamp) {
        this.maybeUpdateEpoch(producerEpoch);
        this.addBatchMetadata(new BatchMetadata(lastSeq, lastOffset, offsetDelta, timestamp));
    }

    public boolean maybeUpdateEpoch(short producerEpoch) {
        boolean bl;
        if (this.producerEpoch() != producerEpoch) {
            this.batchMetadata().clear();
            this.producerEpoch_$eq(producerEpoch);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void addBatchMetadata(BatchMetadata batch) {
        Object object = this.batchMetadata().size() == ProducerStateEntry$.MODULE$.NumBatchesToRetain() ? this.batchMetadata().dequeue() : BoxedUnit.UNIT;
        this.batchMetadata().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{batch}));
    }

    public void update(ProducerStateEntry nextEntry) {
        this.maybeUpdateEpoch(nextEntry.producerEpoch());
        while (nextEntry.batchMetadata().nonEmpty()) {
            this.addBatchMetadata((BatchMetadata)nextEntry.batchMetadata().dequeue());
        }
        this.coordinatorEpoch_$eq(nextEntry.coordinatorEpoch());
        this.currentTxnFirstOffset_$eq(nextEntry.currentTxnFirstOffset());
    }

    public void removeBatchesOlderThan(long offset) {
        this.batchMetadata().dropWhile((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateEntry.$anonfun$removeBatchesOlderThan$1(offset, x$1)));
    }

    public Option<BatchMetadata> findDuplicateBatch(RecordBatch batch) {
        return batch.producerEpoch() != this.producerEpoch() ? None$.MODULE$ : this.batchWithSequenceRange(batch.baseSequence(), batch.lastSequence());
    }

    public Option<BatchMetadata> batchWithSequenceRange(int firstSeq, int lastSeq) {
        Queue duplicate = (Queue)this.batchMetadata().filter((Function1 & java.io.Serializable & Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)ProducerStateEntry.$anonfun$batchWithSequenceRange$1(firstSeq, lastSeq, metadata)));
        return duplicate.headOption();
    }

    public String toString() {
        return new StringBuilder(19).append("ProducerStateEntry(").append(new StringBuilder(13).append("producerId=").append(this.producerId()).append(", ").toString()).append(new StringBuilder(16).append("producerEpoch=").append(this.producerEpoch()).append(", ").toString()).append(new StringBuilder(24).append("currentTxnFirstOffset=").append(this.currentTxnFirstOffset()).append(", ").toString()).append(new StringBuilder(19).append("coordinatorEpoch=").append(this.coordinatorEpoch()).append(", ").toString()).append(new StringBuilder(14).append("batchMetadata=").append(this.batchMetadata()).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$removeBatchesOlderThan$1(long offset$1, BatchMetadata x$1) {
        return x$1.lastOffset() < offset$1;
    }

    public static final /* synthetic */ boolean $anonfun$batchWithSequenceRange$1(int firstSeq$1, int lastSeq$1, BatchMetadata metadata) {
        return firstSeq$1 == metadata.firstSeq() && lastSeq$1 == metadata.lastSeq();
    }

    public ProducerStateEntry(long producerId, Queue<BatchMetadata> batchMetadata, short producerEpoch, int coordinatorEpoch, Option<Object> currentTxnFirstOffset) {
        this.producerId = producerId;
        this.batchMetadata = batchMetadata;
        this.producerEpoch = producerEpoch;
        this.coordinatorEpoch = coordinatorEpoch;
        this.currentTxnFirstOffset = currentTxnFirstOffset;
    }
}

