/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0015h!\u0002\u001c8\u0001]Z\u0004\u0002\u0003(\u0001\u0005\u000b\u0007I\u0011\u0001)\t\u0011\u0015\u0004!\u0011!Q\u0001\nEC\u0001B\u001a\u0001\u0003\u0006\u0004%\ta\u001a\u0005\tu\u0002\u0011\t\u0011)A\u0005Q\"A1\u0010\u0001BC\u0002\u0013\u0005A\u0010C\u0005\u0002\b\u0001\u0011\t\u0011)A\u0005{\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA\u000b\u0001\u0011E\u0013q\u0003\u0005\u000b\u0003K\u0001!\u0019!C\u0001o\u0005]\u0001\u0002CA\u0014\u0001\u0001\u0006I!!\u0007\t\u0013\u0005%\u0002\u00011A\u0005\n\u0005-\u0002\"CA$\u0001\u0001\u0007I\u0011BA%\u0011!\t)\u0006\u0001Q!\n\u00055\u0002\"CA0\u0001\t\u0007I\u0011BA1\u0011!\t)\b\u0001Q\u0001\n\u0005\r\u0004\"CA<\u0001\t\u0007I\u0011BA=\u0011!\t\t\n\u0001Q\u0001\n\u0005m\u0004\"CAJ\u0001\t\u0007I\u0011BAK\u0011!\tY\u000b\u0001Q\u0001\n\u0005]\u0005\"CAW\u0001\t\u0007I\u0011BAX\u0011!\t9\f\u0001Q\u0001\n\u0005E\u0006\"CA]\u0001\u0001\u0007I\u0011BA^\u0011%\t\u0019\r\u0001a\u0001\n\u0013\t)\r\u0003\u0005\u0002J\u0002\u0001\u000b\u0015BA_\u0011%\ti\r\u0001a\u0001\n\u0013\ty\rC\u0005\u0002X\u0002\u0001\r\u0011\"\u0003\u0002Z\"A\u0011Q\u001c\u0001!B\u0013\t\t\u000eC\u0004\u0002b\u0002!\t!a9\t\u0011\u0005%\b\u0001\"\u00018\u0003WD\u0001\"a>\u0001\t\u00039\u0014\u0011 \u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0002\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0005;AqA!\f\u0001\t\u0003\u0011i\u0002C\u0004\u00030\u0001!\tA!\r\t\u000f\t]\u0002\u0001\"\u0001\u0003:!9!Q\b\u0001\u0005\u0002\t}\u0002b\u0002B$\u0001\u0011%!\u0011\n\u0005\b\u0005/\u0002A\u0011\u0002B-\u0011\u001d\u0011i\u0006\u0001C\u0001\u0005?BqAa\u0019\u0001\t\u0003\u0011)\u0007C\u0004\u0003t\u0001!\tA!\u001e\t\u000f\t\u0005\u0005\u0001\"\u0001\u0003\u0004\"9!\u0011\u0012\u0001\u0005\u0002\t-\u0005b\u0002BK\u0001\u0011\u0005!q\u0013\u0005\b\u0005C\u0003A\u0011\u0001BR\u0011!\t9\b\u0001C\u0001o\t\u001d\u0006b\u0002BY\u0001\u0011\u0005!1\u0017\u0005\b\u0005w\u0003A\u0011\u0002B_\u000f!\u0011\u0019m\u000eE\u0001o\t\u0015ga\u0002\u001c8\u0011\u00039$q\u0019\u0005\b\u0003\u0013\u0011D\u0011\u0001Be\u0011\u001d\u0011YM\rC\u0001\u0005\u001bDqA!53\t\u0003\u0011\u0019NA\tM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJT!\u0001O\u001d\u0002\u00071|wMC\u0001;\u0003\u0015Y\u0017MZ6b'\u0011\u0001AH\u0011%\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\r\u0005s\u0017PU3g!\t\u0019e)D\u0001E\u0015\t)\u0015(A\u0003vi&d7/\u0003\u0002H\t\n9Aj\\4hS:<\u0007CA%M\u001b\u0005Q%BA&:\u0003\u001diW\r\u001e:jGNL!!\u0014&\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0004m_\u001e$\u0015N]:\u0004\u0001U\t\u0011\u000bE\u0002S5vs!a\u0015-\u000f\u0005Q;V\"A+\u000b\u0005Y{\u0015A\u0002\u001fs_>$h(C\u0001@\u0013\tIf(A\u0004qC\u000e\\\u0017mZ3\n\u0005mc&aA*fc*\u0011\u0011L\u0010\t\u0003=\u000el\u0011a\u0018\u0006\u0003A\u0006\f!![8\u000b\u0003\t\fAA[1wC&\u0011Am\u0018\u0002\u0005\r&dW-\u0001\u0005m_\u001e$\u0015N]:!\u0003\u0011awnZ:\u0016\u0003!\u0004BaQ5lm&\u0011!\u000e\u0012\u0002\u0005!>|G\u000e\u0005\u0002mi6\tQN\u0003\u0002o_\u000611m\\7n_:T!A\u000f9\u000b\u0005E\u0014\u0018AB1qC\u000eDWMC\u0001t\u0003\ry'oZ\u0005\u0003k6\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002xq6\tq'\u0003\u0002zo\t\u0019Aj\\4\u0002\u000b1|wm\u001d\u0011\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\u0005i\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002e\naa]3sm\u0016\u0014\u0018bAA\u0003\u007f\n!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\fQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007%\u0001\u0004=S:LGO\u0010\u000b\t\u0003\u001b\ty!!\u0005\u0002\u0014A\u0011q\u000f\u0001\u0005\u0006\u001d\u001e\u0001\r!\u0015\u0005\u0006M\u001e\u0001\r\u0001\u001b\u0005\u0006w\u001e\u0001\r!`\u0001\u000bY><w-\u001a:OC6,WCAA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010C\u0006!A.\u00198h\u0013\u0011\t\u0019#!\b\u0003\rM#(/\u001b8h\u0003QygMZ:fi\u000eCWmY6q_&tGOR5mK\u0006)rN\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016\u0004\u0013aC2iK\u000e\\\u0007o\\5oiN,\"!!\f\u0011\u000f\u0005=\u0012\u0011H/\u0002>5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$A\u0005j[6,H/\u00192mK*\u0019\u0011q\u0007 \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002<\u0005E\"aA'baB!\u0011qHA\"\u001b\t\t\tEC\u0002\u0002*}LA!!\u0012\u0002B\t!rJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016\fqb\u00195fG.\u0004x.\u001b8ug~#S-\u001d\u000b\u0005\u0003\u0017\n\t\u0006E\u0002>\u0003\u001bJ1!a\u0014?\u0005\u0011)f.\u001b;\t\u0013\u0005MC\"!AA\u0002\u00055\u0012a\u0001=%c\u0005a1\r[3dWB|\u0017N\u001c;tA!\u001aQ\"!\u0017\u0011\u0007u\nY&C\u0002\u0002^y\u0012\u0001B^8mCRLG.Z\u0001\u000bS:\u0004&o\\4sKN\u001cXCAA2!\u001d\t)'a\u001bl\u0003_j!!a\u001a\u000b\t\u0005%\u0014QG\u0001\b[V$\u0018M\u00197f\u0013\u0011\ti'a\u001a\u0003\u000f!\u000b7\u000f['baB\u0019q/!\u001d\n\u0007\u0005MtG\u0001\tM_\u001e\u001cE.Z1oS:<7\u000b^1uK\u0006Y\u0011N\u001c)s_\u001e\u0014Xm]:!\u0003U)hn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]N,\"!a\u001f\u0011\u0011\u0005\u0015\u00141NA?\u0003\u0017\u0003B!a \u0002\b:!\u0011\u0011QAB!\t!f(C\u0002\u0002\u0006z\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0012\u0003\u0013S1!!\"?!\u0015\t)'!$l\u0013\u0011\ty)a\u001a\u0003\u0007M+G/\u0001\fv]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:!\u0003\u0011awnY6\u0016\u0005\u0005]\u0005\u0003BAM\u0003Ok!!a'\u000b\t\u0005u\u0015qT\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003C\u000b\u0019+\u0001\u0006d_:\u001cWO\u001d:f]RT1!!*b\u0003\u0011)H/\u001b7\n\t\u0005%\u00161\u0014\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\u0002\u000b1|7m\u001b\u0011\u0002%A\fWo]3e\u00072,\u0017M\\5oO\u000e{g\u000eZ\u000b\u0003\u0003c\u0003B!!'\u00024&!\u0011QWAN\u0005%\u0019uN\u001c3ji&|g.A\nqCV\u001cX\rZ\"mK\u0006t\u0017N\\4D_:$\u0007%A\reSJ$\u0018.Z:u\u0019><7\t\\3b]\u0006\u0014G.\u001a*bi&|WCAA_!\ri\u0014qX\u0005\u0004\u0003\u0003t$A\u0002#pk\ndW-A\u000feSJ$\u0018.Z:u\u0019><7\t\\3b]\u0006\u0014G.\u001a*bi&|w\fJ3r)\u0011\tY%a2\t\u0013\u0005Ms#!AA\u0002\u0005u\u0016A\u00073jeRLWm\u001d;M_\u001e\u001cE.Z1oC\ndWMU1uS>\u0004\u0003f\u0001\r\u0002Z\u0005iA/[7f\u001f\u001ad\u0015m\u001d;Sk:,\"!!5\u0011\u0007u\n\u0019.C\u0002\u0002Vz\u0012A\u0001T8oO\u0006\tB/[7f\u001f\u001ad\u0015m\u001d;Sk:|F%Z9\u0015\t\u0005-\u00131\u001c\u0005\n\u0003'R\u0012\u0011!a\u0001\u0003#\fa\u0002^5nK>3G*Y:u%Vt\u0007\u0005K\u0002\u001c\u00033\nQ#\u00197m\u00072,\u0017M\\3s\u0007\",7m\u001b9pS:$8/\u0006\u0002\u0002fB9\u0011qPAtW\u0006E\u0017\u0002BA\u001e\u0003\u0013\u000bQb\u00197fC:LgnZ*uCR,G\u0003BAw\u0003g\u0004R!PAx\u0003_J1!!=?\u0005\u0019y\u0005\u000f^5p]\"1\u0011Q_\u000fA\u0002-\f!\u0001\u001e9\u0002!M,Go\u00117fC:LgnZ*uCR,GCBA&\u0003w\fi\u0010\u0003\u0004\u0002vz\u0001\ra\u001b\u0005\b\u0003\u007ft\u0002\u0019AA8\u0003\u0015\u0019H/\u0019;f\u0003e9'/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4\u0015\t\t\u0015!Q\u0002\t\u0006{\u0005=(q\u0001\t\u0004o\n%\u0011b\u0001B\u0006o\tQAj\\4U_\u000ecW-\u00198\t\u000f\t=q\u00041\u0001\u0003\u0012\u0005!A/[7f!\u0011\u0011\u0019Ba\u0006\u000e\u0005\tU!BA#n\u0013\u0011\u0011IB!\u0006\u0003\tQKW.Z\u0001'a\u0006,8/Z\"mK\u0006t\u0017N\\4G_JtuN\\\"p[B\f7\r^3e!\u0006\u0014H/\u001b;j_:\u001cHC\u0001B\u0010!\u0019\u0011\tCa\t\u0003(5\u0011\u0011QG\u0005\u0005\u0005K\t)D\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0015i$\u0011F6w\u0013\r\u0011YC\u0010\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u001b\u0011,G.\u001a;bE2,Gj\\4t\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR!\u00111\nB\u001a\u0011\u0019\u0011)D\ta\u0001W\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0017!F1c_J$\u0018I\u001c3QCV\u001cXm\u00117fC:Lgn\u001a\u000b\u0005\u0003\u0017\u0012Y\u0004\u0003\u0004\u00036\r\u0002\ra[\u0001\u000fe\u0016\u001cX/\\3DY\u0016\fg.\u001b8h)\u0011\tYE!\u0011\t\u000f\t\rC\u00051\u0001\u0003F\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000fE\u0003\u0003\"\t\r2.A\tjg\u000ecW-\u00198j]\u001eLen\u0015;bi\u0016$bAa\u0013\u0003R\tM\u0003cA\u001f\u0003N%\u0019!q\n \u0003\u000f\t{w\u000e\\3b]\"1!QG\u0013A\u0002-DqA!\u0016&\u0001\u0004\ty'A\u0007fqB,7\r^3e'R\fG/Z\u0001\u0018SN\u001cE.Z1oS:<\u0017J\\*uCR,\u0007+Y;tK\u0012$BAa\u0013\u0003\\!1!Q\u0007\u0014A\u0002-\fAc\u00195fG.\u001cE.Z1oS:<\u0017IY8si\u0016$G\u0003BA&\u0005CBaA!\u000e(\u0001\u0004Y\u0017!E;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ugR1\u00111\nB4\u0005WBaA!\u001b)\u0001\u0004i\u0016a\u00023bi\u0006$\u0015N\u001d\u0005\b\u0005[B\u0003\u0019\u0001B8\u0003\u0019)\b\u000fZ1uKB)Q(a<\u0003rA1QH!\u000bl\u0003#\f!#\u00197uKJ\u001c\u0005.Z2la>Lg\u000e\u001e#jeRA\u00111\nB<\u0005s\u0012i\b\u0003\u0004\u00036%\u0002\ra\u001b\u0005\u0007\u0005wJ\u0003\u0019A/\u0002\u0019M|WO]2f\u0019><G)\u001b:\t\r\t}\u0014\u00061\u0001^\u0003)!Wm\u001d;M_\u001e$\u0015N]\u0001\u0014Q\u0006tG\r\\3M_\u001e$\u0015N\u001d$bS2,(/\u001a\u000b\u0005\u0003\u0017\u0012)\tC\u0004\u0003\b*\u0002\r!! \u0002\u0007\u0011L'/A\fnCf\u0014W\r\u0016:v]\u000e\fG/Z\"iK\u000e\\\u0007o\\5oiRA\u00111\nBG\u0005\u001f\u0013\t\n\u0003\u0004\u0003j-\u0002\r!\u0018\u0005\u0007\u0005kY\u0003\u0019A6\t\u000f\tM5\u00061\u0001\u0002R\u00061qN\u001a4tKR\fA\u0002Z8oK\u000ecW-\u00198j]\u001e$\u0002\"a\u0013\u0003\u001a\nm%Q\u0014\u0005\u0007\u0005ka\u0003\u0019A6\t\r\t%D\u00061\u0001^\u0011\u001d\u0011y\n\fa\u0001\u0003#\f\u0011\"\u001a8e\u001f\u001a47/\u001a;\u0002\u0019\u0011|g.\u001a#fY\u0016$\u0018N\\4\u0015\t\u0005-#Q\u0015\u0005\b\u0005\u0007j\u0003\u0019\u0001B#)\u0011\u0011IK!,\u0011\u000b\u0005}$1V6\n\t\u0005=\u0015\u0011\u0012\u0005\b\u0005_s\u0003\u0019AA?\u0003\u0019awn\u001a#je\u0006AR.\u0019:l!\u0006\u0014H/\u001b;j_:,fn\u00197fC:\f'\r\\3\u0015\r\u0005-#Q\u0017B\\\u0011\u001d\u0011yk\fa\u0001\u0003{BaA!/0\u0001\u0004Y\u0017!\u00039beRLG/[8o\u0003YI7/\u00168dY\u0016\fg.\u00192mKB\u000b'\u000f^5uS>tGC\u0002B&\u0005\u007f\u0013\t\rC\u00039a\u0001\u0007a\u000f\u0003\u0004\u00036A\u0002\ra[\u0001\u0012\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\bCA<3'\r\u0011DH\u0011\u000b\u0003\u0005\u000b\f!#[:D_6\u0004\u0018m\u0019;B]\u0012$U\r\\3uKR!!1\nBh\u0011\u0015AD\u00071\u0001w\u0003A\u0019G.Z1oC\ndWm\u00144gg\u0016$8\u000f\u0006\u0006\u0003V\n]'\u0011\u001cBn\u0005C\u0004r!\u0010B\u0015\u0003#\f\t\u000eC\u00039k\u0001\u0007a\u000f\u0003\u0004\u00036U\u0002\ra\u001b\u0005\b\u0005;,\u0004\u0019\u0001Bp\u0003%a\u0017m\u001d;DY\u0016\fg\u000eE\u0004\u00020\u0005e2.!5\t\u000f\t\rX\u00071\u0001\u0002R\u0006\u0019an\\<")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> inProgress;
    private final HashMap<String, Set<TopicPartition>> kafka$log$LogCleanerManager$$uncleanablePartitions;
    private final ReentrantLock kafka$log$LogCleanerManager$$lock;
    private final Condition pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private volatile long kafka$log$LogCleanerManager$$timeOfLastRun;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> cleanableOffsets(Log log, TopicPartition topicPartition, scala.collection.immutable.Map<TopicPartition, Object> map, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, map, l);
    }

    public static boolean isCompactAndDelete(Log log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    public HashMap<String, Set<TopicPartition>> kafka$log$LogCleanerManager$$uncleanablePartitions() {
        return this.kafka$log$LogCleanerManager$$uncleanablePartitions;
    }

    public ReentrantLock kafka$log$LogCleanerManager$$lock() {
        return this.kafka$log$LogCleanerManager$$lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    private void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public long kafka$log$LogCleanerManager$$timeOfLastRun() {
        return this.kafka$log$LogCleanerManager$$timeOfLastRun;
    }

    private void kafka$log$LogCleanerManager$$timeOfLastRun_$eq(long x$1) {
        this.kafka$log$LogCleanerManager$$timeOfLastRun = x$1;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        return (scala.collection.immutable.Map)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)this.checkpoints().values().flatMap((Function1 & Serializable & scala.Serializable)checkpoint -> {
            scala.collection.immutable.Map map;
            try {
                map = checkpoint.read();
            }
            catch (KafkaStorageException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                map = Predef$.MODULE$.Map().empty();
            }
            return map;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        return (Option)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> this.inProgress().get((Object)tp));
    }

    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> this.inProgress().put((Object)tp, (Object)state));
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time) {
        return (Option)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            None$ none$;
            long now = time.milliseconds();
            this.kafka$log$LogCleanerManager$$timeOfLastRun_$eq(now);
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.allCleanerCheckpoints();
            Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3(this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2.mcJJ.sp sp2;
                Log log;
                TopicPartition topicPartition;
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    topicPartition = (TopicPartition)tuple2._1();
                    log = (Log)tuple2._2();
                    Tuple2<Object, Object> tuple22 = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, lastClean, now);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    long firstDirtyOffset = tuple22._1$mcJ$sp();
                    long firstUncleanableDirtyOffset = tuple22._2$mcJ$sp();
                    sp2 = new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2.mcJJ.sp sp3 = sp2;
                long firstDirtyOffset = sp3._1$mcJ$sp();
                long firstUncleanableDirtyOffset = sp3._2$mcJ$sp();
                LogToClean logToClean = new LogToClean(topicPartition, log, firstDirtyOffset, firstUncleanableDirtyOffset);
                return logToClean;
            }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$5(ltc)));
            this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
            Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
            if (cleanableLogs.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
                none$ = new Some((Object)filthiest);
            }
            return none$;
        });
    }

    public Iterable<Tuple2<TopicPartition, Log>> pauseCleaningForNonCompactedPartitions() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            Iterable deletableLogs = (Iterable)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$3(this, x0$2)));
            deletableLogs.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                Option option = this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
                return option;
            });
            return var1_1;
        });
    }

    public Iterable<Tuple2<TopicPartition, Log>> deletableLogs() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            Iterable toClean = (Iterable)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2(this, x0$1)));
            toClean.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Option option = this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
                return option;
            });
            return var1_1;
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.abortAndPauseCleaning(topicPartition);
            this.resumeCleaning((Iterable<TopicPartition>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("The cleaning for partition ").append(topicPartition).append(" is aborted").toString());
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), () -> LogCleanerManager.$anonfun$abortAndPauseCleaning$1(this, topicPartition));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("The cleaning for partition ").append(topicPartition).append(" is aborted and paused").toString());
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topicPartitions.foreach(arg_0 -> LogCleanerManager.$anonfun$resumeCleaning$2(this, arg_0)));
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            LogCleaningState state;
            Some some = (Some)option;
            LogCleaningState logCleaningState = state = (LogCleaningState)some.value();
            LogCleaningState logCleaningState2 = expectedState;
            bl = !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private boolean isCleaningInStatePaused(TopicPartition topicPartition) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            LogCleaningState state = (LogCleaningState)some.value();
            LogCleaningState logCleaningState = state;
            boolean bl2 = logCleaningState instanceof LogCleaningPaused;
            bl = bl2;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.isCleaningInState(topicPartition, LogCleaningAborted$.MODULE$)) {
                throw new LogCleaningAbortedException();
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> update) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block2: {
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir);
                if (checkpoint == null) break block2;
                try {
                    Map existing = checkpoint.read().filterKeys(this.logs().keys()).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(update));
                    checkpoint.write((Map<TopicPartition, Object>)existing);
                }
                catch (KafkaStorageException e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
        });
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block5: {
                block4: {
                    try {
                        Option option = this.checkpoints().get((Object)sourceLogDir).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.read().get((Object)topicPartition));
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            long offset = BoxesRunTime.unboxToLong((Object)some.value());
                            this.updateCheckpoints(sourceLogDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
                            this.updateCheckpoints(destLogDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)offset))));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        if (None$.MODULE$.equals(option)) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        throw new MatchError((Object)option);
                    }
                    catch (KafkaStorageException e) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to access checkpoint file in dir ").append(sourceLogDir.getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    }
                }
                Set logUncleanablePartitions = (Set)this.kafka$log$LogCleanerManager$$uncleanablePartitions().getOrElse((Object)sourceLogDir.toString(), (Function0 & Serializable & scala.Serializable)() -> (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                if (!logUncleanablePartitions.contains((Object)topicPartition)) break block5;
                logUncleanablePartitions.remove((Object)topicPartition);
                this.markPartitionUncleanable(destLogDir.toString(), topicPartition);
            }
        });
    }

    public void handleLogDirFailure(String dir) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Stopping cleaning logs in dir ").append(dir).toString());
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)this.checkpoints().filterKeys((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$handleLogDirFailure$3(dir, x$5)))));
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                Map<TopicPartition, Object> existing;
                OffsetCheckpointFile checkpoint;
                if (!this.logs().get(topicPartition).config().compact() || (checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir)) == null || BoxesRunTime.unboxToLong((Object)(existing = checkpoint.read()).getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) <= offset) break block0;
                checkpoint.write((Map<TopicPartition, Object>)existing.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)offset))));
            }
        });
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            LogCleaningState logCleaningState;
            boolean bl = false;
            Some some = null;
            Option option = this.inProgress().get((Object)topicPartition);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                    this.updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)endOffset))));
                    return this.inProgress().remove((Object)topicPartition);
                }
            }
            if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
                this.pausedCleaningCond().signalAll();
                return BoxedUnit.UNIT;
            }
            if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
            throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
        });
    }

    public void doneDeleting(Iterable<TopicPartition> topicPartitions) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            LogCleaningState logCleaningState;
            boolean bl = false;
            Some some = null;
            Option option = this.inProgress().get(topicPartition);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                    return this.inProgress().remove(topicPartition);
                }
            }
            if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(1));
                this.pausedCleaningCond().signalAll();
                return BoxedUnit.UNIT;
            }
            if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
            throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
        }));
    }

    public scala.collection.immutable.Set<TopicPartition> uncleanablePartitions(String logDir) {
        ObjectRef partitions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            partitions$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions$1.elem).$plus$plus((GenTraversableOnce)this.kafka$log$LogCleanerManager$$uncleanablePartitions().getOrElse((Object)logDir, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
        });
        return (scala.collection.immutable.Set)partitions.elem;
    }

    public void markPartitionUncleanable(String logDir, TopicPartition partition) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Boolean bl;
            Option option = this.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)logDir);
            if (option instanceof Some) {
                Some some = (Some)option;
                Set partitions = (Set)some.value();
                bl = BoxesRunTime.boxToBoolean((boolean)partitions.add((Object)partition));
            } else if (None$.MODULE$.equals(option)) {
                bl = this.kafka$log$LogCleanerManager$$uncleanablePartitions().put((Object)logDir, (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
            } else {
                throw new MatchError((Object)option);
            }
            return bl;
        });
    }

    private boolean isUncleanablePartition(Log log, TopicPartition topicPartition) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)log.dir().getParent()).exists((Function1 & Serializable & scala.Serializable)partitions -> BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)topicPartition)))));
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log = (Log)tuple2._2();
        boolean bl = log.config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        Log log = (Log)tuple2._2();
        boolean bl = $this.inProgress().contains((Object)topicPartition) || $this.isUncleanablePartition(log, topicPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$5(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log = (Log)tuple2._2();
        boolean bl = !log.config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$3(LogCleanerManager $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.inProgress().contains((Object)topicPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        Log log = (Log)tuple2._2();
        boolean bl = !$this.inProgress().contains((Object)topicPartition) && log.config().compact() && !$this.isUncleanablePartition(log, topicPartition);
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$abortAndPauseCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$2) {
        block7: {
            block6: {
                var3_2 = false;
                var4_3 = null;
                var5_4 = $this.inProgress().get((Object)topicPartition$2);
                if (!None$.MODULE$.equals(var5_4)) break block6;
                var2_5 = $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(1));
                break block7;
            }
            if (!(var5_4 instanceof Some)) ** GOTO lbl-1000
            var3_2 = true;
            var4_3 = (Some)var5_4;
            var6_6 = (LogCleaningState)var4_3.value();
            if (LogCleaningInProgress$.MODULE$.equals(var6_6)) {
                var2_5 = $this.inProgress().put((Object)topicPartition$2, (Object)LogCleaningAborted$.MODULE$);
            } else if (var3_2 && (var7_7 = (LogCleaningState)var4_3.value()) instanceof LogCleaningPaused) {
                var8_8 = (LogCleaningPaused)var7_7;
                count = var8_8.pausedCount();
                var2_5 = $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(count + 1));
            } else {
                if (var3_2) {
                    s = (LogCleaningState)var4_3.value();
                    throw new IllegalStateException(new StringBuilder(77).append("Compaction for partition ").append(topicPartition$2).append(" cannot be aborted and paused since it is in ").append(s).append(" state.").toString());
                }
                throw new MatchError((Object)var5_4);
            }
        }
        while (!$this.isCleaningInStatePaused(topicPartition$2)) {
            $this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Option $anonfun$resumeCleaning$2(LogCleanerManager $this, TopicPartition topicPartition) {
        var4_2 = $this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(var4_2)) {
            throw new IllegalStateException(new StringBuilder(67).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is not paused.").toString());
        }
        if (!(var4_2 instanceof Some)) ** GOTO lbl21
        var5_3 = (Some)var4_2;
        state = (LogCleaningState)var5_3.value();
        var7_5 = false;
        var8_6 = null;
        var9_7 = state;
        if (!(var9_7 instanceof LogCleaningPaused)) ** GOTO lbl-1000
        var7_5 = true;
        var8_6 = (LogCleaningPaused)var9_7;
        count = var8_6.pausedCount();
        if (count == 1) {
            var3_9 = $this.inProgress().remove((Object)topicPartition);
        } else if (var7_5 && (count = var8_6.pausedCount()) > 1) {
            var3_9 = $this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(count - 1));
        } else {
            throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(var9_7).append(" state.").toString());
lbl21:
            // 1 sources

            throw new MatchError((Object)var4_2);
        }
        var2_11 = var3_9;
        return var2_11;
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$3, File x$5) {
        String string = x$5.getAbsolutePath();
        String string2 = dir$3;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((TraversableOnce)logDirs.map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$log$LogCleanerManager$$uncleanablePartitions = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$log$LogCleanerManager$$lock = new ReentrantLock();
        this.pausedCleaningCond = this.kafka$log$LogCleanerManager$$lock().newCondition();
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> this.newGauge("uncleanable-partitions-count", new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$1;

            public int value() {
                return BoxesRunTime.unboxToInt(CoreUtils$.MODULE$.inLock(this.$outer.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.$outer.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)$this.dir$1.getAbsolutePath()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)$anon$1.$anonfun$value$2(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))));
            }

            public static final /* synthetic */ int $anonfun$value$2(Set x$1) {
                return x$1.size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.log.LogCleanerManager$$anon$1 ), $anonfun$value$2$adapted(scala.collection.mutable.Set ), $anonfun$value$3()}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())})))));
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> this.newGauge("uncleanable-bytes", new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$2;

            public long value() {
                return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inLock(this.$outer.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
                    long l;
                    Option option = $this.$outer.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)$this.dir$2.getAbsolutePath());
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Set partitions = (Set)some.value();
                        scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.$outer.allCleanerCheckpoints();
                        long now = Time.SYSTEM.milliseconds();
                        l = BoxesRunTime.unboxToLong((Object)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$5(this, lastClean, now, tp)), Set$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    } else {
                        l = 0L;
                    }
                    return l;
                }));
            }

            public static final /* synthetic */ long $anonfun$value$5($anon$2 $this, scala.collection.immutable.Map lastClean$1, long now$1, TopicPartition tp) {
                long uncleanableBytes;
                Log log = $this.$outer.logs().get(tp);
                Tuple2<Object, Object> tuple2 = LogCleanerManager$.MODULE$.cleanableOffsets(log, tp, (scala.collection.immutable.Map<TopicPartition, Object>)lastClean$1, now$1);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                long firstDirtyOffset = tuple2._1$mcJ$sp();
                long firstUncleanableDirtyOffset = tuple2._2$mcJ$sp();
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                Tuple2.mcJJ.sp sp3 = sp2;
                long firstDirtyOffset2 = sp3._1$mcJ$sp();
                long firstUncleanableDirtyOffset2 = sp3._2$mcJ$sp();
                Tuple2<Object, Object> tuple22 = LogCleaner$.MODULE$.calculateCleanableBytes(log, firstDirtyOffset2, firstUncleanableDirtyOffset2);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                long l = uncleanableBytes = tuple22._2$mcJ$sp();
                long uncleanableBytes2 = l;
                return uncleanableBytes2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$2 = dir$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$4(kafka.log.LogCleanerManager$$anon$2 ), $anonfun$value$5$adapted(kafka.log.LogCleanerManager$$anon$2 scala.collection.immutable.Map long org.apache.kafka.common.TopicPartition )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())})))));
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.kafka$log$LogCleanerManager$$timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public long value() {
                return Time.SYSTEM.milliseconds() - this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

