/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001\u0002\u000f\u001e\u0001\tB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ns\u0001\u0011\t\u0011)A\u0005OiB\u0011b\u000f\u0001\u0003\u0002\u0003\u0006I!\f\u001f\t\u0013u\u0002!\u0011!Q\u0001\ny\n\u0005\"\u0002\"\u0001\t\u0003\u0019\u0005\"B%\u0001\t\u0003R\u0005BB&\u0001A\u0003&q\u0005C\u0003M\u0001\u0011%Q\nC\u0003R\u0001\u0011\u0005!\u000bC\u0003T\u0001\u0011\u0005A\u000bC\u0003X\u0001\u0011\u0005\u0001\fC\u0003a\u0001\u0011%\u0011\rC\u0003m\u0001\u0011%Q\u000eC\u0003q\u0001\u0011\u0005\u0013\u000fC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0003{\u0001\u0011\u00051\u0010C\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e!9\u0011\u0011\u0003\u0001\u0005\n\u0005M\u0001bBA\r\u0001\u0011\u0005\u0013\u0011\u0002\u0005\r\u00037\u0001\u0001\u0013aA\u0001\u0002\u0013%!\n\u0010\u0005\r\u0003;\u0001\u0001\u0013aA\u0001\u0002\u0013%!KO\u0004\n\u0003?i\u0012\u0011!E\u0001\u0003C1\u0001\u0002H\u000f\u0002\u0002#\u0005\u00111\u0005\u0005\u0007\u0005b!\t!a\u000b\t\u0013\u00055\u0002$%A\u0005\u0002\u0005=\u0002\"CA#1E\u0005I\u0011AA$\u0005-yeMZ:fi&sG-\u001a=\u000b\u0005yy\u0012a\u00017pO*\t\u0001%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0003\u0003\u0002\u0013&O5j\u0011!H\u0005\u0003Mu\u0011Q\"\u00112tiJ\f7\r^%oI\u0016D\bC\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#\u0001\u0002'p]\u001e\u0004\"\u0001\u000b\u0018\n\u0005=J#aA%oi\u0006)qLZ5mKB\u0011!gN\u0007\u0002g)\u0011A'N\u0001\u0003S>T\u0011AN\u0001\u0005U\u00064\u0018-\u0003\u00029g\t!a)\u001b7f\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u0005\u0003s\u0015\nA\"\\1y\u0013:$W\r_*ju\u0016L!aO\u0013\u0002\u0011]\u0014\u0018\u000e^1cY\u0016\u0004\"\u0001K \n\u0005\u0001K#a\u0002\"p_2,\u0017M\\\u0005\u0003{\u0015\na\u0001P5oSRtD#\u0002#F\r\u001eC\u0005C\u0001\u0013\u0001\u0011\u0015\u0001T\u00011\u00012\u0011\u0015IT\u00011\u0001(\u0011\u001dYT\u0001%AA\u00025Bq!P\u0003\u0011\u0002\u0003\u0007a(A\u0005f]R\u0014\u0018pU5{KV\tQ&A\u0006`Y\u0006\u001cHo\u00144gg\u0016$\u0018!\u00037bgR,e\u000e\u001e:z+\u0005q\u0005C\u0001\u0013P\u0013\t\u0001VD\u0001\bPM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\u0002\u00151\f7\u000f^(gMN,G/F\u0001(\u0003\u0019awn\\6vaR\u0011a*\u0016\u0005\u0006-*\u0001\raJ\u0001\ri\u0006\u0014x-\u001a;PM\u001a\u001cX\r^\u0001\u0016M\u0016$8\r[+qa\u0016\u0014(i\\;oI>3gm]3u)\rIFL\u0018\t\u0004Qis\u0015BA.*\u0005\u0019y\u0005\u000f^5p]\")Ql\u0003a\u0001\u001d\u0006Ya-\u001a;dQ>3gm]3u\u0011\u0015y6\u00021\u0001.\u0003%1W\r^2i'&TX-\u0001\bsK2\fG/\u001b<f\u001f\u001a47/\u001a;\u0015\u00075\u0012'\u000eC\u0003d\u0019\u0001\u0007A-\u0001\u0004ck\u001a4WM\u001d\t\u0003K\"l\u0011A\u001a\u0006\u0003OV\n1A\\5p\u0013\tIgM\u0001\u0006CsR,')\u001e4gKJDQa\u001b\u0007A\u00025\n\u0011A\\\u0001\ta\"L8/[2bYR\u0019QF\\8\t\u000b\rl\u0001\u0019\u00013\t\u000b-l\u0001\u0019A\u0017\u0002\u0015A\f'o]3F]R\u0014\u0018\u0010F\u0002skZ\u0004\"\u0001J:\n\u0005Ql\"AC%oI\u0016DXI\u001c;ss\")1M\u0004a\u0001I\")1N\u0004a\u0001[\u0005)QM\u001c;ssR\u0011a*\u001f\u0005\u0006W>\u0001\r!L\u0001\u0007CB\u0004XM\u001c3\u0015\tq|\u00181\u0001\t\u0003QuL!A`\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u0003\u0001\u0002\u0019A\u0014\u0002\r=4gm]3u\u0011\u0019\t)\u0001\u0005a\u0001[\u0005A\u0001o\\:ji&|g.\u0001\u0005ueVt7-\u0019;f)\u0005a\u0018A\u0003;sk:\u001c\u0017\r^3U_R\u0019A0a\u0004\t\r\u0005\u0005!\u00031\u0001(\u0003E!(/\u001e8dCR,Gk\\#oiJLWm\u001d\u000b\u0004y\u0006U\u0001BBA\f'\u0001\u0007Q&A\u0004f]R\u0014\u0018.Z:\u0002\u0017M\fg.\u001b;z\u0007\",7m[\u0001\u0013gV\u0004XM\u001d\u0013nCbLe\u000eZ3y'&TX-\u0001\ttkB,'\u000f\n2bg\u0016|eMZ:fi\u0006YqJ\u001a4tKRLe\u000eZ3y!\t!\u0003dE\u0002\u0019\u0003K\u00012\u0001KA\u0014\u0013\r\tI#\u000b\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005\u0005\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u00022)\u001aQ&a\r,\u0005\u0005U\u0002\u0003BA\u001c\u0003\u0003j!!!\u000f\u000b\t\u0005m\u0012QH\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0010*\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0007\nIDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAA%U\rq\u00141\u0007")
public class OffsetIndex
extends AbstractIndex<Object, Object> {
    private long _lastOffset = this.lastEntry().offset();

    public static boolean $lessinit$greater$default$4() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$3();
    }

    private /* synthetic */ int super$maxIndexSize() {
        return super.maxIndexSize();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 8;
    }

    private OffsetPosition lastEntry() {
        return (OffsetPosition)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            OffsetPosition offsetPosition;
            int n = this._entries();
            switch (n) {
                case 0: {
                    offsetPosition = new OffsetPosition(this.super$baseOffset(), 0);
                    break;
                }
                default: {
                    offsetPosition = (OffsetPosition)this.parseEntry(this.mmap(), n - 1);
                    break;
                }
            }
            return offsetPosition;
        });
    }

    public long lastOffset() {
        return this._lastOffset;
    }

    public OffsetPosition lookup(long targetOffset) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetOffset, IndexSearchType$.MODULE$.KEY());
            return slot == -1 ? new OffsetPosition(this.super$baseOffset(), 0) : (OffsetPosition)this.parseEntry(idx, slot);
        });
    }

    public Option<OffsetPosition> fetchUpperBoundOffset(OffsetPosition fetchOffset, int fetchSize) {
        return (Option)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.smallestUpperBoundSlotFor(idx, fetchOffset.position() + fetchSize, IndexSearchType$.MODULE$.VALUE());
            return slot == -1 ? None$.MODULE$ : new Some((Object)((OffsetPosition)this.parseEntry(idx, slot)));
        });
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize());
    }

    private int physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 4);
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new OffsetPosition(super.baseOffset() + (long)this.relativeOffset(buffer, n), this.physical(buffer, n));
    }

    public OffsetPosition entry(int n) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringBuilder(43).append("Attempt to fetch the ").append(n).append("th entry from index ").append(this.file().getAbsolutePath()).append(", ").append(new StringBuilder(16).append("which has size ").append(this._entries()).append(".").toString()).toString());
            }
            ByteBuffer idx = this.mmap().duplicate();
            return new OffsetPosition(this.relativeOffset(idx, n), this.physical(idx, n));
        });
    }

    public void append(long offset, int position) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(!this.isFull(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Attempt to append to a full index (size = ").append(this._entries()).append(").").toString());
            if (this._entries() != 0 && offset <= $this._lastOffset) {
                throw new InvalidOffsetException(new StringBuilder(58).append("Attempt to append an offset (").append(offset).append(") to position ").append(this.entries()).append(" no larger than").append(new StringBuilder(33).append(" the last offset appended (").append($this._lastOffset).append(") to ").append(this.file().getAbsolutePath()).append(".").toString()).toString());
            }
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Adding index entry ").append(offset).append(" => ").append(position).append(" to ").append(this.file().getAbsolutePath()).toString());
            this.mmap().putInt(this.relativeOffset(offset));
            this.mmap().putInt(position);
            this._entries_$eq(this._entries() + 1);
            $this._lastOffset = offset;
            Predef$.MODULE$.require(this._entries() * this.entrySize() == this.mmap().position(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append(this.entries()).append(" entries but file position in index is ").append(this.mmap().position()).append(".").toString());
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, offset, IndexSearchType$.MODULE$.KEY());
            int newEntries = slot < 0 ? 0 : ((long)this.relativeOffset(idx, slot) == offset - this.super$baseOffset() ? slot : slot + 1);
            this.truncateToEntries(newEntries);
        });
    }

    private void truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this._entries_$eq(entries);
            this.mmap().position(this._entries() * this.entrySize());
            $this._lastOffset = this.lastEntry().offset();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Truncated index ").append(this.file().getAbsolutePath()).append(" to ").append(entries).append(" entries;").append(new StringBuilder(41).append(" position is now ").append(this.mmap().position()).append(" and last offset is now ").append($this._lastOffset).toString()).toString());
        });
    }

    @Override
    public void sanityCheck() {
        if (this._entries() != 0 && this._lastOffset < super.baseOffset()) {
            throw new CorruptIndexException(new StringBuilder(53).append("Corrupt index found, index file (").append(this.file().getAbsolutePath()).append(") has non-zero size ").append(new StringBuilder(60).append("but the last offset is ").append(this._lastOffset).append(" which is less than the base offset ").append(super.baseOffset()).append(".").toString()).toString());
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringBuilder(46).append("Index file ").append(this.file().getAbsolutePath()).append(" is corrupt, found ").append(this.length()).append(" bytes which is ").append(new StringBuilder(36).append("neither positive nor a multiple of ").append(this.entrySize()).append(".").toString()).toString());
        }
    }

    public OffsetIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Loaded index file ").append(this.file().getAbsolutePath()).append(" with maxEntries = ").append(this.maxEntries()).append(", ").append(new StringBuilder(60).append("maxIndexSize = ").append(this.super$maxIndexSize()).append(", entries = ").append(this._entries()).append(", lastOffset = ").append($this._lastOffset).append(", file position = ").append(this.mmap().position()).toString()).toString());
    }
}

