/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import kafka.log.CompletedTxn;
import kafka.log.ProducerIdEntry;
import kafka.log.TxnMetadata;
import kafka.server.LogOffsetMetadata;
import org.apache.kafka.common.errors.DuplicateSequenceNumberException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=g!B\u0001\u0003\u0001\t1!A\u0005)s_\u0012,8-\u001a:BaB,g\u000eZ%oM>T!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b'\t\u0001q\u0001\u0005\u0002\t\u00175\t\u0011BC\u0001\u000b\u0003\u0015\u00198-\u00197b\u0013\ta\u0011B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001d\u0001\u0011)\u0019!C\u0001!\u0005Q\u0001O]8ek\u000e,'/\u00133\u0004\u0001U\t\u0011\u0003\u0005\u0002\t%%\u00111#\u0003\u0002\u0005\u0019>tw\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0012\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\t\u0011]\u0001!\u0011!Q\u0001\na\tA\"\u001b8ji&\fG.\u00128uef\u0004\"!\u0007\u000e\u000e\u0003\tI!a\u0007\u0002\u0003\u001fA\u0013x\u000eZ;dKJLE-\u00128uefD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0018m\u0006d\u0017\u000eZ1uKN+\u0017/^3oG\u0016tU/\u001c2feN\u0004\"\u0001C\u0010\n\u0005\u0001J!a\u0002\"p_2,\u0017M\u001c\u0005\tE\u0001\u0011\t\u0011)A\u0005=\u0005a\u0011n\u001d$s_6\u001cE.[3oi\")A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"RAJ\u0014)S)\u0002\"!\u0007\u0001\t\u000b9\u0019\u0003\u0019A\t\t\u000b]\u0019\u0003\u0019\u0001\r\t\u000bu\u0019\u0003\u0019\u0001\u0010\t\u000b\t\u001a\u0003\u0019\u0001\u0010\t\u000f1\u0002\u0001\u0019!C\u0005[\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\u0012A\f\t\u0003\u0011=J!\u0001M\u0005\u0003\u000bMCwN\u001d;\t\u000fI\u0002\u0001\u0019!C\u0005g\u0005\t\u0002O]8ek\u000e,'/\u00129pG\"|F%Z9\u0015\u0005Q:\u0004C\u0001\u00056\u0013\t1\u0014B\u0001\u0003V]&$\bb\u0002\u001d2\u0003\u0003\u0005\rAL\u0001\u0004q\u0012\n\u0004B\u0002\u001e\u0001A\u0003&a&\u0001\bqe>$WoY3s\u000bB|7\r\u001b\u0011\t\u000fq\u0002\u0001\u0019!C\u0005{\u0005Aa-\u001b:tiN+\u0017/F\u0001?!\tAq(\u0003\u0002A\u0013\t\u0019\u0011J\u001c;\t\u000f\t\u0003\u0001\u0019!C\u0005\u0007\u0006aa-\u001b:tiN+\u0017o\u0018\u0013fcR\u0011A\u0007\u0012\u0005\bq\u0005\u000b\t\u00111\u0001?\u0011\u00191\u0005\u0001)Q\u0005}\u0005Ia-\u001b:tiN+\u0017\u000f\t\u0005\b\u0011\u0002\u0001\r\u0011\"\u0003>\u0003\u001da\u0017m\u001d;TKFDqA\u0013\u0001A\u0002\u0013%1*A\u0006mCN$8+Z9`I\u0015\fHC\u0001\u001bM\u0011\u001dA\u0014*!AA\u0002yBaA\u0014\u0001!B\u0013q\u0014\u0001\u00037bgR\u001cV-\u001d\u0011\t\u000fA\u0003\u0001\u0019!C\u0005!\u0005QA.Y:u\u001f\u001a47/\u001a;\t\u000fI\u0003\u0001\u0019!C\u0005'\u0006qA.Y:u\u001f\u001a47/\u001a;`I\u0015\fHC\u0001\u001bU\u0011\u001dA\u0014+!AA\u0002EAaA\u0016\u0001!B\u0013\t\u0012a\u00037bgR|eMZ:fi\u0002Bq\u0001\u0017\u0001A\u0002\u0013%\u0001#\u0001\u0007nCb$\u0016.\\3ti\u0006l\u0007\u000fC\u0004[\u0001\u0001\u0007I\u0011B.\u0002!5\f\u0007\u0010V5nKN$\u0018-\u001c9`I\u0015\fHC\u0001\u001b]\u0011\u001dA\u0014,!AA\u0002EAaA\u0018\u0001!B\u0013\t\u0012!D7bqRKW.Z:uC6\u0004\b\u0005C\u0004a\u0001\u0001\u0007I\u0011B1\u0002+\r,(O]3oiRChNR5sgR|eMZ:fiV\t!\rE\u0002\tGFI!\u0001Z\u0005\u0003\r=\u0003H/[8o\u0011\u001d1\u0007\u00011A\u0005\n\u001d\f\u0011dY;se\u0016tG\u000f\u0016=o\r&\u00148\u000f^(gMN,Go\u0018\u0013fcR\u0011A\u0007\u001b\u0005\bq\u0015\f\t\u00111\u0001c\u0011\u0019Q\u0007\u0001)Q\u0005E\u000612-\u001e:sK:$H\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$\b\u0005C\u0004m\u0001\u0001\u0007I\u0011B\u001f\u0002!\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007b\u00028\u0001\u0001\u0004%Ia\\\u0001\u0015G>|'\u000fZ5oCR|'/\u00129pG\"|F%Z9\u0015\u0005Q\u0002\bb\u0002\u001dn\u0003\u0003\u0005\rA\u0010\u0005\u0007e\u0002\u0001\u000b\u0015\u0002 \u0002#\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007\u0005C\u0004u\u0001\t\u0007I\u0011B;\u0002\u0019Q\u0014\u0018M\\:bGRLwN\\:\u0016\u0003Y\u00042a\u001e?\u007f\u001b\u0005A(BA={\u0003\u001diW\u000f^1cY\u0016T!a_\u0005\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002~q\nQA*[:u\u0005V4g-\u001a:\u0011\u0005ey\u0018bAA\u0001\u0005\tYA\u000b\u001f8NKR\fG-\u0019;b\u0011\u001d\t)\u0001\u0001Q\u0001\nY\fQ\u0002\u001e:b]N\f7\r^5p]N\u0004\u0003bBA\u0005\u0001\u0011%\u00111B\u0001\u000fm\u0006d\u0017\u000eZ1uK\u0006\u0003\b/\u001a8e)\u001d!\u0014QBA\b\u0003#Aa\u0001LA\u0004\u0001\u0004q\u0003B\u0002\u001f\u0002\b\u0001\u0007a\b\u0003\u0004I\u0003\u000f\u0001\rA\u0010\u0005\b\u0003+\u0001A\u0011BA\f\u0003)IgnU3rk\u0016t7-\u001a\u000b\u0006=\u0005e\u00111\u0004\u0005\u0007y\u0005M\u0001\u0019\u0001 \t\r!\u000b\u0019\u00021\u0001?\u0011\u001d\ty\u0002\u0001C\u0005\u0003C\t\u0001\"[:GK:\u001cW\r\u001a\u000b\u0004=\u0005\r\u0002B\u0002\u0017\u0002\u001e\u0001\u0007a\u0006C\u0004\u0002(\u0001!\t!!\u000b\u0002\r\u0005\u0004\b/\u001a8e)\u0011\tY#a\r\u0011\t!\u0019\u0017Q\u0006\t\u00043\u0005=\u0012bAA\u0019\u0005\ta1i\\7qY\u0016$X\r\u001a+y]\"A\u0011QGA\u0013\u0001\u0004\t9$A\u0003cCR\u001c\u0007\u000e\u0005\u0003\u0002:\u00055SBAA\u001e\u0015\u0011\ti$a\u0010\u0002\rI,7m\u001c:e\u0015\u0011\t\t%a\u0011\u0002\r\r|W.\\8o\u0015\r)\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0017\n1a\u001c:h\u0013\u0011\ty%a\u000f\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r\u001b\u0005\b\u0003O\u0001A\u0011AA*)5!\u0014QKA-\u00037\ni&!\u0019\u0002d!9\u0011qKA)\u0001\u0004q\u0013!B3q_\u000eD\u0007B\u0002\u001f\u0002R\u0001\u0007a\b\u0003\u0004I\u0003#\u0002\rA\u0010\u0005\b\u0003?\n\t\u00061\u0001\u0012\u00035a\u0017m\u001d;US6,7\u000f^1na\"1\u0001+!\u0015A\u0002EAq!!\u001a\u0002R\u0001\u0007a$A\bjgR\u0013\u0018M\\:bGRLwN\\1m\u0011\u001d\tI\u0007\u0001C\u0001\u0003W\n!#\u00199qK:$WI\u001c3Uq:l\u0015M]6feRQ\u0011QFA7\u0003o\nI(! \t\u0011\u0005=\u0014q\ra\u0001\u0003c\nA\"\u001a8e)btW*\u0019:lKJ\u0004B!!\u000f\u0002t%!\u0011QOA\u001e\u0005Q)e\u000e\u001a+sC:\u001c\u0018m\u0019;j_:l\u0015M]6fe\"1A&a\u001aA\u00029Bq!a\u001f\u0002h\u0001\u0007\u0011#\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0003\u007f\n9\u00071\u0001\u0012\u0003%!\u0018.\\3ti\u0006l\u0007\u000fC\u0004\u0002\u0004\u0002!\t!!\"\u0002\u00131\f7\u000f^#oiJLX#\u0001\r\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\u0006\u00192\u000f^1si\u0016$GK]1og\u0006\u001cG/[8ogV\u0011\u0011Q\u0012\t\u0006\u0003\u001f\u000byJ \b\u0005\u0003#\u000bYJ\u0004\u0003\u0002\u0014\u0006eUBAAK\u0015\r\t9jD\u0001\u0007yI|w\u000e\u001e \n\u0003)I1!!(\n\u0003\u001d\u0001\u0018mY6bO\u0016LA!!)\u0002$\n!A*[:u\u0015\r\ti*\u0003\u0005\b\u0003O\u0003A\u0011AAU\u0003\u0001j\u0017-\u001f2f\u0007\u0006\u001c\u0007.\u001a+y]\u001aK'o\u001d;PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0015\u0007Q\nY\u000b\u0003\u0005\u0002.\u0006\u0015\u0006\u0019AAX\u0003EawnZ(gMN,G/T3uC\u0012\fG/\u0019\t\u0005\u0003c\u000b9,\u0004\u0002\u00024*\u0019\u0011Q\u0017\u0003\u0002\rM,'O^3s\u0013\u0011\tI,a-\u0003#1{wm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\rC\u0004\u0002>\u0002!\t%a0\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!1\u0011\t\u0005\r\u0017\u0011\u001a\b\u0004\u0011\u0005\u0015\u0017bAAd\u0013\u00051\u0001K]3eK\u001aLA!a3\u0002N\n11\u000b\u001e:j]\u001eT1!a2\n\u0001")
public class ProducerAppendInfo {
    private final long producerId;
    private final boolean validateSequenceNumbers;
    private final boolean isFromClient;
    private short producerEpoch;
    private int firstSeq;
    private int lastSeq;
    private long lastOffset;
    private long maxTimestamp;
    private Option<Object> currentTxnFirstOffset;
    private int coordinatorEpoch;
    private final ListBuffer<TxnMetadata> transactions;

    public long producerId() {
        return this.producerId;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    private int firstSeq() {
        return this.firstSeq;
    }

    private void firstSeq_$eq(int x$1) {
        this.firstSeq = x$1;
    }

    private int lastSeq() {
        return this.lastSeq;
    }

    private void lastSeq_$eq(int x$1) {
        this.lastSeq = x$1;
    }

    private long lastOffset() {
        return this.lastOffset;
    }

    private void lastOffset_$eq(long x$1) {
        this.lastOffset = x$1;
    }

    private long maxTimestamp() {
        return this.maxTimestamp;
    }

    private void maxTimestamp_$eq(long x$1) {
        this.maxTimestamp = x$1;
    }

    private Option<Object> currentTxnFirstOffset() {
        return this.currentTxnFirstOffset;
    }

    private void currentTxnFirstOffset_$eq(Option<Object> x$1) {
        this.currentTxnFirstOffset = x$1;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private void coordinatorEpoch_$eq(int x$1) {
        this.coordinatorEpoch = x$1;
    }

    private ListBuffer<TxnMetadata> transactions() {
        return this.transactions;
    }

    private void validateAppend(short producerEpoch, int firstSeq, int lastSeq) {
        if (this.isFenced(producerEpoch)) {
            throw new ProducerFencedException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Producer's epoch is no longer valid. There is probably another producer "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with a newer epoch. ", " (request epoch), ", " (server epoch)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)producerEpoch), BoxesRunTime.boxToShort((short)this.producerEpoch())}))).toString());
        }
        if (this.validateSequenceNumbers) {
            if (producerEpoch != this.producerEpoch()) {
                if (firstSeq != 0) {
                    throw new OutOfOrderSequenceException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid sequence number for new epoch: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)producerEpoch)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(request epoch), ", " (seq. number)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)firstSeq)}))).toString());
                }
            } else {
                if (this.firstSeq() == -1 && firstSeq != 0) {
                    throw new OutOfOrderSequenceException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Out of order sequence number for producerId ", ": found ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToInteger((int)firstSeq)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(incoming seq. number), but expected 0"})).s((Seq)Nil$.MODULE$)).toString());
                }
                if (firstSeq == this.firstSeq() && lastSeq == this.lastSeq()) {
                    throw new DuplicateSequenceNumberException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate sequence number for producerId ", ": (incomingBatch.firstSeq, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"incomingBatch.lastSeq): (", ", ", "), (lastEntry.firstSeq, lastEntry.lastSeq): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)firstSeq), BoxesRunTime.boxToInteger((int)lastSeq)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.firstSeq()), BoxesRunTime.boxToInteger((int)this.lastSeq())}))).toString());
                }
                if (!this.inSequence(firstSeq, lastSeq)) {
                    throw new OutOfOrderSequenceException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Out of order sequence number for producerId ", ": ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToInteger((int)firstSeq)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(incoming seq. number), ", " (current end sequence number)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastSeq())}))).toString());
                }
            }
        }
    }

    private boolean inSequence(int firstSeq, int lastSeq) {
        return (long)firstSeq == (long)this.lastSeq() + 1L || firstSeq == 0 && this.lastSeq() == Integer.MAX_VALUE;
    }

    private boolean isFenced(short producerEpoch) {
        return producerEpoch < this.producerEpoch();
    }

    public Option<CompletedTxn> append(RecordBatch batch) {
        None$ none$;
        if (batch.isControlBatch()) {
            Record record2 = (Record)batch.iterator().next();
            EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record2);
            CompletedTxn completedTxn = this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record2.timestamp());
            none$ = new Some((Object)completedTxn);
        } else {
            this.append(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), batch.lastOffset(), batch.isTransactional());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void append(short epoch, int firstSeq, int lastSeq, long lastTimestamp, long lastOffset, boolean isTransactional) {
        if (this.isFromClient) {
            this.validateAppend(epoch, firstSeq, lastSeq);
        }
        this.producerEpoch_$eq(epoch);
        this.firstSeq_$eq(firstSeq);
        this.lastSeq_$eq(lastSeq);
        this.maxTimestamp_$eq(lastTimestamp);
        this.lastOffset_$eq(lastOffset);
        if (this.currentTxnFirstOffset().isDefined() && !isTransactional) {
            throw new InvalidTxnStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected transactional write from producer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())})));
        }
        if (isTransactional && this.currentTxnFirstOffset().isEmpty()) {
            long firstOffset = lastOffset - (long)(lastSeq - firstSeq);
            this.currentTxnFirstOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)firstOffset)));
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), firstOffset));
        }
    }

    public CompletedTxn appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset2, long timestamp2) {
        Option<Object> option;
        block9: {
            long l;
            block8: {
                block7: {
                    long txnFirstOffset;
                    if (this.isFenced(producerEpoch)) {
                        throw new ProducerFencedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid producer epoch: ", " (zombie): ", " (current)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)producerEpoch), BoxesRunTime.boxToShort((short)this.producerEpoch())})));
                    }
                    if (this.coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
                        throw new TransactionCoordinatorFencedException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid coordinator epoch: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)endTxnMarker.coordinatorEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(zombie), ", " (current)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.coordinatorEpoch())}))).toString());
                    }
                    if (producerEpoch != this.producerEpoch()) {
                        this.producerEpoch_$eq(producerEpoch);
                        this.firstSeq_$eq(-1);
                        this.lastSeq_$eq(-1);
                    } else {
                        this.firstSeq_$eq(this.lastSeq());
                    }
                    option = this.currentTxnFirstOffset();
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    l = txnFirstOffset = BoxesRunTime.unboxToLong((Object)some.x());
                    break block8;
                }
                if (!None$.MODULE$.equals(option)) break block9;
                this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), offset2));
                l = offset2;
            }
            long firstOffset = l;
            this.lastOffset_$eq(offset2);
            this.currentTxnFirstOffset_$eq((Option<Object>)None$.MODULE$);
            this.maxTimestamp_$eq(timestamp2);
            this.coordinatorEpoch_$eq(endTxnMarker.coordinatorEpoch());
            ControlRecordType controlRecordType = endTxnMarker.controlType();
            ControlRecordType controlRecordType2 = ControlRecordType.ABORT;
            return new CompletedTxn(this.producerId(), firstOffset, offset2, !(controlRecordType != null ? !controlRecordType.equals(controlRecordType2) : controlRecordType2 != null));
        }
        throw new MatchError(option);
    }

    public ProducerIdEntry lastEntry() {
        return new ProducerIdEntry(this.producerId(), this.producerEpoch(), this.lastSeq(), this.lastOffset(), this.lastSeq() - this.firstSeq(), this.maxTimestamp(), this.coordinatorEpoch(), this.currentTxnFirstOffset());
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions().toList();
    }

    public void maybeCacheTxnFirstOffsetMetadata(LogOffsetMetadata logOffsetMetadata) {
        this.transactions().headOption().foreach((Function1)new Serializable(this, logOffsetMetadata){
            public static final long serialVersionUID = 0L;
            private final LogOffsetMetadata logOffsetMetadata$1;

            public final void apply(TxnMetadata txn) {
                if (txn.firstOffset().messageOffset() == this.logOffsetMetadata$1.messageOffset()) {
                    txn.firstOffset_$eq(this.logOffsetMetadata$1);
                }
            }
            {
                this.logOffsetMetadata$1 = logOffsetMetadata$1;
            }
        });
    }

    public String toString() {
        return new StringBuilder().append((Object)"ProducerAppendInfo(").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)this.producerEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firstSequence=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.firstSeq())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastSequence=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastSeq())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currentTxnFirstOffset=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentTxnFirstOffset()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coordinatorEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.coordinatorEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startedTransactions=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactions()}))).toString();
    }

    public ProducerAppendInfo(long producerId, ProducerIdEntry initialEntry, boolean validateSequenceNumbers, boolean isFromClient) {
        this.producerId = producerId;
        this.validateSequenceNumbers = validateSequenceNumbers;
        this.isFromClient = isFromClient;
        this.producerEpoch = initialEntry.producerEpoch();
        this.firstSeq = initialEntry.firstSeq();
        this.lastSeq = initialEntry.lastSeq();
        this.lastOffset = initialEntry.lastOffset();
        this.maxTimestamp = initialEntry.timestamp();
        this.currentTxnFirstOffset = initialEntry.currentTxnFirstOffset();
        this.coordinatorEpoch = initialEntry.coordinatorEpoch();
        this.transactions = (ListBuffer)ListBuffer$.MODULE$.empty();
    }
}

