/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.ConstantPayloadGenerator;
import org.apache.kafka.trogdor.workload.PayloadGenerator;
import org.apache.kafka.trogdor.workload.ProduceBenchWorker;
import org.apache.kafka.trogdor.workload.SequentialPayloadGenerator;
import org.apache.kafka.trogdor.workload.TopicsSpec;
import org.apache.kafka.trogdor.workload.TransactionGenerator;

public class ProduceBenchSpec
extends TaskSpec {
    private final String producerNode;
    private final String bootstrapServers;
    private final int targetMessagesPerSec;
    private final long maxMessages;
    private final PayloadGenerator keyGenerator;
    private final PayloadGenerator valueGenerator;
    private final Optional<TransactionGenerator> transactionGenerator;
    private final Map<String, String> producerConf;
    private final Map<String, String> adminClientConf;
    private final Map<String, String> commonClientConf;
    private final TopicsSpec activeTopics;
    private final TopicsSpec inactiveTopics;

    @JsonCreator
    public ProduceBenchSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="producerNode") String producerNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="targetMessagesPerSec") int targetMessagesPerSec, @JsonProperty(value="maxMessages") long maxMessages, @JsonProperty(value="keyGenerator") PayloadGenerator keyGenerator, @JsonProperty(value="valueGenerator") PayloadGenerator valueGenerator, @JsonProperty(value="transactionGenerator") Optional<TransactionGenerator> txGenerator, @JsonProperty(value="producerConf") Map<String, String> producerConf, @JsonProperty(value="commonClientConf") Map<String, String> commonClientConf, @JsonProperty(value="adminClientConf") Map<String, String> adminClientConf, @JsonProperty(value="activeTopics") TopicsSpec activeTopics, @JsonProperty(value="inactiveTopics") TopicsSpec inactiveTopics) {
        super(startMs, durationMs);
        this.producerNode = producerNode == null ? "" : producerNode;
        this.bootstrapServers = bootstrapServers == null ? "" : bootstrapServers;
        this.targetMessagesPerSec = targetMessagesPerSec;
        this.maxMessages = maxMessages;
        this.keyGenerator = keyGenerator == null ? new SequentialPayloadGenerator(4, 0L) : keyGenerator;
        this.valueGenerator = valueGenerator == null ? new ConstantPayloadGenerator(512, new byte[0]) : valueGenerator;
        this.transactionGenerator = txGenerator == null ? Optional.empty() : txGenerator;
        this.producerConf = this.configOrEmptyMap(producerConf);
        this.commonClientConf = this.configOrEmptyMap(commonClientConf);
        this.adminClientConf = this.configOrEmptyMap(adminClientConf);
        this.activeTopics = activeTopics == null ? TopicsSpec.EMPTY : activeTopics.immutableCopy();
        this.inactiveTopics = inactiveTopics == null ? TopicsSpec.EMPTY : inactiveTopics.immutableCopy();
    }

    @JsonProperty
    public String producerNode() {
        return this.producerNode;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public int targetMessagesPerSec() {
        return this.targetMessagesPerSec;
    }

    @JsonProperty
    public long maxMessages() {
        return this.maxMessages;
    }

    @JsonProperty
    public PayloadGenerator keyGenerator() {
        return this.keyGenerator;
    }

    @JsonProperty
    public PayloadGenerator valueGenerator() {
        return this.valueGenerator;
    }

    @JsonProperty
    public Optional<TransactionGenerator> transactionGenerator() {
        return this.transactionGenerator;
    }

    @JsonProperty
    public Map<String, String> producerConf() {
        return this.producerConf;
    }

    @JsonProperty
    public Map<String, String> commonClientConf() {
        return this.commonClientConf;
    }

    @JsonProperty
    public Map<String, String> adminClientConf() {
        return this.adminClientConf;
    }

    @JsonProperty
    public TopicsSpec activeTopics() {
        return this.activeTopics;
    }

    @JsonProperty
    public TopicsSpec inactiveTopics() {
        return this.inactiveTopics;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.producerNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new ProduceBenchWorker(id, this);
    }
}

