/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.AbstractStoreBuilder;
import org.apache.kafka.streams.state.internals.CachingWindowStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingTimestampedWindowBytesStore;
import org.apache.kafka.streams.state.internals.MeteredTimestampedWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.TimeOrderedCachingWindowStore;
import org.apache.kafka.streams.state.internals.TimestampedWindowStoreBuilder;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WindowToTimestampedWindowByteStoreAdapter;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class TimestampedWindowStoreBuilderTest {
    private static final String TIMESTAMP_STORE_NAME = "Timestamped Store";
    private static final String TIMEORDERED_STORE_NAME = "TimeOrdered Store";
    @Mock
    private WindowBytesStoreSupplier supplier;
    @Mock
    private RocksDBTimestampedWindowStore timestampedStore;
    @Mock
    private RocksDBTimeOrderedWindowStore timeOrderedStore;
    private TimestampedWindowStoreBuilder<String, String> builder;
    private boolean isTimeOrderedStore;
    private WindowStore inner;
    @Parameterized.Parameter
    public String storeName;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({TIMESTAMP_STORE_NAME}, {TIMEORDERED_STORE_NAME});
    }

    @Before
    public void setUp() {
        this.isTimeOrderedStore = TIMEORDERED_STORE_NAME.equals(this.storeName);
        this.inner = this.isTimeOrderedStore ? this.timeOrderedStore : this.timestampedStore;
        Mockito.when((Object)this.supplier.get()).thenReturn((Object)this.inner);
        Mockito.when((Object)this.supplier.name()).thenReturn((Object)"name");
        Mockito.when((Object)this.supplier.metricsScope()).thenReturn((Object)"metricScope");
        this.builder = new TimestampedWindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    @Test
    public void shouldHaveMeteredStoreAsOuterStore() {
        TimestampedWindowStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedWindowStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreByDefault() {
        TimestampedWindowStore store = this.builder.build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedWindowBytesStore.class));
    }

    @Test
    public void shouldNotHaveChangeLoggingStoreWhenDisabled() {
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingDisabled().build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @Test
    public void shouldHaveCachingStoreWhenEnabled() {
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withCachingEnabled().build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedWindowStore.class));
        if (this.isTimeOrderedStore) {
            MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(TimeOrderedCachingWindowStore.class));
        } else {
            MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(CachingWindowStore.class));
        }
    }

    @Test
    public void shouldHaveChangeLoggingStoreWhenLoggingEnabled() {
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingEnabled(Collections.emptyMap()).build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedWindowStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedWindowBytesStore.class));
        MatcherAssert.assertThat((Object)((WrappedStateStore)wrapped).wrapped(), (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @Test
    public void shouldHaveCachingAndChangeLoggingWhenBothEnabled() {
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingEnabled(Collections.emptyMap()).withCachingEnabled().build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        WrappedStateStore changeLogging = (WrappedStateStore)caching.wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedWindowStore.class));
        if (this.isTimeOrderedStore) {
            MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(TimeOrderedCachingWindowStore.class));
        } else {
            MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingWindowStore.class));
        }
        MatcherAssert.assertThat((Object)changeLogging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedWindowBytesStore.class));
        MatcherAssert.assertThat((Object)changeLogging.wrapped(), (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @Test
    public void shouldNotWrapTimestampedByteStore() {
        Mockito.when((Object)this.supplier.get()).thenReturn((Object)new RocksDBTimestampedWindowStore((SegmentedBytesStore)new RocksDBTimestampedSegmentedBytesStore("name", "metric-scope", 10L, 5L, (SegmentedBytesStore.KeySchema)new WindowKeySchema()), false, 1L));
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingDisabled().withCachingDisabled().build();
        MatcherAssert.assertThat((Object)((WrappedStateStore)store).wrapped(), (Matcher)IsInstanceOf.instanceOf(RocksDBTimestampedWindowStore.class));
    }

    @Test
    public void shouldWrapPlainKeyValueStoreAsTimestampStore() {
        Mockito.when((Object)this.supplier.get()).thenReturn((Object)new RocksDBWindowStore((SegmentedBytesStore)new RocksDBSegmentedBytesStore("name", "metric-scope", 10L, 5L, (SegmentedBytesStore.KeySchema)new WindowKeySchema()), false, 1L));
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingDisabled().withCachingDisabled().build();
        MatcherAssert.assertThat((Object)((WrappedStateStore)store).wrapped(), (Matcher)IsInstanceOf.instanceOf(WindowToTimestampedWindowByteStoreAdapter.class));
    }

    @Test
    public void shouldDisableCachingWithRetainDuplicates() {
        this.supplier = Stores.persistentTimestampedWindowStore((String)"name", (Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(10L), (boolean)true);
        StoreBuilder builder = new TimestampedWindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()).withCachingEnabled();
        builder.build();
        Assert.assertFalse((boolean)((AbstractStoreBuilder)builder).enableCaching);
    }

    @Test
    public void shouldThrowNullPointerIfInnerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> new TimestampedWindowStoreBuilder(null, Serdes.String(), Serdes.String(), (Time)new MockTime()));
    }

    @Test
    public void shouldThrowNullPointerIfTimeIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> new TimestampedWindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), null));
    }

    @Test
    public void shouldThrowNullPointerIfMetricsScopeIsNull() {
        Mockito.when((Object)this.supplier.metricsScope()).thenReturn(null);
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> new TimestampedWindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()));
        Assert.assertEquals((Object)e.getMessage(), (Object)"storeSupplier's metricsScope can't be null");
    }
}

