/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.state.internals.TimestampedKeyAndJoinSide;
import org.apache.kafka.streams.state.internals.TimestampedKeyAndJoinSideSerde;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TimestampedKeyAndJoinSideSerializerTest {
    private static final String TOPIC = "some-topic";
    private static final TimestampedKeyAndJoinSideSerde<String> STRING_SERDE = new TimestampedKeyAndJoinSideSerde(Serdes.String());

    @Test
    public void shouldSerializeKeyWithJoinSideAsTrue() {
        String value = "some-string";
        TimestampedKeyAndJoinSide timestampedKeyAndJoinSide = TimestampedKeyAndJoinSide.makeLeft((Object)"some-string", (long)10L);
        byte[] serialized = STRING_SERDE.serializer().serialize(TOPIC, (Object)timestampedKeyAndJoinSide);
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        TimestampedKeyAndJoinSide deserialized = (TimestampedKeyAndJoinSide)STRING_SERDE.deserializer().deserialize(TOPIC, serialized);
        MatcherAssert.assertThat((Object)deserialized, (Matcher)Matchers.is((Object)timestampedKeyAndJoinSide));
    }

    @Test
    public void shouldSerializeKeyWithJoinSideAsFalse() {
        String value = "some-string";
        TimestampedKeyAndJoinSide timestampedKeyAndJoinSide = TimestampedKeyAndJoinSide.makeRight((Object)"some-string", (long)20L);
        byte[] serialized = STRING_SERDE.serializer().serialize(TOPIC, (Object)timestampedKeyAndJoinSide);
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        TimestampedKeyAndJoinSide deserialized = (TimestampedKeyAndJoinSide)STRING_SERDE.deserializer().deserialize(TOPIC, serialized);
        MatcherAssert.assertThat((Object)deserialized, (Matcher)Matchers.is((Object)timestampedKeyAndJoinSide));
    }

    @Test
    public void shouldThrowIfSerializeNullData() {
        Assert.assertThrows(NullPointerException.class, () -> STRING_SERDE.serializer().serialize(TOPIC, (Object)TimestampedKeyAndJoinSide.makeLeft(null, (long)0L)));
    }
}

