/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.StoreSerdeInitializer;
import org.apache.kafka.test.MockInternalNewProcessorContext;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class StoreSerdeInitializerTest {
    private MockedStatic<WrappingNullableUtils> utilsMock;

    @BeforeEach
    public void setup() {
        this.utilsMock = Mockito.mockStatic(WrappingNullableUtils.class);
    }

    @AfterEach
    public void cleanup() {
        this.utilsMock.close();
    }

    @Test
    public void shouldPrepareStoreSerdeForProcessorContext() {
        Serdes.StringSerde keySerde = new Serdes.StringSerde();
        Serdes.StringSerde valueSerde = new Serdes.StringSerde();
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.utilsMock.when(() -> WrappingNullableUtils.prepareKeySerde((Serde)((Serde)ArgumentMatchers.any()), (SerdeGetter)((SerdeGetter)ArgumentMatchers.any()))).thenReturn((Object)keySerde);
        this.utilsMock.when(() -> WrappingNullableUtils.prepareValueSerde((Serde)((Serde)ArgumentMatchers.any()), (SerdeGetter)((SerdeGetter)ArgumentMatchers.any()))).thenReturn((Object)valueSerde);
        StateSerdes result = StoreSerdeInitializer.prepareStoreSerde(context, (String)"myStore", (String)"topic", (Serde)keySerde, (Serde)valueSerde, WrappingNullableUtils::prepareValueSerde);
        MatcherAssert.assertThat((Object)result.keySerde(), (Matcher)Matchers.equalTo((Object)keySerde));
        MatcherAssert.assertThat((Object)result.valueSerde(), (Matcher)Matchers.equalTo((Object)valueSerde));
        MatcherAssert.assertThat((Object)result.topic(), (Matcher)Matchers.equalTo((Object)"topic"));
    }

    @Test
    public void shouldThrowStreamsExceptionOnUndefinedKeySerdeForProcessorContext() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.utilsMock.when(() -> WrappingNullableUtils.prepareKeySerde((Serde)((Serde)ArgumentMatchers.any()), (SerdeGetter)((SerdeGetter)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new ConfigException("Please set StreamsConfig#DEFAULT_KEY_SERDE_CLASS_CONFIG")});
        Throwable exception = Assertions.assertThrows(StreamsException.class, () -> StoreSerdeInitializer.prepareStoreSerde((ProcessorContext)context, (String)"myStore", (String)"topic", (Serde)new Serdes.StringSerde(), (Serde)new Serdes.StringSerde(), WrappingNullableUtils::prepareValueSerde));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Failed to initialize key serdes for store myStore"));
        MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"Please set StreamsConfig#DEFAULT_KEY_SERDE_CLASS_CONFIG"));
    }

    @Test
    public void shouldThrowStreamsExceptionOnUndefinedValueSerdeForProcessorContext() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.utilsMock.when(() -> WrappingNullableUtils.prepareValueSerde((Serde)((Serde)ArgumentMatchers.any()), (SerdeGetter)((SerdeGetter)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new ConfigException("Please set StreamsConfig#DEFAULT_VALUE_SERDE_CLASS_CONFIG")});
        Throwable exception = Assertions.assertThrows(StreamsException.class, () -> StoreSerdeInitializer.prepareStoreSerde((ProcessorContext)context, (String)"myStore", (String)"topic", (Serde)new Serdes.StringSerde(), (Serde)new Serdes.StringSerde(), WrappingNullableUtils::prepareValueSerde));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Failed to initialize value serdes for store myStore"));
        MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"Please set StreamsConfig#DEFAULT_VALUE_SERDE_CLASS_CONFIG"));
    }

    @Test
    public void shouldThrowStreamsExceptionOnUndefinedKeySerdeForStateStoreContext() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.utilsMock.when(() -> WrappingNullableUtils.prepareKeySerde((Serde)((Serde)ArgumentMatchers.any()), (SerdeGetter)((SerdeGetter)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new ConfigException("Please set StreamsConfig#DEFAULT_KEY_SERDE_CLASS_CONFIG")});
        Throwable exception = Assertions.assertThrows(StreamsException.class, () -> StoreSerdeInitializer.prepareStoreSerde((StateStoreContext)context, (String)"myStore", (String)"topic", (Serde)new Serdes.StringSerde(), (Serde)new Serdes.StringSerde(), WrappingNullableUtils::prepareValueSerde));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Failed to initialize key serdes for store myStore"));
        MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"Please set StreamsConfig#DEFAULT_KEY_SERDE_CLASS_CONFIG"));
    }

    @Test
    public void shouldThrowStreamsExceptionOnUndefinedValueSerdeForStateStoreContext() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.utilsMock.when(() -> WrappingNullableUtils.prepareValueSerde((Serde)((Serde)ArgumentMatchers.any()), (SerdeGetter)((SerdeGetter)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new ConfigException("Please set StreamsConfig#DEFAULT_VALUE_SERDE_CLASS_CONFIG")});
        Throwable exception = Assertions.assertThrows(StreamsException.class, () -> StoreSerdeInitializer.prepareStoreSerde((StateStoreContext)context, (String)"myStore", (String)"topic", (Serde)new Serdes.StringSerde(), (Serde)new Serdes.StringSerde(), WrappingNullableUtils::prepareValueSerde));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Failed to initialize value serdes for store myStore"));
        MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"Please set StreamsConfig#DEFAULT_VALUE_SERDE_CLASS_CONFIG"));
    }

    @Test
    public void shouldThrowStreamsExceptionWithExplicitErrorMessageForProcessorContext() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.utilsMock.when(() -> WrappingNullableUtils.prepareKeySerde((Serde)((Serde)ArgumentMatchers.any()), (SerdeGetter)((SerdeGetter)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new StreamsException("")});
        Throwable exception = Assertions.assertThrows(StreamsException.class, () -> StoreSerdeInitializer.prepareStoreSerde((ProcessorContext)context, (String)"myStore", (String)"topic", (Serde)new Serdes.StringSerde(), (Serde)new Serdes.StringSerde(), WrappingNullableUtils::prepareValueSerde));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Failed to initialize key serdes for store myStore"));
    }

    @Test
    public void shouldThrowStreamsExceptionWithExplicitErrorMessageForStateStoreContext() {
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext();
        this.utilsMock.when(() -> WrappingNullableUtils.prepareValueSerde((Serde)((Serde)ArgumentMatchers.any()), (SerdeGetter)((SerdeGetter)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new StreamsException("")});
        Throwable exception = Assertions.assertThrows(StreamsException.class, () -> StoreSerdeInitializer.prepareStoreSerde((StateStoreContext)context, (String)"myStore", (String)"topic", (Serde)new Serdes.StringSerde(), (Serde)new Serdes.StringSerde(), WrappingNullableUtils::prepareValueSerde));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Failed to initialize value serdes for store myStore"));
    }
}

