/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.ListValueStoreBuilder;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ListValueStoreTest {
    private final StoreType storeType;
    private KeyValueStore<Integer, String> listStore;
    final File baseDir = TestUtils.tempDirectory((String)"test");

    public ListValueStoreTest(StoreType type) {
        this.storeType = type;
    }

    @Parameterized.Parameters(name="store type = {0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (StoreType type : Arrays.asList(StoreType.InMemory, StoreType.RocksDB)) {
            values.add(new Object[]{type});
        }
        return values;
    }

    @Before
    public void setup() {
        this.listStore = this.buildStore(Serdes.Integer(), Serdes.String());
        MockRecordCollector recordCollector = new MockRecordCollector();
        InternalMockProcessorContext context = new InternalMockProcessorContext(this.baseDir, Serdes.String(), Serdes.Integer(), recordCollector, new ThreadCache(new LogContext("testCache"), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        context.setTime(1L);
        this.listStore.init(context, this.listStore);
    }

    @After
    public void after() {
        this.listStore.close();
    }

    <K, V> KeyValueStore<K, V> buildStore(Serde<K> keySerde, Serde<V> valueSerde) {
        return new ListValueStoreBuilder(this.storeType == StoreType.RocksDB ? Stores.persistentKeyValueStore((String)"rocksDB list store") : Stores.inMemoryKeyValueStore((String)"in-memory list store"), keySerde, valueSerde, Time.SYSTEM).build();
    }

    @Test
    public void shouldGetAll() {
        this.listStore.put((Object)0, (Object)"zero");
        this.listStore.put((Object)0, (Object)"zero again");
        this.listStore.put((Object)1, (Object)"one");
        this.listStore.put((Object)2, (Object)"two");
        KeyValue zero = KeyValue.pair((Object)0, (Object)"zero");
        KeyValue zeroAgain = KeyValue.pair((Object)0, (Object)"zero again");
        KeyValue one = KeyValue.pair((Object)1, (Object)"one");
        KeyValue two = KeyValue.pair((Object)2, (Object)"two");
        Assert.assertEquals(Arrays.asList(zero, zeroAgain, one, two), StreamsTestUtils.toList(this.listStore.all()));
    }

    @Test
    public void shouldGetAllNonDeletedRecords() {
        this.listStore.put((Object)0, (Object)"zero");
        this.listStore.put((Object)1, (Object)"one");
        this.listStore.put((Object)1, (Object)"one again");
        this.listStore.put((Object)2, (Object)"two");
        this.listStore.put((Object)3, (Object)"three");
        this.listStore.put((Object)4, (Object)"four");
        this.listStore.put((Object)1, null);
        this.listStore.put((Object)3, null);
        KeyValue zero = KeyValue.pair((Object)0, (Object)"zero");
        KeyValue two = KeyValue.pair((Object)2, (Object)"two");
        KeyValue four = KeyValue.pair((Object)4, (Object)"four");
        Assert.assertEquals(Arrays.asList(zero, two, four), StreamsTestUtils.toList(this.listStore.all()));
    }

    @Test
    public void shouldGetAllReturnTimestampOrderedRecords() {
        this.listStore.put((Object)4, (Object)"four");
        this.listStore.put((Object)0, (Object)"zero");
        this.listStore.put((Object)2, (Object)"two1");
        this.listStore.put((Object)3, (Object)"three");
        this.listStore.put((Object)1, (Object)"one");
        this.listStore.put((Object)2, (Object)"two2");
        KeyValue zero = KeyValue.pair((Object)0, (Object)"zero");
        KeyValue one = KeyValue.pair((Object)1, (Object)"one");
        KeyValue two1 = KeyValue.pair((Object)2, (Object)"two1");
        KeyValue two2 = KeyValue.pair((Object)2, (Object)"two2");
        KeyValue three = KeyValue.pair((Object)3, (Object)"three");
        KeyValue four = KeyValue.pair((Object)4, (Object)"four");
        Assert.assertEquals(Arrays.asList(zero, one, two1, two2, three, four), StreamsTestUtils.toList(this.listStore.all()));
    }

    @Test
    public void shouldAllowDeleteWhileIterateRecords() {
        this.listStore.put((Object)0, (Object)"zero1");
        this.listStore.put((Object)0, (Object)"zero2");
        this.listStore.put((Object)1, (Object)"one");
        KeyValue zero1 = KeyValue.pair((Object)0, (Object)"zero1");
        KeyValue zero2 = KeyValue.pair((Object)0, (Object)"zero2");
        KeyValue one = KeyValue.pair((Object)1, (Object)"one");
        KeyValueIterator it = this.listStore.all();
        Assert.assertEquals((Object)zero1, (Object)it.next());
        this.listStore.put((Object)0, null);
        Assert.assertEquals((Object)zero2, (Object)it.next());
        it.close();
        Assert.assertEquals(Collections.singletonList(one), StreamsTestUtils.toList(this.listStore.all()));
    }

    @Test
    public void shouldNotReturnMoreDataWhenIteratorClosed() {
        this.listStore.put((Object)0, (Object)"zero1");
        this.listStore.put((Object)0, (Object)"zero2");
        this.listStore.put((Object)1, (Object)"one");
        KeyValueIterator it = this.listStore.all();
        it.close();
        Assert.assertThrows(InvalidStateStoreException.class, () -> it.next());
    }

    private static enum StoreType {
        InMemory,
        RocksDB;

    }
}

