/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Instant;
import java.util.Map;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingTimestampedWindowBytesStore;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class ChangeLoggingTimestampedWindowBytesStoreTest {
    private final byte[] value = new byte[]{0};
    private final byte[] valueAndTimestamp = new byte[]{0, 0, 0, 0, 0, 0, 0, 42, 0};
    private final Bytes bytesKey = Bytes.wrap((byte[])this.value);
    @Mock
    private WindowStore<Bytes, byte[]> inner;
    @Mock
    private ProcessorContextImpl context;
    private ChangeLoggingTimestampedWindowBytesStore store;
    private static final Position POSITION = Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)1L)}))}));

    @Before
    public void setUp() {
        this.store = new ChangeLoggingTimestampedWindowBytesStore(this.inner, false);
        this.store.init((StateStoreContext)this.context, (StateStore)this.store);
    }

    @After
    public void tearDown() {
        ((WindowStore)Mockito.verify(this.inner)).init((StateStoreContext)this.context, (StateStore)this.store);
    }

    @Test
    public void shouldDelegateDeprecatedInit() {
        this.store.init((ProcessorContext)this.context, (StateStore)this.store);
        ((WindowStore)Mockito.verify(this.inner)).init((ProcessorContext)this.context, (StateStore)this.store);
    }

    @Test
    public void shouldDelegateInit() {
    }

    @Test
    public void shouldLogPuts() {
        Bytes key = WindowKeySchema.toStoreKeyBinary((Bytes)this.bytesKey, (long)0L, (int)0);
        Mockito.when((Object)this.inner.getPosition()).thenReturn((Object)Position.emptyPosition());
        this.store.put(this.bytesKey, this.valueAndTimestamp, this.context.timestamp());
        ((WindowStore)Mockito.verify(this.inner)).put((Object)this.bytesKey, (Object)this.valueAndTimestamp, 0L);
        ((ProcessorContextImpl)Mockito.verify((Object)this.context)).logChange(this.store.name(), key, this.value, 42L, Position.emptyPosition());
    }

    @Test
    public void shouldLogPutsWithPosition() {
        Bytes key = WindowKeySchema.toStoreKeyBinary((Bytes)this.bytesKey, (long)0L, (int)0);
        Mockito.when((Object)this.inner.getPosition()).thenReturn((Object)POSITION);
        this.store.put(this.bytesKey, this.valueAndTimestamp, this.context.timestamp());
        ((WindowStore)Mockito.verify(this.inner)).put((Object)this.bytesKey, (Object)this.valueAndTimestamp, 0L);
        ((ProcessorContextImpl)Mockito.verify((Object)this.context)).logChange(this.store.name(), key, this.value, 42L, POSITION);
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFetching() {
        this.store.fetch((Object)this.bytesKey, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L));
        ((WindowStore)Mockito.verify(this.inner)).fetch((Object)this.bytesKey, 0L, 10L);
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFetchingRange() {
        this.store.fetch((Object)this.bytesKey, (Object)this.bytesKey, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1L));
        ((WindowStore)Mockito.verify(this.inner)).fetch((Object)this.bytesKey, (Object)this.bytesKey, 0L, 1L);
    }

    @Test
    public void shouldRetainDuplicatesWhenSet() {
        this.store = new ChangeLoggingTimestampedWindowBytesStore(this.inner, true);
        this.store.init((StateStoreContext)this.context, (StateStore)this.store);
        Bytes key1 = WindowKeySchema.toStoreKeyBinary((Bytes)this.bytesKey, (long)0L, (int)1);
        Bytes key2 = WindowKeySchema.toStoreKeyBinary((Bytes)this.bytesKey, (long)0L, (int)2);
        Mockito.when((Object)this.inner.getPosition()).thenReturn((Object)Position.emptyPosition());
        this.store.put(this.bytesKey, this.valueAndTimestamp, this.context.timestamp());
        this.store.put(this.bytesKey, this.valueAndTimestamp, this.context.timestamp());
        ((WindowStore)Mockito.verify(this.inner, (VerificationMode)Mockito.times((int)2))).put((Object)this.bytesKey, (Object)this.valueAndTimestamp, 0L);
        ((ProcessorContextImpl)Mockito.verify((Object)this.context)).logChange(this.store.name(), key1, this.value, 42L, Position.emptyPosition());
        ((ProcessorContextImpl)Mockito.verify((Object)this.context)).logChange(this.store.name(), key2, this.value, 42L, Position.emptyPosition());
    }
}

